<cfcomponent extends="_transportes.consulta.cfc_contrato_transporte">
	<!--- 
	-- PROPSITO 
	-- Busca tipos de frete
	-- NOTAS EXPLICATIVAS
	-- GUTO 06/05/2006
	--->
	<cffunction name="get_tipo_frete" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select produto_id, descricao 
              from fiscal.v$produto t
	 		 where t.conhecimento = 1
		</cfquery>
	<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca Regras fiscais do Cliente
	-- Wagner //2006
	--->	
	<cffunction name="get_lote_regra_fiscal" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qr_lote" username="#session.usuario#" password="#session.senha#">
			select distinct lr.regra_fiscal_id, lr.descricao
		      from fiscal.v$regra_fiscal lr
			where ativa = 1
		</cfquery>
	<cfreturn qr_lote>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os dados da operacao
	-- CRISTOFER  24/11/2006
	--->		
	<cffunction name="get_solicitacao_carga_dados" access="remote" returntype="query" output="true">	
		<cfargument name="viagem_carga_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.operacao_id, o.descricao as operacao,
                   sc.valor_em as frete_em,
                   o.fracionado,
                   sc.cod_remetente cod_pessoa_remetente,
                   sc.cod_organograma
                from logistica.v$operacao o
                inner join logistica.v$solicitacao_carga sc
                        on sc.operacao_id = o.operacao_id
                inner join logistica.v$viagem_carga vc
                        on vc.solicitacao_carga_id = sc.solicitacao_carga_id
               where 1=1
                 and vc.viagem_carga_id = #arguments.viagem_carga_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca os dados do manifesto para 
	-- CRISTOFER  24/11/2006
	--->		
	<cffunction name="get_manifesto_ct" access="remote" returntype="query" output="true">
		<cfargument name="num_manifesto" required="no" default="">
		<cfargument name="cod_pessoa_filial" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.manifesto_id,
				   m.num_manifesto,
				   sum(c.peso) peso,
				   fiscal.pkg_fiscal.fnc_converte_peso(sum(c.peso),min(cod_unidade),'Ton') peso_ton,
				   sum(c.m3) m3,
				   sum(c.volume) volume,
				   min(cod_unidade) cod_unidade,
				   m.placa_tracao,
				   m.placa_reboque,
				   oper.pkg_veiculo.fnc_veiculo_proprietario(m.placa_tracao) as veiculo_proprietario, -- 1 - Frota, 2 - Agregado, 3 - Terceiro
				   case when exists (select 0
                                        from oper.v$contrato_transp_manifesto ct
                                       where ct.manifesto_id = m.manifesto_id) then 1
					    else 0
				   end vinculado_ct,
				   case when exists (select 0
				                       from oper.v$romaneio roo
	                                  inner join oper.v$contrato_transp ct
    	                                      on ct.num_romaneio = roo.num_romaneio
									  where roo.num_romaneio = c.num_romaneio
									    and ct.data_cancelamento is null) and m.roo_item_id is not null then 1
					    else 0
				   end vinculado_roo,
				   m.num_lote
			  from oper.v$manifesto m
			 inner join oper.v$manifesto_conhecimento mc
					 on mc.manifesto_id = m.manifesto_id
			 inner join fiscal.v$conhecimento c
					 on c.conhecimento_id = mc.conhecimento_id
			 where 1=1
			 <cfif len(trim(arguments.num_manifesto))>
			   and m.num_manifesto = #arguments.num_manifesto#
			 </cfif>
			 <cfif len(trim(arguments.cod_pessoa_filial))>
	           and m.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif>
			 group by m.manifesto_id, 
					  m.num_manifesto,
					  m.placa_tracao,
					  m.placa_reboque,
					  m.num_lote,
					  c.num_romaneio,
                      m.roo_item_id
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO  
	-- Busca os contratos de transporte
	-- ANDERSON - 14/07/2009 - ALTERADO
	--->		
	<cffunction name="get_contrato_transp" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="placa_controle" required="no" default="">
        <cfargument name="proprietario_cod_pessoa" required="no" default="">
        <cfargument name="num_formulario" required="no" default="">
        <cfargument name="lancto_id" required="no" default="">
        <cfargument name="cancelada" required="no" default="">
    	<cfargument name="tipo_contrato" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select /*+ FIRST_ROWS */
                   c.lancto_id,
                   c.num_romaneio,
                   c.num_formulario,
                   c.serie_formulario,
                   c.cod_modelo,
                   c.cod_pessoa_filial,
                   c.cod_departamento,
                   c.cod_setor,
                   c.cod_centro_custo,
                   to_char(c.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao,
                   c.peso,
                   c.volume,
                   c.m3,
                   c.frete_em,
                   c.cod_unidade,
                   c.tolerancia_falta,
                   c.valor_unitario,
                   c.valor_frete_bruto,
                   c.valor_frete_liquido,
                   to_number(replace(replace(cf.cf_pedagio, '.', ''), ',', '.')) as valor_pedagio,
                   to_number(replace(replace(cf.cf_adiant, '.', ''), ',', '.')) as valor_adiant,
                   cf_total_impostos as valor_total_impostos,
                   to_number(replace(replace(cf.cf_saldo_frete, '.', ''), ',', '.')) as valor_saldo_frete,
                   c.motorista_cod_pessoa,
                   cf.cf_motorista as motorista,
                   c.placa_controle,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_controle) as cod_veiculo_controle,
                   c.placa_referencia,
                   oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_referencia) as cod_veiculo_referencia,
                   c.proprietario_cod_pessoa,
                   cf.cf_proprietario as proprietario,
                   c.proprietario_endereco,
                   c.proprietario_municipio_id,
                   c.proprietario_nit,
                   cf.cf_origem as origem,
       			   cf.cf_destino as destino,
                   nvl((select least(nvl(min(c1.impresso), 1), c.impresso)
                          from oper.v$contrato_transp c1
                         where c1.lancto_id_pai = c.lancto_id), 1) as impresso,
                   c.observacao,
                   c.proprietario_municipio_id,
                   c.num_rpa,
                   to_char(c.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') as data_cancelamento,
                   c.usuario_cancelamento,
                   c.motivo_cancelamento,
                   c.tipo_contrato,
                   case
                      when c.tipo_contrato = 0 then 'TERCEIRO'
                      else 'AGREGADO'
                   end as tipo_contrato_desc,
                   c.parcela,
                   c.total_parcela,
                   c.valor_parcelamento,
                   c.lancto_id_pai,
                   c.user_insert,
                   c.date_insert,
                   c.user_update,
                   c.date_update,
                   c.site,
                   av.viagem_id,
                   (select min(ctc.conhecimento_id)
                     from oper.v$contrato_transp_conhecimento ctc
                    where ctc.lancto_id = c.lancto_id) as conhecimento_id
                   ,kss.pkg_organizacional.fnc_descricao_completa(c.organizacional_id) as organizacional
              from oper.v$contrato_transp c
             inner join oper.v$contrato_transp_form cf
                     on cf.documento_id = c.lancto_id
              left join oper.v$agreg_viagem av
                     on av.lancto_id = c.lancto_id
             where 1 = 1
               and c.lancto_id_pai is null
            <cfif Len(Trim(arguments.cod_pessoa_filial))>
               and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
            </cfif>
            <cfif Len(Trim(arguments.cod_centro_custo))>
               and c.cod_centro_custo = #arguments.cod_centro_custo#
            </cfif>
            <cfif Len(Trim(arguments.placa_controle))>
               and (c.placa_controle = '#arguments.placa_controle#' 
                    or oper.pkg_veiculo.fnc_get_cod_veiculo(c.placa_controle) = '#arguments.placa_controle#')
            </cfif>
            <cfif Len(Trim(arguments.proprietario_cod_pessoa))>
               and c.proprietario_cod_pessoa = #arguments.proprietario_cod_pessoa#
            </cfif>
			<cfif Len(Trim(arguments.num_formulario))>
               and c.num_formulario = #arguments.num_formulario#
            </cfif>
            <cfif Len(Trim(arguments.lancto_id))>
               and c.lancto_id = #arguments.lancto_id#
            </cfif>
            <cfif Len(Trim(arguments.cancelada))>
				<cfif arguments.cancelada eq 1>
                	and c.data_cancelamento is not null
                <cfelse>
                	and c.data_cancelamento is null
                </cfif>
            </cfif>
            <cfif Len(Trim(arguments.tipo_contrato))>
               and c.tipo_contrato = #arguments.tipo_contrato#
            </cfif>
			<cfif Len(Trim(arguments.data_inicial))>
               and trunc(c.data_emissao) >= '#arguments.data_inicial#'
            </cfif>
            <cfif Len(Trim(arguments.data_final))>
               and trunc(c.data_emissao) <= '#arguments.data_final#'
            </cfif>
             order by c.data_emissao
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

    
    <!--- 
    -- PROPSITO 
    -- Retorna os dados da Carta Frete a serem impressos
    -- ANDERSON 13/11/2009 - CRIADO
    --->		
    <cffunction name="get_contrato_transp_form" access="remote" returntype="query" output="true">
        <cfargument name="documento_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ctf.documento_id
                 , ctf.cf_numero
                 , ctf.cf_num_romaneio
                 , ctf.cf_origem
                 , ctf.cf_destino
                 , ctf.cf_data_emissao
                 , ctf.cf_emissao_data
                 , ctf.cf_filial_dados
                 , ctf.cf_documentos_origem
                 , ctf.cf_proprietario
                 , ctf.cf_prop_endereco
                 , ctf.cf_prop_cep
                 , ctf.cf_prop_municipio
                 , ctf.cf_prop_uf
                 , ctf.cf_prop_cnpj_cpf
                 , ctf.cf_prop_inscricao_estadual
                 , ctf.cf_prop_pis
                 , ctf.cf_motorista
                 , ctf.cf_mot_endereco
                 , ctf.cf_mot_municipio
                 , ctf.cf_mot_uf
                 , ctf.cf_mot_cpf
                 , ctf.cf_mot_rg_uf
                 , ctf.cf_mot_cnh
                 , ctf.cf_mot_cnh_validade
                 , ctf.cf_mot_cnh_completa
                 , ctf.cf_placa_tracao
                 , ctf.cf_placa_carreta
                 , ctf.cf_uf_tracao
                 , ctf.cf_uf_carreta
                 , ctf.cf_veiculo_marca
                 , ctf.cf_quantidade
                 , ctf.cf_valor_unitario
                 , ctf.cf_valor_servico
                 , ctf.cf_irrf
                 , ctf.cf_pedagio
                 , ctf.cf_outros_cred
                 , ctf.cf_sest_senat
                 , ctf.cf_total_impostos
                 , ctf.cf_outros_deb
                 , ctf.cf_valor_liquido
                 , ctf.cf_inss
                 , ctf.cf_adiant_extenso
                 , ctf.cf_adiant
                 , ctf.cf_adiant_pedagio
                 , ctf.cf_adiant_frete                 
                 , ctf.cf_saldo_frete_ext
                 , ctf.cf_saldo_frete
                 , ctf.cf_observacao
                 , ctf.cf_data_cancelamento
              from oper.v$contrato_transp_form ctf
             where ctf.documento_id = #arguments.documento_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o prximo nmero de formulrio para o organograma definido
    -- ANDERSON 27/11/2009 - CRIADO
    --->		
    <cffunction name="get_prox_num_formulario" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_filial" required="yes">
        <cfargument name="cod_departamento" required="yes">
        <cfargument name="cod_setor" required="yes">
        <cfargument name="cod_centro_custo" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select nvl(max(ct.num_formulario) + 1, 1) as prox_num_formulario
              from oper.v$contrato_transp ct
             where ct.cod_pessoa_filial = #arguments.cod_pessoa_filial#
               and ct.cod_departamento = #arguments.cod_departamento#
               and ct.cod_setor = #arguments.cod_setor#
               and ct.cod_centro_custo = #arguments.cod_centro_custo#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o prximo nmero de formulrio para o organograma definido dentro dos limites configurados
    -- ANDERSON 27/11/2009 - CRIADO
    --->		
    <cffunction name="get_prox_num_formulario_limite" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_filial" required="yes">
        <cfargument name="cod_departamento" required="yes">
        <cfargument name="cod_setor" required="yes">
        <cfargument name="cod_centro_custo" required="yes">
        <cfargument name="serie" required="no" default="">
        <cfargument name="cod_modelo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select nvl(max(ct.num_formulario) + 1, 1) as prox_num_formulario
              from oper.v$contrato_transp ct
             where ct.cod_pessoa_filial = #arguments.cod_pessoa_filial#
               and ct.cod_departamento = #arguments.cod_departamento#
               and ct.cod_setor = #arguments.cod_setor#
               and ct.cod_centro_custo = #arguments.cod_centro_custo#
               and ct.num_formulario > (select ms.num_inicial
                                         from fiscal.v$modelo_serie ms
                                        where ms.cod_pessoa = #arguments.cod_pessoa_filial#
                                          and ms.cod_departamento = #arguments.cod_departamento#
                                          and ms.cod_setor = #arguments.cod_setor#
                                          and ms.cod_centro_custo = #arguments.cod_centro_custo#
                                       <cfif Len(Trim(arguments.serie))>
                                          and ms.serie = '#arguments.serie#'
                                       </cfif>
                                       <cfif Len(Trim(arguments.serie))>
                                          and ms.cod_modelo = '#arguments.cod_modelo#'
                                       </cfif>
                                       )
               and ct.num_formulario < (select ms.num_final
                                         from fiscal.v$modelo_serie ms
                                        where ms.cod_pessoa = #arguments.cod_pessoa_filial#
                                          and ms.cod_departamento = #arguments.cod_departamento#
                                          and ms.cod_setor = #arguments.cod_setor#
                                          and ms.cod_centro_custo = #arguments.cod_centro_custo#
                                       <cfif Len(Trim(arguments.serie))>
                                          and ms.serie = '#arguments.serie#'
                                       </cfif>
                                       <cfif Len(Trim(arguments.cod_modelo))>
                                          and ms.cod_modelo = '#arguments.cod_modelo#'
                                       </cfif>
                                       )
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!--- 
    -- PROPSITO 
    -- Dados para a impresso do contrato
    -- GUTO 19/10/2012 - CRIADO
    --->		
    <cffunction name="get_contrato_transp_impressao_formulario" access="remote" returntype="query" output="true">
        <cfargument name="documento_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select ct.num_formulario as doc_contrato
                   , ct.observacao
                   , ct.lancto_id,
                   (select pe.municipio
                      from kss.v$pessoa_endereco pe
                     where pe.cod_pessoa = ct.cod_pessoa_filial
                       and pe.endereco_padrao = 1) as municipio_emissao,
                   to_char(ct.data_emissao, 'dd/mm/yyyy hh24:mi:ss') as data_emissao,
                   to_char(ct.data_emissao, 'dd')||' de '||to_char(ct.data_emissao, 'month')||' de '||to_char(ct.data_emissao, 'yyyy') as data_emissao_extenso,
                   (select p.razao_social from kss.v$pessoa p
                     where p.cod_pessoa = ct.cod_pessoa_filial) as emitente_razao_social,
                   
                   /*Endereco*/
                   initcap(pep.logradouro || ', ' ||pep.numero) as endereco_linha1,
                   initcap(pep.bairro)||' CEP: '||pep.cep as endereco_linha2,                   
                   initcap(pep.municipio) || ' - ' || pep.uf || decode(ptp.telefone,null,'',' Tel.'||ptp.telefone) as endereco_linha3,
                   
                   /*transportador*/
                   ctf.cf_proprietario as transportador_nome,
                   ctf.cf_prop_endereco transportador_endereco,
                   ctf.cf_prop_municipio as transportador_municipio,
                   ctf.cf_prop_uf as transportador_uf,
                   ctf.cf_prop_telefone as transportador_telefone,
                   ctf.cf_prop_cnpj_cpf as transportador_cnpj,
                   
                   /*motorista*/
                   ctf.cf_motorista as motorista_nome,
                   ctf.cf_mot_endereco as motorista_endereco,
                   ctf.cf_mot_municipio as motorista_municipio,
                   ctf.cf_mot_uf as motorista_uf,
                   (select telefone from kss.v$pessoa_telefone_padrao mt
                     where mt.cod_pessoa = ct.motorista_cod_pessoa) as motorista_telefone,
                   ctf.cf_mot_cpf as motorista_cnpj,
                   ctf.cf_mot_cnh as motorista_cnh, 
                   
                   --veiculo tracionador
                   ctf.cf_placa_tracao as placa_tracao,
                   (select cor_predominante from oper.v$veiculo v
                     where v.placa = ct.placa_controle) as tracao_cor,
                   (select ano from oper.v$veiculo v
                     where v.placa = ct.placa_controle) as tracao_ano,
                   (select chassis from oper.v$veiculo v
                   where v.placa = ct.placa_controle) as tracao_chassis,
                   (select renavan from oper.v$veiculo v
                     where v.placa = ct.placa_controle) as tracao_renavam,
                   (select vm2.marca|| ' ' || vm.modelo from oper.v$veiculo v
                         inner join oper.v$veiculo_modelo vm
                                 on vm.modelo_id = v.modelo_id
                         inner join oper.v$veiculo_marca vm2
                                 on vm2.marca_id = v.marca_id
                              where v.placa = ct.placa_controle) as tracao_modelo,
                     
                   ct.usuario_cancelamento,
                     
                   --veiculos tracionados
                   case
                       when ct.placa_controle <> ct.placa_referencia then ct.placa_referencia
                   end  as tracionado_placa,
                   case
                       when ct.placa_controle <> ct.placa_referencia then
                            (select v.cor_predominante from oper.v$veiculo v
                              where v.placa = ct.placa_referencia)
                   end  as tracionado_cor,
                   case
                       when ct.placa_controle <> ct.placa_referencia then
                            (select v.ano from oper.v$veiculo v
                              where v.placa = ct.placa_referencia)
                   end  as tracionado_ano,
                   case
                       when ct.placa_controle <> ct.placa_referencia then
                            (select v.chassis from oper.v$veiculo v
                              where v.placa = ct.placa_referencia)
                   end  as tracionado_chassis,
                   case
                       when ct.placa_controle <> ct.placa_referencia then
                            (select v.renavan from oper.v$veiculo v
                              where v.placa = ct.placa_referencia)
                   end  as tracionado_renavam,
                   
                   --coleta / entrega
                   ctf.cf_origem  as coleta_municipio,
                   ctf.cf_destino as entrega_municipio,
                   
                   --dados do frete
                   nvl2(ct.valor_frete_bruto, to_char(ct.valor_frete_bruto,'FM9G9999G990D00','nls_numeric_characters=,.'), '0,00')as frete_bruto,
                   nvl2(ctf.cf_pedagio,ctf.cf_pedagio,'0,00')as frete_pedagio,
                   nvl2(ctf.CF_IRRF,ctf.CF_IRRF,'0,00') as frete_irrf,
                   nvl2(ctf.CF_INSS,ctf.CF_INSS,'0,00') as frete_inss,
                   nvl2(ctf.CF_SEST_SENAT,ctf.CF_SEST_SENAT,'0,00') as frete_sest_senat,
                   nvl2(ctf.CF_VALOR_LIQUIDO ,ctf.CF_VALOR_LIQUIDO,'0,00') as frete_liquido,
                   nvl2(ctf.CF_ADIANT,ctf.CF_ADIANT,'0,00') as frete_adiantamento,
                   nvl2(ctf.CF_SALDO_FRETE,ctf.CF_SALDO_FRETE,'0,00') as frete_saldo,
                   fiscal.pkg_conhecimento.fnc_notas_fiscais_ctrc(c.conhecimento_id) as notas_fiscais
                   -- Logo e endereo da filial
                  , (select pl.logotipo
                      from kss.v$pessoa_logotipo pl
                     where pl.cod_pessoa = 1
                    ) as logo
                  , (select p.razao_social
                      from kss.v$pessoa p
                     where p.cod_pessoa = 1
                     ) as razao_social_filial                
              from oper.v$contrato_transp ct
             inner join oper.v$contrato_transp_form ctf
                     on ctf.documento_id = ct.lancto_id
             inner join kss.v$unidade_negocio un
                     on un.cod_pessoa = ct.cod_pessoa_filial
             inner join kss.v$pessoa_endereco_padrao pep
                on pep.cod_pessoa = ct.cod_pessoa_filial
              left join kss.v$pessoa_telefone_completo ptp
                on ptp.cod_pessoa = ct.cod_pessoa_filial
              left join fiscal.v$unidade_medida und
                     on und.cod_unidade = ct.cod_unidade
              left join fiscal.v$conhecimento c
                     on ct.num_romaneio = c.num_romaneio
                    and c.cancelado is null
              left join cep.municipio mcol
                     on mcol.municipio_id = c.coleta_municipio_id
              left join cep.municipio ment
                     on ment.municipio_id = c.entrega_municipio_id
              where 1 = 1
                and ctf.documento_id = #arguments.documento_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    

    <!--- 
	-- PROPSITO 
	-- Busca o setor
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER  03/01/2006
	--->	
	<cffunction name="get_nf_contrato" displayname="Busca o organograma" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_id" 		required="no" default="">
		<cfargument name="num_nota_fiscal" required="no" default="">
        <cfargument name="lancto_id" required="no" default="">
        <cfargument name="sem_contrato" required="no" default="1">
		<cfquery datasource="#session.dsn#" name="qr_dados" username="#session.usuario#" password="#session.senha#">
			select  nf.num_nota_id
            	  , nf.num_nota_fiscal                  
                  , nf.serie
                  , to_char(nf.data_emissao,'dd/mm/yyyy hh24:mi') as data_emissao
                  ,  (select ri.viagem_carga_id
                        from oper.v$romaneio_item ri
                       where ri.num_romaneio = nef.num_romaneio
                         and ri.item_id = nef.item_id) as viagem_carga_id
              from fiscal.v$nf_es_frete nef
             inner join fiscal.v$nf_es nf
                on nf.num_nota_id = nef.nf_es_id      
            <cfif len(trim(arguments.num_nota_id))>
			  and nf.num_nota_id = '#arguments.num_nota_id#'
			</cfif>
            <cfif len(trim(arguments.num_nota_fiscal))>
			  and nf.num_nota_fiscal = '#arguments.num_nota_fiscal#'
			</cfif>
            <cfif len(trim(arguments.num_romaneio)) >
              and nef.num_romaneio = '#arguments.num_romaneio#'
            </cfif>
            <cfif len(trim(arguments.sem_contrato)) and arguments.sem_contrato eq 1 >
              and not exists (select ctn.num_nota_id
                                from oper.v$contrato_transp_nf ctn
                               inner join oper.v$contrato_transp ct
                                  on ct.lancto_id = ctn.lancto_id
                                 and ct.data_cancelamento is null
                               where ctn.num_nota_id = nf.num_nota_id)
            </cfif>
            order by num_nota_fiscal
		</cfquery>
		<cfreturn qr_dados>
	</cffunction>

    <!--- 
	-- PROPSITO 
	-- Busca os N de CF emitidas para o romaneio
	-- RAFAEL 02/06/2010
	--->		
	<cffunction name="get_num_cf_romaneio" access="remote" returntype="query" output="true">	
		<cfargument name="num_romaneio" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select count(ct.lancto_id) as total_cf
              from oper.v$contrato_transp ct
             where ct.num_romaneio = #arguments.num_romaneio#
               and ct.data_cancelamento is null
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>    
</cfcomponent>
