<cfcomponent extends="rodomar._componentes.consulta.cfc_pneus">
	<!--- 
	-- PROPSITO 
	-- Busca km atual do veculo
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/10/2006
	--->
	<cffunction name="get_km_atual" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="data" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_pneu.fnc_km_data(oper.pkg_veiculo.fnc_get_placa('#arguments.placa#'),'#arguments.DATA#') as km_atual
			  from dual
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
 <!--- 
	-- PROPSITO 
	-- Busca as inspees de um pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 08/02/2006
	--->
	<cffunction name="get_pneu_inspecoes" returntype="query" access="remote">
		<cfargument name="pneu_id" required="yes">
        <cfargument name="num_inspecao" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_inspecoes" username="#session.usuario#" password="#session.senha#">
			select pi.num_inspecao, p.num_pneu, pi.placa, oper.fnc_get_cod_veiculo(pi.placa) as cod_veiculo, pi.posicao, pi.data_ult_inspecao, pi.km_ult_inspecao, pi.mm_ult_inspecao, pi.data_inspecao, 
				   pi.km_inspecao, pi.mm_inspecao, pi.medida_1, pi.medida_2, pi.medida_3, pi.movimentacao,
				   pa.descricao as laudo, pi.pressao_encontrada, pi.user_insert,
                   nvl(round(oper.pkg_pneu.fnc_sulco_atual_estimado(pi.pneu_id),1),0) as sulco_atual,
                   nvl(pm.mm_montagem,0) as mm_montagem,
                   oper.pkg_global.fnc_get_parametro(1,'PNEU')/100 as tolerancia,p.pneu_id,
                   pi.medida_1,pi.medida_2,pi.medida_3,pi.pressao_encontrada
			  from oper.v$pneu_dados p
			 inner join oper.v$pneu_inspecao pi
					 on pi.pneu_id = p.pneu_id
			 left join oper.v$pneu_laudo_analise pa
					 on pa.laudo_id = pi.laudo_analise_id      
             inner join oper.v$pneu_movimentacao pm 
							 on pm.pneu_id = p.pneu_id  
			where 1=1
			<cfif IsDefined("arguments.PNEU_ID")>
				and pi.pneu_id = #arguments.PNEU_ID#
			</cfif>
            <cfif len(trim(arguments.num_inspecao))>
            	and pi.num_inspecao = #arguments.num_inspecao#
            </cfif>            
			order by pi.data_inspecao
		</cfquery>
		<cfreturn qr_inspecoes>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca o rendimento sintetico
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_rendimento_sintetico" returntype="query" access="remote">
		<cfargument name="reformas" required="no">
		<cfargument name="tipo_veiculo_id" required="no">
		<cfargument name="perc_consumido" required="no">
		<cfargument name="considera_peso" required="no">
		<cfquery datasource="#session.dsn#" name="qr_rendimento" username="#session.usuario#" password="#session.senha#">
			select a.marca_borracha || '-' || medida as marca_borracha,  
				   <cfif IsDefined("arguments.considera_peso") and arguments.considera_peso eq 1>
					   round(decode(a.peso_tracionado,1,a.rendimento, a.rendimento * (a.peso_tracionado/b.max_peso))) as rendimento,
				   <cfelse>
					   a.rendimento,
				   </cfif>
				   a.peso_tracionado,b.max_peso, mm_consumido,
                   case 
                    when eixo = '1' then 1
                    when eixo = '2' then 2
                    when eixo = '3' then 3
                    when eixo = 'SR1' then 4
                    when eixo = 'SR2' then 5 
                    when eixo = 'SR3' then 6
                   end ordem,
                   case 
                    when eixo = '1' then 'CV - eixo Dianteiro'
                    when eixo = '2' then 'CV - eixo Tracao'
                    when eixo = '3' then 'CV - eixo Truck'
                    when eixo = 'SR1' then 'SR - Primeiro eixo'
                    when eixo = 'SR2' then 'SR - Segundo eixo'
                    when eixo = 'SR3' then 'SR - Terceiro eixo'
                   end eixo  			   
			  from (select eixo, marca_borracha, medida, round(km_percorrido/mm_consumido) as rendimento, 
						   round(decode(eixo,'2',peso_tracionado,1)) as peso_tracionado, mm_consumido
					  from (select eixo,  decode(r.reformas, 0, marca, borracha) as marca_borracha,r.medida,
								   sum(mm_consumido) as mm_consumido, sum(km_percorrido) as km_percorrido,
								   avg(peso_tracionado) as peso_tracionado
									  from oper.v$pneu_rendimento r
								 where 1=1
								  <cfif IsDefined("arguments.reformas") and Len(Trim(arguments.reformas))>
									  and reformas in (#arguments.reformas#)
								  </cfif>
								  <cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
									  and tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
								  </cfif>
								  <cfif IsDefined("arguments.perc_consumido") and Len(Trim(arguments.perc_consumido))>
								     and r.perc_consumido >= #arguments.perc_consumido#
								  </cfif>
									 group by eixo, decode(r.reformas, 0,  marca, borracha), r.medida
									 order by eixo,  decode(r.reformas, 0,marca, borracha)
								 )) a,
					(select max(round(decode(eixo,'2',peso_tracionado,1))) as max_peso
					  from (select eixo, decode(r.reformas, 0, marca || ' / ' || modelo, borracha) as marca_borracha,r.medida,	
								   sum(mm_consumido) as mm_consumido, sum(km_percorrido) as km_percorrido,
								   avg(peso_tracionado) as peso_tracionado
							  from oper.v$pneu_rendimento r
								 where 1=1
								  <cfif IsDefined("arguments.reformas") and Len(Trim(arguments.reformas))>
									  and reformas in (#arguments.reformas#)
								  </cfif>
								  <cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
									  and tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
								  </cfif>
									 group by eixo, decode(r.reformas, 0, marca || ' / ' || modelo, borracha), r.medida
									 order by eixo, decode(r.reformas, 0, marca || ' / ' || modelo, borracha)
								 )) b
				where a.mm_consumido > 50
				  order by ordem 
		</cfquery>			
		<cfreturn qr_rendimento>				 
	</cffunction>	

	<!--- 
	-- PROPSITO 
	-- Busca o rendimento sintetico parcial
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_rendimento_sintetico_parcial" returntype="query" access="remote">
		<cfargument name="reformas" required="no">
		<cfargument name="tipo_veiculo_id" required="no">
		<cfargument name="considera_peso" required="no">
		<cfargument name="mm_ate" required="yes">
		<cfargument name="perc_consumido" required="no">
		<cfquery datasource="#session.dsn#" name="qr_rendimento" username="#session.usuario#" password="#session.senha#">
		  <cfif IsDefined("arguments.reformas") and ((ListLen(arguments.reformas) gte 1 and ListFind(arguments.reformas,'0')) or not Len(Trim(arguments.reformas)))>
				select marca || '-' || medida as marca_borracha,  max_peso, peso_tracionado,
						   case 
							  when eixo = '1' then 1
							  when eixo = '2' then 2
							  when eixo = '3' then 3
							  when eixo = 'SR1' then 4
							  when eixo = 'SR2' then 5 
							  when eixo = 'SR3' then 6
						   end ordem,
						   case 
							  when eixo = '1' then 'eixo Dianteiro'
							  when eixo = '2' then 'eixo Tracao'
							  when eixo = '3' then 'eixo Truck'
							  when eixo = 'SR1' then 'Primeiro eixo'
							  when eixo = 'SR2' then 'Segundo eixo'
							  when eixo = 'SR3' then 'Terceiro eixo'
						   end eixo, 
						   <cfif IsDefined("arguments.considera_peso") and arguments.considera_peso eq 1>
							   round(decode(peso_tracionado,1,round(km / decode(mm,0,1,mm)), round(km / decode(mm,0,1,mm)) * (peso_tracionado/max_peso))) as rendimento,
						   <cfelse>
							   round(km / decode(mm,0,1,mm)) as rendimento,
						   </cfif>
					   mm as mm_consumido
				  from (select max_peso, peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, marca, modelo, data_inspecao,
							   mm, mm_proximo, km, reformas, eixo, 
							   row_number() over (partition by marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, reformas order by data_inspecao, km) rank
						  from (select max_peso, peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, marca, modelo, data_inspecao, reformas, eixo,
									   mm, mm_proximo, km,
									   last_value(mm) over (partition by marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, reformas) maior
								 from (select max(round(decode(eixo,'2',peso_tracionado,1))) over() as max_peso, round(decode(eixo,'2',peso_tracionado,1)) as peso_tracionado, marca_id, modelo_id, 
                                              medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, r.marca, r.modelo, r.data_inspecao, reformas, eixo,
											  sum(r.mm_consumido) 
												  over (partition by r.marca_id, r.modelo_id, r.medida, tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc 
														rows unbounded preceding ) mm,
											  sum(r.mm_consumido) 
												  over (partition by r.marca_id, r.modelo_id, r.medida,tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc 
														rows between unbounded preceding and 1 following) mm_proximo,
											  sum(r.km_percorrido) 
												  over (partition by r.marca_id, r.modelo_id, r.medida, tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc rows unbounded preceding) km
										 from oper.v$pneu_rendimento r
										where reformas = 0
										<cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
										  and tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
										</cfif>                         
										<cfif IsDefined("arguments.perc_consumido") and Len(Trim(arguments.perc_consumido))>
											 and r.perc_consumido >= #arguments.perc_consumido#
										</cfif>
										 ))
						 where #arguments.mm_ate# between mm and mm_proximo
							or maior < #arguments.mm_ate#) 
				   where rank =1 
				     and mm > 50
			   <cfif IsDefined("arguments.reformas") and (ListLen(arguments.reformas) gt 1 or not Len(Trim(arguments.reformas)))>
				   union 
			   </cfif>
			</cfif>
		   
		   <cfif IsDefined("arguments.reformas") and (ListLen(arguments.reformas) gt 1 or not Len(Trim(arguments.reformas)))>

				select marca || '-' || medida as marca_borracha,  max_peso, peso_tracionado,
						   case 
							  when eixo = '1' then 1
							  when eixo = '2' then 2
							  when eixo = '3' then 3
							  when eixo = 'SR1' then 4
							  when eixo = 'SR2' then 5 
							  when eixo = 'SR3' then 6
						   end ordem,
						   case 
							  when eixo = '1' then 'eixo Dianteiro'
							  when eixo = '2' then 'eixo Tracao'
							  when eixo = '3' then 'eixo Truck'
							  when eixo = 'SR1' then 'Primeiro eixo'
							  when eixo = 'SR2' then 'Segundo eixo'
							  when eixo = 'SR3' then 'Terceiro eixo'
						   end eixo, 
						   <cfif IsDefined("arguments.considera_peso") and arguments.considera_peso eq 1>
							   round(decode(peso_tracionado,1,round(km / decode(mm,0,1,mm)), round(km / decode(mm,0,1,mm)) * (peso_tracionado/max_peso))) as rendimento,
						   <cfelse>
							   round(km / decode(mm,0,1,mm)) as rendimento,
						   </cfif>
					   mm as mm_consumido
				  from (select max_peso, peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, marca, modelo, data_inspecao,
							   mm, mm_proximo, km, reformas, eixo, 
							   row_number() over (partition by marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, reformas order by data_inspecao, km) rank
						  from (select max_peso, peso_tracionado, marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, marca, modelo, data_inspecao, reformas, eixo,
									   mm, mm_proximo, km,
									   last_value(mm) over (partition by marca_id, modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, reformas) maior
								 from (select max(round(decode(eixo,'2',peso_tracionado,1))) over() as max_peso, round(decode(eixo,'2',peso_tracionado,1)) as peso_tracionado, 
								 			  borracha_id as marca_id, desenho_id as modelo_id, medida, tipo_veiculo_id, modelo_eixo_id, num_eixo, 
											  r.borracha as marca, r.desenho as modelo, r.data_inspecao, reformas, eixo,
											  sum(r.mm_consumido) 
												  over (partition by r.borracha_id, r.desenho_id, r.medida, tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc 
														rows unbounded preceding ) mm,
											  sum(r.mm_consumido) 
												  over (partition by r.borracha_id, r.desenho_id, r.medida,tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc 
														rows between unbounded preceding and 1 following) mm_proximo,
											  sum(r.km_percorrido) 
												  over (partition by r.borracha_id, r.desenho_id, r.medida, tipo_veiculo_id, r.modelo_eixo_id, r.num_eixo, r.reformas order by r.data_inspecao desc rows unbounded preceding) km
										 from oper.v$pneu_rendimento r
										where 1=1
										<cfif Len(Trim(arguments.reformas))>
										  and reformas in (#arguments.reformas#)
										<cfelse>  
										  and reformas > 0
										</cfif>
										<cfif IsDefined("arguments.tipo_veiculo_id") and Len(Trim(arguments.tipo_veiculo_id))>
										   and tipo_veiculo_id in (#arguments.tipo_veiculo_id#)
										</cfif>   
										<cfif IsDefined("arguments.perc_consumido") and Len(Trim(arguments.perc_consumido))>
											 and r.perc_consumido >= #arguments.perc_consumido#
										</cfif>										                      
										 ))
						 where #arguments.mm_ate# between mm and mm_proximo
							or maior < #arguments.mm_ate#) 
				   where rank =1 
				     and mm > 50				   
			  </cfif>
				  order by ordem, 1
		</cfquery>			
		<cfreturn qr_rendimento>				 
	</cffunction>


	<!--- 
	-- PROPSITO 
	-- Busca todos os pneus enviados para a reforma
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_pneus_enviados_reforma" returntype="query" access="remote">
		<cfargument name="conserto_id" required="no">
		<cfargument name="sem_ficha" required="no">
		<cfargument name="inclui_consertos" required="no">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS*/  pr.conserto_id, p.num_pneu, pr.pneu_id, pr.cod_pessoa_reformador, 
				   pj.cliente as nome_fantasia, pr.data_envio_reforma,
				   p.marca, p.modelo, p.reformas, p.medida, p.medida_roda,
				   bo.descricao as borracha, de.descricao as desenho, pr.user_insert as usuario,
				   decode(pr.conserto,1,'Conserto','Reforma') as tipo
			  from oper.v$pneu_reforma pr
			 inner join oper.v$pneu_dados p 
					 on p.pneu_id = pr.pneu_id
			 inner join oper.v$pessoa pj
					 on pj.cod_pessoa = pr.cod_pessoa_reformador
			 inner join oper.v$pneu_localizacao_atual pl
					 on pl.pneu_id = pr.pneu_id
					and pl.data_saida is null
			 left join	oper.v$pneu_borracha bo
			         on bo.borracha_id = pr.borracha_id
		     left join oper.v$pneu_desenho de
			         on de.borracha_id = pr.borracha_id
					and de.desenho_id = pr.desenho_id
			 where pr.data_retorno_reforma is null      
			   <cfif not IsDefined("arguments.inclui_consertos")>
				   and pr.conserto = 0
			   </cfif>
			   <cfif IsDefined("arguments.conserto_id")>
				   and pr.conserto_id = #arguments.conserto_id#
			   </cfif>
			   <cfif IsDefined("arguments.sem_ficha")>
				   and num_relacao is null
			   </cfif>
			   order by p.num_pneu
   		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca todos os pneus enviados para conserto
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_pneus_enviados_conserto" returntype="query" access="remote">
		<cfargument name="conserto_id" required="no" default="">
		<cfquery name="qrPneus"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ FIRST_ROWS*/  pr.conserto_id, p.num_pneu, pr.pneu_id, pr.cod_pessoa_reformador, 
				   pj.cliente as nome_fantasia, pr.data_envio_reforma,
				   p.marca, p.modelo, p.reformas, pr.user_insert as usuario,
          		   greatest(pi.medida_1, pi.medida_2, pi.medida_3) as medida_maxima
			  from oper.v$pneu_reforma pr
			 inner join oper.v$pneu_dados p 
					 on p.pneu_id = pr.pneu_id
			 inner join kss.v$pessoa pj
					 on pj.cod_pessoa = pr.cod_pessoa_reformador
			 inner join oper.v$pneu_localizacao_atual pl
					 on pl.pneu_id = pr.pneu_id
					and pl.data_saida is null
       		  left join oper.v$pneu_inspecao pi
					  on pi.pneu_id = pr.pneu_id
			 where pr.data_retorno_reforma is null         
			   and pr.conserto = 1
			   and pl.cod_pessoa = #session.cod_pessoa#
			   and (pi.data_inspecao = (select max(pi2.data_inspecao)
										   from oper.v$pneu_inspecao pi2
										  where pi2.pneu_id = pi.pneu_id)   
				    or pi.data_inspecao is null)
			   <cfif IsDefined("arguments.conserto_id") and Len(Trim(arguments.conserto_id))>
				   and pr.conserto_id = #arguments.conserto_id#
			   </cfif>
			   order by p.num_pneu
   		</cfquery>		
		<cfreturn qrPneus>
	</cffunction>    

	<!--- 
	-- PROPSITO 
	-- Monta busca fichas de envio 
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 10/02/2006
	--->	
	<cffunction name="get_fichas_reforma" returntype="query" access="remote">
		<cfargument name="num_relacao" required="no">
		<cfquery datasource="#session.dsn#" name="qr_pneus" username="#session.usuario#" password="#session.senha#">
            select /*+ FIRST_ROWS */  r.num_relacao, r.data_envio, pr.cod_pessoa_reformador, pj.cliente as reformador, pb.imagem,
                               oper.pkg_global.fnc_busca_nome_pessoa(u.cod_pessoa) as usuario,
                               pd.num_pneu, pd.marca, pd.modelo, d.descricao as desenho, pr.data_envio_reforma,
                               (select count(*)
                          from oper.v$pneu_reforma r2
                          where r2.num_relacao = r.num_relacao) as num_pneus,
                         (select kss.fnc_concat_all(kss.to_concat_expr(to_char(p.num_pneu), ' / ')) 
                            from oper.v$pneu_relacao_envio_reforma r2 
                            inner join oper.v$pneu_reforma pr2
                                    on pr2.num_relacao = r2.num_relacao
                            inner join oper.v$pneu p
                                    on p.pneu_id = pr2.pneu_id
                            where r2.num_relacao = r.num_relacao ) as pneus
                          from oper.v$pneu_relacao_envio_reforma r
                         inner join oper.v$pneu_reforma pr
                           on pr.num_relacao = r.num_relacao
                      and pr.cod_pessoa_reformador = r.cod_pessoa_reformador
                      and pr.data_retorno_reforma is null
                   inner join oper.v$pessoa pj
                           on pj.cod_pessoa = pr.cod_pessoa_reformador
                   inner join oper.v$pneu_dados pd
                       on pd.pneu_id = pr.pneu_id
                   inner join kss.kss_usuarios u
                       on u.usuario = pr.user_insert
                   left join oper.v$pneu_borracha pb
                       on pb.borracha_id = pr.borracha_id
                   left join oper.v$pneu_desenho d
                       on d.borracha_id = pr.borracha_id
                      and d.desenho_id = pr.desenho_id
   		        where 1=1
			  <cfif IsDefined("arguments.num_relacao")>
				  and r.num_relacao = #arguments.num_relacao#
			  </cfif>	 
			  order by num_relacao
		</cfquery>
		<cfreturn qr_pneus>
	</cffunction>	        

		<!--- 
	-- PROPSITO 
	-- Busca os reformadores
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 18/01/2006
	--->
	<cffunction name="get_reformadores" returntype="query" access="remote">
		<cfargument name="cod_pessoa_reformador" required="no">
		<cfargument name="borracha_id" required="no" default="">
		<cfargument name="sem_imagem" required="no" default="0">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select pj.cliente as nome_fantasia, 
				   prb.cod_pessoa_reformador, 
				   pb.borracha_id, 
				   pb.descricao as borracha
			  from oper.v$pneu_reformador_bandeira prb
			 inner join oper.v$pneu_borracha pb
					 on pb.borracha_id = prb.borracha_id
			 inner join kss.v$pessoa pj
					 on pj.cod_pessoa = prb.cod_pessoa_reformador
			 where 1=1
			   <cfif IsDefined("arguments.cod_pessoa_reformador")>
			   and prb.cod_pessoa_reformador = #arguments.cod_pessoa_reformador#
			   </cfif>
			   <cfif len(trim(arguments.borracha_id))>
			   and pb.borracha_id = #arguments.borracha_id#
			   </cfif>
			order by pj.cliente		 
 		</cfquery>		
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os pneus apartir de uma lista
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="get_pneus" returntype="query" access="remote">
		<cfargument name="lista_pneus" required="no">
		<cfargument name="lista_localizacao" required="no">
		<cfargument name="pneu_id" required="no">
		<cfargument name="num_pneu" required="no">
		<cfargument name="situacao_id" required="no">
		<cfargument name="transferencia" required="no">
		<cfargument name="varios" required="no" default="">	
		<cfquery name="qr_result"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.pneu_id, p.num_pneu, p.situacao_id, p.data_aquisicao,  p.custo, 
				   p.nota_fiscal_numero, p.nota_fiscal_serie, pj2.cnpj_cpf as cnpj_cpf, p.ano_fabricacao, p.marca_id, p.marca,
				   p.modelo_id, p.modelo, pb.descricao as borracha, pd.descricao as desenho, 
				   p.sulco, p.medida_id, p.medida, p.medida_roda_id,
				   p.medida_roda, p.reformas, decode(p.reformas,0,'Novo','Reforma ' || p.reformas) as status,
				   oper.pkg_pneu.fnc_valor_pneu(p.pneu_id) as valor_estimado,
				   p.situacao,p.situacao_id,p.formato_borracha,
				   pj.cliente as filial, pl.cod_pessoa,
				   pr.data_retorno_reforma,
				   p.observacoes,
                   pj.cod_pessoa as cod_filial,
				   oper.pkg_pneu.fnc_km_rodado_pneu(p.pneu_id) as km_rodado_total,
				   (select count(*)
					  from oper.v$pneu_reforma
					 where pneu_id = p.pneu_id
					   and conserto = 1
					   and furo = 0) quant_reparos,
				   (select count(*)
					  from oper.v$pneu_reforma
					 where pneu_id = p.pneu_id
					   and conserto = 1
					   and furo = 1) quant_furos,
					oper.pkg_pneu.fnc_reforma_bloqueada(p.pneu_id) as reforma_bloqueada, 
					p.libera_reforma_manual,
					nvl(p.usuario_bloqueio,'Sistema') as usuario_bloqueio,
					oper.pkg_pneu.fnc_sulco_atual_estimado(p.pneu_id) as sulco_estimado,
					oper.pkg_pneu.fnc_sulco_atual(p.pneu_id) as sulco_atual,
					nvl((select pm.placa
					  from oper.v$pneu_movimentacao pm
					 where pm.pneu_id = p.pneu_id
					   and pm.data_desmontagem is null),'Desmontado') as montado_em,
					 pj2.razao_social as proprietario, 
					 (select cliente
					    from oper.v$pessoa pj
					   where pj.cod_pessoa = pr.cod_pessoa_reformador) as reformador,
					 (select nvl(sum(custo),0)
						 from oper.v$pneu_reforma pc
					    where pc.pneu_id = p.pneu_id
						  and pc.conserto = 1
						  and pc.cod_pessoa_reformador = 1) as conserto_estrada,
					  (select nvl(sum(custo),0)
						 from oper.v$pneu_reforma pc
					    where pc.pneu_id = p.pneu_id
						  and pc.conserto = 1
						  and pc.cod_pessoa_reformador <> 1) as outros_consertos					 			
			  from oper.v$pneu_dados p
			 left join oper.v$pneu_localizacao_atual pl 
			         on pl.pneu_id = p.pneu_id
	         left join oper.v$pessoa pj
                    on pj.cod_pessoa = pl.cod_pessoa
	         left join oper.v$pneu_proprietario pp
                    on p.pneu_id = pp.pneu_id
				   and pp.data_fim is null
			 left join oper.v$pessoa pj2
	 			    on pj2.cod_pessoa = pp.cod_pessoa
			 left join oper.v$pneu_reforma pr
			        on pr.pneu_id = p.pneu_id
				   and pr.conserto = 0
			left join oper.v$pneu_borracha pb
					on pb.borracha_id = pr.borracha_id
			left join oper.v$pneu_desenho pd
					on pd.borracha_id = pr.borracha_id
				   and pd.desenho_id = pr.desenho_id													 
			 where 1=1
			 and (pr.data_retorno_reforma is null or pr.data_envio_reforma = (select max(pr2.data_envio_reforma)
                                         from oper.v$pneu_reforma pr2
                                        where pr2.pneu_id = pr.pneu_id
                                         and pr2.conserto = 0))
			 <cfif IsDefined("arguments.lista_pneus") and Len(Trim(arguments.lista_pneus))>
			   and p.pneu_id in (#arguments.lista_pneus#)
			 </cfif>  			 
			 <cfif ((Len(trim(arguments.varios))) and (IsDefined("arguments.pneu_id") and Len(Trim(arguments.pneu_id))))>
			   	and p.pneu_id in (#arguments.pneu_id#)
			 <cfelse>
			 		<cfif IsDefined("arguments.pneu_id") and Len(Trim(arguments.pneu_id))>
			   			and p.pneu_id = #arguments.pneu_id#
			 		</cfif>
			 </cfif>
			 <cfif IsDefined("arguments.num_pneu") and Len(Trim(arguments.num_pneu))>
			   and p.num_pneu = #arguments.num_pneu#
			 </cfif>  
			 <cfif IsDefined("arguments.lista_localizacao") and Len(Trim(arguments.lista_localizacao))>
			   and pl.localizacao_id in (#arguments.lista_localizacao#)
			 </cfif>
			 <cfif IsDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id))>
			   and p.situacao_id = #arguments.situacao_id#
			   <cfif arguments.situacao_id eq 6>
               and exists (select 1 from oper.v$pneu_sucateamento ps where ps.pneu_id = p.pneu_id)
               </cfif>               
			 </cfif>
			 order by p.num_pneu		 
   		</cfquery>		
		<cfreturn qr_result>
	</cffunction>    

	<!--- 
	-- PROPSITO 
	-- Busca as reformas de um pneu
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 08/02/2006
	--->
	<cffunction name="get_pneu_reformas" returntype="query" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_inspecoes" username="#session.usuario#" password="#session.senha#">
			select /*+ ORDERED */ pr.custo, pr.conserto_id, pd.num_pneu, pd.pneu_id, pr.data_envio_reforma, pr.data_retorno_reforma, pb.descricao as borracha,
				   pr.desenho_id, d.descricao as desenho, pr.borracha_id, pj.cliente as nome_fantasia
			  from oper.v$pneu_dados pd
			 inner join oper.v$pneu_reforma pr
					 on pr.pneu_id = pd.pneu_id
					and pr.conserto = 0
			 inner join oper.v$pneu_borracha pb
					 on pb.borracha_id = pr.borracha_id
			 inner join oper.v$pneu_desenho d
					 on d.borracha_id = pr.borracha_id
					and d.desenho_id = pr.desenho_id        
			 inner join kss.v$pessoa pj
					 on pj.cod_pessoa = pr.cod_pessoa_reformador         
			<cfif IsDefined("arguments.PNEU_ID")>
				 where pd.pneu_id = #arguments.pneu_id#          
			</cfif>
			order by pr.data_envio_reforma
		</cfquery>
		<cfreturn qr_inspecoes>
	</cffunction>    
	<!--- 
	-- PROPSITO 
	-- Busca os dados para a troca dos pneus
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 24/01/2006
	--->
	<cffunction name="get_dados_pneu_troca" returntype="query" access="remote">
		<cfargument name="pneu_id" required="yes">
		<cfquery name="qrPneu"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select /*+ ORDERED */ pneu_id, num_pneu, num_gabarito, num_eixo ,marca_id, mm_montagem, data_montagem, pmov_id, 
				   modelo_id, reformas, borracha_id, desenho_id, medida_roda_id, marca, modelo, desenho, borracha,
				   medida, medida_roda, placa, data_montagem, km_montagem, suspenso, geminado, cod_posicao, parceiro,
				   null as parc_num_pneu, null as parc_data_inspecao, null as parc_mm_inspecao, null as parc_mm_estimado,
				   0 as dias_ult_inspecao, posicao,
				   case 
				      when trunc(sysdate - oper.pkg_pneu.fnc_ultima_inspecao(pneu_id)) >= 2 then mm_montagem
					  when trunc(sysdate - oper.pkg_pneu.fnc_ultima_inspecao(pneu_id)) < 2 then oper.pkg_pneu.fnc_sulco_atual(pneu_id)
				   end sulco_parametro, medida_id, tempo_montagem
 			  from (select pm.pneu_id, pd.num_pneu, pm.mm_montagem, pm.posicao, pm.pmov_id, 
						   pm.num_gabarito, pm.num_eixo, pd.marca_id, pd.modelo_id, pd.reformas, 
						   pr.borracha_id, pr.desenho_id, pd.medida_roda_id, pd.medida_id,
						   pd.marca, pd.modelo, d.descricao as desenho, pb.descricao as borracha, 
						   pd.medida, pd.medida_roda, pm.placa, to_char(pm.data_montagem,'dd/mm/yyyy hh24:mi') as data_montagem, pm.km_montagem, 
                           round(sysdate - pm.data_montagem)*24 as tempo_montagem,
						   pvp.suspenso, pvp.geminado, pvp.cod_posicao,
						   oper.pkg_pneu.fnc_pneu_geminado(pm.pneu_id) as parceiro
					  from oper.v$pneu_dados pd
					 inner join oper.v$pneu_movimentacao pm
								 on pm.pneu_id = pd.pneu_id 
					 inner join oper.v$pneu_veiculo_posicao pvp
								 on pvp.placa = pm.placa
								--and pvp.num_gabarito = pm.num_gabarito
								and pvp.num_eixo = pm.num_eixo
								and pvp.posicao = pm.posicao
    				  left join oper.v$pneu_reforma pr
						     on pr.pneu_id = pd.pneu_id
					  left join oper.v$pneu_borracha pb
							 on pb.borracha_id = pr.borracha_id
					  left join oper.v$pneu_desenho d
							 on d.borracha_id = pr.borracha_id
						    and d.desenho_id = pr.desenho_id												  
					where pd.pneu_id = #arguments.pneu_id#
					  and pm.data_desmontagem is null
					  and (pr.data_retorno_reforma = (select max(r2.data_retorno_reforma)
													 from oper.v$pneu_reforma r2
													where r2.pneu_id = pr.pneu_id
													  and r2.data_retorno_reforma is not null
													  and r2.conserto = 0)
						   or (select max(r2.data_retorno_reforma)
													 from oper.v$pneu_reforma r2
													where r2.pneu_id = pr.pneu_id
													  and r2.data_retorno_reforma is not null
													  and r2.conserto = 0) is null)
					  ) 
   		</cfquery>		
		<cfif Len(Trim(qrPneu.parceiro)) >
			<cfquery name="qrPneuParceiro"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*+ FIRST_ROWS */ p.num_pneu as PARC_NUM_PNEU, 
					   decode(p.rendimento,0,-1, round(nvl(mm_inspecao, p.mm_montagem) - (p.km_rodado/p.rendimento),1)) as PARC_MM_ESTIMADO, 
					   data_inspecao as PARC_DATA_INSPECAO, 
					   mm_inspecao as PARC_MM_INSPECAO, parceiro,
					   num_gabarito, num_eixo ,marca_id, 
					   #qrPneu.mm_montagem# as mm_montagem,
					   modelo_id, reformas, borracha_id, desenho_id, medida_roda_id, marca, modelo, desenho, borracha,
					   medida, medida_roda, placa, data_montagem as data_montagem_parceiro,  km_montagem, suspenso, geminado, cod_posicao, 
					   #qrPneu.num_pneu# as num_pneu,
					   dias_ult_inspecao, '#qrPneu.posicao#' as posicao, sulco, to_date('#LSDateFormat(qrPneu.DATA_MONTAGEM)#','dd/mm/yyyy') as data_montagem,
					   '#qrPneu.PMOV_ID#' as pmov_id, '#qrPneu.sulco_parametro#' as sulco_parametro, medida_id,
                       tempo_montagem
				  from (select pd.pneu_id, pd.num_pneu, pm.mm_montagem, 
							   oper.pkg_pneu.fnc_km_rodado(pm.placa, nvl(pi.data_inspecao,pm.data_montagem), pvp.suspenso) as km_rodado,
							   oper.pkg_pneu.fnc_rendimento_pneu(pm.pneu_id, pvp.modelo_eixo_id, pvp.num_eixo, pvp.tipo_veiculo) as rendimento,
							   pm.num_gabarito, pm.num_eixo, pd.marca_id, pd.modelo_id, pd.reformas, pr.borracha_id, pr.desenho_id, pd.medida_roda_id, 
							   pd.marca, pd.modelo, d.descricao as desenho, pb.descricao as borracha, pd.medida, pd.medida_roda,
							   pm.placa, to_char(pm.data_montagem,'dd/mm/yyyy hh24:mi') as data_montagem, pm.km_montagem, pvp.suspenso, pvp.geminado, pvp.cod_posicao,
							   oper.pkg_pneu.fnc_pneu_geminado(pm.pneu_id) as parceiro, 
							   nvl(pi.data_inspecao,pm.data_montagem) as data_inspecao, nvl(pi.mm_inspecao,pm.mm_montagem) as mm_inspecao, trunc(sysdate - pi.data_inspecao) as dias_ult_inspecao,
							   oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id) as sulco, pd.medida_id,
                               round(sysdate - pm.data_montagem)*24 as tempo_montagem
						  from oper.v$pneu_dados pd
						 inner join oper.v$pneu_movimentacao pm
									 on pm.pneu_id = pd.pneu_id 
						 inner join oper.v$pneu_veiculo_posicao pvp
									 on pvp.placa = pm.placa
									and pvp.num_gabarito = pm.num_gabarito
									and pvp.num_eixo = pm.num_eixo
									and pvp.posicao = pm.posicao
						 left join oper.v$pneu_inspecao pi
								 on pd.pneu_id = pi.pneu_id
						 left join oper.v$pneu_reforma pr
							    on pr.pneu_id = pd.pneu_id
						 left join oper.v$pneu_borracha pb
							 	on pb.borracha_id = pr.borracha_id
						 left join oper.v$pneu_desenho d
								on d.borracha_id = pr.borracha_id
							   and d.desenho_id = pr.desenho_id														 
						where pm.data_desmontagem is null
						  and pd.pneu_id = #qrPneu.parceiro#
						  and (pi.data_inspecao = (select max(pi2.data_inspecao)
												  from oper.v$pneu_inspecao pi2
												 where pi2.pneu_id = pi.pneu_id)
							   or pi.data_inspecao is null)
						  and (pr.data_retorno_reforma = (select max(r2.data_retorno_reforma)
															from oper.v$pneu_reforma r2
														   where r2.pneu_id = pr.pneu_id
															 and r2.data_retorno_reforma is not null
															 and r2.conserto = 0)
							   or (select max(r2.data_retorno_reforma)
															from oper.v$pneu_reforma r2
														   where r2.pneu_id = pr.pneu_id
															 and r2.data_retorno_reforma is not null
															 and r2.conserto = 0) is null)) p	
			</cfquery>			
			<cfreturn qrPneuParceiro>
		</cfif>		
		<cfreturn qrPneu>
	</cffunction>


	
	<!--- 
	-- PROPSITO 
	-- Busca todos os pneus cadastrados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 06/02/2006
	--->
	<cffunction name="get_relacao_pneus" returntype="query" access="remote">
		<cfargument name="sulco" required="no">
		<cfargument name="sulco_final" required="no">
		<cfargument name="situacao_id" required="no">
		<cfargument name="medida_id" required="no">
		<cfargument name="medida_roda_id" required="no">
		<cfargument name="modelo_id" required="no">
		<cfargument name="eixo" required="no">
		<cfargument name="cod_pessoa_filial" required="no">
		<cfargument name="operador" required="no">
		<cfargument name="reformas" required="no" default="">
		<cfargument name="borracha_id" required="yes">
		<cfargument name="desenho_id" required="yes">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="formato_borracha" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_desenhos" username="#session.usuario#" password="#session.senha#" timeout="300">
			select pneu_id,
				   num_pneu,
				   modelo_id,
				   decode(reformas, 0, 'Novo', 'Reforma ' || reformas) as reformas,
				   reformas as nro_reformas,
				   marca,
				   modelo,
				   medida,
				   medida_roda,
				   sulco,
				   oper.fnc_get_cod_veiculo(placa) as placa,
				   posicao,
				   borracha,
				   desenho,
				   filial,
				   cod_pessoa,
				   zero_km,
				   formato_borracha,
				   cliente,
       			   cod_pessoa_proprietario
				   
			  from (select /*+ USE_HASH(PVP R) */ r.pneu_id,
						   r.num_pneu,
						   r.modelo_id,
						   r.reformas,
						   r.marca,
						   r.modelo,
						   r.medida,
						   r.medida_roda,
						   r.medida_roda_id,
						   r.medida_id,
						   r.num_eixo,
						   r.num_gabarito,
						   r.sulco,
						   r.placa,
						   r.posicao,
						   r.borracha,
						   r.desenho,
						   r.filial,
						   r.situacao_id,
						   r.cod_pessoa,
						   r.borracha_id,
						   r.desenho_id,
						   r.zero_km,
						   pvp.prefixo as eixo,
						   formato_borracha,
						   r.cliente,
               			   r.cod_pessoa_proprietario
					  from oper.v$pneu_veiculo_posicao pvp 
					  right join (select pd.pneu_id,
								   pd.num_pneu,
								   pd.modelo_id,
								   pd.reformas,
								   pd.marca,
								   pd.modelo,
								   pd.medida,
								   pd.medida_roda,
								   pd.medida_roda_id,
								   pm.num_gabarito,
								   pm.num_eixo,
								   pd.medida_id,
								   case
									 when p.sulco < 0 then
									  0
									 when p.sulco is null then
									  oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id)
									 else
									  p.sulco
								   end sulco,
								   nvl(pm.placa, pm2.placa) as placa,
								   nvl(pm.posicao, pm2.posicao) as posicao,
								   null as borracha,
								   null as desenho,
								   (select cliente
									  from kss.v$pessoa
									 where cod_pessoa = pl.cod_pessoa) as filial,
								   pd.situacao_id,
								   pl.cod_pessoa,
								   null as borracha_id,
								   null as desenho_id,
								   case
									 when not exists (select 'x'
											 from oper.v$pneu_movimentacao pm4
											where pm4.pneu_id = pd.pneu_id) then
									  1
									 else
									  0
								   end as zero_km,
								   pd.formato_borracha,
								   ps.cliente,
                       			   pp.cod_pessoa as cod_pessoa_proprietario
							  from oper.v$pneu_dados pd
							  
							  left join oper.v$pneu_localizacao_atual pl on pd.pneu_id =
																			pl.pneu_id
																		and pl.data_saida is null
							  left join oper.pneu_sulco_estimado p on p.pneu_id =
																	  pd.pneu_id
							  left join oper.v$pneu_movimentacao pm on pm.pneu_id =
																	   pd.pneu_id
																   and pm.data_desmontagem is null
							  left join oper.v$pneu_movimentacao pm2 on pm2.pneu_id =
																		pm.pneu_id
																	and pm2.data_desmontagem is not null
							  																		
							  left join oper.v$pneu_proprietario pp on pp.pneu_id = pd.pneu_id
                 			  left join kss.v$pessoa ps on ps.cod_pessoa = pp.cod_pessoa 
							 where pd.reformas = 0
							 and pp.data_fim is null
				<cfif arguments.situacao_id neq 2>
							   and not exists (select 'x'
											  from oper.v$pneu_movimentacao pm3
											 where pm3.pneu_id = p.pneu_id
											   and pm3.data_desmontagem is null)
				</cfif>
			 <cfif IsDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id))>
				<cfif arguments.situacao_id eq 2>
					and pd.situacao_id = 2
				<cfelseif arguments.situacao_id eq 1>
					and pd.situacao_id = 1
				</cfif>
			 <cfelse>
				   and pd.situacao_id in (1, 2, 3, 4, 5, 6, 8, 9, 10)
			 </cfif> 	
							   ) r
					  on pvp.placa = r.placa
															   and pvp.num_gabarito =
																   r.num_gabarito
															   and pvp.num_eixo =
																   r.num_eixo
															   and pvp.posicao =
																   r.posicao
					union
					select /*+ USE_HASH(PVP R) */ r.pneu_id,
						   r.num_pneu,
						   r.modelo_id,
						   r.reformas,
						   r.marca,
						   r.modelo,
						   r.medida,
						   r.medida_roda,
						   r.medida_roda_id,
						   r.medida_id,
						   r.num_eixo,
						   r.num_gabarito,
						   r.sulco,
						   r.placa,
						   r.posicao,
						   r.borracha,
						   r.desenho,
						   r.filial,
						   r.situacao_id,
						   r.cod_pessoa,
						   r.borracha_id,
						   r.desenho_id,
						   r.zero_km,
						   pvp.prefixo as eixo,
						   r.formato_borracha,
						   r.cliente,
               			   r.cod_pessoa_proprietario               
					  from oper.v$pneu_veiculo_posicao pvp 
					  right join (select 
							 pd.pneu_id,
							 pd.num_pneu,
							 pd.modelo_id,
							 pd.reformas,
							 pd.marca,
							 pd.modelo,
							 pd.medida,
							 pd.medida_roda,
							 pd.medida_roda_id,
							 pd.medida_id,
							 pm.num_gabarito,
							 pm.num_eixo,
							 case
							   when p.sulco < 0 then
								0
							   when p.sulco is null then
								oper.pkg_pneu.fnc_sulco_atual(pd.pneu_id)
							   else
								p.sulco
							 end sulco,
							 nvl(pm.placa, pm2.placa) as placa,
							 nvl(pm.posicao, pm2.posicao) as posicao,
							 pb.descricao as borracha,
							 d.descricao as desenho,
							 (select cliente
								from kss.v$pessoa
							   where cod_pessoa = pl.cod_pessoa) as filial,
							 pd.situacao_id,
							 pl.cod_pessoa,
							 pb.borracha_id as borracha_id,
							 d.desenho_id as desenho_id,
							 case
							   when not exists
								(select 'x'
									   from oper.v$pneu_movimentacao pm4
									  where pm4.pneu_id = pd.pneu_id
										and pm4.data_montagem > pr.data_retorno_reforma) then
								1
							   else
								0
							 end as zero_km,
							 pd.formato_borracha,
							 ps.cliente,
                 			 pp.cod_pessoa as cod_pessoa_proprietario
							  from oper.v$pneu_dados pd
							  
							 inner join oper.v$pneu_reforma pr on pr.pneu_id = pd.pneu_id
															  and pr.conserto = 0
							 inner join oper.v$pneu_borracha pb on pb.borracha_id =
																   pr.borracha_id
							 inner join oper.v$pneu_desenho d on d.borracha_id =
																 pr.borracha_id
															 and d.desenho_id =
																 pr.desenho_id
							  left join oper.v$pneu_localizacao_atual pl on pd.pneu_id =
																			pl.pneu_id
																		and pl.data_saida is null
							  left join oper.pneu_sulco_estimado p on p.pneu_id =
																	  pd.pneu_id
							  left join oper.v$pneu_movimentacao pm on pm.pneu_id =
																	   pd.pneu_id
																   and pm.data_desmontagem is null
							  left join oper.v$pneu_movimentacao pm2 on pm2.pneu_id =
																		pm.pneu_id
																	and pm2.data_desmontagem is not null
							  left join oper.v$pneu_proprietario pp on pp.pneu_id = pd.pneu_id
                  			 left join kss.v$pessoa ps on ps.cod_pessoa = pp.cod_pessoa
							 where pd.reformas > 0
							 and pp.data_fim is null
				<cfif arguments.situacao_id neq 2>
							   and not exists
							 (select 'x'
									  from oper.v$pneu_movimentacao pm3
									 where pm3.pneu_id = p.pneu_id
									   and pm3.data_desmontagem is null) 
				</cfif>
							   and pr.data_retorno_reforma =
								   (select max(pr2.data_retorno_reforma)
									  from oper.v$pneu_reforma pr2
									 where pr2.pneu_id = pr.pneu_id
									   and pr2.conserto = 0)
			 <cfif IsDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id))>
				<cfif arguments.situacao_id eq 2>
					and pd.situacao_id = 2
				<cfelseif arguments.situacao_id eq 1>
					and pd.situacao_id = 1
				</cfif>
			 <cfelse>
				   and pd.situacao_id in (1, 2, 3, 4, 5, 6, 8, 9, 10)
			 </cfif> 									   
							   ) r
					   on pvp.placa = r.placa
															   and pvp.num_gabarito =
																   r.num_gabarito
															   and pvp.num_eixo =
																   r.num_eixo
															   and pvp.posicao =
																   r.posicao)
			 where 1 = 1	
			 <cfif arguments.operador eq 'BETWEEN'>
			   and sulco between #arguments.sulco# and #arguments.sulco_final#
			 <cfelse>
			   and sulco #arguments.operador# #arguments.sulco# 
			 </cfif>
			 <cfif IsDefined("arguments.cod_pessoa_filial") and Len(Trim(arguments.cod_pessoa_filial))>
			   and cod_pessoa = #arguments.cod_pessoa_filial#
			 </cfif>
			 <cfif IsDefined("arguments.medida_id") and Len(Trim(arguments.medida_id))>
			   and medida_id = #arguments.medida_id#
			 </cfif>
			 <cfif IsDefined("arguments.medida_roda_id") and Len(Trim(arguments.medida_roda_id))>
			   and medida_roda_id = #arguments.medida_roda_id#
			 </cfif>
			 <cfif IsDefined("arguments.eixo") and Len(Trim(arguments.eixo))>
			   and eixo = '#arguments.eixo#'
			 </cfif>
			 <cfif IsDefined("arguments.modelo_id") and Len(Trim(arguments.modelo_id))>
			   and modelo_id in (#arguments.modelo_id#)
			 </cfif>
			 <cfif IsDefined("arguments.reformas") and Len(Trim(arguments.reformas))>
			   and reformas in (#arguments.reformas#)
			 </cfif>
			 <cfif IsDefined("arguments.situacao_id") and Len(Trim(arguments.situacao_id))>
				<cfif arguments.situacao_id eq 2>
					and situacao_id = 2
				<cfelseif arguments.situacao_id eq 1>
					and situacao_id = 1
				</cfif>
			 </cfif>  
			 <cfif len(trim(arguments.borracha_id))>
				and borracha_id = #arguments.borracha_id# and reformas > 0
			 </cfif>
			 <cfif len(trim(arguments.proprietario))>
				and cod_pessoa_proprietario in (#arguments.proprietario#)
			 </cfif>
			 <cfif len(trim(arguments.desenho_id))>
				and desenho_id = #arguments.desenho_id# and reformas > 0
			 </cfif>
			 <cfif len(trim(arguments.formato_borracha))>
			    and formato_borracha = '#arguments.formato_borracha#'
			 </cfif>
			 order by cod_pessoa_proprietario, reformas, marca, num_pneu, modelo, medida, medida_roda, sulco 
		</cfquery>

		<cfreturn qr_desenhos>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca todas as posicoes vagas nos veiculos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 30/01/2006
	--->	
	<cffunction name="get_posicoes_vagas" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_posicoes_vagas" username="#session.usuario#" password="#session.senha#">
			select oper.fnc_get_cod_veiculo(pvp.placa) as placa,
				   pvp.num_gabarito,
				   pvp.num_eixo,
				   pvp.posicao,
				   pvp.cod_posicao,
				   pvp.ordem,
				   pvp.modelo_eixo_id,
				   pvp.caminho_imagem,
				   pvp.veiculo_modelo,
				   pvp.tipo_veiculo,
				   pvp.suspenso,
				   pvp.geminado,
				   pvp.num_veiculos,
				   pvp.pmov_id,
				   pmv.data_desmontagem,
				   pmv.user_update as usuario_desmontagem,
				   (select num_pneu
					  from oper.v$pneu p1
					 where p1.pneu_id = pmv.pneu_id) as num_pneu,
				   pld.DESCRICAO as laudo_desmontagem,
				   (select t.landmark
					  from oper.v$rank_frota t
					 where (placa_controle = pvp.placa or placa_referencia = pvp.placa)
					   and rownum = 1) as ultima_posicao
			  from (select /*+ ORDERED */
					 pvp.placa,
					 pvp.num_gabarito,
					 pvp.num_eixo,
					 pvp.posicao,
					 pvp.cod_posicao,
					 pvp.ordem,
					 pvp.modelo_eixo_id,
					 pvp.caminho_imagem,
					 pvp.veiculo_modelo,
					 pvp.tipo_veiculo,
					 pvp.suspenso,
					 pvp.geminado,
					 (select count(*)
						from (select distinct pvp.placa
								from oper.v$pneu_veiculo_posicao pvp
							   where not exists (select 'x'
										from oper.v$pneu_movimentacao pm
									   where pm.placa = pvp.placa
										 and pm.num_gabarito = pvp.num_gabarito
										 and pm.num_eixo = pvp.num_eixo
										 and pm.posicao = pvp.posicao
										 and pm.data_desmontagem is null)
								 and (pvp.empresa = 1 or exists
									  (select 'x'
										 from oper.v$veiculo_agregado a
										inner join oper.v$agregado_gestao_individual ag on a.cod_pessoa =
																						   ag.cod_pessoa
																					   and ag.id = 30
																					   and ag.percentual = 1
										where a.placa = pvp.placa))
							   group by pvp.placa)) as num_veiculos
					 /* ------------------------------------------------- */,
					 (select max(pmov_id)
						from oper.v$pneu_movimentacao pm
					   where pm.placa = pvp.placa
						 and pm.num_gabarito = pvp.num_gabarito
						 and pm.num_eixo = pvp.num_eixo
						 and pm.posicao = pvp.posicao
						 and pm.data_desmontagem =
							 (select max(data_desmontagem)
								from oper.v$pneu_movimentacao pm
							   where pm.placa = pvp.placa
								 and pm.num_gabarito = pvp.num_gabarito
								 and pm.num_eixo = pvp.num_eixo
								 and pm.posicao = pvp.posicao)) as pmov_id
					/* ------------------------------------------------- */
					  from oper.v$pneu_veiculo_posicao pvp
					 where not exists (select 'x'
							  from oper.v$pneu_movimentacao pm
							 where pm.placa = pvp.placa
							   and pm.num_gabarito = pvp.num_gabarito
							   and pm.num_eixo = pvp.num_eixo
							   and pm.posicao = pvp.posicao
							   and pm.data_desmontagem is null)
					   and (pvp.empresa = 1 or exists
							(select 'x'
							   from oper.v$veiculo_agregado a
							  inner join oper.v$agregado_gestao_individual ag on a.cod_pessoa =
																				 ag.cod_pessoa
																			 and ag.id = 30
																			 and ag.percentual = 1
							  where a.placa = pvp.placa))
					
					 order by pvp.placa, num_eixo, ordem) pvp
			  left join oper.v$pneu_movimentacao pmv 
					 on pmv.pmov_id = pvp.pmov_id
			  left join oper.v$pneu_laudo_desmontagem pld
					 on pld.LAUDO_ID = pmv.laudo_desmontagem_id
		</cfquery>
		<cfreturn qr_posicoes_vagas>
	</cffunction>	
	<!--- 
	-- PROPSITO 
	-- Busca o rendimento dos pneus do veiculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 01/02/2006
	--->
	<cffunction name="get_rendimento" returntype="query" access="remote" output="true">
		<cfargument name="cod_veiculo" required="no">
		<cfset qr_veiculo.COMPOSICAO = this.get_composicao(placa = '#this.get_placa(arguments.cod_veiculo)#', sem_aspas = true)>
		<cfquery datasource="#session.dsn#" name="qr_rendimento" username="#session.usuario#" password="#session.senha#" blockfactor="100">
			select /*+ RULE */  num_pneu, modelo, marca, borracha, desenho, pmov_id, num_gabarito, num_eixo, caminho_imagem, posicao,
					   oper.fnc_get_cod_veiculo(placa) as placa, pneu_id, data_montagem, km_montagem, eixo_posicao, posicao_gabarito, ordem, veiculo_modelo,
					   suspenso, modelo_eixo_id, tipo_veiculo, mm_montagem, km_rodado, mm_estimado, rendimento, mm_gastos,
					   peso_tracionado, peso_tracionado_familia, dias_ult_inspecao, reformas,
					  case 
						 when mm_estimado <= 0 then 'SP'
					  else  to_char(round(km_rodado / decode((mm_montagem - mm_estimado),0,1,(mm_montagem - mm_estimado)))) end rendimento_pneu
			  from (
							select num_pneu, modelo, marca, borracha , desenho,  pmov_id, num_gabarito, num_eixo, caminho_imagem, posicao, placa, 
								   pneu_id, data_montagem, km_montagem, eixo_posicao, posicao_gabarito, ordem, 
								   veiculo_modelo, suspenso, modelo_eixo_id, tipo_veiculo, mm_montagem,
									oper.pkg_pneu.fnc_km_rodado(placa,data_montagem,suspenso) as km_rodado,		
								   decode(oper.pkg_pneu.fnc_rendimento_pneu(pneu_id,modelo_eixo_id, num_eixo, tipo_veiculo), 0, -1,
								   round(mm_montagem - ((oper.pkg_pneu.fnc_km_atual(placa) - decode(suspenso,0,0,oper.pkg_pneu.fnc_km_vazio(placa, data_montagem, sysdate)) - km_montagem) / 
								   oper.pkg_pneu.fnc_rendimento_pneu(pneu_id, modelo_eixo_id, num_eixo, tipo_veiculo)), 1)) as mm_estimado,
								   oper.pkg_pneu.fnc_rendimento_pneu(pneu_id,modelo_eixo_id, num_eixo, tipo_veiculo) as rendimento, 
								   oper.pkg_pneu.fnc_rendimento_pneu_mm(pneu_id,modelo_eixo_id, num_eixo, tipo_veiculo) as mm_gastos, 
								   oper.pkg_pneu.fnc_peso_medio_tracionado(pneu_id) as peso_tracionado, 
								   oper.pkg_pneu.fnc_peso_medio_tracionado(pneu_id, modelo_eixo_id, num_eixo, tipo_veiculo) as peso_tracionado_familia, 
								   trunc(sysdate - oper.pkg_pneu.fnc_ultima_inspecao(pneu_id)) as dias_ult_inspecao, reformas
							  from (select num_pneu, modelo, marca, borracha , desenho,  pmov_id, num_gabarito, num_eixo, caminho_imagem, posicao, placa, 
												   pneu_id, data_montagem, km_montagem, eixo_posicao, posicao_gabarito, ordem, 
												   veiculo_modelo, suspenso, modelo_eixo_id, tipo_veiculo, 
										   mm_montagem, reformas
									  from oper.v$pneu_veiculo_gabarito
									 where instr('#qr_veiculo.COMPOSICAO#',placa) > 0)
								     order by instr('#qr_veiculo.COMPOSICAO#',placa), num_eixo, ordem) 
		</cfquery>
		<cfreturn qr_rendimento>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca as Reformadores para o painel
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 09/02/2006
	--->
	<cffunction name="get_painel_reformadores" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qrReformadores" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa_reformador, nvl(cliente,'Outros') as reformador, sum(quantidade) as quantidade
			from (select case
							  when quantidade/total < 0.05 then 0
							  else cod_pessoa_reformador end cod_pessoa_reformador, quantidade
					from (select pr.cod_pessoa_reformador, count(*) as quantidade,
								 (select count(*)
										  from oper.v$pneu_dados p
										 inner join oper.v$pneu_reforma pr
												on pr.pneu_id = p.pneu_id
											   and pr.conserto = 0
										inner join oper.v$pneu_borracha pb
												on pb.borracha_id = pr.borracha_id
										inner join oper.v$pneu_desenho pd
												on pd.borracha_id = pr.borracha_id
											   and pd.desenho_id = pr.desenho_id
										  where pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																			from oper.v$pneu_reforma pr2
																		   where pr2.pneu_id = pr.pneu_id
																			 and pr2.conserto = 0)) as total
								  from oper.v$pneu_dados p
								 inner join oper.v$pneu_reforma pr
										on pr.pneu_id = p.pneu_id
									   and pr.conserto = 0
								inner join oper.v$pneu_borracha pb
										on pb.borracha_id = pr.borracha_id
								inner join oper.v$pneu_desenho pd
										on pd.borracha_id = pr.borracha_id
									   and pd.desenho_id = pr.desenho_id
								where p.situacao_id in (1,2,3,4,5,6,8,9,10)
								   and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																	from oper.v$pneu_reforma pr2
																   where pr2.pneu_id = pr.pneu_id
																	 and pr2.conserto = 0)
							group by pr.COD_PESSOA_REFORMADOR))
			left join oper.v$pessoa pj
					on pj.cod_pessoa = cod_pessoa_reformador
			group by cod_pessoa_reformador, cliente
		</cfquery>
		<cfreturn qrReformadores>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca todas os reformadores de pneu para a montagem do relatorio de reformadores
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 31/01/2006
	--->
	<cffunction name="get_resumo_reformador" returntype="query" access="remote">
		<cfquery datasource="#session.dsn#" name="qr_desenhos" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa_reformador, nvl(cliente,'Outros') as reformador, sum(quantidade) as quantidade
			from (select cod_pessoa_reformador, quantidade
					from (select pr.cod_pessoa_reformador, count(*) as quantidade,
								 (select count(*)
										  from oper.v$pneu_dados p
										 inner join oper.v$pneu_reforma pr
												on pr.pneu_id = p.pneu_id
											   and pr.conserto = 0
										inner join oper.v$pneu_borracha pb
												on pb.borracha_id = pr.borracha_id
										inner join oper.v$pneu_desenho pd
												on pd.borracha_id = pr.borracha_id
											   and pd.desenho_id = pr.desenho_id
                    where pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
                  																		from oper.v$pneu_reforma pr2
                  																	   where pr2.pneu_id = pr.pneu_id
                  																		 and pr2.conserto = 0)) as total      
								  from oper.v$pneu_dados p
								 inner join oper.v$pneu_reforma pr
										on pr.pneu_id = p.pneu_id
									   and pr.conserto = 0
								inner join oper.v$pneu_borracha pb
										on pb.borracha_id = pr.borracha_id
								inner join oper.v$pneu_desenho pd
										on pd.borracha_id = pr.borracha_id
									   and pd.desenho_id = pr.desenho_id		
								where  p.situacao_id in (1,2,3,4,5,6,8,9,10)   	   
							   and pr.data_retorno_reforma = (select max(pr2.data_retorno_reforma)
																from oper.v$pneu_reforma pr2
															   where pr2.pneu_id = pr.pneu_id
																 and pr2.conserto = 0)
                
							group by pr.COD_PESSOA_REFORMADOR))
			left join oper.v$pessoa pj
					on pj.cod_pessoa = cod_pessoa_reformador              
			group by cod_pessoa_reformador, cliente
		  order by 3 desc
		</cfquery>
		<cfreturn qr_desenhos>
	</cffunction>
</cfcomponent>