<!---
Atualizador KMM Web.
Os procedimentos dessa estrutura ficam independentes do restante para evitar erros de implantao. No se utilizam CFCs.
--->
<cfparam name="v_versao" default="-1">
<cfparam name="v_disable_update" default="0">
<cfflush interval="1">
<div id="div_atualizador">
<img src="/_imagens/uteis/carregando.gif" /><br />
Baixando atualizaes: <span id="span_atualizador_arquivo"></span>
</div>
<cffunction name="md5_file" displayname="Captura o Hash MD5 do Arquivo" returntype="string" output="true" access="remote">
        <cfargument name="file" required="yes">
        <cfargument name="expand" required="no" default="0">
	<cfset var md5 = createObject("java","java.security.MessageDigest").getInstance("MD5")>
        <cfif arguments.expand eq 1>
                <cfset arguments.file = expandPath(arguments.file)>
        </cfif>
        <cffile action="readbinary" file="#file#" variable="myBinaryFile">
        <cfset md5.update(myBinaryFile,0,len(myBinaryFile))>
        <cfset checksumByteArray = md5.digest()>
        <cfset checkSumHex = "">
        <cfloop from="1" to="#len(checksumByteArray)#" index="i">
           <cfset hexCouplet = formatBaseN(bitAND(checksumByteArray[i],255),16)>
           <!--- Pad with 0's --->
           <cfif len(hexCouplet) EQ 1>
              <cfset hexCouplet = "0#hexCouplet#">
           </cfif>
           <cfset checkSumHex = "#checkSumHex##hexCouplet#">
        </cfloop>
        
        <cfreturn checkSumHex/>

</cffunction>

<cfif not FileExists(ExpandPath("/config/atualizador.xml"))>
        <cffile action="write" nameconflict="overwrite" file="#ExpandPath('/config/atualizador.xml')#" output="<config></config>" charset="utf-8">
</cfif>

<cfif FileExists(ExpandPath("/config/atualizador.xml"))>
        <cffile action="read" file="#ExpandPath('/config/atualizador.xml')#" variable="configIn" charset="utf-8">
    <cfset config = XMLParse(configIn)>
        <cfset search = xmlsearch(config,'/config/versao[@DSN="#session.dsn#"]')>
    <cfif not ArrayIsEmpty(search)>
        <cfset v_versao = search[1].xmltext>
    </cfif>
        <cfset search = xmlsearch(config,'/config/disable_update')>
    <cfif not ArrayIsEmpty(search)>
        <cfset v_disable_update = search[1].xmltext>
    </cfif>
<cfelse>
        <cfxml casesensitive="yes" variable="config">
    <config></config>
    </cfxml>
</cfif>

<cfif v_disable_update neq "1">
<cftry>
    <cfquery name="qrAtualizacao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select versao_id,
               arquivo_id,
               path,
               nome_arquivo,
               conteudo,
               md5,
               md5_compactado,
               aplicacao,
               user_insert,
               date_insert,
               user_update,
               date_update,
               site
          from kmmupdate.v$arquivo
         where aplicacao = 'INTERNET'
           and versao_id > #v_versao#
         order by versao_id
    </cfquery>

    <cfloop query="qrAtualizacao">
        <cfset v_atualizado = true>
        <cfset tempfile = GetTempFile(GetTempDirectory(),'zip_')>
        <cffile action="write" file="#tempfile#" output="#qrAtualizacao.conteudo#" mode="774">

                <cfif md5_file(tempfile) neq ucase(qrAtualizacao.md5_compactado)>
                <cfoutput>Falha na Atualizao do Site. No foi possvel extrair o arquivo #qrAtualizacao.path#/#qrAtualizacao.nome_arquivo#.</cfoutput>
            <cfabort>
        </cfif>

        <cfzip
            action = "list"
            file = "#tempfile#"
            name = "v_list">

        <cfif v_list.recordcount gt 0>
                <cfzip action="readBinary" entrypath="#v_list.directory##v_list.name#" file="#tempfile#" variable="v_arquivo">

            <cfset filename = ExpandPath(qrAtualizacao.path&"/"&qrAtualizacao.nome_arquivo)>
            <cfif FileExists(filename)>
                                <cfset bkpfile = GetTempFile(GetTempDirectory(),'bkp_')>
                <cffile action="move" destination="#bkpfile#" source="#filename#">
            </cfif>
            <cfif not DirectoryExists(GetDirectoryFromPath(filename))>
                    <cfdirectory action="create" directory="#GetDirectoryFromPath(filename)#" mode="777" />
            </cfif>

            <cffile action="write" file="#filename#" output="#v_arquivo#" mode="777" >

            <cfif trim(md5_file(filename)) neq trim(ucase(qrAtualizacao.md5))>
                <cfset md5old = md5_file(filename)>
                <cfif isdefined("bkpfile")>
                        <cffile action="move" destination="#filename#" source="#bkpfile#">
                </cfif>
                <cfoutput>Falha na Atualizao do Site. Falha na gravao do arquivo #filename#.#md5old# != #ucase(qrAtualizacao.md5)#</cfoutput>
                    <cfset v_atualizado = false>
            <cfelse>
<cfoutput><!-- Arquivo atualizado: #filename# -->
<script>
	document.getElementById("span_atualizador_arquivo").innerHTML = "#LSNumberFormat(100*qrAtualizacao.currentrow/qrAtualizacao.recordcount,'_._')#% (#qrAtualizacao.currentrow# de #qrAtualizacao.recordcount#) #JSStringFormat(replace(filename,ExpandPath('/'),'/','all'))# ";
</script>
</cfoutput>
            </cfif>
        </cfif>

        <cfif v_atualizado>
                        <!--- Atualiza o arquivo de controle de verso --->
            <cfset search = xmlsearch(config,'/config/versao[@DSN="#session.dsn#"]')>
            <cfif not ArrayIsEmpty(search)>
                <cfset v_versao = search[1].xmltext>
                <cfset search[1].xmltext = qrAtualizacao.versao_id>
            <cfelse>
                <cfset v_elem_versao = xmlelemnew(config,"versao")>
                <cfset v_elem_versao.xmlattributes.dsn = ucase(trim(session.dsn))>
                <cfset v_elem_versao.xmltext = qrAtualizacao.versao_id>
                <cfset arrayAppend(config.config.xmlchildren, v_elem_versao)>
            </cfif>

                <cffile action="write" nameconflict="overwrite" file="#ExpandPath('/config/atualizador.xml')#" output="#ToString(config)#" charset="utf-8">
        <cfelse>
                <cfbreak/>
        </cfif>
    </cfloop>

    <cfcatch type="database">
        <cfif cfcatch.NativeErrorCode eq 1017>
           <cfthrow object="#cfcatch#">
        </cfif>
        <!--- Ignora, no deve existir a estrutura da atualizao --->
    </cfcatch>
</cftry>
</cfif>
<script>
   document.getElementById("div_atualizador").style.display = 'none';
</script>