<cfscript>
conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
qrEspelho = conn.get_crt_espelho(conhecimento_id = vars.conhecimento_id);
qrItens = conn.get_crt_espelho_itens(conhecimento_id = vars.conhecimento_id);
qrDivisao = conn.get_intc_crt_divisao(conhecimento_id = vars.conhecimento_id, mostra_canceladas = 0);
qrCartaFrete = conn.get_contrato_transporte(conhecimento_id = vars.conhecimento_id);
</cfscript>
<cfdocument name="espelho_conhecimento" format="pdf">
<style type="text/css">
	body {
		margin: 0;
		padding: 0;
	}
	.fonte {
		font-family: Verdana, Arial, Helvetica, sans-serif;
		font-size: 20px;
		line-height: 20px;
	}
table.bordasimples {border-collapse: collapse;
border: 1px  groove  #CCC;
}

table.bordasimples tr {border:1px solid #CCC}
	
</style>
<body>
<cfoutput>

<table border="0" cellspacing="2" class="fonte">
    <tr>
      <td colspan="4"></td></tr>
    <tr>
        <td width="254" rowspan="2" align="center" valign="middle" border="1"class="titulo">
           <img src="<cf_url>/_imagens/logos/logo_relatorio_2.png</cf_url>" alt="Espelho de Conhecimento Internacional" name="img_logo" id="img_logo" />
</td>
        <td width="156">&nbsp;</td>
        <td width="45" align="right">&nbsp;</td>
        <td width="594" align="center">&nbsp;</td>
    </tr>
    <tr>
        <td height="81" colspan="3" align="center" style="width: 22cm; font-size: 28px; font-weight: bold;">Espelho de Conhecimento Internacional</td>
    </tr>
</table>

<table cellpadding="2" cellspacing="2" class="fonte" style="width: 20cm;">
<tr>
        <td width="10%"><nobr>Emitente :</nobr></td>
        <td width="60%">&nbsp;#qrEspelho.cod_emitente#&nbsp;#qrEspelho.emitente#</td>
        <td width="10%"><nobr>N CRT :</nobr></td>
        <td width="20%">#qrEspelho.num_crt_completo#</td>
    </tr>
    <tr>
        <td width="10%"><nobr>Pagador do Frete :</nobr></td>
        <td width="60%">&nbsp;#qrEspelho.pago_por#</td>
        <td width="10%"><nobr>Tipo de Frete :</nobr></td>
      <td width="20%">&nbsp;#qrEspelho.situacao#</td>
    </tr>
  </table>
  <br>
<table width="1480px" cellspacing="2" cellpadding="2" class="bordasimples" >
    <tr>
    	<td>
            <table cellpadding="2" cellspacing="2" class="fonte">
            <tr>
                <td width="19%" style="text-align: right"><nobr>Remetente :</nobr></td>
            <td width="26%" >&nbsp;#qrEspelho.cod_remetente#</td>
                <td width="55%" align="left">#qrEspelho.rem_nome#</td>
			</tr>
            <tr>
                <td width="19%" style="text-align: right"><nobr>Destinatrio :</nobr></td>
            	<td width="26%" >#qrEspelho.COD_DESTINATARIO#</td>
                <td width="55%" align="left">#qrEspelho.dest_nome#</td>
			</tr>
            <tr>
                <td width="19%" style="text-align: right"><nobr>Consignatrio :</nobr></td>
            	<td width="26%" >#qrEspelho.cod_consignatario#</td>
                <td width="55%" align="left">#qrEspelho.cons_nome#</td>
			</tr>
            <tr>
                <td width="19%" style="text-align: right"><nobr>Local Emisso :</nobr></td>
            	<td width="26%" >#qrEspelho.emissao_cep#</td>
                <td width="55%" align="left">#qrEspelho.emissao_local#</td>
			</tr>
            <tr>
                <td width="19%" style="text-align: right"><nobr>Cep. Resp. :</nobr></td>
            	<td width="26%" >#qrEspelho.resp_cep#</td>
                <td width="55%" align="left">#qrEspelho.resp_local#</td>
			</tr>
            <tr>
                <td width="19%" style="text-align: right"><nobr>Cep. Entrega :</nobr></td>
            	<td width="26%" >#qrEspelho.entrega_cep#</td>
                <td width="55%" align="left">#qrEspelho.entrega_local#</td>
			</tr>
            <tr>
                <td width="19%" style="text-align: right"><nobr>Rota :</nobr></td>
            	<td width="26%" >#qrEspelho.rota#</td>
                <td  width="55%" align="left" >#qrEspelho.rota_descricao#</td>
			</tr>
            </table>
        <td>
          <table cellpadding="2" cellspacing="2" class="fonte">
            <tr>
		        <td style="text-align: right"><nobr>Espcie de Carga :</nobr></td>
            	<td >#qrEspelho.num_especie#</td>
                <td colspan="3" >#qrEspelho.especie_descricao#</td>
		    </tr>
            <tr>
		        <td style="text-align: right"><nobr>Natureza da Carga :</nobr></td>
            	<td >#qrEspelho.produto_id#</td>
                <td colspan="3" >#qrEspelho.produto_descricao#</td>
		    </tr>
            <tr>
		        <td style="text-align: right"><nobr>Tipo de Transporte :</nobr></td>
            	<td colspan="4" >#qrEspelho.organizacional_id_gerencial#&nbsp;&nbsp;#qrEspelho.organizacional_descricao#</td>
                
		    </tr>
            <tr>
		        <td style="text-align: right"><nobr>Qtdade de Volumes :</nobr></td>
            	<td  colspan="2" >#qrEspelho.quantidade_total#&nbsp;</td>
                <td>M :</td>
                <td>#qrEspelho.m3#</td>
		    </tr>
            <tr>
		        <td width="240" style="text-align: right"><nobr>Peso Lquido :</nobr></td>
            	<td  colspan="2">#qrEspelho.peso_liquido#&nbsp;</td>
                <td width="145">Peso Bruto :</td>
                <td width="200">#qrEspelho.peso_bruto#</td>
		    </tr>
            <tr>
            	<td width="240"  style="text-align: right"><nobr>Doc. Anexos :</nobr></td>
                <td colspan="4">#HTMLEditFormat(qrEspelho.documentos)#</td>
                
		    </tr>
            <tr>
		        <td width="240"  style="text-align: right"><nobr>Declarao Mercad. :</nobr></td>
                <td  colspan="4">N.I.H.I.L</td>
		    </tr>
            </table>
        </td>
    </tr>
</table>
<br>
<table width="1480px" cellspacing="2" cellpadding="2" class="bordasimples"  >
    <tr>
    	<td height="100%" >
          <table cellspacing="2" cellpadding="2" class="fonte" style="width: 18cm;">
            <tr>
                <td width="25%">Moeda :</td>
                <td  colspan ="2">&nbsp;US$</td>
                <td  colspan="2"><nobr>Cotao Moeda&nbsp;</nobr></td>
                <td width="16%">&nbsp;#qrEspelho.cotacao#</td>
			</tr>
            <tr>
                <td width="25%">Valor Mercadoria</td>
                <td width="20%" style="text-align: right">#LsNumberFormat(qrEspelho.valor_mercadorias,',.__')#&nbsp;</td>
            	<td width="8%">#qrEspelho.mercadorias_moeda#</td>
                <td width="4%">&nbsp;R$&nbsp;</td>
                <td  colspan="2" style="text-align: right">#LsNumberFormat(qrEspelho.valor_mercadorias*qrEspelho.cotacao,',.__')#&nbsp;</td>
			</tr>
            <tr>
                <td width="25%">Frete Externo</td>
                <td width="20%" style="text-align: right">#LsNumberFormat(qrEspelho.valor_frt_externo,',.__')#&nbsp;</td>
           		<td width="8%">#qrEspelho.mercadorias_moeda#</td>
                <td width="4%">&nbsp;R$&nbsp;</td>
                <td  colspan="2" style="text-align: right">#LsNumberFormat(qrEspelho.valor_frt_externo*qrEspelho.cotacao,',.__')#&nbsp;</td>
			</tr>
            <tr>
                <td width="25%">Ref. Contra Ent.</td>
                <td width="20%" style="text-align: right">#LsNumberFormat(qrEspelho.valor_reembolso,',.__')#&nbsp;</td>
            	<td width="8%">#qrEspelho.reembolso_cod_moeda#</td>
                <td width="4%">&nbsp;R$&nbsp;</td>
                <td  colspan="2" style="text-align: right">#LsNumberFormat(qrEspelho.valor_reembolso*qrEspelho.cotacao,',.__')#&nbsp;</td>
			</tr>
            <cfloop query="qrItens">
            <tr>
                <td width="25%">#qrItens.descricao#</td>
                <td width="20%" style="text-align: right">#LsNumberFormat(qrItens.valor,',.__')#&nbsp;</td>
            	<td width="8%">US$</td>
                <td width="4%">&nbsp;R$&nbsp;</td>
                <td  colspan="2" style="text-align: right">#LsNumberFormat(qrItens.valor*qrEspelho.cotacao,',.__')#&nbsp;</td>
			</tr>

            </cfloop>
            </table>
    </td>
    <td >
            <table cellpadding="2" cellspacing="2" class="fonte" style="width: 12cm;">
            <tr>
	          <td width="30%" style="text-align: right"><nobr>Data de Emisso :</nobr></td>
              <td width="70%">&nbsp;#qrEspelho.emissao_data#</td>
            </tr>
            <tr>
	          <td width="30%" style="text-align: right"><nobr>Data Ass. Transportador :</nobr></td>
              <td width="70%">&nbsp;#qrEspelho.emissao_data#</td>
            </tr>
            <tr>
	          <td width="30%" style="text-align: right"><nobr>Data Ass. Remetente :</nobr></td>
              <td width="70%">&nbsp;#qrEspelho.emissao_data#</td>
            </tr>
            <tr>
	          <td width="30%" style="text-align: right"><nobr>Data Ass. Destinatrio :</nobr></td>
              <td width="70%">&nbsp;#qrEspelho.data_entrega#</td>
            </tr>
            </table>
        </td>
    </tr>
</table>
<br>
<cfif qrDivisao.RecordCount neq 0>
<table width="1480px" cellspacing="2" cellpadding="2" class="bordasimples" >
    <tr>
    <td>
    <table width="100%" cellspacing="2" cellpadding="2" class="fonte">
        <tr>
        <td colspan="8"  style="width: 20cm; font-weight: bold;">&nbsp;&nbsp;Motoristas</td>
        </tr>
        <tr>
        <td align="center">Motorista</td>
        <td align="center">Valor Frete</td>
        <td align="center">Taxa C.</td>
        <td align="center">Valor Frete R$</td>
        <td align="center">Data Embarque</td>
        <td align="center">Veculo</td>
        <td align="center">Carta Frete</td>
        <td align="center">Valor</td>
        </tr>
        <cfloop query="qrDivisao">
        <tr>
        <td align="left">#qrDivisao.motorista#</td>
        <td align="right">#DecimalFormat(qrDivisao.valor_frete)#</td>
        <td align="right">#qrEspelho.cotacao#</td>
        <td align="right">#LsNumberFormat(qrDivisao.valor_frete*qrEspelho.cotacao,',.__')#</td>
        <td align="center">#qrDivisao.data_embarque#</td>
        <td align="center">#qrDivisao.placa_frota_controle#</td>
        <td align="center">#qrDivisao.filial#&nbsp;-&nbsp;#qrDivisao.num_formulario#</td>
        <td align="right">#LsNumberFormat(qrDivisao.valor*qrEspelho.cotacao,',.__')#</td></tr>
        </cfloop>
    </table>
    </td>
    </tr>
</table>
</cfif>
<br>
<cfif qrCartaFrete.RecordCount neq 0>
<table width="1480px" cellspacing="2" cellpadding="2" class="bordasimples" >
    <tr>
    <td>
        <table width="100%" cellpadding="2" cellspacing="2" class="fonte">
            <tr>
            <td colspan="9"  style="width: 20cm; font-weight: bold;">&nbsp;&nbsp;Cartas Frete</td>
            </tr>
            <tr>
            <td align="center">Empresa</td>
            <td align="center">Apelido</td>
            <td align="center">Carta Frete</td>
            <td align="center">Motorista</td>
            <td align="center">Data de Emisso</td>
            <td align="center">Valor Frete Mot.</td>
            <td align="center">Valor Fete Emp.</td>
            <td align="center">Valor Total</td>
            <td align="center">FC/FE</td>
            </tr>
            <cfloop query="qrCartaFrete">
            <tr>
            <td align="left">#qrCartaFrete.cod_filial#</td>
            <td align="left">#qrCartaFrete.filial#</td>
            <td align="center">#qrCartaFrete.carta_frete#</td>
            <td align="left">#qrCartaFrete.motorista#</td>
            <td align="center">#qrCartaFrete.data_emissao#</td>
            <td align="right">#DecimalFormat(qrCartaFrete.valor_frete_motorista)#</td>
            <td align="right">#DecimalFormat(qrCartaFrete.valor_frete_empresa*qrEspelho.cotacao)#</td>
            <td align="right">#DecimalFormat(qrCartaFrete.valor_frete_motorista)#</td>
            <td align="center">#qrCartaFrete.porcentagem#%</td>
          </tr>
          	</cfloop>
        </table>
    </td>
    </tr>
</table>
</cfif>
</cfoutput>
</body>
</cfdocument>
<cfset path = ExpandPath("/temp")>
<cfpdf action="merge" destination="#path#/esp_conhecimento.pdf" overwrite="yes">
	<cfpdfparam source="espelho_conhecimento">
</cfpdf>
<script>
  window.location = '/temp/esp_conhecimento.pdf';
</script>