
<cfscript>
conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
qr_result = conn.get_crt_por_modalidade();

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The data for the bar chart
count = 0;
data0 = ArrayNew(1);
data1 = ArrayNew(1);
data2 = ArrayNew(1);
while (count lt qr_result.RecordCount) 
{
	count = count + 1;
	if (qr_result[ "PROPRIETARIO" ][ count ] eq 'Frota') 
		ArrayPrepend(data0,qr_result[ "VALOR_FRETE" ][ count ]);
	if (qr_result[ "PROPRIETARIO" ][ count ] eq 'Agregado') 
		ArrayPrepend(data1,qr_result[ "VALOR_FRETE" ][ count ]);
	if (qr_result[ "PROPRIETARIO" ][ count ] eq 'Terceiro') 
		ArrayPrepend(data2,qr_result[ "VALOR_FRETE" ][ count ]);
}
//data0 = Array(100, 125, 245, 147, 67);
//data1 = Array(85, 156, 179, 211, 123);
//data2 = Array(97, 87, 56, 267, 157);

// The labels for the bar chart
labels = Array("11/2006", "12/2006", "01/2007", "02/2007", "03/2007");

// Create a XYChart object of size 500 x 280 pixels, using 0xffffcc as background
// color, with a black border, and 1 pixel 3D border effect
c = cd.XYChart(500, 280, "0xffffcc", 0, 1);

// Set search path to current directory for loading icon images
c.setSearchPath(GetPageContext());

// Set the plotarea at (50, 45) and of size 320 x 200 pixels. Use white (0xffffff)
// color as background.
c.setPlotArea(50, 45, 320, 200, "0xffffff");

// Add a legend box at (370, 45) using vertical layout and 8 points Arial Bold font.
legendBox = c.addLegend(370, 45, True, "Arial Bold", 8);

// Set the legend box background and border to transparent
legendBox.setBackground(cd.Transparent, cd.Transparent);

// Set the legend box icon size to 16 x 32 pixels to match with custom icon size
legendBox.setKeySize(16, 32);

// Add a title to the chart using 14 points Times Bold Itatic font and white font
// color, and 0x804020 as the background color
c.addTitle("Modalidade por ms", "Times New Roman Bold Italic", 14, "0xffffff"
    ).setBackground("0x804020");

// Set the labels on the x axis
c.xAxis().setLabels(labels);

// Add a percentage bar layer and set the layer 3D depth to 8 pixels
layer = c.addBarLayer2(cd.Percentage);

// Add the three data sets to the bar layer, using icons images with labels as data
// set names
layer.addDataSet(data0, "0xddaa77",
    "<*block,valign=absmiddle*><*img=service.png*> Frota<*/*>");
layer.addDataSet(data1, "0xaadd77",
    "<*block,valign=absmiddle*><*img=software.png*> Agregado<*/*>");
layer.addDataSet(data2, "0xaa77dd",
    "<*block,valign=absmiddle*><*img=computer.png*> Terceiro<*/*>");

// Disable bar borders by setting their colors to transparent
layer.setBorderColor(cd.Transparent);

// Enable data label at the middle of the the bar
layer.setDataLabelStyle().setAlignment(cd.Center);

// For a vertical stacked chart with positive data only, the last data set is always
// on top. However, in a vertical legend box, the last data set is at the bottom.
// This can be reversed by using the setLegend method.
layer.setLegend(cd.ReverseLegend);

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("", "",
    "title='{dataSetName} revenue on {xLabel}: US${value}K ({percent}%)'");

</cfscript>
<html>
<body style="margin:5px 0px 0px 5px">
<hr style="border:solid 1px #000080" />
<cfoutput>
<img src="/testes/cfdemo/getchart.cfm?#chart1URL#" usemap="##map1" border="0" />
</cfoutput>
</body>
</html>