<html>
<cfinclude template="/_scripts/scripts.cfm" />
<cfinclude template="/_include/carregando.cfm" />
<cfscript>
	conn = CreateComponent("_transportes.consulta.cfc_global");
	qrTipo = conn.get_cg_ref_codes(rv_domain = 'INTC_PROGRAMACAO.TIPO_ID', owner = 'OPER');
	conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
	qrEmail = conn.get_lista_email();
	if(IsDefined("vars.TIPO_ID")) {
		conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
		qrProgramacao     = conn.get_intc_programacao_abertas(tipo_id = vars.TIPO_ID);
		qrFronteira       = conn.get_fronteira();
		qrLocalTransbordo = conn.get_intc_local_transbordo();
	}
</cfscript>
<script type="text/javascript">
	// Configura botoes //
	parent.f_set_texto('titulo_aplicacao', 'Transporte Internacional');
	parent.f_set_texto('titulo_pagina', 'Registro de Embarques');
	
	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); } 
	
	parent.f_hidden('btn_incluir');
	parent.f_hidden('btn_editar');
	parent.f_hidden('btn_excluir');
	parent.f_hidden('btn_cancelar');
	parent.f_hidden('btn_confirmar');
	f_habilitar_botao('confirmar', 'f_confirmar()');
	
	// -------------------- //
	
	function f_confirmar() {
		with(document.forms[0]) {
			target = 'consultas';
			action = 'confirma.cfm';
			TRANSBORDO.disabled = false;
			LOCAL_TRANSBORDO_ID.disabled = false;
			
			if(f_verifica_form(document.forms[0])) {
				submit();
			}
		}
		return false;
	}
	parent.f_confirmar = f_confirmar;
	
	function f_buscar_programacao_abertas() {
		with(document.forms[0]) {
			target = '_self';
			action = 'principal.cfm';
			submit();
		}
		return false;
	}
	
	function f_embarcar(p_programacao_id, p_consolidada, p_programacao_id_vinculo) {
		with(document.forms[0]) {
			OPERACAO.value = 2; // Inserir Embarque
			PROGRAMACAO_ID.value = p_programacao_id;
			
			document.getElementById('tr_filtro').style.display = 'none';
			document.getElementById('tr_programacao').style.display = 'none';
			document.getElementById('tr_embarque').style.display = '';
			parent.f_show('btn_confirmar');
			
			parent.document.getElementById('btn_voltar').onclick = function () {
				f_mostrar_programacao();
				this.onclick = function () {
					window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent','');
				}
			};
			
			f_readOnly_campos(false);
			
			if(p_consolidada == 1) {
				f_busca_viagens(p_programacao_id_vinculo, p_consolidada);
			}
			else {
				f_busca_viagens(p_programacao_id, p_consolidada);
			}
			
			f_busca_fronteira_programacao(p_programacao_id);
		}
	}
	
	function f_vincular_conhecimento(p_embarque_id) {
		with(document.forms[0]) {
			OPERACAO.value = 3; // Vincular a um CRT
			EMBARQUE_ID.value = p_embarque_id;
			
			document.getElementById('tr_filtro').style.display = 'none';
			document.getElementById('tr_programacao').style.display = 'none';
			document.getElementById('tr_embarque').style.display = '';
			parent.f_show('btn_confirmar');
			
			parent.document.getElementById('btn_voltar').onclick = function () {
				f_mostrar_programacao();
				this.onclick = function () {
					window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent','');
				}
			};
			
			f_readOnly_campos(true);
			f_busca_dados_embarque();
		}
	}
	
	function f_vincular_manifesto(p_embarque_id) {
		with(document.forms[0]) {
			OPERACAO.value = 4; // Vincular a um MIC/DTA
			EMBARQUE_ID.value = p_embarque_id;
			
			document.getElementById('tr_filtro').style.display = 'none';
			document.getElementById('tr_programacao').style.display = 'none';
			document.getElementById('tr_embarque').style.display = '';
			parent.f_show('btn_confirmar');
			
			parent.document.getElementById('btn_voltar').onclick = function () {
				f_mostrar_programacao();
				this.onclick = function () {
					window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent','');
				}
			};
			
			f_readOnly_campos(true);
			f_busca_dados_embarque();
		}
	}
	
	function f_editar_embarque(p_embarque_id) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Editar Embarque
			EMBARQUE_ID.value = p_embarque_id;
			
			document.getElementById('tr_filtro').style.display = 'none';
			document.getElementById('tr_programacao').style.display = 'none';
			document.getElementById('tr_embarque').style.display = '';
			parent.f_show('btn_confirmar');
			
			parent.document.getElementById('btn_voltar').onclick = function () {
				f_mostrar_programacao();
				this.onclick = function () {
					window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent','');
				}
			};
			
			f_readOnly_campos(false);
			f_busca_dados_embarque();
		}
	}
	
	function f_visualizar_ocorrencia_viagem_emb(p_embarque_id, p_programacao_id){
		f_abrir_janela('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/embarque/embarque_resumo.cfm</cf_url>?embarque_id=' + p_embarque_id + '&programacao_id=' + p_programacao_id, '', 640, 480);
	}
	
	function f_excluir_viagem(p_viagem_id) {
		with(document.forms[0]) {
			OPERACAO.value = 6; // Excluir Viagem
			VIAGEM_ID_EXCLUIR.value = p_viagem_id;
			target = 'consultas';
			action = 'confirma.cfm';		
			if(confirm('Para confirmar a excluso da viagem clique em OK.')) {
				submit();
			}
		}
	}
	
	function f_excluir_embarque(p_embarque_id) {
		with(document.forms[0]) {
			OPERACAO.value = 7; // Excluir Embarque
			EMBARQUE_ID.value = p_embarque_id;
			target = 'consultas';
			action = 'confirma.cfm';		
			if(confirm('Para confirmar a excluso do embarque clique em OK.')) {
				submit();
			}
		}
	}
	
	function f_visualizar_resumo_programacao(p_programacao_id, p_consolidada, p_programacao_id_vinculo) {
		if(p_consolidada == 1) {
			f_abrir_janela('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/embarque/programacao_resumo.cfm</cf_url>?programacao_id=' + p_programacao_id_vinculo, '', 640, 480);
		}
		else {
			f_abrir_janela('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/embarque/programacao_resumo.cfm</cf_url>?programacao_id=' + p_programacao_id, '', 640, 480);
		}
	}
	
	function f_inserir_anexo(p_docto_id, p_tipo) {
		// Programao
		if(p_tipo == 0) {
			f_abrir_janela('<cf_url>/aplicacoes/transporte_internacional/anexos/principal.cfm</cf_url>?programacao_id=' + p_docto_id + '&funcao_end=f_incluir()', '', 640, 480);
		}
		// Embarque
		else if(p_tipo == 1) {
			f_abrir_janela('<cf_url>/aplicacoes/transporte_internacional/anexos/principal.cfm</cf_url>?embarque_id=' + p_docto_id + '&funcao_end=f_incluir()', '', 640, 480);
		}
	}
	
	function f_visualizar_anexo(p_docto_id, p_tipo) {
		// Programao
		if(p_tipo == 0) {
			f_abrir_janela('<cf_url>/aplicacoes/transporte_internacional/anexos/visualizar.cfm</cf_url>?programacao_id=' + p_docto_id, '', 640, 480);
		}
		// Embarque
		if(p_tipo == 1) {
			f_abrir_janela('<cf_url>/aplicacoes/transporte_internacional/anexos/visualizar.cfm</cf_url>?embarque_id=' + p_docto_id, '', 640, 480);
		}
	}
	
	function f_mostrar_viagens(p_programacao_id) {
		document.getElementById('BTN_MOSTRAR_VIAGENS_' + p_programacao_id).style.display = 'none';
		document.getElementById('BTN_OCULTAR_VIAGENS_' + p_programacao_id).style.display = '';
		
		document.getElementById('tr_programacao_' + p_programacao_id).style.display = '';
	}
	
	function f_ocultar_viagens(p_programacao_id) {
		document.getElementById('BTN_MOSTRAR_VIAGENS_' + p_programacao_id).style.display = '';
		document.getElementById('BTN_OCULTAR_VIAGENS_' + p_programacao_id).style.display = 'none';
		
		document.getElementById('tr_programacao_' + p_programacao_id).style.display = 'none';
	}
	
	function f_mostrar_programacao() {
		document.getElementById('tr_filtro').style.display = '';
		document.getElementById('tr_programacao').style.display = '';
		document.getElementById('tr_embarque').style.display = 'none';
		parent.f_hidden('btn_confirmar');
		f_limpar_campos();
	}
	
	function f_busca_dados_embarque(p_opcao) {
		with(document.forms[0]) {
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_transp_internacional.cfc</cf_url>?method=get_intc_embarque'
						,'embarque_id=' + EMBARQUE_ID.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.embarque_id.length > 0) {
									var v_option;
									
									for(var i = VIAGEM_ID.options.length - 1; i >= 0; i--) {
										VIAGEM_ID.options[i] = null;
									}
									v_option = f_cria_option(obj.struct.viagem_id[0], 'N ' + obj.struct.num_viagem[0] + ' - ' + obj.struct.data_saida_viagem[0], VIAGEM_ID);
									v_option.setAttribute('possui_embarque', '1');
									VIAGEM_ID.value = obj.struct.viagem_id[0];
									
									for(var i = MANIFESTO_ID.options.length - 1; i >= 0; i--) {
										MANIFESTO_ID.options[i] = null;
									}
									
									// Vincular a um CRT
									if(OPERACAO.value == 3) {
										NUM_CONHECIMENTO.value = '';
										CONHECIMENTO_ID.value = '';
										
										v_option = f_cria_option('', '-- Informe um CRT --', MANIFESTO_ID);
										v_option.setAttribute('cod_motorista', '');
										v_option.setAttribute('cod_funcionario', '');
										v_option.setAttribute('nome_motorista', '');
										v_option.setAttribute('cod_veiculo_cavalo', '');
										v_option.setAttribute('placa_cavalo', '');
										v_option.setAttribute('cod_veiculo_carreta', '');
										v_option.setAttribute('placa_carreta', '');
										MANIFESTO_ID.value = '';
									}
									// Vincular a um MIC/DTA
									else if(OPERACAO.value == 4) {
										NUM_CONHECIMENTO.value = obj.struct.num_conhecimento[0];
										CONHECIMENTO_ID.value = obj.struct.conhecimento_id[0];
										f_busca_manifestos(null);
									}
									// Editar Embarque
									else if(OPERACAO.value == 5) {										
										NUM_CONHECIMENTO.value = obj.struct.num_conhecimento[0];
										CONHECIMENTO_ID.value = obj.struct.conhecimento_id[0];
										f_busca_manifestos(obj.struct.manifesto_id[0]);
									}
									
									COD_FUNCIONARIO.value = obj.struct.cod_funcionario_motorista[0];
									NOME_MOTORISTA.value = obj.struct.nome_motorista[0];
									COD_MOTORISTA.value = obj.struct.cod_motorista[0];
									COD_VEICULO_CAVALO.value = obj.struct.cod_veiculo_cavalo[0];
									PLACA_CAVALO.value = obj.struct.placa_cavalo[0];
									COD_VEICULO_CARRETA.value = obj.struct.cod_veiculo_carreta[0];
									PLACA_CARRETA.value = obj.struct.placa_carreta[0];
									DATA_SAIDA.value = obj.struct.data_saida[0];
									PREVISAO_CHEGADA_FRONTEIRA.value = obj.struct.previsao_chegada_fronteira[0];
									FRONTEIRA_ID.value = obj.struct.fronteira_id[0];
									CNPJ_CPF_DESPACHANTE_ORIGEM.value = obj.struct.cnpj_cpf_despachante_origem[0];
									DESPACHANTE_ORIGEM.value = obj.struct.despachante_origem[0];
									COD_DESPACHANTE_ORIGEM.value = obj.struct.cod_despachante_origem[0];
									CNPJ_CPF_DESPACHANTE_DESTINO.value = obj.struct.cnpj_cpf_despachante_destino[0];
									DESPACHANTE_DESTINO.value = obj.struct.despachante_destino[0];
									COD_DESPACHANTE_DESTINO.value = obj.struct.cod_despachante_destino[0];
									FACTURA.value = obj.struct.factura[0];
									SD.value = obj.struct.sd[0];
									TRAS.value = obj.struct.tras[0];
									PE.value = obj.struct.pe[0];
									DI.value = obj.struct.di[0];
									DTA.value = obj.struct.dta[0];
									TRANSBORDO.value = obj.struct.transbordo[0];
									LOCAL_TRANSBORDO_ID.value = obj.struct.local_transbordo_id[0];
									DATA_CARGA_TRANSBORDO.value = obj.struct.data_carga_transbordo[0];
									DATA_DESCARGA_TRANSBORDO.value = obj.struct.data_descarga_transbordo[0];
									COD_VEICULO_CAVALO_TRANSBORDO.value = obj.struct.cod_veiculo_cavalo_transbordo[0];
									PLACA_CAVALO_TRANSBORDO.value = obj.struct.placa_cavalo_transbordo[0];
									COD_VEICULO_CARRETA_TRANSBORDO.value = obj.struct.cod_veiculo_carreta_transbordo[0];
									PLACA_CARRETA_TRANSBORDO.value = obj.struct.placa_carreta_transbordo[0];
									OBSERVACAO.value = obj.struct.observacao[0];
									
									// Editar Embarque
									if(OPERACAO.value == 5) {
										if(obj.struct.dta[0] == 1) {
											TRANSBORDO.disabled = true;
										}
										else {
											TRANSBORDO.disabled = false;
										}
										
										f_muda_transbordo(0);
									}
								}
								else {
									alert('Embarque no encontrado.');
									parent.document.getElementById('btn_voltar').onclick();
								}
							}
						});
		}
	}
	
	function f_busca_viagens(p_programacao_id, p_consolidada) {
		with(document.forms[0]) {
			var v_option;
			
			for(var i = VIAGEM_ID.options.length - 1; i >= 0; i--) {
				VIAGEM_ID.options[i] = null;
			}
			
			if(p_consolidada == 1) {
				f_query_wddx('<cf_url>/_transportes/consulta/cfc_transp_internacional.cfc</cf_url>?method=get_intc_viagem'
							,'programacao_id=' + p_programacao_id +
							'&abertas=1'
							,function(obj) {
								if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
									if(obj.struct.viagem_id.length > 0) {
										for(var i = 0; i < obj.struct.viagem_id.length; i++) {
											v_option = f_cria_option(obj.struct.viagem_id[i], 'N ' + obj.struct.num_viagem[i] + ' - ' + obj.struct.data_saida[i], VIAGEM_ID);
											v_option.setAttribute('possui_embarque', obj.struct.possui_embarque[i]);
										}
										
										f_busca_dados_pre_definidos();
									}
									else {
										alert('A programao de carga a qual esta  consolidada no possui viagens.');
										parent.document.getElementById('btn_voltar').onclick();
									}
								}
							});
			}
			else {
				v_option = f_cria_option('', '- Nova Viagem --', VIAGEM_ID);
				v_option.setAttribute('possui_embarque', 0);
			}
		}
	}
	
	function f_busca_fronteira_programacao(p_programacao_id) {
		with(document.forms[0]) {
			FRONTEIRA_ID.value = '';
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_transp_internacional.cfc</cf_url>?method=get_intc_programacao'
						,'programacao_id=' + p_programacao_id
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.programacao_id.length > 0) {
									FRONTEIRA_ID.value = obj.struct.fronteira_id[0];
								}
							}
						});
		}
	}
	
	function f_busca_dados_pre_definidos() {
		with(document.forms[0]) {
			COD_FUNCIONARIO.value = '';
			NOME_MOTORISTA.value = '';
			COD_MOTORISTA.value = '';
			COD_VEICULO_CAVALO.value = '';
			PLACA_CAVALO.value = '';
			COD_VEICULO_CARRETA.value = '';
			PLACA_CARRETA.value = '';
			DATA_SAIDA.value = '';
			PREVISAO_CHEGADA_FRONTEIRA.value = '';
			CNPJ_CPF_DESPACHANTE_ORIGEM.value = '';
			DESPACHANTE_ORIGEM.value = '';
			COD_DESPACHANTE_ORIGEM.value = '';
			CNPJ_CPF_DESPACHANTE_DESTINO.value = '';
			DESPACHANTE_DESTINO.value = '';
			COD_DESPACHANTE_DESTINO.value = '';
			SD.value = '';
			TRAS.value = '';
			PE.value = '';
			DI.value = '';
			DTA.value = 0;
			OBSERVACAO.value = '';
			
			if((!VIAGEM_ID.value) || (Number(VIAGEM_ID.options[VIAGEM_ID.selectedIndex].getAttribute('possui_embarque').toString()) == 0)) {
				f_muda_dta();
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_transp_internacional.cfc</cf_url>?method=get_intc_embarque'
						,'viagem_id=' + VIAGEM_ID.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.embarque_id.length > 0) {
									COD_FUNCIONARIO.value = obj.struct.cod_funcionario_motorista[0];
									NOME_MOTORISTA.value = obj.struct.nome_motorista[0];
									COD_MOTORISTA.value = obj.struct.cod_motorista[0];
									COD_VEICULO_CAVALO.value = obj.struct.cod_veiculo_cavalo[0];
									PLACA_CAVALO.value = obj.struct.placa_cavalo[0];
									COD_VEICULO_CARRETA.value = obj.struct.cod_veiculo_carreta[0];
									PLACA_CARRETA.value = obj.struct.placa_carreta[0];
									DATA_SAIDA.value = obj.struct.data_saida[0];
									PREVISAO_CHEGADA_FRONTEIRA.value = obj.struct.previsao_chegada_fronteira[0];
									CNPJ_CPF_DESPACHANTE_ORIGEM.value = obj.struct.cnpj_cpf_despachante_origem[0];
									DESPACHANTE_ORIGEM.value = obj.struct.despachante_origem[0];
									COD_DESPACHANTE_ORIGEM.value = obj.struct.cod_despachante_origem[0];
									CNPJ_CPF_DESPACHANTE_DESTINO.value = obj.struct.cnpj_cpf_despachante_destino[0];
									DESPACHANTE_DESTINO.value = obj.struct.despachante_destino[0];
									COD_DESPACHANTE_DESTINO.value = obj.struct.cod_despachante_destino[0];
									SD.value = obj.struct.sd[0];
									TRAS.value = obj.struct.tras[0];
									PE.value = obj.struct.pe[0];
									DI.value = obj.struct.di[0];
									DTA.value = obj.struct.dta[0];
									
									if(obj.struct.dta[0] == 1) {
										TRANSBORDO.disabled = true;
										TRANSBORDO.value = 0;
										
										f_muda_transbordo(1);
									}
									else {
										TRANSBORDO.disabled = false;
										TRANSBORDO.value = obj.struct.transbordo[0];
										
										if(obj.struct.transbordo[0] == 1) {
											LOCAL_TRANSBORDO_ID.value = obj.struct.local_transbordo_id[0];
											DATA_CARGA_TRANSBORDO.value = obj.struct.data_carga_transbordo[0];
											DATA_DESCARGA_TRANSBORDO.value = obj.struct.data_descarga_transbordo[0];
											COD_VEICULO_CAVALO_TRANSBORDO.value = obj.struct.cod_veiculo_cavalo_transbordo[0];
											PLACA_CAVALO_TRANSBORDO.value = obj.struct.placa_cavalo_transbordo[0];
											COD_VEICULO_CARRETA_TRANSBORDO.value = obj.struct.cod_veiculo_carreta_transbordo[0];
											PLACA_CARRETA_TRANSBORDO.value = obj.struct.placa_carreta_transbordo[0];
											
											f_muda_transbordo(0);
										}
										else {
											f_muda_transbordo(1);
										}
									}
									
									OBSERVACAO.value = obj.struct.observacao[0];
								}
								else {
									f_muda_dta();
								}
							}
						});
		}
	}
	
	function f_busca_conhecimento() {
		with(document.forms[0]) {
			var v_option;
			
			CONHECIMENTO_ID.value = '';
			for(var i = MANIFESTO_ID.options.length - 1; i >= 0; i--) {
				MANIFESTO_ID.options[i] = null;
			}
			
			if(!NUM_CONHECIMENTO.value) {
				v_option = f_cria_option('', '-- Informe um CRT --', MANIFESTO_ID);
				v_option.setAttribute('cod_motorista', '');
				v_option.setAttribute('cod_funcionario', '');
				v_option.setAttribute('nome_motorista', '');
				v_option.setAttribute('cod_veiculo_cavalo', '');
				v_option.setAttribute('placa_cavalo', '');
				v_option.setAttribute('cod_veiculo_carreta', '');
				v_option.setAttribute('placa_carreta', '');
				
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_transp_internacional.cfc</cf_url>?method=get_intc_conhecimento'
						,'numero=' + NUM_CONHECIMENTO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.conhecimento_id.length > 0) {
									CONHECIMENTO_ID.value = obj.struct.conhecimento_id[0];
									
									// Inserir Embarque
									if(OPERACAO.value == 2) {
										FACTURA.value = obj.struct.num_fatura[0];
									}
									// Editar Embarque
									else if(OPERACAO.value == 5) {
										if(confirm('Para alterar a factura de acordo com o CRT clique em OK.')) {
											FACTURA.value = obj.struct.num_fatura[0];
										}
									}
									
									f_busca_manifestos(null);
								}
								else {
									v_option = f_cria_option('', '-- Informe um CRT --', MANIFESTO_ID);
									v_option.setAttribute('cod_motorista', '');
									v_option.setAttribute('cod_funcionario', '');
									v_option.setAttribute('nome_motorista', '');
									v_option.setAttribute('cod_veiculo_cavalo', '');
									v_option.setAttribute('placa_cavalo', '');
									v_option.setAttribute('cod_veiculo_carreta', '');
									v_option.setAttribute('placa_carreta', '');
									
									alert('CRT no encontrado.');
									NUM_CONHECIMENTO.focus();
								}
							}
						});
		}
	}
	
	function f_busca_manifestos(p_manifesto_id) {
		with(document.forms[0]) {
			var v_filtro;
			var v_option;
			
			if(!CONHECIMENTO_ID.value) {
				v_option = f_cria_option('', '-- Informe um CRT --', MANIFESTO_ID);
				v_option.setAttribute('cod_motorista', '');
				v_option.setAttribute('cod_funcionario', '');
				v_option.setAttribute('nome_motorista', '');
				v_option.setAttribute('cod_veiculo_cavalo', '');
				v_option.setAttribute('placa_cavalo', '');
				v_option.setAttribute('cod_veiculo_carreta', '');
				v_option.setAttribute('placa_carreta', '');
				
				return;
			}
			
			if(p_manifesto_id != null && p_manifesto_id != '') {
				v_filtro = 'conhecimento_id=' + CONHECIMENTO_ID.value + '&manifesto_id=' + p_manifesto_id + '&somente_nao_embarcados=1&multipla_consulta=1';
			}
			else {
				v_filtro = 'conhecimento_id=' + CONHECIMENTO_ID.value + '&somente_nao_embarcados=1&multipla_consulta=0';
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_transp_internacional.cfc</cf_url>?method=get_mic_crt'
						,v_filtro
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.manifesto_id.length > 0) {									
									v_option = f_cria_option('', '-- Selecione --', MANIFESTO_ID);
									v_option.setAttribute('cod_motorista', '');
									v_option.setAttribute('cod_funcionario', '');
									v_option.setAttribute('nome_motorista', '');
									v_option.setAttribute('cod_veiculo_cavalo', '');
									v_option.setAttribute('placa_cavalo', '');
									v_option.setAttribute('cod_veiculo_carreta', '');
									v_option.setAttribute('placa_carreta', '');
									
									for(var i = 0; i < obj.struct.manifesto_id.length; i++) {
										v_option = f_cria_option(obj.struct.manifesto_id[i], obj.struct.numero_mic[i], MANIFESTO_ID);
										v_option.setAttribute('cod_motorista', obj.struct.cod_pessoa_motorista[i]);
										v_option.setAttribute('cod_funcionario', obj.struct.cod_funcionario_motorista[i]);
										v_option.setAttribute('nome_motorista', obj.struct.nome_motorista[i]);
										v_option.setAttribute('cod_veiculo_cavalo', obj.struct.cod_veiculo_controle[i]);
										v_option.setAttribute('placa_cavalo', obj.struct.placa_controle[i]);
										v_option.setAttribute('cod_veiculo_carreta', obj.struct.cod_veiculo_referencia[i]);
										v_option.setAttribute('placa_carreta', obj.struct.placa_referencia[i]);
									}
									
									if(p_manifesto_id != null && p_manifesto_id != '') {
										MANIFESTO_ID.value = p_manifesto_id;
									}
								}
								else {
									v_option = f_cria_option('', '-- Informe um CRT --', MANIFESTO_ID);
									v_option.setAttribute('cod_motorista', '');
									v_option.setAttribute('cod_funcionario', '');
									v_option.setAttribute('nome_motorista', '');
									v_option.setAttribute('cod_veiculo_cavalo', '');
									v_option.setAttribute('placa_cavalo', '');
									v_option.setAttribute('cod_veiculo_carreta', '');
									v_option.setAttribute('placa_carreta', '');
									
									alert('O CRT informado no possui MIC/DTA para serem embarcados.');
									NUM_CONHECIMENTO.focus();
								}
							}
						});
		}
	}
	
	function f_altera_dados_embarque() {
		with(document.forms[0]) {
			// Inserir Embarque
			if(OPERACAO.value == 2) {
				COD_FUNCIONARIO.value = MANIFESTO_ID.options[MANIFESTO_ID.selectedIndex].getAttribute('cod_funcionario').toString();
				NOME_MOTORISTA.value = MANIFESTO_ID.options[MANIFESTO_ID.selectedIndex].getAttribute('nome_motorista').toString();
				COD_MOTORISTA.value = MANIFESTO_ID.options[MANIFESTO_ID.selectedIndex].getAttribute('cod_motorista').toString();
				COD_VEICULO_CAVALO.value = MANIFESTO_ID.options[MANIFESTO_ID.selectedIndex].getAttribute('cod_veiculo_cavalo').toString();
				PLACA_CAVALO.value = MANIFESTO_ID.options[MANIFESTO_ID.selectedIndex].getAttribute('placa_cavalo').toString();
				COD_VEICULO_CARRETA.value = MANIFESTO_ID.options[MANIFESTO_ID.selectedIndex].getAttribute('cod_veiculo_carreta').toString();
				PLACA_CARRETA.value = MANIFESTO_ID.options[MANIFESTO_ID.selectedIndex].getAttribute('placa_carreta').toString();
				
				COD_FUNCIONARIO.readOnly = (MANIFESTO_ID.value) ? true : false;
				COD_VEICULO_CAVALO.readOnly = (MANIFESTO_ID.value) ? true : false;
				COD_VEICULO_CARRETA.readOnly = (MANIFESTO_ID.value) ? true : false;
			}
			// Editar Embarque
			else if(OPERACAO.value == 5) {
				if(confirm('Para alterar os dados de acordo com o MIC/DTA clique em OK.')) {
					COD_FUNCIONARIO.value = MANIFESTO_ID.options[MANIFESTO_ID.selectedIndex].getAttribute('cod_funcionario').toString();
					NOME_MOTORISTA.value = MANIFESTO_ID.options[MANIFESTO_ID.selectedIndex].getAttribute('nome_motorista').toString();
					COD_MOTORISTA.value = MANIFESTO_ID.options[MANIFESTO_ID.selectedIndex].getAttribute('cod_motorista').toString();
					COD_VEICULO_CAVALO.value = MANIFESTO_ID.options[MANIFESTO_ID.selectedIndex].getAttribute('cod_veiculo_cavalo').toString();
					PLACA_CAVALO.value = MANIFESTO_ID.options[MANIFESTO_ID.selectedIndex].getAttribute('placa_cavalo').toString();
					COD_VEICULO_CARRETA.value = MANIFESTO_ID.options[MANIFESTO_ID.selectedIndex].getAttribute('cod_veiculo_carreta').toString();
					PLACA_CARRETA.value = MANIFESTO_ID.options[MANIFESTO_ID.selectedIndex].getAttribute('placa_carreta').toString();
					
					COD_FUNCIONARIO.readOnly = (MANIFESTO_ID.value) ? true : false;
					COD_VEICULO_CAVALO.readOnly = (MANIFESTO_ID.value) ? true : false;
					COD_VEICULO_CARRETA.readOnly = (MANIFESTO_ID.value) ? true : false;
				}
				else {
					COD_FUNCIONARIO.readOnly = false;
					COD_VEICULO_CAVALO.readOnly = false;
					COD_VEICULO_CARRETA.readOnly = false;
				}
			}
		}
	}
	
	function f_busca_motorista(p_opcao) {
		with(document.forms[0]) {
			var v_filtro;
			
			if(p_opcao == 1) {
				NOME_MOTORISTA.value = '';
				COD_MOTORISTA.value = '';				
				if(!COD_FUNCIONARIO.value) {
					return;
				}				
				v_filtro = 'num_modalidade=2,6,8&cod_funcionario=' + COD_FUNCIONARIO.value;
			}
			else if(p_opcao == 2) {
				NOME_MOTORISTA.value = '';
				COD_FUNCIONARIO.value = '';				
				v_filtro = 'num_modalidade=2,6,8&cod_pessoa=' + COD_MOTORISTA.value;
			}
			
			NOME_MOTORISTA.value = 'Buscando motorista...';
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=getPessoa'
						,v_filtro
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.cod_pessoa.length > 0) {
									if(p_opcao == 1) {
										NOME_MOTORISTA.value = obj.struct.cliente[0];
										COD_MOTORISTA.value = obj.struct.cod_pessoa[0];
									}
									else if(p_opcao == 2) {
										NOME_MOTORISTA.value = obj.struct.cliente[0];
										COD_FUNCIONARIO.value = obj.struct.cod_funcionario[0];
									}
								}
								else {
									NOME_MOTORISTA.value = 'Motorista no encontrado.';
								}
							}
						});
		}
	}
	
	function f_busca_placa_tracao() {
		with(document.forms[0]) {
			PLACA_CAVALO.value = '';
			
			if(!COD_VEICULO_CAVALO.value) {
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_veiculo.cfc</cf_url>?method=get_veiculo'
						,'frota=' + COD_VEICULO_CAVALO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.placa.length == 1) {
									PLACA_CAVALO.value = obj.struct.placa[0];
									
									if(Number(obj.struct.tracao[0]) == 1 && Number(obj.struct.articulado[0]) == 0) {
										COD_VEICULO_CARRETA.setAttribute('obrigatorio', 0);
										PLACA_CARRETA.setAttribute('obrigatorio', 0);
									}
									else {
										COD_VEICULO_CARRETA.setAttribute('obrigatorio', 1);
										PLACA_CARRETA.setAttribute('obrigatorio', 1);
									}
								}
								else if(obj.struct.placa.length > 1) {
									var msg;
									msg = 'Foi encontrado mais de um veculo (';
																			  
									for(var i = 0; i < obj.struct.placa.length; i++) {
										msg += obj.struct.placa[i];
										
										if(i != (obj.struct.placa.length - 1)) {
											msg += ' / ';
										}
									}
									
									msg += ').';
									alert(msg);
									COD_VEICULO_CAVALO.focus();
								}
								else {
									alert('Veculo no encontrado.');
									COD_VEICULO_CAVALO.focus();
								}
							}
						});
		}
	}
	
	function f_busca_placa_carreta() {
		with(document.forms[0]) {
			PLACA_CARRETA.value = '';
			
			if(!COD_VEICULO_CARRETA.value) {
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_veiculo.cfc</cf_url>?method=get_veiculo'
						,'frota=' + COD_VEICULO_CARRETA.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.placa.length == 1) {
									PLACA_CARRETA.value = obj.struct.placa[0];
								}
								else if(obj.struct.placa.length > 1) {
									var msg;
									msg = 'Foi encontrado mais de um veculo (';
																			  
									for(var i = 0; i < obj.struct.placa.length; i++) {
										msg += obj.struct.placa[i];
										
										if(i != (obj.struct.placa.length - 1)) {
											msg += ' / ';
										}
									}
									
									msg += ').';
									alert(msg);
									COD_VEICULO_CARRETA.focus();
								}
								else {
									alert('Veculo no encontrado.');
									COD_VEICULO_CARRETA.focus();
								}
							}
						});
		}
	}
	
	function f_busca_despachante_origem() {
		with(document.forms[0]) {
			COD_DESPACHANTE_ORIGEM.value = '';
			DESPACHANTE_ORIGEM.value = '';
			
			if(!CNPJ_CPF_DESPACHANTE_ORIGEM.value) {
				return;
			}
			
			DESPACHANTE_ORIGEM.value = 'Buscando despachante de origem...';
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=getPessoa'
						,'cnpj_cpf=' + CNPJ_CPF_DESPACHANTE_ORIGEM.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.cod_pessoa.length > 0) {
									COD_DESPACHANTE_ORIGEM.value = obj.struct.cod_pessoa[0];
									DESPACHANTE_ORIGEM.value = obj.struct.razao_social[0];
								}
								else {
									DESPACHANTE_ORIGEM.value = 'Despachante de origem no encontrado.'
								}
							}
						});
		}
	}
	
	function f_busca_despachante_destino() {
		with(document.forms[0]) {
			COD_DESPACHANTE_DESTINO.value = '';
			DESPACHANTE_DESTINO.value = '';
			
			if(!CNPJ_CPF_DESPACHANTE_DESTINO.value) {
				return;
			}
			
			DESPACHANTE_DESTINO.value = 'Buscando despachante de destino...';
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=getPessoa'
						,'cnpj_cpf=' + CNPJ_CPF_DESPACHANTE_DESTINO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.cod_pessoa.length > 0) {
									COD_DESPACHANTE_DESTINO.value = obj.struct.cod_pessoa[0];
									DESPACHANTE_DESTINO.value = obj.struct.razao_social[0];
								}
								else {
									DESPACHANTE_DESTINO.value = 'Despachante de destino no encontrado.'
								}
							}
						});
		}
	}
	
	function f_muda_dta() {
		with(document.forms[0]) {
			if(DTA.value == 1) {
				TRANSBORDO.disabled = true;
			}
			else {
				TRANSBORDO.disabled = false;
			}
			
			TRANSBORDO.value = 0;
			f_muda_transbordo(1);
		}
	}
	
	function f_muda_transbordo(p_limpar_campos) {
		with(document.forms[0]) {
			if(TRANSBORDO.value == 1) {
				LOCAL_TRANSBORDO_ID.disabled = false;
				DATA_CARGA_TRANSBORDO.readOnly = false;
				DATA_DESCARGA_TRANSBORDO.readOnly = false;
				COD_VEICULO_CAVALO_TRANSBORDO.readOnly = false;
				COD_VEICULO_CARRETA_TRANSBORDO.readOnly = false;
				
				document.getElementById('BTN_DATA_CARGA_TRANSBORDO').disabled = false;
				document.getElementById('BTN_DATA_DESCARGA_TRANSBORDO').disabled = false;
				document.getElementById('btn_busca_tracao_transbordo').disabled = false;
				document.getElementById('btn_busca_carreta_transbordo').disabled = false;
			}
			else {
				LOCAL_TRANSBORDO_ID.disabled = true;
				DATA_CARGA_TRANSBORDO.readOnly = true;
				DATA_DESCARGA_TRANSBORDO.readOnly = true;
				COD_VEICULO_CAVALO_TRANSBORDO.readOnly = true;
				COD_VEICULO_CARRETA_TRANSBORDO.readOnly = true;
				
				document.getElementById('BTN_DATA_CARGA_TRANSBORDO').disabled = true;
				document.getElementById('BTN_DATA_DESCARGA_TRANSBORDO').disabled = true;
				document.getElementById('btn_busca_tracao_transbordo').disabled = true;
				document.getElementById('btn_busca_carreta_transbordo').disabled = true;
			}
			
			if(p_limpar_campos == 1) {
				LOCAL_TRANSBORDO_ID.value = '';
				DATA_CARGA_TRANSBORDO.value = '';
				DATA_DESCARGA_TRANSBORDO.value = '';
				COD_VEICULO_CAVALO_TRANSBORDO.value = '';
				PLACA_CAVALO_TRANSBORDO.value = '';
				COD_VEICULO_CARRETA_TRANSBORDO.value = '';
				PLACA_CARRETA_TRANSBORDO.value = '';
			}
		}
	}
	
	function f_busca_placa_tracao_transbordo() {
		with(document.forms[0]) {
			PLACA_CAVALO_TRANSBORDO.value = '';
			
			if(!COD_VEICULO_CAVALO_TRANSBORDO.value) {
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_veiculo.cfc</cf_url>?method=get_veiculo'
						,'frota=' + COD_VEICULO_CAVALO_TRANSBORDO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.placa.length == 1) {
									PLACA_CAVALO_TRANSBORDO.value = obj.struct.placa[0];
								}
								else if(obj.struct.placa.length > 1) {
									var msg;
									msg = 'Foi encontrado mais de um veculo (';
																			  
									for(var i = 0; i < obj.struct.placa.length; i++) {
										msg += obj.struct.placa[i];
										
										if(i != (obj.struct.placa.length - 1)) {
											msg += ' / ';
										}
									}
									
									msg += ').';
									alert(msg);
									COD_VEICULO_CAVALO_TRANSBORDO.focus();
								}
								else {
									alert('Veculo no encontrado.');
									COD_VEICULO_CAVALO_TRANSBORDO.focus();
								}
							}
						});
		}
	}
	
	function f_busca_placa_carreta_transbordo() {
		with(document.forms[0]) {
			PLACA_CARRETA_TRANSBORDO.value = '';
			
			if(!COD_VEICULO_CARRETA_TRANSBORDO.value) {
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_veiculo.cfc</cf_url>?method=get_veiculo'
						,'frota=' + COD_VEICULO_CARRETA_TRANSBORDO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.placa.length == 1) {
									PLACA_CARRETA_TRANSBORDO.value = obj.struct.placa[0];
								}
								else if(obj.struct.placa.length > 1) {
									var msg;
									msg = 'Foi encontrado mais de um veculo (';
																			  
									for(var i = 0; i < obj.struct.placa.length; i++) {
										msg += obj.struct.placa[i];
										
										if(i != (obj.struct.placa.length - 1)) {
											msg += ' / ';
										}
									}
									
									msg += ').';
									alert(msg);
									COD_VEICULO_CARRETA_TRANSBORDO.focus();
								}
								else {
									alert('Veculo no encontrado.');
									COD_VEICULO_CARRETA_TRANSBORDO.focus();
								}
							}
						});
		}
	}
	
	function f_readOnly_campos(p_valor) {
		with(document.forms[0]) {
			// Inserir Embarque
			if(OPERACAO.value == 2) {
				VIAGEM_ID.disabled = p_valor;
				NUM_CONHECIMENTO.readOnly = p_valor;
				MANIFESTO_ID.disabled = p_valor;
			}
			// Vincular a um CRT
			else if(OPERACAO.value == 3) {
				VIAGEM_ID.disabled = p_valor;
				NUM_CONHECIMENTO.readOnly = !p_valor;
				MANIFESTO_ID.disabled = !p_valor;
			}
			// Vincular a um MIC/DTA
			else if(OPERACAO.value == 4) {
				VIAGEM_ID.disabled = p_valor;
				NUM_CONHECIMENTO.readOnly = p_valor;
				MANIFESTO_ID.disabled = !p_valor;
			}
			// Editar Embarque
			else if(OPERACAO.value == 5) {
				VIAGEM_ID.disabled = !p_valor;
				NUM_CONHECIMENTO.readOnly = p_valor;
				MANIFESTO_ID.disabled = p_valor;
			}
			
			COD_FUNCIONARIO.readOnly = p_valor;
			COD_VEICULO_CAVALO.readOnly = p_valor;
			COD_VEICULO_CARRETA.readOnly = p_valor;
			DATA_SAIDA.readOnly = p_valor;
			PREVISAO_CHEGADA_FRONTEIRA.readOnly = p_valor;
			FRONTEIRA_ID.disabled = p_valor;
			CNPJ_CPF_DESPACHANTE_ORIGEM.readOnly = p_valor;
			CNPJ_CPF_DESPACHANTE_DESTINO.readOnly = p_valor;
			FACTURA.readOnly = p_valor;
			SD.readOnly = p_valor;
			TRAS.readOnly = p_valor;
			PE.readOnly = p_valor;
			DI.readOnly = p_valor;
			DTA.disabled = p_valor;
			TRANSBORDO.disabled = p_valor;
			LOCAL_TRANSBORDO_ID.disabled = p_valor;
			DATA_CARGA_TRANSBORDO.readOnly = p_valor;
			DATA_DESCARGA_TRANSBORDO.readOnly = p_valor;
			COD_VEICULO_CAVALO_TRANSBORDO.readOnly = p_valor;
			COD_VEICULO_CARRETA_TRANSBORDO.readOnly = p_valor;
			OBSERVACAO.readOnly = p_valor;
			
			document.getElementById('btn_busca_motorista').disabled = p_valor;
			document.getElementById('btn_busca_tracao').disabled = p_valor;
			document.getElementById('btn_busca_carreta').disabled = p_valor;
			document.getElementById('BTN_DATA_SAIDA').disabled = p_valor;
			document.getElementById('BTN_PREVISAO_CHEGADA_FRONTEIRA').disabled = p_valor;
			document.getElementById('btn_busca_despachante_origem').disabled = p_valor;
			document.getElementById('btn_busca_despachante_destino').disabled = p_valor;
			document.getElementById('BTN_DATA_CARGA_TRANSBORDO').disabled = p_valor;
			document.getElementById('BTN_DATA_DESCARGA_TRANSBORDO').disabled = p_valor;
			document.getElementById('btn_busca_tracao_transbordo').disabled = p_valor;
			document.getElementById('btn_busca_carreta_transbordo').disabled = p_valor;
		}
	}
	
	function f_limpar_campos() {
		with(document.forms[0]) {
			var v_option;
			
			for(var i = VIAGEM_ID.options.length - 1; i >= 0; i--) {
				VIAGEM_ID.options[i] = null;
			}
			v_option = f_cria_option('', '- Nova Viagem --', VIAGEM_ID);
			v_option.setAttribute('possui_embarque', 0);
			
			for(var i = MANIFESTO_ID.options.length - 1; i >= 0; i--) {
				MANIFESTO_ID.options[i] = null;
			}
			v_option = f_cria_option('', '-- Informe um CRT --', MANIFESTO_ID);
			v_option.setAttribute('cod_motorista', '');
			v_option.setAttribute('cod_funcionario', '');
			v_option.setAttribute('nome_motorista', '');
			v_option.setAttribute('cod_veiculo_cavalo', '');
			v_option.setAttribute('placa_cavalo', '');
			v_option.setAttribute('cod_veiculo_carreta', '');
			v_option.setAttribute('placa_carreta', '');
			
			VIAGEM_ID.value = '';
			NUM_CONHECIMENTO.value = '';
			CONHECIMENTO_ID.value = '';
			MANIFESTO_ID.value = '';
			COD_FUNCIONARIO.value = '';
			NOME_MOTORISTA.value = '';
			COD_MOTORISTA.value = '';
			COD_VEICULO_CAVALO.value = '';
			PLACA_CAVALO.value = '';
			COD_VEICULO_CARRETA.value = '';
			PLACA_CARRETA.value = '';
			DATA_SAIDA.value = '';
			PREVISAO_CHEGADA_FRONTEIRA.value = '';
			FRONTEIRA_ID.value = '';
			CNPJ_CPF_DESPACHANTE_ORIGEM.value = '';
			DESPACHANTE_ORIGEM.value = '';
			COD_DESPACHANTE_ORIGEM.value = '';
			CNPJ_CPF_DESPACHANTE_DESTINO.value = '';
			DESPACHANTE_DESTINO.value = '';
			COD_DESPACHANTE_DESTINO.value = '';
			FACTURA.value = '';
			SD.value = '';
			TRAS.value = '';
			PE.value = '';
			DI.value = '';
			DTA.value = 0;
			TRANSBORDO.value = 0;
			LOCAL_TRANSBORDO_ID.value = '';
			DATA_CARGA_TRANSBORDO.value = '';
			DATA_DESCARGA_TRANSBORDO.value = '';
			COD_VEICULO_CAVALO_TRANSBORDO.value = '';
			PLACA_CAVALO_TRANSBORDO.value = '';
			COD_VEICULO_CARRETA_TRANSBORDO.value = '';
			PLACA_CARRETA_TRANSBORDO.value = '';
			OBSERVACAO.value = '';
		}
	}
</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KM&amp;M :..</title>
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body class="background" style="height: 100%;">
<table width="100%" border="0" cellspacing="0" cellpadding="0">
	<form id="form_transportes" name="form_transportes" method="get" action="" onSubmit="return f_confirmar()">
        <input type="hidden" name="OPERACAO" id="OPERACAO" value="" sempre_ativo="1" />
        <input type="hidden" name="CONSULTA" id="CONSULTA" value="" sempre_ativo="1" />
        <input type="hidden" name="PROGRAMACAO_ID" id="PROGRAMACAO_ID" value="" sempre_ativo="1" />
        <input type="hidden" name="VIAGEM_ID_EXCLUIR" id="VIAGEM_ID_EXCLUIR" value="" sempre_ativo="1" />
        <input type="hidden" name="EMBARQUE_ID" id="EMBARQUE_ID" value="" sempre_ativo="1" />
        <tr id="tr_filtro">
        	<td>
                <fieldset><legend>Filtro</legend>
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                	<tr>
                    	<td width="1%" nowrap class="texto">Tipo:</td>
                        <td width="99%" class="texto"><select name="TIPO_ID" id="TIPO_ID" display="TIPO" style="width: 105px;">
                            <option value="">-- Ambos --</option>
							<cfoutput query="qrTipo">
                                <option value="#qrTipo.RV_LOW_VALUE#">#qrTipo.RV_ABBREVIATION#</option>
                            </cfoutput>
                            </select>&nbsp;
                            <button type="button" class="botao" onClick="f_buscar_programacao_abertas()"><img src="/_imagens/botoes/16x16/buscar.gif" alt="" title="" width="16" height="16" align="absmiddle">&nbsp;Buscar Programa&ccedil;&otilde;es</button></td>
                    </tr>
				</table>
			</fieldset>
        </tr>
        <cfif IsDefined("qrProgramacao")>
        <tr id="tr_programacao">
            <td>
                <fieldset><legend>Programa&ccedil;&otilde;s de carga em aberto (Selecione aquela que ser&aacute; embarcada)</legend>
                <table width="100%" border="0" cellspacing="1" cellpadding="3">
                    <cfif qrProgramacao.RecordCount gt 0>
                    <tr class="titulo_1">
                    	<td width="1%" nowrap align="center">&nbsp;</td>
                        <td width="1%" nowrap align="center">&nbsp;</td>
                        <td width="1%" nowrap align="center">&nbsp;</td>
                        <td width="1%" nowrap align="center">&nbsp;</td>
                        <td width="1%" nowrap align="center">&nbsp;</td>
                        <td width="1%" nowrap align="center">&nbsp;</td>
                        <td nowrap align="center">CRT</td>
                        <td nowrap align="center">Qtd. Ve&iacute;c.</td>
                        <td nowrap align="center">Embarcados</td>
                        <td nowrap align="center">Tipo</td>
                        <td nowrap align="center">Data</td>
                        <td nowrap align="left">Origem</td>
                        <td nowrap align="left">Destino</td>
                    </tr>
                    <cfoutput query="qrProgramacao" group="PROGRAMACAO_ID">
                    <tr class="linha_2">
                        <td nowrap align="center"><button type="button" id="BTN_MOSTRAR_VIAGENS_#qrProgramacao.PROGRAMACAO_ID#" class="botao-16x16" onClick="f_mostrar_viagens(#JSStringFormat(qrProgramacao.PROGRAMACAO_ID)#)"><img src="/_imagens/botoes/16x16/mostrar.gif" alt="Mostrar Viagens" title="Mostrar Viagens" width="16" height="16" align="absmiddle" /></button>
                        	<button type="button" id="BTN_OCULTAR_VIAGENS_#qrProgramacao.PROGRAMACAO_ID#" class="botao-16x16" onClick="f_ocultar_viagens(#JSStringFormat(qrProgramacao.PROGRAMACAO_ID)#)" style="display: none;"><img src="/_imagens/botoes/16x16/ocultar.gif" alt="Ocultar Viagens" title="Ocultar Viagens" width="16" height="16" align="absmiddle" /></button></td>
                        <td nowrap align="center"><button type="button" class="botao-16x16" onClick="f_embarcar(#JSStringFormat(qrProgramacao.PROGRAMACAO_ID)#, #JSStringFormat(qrProgramacao.CONSOLIDADA)#, '#JSStringFormat(qrProgramacao.PROGRAMACAO_ID_VINCULO)#')"><img src="/_imagens/botoes/16x16/embarcar.gif" alt="Embarcar" title="Embarcar" width="16" height="16" align="absmiddle" /></button></td>
                        <td nowrap align="center"><button type="button" class="botao-16x16" onClick="f_inserir_anexo(#JSStringFormat(qrProgramacao.PROGRAMACAO_ID)#, 0)"><img src="/_imagens/botoes/16x16/anexos.gif" alt="Inserir Anexo" title="Inserir Anexo" width="16" height="16" align="absmiddle" /></button></td>
                        <td nowrap align="center"><cfif qrProgramacao.QTE_PROGRAMACAO_ANEXOS gt 0><button type="button" class="botao-16x16" onClick="f_visualizar_anexo(#JSStringFormat(qrProgramacao.PROGRAMACAO_ID)#, 0)"><img src="/_imagens/botoes/16x16/visualizar_anexo.gif" alt="Visualizar Anexos" title="Visualizar Anexos" width="16" height="16" align="absmiddle" /></button><cfelse>&nbsp;</cfif></td>
                        <td nowrap align="center"><cfif Len(Trim(qrProgramacao.OBSERVACAO_PROGRAMACAO))><img src="/_imagens/botoes/16x16/ajuda.gif" alt="#qrProgramacao.OBSERVACAO_PROGRAMACAO#" title="#qrProgramacao.OBSERVACAO_PROGRAMACAO#" width="16" height="16" align="absmiddle" /><cfelse>&nbsp;</cfif></td>
                        <td nowrap align="center"><button type="button" class="botao-16x16" onClick="f_visualizar_resumo_programacao(#JSStringFormat(qrProgramacao.PROGRAMACAO_ID)#, #JSStringFormat(qrProgramacao.CONSOLIDADA)#, '#JSStringFormat(qrProgramacao.PROGRAMACAO_ID_VINCULO)#')"><img src="/_imagens/botoes/16x16/visualizar.gif" alt="Visualizar Resumo" title="Visualizar Resumo" width="16" height="16" align="absmiddle" /></button></td>                                              
                        <td nowrap align="center">#qrProgramacao.CRT_PROGRAMACAO#</td>
                        <td nowrap align="center">#qrProgramacao.QUANTIDADE_VEICULOS#</td>
                        <td nowrap align="center">#qrProgramacao.QTDE_VEICULOS_EMBARCADOS#</td>
                        <td nowrap align="center">#qrProgramacao.TIPO#</td>
                        <td nowrap align="center">#qrProgramacao.DATA_PROGRAMACAO#</td>
                        <td nowrap align="left">#qrProgramacao.ORIGEM#</td>
                        <td nowrap align="left">#qrProgramacao.DESTINO#</td>
                    </tr>
                    <tr id="tr_programacao_#qrProgramacao.PROGRAMACAO_ID#" style="display: none;">
                    	<td colspan="14">
                        	<table width="100%" border="0" cellspacing="1" cellpadding="3">
                            	<tr class="titulo_1">
                                    <td width="1%" nowrap align="center">&nbsp;</td>
                                    <td width="1%" nowrap align="center">&nbsp;</td>
                                    <td width="1%" nowrap align="center">&nbsp;</td>
                                    <td width="1%" nowrap align="center">&nbsp;</td>
                                    <td width="1%" nowrap align="center">&nbsp;</td>
                                    <td width="1%" nowrap align="center">&nbsp;</td>
                                    <td nowrap align="center">CRT</td>
                                    <td nowrap align="center">MIC/DTA</td>
                                    <td nowrap align="left">Motorista</td>
                                    <td nowrap align="center">Tra&ccedil;&atilde;o</td>
                                    <td nowrap align="center">Reboque</td>
                                    <td nowrap align="center">Data de Sa&iacute;da</td>
                                    <td nowrap align="center">Prev. Cheg. na Fronteira</td>
                                    <td nowrap align="left">Fronteira</td>
                                    <td nowrap align="center">DTA?</td>
                                    <td nowrap align="center">Possui Transbordo?</td>
                                    <td nowrap align="center">Consolidada?</td>
                                    <td nowrap align="center">N&deg; Viagem</td>
                                </tr>
								<cfoutput>
									<cfif Len(Trim(qrProgramacao.EMBARQUE_ID))>
                                        <tr id="tr_viagem_#qrProgramacao.PROGRAMACAO_ID#_#qrProgramacao.VIAGEM_ID#" class="linha_2">											
                                            <td nowrap align="center"><button type="button" class="botao-16x16" onClick="f_editar_embarque(#JSStringFormat(qrProgramacao.EMBARQUE_ID)#)"><img src="/_imagens/botoes/16x16/editar.gif" alt="Editar Embarque" title="Editar Embarque" width="16" height="16" align="absmiddle" /></button></td>
                                            <td nowrap align="center"><button type="button" class="botao-16x16" onClick="f_inserir_anexo(#JSStringFormat(qrProgramacao.EMBARQUE_ID)#, 1)"><img src="/_imagens/botoes/16x16/anexos.gif" alt="Inserir Anexo" title="Inserir Anexo" width="16" height="16" align="absmiddle" /></button></td>
                                            <td nowrap align="center"><cfif qrProgramacao.QTDE_EMBARQUE_ANEXOS gt 0><button type="button" class="botao-16x16" onClick="f_visualizar_anexo(#JSStringFormat(qrProgramacao.EMBARQUE_ID)#, 1)"><img src="/_imagens/botoes/16x16/visualizar_anexo.gif" alt="Visualizar Anexos" title="Visualizar Anexos" width="16" height="16" align="absmiddle" /></button><cfelse>&nbsp;</cfif></td>
                                            <td nowrap align="center"><button type="button" class="botao-16x16" onClick="f_excluir_embarque(#JSStringFormat(qrProgramacao.EMBARQUE_ID)#)"><img src="/_imagens/botoes/16x16/cancelar.gif" alt="Excluir Embarque" title="Excluir Embarque" width="16" height="16" align="absmiddle" /></button></td>
                                            <td nowrap align="center"><button type="button" class="botao-16x16" onClick="f_visualizar_ocorrencia_viagem_emb(#JSStringFormat(qrProgramacao.EMBARQUE_ID)#,#JSStringFormat(qrProgramacao.PROGRAMACAO_ID)#)"><img src="/_imagens/botoes/16x16/visualizar.gif" alt="Visualizar Ocorrencia" title="Visualizar Ocorrencia" width="16" height="16" align="absmiddle" /></button></td>
                                            <td nowrap align="center"><cfif Len(Trim(qrProgramacao.OBSERVACAO_EMBARQUE))><img src="/_imagens/botoes/16x16/ajuda.gif" alt="#qrProgramacao.OBSERVACAO_EMBARQUE#" title="#qrProgramacao.OBSERVACAO_EMBARQUE#" width="16" height="16" align="absmiddle" /><cfelse>&nbsp;</cfif></td> 
                                            <td nowrap align="center"><cfif Len(Trim(qrProgramacao.CONHECIMENTO_ID))>#qrProgramacao.NUM_CONHECIMENTO#<cfelse><button type="button" class="botao-16x16" onClick="f_vincular_conhecimento(#JSStringFormat(qrProgramacao.EMBARQUE_ID)#)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a um CRT" title="Vincular a um CRT" width="16" height="16" align="absmiddle" /></button></cfif></td>
                                            <td nowrap align="center"><cfif Len(Trim(qrProgramacao.MANIFESTO_ID))>#qrProgramacao.NUM_MANIFESTO#<cfelse><button type="button" class="botao-16x16" onClick="f_vincular_manifesto(#JSStringFormat(qrProgramacao.EMBARQUE_ID)#)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a um MIC/DTA" title="Vincular a um MIC/DTA" width="16" height="16" align="absmiddle" /></button></cfif></td>
                                            <td nowrap align="left">#qrProgramacao.NOME_MOTORISTA#</td>
                                            <td nowrap align="center">#qrProgramacao.COD_VEICULO_CAVALO#</td>
                                            <td nowrap align="center">#qrProgramacao.COD_VEICULO_CARRETA#</td>
                                            <td nowrap align="center">#qrProgramacao.DATA_SAIDA_EMBARQUE#</td>
                                            <td nowrap align="center">#qrProgramacao.PREVISAO_CHEGADA_FRONTEIRA#</td>
                                            <td nowrap align="left">#qrProgramacao.FRONTEIRA#</td>
                                            <td nowrap align="center">#qrProgramacao.DTA_DESC#</td>
                                            <td nowrap align="center">#qrProgramacao.TRANSBORDO_DESC#</td>
                                            <td nowrap align="center">#qrProgramacao.CONSOLIDADA_DESC#</td>
                                            <td nowrap align="center">#qrProgramacao.NUM_VIAGEM#</td>
                                        </tr>
                                    </cfif>
                                </cfoutput>
							</table>
						</td>
                    </tr>
                    </cfoutput>
                    <cfelse>
                    <tr style="padding-top: 15px;">
                        <td align="center" valign="middle" class="obrigatorio">Nenhuma programa&ccedil;&atilde;o de carga em aberto encontrada.</td>
                    </tr>
                    </cfif>
                </table>
                </fieldset>
            </td>
        </tr>
        <tr id="tr_embarque" style="display: none;">
            <td>
                <fieldset><legend>Dados</legend>
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                	<tr>
                    	<td width="1%" nowrap class="texto">Vincular  viagem:</td>
                        <td width="99%" class="texto"><select name="VIAGEM_ID" id="VIAGEM_ID" onChange="f_busca_dados_pre_definidos()" display="VIAGEM">
                            <option value="" possui_embarque="0">-- Nova Viagem --</option>
                            </select></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">CRT:</td>
                        <td class="texto"><input type="text" name="NUM_CONHECIMENTO" id="NUM_CONHECIMENTO" maxlength="13" display="CRT" onChange="f_busca_conhecimento()" onKeyPress="return f_formata(this, 'AA.000.000000')" style="width: 95px;" />
                        	<input type="hidden" name="CONHECIMENTO_ID" id="CONHECIMENTO_ID" display="CRT" /></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">MIC/DTA:</td>
                        <td class="texto"><select name="MANIFESTO_ID" id="MANIFESTO_ID" display="MIC/DTA" onChange="f_altera_dados_embarque()" style="width: 220px;">
                            <option value="" cod_funcionario="" nome_motorista="" cod_motorista="" cod_veiculo_cavalo="" placa_cavalo="" cod_veiculo_carreta="" placa_carreta="">-- Informe um CRT --</option>
                            </select></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">Motorista:</td>
                        <td class="texto"><input type="text" name="COD_FUNCIONARIO" id="COD_FUNCIONARIO" maxlength="10" display="CD. REGISTRO DO MOTORISTA" onChange="f_busca_motorista(1)" onKeyPress="return f_formata(this, '0000000000')" style="width: 95px;" />
                        	<input type="text" name="NOME_MOTORISTA" id="NOME_MOTORISTA" class="requerido_form" obrigatorio="1" readonly="true" display="MOTORISTA" style="width: 348px;" />
                            <input type="hidden" name="COD_MOTORISTA" id="COD_MOTORISTA" obrigatorio="1" display="MOTORISTA" />
                            <button type="button" id="btn_busca_motorista" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?funcao=f_busca_motorista(2)&field=COD_PESSOA&campo=COD_MOTORISTA&num_modalidade=2,6,8&tipo=2', '_blank', 800, 600, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Motorista" title="Buscar Motorista" width="16" height="16" align="absmiddle" /></button></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">Tra&ccedil;&atilde;o:</td>
                        <td class="texto"><input type="text" name="COD_VEICULO_CAVALO" id="COD_VEICULO_CAVALO" class="requerido_form" maxlength="12" obrigatorio="1" display="FROTA TRAO" onChange="f_busca_placa_tracao()" onKeyPress="return f_formata(this, 'AAAAAAAAAAAA')" style="width: 95px;" />
                        	<input type="text" name="PLACA_CAVALO" id="PLACA_CAVALO" class="requerido_form" obrigatorio="1" readonly="true" display="PLACA TRAO" style="width: 95px;" />&nbsp;
                        	<button type="button" id="btn_busca_tracao" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_veiculo.cfm?cod_veiculo=COD_VEICULO_CAVALO&placa=PLACA_CAVALO', '_blank', 640, 360, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Tra&ccedil;&atilde;o" title="Buscar Tra&ccedil;&atilde;o" width="16" height="16" align="absmiddle" /></button></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">Reboque:</td>
                        <td class="texto"><input type="text" name="COD_VEICULO_CARRETA" id="COD_VEICULO_CARRETA" class="requerido_form" maxlength="12" obrigatorio="1" display="FROTA REBOQUE" onChange="f_busca_placa_carreta()" onKeyPress="return f_formata(this, 'AAAAAAAAAAAA')" style="width: 95px;" />
                        	<input type="text" name="PLACA_CARRETA" id="PLACA_CARRETA" class="requerido_form" obrigatorio="1" readonly="true" display="PLACA REBOQUE" style="width: 95px;" />&nbsp;
                        	<button type="button" id="btn_busca_carreta" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_veiculo.cfm?cod_veiculo=COD_VEICULO_CARRETA&placa=PLACA_CARRETA', '_blank', 640, 360, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Reboque" title="Buscar Reboque" width="16" height="16" align="absmiddle" /></button></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">Programado para:</td>
                        <td class="texto"><input type="text" name="PROGRAMADO_PARA" id="PROGRAMADO_PARA" class="requerido_form" maxlength="16"  tipo="data" display="PROGRAMADO PARA" onKeyPress="return f_formata(this, '00/00/0000 00:00')" style="width: 110px;" />
							<button type="button" id="BTN_PROGRAMADO_PARA" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle" /></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "PROGRAMADO_PARA",     // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M", // the date format
									button      : "BTN_PROGRAMADO_PARA", // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
                            </script></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">Data de Embarque:</td>
                        <td class="texto"><input type="text" name="DATA_SAIDA" id="DATA_SAIDA" class="requerido_form" maxlength="16" obrigatorio="1" tipo="data" display="DATA DE EMBARQUE" onKeyPress="return f_formata(this, '00/00/0000 00:00')" style="width: 110px;" />
							<button type="button" id="BTN_DATA_SAIDA" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle" /></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "DATA_SAIDA",     // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M", // the date format
									button      : "BTN_DATA_SAIDA", // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
                            </script></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">Prev. Chegada na Fronteira:</td>
                        <td class="texto"><input type="text" name="PREVISAO_CHEGADA_FRONTEIRA" id="PREVISAO_CHEGADA_FRONTEIRA" class="requerido_form" maxlength="16" obrigatorio="1" tipo="data" display="PREVIS&Atilde;O DE CHEGADA DE FRONTEIRA" onKeyPress="return f_formata(this, '00/00/0000 00:00')" style="width: 110px;" />
							<button type="button" id="BTN_PREVISAO_CHEGADA_FRONTEIRA" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle" /></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "PREVISAO_CHEGADA_FRONTEIRA",     // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M",                 // the date format
									button      : "BTN_PREVISAO_CHEGADA_FRONTEIRA", // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
                            </script></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">Fronteira:</td>
                        <td class="texto"><select name="FRONTEIRA_ID" id="FRONTEIRA_ID" class="requerido_form" obrigatorio="1" display="FRONTEIRA DE TRANSBORDO" style="width: 220px;">
                            <option value="">-- Selecione --</option>
							<cfoutput query="qrFronteira">
                                <option value="#qrFronteira.FRONTEIRA_ID#">#qrFronteira.DESCRICAO#</option>
                            </cfoutput>
                            </select></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">Despachante de Origem:</td>
                        <td class="texto"><input type="text" name="CNPJ_CPF_DESPACHANTE_ORIGEM" id="CNPJ_CPF_DESPACHANTE_ORIGEM" maxlength="14" tipo="numerico" display="CNPJ/CPF DO DESPACHANTE DE ORIGEM" onChange="f_busca_despachante_origem()" onKeyPress="return f_formata(this, '000000000000000000')" style="width: 110px;" />
                        	<input type="text" name="DESPACHANTE_ORIGEM" id="DESPACHANTE_ORIGEM" readonly="true" display="DESPACHANTE DE ORIGEM" style="width: 333px;" />
                        	<input type="hidden" name="COD_DESPACHANTE_ORIGEM" id="COD_DESPACHANTE_ORIGEM" display="DESPACHANTE DE ORIGEM" />
                            <button type="button" id="btn_busca_despachante_origem" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?field=COD_PESSOA,CNPJ_CPF,RAZAO_SOCIAL&campo=COD_DESPACHANTE_ORIGEM,CNPJ_CPF_DESPACHANTE_ORIGEM,DESPACHANTE_ORIGEM&num_modalidade=19,22', '_blank', 800, 600, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Despachante de Origem" title="Buscar Despachante de Origem" width="16" height="16" align="absmiddle" /></button></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">Despachante de Destino:</td>
                        <td class="texto"><input type="text" name="CNPJ_CPF_DESPACHANTE_DESTINO" id="CNPJ_CPF_DESPACHANTE_DESTINO" maxlength="14" tipo="numerico" display="CNPJ/CPF DO DESPACHANTE DE DESTINO" onChange="f_busca_despachante_destino()" onKeyPress="return f_formata(this, '000000000000000000')" style="width: 110px;" />
                        	<input type="text" name="DESPACHANTE_DESTINO" id="DESPACHANTE_DESTINO" readonly="true" display="DESPACHANTE DE DESTINO" style="width: 333px;" />
                        	<input type="hidden" name="COD_DESPACHANTE_DESTINO" id="COD_DESPACHANTE_DESTINO" display="DESPACHANTE DE DESTINO" />
                            <button type="button" id="btn_busca_despachante_destino" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?field=COD_PESSOA,CNPJ_CPF,RAZAO_SOCIAL&campo=COD_DESPACHANTE_DESTINO,CNPJ_CPF_DESPACHANTE_DESTINO,DESPACHANTE_DESTINO&num_modalidade=19,22', '_blank', 800, 600, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Despachante de Destino" title="Buscar Despachante de Destino" width="16" height="16" align="absmiddle" /></button></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">N&deg; Pedido:</td>
                        <td class="texto"><input type="text" name="NUM_PEDIDO" id="NUM_PEDIDO" maxlength="20" display="SD" style="width: 110px;" /></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">Factura:</td>
                        <td class="texto"><input type="text" name="FACTURA" id="FACTURA" class="requerido_form" maxlength="100" obrigatorio="1" display="FACTURA" style="width: 447px;" /></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">SD:</td>
                        <td class="texto"><input type="text" name="SD" id="SD" maxlength="20" display="SD" onKeyPress="return f_formata(this, 'AAAAAAAAAAAAAAAAAAAA')" style="width: 110px;" /></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">TRAS:</td>
                        <td class="texto"><input type="text" name="TRAS" id="TRAS" maxlength="20" display="TRAS" onKeyPress="return f_formata(this, 'AAAAAAAAAAAAAAAAAAAA')" style="width: 110px;" /></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">PE:</td>
                        <td class="texto"><input type="text" name="PE" id="PE" maxlength="20" display="PE" onKeyPress="return f_formata(this, 'AAAAAAAAAAAAAAAAAAAA')" style="width: 110px;" /></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">DI:</td>
                        <td class="texto"><input type="text" name="DI" id="DI" maxlength="20" display="DI" onKeyPress="return f_formata(this, 'AAAAAAAAAAAAAAAAAAAA')" style="width: 110px;" /></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">DTA:</td>
                        <td class="texto"><select name="DTA" id="DTA" class="requerido_form" obrigatorio="1" display="DTA" onChange="f_muda_dta()" style="width: 50px;">
							<option value="0">N&atilde;o</option>
                            <option value="1">Sim</option>
                            </select></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">Possui Transbordo:</td>
                        <td class="texto"><select name="TRANSBORDO" id="TRANSBORDO" class="requerido_form" obrigatorio="1" display="TRANSBORDO" onChange="f_muda_transbordo(1)" style="width: 50px;">
							<option value="0">N&atilde;o</option>
                            <option value="1">Sim</option>
                            </select></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">Local de Transbordo:</td>
                        <td class="texto"><select name="LOCAL_TRANSBORDO_ID" id="LOCAL_TRANSBORDO_ID" display="LOCAL DE TRANSBORDO" style="width: 220px;">
                            <option value="">-- Selecione --</option>
							<cfoutput query="qrLocalTransbordo">
                                <option value="#qrLocalTransbordo.LOCAL_ID#">#qrLocalTransbordo.DESCRICAO#</option>
                            </cfoutput>
                            </select></td>
                    </tr>
                     <tr>
                    	<td nowrap class="texto">Solicita&ccedil;&atilde;o de cruze:</td>
                        <td class="texto"><input type="text" name="SOLICITACAO_CRUZE" id="SOLICITACAO_CRUZE" maxlength="16" obrigatorio="0" tipo="data" display="SOLICITAO DE CRUZE" onKeyPress="return f_formata(this, '00/00/0000 00:00')" style="width: 110px;" />
							<button type="button" id="BTN_SOLICITACAO_CRUZE" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle" /></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "SOLICITACAO_CRUZE",     // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M",                 // the date format
									button      : "BTN_SOLICITACAO_CRUZE", // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
                            </script></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">Data de Descarga:</td>
                        <td class="texto"><input type="text" name="DATA_DESCARGA_TRANSBORDO" id="DATA_DESCARGA_TRANSBORDO" maxlength="16" tipo="data_hora" display="DATA DE DESCARGA" onKeyPress="return f_formata(this, '00/00/0000 00:00')" style="width: 110px;" />
							<button type="button" id="BTN_DATA_DESCARGA_TRANSBORDO" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle" /></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "DATA_DESCARGA_TRANSBORDO",      // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M",                // the date format
									button      : "BTN_DATA_DESCARGA_TRANSBORDO",  // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
                            </script></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">Data de Reembarque:</td>
                        <td class="texto"><input type="text" name="DATA_CARGA_TRANSBORDO" id="DATA_CARGA_TRANSBORDO" maxlength="16" tipo="data_hora" display="DATA DE REEMBARQUE" onKeyPress="return f_formata(this, '00/00/0000 00:00')" style="width: 110px;" />
							<button type="button" id="BTN_DATA_CARGA_TRANSBORDO" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle" /></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "DATA_CARGA_TRANSBORDO",      // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M",             // the date format
									button      : "BTN_DATA_CARGA_TRANSBORDO",  // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
                            </script></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">Tra&ccedil;&atilde;o de Transbordo:</td>
                        <td class="texto"><input type="text" name="COD_VEICULO_CAVALO_TRANSBORDO" id="COD_VEICULO_CAVALO_TRANSBORDO" maxlength="12" display="FROTA TRAO DE TRANSBORDO" onChange="f_busca_placa_tracao_transbordo()" onKeyPress="return f_formata(this, 'AAAAAAAAAAAA')" style="width: 95px;" />
                        	<input type="text" name="PLACA_CAVALO_TRANSBORDO" id="PLACA_CAVALO_TRANSBORDO" readonly="true" display="PLACA TRAO DE TRANSBORDO" style="width: 95px;" />&nbsp;
                        	<button type="button" id="btn_busca_tracao_transbordo" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_veiculo.cfm?cod_veiculo=COD_VEICULO_CAVALO_TRANSBORDO&placa=PLACA_CAVALO_TRANSBORDO', '_blank', 640, 360, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Tra&ccedil;&atilde;o de Transbordo" title="Buscar Tra&ccedil;&atilde;o de Transbordo" width="16" height="16" align="absmiddle" /></button></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto">Reboque de Transbordo:</td>
                        <td class="texto"><input type="text" name="COD_VEICULO_CARRETA_TRANSBORDO" id="COD_VEICULO_CARRETA_TRANSBORDO" maxlength="12" display="FROTA REBOQUE DE TRANSBORDO" onChange="f_busca_placa_carreta_transbordo()" onKeyPress="return f_formata(this, 'AAAAAAAAAAAA')" style="width: 95px;" />
                        	<input type="text" name="PLACA_CARRETA_TRANSBORDO" id="PLACA_CARRETA_TRANSBORDO" readonly="true" display="PLACA REBOQUE DE TRANSBORDO" style="width: 95px;" />&nbsp;
                        	<button type="button" id="btn_busca_carreta_transbordo" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_veiculo.cfm?cod_veiculo=COD_VEICULO_CARRETA_TRANSBORDO&placa=PLACA_CARRETA_TRANSBORDO', '_blank', 640, 360, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Reboque de Transbordo" title="Buscar Reboque de Transbordo" width="16" height="16" align="absmiddle" /></button></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto" valign="top">Observao:</td>
                        <td class="texto"><textarea name="OBSERVACAO" id="OBSERVACAO" rows="5" display="OBSERVAO" onKeyPress="if(this.value.length >= 1000) { return false; }" style="width: 447px;"></textarea></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto" valign="top">Lista de E-mails:</td>
                        <td class="texto"><textarea name="LISTA_EMAIL" id="LISTA_EMAIL" rows="5" display="LISTA DE E-MAILS" onKeyPress="if(this.value.length >= 1000) { return false; }" style="width: 447px;"><cfoutput>#qrEmail.EMAIL_REGISTRO_EMBARQUE#</cfoutput></textarea></td>
                    </tr>
                </table>
				</fieldset>
            </td>
		</tr>
        </cfif>
	</form>
</table>
</body>
<script type="text/javascript">
	f_hide_carregando();
</script>
</html>
<iframe name="consultas" frameborder="0" width="100%" height="600" src="" style=" display: none;"></iframe>
<cfset RequestEnd = 0>