<cfscript>
	// Verifica se a varivel de controle de fluxo existe
	if((IsDefined("vars.OPERACAO")) and (Len(Trim(vars.OPERACAO)))) {
		conn_manip = CreateComponent("_transportes.manipulacao.cfc_transp_internacional");
		switch(val(vars.OPERACAO)) {   	 
			case 2:
				set_manipulacao = conn_manip.ins_viagem_embarque(argumentCollection = vars); // Inserir Embarque
				break;
			case 3:
				set_manipulacao = conn_manip.viagem_embarque_crt(embarque_id = vars.EMBARQUE_ID, conhecimento_id = vars.CONHECIMENTO_ID, manifesto_id = vars.MANIFESTO_ID); // Vincular a um CRT
				break;
			case 4:
				set_manipulacao = conn_manip.viagem_embarque_mic(embarque_id = vars.EMBARQUE_ID, manifesto_id = vars.MANIFESTO_ID); // Vincular a um MIC/DTA
				break;
			case 5:
				set_manipulacao = conn_manip.upd_viagem_embarque(argumentCollection = vars); // Editar Embarque
				break;
			case 6:
				set_manipulacao = conn_manip.del_viagem(viagem_id = vars.VIAGEM_ID_EXCLUIR); // Excluir Viagem
				break;
			case 7:
				set_manipulacao = conn_manip.del_viagem_embarque(embarque_id = vars.EMBARQUE_ID); // Excluir Embarque
				break;
		}
		
		fnc_trata_erros(struct_erro = set_manipulacao);
	}
</cfscript>
<script type="text/javascript">
	with(parent.document.forms[0]) {
		<cfif (IsDefined("vars.ATUALIZA_COMBO")) and (Len(Trim(vars.ATUALIZA_COMBO)))>
			window.onload = function() {
				<cfoutput>
					#vars.ATUALIZA_COMBO#;
					top.window.close();
				</cfoutput>
			}	
		<cfelse>
			parent.f_atualizar();
		</cfif>
	}
</script>