<html>
<cfinclude template="/_scripts/scripts.cfm" />
<cfinclude template="/_include/carregando.cfm" />
<script src="/_scripts/dragdrop.js" type="text/javascript"></script>
<cfscript>
	if(IsDefined("vars.NUM_VIAGEM")){
		conn = CreateComponent("_transportes.consulta.cfc_transp_internacional");
		qrEmbarque = conn.intc_viagem_embarque_dados(argumentCollection = vars);
    }
	conn       = CreateComponent("_transportes.consulta.cfc_global");
	qrSituacao = conn.get_cg_ref_codes(rv_domain = 'INTC_PROGRAMACAO.SITUACAO_ID', owner = 'OPER');
	qrTipo     = conn.get_cg_ref_codes(rv_domain = 'INTC_PROGRAMACAO.TIPO_ID', owner = 'OPER');
</cfscript>
<script type="text/javascript">
	// Configura botoes //
	parent.f_set_texto('titulo_aplicacao', 'Transporte Internacional');
	parent.f_set_texto('titulo_pagina', 'Controle de Viagens');
	
	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); } 
	
	parent.f_hidden('btn_incluir');
	parent.f_hidden('btn_editar');
	parent.f_hidden('btn_excluir');
	parent.f_hidden('btn_cancelar');
	parent.f_hidden('btn_confirmar');
	
	// -------------------- //
	
	function f_confirmar() {
		with(document.forms[0]) {
			target = 'consultas';
			action = 'confirma.cfm';
			if(f_verifica_form(document.forms[0])) {
				submit();
			}
		}
		return false;
	}
	parent.f_confirmar = f_confirmar;
	
	function f_mostrar_div() {
		f_ocultar_div();
		
		obj = document.getElementById('div_manipulacao');
		f_get_scroll();
		
		if(obj.style.display == 'none') {
			setTimeout("document.getElementById('div_manipulacao').style.display = '';", 100);
			obj.style.top  = 10 + window.event.clientY + scrOfY;
			obj.style.left = 20 + scrOfX;
		}
	}
	
	function f_ocultar_div() {
		document.getElementById('div_manipulacao').style.display = 'none';
		
		document.getElementById('lb_manipulacao').innerHTML = '';
		document.getElementById('td_manipulacao').innerHTML = '';
	}
	
	function f_imprimir_embarque(p_embarque_id) {
		NewWindow('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/print.cfm</cf_url>?embarque_id=' + p_embarque_id, 'Embarque', 800, 600, 'yes');
	}
	
	function f_inserir_anexo(p_embarque_id) {
		f_abrir_janela('<cf_url>/aplicacoes/transporte_internacional/anexos/principal.cfm</cf_url>?embarque_id=' + p_embarque_id + '&funcao_end=f_incluir()', '', 640, 480);
	}
	
	function f_visualizar_anexo(p_embarque_id) {
		f_abrir_janela('<cf_url>/aplicacoes/transporte_internacional/anexos/visualizar.cfm</cf_url>?embarque_id=' + p_embarque_id, '', 640, 480);
	}
	
	function f_finalizar_embarque(p_embarque_id) {
		with(document.forms[0]) {
			OPERACAO.value = 2; // Finalizar Embarque
			EMBARQUE_ID.value = p_embarque_id;
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Finalizar Embarque';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=2'
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
						
						if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
							try {
								Calendar.setup( {
											inputField  : "DATA_TERMINO",      // ID of the input field
											ifFormat    : "%d/%m/%Y %H:%M",    // the date format
											button      : "BTN_DATA_TERMINO",  // ID of the button
											range       : [2001,2050],
											showsTime   : true
										} );
							} catch(e) {}
						}
					});
		}
	}
	
	function f_vincular_conhecimento(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 3; // Vincular a um CRT
			EMBARQUE_ID.value = p_embarque_id;
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a um CRT';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=3' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
					});
		}
	}
	
	function f_vincular_manifesto(p_embarque_id, p_conhecimento_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 4; // Vincular a um MIC/DTA
			EMBARQUE_ID.value = p_embarque_id;
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a um MIC/DTA';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=4' +
					'&conhecimento_id=' + p_conhecimento_id +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
					});
		}
	}
	
	function f_vincular_despachante_origem(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a um Despachante de Origem
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'COD_DESPACHANTE_ORIGEM';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a um Despachante de Origem';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=5' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
					});
		}
	}
	
	function f_vincular_despachante_destino(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a um Despachante de Destino
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'COD_DESPACHANTE_DESTINO';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a um Despachante de Destino';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=6' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
					});
		}
	}
	
	function f_vincular_sd(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a um SD
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'SD';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a um SD';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=7' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
					});
		}
	}
	
	function f_vincular_tras(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a um TRAS
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'TRAS';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a um TRAS';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=8' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
					});
		}
	}
	
	function f_vincular_pe(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a um PE
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'PE';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a um PE';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=9' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
					});
		}
	}
	
	function f_vincular_di(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a um DI
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'DI';

			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a um DI';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=10' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
					});
		}
	}
	
	function f_vincular_local_transbordo(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a um Local de Transbordo
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'LOCAL_TRANSBORDO_ID';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a um Local de Transbordo';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=11' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
					});
		}
	}
	
	function f_vincular_data_descarga_transbordo(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a uma Data de Descarga de Transbordo
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'DATA_DESCARGA_TRANSBORDO';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a uma Data de Descarga de Transbordo';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=12' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
						
						if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
							try {
								Calendar.setup( {
									inputField  : "VALOR",          // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M", // the date format
									button      : "BTN_VALOR",      // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
							} catch(e) {}
						}
					});
		}
	}
	
	function f_vincular_data_carga_transbordo(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a uma Data de Carga de Transbordo
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'DATA_CARGA_TRANSBORDO';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a uma Data de Carga de Transbordo';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=13' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
						
						if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
							try {
								Calendar.setup( {
									inputField  : "VALOR",          // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M", // the date format
									button      : "BTN_VALOR",      // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
							} catch(e) {}
						}						
					});
		}
	}
	
	function f_vincular_tracao_transbordo(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a uma Trao de Transbordo
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'PLACA_CAVALO_TRANSBORDO';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a uma Trao de Transbordo';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=14' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
					});
		}
	}
	
	function f_vincular_reboque_transbordo(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a um Reboque de Transbordo
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'PLACA_CARRETA_TRANSBORDO';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a um Reboque de Transbordo';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=15' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
					});
		}
	}
	
	function f_vincular_entrada_alfandega_origem(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a uma Data de Entrada na Alfndega de Origem
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'ENTRADA_ALFANDEGA_ORIGEM';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a uma Data de Entrada na Alfndega de Origem';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=16' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
						
						if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
							try {
								Calendar.setup( {
									inputField  : "VALOR",          // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M", // the date format
									button      : "BTN_VALOR",      // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
							} catch(e) {}
						}
					});
		}
	}
	
	function f_vincular_saida_alfandega_origem(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a uma Data de Sada da Alfndega de Origem
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'SAIDA_ALFANDEGA_ORIGEM';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a uma Data de Sada da Alfndega de Origem';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=17' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
						
						if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
							try {
								Calendar.setup( {
									inputField  : "VALOR",          // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M", // the date format
									button      : "BTN_VALOR",      // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
							} catch(e) {}
						}
					});
		}
	}
	
	function f_vincular_chegada_fronteira_origem(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a uma Data de Chegada na Fronteira de Origem
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'CHEGADA_FRONTEIRA_ORIGEM';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a uma Data de Chegada na Fronteira de Origem';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=18' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
						
						if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
							try {
								Calendar.setup( {
									inputField  : "VALOR",          // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M", // the date format
									button      : "BTN_VALOR",      // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
							} catch(e) {}
						}
					});
		}
	}
	
	function f_vincular_saida_fronteira_origem(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a uma Data de Sada da Fronteira de Origem
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'SAIDA_FRONTEIRA_ORIGEM';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a uma Data de Sada da Fronteira de Origem';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=19' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
						
						if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
							try {
								Calendar.setup( {
									inputField  : "VALOR",          // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M", // the date format
									button      : "BTN_VALOR",      // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
							} catch(e) {}
						}
					});
		}
	}
	
	function f_vincular_chegada_fronteira_destino(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a uma Data de Chegada na Fronteira de Destino
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'CHEGADA_FRONTEIRA_DESTINO';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a uma Data de Chegada na Fronteira de Destino';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=20' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
						
						if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
							try {
								Calendar.setup( {
									inputField  : "VALOR",          // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M", // the date format
									button      : "BTN_VALOR",      // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
							} catch(e) {}
						}
					});
		}
	}
	
	function f_vincular_saida_fronteira_destino(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a uma Data de Sada da Fronteira de Destino
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'SAIDA_FRONTEIRA_DESTINO';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a uma Data de Sada da Fronteira de Destino';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=21' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
						
						if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
							try {
								Calendar.setup( {
									inputField  : "VALOR",          // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M", // the date format
									button      : "BTN_VALOR",      // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
							} catch(e) {}
						}
					});
		}
	}
	
	function f_vincular_entrada_alfandega_destino(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a uma Data de Entrada na Alfndega de Destino
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'ENTRADA_ALFANDEGA_DESTINO';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a uma Data de Entrada na Alfndega de Destino';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=22' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
						
						if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
							try {
								Calendar.setup( {
									inputField  : "VALOR",          // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M", // the date format
									button      : "BTN_VALOR",      // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
							} catch(e) {}
						}
					});
		}
	}
	
	function f_vincular_saida_alfandega_destino(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a uma Data de Sada da Alfndega de Destino
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'SAIDA_ALFANDEGA_DESTINO';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a uma Data de Sada da Alfndega de Destino';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=23' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
						
						if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
							try {
								Calendar.setup( {
									inputField  : "VALOR",          // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M", // the date format
									button      : "BTN_VALOR",      // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
							} catch(e) {}
						}
					});
		}
	}
	
	function f_busca_conhecimento() {
		with(document.forms[0]) {
			CONHECIMENTO_ID.value = '';
			
			if(!NUM_CONHECIMENTO.value) {
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_transp_internacional.cfc</cf_url>?method=get_intc_conhecimento'
						,'numero=' + NUM_CONHECIMENTO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.conhecimento_id.length > 0) {
									CONHECIMENTO_ID.value = obj.struct.conhecimento_id[0];
								}
								else {
									alert('CRT no encontrado.');
									NUM_CONHECIMENTO.focus();
								}
							}
						});
		}
	}
	
	function f_busca_despachante_origem() {
		with(document.forms[0]) {
			COD_DESPACHANTE_ORIGEM.value = '';
			DESPACHANTE_ORIGEM.value = '';
			
			if(!CNPJ_CPF_DESPACHANTE_ORIGEM.value) {
				return;
			}
			
			DESPACHANTE_ORIGEM.value = 'Buscando despachante de origem...';
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=getPessoa'
						,'cnpj_cpf=' + CNPJ_CPF_DESPACHANTE_ORIGEM.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.cod_pessoa.length > 0) {
									COD_DESPACHANTE_ORIGEM.value = obj.struct.cod_pessoa[0];
									DESPACHANTE_ORIGEM.value = obj.struct.razao_social[0];
								}
								else {
									DESPACHANTE_ORIGEM.value = 'Despachante de origem no encontrado.'
								}
							}
						});
		}
	}
	
	function f_busca_despachante_destino() {
		with(document.forms[0]) {
			COD_DESPACHANTE_DESTINO.value = '';
			DESPACHANTE_DESTINO.value = '';
			
			if(!CNPJ_CPF_DESPACHANTE_DESTINO.value) {
				return;
			}
			
			DESPACHANTE_DESTINO.value = 'Buscando despachante de destino...';
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=getPessoa'
						,'cnpj_cpf=' + CNPJ_CPF_DESPACHANTE_DESTINO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.cod_pessoa.length > 0) {
									COD_DESPACHANTE_DESTINO.value = obj.struct.cod_pessoa[0];
									DESPACHANTE_DESTINO.value = obj.struct.razao_social[0];
								}
								else {
									DESPACHANTE_DESTINO.value = 'Despachante de destino no encontrado.'
								}
							}
						});
		}
	}
	
	function f_busca_placa_tracao_transbordo() {
		with(document.forms[0]) {
			PLACA_CAVALO_TRANSBORDO.value = '';
			
			if(!COD_VEICULO_CAVALO_TRANSBORDO.value) {
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/transporte/cfc_veiculo.cfc</cf_url>?method=get_veiculo'
						,'frota=' + COD_VEICULO_CAVALO_TRANSBORDO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.placa.length == 1) {
									PLACA_CAVALO_TRANSBORDO.value = obj.struct.placa[0];
								}
								else if(obj.struct.placa.length > 1) {
									var msg;
									msg = 'Foi encontrado mais de um veculo (';
																			  
									for(var i = 0; i < obj.struct.placa.length; i++) {
										msg += obj.struct.placa[i];
										
										if(i != (obj.struct.placa.length - 1)) {
											msg += ' / ';
										}
									}
									
									msg += ').';
									alert(msg);
									COD_VEICULO_CAVALO_TRANSBORDO.focus();
								}
								else {
									alert('Veculo no encontrado.');
									COD_VEICULO_CAVALO_TRANSBORDO.focus();
								}
							}
						});
		}
	}	
	
	function f_busca_placa_carreta_transbordo() {
		with(document.forms[0]) {
			PLACA_CARRETA_TRANSBORDO.value = '';
			
			if(!COD_VEICULO_CARRETA_TRANSBORDO.value) {
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/transporte/cfc_veiculo.cfc</cf_url>?method=get_veiculo'
						,'frota=' + COD_VEICULO_CARRETA_TRANSBORDO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.placa.length == 1) {
									PLACA_CARRETA_TRANSBORDO.value = obj.struct.placa[0];
								}
								else if(obj.struct.placa.length > 1) {
									var msg;
									msg = 'Foi encontrado mais de um veculo (';
																			  
									for(var i = 0; i < obj.struct.placa.length; i++) {
										msg += obj.struct.placa[i];
										
										if(i != (obj.struct.placa.length - 1)) {
											msg += ' / ';
										}
									}
									
									msg += ').';
									alert(msg);
									COD_VEICULO_CARRETA_TRANSBORDO.focus();
								}
								else {
									alert('Veculo no encontrado.');
									COD_VEICULO_CARRETA_TRANSBORDO.focus();
								}
							}
						});
		}
	}
	
	function f_buscar_dados(){
		with(document.forms[0]){
			target = '_self';
			action = 'principal.cfm';
			if(f_verifica_form(document.forms[0])) {
				submit();
			}
		}
	}
	
   function f_vincular_data_chegada_cliente(p_embarque_id, p_editar) {
		with(document.forms[0]) {
			OPERACAO.value = 5; // Vincular a uma date de chegada no cliente
			EMBARQUE_ID.value = p_embarque_id;
			CAMPO.value = 'CHEGADA_CLIENTE';
			
			f_mostrar_div();
			document.getElementById('lb_manipulacao').innerHTML = 'Vincular a uma Data de Chegada no Cliente';
			
			f_query_ajax('<cf_url>/aplicacoes/transporte_internacional/rastreabilidade/controle_viagens/consultas.cfm</cf_url>' +
					'?consulta=24' +
					'&embarque_id=' + p_embarque_id +
					'&editar=' + p_editar
					,function(obj) {
						document.getElementById('td_manipulacao').innerHTML = obj;
						
						if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
							try {
								Calendar.setup( {
									inputField  : "VALOR",          // ID of the input field
									ifFormat    : "%d/%m/%Y %H:%M", // the date format
									button      : "BTN_VALOR",      // ID of the button
									range       : [2001,2050],
									showsTime   : true
								} );
							} catch(e) {}
						}
					});
		}
	}
	
	function f_busca_remetente() {
		with(document.forms[0]) {
			REM_RAZAO_SOCIAL.value = '';
			COD_REMETENTE.value = '';
			
			if(!REM_CNPJ_CPF.value) {
				return;
			}
			REM_RAZAO_SOCIAL.value = 'Buscando remetente...';
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=get_pessoa_light'
						,'num_modalidade=9,5,13,15&cnpj_cpf=' + REM_CNPJ_CPF.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.cod_pessoa.length > 0) {
									REM_RAZAO_SOCIAL.value = obj.struct.razao_social[0];
									COD_REMETENTE.value = obj.struct.cod_pessoa[0];
								}
								else {
									REM_RAZAO_SOCIAL.value = 'Destinatrio no encontrado.';
								}
							}
						});
		}
	}
	
	function f_busca_destinatario() {
		with(document.forms[0]) {
			DEST_RAZAO_SOCIAL.value = '';
			COD_DESTINATARIO.value = '';
			
			if(!DEST_CNPJ_CPF.value) {
				return;
			}
			DEST_RAZAO_SOCIAL.value = 'Buscando destinatrio...';
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=get_pessoa_light'
						,'num_modalidade=9,5,13,15&cnpj_cpf=' + DEST_CNPJ_CPF.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.cod_pessoa.length > 0) {
									DEST_RAZAO_SOCIAL.value = obj.struct.razao_social[0];
									COD_DESTINATARIO.value = obj.struct.cod_pessoa[0];
								}
								else {
									DEST_RAZAO_SOCIAL.value = 'Destinatrio no encontrado.';
								}
							}
						});
		}
	}
		
</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KM&amp;M :..</title>
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/status.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body class="background" style="height: 100%;">
<form id="form_transportes" name="form_transportes" method="get" action="" onSubmit="return f_confirmar()">
    <input name="OPERACAO" id="OPERACAO" type="hidden" value="" sempre_ativo="1" />
    <input name="CONSULTA" id="CONSULTA" type="hidden" value="" sempre_ativo="1" />
    <input name="EMBARQUE_ID" id="EMBARQUE_ID" type="hidden" value="" sempre_ativo="1" />
    <input name="CAMPO" id="CAMPO" type="hidden" value="" sempre_ativo="1" />
    <input name="EMBARQUE_ID_FOCUS" id="EMBARQUE_ID_FOCUS" type="hidden" value="" sempre_ativo="1" />
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tr>
           <td>
              <fieldset><legend>Dados</legend>
              <table width="100%" border="0" align="center" cellpadding="2" cellspacing="0">
                 <tr>
                    <td width="1%" nowrap class="texto">Situa&ccedil;&atilde;o:</td>
                    <td width="99%" class="texto"><select name="SITUACAO_ID" id="SITUACAO_ID" display="SITUAO" style="width: 105px;">
                        <option value="">-- Todas --</option>
                        <option value="1">Pendente</option>
                        <option value="2">Finalizado</option>
                        </select></td>
                 </tr>
                  <tr>
                     <td nowrap class="texto">Tipo:</td>
                     <td class="texto"><select name="TIPO_ID" id="TIPO_ID" display="TIPO" style="width: 105px;">
                         <option value="">-- Todas --</option>
                         <cfoutput query="qrTipo">
                             <option value="#qrTipo.RV_LOW_VALUE#">#qrTipo.RV_ABBREVIATION#</option>
                         </cfoutput>
                         </select></td>
                 </tr>
                 <tr>
                 	  <td width="1%" nowrap class="texto">N&ordm; Viagem</td>
                      <td width="99%" class="texto"><input type="text" name="NUM_VIAGEM" id="NUM_VIAGEM" tipo="numerico" display="N VIAGEM" style="width: 85px;" /></td>
                 </tr>
                 <tr>
                    <td nowrap class="texto">Exportador:</td>
                    <td class="texto"><input type="text" name="REM_CNPJ_CPF" id="REM_CNPJ_CPF" maxlength="20" tipo="numerico" display="CNPJ/CPF DO REMETENTE" onChange="f_busca_remetente()" onKeyPress="return f_formata(this, '00000000000000000000')" style="width: 128px;" />
                       <input type="text" name="REM_RAZAO_SOCIAL" id="REM_RAZAO_SOCIAL" readonly display="REMETENTE" style="width: 315px;" />
                       <input type="hidden" name="COD_REMETENTE" id="COD_REMETENTE" display="REMETENTE" />
                       <button type="button" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?campo=REM_CNPJ_CPF,REM_RAZAO_SOCIAL,COD_REMETENTE&field=CNPJ_CPF,RAZAO_SOCIAL,COD_PESSOA&num_modalidade=9,5,13,15', '_blank', 800, 600, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Remetente" title="Buscar Remetente" width="16" height="16" align="absmiddle" /></button></td>
                 </tr>
                 <tr>
                    <td nowrap class="texto">Importador:</td>
                    <td class="texto"><input type="text" name="DEST_CNPJ_CPF" id="DEST_CNPJ_CPF" maxlength="20" tipo="numerico" display="CNPJ/CPF DO DESTINATRIO" onChange="f_busca_destinatario()" onKeyPress="return f_formata(this, '00000000000000000000')" style="width: 128px;" />
                       <input type="text" name="DEST_RAZAO_SOCIAL" id="DEST_RAZAO_SOCIAL" readonly display="DESTINATRIO" style="width: 315px;" />
                       <input type="hidden" name="COD_DESTINATARIO" id="COD_DESTINATARIO" display="DESTINATRIO" />
                       <button type="button" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?campo=DEST_CNPJ_CPF,DEST_RAZAO_SOCIAL,COD_DESTINATARIO&field=CNPJ_CPF,RAZAO_SOCIAL,COD_PESSOA&num_modalidade=9,5,13,15', '_blank', 800, 600, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Destinat&aacute;rio" title="Buscar Destinat&aacute;rio" width="16" height="16" align="absmiddle" /></button></td>
                 </tr>
                 <tr>
                    <td nowrap class="texto">Coleta:</td>
                    <td class="texto"><input type="text" name="COLETA_MUNICIPIO" id="COLETA_MUNICIPIO" maxlength="60" display="MUNICPIO DE COLETA" style="width: 244px;" /></td>
                 </tr>
                 <tr>
                    <td nowrap class="texto">Entrega:</td>
                    <td class="texto"><input type="text" name="ENTREGA_MUNICIPIO" id="ENTREGA_MUNICIPIO" maxlength="60" display="MUNICPIO DE ENTREGA" style="width: 244px;" /></td>
                 </tr>
                 <tr>
                    <td nowrap class="texto">Per&iacute;odo:</td>
                    <td class="texto"><input type="text" name="DATA_INICIO" id="DATA_INICIO" maxlength="10" tipo="data" display="DATA DE INCIO" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 87px;" />
                        <button type="button" id="BTN_DATA_INICIO" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
                        <script type="text/javascript"> 
                            Calendar.setup( {
                                inputField  : "DATA_INICIO",     // ID of the input field
                                ifFormat    : "%d/%m/%Y",        // the date format
                                button      : "BTN_DATA_INICIO", // ID of the button
                                range       : [2001,2050]
                            } );
                        </script>
                        &nbsp;at&eacute;&nbsp;
                        <input type="text" name="DATA_FIM" id="DATA_FIM" maxlength="10" tipo="data" display="DATA DE TRMINO" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 87px;" />
                        <button type="button" id="BTN_DATA_FIM" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
                        <script type="text/javascript"> 
                            Calendar.setup( {
                                inputField  : "DATA_FIM",     // ID of the input field
                                ifFormat    : "%d/%m/%Y",     // the date format
                                button      : "BTN_DATA_FIM", // ID of the button
                                range       : [2001,2050]
                            } );
                        </script>
                        &nbsp;
                        <button type="button" class="botao-16x16" onClick="f_buscar_dados();"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar" title="Buscar" width="16" height="16" align="absmiddle" /></button></td>
				 </tr>
              </table>
              </fieldset>
           </td>		
        </tr>
		
		
		<cfif IsDefined("qrEmbarque") and qrEmbarque.RecordCount gt 0>
        <tr>
        	<td>
            	<cfset grid_cod = 'INTC_CONTROLE_VIAGENS'>
				<cfset grid_query = 'qrEmbarque'>
                <cfset grid_field_list    = ''>
                <cfset grid_field_caption = ''>
                <cfset grid_field_align   = ''>
                <cfset grid_field_type    = ''>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'IMPRIMIR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>&nbsp;</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'INSERIR_ANEXO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>&nbsp;</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VISUALIZAR_ANEXO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>&nbsp;</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'FINALIZAR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>&nbsp;</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'STATUS_ATUAL')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Status Atual</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_VIAGEM')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>N&ordm; Viagem</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_SAIDA_VIAGEM')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Data de Sa&iacute;da Viagem</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_CONHECIMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>CRT</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_SAIDA_EMBARQUE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Data de Sa&iacute;da Embarque</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'REMETENTE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Exportador</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'MUNICIPIO_ORIGEM')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Origem</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DESTINATARIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Importador</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'MUNICIPIO_DESTINO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Destino</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_MANIFESTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>MIC/DTA</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NOME_MOTORISTA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Motorista</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COD_VEICULO_CAVALO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Tra&ccedil;&atilde;o</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'POSICAO_ATUAL')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Posi&ccedil;&atilde;o Atual</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COD_VEICULO_CARRETA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Reboque</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'PREVISAO_CHEGADA_FRONTEIRA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Prev. Chegada na Fronteira</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DESPACHANTE_ORIGEM')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Despachante de Origem</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'ALFANDEGA_ORIGEM')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Alf&acirc;ndega de Origem</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'ENTRADA_ALFANDEGA_ORIGEM')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Entrada na Alf&acirc;ndega de Origem</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'SAIDA_ALFANDEGA_ORIGEM')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Sa&iacute;da da Alf&acirc;ndega de Origem</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CHEGADA_FRONTEIRA_ORIGEM')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Chegada na Fronteira de Origem</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'SAIDA_FRONTEIRA_ORIGEM')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Sa&iacute;da da Fronteira de Origem</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'FRONTEIRA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Fronteira de Cruze</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CHEGADA_FRONTEIRA_DESTINO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Chegada na Fronteira de Destino</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'SAIDA_FRONTEIRA_DESTINO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Sa&iacute;da da Fronteira de Destino</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DESPACHANTE_DESTINO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Despachante de Destino</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'ALFANDEGA_DESTINO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Alf&acirc;ndega de Destino</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'ENTRADA_ALFANDEGA_DESTINO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Entrada na Alf&acirc;ndega de Destino</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'SAIDA_ALFANDEGA_DESTINO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Sa&iacute;da da Alf&acirc;ndega de Destino</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CHEGADA_CLIENTE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Chegada no Cliente</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_TERMINO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Data de T&eacute;rmino</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'FACTURA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Factura</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'SD')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>SD</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'TRAS')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>TRAS</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'PE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>PE</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DI')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>DI</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DTA_DESC')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>DTA?</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'TRANSBORDO_DESC')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Possui Transbordo?</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'LOCAL_TRANSBORDO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Local de Transbordo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_DESCARGA_TRANSBORDO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Data de Descarga Transbordo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_CARGA_TRANSBORDO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Data de Carga Transbordo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COD_VEICULO_CAVALO_TRANSBORDO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Tra&ccedil;&atilde;o de Transbordo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COD_VEICULO_CARRETA_TRANSBORDO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Reboque de Transbordo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'EM_TRANSBORDO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Em Transbordo?</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_td_context_eval         = 'fnc_td_context_eval'>
             <!---   <cfset grid_tr_onmouseover_function = 'fnc_tr_onmouseover_eval'>
                <cfset grid_tr_onmouseout_function  = 'fnc_tr_onmouseout_eval'>--->
                <cfset grid_td_inline_function      = 'fnc_grid_td_inline_function'>
                <cfset grid_td_id_function	        = 'fnc_grid_td_id'>
                <cfset grid_tr_id_function			= 'fnc_grid_tr_id'>
                <cfset grid_td_ondblclick_function  = 'fnc_td_ondblclick_function'>
                <cfset grid_td_style_function       = 'fnc_grid_td_style_function'>
                <cfset grid_tr_onclick_function		= 'fnc_grid_tr_onclick'>
                
                <cfscript>
                    function fnc_td_context_eval(field) {
                        switch(ucase(field)) {
                            case "IMPRIMIR":
                                return '<button type="button" class="botao-16x16" onClick="f_imprimir_embarque(#qrEmbarque.EMBARQUE_ID#)"><img src="/_imagens/botoes/16x16/imprimir.gif" alt="Imprimir Embarque" title="Imprimir Embarque" width="16" height="16" align="absmiddle"></button>';
							case "INSERIR_ANEXO":
                                return '<button type="button" class="botao-16x16" onClick="f_inserir_anexo(#qrEmbarque.EMBARQUE_ID#)"><img src="/_imagens/botoes/16x16/anexos.gif" alt="Inserir Anexo" title="Inserir Anexo" width="16" height="16" align="absmiddle" /></button>';
							case "VISUALIZAR_ANEXO":
								if(qrEmbarque.QTDE_EMBARQUE_ANEXOS gt 0) {
									return '<button type="button" class="botao-16x16" onClick="f_visualizar_anexo(#qrEmbarque.EMBARQUE_ID#)"><img src="/_imagens/botoes/16x16/visualizar_anexo.gif" alt="Visualizar Anexos" title="Visualizar Anexos" width="16" height="16" align="absmiddle" />';
								}
								else {
									return '';
								}
                            case "FINALIZAR":
                                if(qrEmbarque.VINCULOS_OK eq 1) {
									return '<button type="button" class="botao-16x16" onClick="f_finalizar_embarque(#qrEmbarque.EMBARQUE_ID#)"><img src="/_imagens/botoes/16x16/aplicar.gif" alt="Finalizar Embarque" title="Finalizar Embarque" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '';
								}
							case "NUM_CONHECIMENTO":
								if(not Len(Trim(qrEmbarque.NUM_CONHECIMENTO))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_conhecimento(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a um CRT" title="Vincular a um CRT" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.NUM_CONHECIMENTO#';
								}
							case "NUM_MANIFESTO":
								if(Len(Trim(qrEmbarque.NUM_CONHECIMENTO)) and not Len(Trim(qrEmbarque.NUM_MANIFESTO))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_manifesto(#qrEmbarque.EMBARQUE_ID#, #qrEmbarque.CONHECIMENTO_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a um MIC/DTA" title="Vincular a um MIC/DTA" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.NUM_MANIFESTO#';
								}
							case "DESPACHANTE_ORIGEM":
								if(not Len(Trim(qrEmbarque.CNPJ_CPF_DESPACHANTE_ORIGEM))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_despachante_origem(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a um Despachante de Origem" title="Vincular a um Despachante de Origem" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.DESPACHANTE_ORIGEM#';
								}
							case "DESPACHANTE_DESTINO":
								if(not Len(Trim(qrEmbarque.CNPJ_CPF_DESPACHANTE_DESTINO))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_despachante_destino(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a um Despachante de Destino" title="Vincular a um Despachante de Destino" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.DESPACHANTE_DESTINO#';
								}
							case "SD":
								if(not Len(Trim(qrEmbarque.SD))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_sd(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a um SD" title="Vincular a um SD" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.SD#';
								}
							case "TRAS":
								if(not Len(Trim(qrEmbarque.TRAS))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_tras(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a um TRAS" title="Vincular a um TRAS" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.TRAS#';
								}
							case "PE":
								if(not Len(Trim(qrEmbarque.PE))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_pe(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a um PE" title="Vincular a um PE" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.PE#';
								}
							case "DI":
								if(not Len(Trim(qrEmbarque.DI))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_di(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a um DI" title="Vincular a um DI" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.DI#';
								}
							case "LOCAL_TRANSBORDO":
								if(qrEmbarque.TRANSBORDO eq 1 and not Len(Trim(qrEmbarque.LOCAL_TRANSBORDO))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_local_transbordo(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a um Local de Transbordo" title="Vincular a um Local de Transbordo" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.LOCAL_TRANSBORDO#';
								}
							case "DATA_DESCARGA_TRANSBORDO":
								if(qrEmbarque.TRANSBORDO eq 1 and not Len(Trim(qrEmbarque.DATA_DESCARGA_TRANSBORDO))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_data_descarga_transbordo(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a uma Data de Descarga de Transbordo" title="Vincular a uma Data de Descarga de Transbordo" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.DATA_DESCARGA_TRANSBORDO#';
								}
							case "DATA_CARGA_TRANSBORDO":
								if(qrEmbarque.TRANSBORDO eq 1 and not Len(Trim(qrEmbarque.DATA_CARGA_TRANSBORDO))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_data_carga_transbordo(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a uma Data de Carga de Transbordo" title="Vincular a uma Data de Carga de Transbordo" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.DATA_CARGA_TRANSBORDO#';
								}
							case "COD_VEICULO_CAVALO_TRANSBORDO":
								if(qrEmbarque.TRANSBORDO eq 1 and not Len(Trim(qrEmbarque.COD_VEICULO_CAVALO_TRANSBORDO))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_tracao_transbordo(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a uma Trao de Transbordo" title="Vincular a uma Trao de Transbordo" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.COD_VEICULO_CAVALO_TRANSBORDO#';
								}
							case "COD_VEICULO_CARRETA_TRANSBORDO":
								if(qrEmbarque.TRANSBORDO eq 1 and not Len(Trim(qrEmbarque.COD_VEICULO_CARRETA_TRANSBORDO))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_reboque_transbordo(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a um Reboque de Transbordo" title="Vincular a um Reboque de Transbordo" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.COD_VEICULO_CARRETA_TRANSBORDO#';
								}
							case "ENTRADA_ALFANDEGA_ORIGEM":
								if(not Len(Trim(qrEmbarque.ENTRADA_ALFANDEGA_ORIGEM))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_entrada_alfandega_origem(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a uma Data de Entrada na Alfndega de Origem" title="Vincular a uma Data de Entrada na Alfndega de Origem" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.ENTRADA_ALFANDEGA_ORIGEM#';
								}
							case "SAIDA_ALFANDEGA_ORIGEM":
								if(not Len(Trim(qrEmbarque.SAIDA_ALFANDEGA_ORIGEM))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_saida_alfandega_origem(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a uma Data de Sada da Alfndega de Origem" title="Vincular a uma Data de Sada da Alfndega de Origem" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.SAIDA_ALFANDEGA_ORIGEM#';
								}
							case "CHEGADA_FRONTEIRA_ORIGEM":
								if(not Len(Trim(qrEmbarque.CHEGADA_FRONTEIRA_ORIGEM))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_chegada_fronteira_origem(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a uma Data de Chegada na Fronteira de Origem" title="Vincular a uma Data de Chegada na Fronteira de Origem" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.CHEGADA_FRONTEIRA_ORIGEM#';
								}
							case "SAIDA_FRONTEIRA_ORIGEM":
								if(not Len(Trim(qrEmbarque.SAIDA_FRONTEIRA_ORIGEM))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_saida_fronteira_origem(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a uma Data de Sada da Fronteira de Origem" title="Vincular a uma Data de Sada da Fronteira de Origem" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.SAIDA_FRONTEIRA_ORIGEM#';
								}
							case "CHEGADA_FRONTEIRA_DESTINO":
								if(not Len(Trim(qrEmbarque.CHEGADA_FRONTEIRA_DESTINO))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_chegada_fronteira_destino(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a uma Data de Chegada na Fronteira de Destino" title="Vincular a uma Data de Chegada na Fronteira de Destino" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.CHEGADA_FRONTEIRA_DESTINO#';
								}
							case "SAIDA_FRONTEIRA_DESTINO":
								if(not Len(Trim(qrEmbarque.SAIDA_FRONTEIRA_DESTINO))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_saida_fronteira_destino(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a uma Data de Sada da Fronteira de Destino" title="Vincular a uma Data de Sada da Fronteira de Destino" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.SAIDA_FRONTEIRA_DESTINO#';
								}
							case "ENTRADA_ALFANDEGA_DESTINO":
								if(not Len(Trim(qrEmbarque.ENTRADA_ALFANDEGA_DESTINO))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_entrada_alfandega_destino(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a uma Data de Entrada na Alfndega de Destino" title="Vincular a uma Data de Entrada na Alfndega de Destino" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.ENTRADA_ALFANDEGA_DESTINO#';
								}
							case "SAIDA_ALFANDEGA_DESTINO":
								if(not Len(Trim(qrEmbarque.SAIDA_ALFANDEGA_DESTINO))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_saida_alfandega_destino(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a uma Data de Sada da Alfndega de Destino" title="Vincular a uma Data de Sada da Alfndega de Destino" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.SAIDA_ALFANDEGA_DESTINO#';
								}
						    case "CHEGADA_CLIENTE":
								if(not Len(Trim(qrEmbarque.CHEGADA_CLIENTE))) {
									return '<button type="button" class="botao-16x16" onClick="f_vincular_data_chegada_cliente(#qrEmbarque.EMBARQUE_ID#, 0)"><img src="/_imagens/botoes/16x16/vincula_crt.gif" alt="Vincular a uma Data de Chegada no Cliente" title="Vincular a uma Data de Chegada no Cliente" width="16" height="16" align="absmiddle"></button>';
								}
								else {
									return '#qrEmbarque.CHEGADA_CLIENTE#';
								}
                            default:
                                return Evaluate("#grid_query#.#field#");
                                break;
                        }
                    }
                    
                   /* function fnc_tr_onmouseover_eval() {
                        return "this.className = 'linha_over';";
                    }
                    
                    function fnc_tr_onmouseout_eval() {
                        return "this.className = 'linha_2';";
                    }*/
                    
                    function fnc_grid_td_inline_function(field) {
                        return " nowrap";
                    }
					
					function fnc_grid_td_id(field) {
						return "td_#qrEmbarque.EMBARQUE_ID#_#field#";
					}
					
					function fnc_grid_tr_id() {
						return "tr_#qrEmbarque.EMBARQUE_ID#";
					}
					
					function fnc_td_ondblclick_function(field){
						switch(ucase(field)) {
							case "NUM_CONHECIMENTO":
								if(Len(Trim(qrEmbarque.NUM_CONHECIMENTO))) {
									return 'f_vincular_conhecimento(#qrEmbarque.EMBARQUE_ID#, 1)';
								}
								else {
									return '';
								}
							break;
							case "NUM_MANIFESTO":
								if(Len(Trim(qrEmbarque.NUM_CONHECIMENTO)) and  Len(Trim(qrEmbarque.NUM_MANIFESTO))) {
									return 'f_vincular_manifesto(#qrEmbarque.EMBARQUE_ID#, #qrEmbarque.CONHECIMENTO_ID#, 1)';
								}
								else {
									return '';
								}
							break;
							case "DESPACHANTE_ORIGEM":
								if(Len(Trim(qrEmbarque.CNPJ_CPF_DESPACHANTE_ORIGEM))) {
									return 'f_vincular_despachante_origem(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "DESPACHANTE_DESTINO":
								if(Len(Trim(qrEmbarque.CNPJ_CPF_DESPACHANTE_DESTINO))) {
									return 'f_vincular_despachante_destino(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "SD":
								if(Len(Trim(qrEmbarque.SD))) {
									return 'f_vincular_sd(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "TRAS":
								if(Len(Trim(qrEmbarque.TRAS))) {
									return 'f_vincular_tras(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "PE":
								if(Len(Trim(qrEmbarque.PE))) {
									return 'f_vincular_pe(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "DI":
								if(Len(Trim(qrEmbarque.DI))) {
									return 'f_vincular_di(#qrEmbarque.EMBARQUE_ID#, 1)';
								}
								else {
									return '';
								}
							break;
							case "LOCAL_TRANSBORDO":
								if(Len(Trim(qrEmbarque.LOCAL_TRANSBORDO))) {
									return 'f_vincular_local_transbordo(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "DATA_DESCARGA_TRANSBORDO":
								if(Len(Trim(qrEmbarque.DATA_DESCARGA_TRANSBORDO))) {
									return 'f_vincular_data_descarga_transbordo(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "DATA_CARGA_TRANSBORDO":
								if(Len(Trim(qrEmbarque.DATA_CARGA_TRANSBORDO))) {
									return 'f_vincular_data_carga_transbordo(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "COD_VEICULO_CAVALO_TRANSBORDO":
								if(Len(Trim(qrEmbarque.COD_VEICULO_CAVALO_TRANSBORDO))) {
									return 'f_vincular_tracao_transbordo(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "COD_VEICULO_CARRETA_TRANSBORDO":
								if(Len(Trim(qrEmbarque.COD_VEICULO_CARRETA_TRANSBORDO))) {
									return 'f_vincular_reboque_transbordo(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "ENTRADA_ALFANDEGA_ORIGEM":
								if(Len(Trim(qrEmbarque.ENTRADA_ALFANDEGA_ORIGEM))) {
									return 'f_vincular_entrada_alfandega_origem(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "SAIDA_ALFANDEGA_ORIGEM":
								if(Len(Trim(qrEmbarque.SAIDA_ALFANDEGA_ORIGEM))) {
									return 'f_vincular_saida_alfandega_origem(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "CHEGADA_FRONTEIRA_ORIGEM":
								if(Len(Trim(qrEmbarque.CHEGADA_FRONTEIRA_ORIGEM))) {
									return 'f_vincular_chegada_fronteira_origem(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "SAIDA_FRONTEIRA_ORIGEM":
								if(Len(Trim(qrEmbarque.SAIDA_FRONTEIRA_ORIGEM))) {
									return 'f_vincular_saida_fronteira_origem(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "CHEGADA_FRONTEIRA_DESTINO":
								if(Len(Trim(qrEmbarque.CHEGADA_FRONTEIRA_DESTINO))) {
									return 'f_vincular_chegada_fronteira_destino(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "SAIDA_FRONTEIRA_DESTINO":
								if(Len(Trim(qrEmbarque.SAIDA_FRONTEIRA_DESTINO))) {
									return 'f_vincular_saida_fronteira_destino(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "ENTRADA_ALFANDEGA_DESTINO":
								if(Len(Trim(qrEmbarque.ENTRADA_ALFANDEGA_DESTINO))) {
									return 'f_vincular_entrada_alfandega_destino(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "SAIDA_ALFANDEGA_DESTINO":
								if(Len(Trim(qrEmbarque.SAIDA_ALFANDEGA_DESTINO))) {
									return 'f_vincular_saida_alfandega_destino(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
							case "CHEGADA_CLIENTE":
								if(Len(Trim(qrEmbarque.CHEGADA_CLIENTE))) {
									return 'f_vincular_data_chegada_cliente(#qrEmbarque.EMBARQUE_ID#, 1);';
								}
								else {
									return '';
								}
							break;
						}
						
					}
					 function fnc_grid_td_style_function(field) {
						switch(ucase(field)) {
							case 'NUM_CONHECIMENTO':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							case 'NUM_MANIFESTO':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							case 'DESPACHANTE_ORIGEM':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							case 'DESPACHANTE_DESTINO':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							case 'SD':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							case 'TRAS':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							case 'PE':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							case 'DI':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							case 'LOCAL_TRANSBORDO':
								if(not Len(Trim(qrEmbarque.SAIDA_FRONTEIRA_DESTINO))) {
									return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								}
								break;
							case 'DATA_DESCARGA_TRANSBORDO':
								if(not Len(Trim(qrEmbarque.SAIDA_FRONTEIRA_DESTINO))) {
									return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								}
								break;
							case 'DATA_CARGA_TRANSBORDO':
								if(not Len(Trim(qrEmbarque.SAIDA_FRONTEIRA_DESTINO))) {
									return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								}
								break;
							case 'COD_VEICULO_CAVALO_TRANSBORDO':
								if(not Len(Trim(qrEmbarque.SAIDA_FRONTEIRA_DESTINO))) {
									return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								}
								break;
							case 'COD_VEICULO_CARRETA_TRANSBORDO':
								if(not Len(Trim(qrEmbarque.SAIDA_FRONTEIRA_DESTINO))) {
									return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								}
								break;
							case 'ENTRADA_ALFANDEGA_ORIGEM':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							case 'SAIDA_ALFANDEGA_ORIGEM':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							case 'CHEGADA_FRONTEIRA_ORIGEM':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							case 'SAIDA_FRONTEIRA_ORIGEM':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							case 'CHEGADA_FRONTEIRA_DESTINO':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							case 'SAIDA_FRONTEIRA_DESTINO':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							case 'ENTRADA_ALFANDEGA_DESTINO':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							case 'SAIDA_ALFANDEGA_DESTINO':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							case 'CHEGADA_CLIENTE':
								return "cursor:pointer;background-image:url(/_imagens/botoes/16x16/required-tick.gif); background-position: right bottom; background-repeat: no-repeat;";
								break;
							default:
								return "";
								break;
                    }
                }
				
				function fnc_grid_tr_onclick() {
					return "this.className = (this.className == 'linha_azul' ? 'linha_2' : 'linha_azul');";
				}
                </cfscript>
                
                <cfset grid_fixed_header = 0>
                <cfinclude template="/_include/grid/grid.cfm">
                
                <cfloop query="qrEmbarque">
                	<script type="text/javascript">
						<cfif not Len(Trim(qrEmbarque.DESPACHANTE_ORIGEM))>
							document.getElementById('td_<cfoutput>#qrEmbarque.EMBARQUE_ID#</cfoutput>_DESPACHANTE_ORIGEM').align = 'center';
						</cfif>
						<cfif not Len(Trim(qrEmbarque.DESPACHANTE_DESTINO))>
							document.getElementById('td_<cfoutput>#qrEmbarque.EMBARQUE_ID#</cfoutput>_DESPACHANTE_DESTINO').align = 'center';
						</cfif>
						<cfif not Len(Trim(qrEmbarque.SD))>
							document.getElementById('td_<cfoutput>#qrEmbarque.EMBARQUE_ID#</cfoutput>_SD').align = 'center';
						</cfif>
						<cfif not Len(Trim(qrEmbarque.TRAS))>
							document.getElementById('td_<cfoutput>#qrEmbarque.EMBARQUE_ID#</cfoutput>_TRAS').align = 'center';
						</cfif>
						<cfif not Len(Trim(qrEmbarque.PE))>
							document.getElementById('td_<cfoutput>#qrEmbarque.EMBARQUE_ID#</cfoutput>_PE').align = 'center';
						</cfif>
						<cfif not Len(Trim(qrEmbarque.DI))>
							document.getElementById('td_<cfoutput>#qrEmbarque.EMBARQUE_ID#</cfoutput>_DI').align = 'center';
						</cfif>
					</script>
                </cfloop>
            </td>
        </tr>
        <cfelseif IsDefined("qrEmbarque") and qrEmbarque.RecordCount eq 0>
        <tr style="padding-top: 15px;">
            <td align="center" valign="middle" class="obrigatorio">Nenhum embarque em aberto encontrado.</td>
        </tr>
        </cfif>
    </table>
    <div id="div_manipulacao" style="position: absolute; width: 200px; height: 100px; display: none;">
    	<table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr>
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito"><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<nobr><label id="lb_manipulacao" style="padding-right: 10px;"></label></nobr></td>
            </tr>
            <tr>
                <td id="td_manipulacao" height="98%" valign="top"></td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right"><button type="button" class="botao" onClick="f_ocultar_div()"><nobr><img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr></button>&nbsp;
                    <button type="button" class="botao" onClick="f_confirmar()"><nobr><img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr></button></td>
            </tr>
        </table>
    </div>
</form>
</body>
<script type="text/javascript">
	with(document.forms[0]) {
		f_hide_carregando();
		
		<cfif IsDefined("vars.EMBARQUE_ID_FOCUS") and Len(Trim(vars.EMBARQUE_ID_FOCUS))>
			<cfoutput>
			    document.getElementById('<cfoutput>#grid_cod#</cfoutput>').focus();
				document.getElementById('tr_' + #vars.EMBARQUE_ID_FOCUS#).className = 'linha_azul';
				document.getElementById('tr_' + #vars.EMBARQUE_ID_FOCUS#).focus();
			</cfoutput>
		</cfif>
	
	    <cfif IsDefined("qrEmbarque")>	
			<cfoutput>													
				SITUACAO_ID.value	    = '#JSStringFormat(vars.SITUACAO_ID)#';
				TIPO_ID.value			= '#JSStringFormat(vars.TIPO_ID)#';
				NUM_VIAGEM.value 		= '#JSStringFormat(vars.NUM_VIAGEM)#';
				REM_CNPJ_CPF.value 	    = '#JSStringFormat(vars.REM_CNPJ_CPF)#';
				REM_RAZAO_SOCIAL.value  = '#JSStringFormat(vars.REM_RAZAO_SOCIAL)#'; 
				COD_REMETENTE.value		= '#JSStringFormat(vars.COD_REMETENTE)#'; 
				DEST_CNPJ_CPF.value 	= '#JSStringFormat(vars.DEST_CNPJ_CPF)#';
				DEST_RAZAO_SOCIAL.value = '#JSStringFormat(vars.DEST_RAZAO_SOCIAL)#'; 
				COD_DESTINATARIO.value	= '#JSStringFormat(vars.COD_DESTINATARIO)#'; 
				COLETA_MUNICIPIO.value  = '#JSStringFormat(vars.COLETA_MUNICIPIO)#'; 
				ENTREGA_MUNICIPIO.value = '#JSStringFormat(vars.ENTREGA_MUNICIPIO)#'; 
				DATA_INICIO.value 		= '#JSStringFormat(vars.DATA_INICIO)#'; 
				DATA_FIM.value 			= '#JSStringFormat(vars.DATA_FIM)#'; 		
			</cfoutput>
		</cfif>	
	}
</script>
</html>
<iframe name="consultas" frameborder="0" width="100%" height="600" src="" style=" display:none;"></iframe>
<cfset RequestEnd = 0>