<html>
<cfinclude template="/_scripts/scripts.cfm" />
<cfscript>
	conn = CreateComponent("_transportes.consulta.logistica.cfc_operacao");
	qrOperacao = conn.get_operacao_tree(cod_organograma = session.cod_organograma, somente_ativas = 1);
	
	conn = CreateComponent("_transportes.consulta.cfc_global");
	qrValorEm           	= conn.get_cg_ref_codes(rv_domain = 'LOTE.FRETE_EM', owner = 'OPER');
	qrModalidade        	= conn.get_cg_ref_codes(rv_domain = 'VEICULO_MODALIDADE.MODALIDADE', owner = 'OPER');
	qrPrioridade        	= conn.get_cg_ref_codes(rv_domain = 'PRIORIDADE', owner = 'LOGISTICA');
	v_nf_serie_liberada     = conn.get_parametro_valor(cod_projeto = 25, cod_aplicacao = 'FISCAL', parametro_id = 311, parametro_grupo_id = 8);
	v_valor_sug_obrigatorio = conn.get_parametro_valor(cod_projeto = 11, cod_aplicacao = 'OPERACIONAL', parametro_id = 486, parametro_grupo_id = 17);
	
	conn = CreateComponent("_transportes.consulta.cfc_emissao_documentos");	
	qrUnidade  = conn.get_unidade();
	qrEspecie  = conn.get_especie();
	qrSubSerie = conn.get_sub_serie_nota(documento_proprio = 0, carga_transportada = 1);
</cfscript>
<script type="text/javascript">
	// Configura botoes // 
	parent.f_set_texto( 'titulo_aplicacao', '<cf_language>Controle Logstico</cf_language>' );
	parent.f_set_texto( 'titulo_pagina', '<cf_language>Solicitaes de Carga</cf_language>' );
	
	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); } 
	
	parent.f_hidden('btn_excluir');
	f_cria_botao('cancelar_doc', 'Cancelar', 'f_cancelar_doc()', parent.document.getElementById('barra_botoes_top'));
	f_cria_botao('localizar', 'Localizar', 'f_localizar()', parent.document.getElementById('barra_botoes_top'));
	f_desabilitar_botao('cancelar_doc');
	
	// -------------------- //
	
	var v_inserida = 0;	
	
	function f_confirmar() { 
		with(document.forms[0]) {
			OPERACAO.disabled = false;
			target = 'consultas';
			action = 'confirma.cfm';
			if(COD_ORGANOGRAMA.value == '') {
				alert('O usurio atual no possui lotao, impossvel prosseguir!');
				return false;
			}
			if(VALOR_TOTAL_SUGERIDO.value.trim() != '' && Number(VALOR_TOTAL_SUGERIDO.value) <<cfif v_valor_sug_obrigatorio eq 1 >=</cfif> 0) {
				alert('No  possvel gerar uma solicitao de carga com valor sugerido inferior a 0 (zero).');
				return false;
			}
			if(Number(VALOR_TOTAL_SUGERIDO.value) < Number(VALOR_TOTAL_NF.value)) {
				alert('No  possvel gerar uma solicitao de carga com valor sugerido inferior ao valor total das notas fiscais..');
				return false;
			}
			if(Number(PESO.value) > 80000) {
				alert('No  possvel gerar uma solicitao de carga com peso superior a 80.000 Kg.');
				return false;
			}
			/*if(Number(VALOR_TOTAL.value) > 20000) {
				alert('No  possvel gerar uma solicitao de carga com valor superior a R$ 20.000,00.');
				return false;
			}*/
			if(DATA_CARREGAMENTO_INICIO.value == '' || DATA_CARREGAMENTO_INICIO.value.getDateTime().format('hh24:mi') == '00:00') {
				alert(' necessrio definir a hora de inicio de carregamento para a carga.');
				DATA_CARREGAMENTO_INICIO.select();
				return false;
			}
			if(DATA_CARREGAMENTO_FIM.value == '' || DATA_CARREGAMENTO_FIM.value.getDateTime().format('hh24:mi') == '00:00') {
				alert(' necessrio definir a hora de trmino de carregamento para a carga.');
				DATA_CARREGAMENTO_FIM.select();
				return false;
			}
			if(DATA_ENTREGA_INICIO.value == '' || DATA_ENTREGA_INICIO.value.getDateTime().format('hh24:mi') == '00:00') {
				alert(' necessrio definir a hora de inicio de entrega para a carga.');
				DATA_ENTREGA_INICIO.select();
				return false;
			}
			if(DATA_ENTREGA_FIM.value == '' || DATA_ENTREGA_FIM.value.getDateTime().format('hh24:mi') == '00:00') {
				alert(' necessrio definir a hora de trmino de entrega para a carga.');
				DATA_ENTREGA_FIM.select();
				return false;
			}
			
			VALOR_UNITARIO.setAttribute('obrigatorio', (VALOR_EM.value == 'LOTACAO')?'0':'1');
			if(f_verifica_form(document.forms[0])) {
				document.getElementById('sp_origem_restrita').disabled = false;
				document.getElementById('sp_origem_aberta').disabled = false;
				document.getElementById('sp_destino_restrita').disabled = false;
				document.getElementById('sp_destino_aberta').disabled = false;
				
				MODALIDADE.disabled = false;
				COD_UNIDADE.disabled = false;
				LIBERADA_AGENDAMENTO.disabled = false;
				VALOR_UNITARIO.disabled = false;
				
				v_tipo_docto_id = document.getElementById('TIPO_DOCUMENTO_ID');
				v_status = v_tipo_docto_id.disabled;
				v_tipo_docto_id.disabled = '';
				
				submit();
				
				v_tipo_docto_id.disabled = v_status;
				
			}
		}
		return false;
	}
	parent.f_confirmar = f_confirmar;

	function f_cancelar_doc() {
		with(document.forms[0]) {
			OPERACAO.value = 4; // Cancelar
			OPERACAO.disabled = false;
			SOLICITACAO_CARGA_ID.disabled = false; 
			try {
				ATUALIZA_COMBO.disabled = false;
			} catch(e) {}
			target = 'consultas';
			action = 'confirma.cfm';		
			if(confirm('Para confirmar o cancelamento da solicitao de carga clique em OK.')) {
				submit();
			}
		}
	}
	parent.f_cancelar_doc = f_cancelar_doc;
	
	function f_localizar() {
		NewWindow('localizar.cfm', 'Localizar', '800', '600', 'yes');
	}
	parent.f_localizar = f_localizar;
	
	function f_on_incluir() {
		with(document.forms[0]) {
			f_desabilitar_botao('cancelar_doc');
			
			catTree.closeAll();
			document.getElementById('arvore').disabled = false;
			
			f_limpa_select(NATUREZA_COMBO);
			document.getElementById('sp_natureza_restrita').style.display = 'none';
			document.getElementById('sp_natureza_aberta').style.display = '';
			
			f_limpa_select(NOME_REMETENTE_COMBO);
			document.getElementById('sp_remetente_restrita').style.display = 'none';
			document.getElementById('sp_remetente_aberta').style.display = '';
			
			f_limpa_select(NOME_DESTINATARIO_COMBO);
			document.getElementById('sp_destinatario_restrita').style.display = 'none';
			document.getElementById('sp_destinatario_aberta').style.display = '';
			
			f_limpa_select(NOME_CONSIGNATARIO_COMBO);
			document.getElementById('sp_consignatario_restrita').style.display = 'none';
			document.getElementById('sp_consignatario_aberta').style.display = '';
			
			f_limpa_select(NOME_REDESPACHO_COMBO);
			document.getElementById('sp_redespacho_restrita').style.display = 'none';
			document.getElementById('sp_redespacho_aberta').style.display = '';
			
			f_limpa_select(NOME_COBRANCA_COMBO);
			document.getElementById('sp_cobranca_restrita').style.display = 'none';
			document.getElementById('sp_cobranca_aberta').style.display = '';
			
			f_limpa_select(ORIGEM_MUNICIPIO_COMBO);
			document.getElementById('sp_origem_restrita').style.display = 'none';
			document.getElementById('sp_origem_aberta').style.display = '';
			
			f_limpa_select(DESTINO_MUNICIPIO_COMBO);
			document.getElementById('sp_destino_restrita').style.display = 'none';
			document.getElementById('sp_destino_aberta').style.display = '';
			
			document.getElementById('sp_m3').style.display = 'none';
			document.getElementById('sp_volumes').style.display = 'none';
			VALOR_UNITARIO.disabled = false;
			VALOR_UNITARIO.className = '';
			f_obrigatorio(VALOR_UNITARIO, 0);
			
			document.getElementById('sp_situacao').innerHTML = '';
			f_limpa_composicao();
			
			VALOR_TOTAL_NF.value = '0.00';
			COD_UNIDADE.value = 'Kg';
			NOTA_ALTURA.value = 0;
			NOTA_COMPRIMENTO.value = 0;
			NOTA_LARGURA.value = 0;
			NOTA_QTDE_VOLUME.value = 1;
			
			COMPOSICAO.readOnly = false;
			CPF_MOTORISTA.readOnly = false;
			
			document.getElementById('tr_gerar_romaneio').style.display = '';
			GERA_ROMANEIO.disabled = true;
			GERA_ROMANEIO.checked  = false;
			
			f_limpar_NOTAS_FISCAIS();
			f_limpar_NFE();
			f_limpar_OUTROS();
			TIPO_DOCUMENTO_ID.value = 1;
			f_muda_tipo_documento();
			
			document.getElementById("MODALIDADE").value = 'FROTA';
			document.getElementById("LIBERADA_AGENDAMENTO").value = '1';
		}
	}
	
	function f_on_editar() {
		with(document.forms[0]) {
			f_desabilitar_botao('cancelar_doc');
			if(TIPO_DOCUMENTO_ID.value == ''){
				TIPO_DOCUMENTO_ID.value = 1;
				f_muda_tipo_documento();
			}
			
			catTree.closeAll();
			document.getElementById('arvore').disabled = true;
			
			if(document.getElementById('sp_natureza_restrita').style.display == '' && NATUREZA_COMBO.options.length == 1)
				NATUREZA_COMBO.disabled = true;
			else
				NATUREZA_COMBO.disabled = false;
			
			if(document.getElementById('sp_remetente_restrita').style.display == '' && NOME_REMETENTE_COMBO.options.length == 1)
				NOME_REMETENTE_COMBO.disabled = true;
			else
				NOME_REMETENTE_COMBO.disabled = false;
			
			if(document.getElementById('sp_destinatario_restrita').style.display == '' && NOME_DESTINATARIO_COMBO.options.length == 1)
				NOME_DESTINATARIO_COMBO.disabled = true;
			else
				NOME_DESTINATARIO_COMBO.disabled = false;
			
			if(document.getElementById('sp_consignatario_restrita').style.display == '' && NOME_CONSIGNATARIO_COMBO.options.length == 1)
				NOME_CONSIGNATARIO_COMBO.disabled = true;
			else
				NOME_CONSIGNATARIO_COMBO.disabled = false;
			
			if(document.getElementById('sp_redespacho_restrita').style.display == '' && NOME_REDESPACHO_COMBO.options.length == 1)
				NOME_REDESPACHO_COMBO.disabled = true;
			else
				NOME_REDESPACHO_COMBO.disabled = false;
			
			if(document.getElementById('sp_cobranca_restrita').style.display == '' && NOME_COBRANCA_COMBO.options.length == 1)
				NOME_COBRANCA_COMBO.disabled = true;
			else
				NOME_COBRANCA_COMBO.disabled = false;
			
			if(document.getElementById('sp_origem_restrita').style.display == '' && ORIGEM_MUNICIPIO_COMBO.options.length == 1)
				ORIGEM_MUNICIPIO_COMBO.disabled = true;
			else
				ORIGEM_MUNICIPIO_COMBO.disabled = false;
			
			if(document.getElementById('sp_destino_restrita').style.display == '' && DESTINO_MUNICIPIO_COMBO.options.length == 1)
				DESTINO_MUNICIPIO_COMBO.disabled = true;
			else
				DESTINO_MUNICIPIO_COMBO.disabled = false;
			
			// Se a SITUACAO_ID for 1 ou 2, permite alterar os dados da composio
			if(Number(SITUACAO_ID.value) == 1 && Number(LIBERADA_AGENDAMENTO.value) == 0) {
				MODALIDADE.disabled           = false;
				LIBERADA_AGENDAMENTO.disabled = false;
				f_muda_liberada_agendamento();
				MULTIPLA_SOLICITACAO.disabled = false;
				
				document.getElementById('COMPOSICAO').readOnly = false;
				for(var i = 1; i <= v_count_composicao.length; i++) {
					document.getElementById('COMPOSICAO_' + i).readOnly = false;
				}
				CPF_MOTORISTA.readOnly = false;
				document.getElementById('btn_add_composicao').disabled = false;
				document.getElementById('btn_localizar_motorista').disabled = false;
			}
			else {
				MODALIDADE.disabled           = true;
				LIBERADA_AGENDAMENTO.disabled = true;
				f_muda_liberada_agendamento();
				MULTIPLA_SOLICITACAO.checked  = false;
				MULTIPLA_SOLICITACAO.disabled = true;
				
				document.getElementById('COMPOSICAO').readOnly = true;
				for(var i = 1; i <= v_count_composicao.length; i++) {
					document.getElementById('COMPOSICAO_' + i).readOnly = true;
				}
				CPF_MOTORISTA.readOnly = true;
				document.getElementById('btn_add_composicao').disabled = true;
				document.getElementById('btn_localizar_motorista').disabled = true;
			}
		}
	}
	
	function f_on_cancelar() {
		catTree.closeAll();
		document.getElementById('arvore').disabled = true;
	}
	
	function f_muda_operacao() {
		with(document.forms[0]) {
			if(OPERACAO_ID.value == ""){
				OPERACAO_DESCRICAO.value = "";
				return false;
			}
			f_cria_carregando_ajax();		
			CONSULTA.value = 2; 
			target = 'consultas';
			action = 'consultas.cfm';
			submit();
		}
	}
	
	function f_muda_valor_em() {
		with(document.forms[0]) {
			switch(VALOR_EM.value) {
				case 'M3':
					document.getElementById('sp_m3').style.display = '';
					document.getElementById('sp_volumes').style.display = 'none';
					VALOR_UNITARIO.disabled = false;
					VALOR_UNITARIO.className = 'requerido_form';
					parent.f_obrigatorio(VALOR_UNITARIO, 1);
					break;
				case 'VOLUME':
					document.getElementById('sp_m3').style.display = 'none';
					document.getElementById('sp_volumes').style.display = '';
					VALOR_UNITARIO.disabled = false;
					VALOR_UNITARIO.className = 'requerido_form';
					parent.f_obrigatorio(VALOR_UNITARIO, 1);
					break;
				case 'PESO':
					document.getElementById('sp_m3').style.display = 'none';
					document.getElementById('sp_volumes').style.display = 'none';
					VALOR_UNITARIO.disabled = false;
					VALOR_UNITARIO.className = 'requerido_form';
					parent.f_obrigatorio(VALOR_UNITARIO, 1);
					break;
				case 'LOTACAO':
					document.getElementById('sp_m3').style.display = 'none';
					document.getElementById('sp_volumes').style.display = 'none';
					VALOR_UNITARIO.disabled = true;
					VALOR_UNITARIO.className = 'input_disable';
					parent.f_obrigatorio(VALOR_UNITARIO, 0);
					break;
				default:
					document.getElementById('sp_m3').style.display = 'none';
					document.getElementById('sp_volumes').style.display = 'none';
					VALOR_UNITARIO.disabled = false;
					VALOR_UNITARIO.className = 'requerido_form';
					parent.f_obrigatorio(VALOR_UNITARIO, 1);
					break;
			}
			f_calcula_peso(VALOR_EM);
		}
	}
	
	function f_busca_natureza(p_opcao) {
		with(document.forms[0]) {
			PESO_ESPECIFICO.value = 1;
			
			switch(p_opcao) {
				case 1:
					if(document.getElementById('sp_natureza_aberta').style.display == 'none') {
						NATUREZA_COMBO.value = NUM_NATUREZA.value;
						
						if(!NUM_NATUREZA.value) {
							return;
						}
						
						if(NATUREZA_COMBO.value) {
							PESO_ESPECIFICO.value = NATUREZA_COMBO.options[NATUREZA_COMBO.selectedIndex].getAttribute('peso_especifico');
						}
						else {
							alert('Natureza no permitida para a operao ' + OPERACAO_DESCRICAO.value + ', selecione uma das naturezas permitidas.');
							NUM_NATUREZA.focus();
						}
					}
					else {
						NATUREZA.value = '';
					
						if(!NUM_NATUREZA.value) {
							return;
						}
						NATUREZA.value = 'Buscando natureza...';
						f_query_wddx('<cf_url>/_transportes/consulta/cfc_emissao_documentos.cfc</cf_url>?method=get_natureza'
									,'num_natureza=' + NUM_NATUREZA.value
									,function(obj) {
										if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
											if(obj.struct.num_natureza.length > 0) {
												NATUREZA.value        = obj.struct.descricao[0];
												PESO_ESPECIFICO.value = obj.struct.peso_especifico[0];
											}
											else {
												NATUREZA.value = '';
												alert('Natureza no encontrada.');
												NUM_NATUREZA.focus();
											}
										}
									});
					}
					break;
				case 2:
					NUM_NATUREZA.value = NATUREZA_COMBO.value;
					break;
			}
			
			NOTA_NUM_NATUREZA.value = NUM_NATUREZA.value;
			NOTA_NUM_NATUREZA.onchange();
		}
	}
	
	function f_calcula_peso(obj) {
		with(document.forms[0]) {
			switch(VALOR_EM.value) {
				case 'M3':
					if(obj == PESO) {
						if(Number(PESO_ESPECIFICO.value) == 0) {
							M3.value = 0;
						}
						else {
							M3.value = Math.round(Number(PESO.value) / Number(PESO_ESPECIFICO.value), 2);
						}
					}
					else {
						PESO.value = Math.round(Number(M3.value) * Number(PESO_ESPECIFICO.value), 2);
					}
					break;
				case 'VOLUME':
					if(obj == PESO) {
						if(Number(QTDE_VOLUME.value) == 0) {
							PESO_VOLUME.value = 0;
						}
						else {
							PESO_VOLUME.value = Math.round(Number(PESO.value) / Number(QTDE_VOLUME.value), 2);
						}
					}
					else {
						PESO.value = Math.round(Number(PESO_VOLUME.value) * Number(QTDE_VOLUME.value), 2);
					}
					break;
				case 'PESO':
					
					break;
				case 'LOTACAO':
					
					break;
				default:
					
					break;
			}
		}
		f_calcula_valor();
	}
	
	function f_calcula_valor(obj) {
		with(document.forms[0]) {
			switch(VALOR_EM.value) {
				case 'M3':
					if(obj == VALOR_TOTAL) {
						VALOR_UNITARIO.value = Number(Number(VALOR_TOTAL.value) / Number(M3.value)).toFixed(2);
					}
					else {
						VALOR_TOTAL.value = Number(Number(VALOR_UNITARIO.value) * Number(M3.value)).toFixed(2);
					}
					break;
				case 'VOLUME':
					if(obj == VALOR_TOTAL) {
						VALOR_UNITARIO.value = Number(Number(VALOR_TOTAL.value) / Number(QTDE_VOLUME.value)).toFixed(2);
					}
					else {
						VALOR_TOTAL.value = Number(Number(VALOR_UNITARIO.value) * Number(QTDE_VOLUME.value)).toFixed(2);
					}
					break;
				case 'LOTACAO':
					// No altera o Valor
					break;
				default:
					if(obj == VALOR_TOTAL) {
							if(PESO.value == ''){
								alert('Informe o Peso.');
								VALOR_TOTAL.value = '';
								 return;
							}
							if(PESO.value == 0){
								alert('O Peso deve ser maior que zero.');
								VALOR_TOTAL.value = '';
								 return;
							}																			
						VALOR_UNITARIO.value = Number((Number(VALOR_TOTAL.value) / Number(PESO.value))).toFixed(2);

						}
						else if(obj == VALOR_UNITARIO){
							if(PESO.value == ''){
								alert('Informe o Peso.');
								VALOR_UNITARIO.value = '';
								return;
							}	
							if(PESO.value == 0){
								alert('O Peso deve ser maior que zero.');
								VALOR_TOTAL.value = '';
								 return;
							}							
							VALOR_TOTAL.value = Number(Number(VALOR_UNITARIO.value) * Number(PESO.value)).toFixed(2);
					}
					else {
						VALOR_TOTAL.value = Number(Number(VALOR_UNITARIO.value) * Number(PESO.value)).toFixed(2);
					}
					break;
			}
		}
	}
	
	function f_valida_data_campo(p_campo, p_data) {
		v_display = p_campo.getAttribute('display').toString();
		if(Number(p_campo.value.getDateTime()) < Number(p_data)) {
			alert('O campo ' + v_display + ' deve ser maior que a data atual.');
			p_campo.select();
			return false;
		}
		else if (Number(p_campo.value.getDateTime()) > Number(p_data)+(30*24*60*60*1000)) {
			alert('O campo ' + v_display + ' no pode ser maior que ' + (new Date(Number(new Date()) + (30 * 24 * 60 * 60 * 1000))).format('dd/mm/yyyy hh24:mi') + '.');
			p_campo.select();
			return false;	
		}
		return true;
	}
	
	var v_count_composicao = 0;
	
	function f_add_composicao() {
		with(document.forms[0]) {
			v_div = document.getElementById('dv_composicao');
			v_dv = document.createElement('span');
			v_count_composicao++;
			v_dv.innerHTML = '&nbsp;<input type="text" name="COMPOSICAO" id="COMPOSICAO_' + v_count_composicao + '" readonly="false" onChange="f_change_composicao(this)" onBlur="f_change_composicao(this)" onKeyPress="return f_formata(this, event, \'AAAAAAAAAAAAAAAAAA\')" />';
			v_div.appendChild(v_dv);
			document.getElementById('COMPOSICAO_' + v_count_composicao).readOnly = false;
			document.getElementById('COMPOSICAO_' + v_count_composicao).select();
		}
	}
	
	function f_change_composicao(v_obj) {
		if(v_obj.value == '') {
			v_obj.parentNode.parentNode.removeChild(v_obj.parentNode);
			return;
		}
	}
	
	function f_limpa_composicao() {
		v_div = document.getElementById('dv_composicao');
		
		for(i = v_div.childNodes.length - 1; i >= 0; i--) {
			v_div.removeChild(v_div.childNodes[i]);
		}
		
		v_count_composicao = 0;
	}
	
	function f_busca_composicao() {
		with(document.forms[0]) {
			NOME_MOTORISTA.value = '';
			COD_MOTORISTA.value = '';
			CPF_MOTORISTA.value = '';
			if(document.getElementById('COMPOSICAO').value == '') {
				f_limpa_composicao();
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_veiculo.cfc</cf_url>?method=get_composicao'
						,'cod_veiculo='+document.getElementById('COMPOSICAO').value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.cod_veiculo.length > 0 && obj.struct.cod_veiculo[0] != -1) {
									f_limpa_composicao();
									for(var i=0;i<obj.struct.cod_veiculo.length;i++) {
										if(i == 0) {
											document.getElementById('COMPOSICAO').value = obj.struct.cod_veiculo[0];
											MODALIDADE_VEICULO.value = obj.struct.modalidade[0];
											f_busca_motorista();
										}
										else {
											f_add_composicao();
											document.getElementById('COMPOSICAO_'+v_count_composicao).value = obj.struct.cod_veiculo[i];
										}
									}
								}
							}
						});
		}
	}
	
	function f_busca_motorista() {
		with(document.forms[0]) {
			COD_MOTORISTA.value  = '';
			CPF_MOTORISTA.value  = '';
			NOME_MOTORISTA.value = '';
			
			if(!document.getElementById('COMPOSICAO').value) {
				f_busca_historico_cartao();
				
				return;
			}
			
			NOME_MOTORISTA.value = 'Aguarde, buscando dados...';
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_veiculo.cfc</cf_url>?method=get_motorista_proprietario'
						,'placa_controle=' + document.getElementById('COMPOSICAO').value
						+'&trata_erro=2'
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.erro == 'true') {
									alert(obj.struct.mensagem.detail.replace(/^ORA-20000: |ORA-[0-9]{5}.*|\n/g, ''));
								 	COD_MOTORISTA.value  = '';
									CPF_MOTORISTA.value  = '';
									NOME_MOTORISTA.value = '';
								}
								else{
									if(obj.struct.cod_pessoa_proprietario[0] != '') {
										COD_MOTORISTA.value = obj.struct.cod_pessoa_motorista;
										CPF_MOTORISTA.value = obj.struct.cpf_motorista;
									 	NOME_MOTORISTA.value = obj.struct.nome_motorista;
										f_verifica_bloqueio_motorista();
								   	}
							  	}
								
								f_busca_historico_cartao();
							}
						});
		}
	}
	
	function f_busca_dados(p_solicitacao_carga_id, p_editar) {
		with(document.form_transportes) {
			CONSULTA.value = 1; // Todos os Dados
			SOLICITACAO_CARGA_ID.value = p_solicitacao_carga_id;
			EDITAR.value = p_editar;
			target = 'consultas';
			action = '<cf_url>/aplicacoes/transporte/logistica/solicitacao/consultas.cfm</cf_url>';
			submit();
		}
	}
	
	function f_localizar_motorista(){
		with(document.form_transportes) {
			var v_modalidade;
			
			if(MODALIDADE_VEICULO.value == 'AGREGADO'){
				v_modalidade = '2,6';
			}else{
				v_modalidade = '2,6,8';
			}
			
			NewWindow('<cf_url>/_consultas/localizar_pessoa.cfm</cf_url>?field=COD_PESSOA,CNPJ_CPF,CLIENTE&campo=COD_MOTORISTA,CPF_MOTORISTA,NOME_MOTORISTA&funcao=f_verifica_bloqueio_motorista()&num_modalidade=' + v_modalidade,'_blank',800,600,'yes');
		}
	}
	
	function f_muda_liberada_agendamento() {
		with(document.forms[0]) {
			if(MODALIDADE.value == 'FROTA' && Number(LIBERADA_AGENDAMENTO.value) == 1) {
				GERA_ROMANEIO.disabled = false;
			}
			else if(MODALIDADE.value == 'AGREGADO' && Number(LIBERADA_AGENDAMENTO.value) == 1) {
				GERA_ROMANEIO.disabled = false;
			}
			else {
				GERA_ROMANEIO.checked  = false;
				GERA_ROMANEIO.disabled = true;
			}
		}
	}
	
	function f_muda_modalidade() {
		with(document.forms[0]){
			if(MODALIDADE.value == 'FROTA') {
				GERA_ROMANEIO.disabled   = false;
				
				CARTAO_NUMERO.value		 = '';
				ADTO_TRAJETO_VAZIO.value = '';
				
				document.getElementById('dados_repom').style.display = 'none';
			}
			else if(MODALIDADE.value == 'AGREGADO') {
				GERA_ROMANEIO.disabled = false;
				
				if(Number(TIPO_PAGAMENTO_ID.value) == 2) {
					document.getElementById('dados_repom').style.display = '';
				}
				else {
					document.getElementById('dados_repom').style.display = 'none';
				}
			}
			else {
				GERA_ROMANEIO.checked  = false;
				GERA_ROMANEIO.disabled = true;
				
				if(Number(TIPO_PAGAMENTO_ID.value) == 2) {
					document.getElementById('dados_repom').style.display = '';
				}
				else {
					document.getElementById('dados_repom').style.display = 'none';
				}
			}
		}
	}
	
	function f_muda_especie() {
		with(document.forms[0]) {
			NOTA_NUM_ESPECIE.value = NUM_ESPECIE.value;
			NFE_NUM_ESPECIE.value = NUM_ESPECIE.value;
			OUTROS_NUM_ESPECIE.value = NUM_ESPECIE.value;
			
			NOTA_NUM_ESPECIE.onchange();
			NFE_NUM_ESPECIE.onchange();
			OUTROS_NUM_ESPECIE.onchange();
		}
	}
	
	function f_busca_historico_cartao() {
		with(document.forms[0]) {
			if(Number(TIPO_PAGAMENTO_ID.value) != 2 || !COD_MOTORISTA.value) {
				CARTAO_NUMERO_HISTORICO.value = '';
				f_validar_cartao_historico();
				
				return;
			}
			
			f_query_wddx('<cf_url>/_transportes/consulta/transporte/cfc_repom.cfc</cf_url>?method=get_historico_cartao'
							,'cod_motorista=' + COD_MOTORISTA.value
							,function(obj) {
								if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
									if(obj.struct.cartao_numero.length > 0) {
										CARTAO_NUMERO_HISTORICO.value = obj.struct.cartao_numero[0];
										
										if(!CARTAO_NUMERO.value) {
											CARTAO_NUMERO.value = obj.struct.cartao_numero[0];
										}
									}
									else {
										CARTAO_NUMERO_HISTORICO.value = '';
									}
									
									f_validar_cartao_historico();
								}
							});
		}
	}
	
	function f_validar_cartao_historico() {
		with(document.forms[0]) {
			if(CARTAO_NUMERO_HISTORICO.value && CARTAO_NUMERO.value != CARTAO_NUMERO_HISTORICO.value) {
				document.getElementById('tr_info_cartao_historico').style.display = '';
				document.getElementById('sp_info_cartao_historico').innerHTML = 'Nmero do ltimo carto Repom utilizado por este motorista: ' + CARTAO_NUMERO_HISTORICO.value + '.';
			}
			else {
				document.getElementById('tr_info_cartao_historico').style.display = 'none';
				document.getElementById('sp_info_cartao_historico').innerHTML = '';
			}
		}
	}
	
	function f_visualizar_cartao_historico() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/aplicacoes/transporte/repom/consulta_cartao/principal.cfm</cf_url>?CARTAO_NUMERO=' + CARTAO_NUMERO_HISTORICO.value, '', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}
	
	function f_verifica_bloqueio_motorista(){
		with(document.forms[0]){
			if(COD_MOTORISTA.value != ''){
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_emissao_documentos.cfc</cf_url>?method=verifica_bloqueio_motorista'
						,'cod_motorista=' + COD_MOTORISTA.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.motorista_bloqueado.length > 0) {
									if(Number(obj.struct.motorista_bloqueado[0]) > 0){
								   	  alert('O motorista ' + NOME_MOTORISTA.value + ' est bloqueado.');
								    }
								}
							}
						});
		}
	}
	}
	
	function f_verifica_bloqueio_veiculo(){
		with(document.forms[0]){
			var placa_controle = COMPOSICAO.value.split(',');
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_emissao_documentos.cfc</cf_url>?method=verifica_bloqueio_veiculo'
						,'placa=' + placa_controle[0]
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.veiculo_bloqueado.length > 0) {
								   if(Number(obj.struct.veiculo_bloqueado[0]) > 0){
									 alert('O veculo ' + placa_controle[0] + ' est bloqueado.');
								   }
								}
							}
						});
		}
	}

	function f_busca_crt(){
		with(document.forms[0]) {
			if(!NUM_CRT_COMPLETO.value){
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_transp_internacional.cfc</cf_url>?method=get_crt'
						,'num_crt_completo='+NUM_CRT_COMPLETO.value
						,function(obj){
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								//alert(obj.struct.conhecimento_id);
								if(obj.struct.conhecimento_id.length == 1){
									INTC_CONHECIMENTO_ID.value = obj.struct.conhecimento_id[0];
									document.getElementById('dados_crt').innerHTML = 'Cliente: ' + obj.struct.rem_nome[0] + ' Pedido Shipment: ' + obj.struct.pedido_shipment[0] + ' Qtde. Embarques:' + obj.struct.qtde_veiculos[0] + ' Peso Bruto: ' + obj.struct.peso_bruto[0];
 								    f_busca_crt_divisao();
								}else{
									alert("C.R.T. no encontrado. Verifique o nmero do conhecimento informado.");
									document.getElementById('dados_crt').innerHTML = '';
									NUM_CRT_COMPLETO.value = '';
									INTC_CONHECIMENTO_ID.value = "";
								}
							}
						});
		}
	}


	function f_busca_crt_divisao(){
		with(document.forms[0]) {
			f_query_ajax('<cf_url>/aplicacoes/transporte/logistica/solicitacao/consultas.cfm</cf_url>?consulta=3&conhecimento_id=' + INTC_CONHECIMENTO_ID.value
						,function(obj) {
							if(obj.ajax.readyState == 4) {
								if(obj.ajax.status == 200) {
									document.getElementById('span_divisoes').style.display = '';
									document.getElementById('span_divisoes').innerHTML = obj;
							   }
							   else {
									document.getElementById('span_divisoes').style.display = '';
									document.getElementById('span_divisoes').style.width = '100%';
									document.getElementById('span_divisoes').style.height = '100%';
									document.getElementById('span_divisoes').innerHTML = obj;
							   }
							}
						});
		}
	}

</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KMM :..</title>
<link href="<cf_url>/_estilos/abas.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
<script src="/_scripts/dragdrop/drag.js"></script>
<script src="/_scripts/dragdrop/tree.js"></script>
</head>
<body class="background" style="height:100%; overflow:auto">
<form id="form_transportes" name="form_transportes" method="post" action="" enctype="multipart/form-data">
  <input name="OPERACAO" type="hidden" value="" sempre_ativo="1">
  <input name="OPERACAO_OLD" type="hidden" value="" sempre_ativo="1">
  <input name="CONSULTA" type="hidden" value="" sempre_ativo="1">
  <input name="EDITAR" type="hidden" value="" sempre_ativo="1">
  <input name="SOLICITACAO_CARGA_ID" type="hidden" value="" sempre_ativo="1">
  <input name="SITUACAO_ID" type="hidden" value="" sempre_ativo="1">
  <input name="COD_ORGANOGRAMA" type="hidden" value="<cfoutput>#session.cod_organograma#</cfoutput>" sempre_ativo="1" fixo="1" obrigatorio="1" display="LOTAO DO USURIO">
  <input name="COD_MOTORISTA" type="hidden" value="" sempre_ativo="1" fixo="1" obrigatorio="0" >
  <input name="MODALIDADE_VEICULO" type="hidden" value="" sempre_ativo="1" fixo="1" obrigatorio="0" >
  <input name="TIPO_PAGAMENTO_ID" id="TIPO_PAGAMENTO_ID" type="hidden" value="" sempre_ativo="1">
  <input name="SOLICITACAO_CARGA_ID_VINCULO" id="SOLICITACAO_CARGA_ID_VINCULO" type="hidden" value="" sempre_ativo="1">
  <input name="CARTAO_NUMERO_HISTORICO" id="CARTAO_NUMERO_HISTORICO" type="hidden" value="" sempre_ativo="1" />
  <input name="TIPO_DOCTO_FRETE" id="TIPO_DOCTO_FRETE" type="hidden" sempre_ativo="1" />
  <input name="INTC_CONHECIMENTO_ID" type="hidden" id="INTC_CONHECIMENTO_ID" fixo="1" sempre_ativo="1"/>
	<table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0">
           <tr valign="top">
             <td width="1%">
             <table width="250" height="100%" border="0" cellspacing="0" cellpadding="0">
              <tr>
                <td height="1"><button type="button" class="botao-16x16" onClick="catTree.openAll()"><img src="/_imagens/botoes/16x16/expandir_projeto_escopo.gif" alt="Expandir Tudo" title="Expandir Tudo" width="16" height="16" align="absmiddle" /></button>
                  <button type="button" class="botao-16x16" onClick="catTree.closeAll()"><img src="/_imagens/botoes/16x16/contrair_projeto_escopo.gif" alt="Contrair Tudo" title="Contrair Tudo" width="16" height="16" align="absmiddle" /></button></td>
              </tr>
              <tr>
                <td><div id="arvore" class="lista">
                	<link rel="StyleSheet" href="/_scripts/dragdrop/tree.css" type="text/css" />
				  	<script type="text/javascript">
						<!--
						var catTree = new Tree('servTree', { 
							imgPath:'/_scripts/dragdrop/tree/',
							defaultNodeConfig: { 
								onclick: function(obj) {
									with(document.forms[0]) {
										OPERACAO_ID.value = obj.data['operacao_id'];
										f_muda_operacao();
									}
								}
							}
						});
						node = catTree.addNode(0,-1,"Operaes");
						node.data["operacao_id"] = '';
						node.data["descricao"] = '';
						node.data["carregado"] = true;
						node.setHaveChildren(true);
						node.select(true);
						
						<cfoutput query="qrOperacao">
						node = catTree.addNode(#qrOperacao.operacao_id#,#qrOperacao.operacao_id_pai_nvl#,"#Replace(qrOperacao.descricao, '"', '', 'ALL')#");
						node.data["operacao_id"] = "#qrOperacao.operacao_id#";
						node.data["descricao"] = "#Replace(qrOperacao.descricao, '"', '', 'ALL')#";
						node.data["carregado"] = true;
						<cfif qrOperacao.possui_filhos>
  						   node.setHaveChildren(true);
						</cfif>
						</cfoutput>
						
						catTree.moveObj.enabled = false;
						catTree.print();
						//-->
            	  	</script>
                </div></td>
              </tr>
            </table>
            </td>
             <td width="1%" class="separador">&nbsp;</td>
             <td width="98%" valign="top"><div class="lista">
             
             <table width="100%" border="0" cellspacing="1" cellpadding="3">
               <tr class="texto">
                 <td width="1%">Opera&ccedil;&atilde;o:</td>
                 <td width="99%">
                 <input type="text" name="OPERACAO_ID" onChange="f_muda_operacao()" id="OPERACAO_ID" display="OPERAO" obrigatorio="1" style="width: 60px"  sempre_ativo="1">
                 <input type="text" name="OPERACAO_DESCRICAO" id="OPERACAO_DESCRICAO" readonly style="width: 496px">                 
                 </td>
               </tr>
               <tr class="texto">
                 <td>Natureza:</td>
                 <td><input type="text" name="NUM_NATUREZA" id="NUM_NATUREZA" maxlength="10" obrigatorio="1" tipo="numerico" display="NATUREZA" onChange="f_busca_natureza(1)" onKeyPress="return f_formata(this, '0000000000')" style="width:60px;" />
                    <span id="sp_natureza_restrita" style="display: none;">
                        <select name="NATUREZA_COMBO" id="NATUREZA_COMBO" display="NATUREZA" onChange="f_busca_natureza(2)">
                        </select>
                    </span>
                    <span id="sp_natureza_aberta">
                        <input type="text" name="NATUREZA" id="NATUREZA" readonly display="NATUREZA" style="width: 296px;" />&nbsp;
                        <button type="button" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_natureza.cfm?num_natureza=NUM_NATUREZA&natureza=NATUREZA', '_blank', 640, 480, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Natureza" title="Buscar Natureza" width="16" height="16" align="absmiddle" /></button>
                    </span>
                 </td>
               </tr>
               <cfset pessoa_cliente_cod = 'COD_REMETENTE'>
               <cfset pessoa_cliente_pref = 'REMETENTE'>
               <cfset pessoa_cliente_descricao = 'Remetente'>
               <cfset pessoa_cliente_descricao2 = 'remetentes'>
               <cfset pessoa_cliente_obrigatorio = '1'>
               <cfinclude template="#f_url('/aplicacoes/transporte/logistica/solicitacao/forms/pessoa_cliente.cfm')#">
               <cfset pessoa_cliente_cod = 'COD_DESTINATARIO'>
               <cfset pessoa_cliente_pref = 'DESTINATARIO'>
               <cfset pessoa_cliente_descricao = 'Destinatrio'>
               <cfset pessoa_cliente_descricao2 = 'destinatrios'>
               <cfset pessoa_cliente_obrigatorio = '1'>
               <cfinclude template="#f_url('/aplicacoes/transporte/logistica/solicitacao/forms/pessoa_cliente.cfm')#">
               <tr class="texto" height="1">
                 <td>Origem:</td>
                 <td>
			      <input name="ORIGEM_MUNICIPIO_ID" type="hidden" value="" sempre_ativo="1" obrigatorio="1" display="ORIGEM">
                 <span id="sp_origem_restrita" style="display: none"><select name="ORIGEM_MUNICIPIO_COMBO" id="ORIGEM_MUNICIPIO_COMBO" onChange="document.forms[0].ORIGEM_MUNICIPIO_ID.value = this.value">
                 </select>
                 </span><span id="sp_origem_aberta">
                  <input type="text" name="ORIGEM_MUNICIPIO" id="ORIGEM_MUNICIPIO" style="width: 350px" readonly tabindex="-1">
                   <button type="button" class="botao-16x16" onClick="NewWindow('<cf_url>/_consultas/localizar_cidade.cfm</cf_url>?municipio_id=ORIGEM_MUNICIPIO_ID&municipio_uf=ORIGEM_MUNICIPIO','_blank',800,600,'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" align="absmiddle" height="16" width="16" /></button>
                 </span>
                  </td>
               </tr>
               <tr class="texto" height="1">
                 <td>Destino:</td>
                 <td>
                   <input name="DESTINO_MUNICIPIO_ID" type="hidden" value="" sempre_ativo="1" obrigatorio="1" display="DESTINO">
                   <span id="sp_destino_restrita" style="display: none"><select name="DESTINO_MUNICIPIO_COMBO" id="DESTINO_MUNICIPIO_COMBO" onChange="document.forms[0].DESTINO_MUNICIPIO_ID.value = this.value">
                     </select>
                     </span><span id="sp_destino_aberta">
                      <input type="text" name="DESTINO_MUNICIPIO" id="DESTINO_MUNICIPIO" style="width: 350px" readonly tabindex="-1">
                      <button type="button" class="botao-16x16" onClick="NewWindow('<cf_url>/_consultas/localizar_cidade.cfm</cf_url>?municipio_id=DESTINO_MUNICIPIO_ID&municipio_uf=DESTINO_MUNICIPIO','_blank',800,600,'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" align="absmiddle" height="16" width="16" /></button>
                      </span>
                   </td>
               </tr>
               <tr class="texto" height="1">
                 <td>Modalidade:</td>
                 <td><select name="MODALIDADE" id="MODALIDADE" obrigatorio="0" display="MODALIDADE" onChange="f_muda_modalidade();">
                   <option value="">-- No Definida --</option>
                   <cfoutput query="qrModalidade">
                     <option value="#qrModalidade.rv_low_value#">#qrModalidade.rv_abbreviation#</option>
                     </cfoutput>
                   </select>
                   &nbsp;&nbsp;&nbsp;
                   Liberada p/ Agendamento:
                   <select name="LIBERADA_AGENDAMENTO" id="LIBERADA_AGENDAMENTO" obrigatorio="1" display="LIBERADA PARA AGENDAMENTO" onChange="f_muda_liberada_agendamento()" style="width: 50px;">
                     <option value="">---</option>
                     <option value="0">N&atilde;o</option>
                     <option value="1">Sim</option>
                   </select><span id="sp_situacao" class="obrigatorio" style="margin-left: 20px;"></span></td>
               </tr>
               <tr class="texto" height="1">
                 <td>Prioridade:</td>
                 <td><select name="PRIORIDADE" id="PRIORIDADE" display='PRIORIDADE CARGA' obrigatorio="1" fixo="1">
                   <cfoutput query="qrPrioridade">
                     <option value="#qrPrioridade.rv_low_value#">#qrPrioridade.rv_abbreviation#</option>
                   </cfoutput>
                   </select></td>
               </tr>
               <tr id="tr_multipla_solicitacao" class="texto" height="1">
                   <td>&nbsp;</td>
                   <td><nobr><input type="checkbox" name="MULTIPLA_SOLICITACAO" id="MULTIPLA_SOLICITACAO" class="check" value="1" />&nbsp;<label for="MULTIPLA_SOLICITACAO">Selecione para Gerar M&uacute;ltiplas Solicita&ccedil;&otilde;es de Cargas</label></nobr></td>
               </tr>
               <tr id="tr_gerar_romaneio" class="texto" height="1">
                   <td>&nbsp;</td>
                   <td><nobr><input type="checkbox" name="GERA_ROMANEIO" id="GERA_ROMANEIO" class="check" value="1" />&nbsp;<label for="GERA_ROMANEIO">Selecione para Gerar Romaneio (Modalidades Frota e Agregado)</label></nobr></td>
               </tr>
               <tr class="texto" height="1">
                 <td nowrap>Valor Mercadorias:</td>
                 <td><input type="text" name="VALOR_TOTAL_NF" id="VALOR_TOTAL_NF" obrigatorio="1" readonly display="VALOR (NOTAS FISCAIS)" style="width: 85px;" />
                 	Valor Sugerido:
                    <input type="text" name="VALOR_TOTAL_SUGERIDO" id="VALOR_TOTAL_SUGERIDO" maxlength="15" obrigatorio="<cfoutput>#v_valor_sug_obrigatorio#</cfoutput>" tipo="numerico" display="VALOR SUGERIDO" onChange="this.value = toCurrency(this.value);" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 85px;" />
               </tr>
               <tr class="texto" height="1" id="tr_internacional" style="display:none">
                 <td colspan="2"><fieldset>
                   <legend>Docto Internacional</legend>
                   <table width="100%" border="0" cellspacing="1" cellpadding="2" class="texto">
                     <tr>
                       <td width="4%" nowrap="nowrap">CRT:</td>
                       <td width="96%"><input name="NUM_CRT_COMPLETO" display="DOCTO INTERNACIONAL" type="text" id="NUM_CRT_COMPLETO" style="width:110px" onKeyPress="return f_formata(this, 'XX.000.000000')" onChange="f_busca_crt()" />&nbsp;<div style="position:absolute; float:left; width:70%; height:100%; vertical-align:middle" id="dados_crt" class="texto_negrito">&nbsp;</div></td>
                     </tr>
                     <tr>
                       <td colspan="2" nowrap="nowrap"><span id="span_divisoes" style="position:relative; border:1px solid black; background:white; display:none"></span></td>
                       </tr>
                   </table>
                 </fieldset></td>
               </tr>
               <tr class="texto" height="1">
                 <td colspan="2">
                 	<fieldset id="fld_composicao"><legend>Composio Sugerida</legend>
                    <table width="100%" border="0" cellspacing="1" cellpadding="3">
						<tr class="texto">
                        	<td width="1%">Ve&iacute;culos:</td>
                            <td width="99%"><input type="text" name="COMPOSICAO" id="COMPOSICAO" readonly onChange="f_busca_composicao()" onKeyPress="return f_formata(this,event,'AAAAAAAAAAAAAAAAAA')" obrigatorio="0" display="VEICULOS" ><span id="dv_composicao"></span>
                            	<button type="button" id="btn_add_composicao" class="botao-16x16" onClick="f_add_composicao()"><img src="/_imagens/botoes/16x16/mais.gif" align="absmiddle" height="16" width="16" /></button></td>
                   		</tr>
                        <tr class="texto">
                        	<td>Motorista:</td>
							<td><input type="text" name="CPF_MOTORISTA" id="CPF_MOTORISTA" readonly onKeyPress="return f_formata(this,event,'00000000000000')" tipo="numerico" >&nbsp;
                            	<button type="button" id="btn_localizar_motorista" class="botao-16x16" onClick="f_localizar_motorista();"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Motorista" align="absmiddle" height="16" width="16" /></button>
                                <input type="text" name="NOME_MOTORISTA" id="NOME_MOTORISTA" readonly style="width:395px"></td>
						</tr>
                        <tr id="tr_info_cartao_historico" style="display: none;">
                            <td nowrap class="texto"></td>
                            <td nowrap class="texto"><span id="sp_info_cartao_historico" class="obrigatorio"></span>&nbsp;
                                <button type="button" class="botao-16x16" onClick="f_visualizar_cartao_historico()"><img src="/_imagens/botoes/16x16/repom.gif" alt="Visualizar Hist&oacute;rico do Cart&atilde;o" title="Visualizar Hist&oacute;rico do Cart&atilde;o" width="16" height="16" align="absmiddle" /></button></td>
                        </tr>
					</table>
                    </fieldset>
                  </td>
               </tr> 
               <tr id="dados_repom" style="display:none">
               	  <td colspan="2">
                  	<fieldset><legend>Repom</legend>
                    	<table width="100%" height="100%" border="0" cellspacing="2" cellpadding="3">
                        	<tr class="texto">
                            	<td nowrap width="1%">N&deg; Cart&atilde;o:</td>
                                <td width="99%"><input type="text" name="CARTAO_NUMERO" id="CARTAO_NUMERO" maxlength="20" tipo="numerico" display="NMERO DO CARTO REPOM" onChange="f_validar_cartao_historico()" onKeyPress="return f_formata(this,event,'00000000000000000000')"  style="width: 150px;" />&nbsp;
                                	<span class="obrigatorio">* N&uacute;mero que consta no verso do cart&atilde;o Repom.</span></td>
                            </tr>
                            <tr class="texto">
                            	<td nowrap>Adto. Trajeto Vazio:</td>
                                <td><input type="text" name="ADTO_TRAJETO_VAZIO" id="ADTO_TRAJETO_VAZIO"  tipo="numerico" display="ADTO. TRAJETO VAZIO" onChange="this.value = toCurrency(this.value);" onBlur="this.value = toCurrency(this.value);" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 85px;" /></td>
                            </tr>
                        </table>
                    </fieldset>
                  </td>
               </tr>  
               <tr class="texto">
                 <td colspan="2"><table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" id="tbl_abas">
                   <tr>
                     <td height="1" width="1%"><nobr>Carregamento</nobr></td>
                     <td width="1%"><nobr>Coleta/Entrega/Cobran&ccedil;a</nobr></td>
                     <td width="1%"><nobr>Notas Fiscais</nobr></td>
                     <td width="1%"><nobr>Observa&ccedil;&otilde;es</nobr></td>
                     <td width="98%">&nbsp;</td>
                   </tr>
                   <tr>
                     <td colspan="5" valign="top"><table width="100%" border="0" cellspacing="1" cellpadding="3">
                       <tr>
                         <td><fieldset>
                           <legend>Frete</legend>
                           <table width="100%" border="0" cellspacing="1" cellpadding="3">
                             <tr class="texto">
                               <td width="8%" height="26">Frete em:</td>
                               <td valign="top"><select name="VALOR_EM" id="VALOR_EM" obrigatorio="1" display="FRETE EM" onChange="f_muda_valor_em()">
                               		<option value="">-- Selecione --</option>
                                    <cfoutput query="qrValorEm">
                                    <option value="#qrValorEm.rv_low_value#">#qrValorEm.rv_abbreviation#</option>
									</cfoutput>
                               </select>
                               <span id="sp_m3" style="display:none">
                                 <nobr>M<sup>3</sup>:
                                 <input type="text" name="M3" id="M3" style="width:50px" onKeyPress="return f_formata_numero_decimal(this,event)" onChange="f_calcula_peso(this)">&nbsp;
                                 Peso Espec&iacute;fico: <input type="text" name="PESO_ESPECIFICO" id="PESO_ESPECIFICO" onKeyPress="return f_formata_numero_decimal(this,event)" style="width: 70px" onChange="f_calcula_peso(this)"></nobr>
                               </span><span id="sp_volumes" style="display:none">
                                 
                                </span></td>
                               </tr>
                             <tr class="texto">
                               <td>Volumes:</td>
                               <td><nobr> 
                                 <input type="text" name="QTDE_VOLUME" id="QTDE_VOLUME" style="width:50px" onKeyPress="return f_formata_numero_decimal(this,event)" onChange="f_calcula_peso(this)">
                                 Peso do Volume:
                                 <input type="text" name="PESO_VOLUME" id="PESO_VOLUME" style="width:70px" onKeyPress="return f_formata_numero_decimal(this,event)" onChange="f_calcula_peso(this)"></nobr></td>
                             </tr>
                             <tr class="texto">
                               <td>Peso em:</td>
                               <td><select name="COD_UNIDADE" id="COD_UNIDADE" obrigatorio="1" display="PESO EM" onChange="f_calcula_peso(this)" ativo="0">
                               		<option value="">-- Selecione --</option>
                                    <cfoutput query="qrUnidade">
                                    <option value="#qrUnidade.cod_unidade#" equivalencia_kg="#qrUnidade.equivalencia_kg#">#qrUnidade.unidade#</option>
                                    </cfoutput>
                               </select>
                                 Esp&eacute;cie/Embalagem:
                                 <select name="NUM_ESPECIE" id="NUM_ESPECIE" obrigatorio="1" display="ESPECIE/EMBALAGEM" onChange="f_muda_especie()">
                               		<option value="">-- Selecione --</option>
                                    <cfoutput query="qrEspecie">
                                    <option value="#qrEspecie.num_especie#">#qrEspecie.descricao#</option>
                                    </cfoutput>
                               </select>
                                 Peso:
                                 <input type="text" name="PESO" id="PESO" style="width:70px" onKeyPress="return f_formata_numero_decimal(this,event)" tipo="numerico" obrigatorio="1" display="PESO TOTAL" onChange="f_calcula_peso(this)"></td>
                               </tr>
                             <tr class="texto">
                               <td><nobr>Valor Unit&aacute;rio:</nobr></td>
                               <td><input type="text" name="VALOR_UNITARIO" id="VALOR_UNITARIO" style="width:70px" onKeyPress="return f_formata_numero_decimal(this,event)" tipo="numerico" obrigatorio="0" display="VALOR UNITARIO"  onChange="f_calcula_valor(this)">
                                 Valor Total:
                                 <input type="text" name="VALOR_TOTAL" id="VALOR_TOTAL" style="width:70px" onKeyPress="return f_formata_numero_decimal(this,event)" tipo="numerico" obrigatorio="1" display="VALOR TOTAL" onChange="f_calcula_valor(this)"></td>
                             </tr>
                           </table>
                         </fieldset></td>
                         </tr>
                       <tr>
                         <td><fieldset>
                           <legend>Agendamento</legend>
                           <table border="0" cellspacing="1" cellpadding="3">
                             <tr>
                               <td width="50%"><fieldset>
                                 <legend>Carregamento</legend>
                                 <table width="100%" border="0" cellspacing="1" cellpadding="3">
                                   <tr class="texto">
                                     <td width="2%"><nobr>Data de In&iacute;cio:</nobr></td>
                                     <td width="98%"><input type="text" name="DATA_CARREGAMENTO_INICIO" id="DATA_CARREGAMENTO_INICIO" style="width:110px" obrigatorio="1" display="DATA DE INICIO DE CARREGAMENTO" onKeyPress="return f_formata(this,event,'00/00/0000 00:00')" />
                                       <button id="btn_DATA_CARREGAMENTO_INICIO" type="button" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="" width="16" height="16" align="absmiddle"></button></td>
                                     </tr>
									<script>
                                    Calendar.setup({
                                        inputField  : "DATA_CARREGAMENTO_INICIO",      // ID of the input field
                                        ifFormat    : "%d/%m/%Y %H:%M",    // the date format
                                        button      : "btn_DATA_CARREGAMENTO_INICIO",    // ID of the button
                                        range       : [2001,2050],
                                        showsTime	: true
                                    });
                                    </script>
                                   <tr class="texto">
                                     <td><nobr>Data de T&eacute;rmino:</nobr></td>
                                     <td><input type="text" name="DATA_CARREGAMENTO_FIM" id="DATA_CARREGAMENTO_FIM" style="width:110px" obrigatorio="1" display="DATA DE TERMINO DE CARREGAMENTO" onKeyPress="return f_formata(this,event,'00/00/0000 00:00')" />
                                       <button id="btn_DATA_CARREGAMENTO_FIM" type="button" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="" width="16" height="16" align="absmiddle"></button></td>
                                     </tr>
									<script>
                                    Calendar.setup({
                                        inputField  : "DATA_CARREGAMENTO_FIM",      // ID of the input field
                                        ifFormat    : "%d/%m/%Y %H:%M",    // the date format
                                        button      : "btn_DATA_CARREGAMENTO_FIM",    // ID of the button
                                        range       : [2001,2050],
                                        showsTime	: true
                                    });
                                    </script>
                                   </table>
                                 </fieldset></td>
                               <td width="50%"><fieldset>
                                 <legend>Entrega</legend>
                                 <table width="100%" border="0" cellspacing="1" cellpadding="3">
                                   <tr class="texto">
                                     <td width="19%">Data de In&iacute;cio:</td>
                                     <td width="81%"><input type="text" name="DATA_ENTREGA_INICIO" id="DATA_ENTREGA_INICIO" style="width:110px" obrigatorio="1" display="DATA DE INICIO DE ENTREGA" onKeyPress="return f_formata(this,event,'00/00/0000 00:00')" />
                                       <button id="btn_DATA_ENTREGA_INICIO" type="button" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="" width="16" height="16" align="absmiddle"></button></td>
                                     </tr>
									<script>
                                    Calendar.setup({
                                        inputField  : "DATA_ENTREGA_INICIO",      // ID of the input field
                                        ifFormat    : "%d/%m/%Y %H:%M",    // the date format
                                        button      : "btn_DATA_ENTREGA_INICIO",    // ID of the button
                                        range       : [2001,2050],
                                        showsTime	: true
                                    });
                                    </script>
                                   <tr class="texto">
                                     <td><nobr>Data de T&eacute;rmino:</nobr></td>
                                     <td><input type="text" name="DATA_ENTREGA_FIM" id="DATA_ENTREGA_FIM" style="width:110px" obrigatorio="1" display="DATA DE TERMINO DE ENTREGA" onKeyPress="return f_formata(this,event,'00/00/0000 00:00')" />
                                       <button id="btn_DATA_ENTREGA_FIM" type="button" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="" width="16" height="16" align="absmiddle"></button></td>
                                     </tr>
									<script>
                                    Calendar.setup({
                                        inputField  : "DATA_ENTREGA_FIM",      // ID of the input field
                                        ifFormat    : "%d/%m/%Y %H:%M",    // the date format
                                        button      : "btn_DATA_ENTREGA_FIM",    // ID of the button
                                        range       : [2001,2050],
                                        showsTime	: true
                                    });
                                    </script>
                                   </table>
                                 </fieldset></td>
                               </tr>
                           </table>
                         </fieldset></td>
                         </tr>
                     </table></td>
                     </tr>
                   <tr>
                     <td colspan="5" valign="top"><table width="100%" border="0" cellspacing="1" cellpadding="3">
					   <cfset pessoa_cliente_cod = 'COD_CONSIGNATARIO'>
                       <cfset pessoa_cliente_pref = 'CONSIGNATARIO'>
                       <cfset pessoa_cliente_descricao = 'Local de Coleta'>
                       <cfset pessoa_cliente_descricao2 = 'locais de coleta'>
		               <cfset pessoa_cliente_obrigatorio = '0'>
                       <cfinclude template="#f_url('/aplicacoes/transporte/logistica/solicitacao/forms/pessoa_cliente.cfm')#">
					   <cfset pessoa_cliente_cod = 'COD_REDESPACHO'>
                       <cfset pessoa_cliente_pref = 'REDESPACHO'>
                       <cfset pessoa_cliente_descricao = 'Local de Entrega'>
                       <cfset pessoa_cliente_descricao2 = 'locais de entrega'>
		               <cfset pessoa_cliente_obrigatorio = '0'>
                       <cfinclude template="#f_url('/aplicacoes/transporte/logistica/solicitacao/forms/pessoa_cliente.cfm')#">
					   <cfset pessoa_cliente_cod = 'COD_COBRANCA'>
                       <cfset pessoa_cliente_pref = 'COBRANCA'>
                       <cfset pessoa_cliente_descricao = 'Cliente Cobrana'>
                       <cfset pessoa_cliente_descricao2 = 'clientes de cobrana'>
		               <cfset pessoa_cliente_obrigatorio = '0'>
                       <cfinclude template="#f_url('/aplicacoes/transporte/logistica/solicitacao/forms/pessoa_cliente.cfm')#">
                     </table></td>
                   </tr>
                   <tr>
                     <td colspan="5" valign="top"><cfinclude template="#f_url('/aplicacoes/transporte/logistica/solicitacao/forms/notas_fiscais.cfm')#"></td>
                   </tr>
                   <tr>
                     <td colspan="5" valign="top"><textarea name="OBSERVACAO" id="OBSERVACAO" style="width:100%; height:150px"></textarea></td>
                   </tr>
                 </table>
                 <script>
				 initAbas('tbl_abas',0);
				 </script>
                 </td>
                </tr>
             </table></div></td>
           </tr>
         </table>
</form>

<span id="span_consultas" style="position: absolute; top: 0px; left:0px; border:1px solid black; background:white; display:none"></span>
<script>
	document.getElementById('arvore').disabled = true;
	<cfif not len(trim(session.cod_organograma))>
		alert('O usurio atual no possui lotao, impossvel prosseguir.');
		parent.document.getElementById('btn_voltar').click();
	</cfif>
</script>
</body>
</html>
<iframe name="consultas" frameborder="0" width="100%" height="600" src="" style="display:none;"></iframe>