<html>
<cfinclude template="/_scripts/scripts.cfm" />
<cfscript>
	// ChartDirector for ColdFusion API Access Point
	cd = CreateObject("java", "ChartDirector.CFChart");
	
	// A utility to allow us to create arrays with data in one line of code
	function Array() {
		var result = ArrayNew(1);
		var i = 0;
		for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
			result[i] = arguments[i];
		return result;
	}


	conn = CreateComponent("_transportes.consulta.cfc_acesso");
	qrUsuario = conn.get_usuarios_modulo(modulo_id = 29, usuario = session.usuario);
	
	if(qrUsuario.RecordCount and qrUsuario.NIVEL_ACESSO eq 10) {
		v_administrador = true;
	}
	else {
		v_administrador = false;
	}
	
	conn = CreateComponent('_transportes.consulta.logistica.cfc_faturamento');
	if(qrUsuario.RecordCount and qrUsuario.NIVEL_ACESSO eq 10) { 
		qrFaturamentoEstimativa = conn.get_faturamento_estimativa_gerencial(data_ontem = LSDateFormat((Now()), 'dd/mm/yyyy'));
		qrIndicador = conn.get_faturamento_indicador_gerencial(data = LSDateFormat((Now()), 'dd/mm/yyyy'));
	}
	else {
		qrFaturamentoEstimativa = conn.get_faturamento_estimativa_gerencial(cod_centro_custo = session.cod_centro_custo, data_ontem = LSDateFormat((Now() - 1), 'dd/mm/yyyy'));
		qrIndicador = conn.get_faturamento_indicador_gerencial(cod_centro_custo = session.cod_centro_custo, data = LSDateFormat((Now()), 'dd/mm/yyyy'));
	}
	
	conn = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
	qrOrganizacional = conn.get_organizacional();
	
</cfscript>
<script type="text/javascript">
	// Configura botoes //
	var v_interval = 0;
	parent.f_set_texto('titulo_aplicacao', 'Faturamento');
	parent.f_set_texto('titulo_pagina', 'Cadastro de Estimativa Diria de Faturamento por Centro de Custo');
	
	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); }
	
	f_cria_botao('localizar', 'Localizar', 'f_localizar()', parent.document.getElementById('barra_botoes_top'));
	parent.f_hidden('btn_excluir');
	
	// -------------------- //
	
	function f_confirmar() {
		with(document.forms[0]) {
			if(f_ajax_running() > 0) {
				alert('Aguarde o trmino do processamento antes de confirmar.');
				return;
			}
			target = 'consultas';
			action = 'confirma.cfm';	
			if(f_verifica_form(document.forms[0])) {
				submit();
			}
		}
		return false;
	}
	parent.f_confirmar = f_confirmar;
	
	function f_localizar() {
		NewWindow('localizar.cfm', 'Localizar', '640', '480', 'yes');
	}
	parent.f_localizar = f_localizar;
	
	function f_busca_estimativa() {
		with(document.forms[0]) {
			ESTIMATIVA_ID.value = '';
			VALOR_ESTIMADO.value = '';
			
			if(!DATA_ESTIMATIVA.value || !COD_CENTRO_CUSTO.value) {													
				return;
			}			
			f_query_wddx('<cf_url>/_transportes/consulta/logistica/cfc_faturamento.cfc</cf_url>?method=get_faturamento_estimativa_gerencial'
						,'data_estimativa=' + DATA_ESTIMATIVA.value + '&cod_centro_custo=' + COD_CENTRO_CUSTO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {									
								if(obj.struct.estimativa_id.length > 0) {
									ESTIMATIVA_ID.value = obj.struct.estimativa_id[0];
									DATA_ESTIMATIVA.value = obj.struct.data_estimativa[0];
									VALOR_ESTIMADO.value = Number(obj.struct.valor_estimado[0]).toFixed(2);
									OPERACAO.value = 3; // Editar
									document.getElementById('sp_info').style.display = '';
								}
								else {
									OPERACAO.value = 2; // Incluir
									document.getElementById('sp_info').style.display = 'none';
								}
							} else VALOR_ESTIMADO.value = '';
						});
		}
	}
	
	function f_on_incluir() {
		with(document.forms[0]) {
			DATA_ESTIMATIVA.readOnly = false;
			document.getElementById('BTN_DATA_ESTIMATIVA').disabled = false;
		}
	}
	parent.f_on_incluir = f_on_incluir;
	
	function f_on_editar() {
		with(document.forms[0]) {
			DATA_ESTIMATIVA.readOnly = true;
			document.getElementById('BTN_DATA_ESTIMATIVA').disabled = true;
		}
	}
	parent.f_on_editar = f_on_editar;
	
	function f_busca_estimativas_cc() {
		with(document.forms[0]) {
			f_query_ajax('<cf_url>/aplicacoes/transporte/logistica/faturamento_gerencial/faturamento_estimativa/consultas.cfm</cf_url>' +
					'?consulta=1' +
					'&cod_centro_custo=' + COD_CENTRO_CUSTO.value
					,function(obj) {
						document.getElementById('td_estimativas').innerHTML = obj;
					});
		}
	}
	
	function f_seleciona_centro_custo() {
		with(document.forms[0]) { 
			for(var i = 0; i < COD_CENTRO_CUSTO.options.length; i++) {
				if(COD_CENTRO_CUSTO.options[i].codigo == COD_ORGANIZACIONAL.value) {
					COD_CENTRO_CUSTO.value = COD_CENTRO_CUSTO.options[i].value;
					COD_CENTRO_CUSTO.options[i].selected = true;
				}
			}
		}
	}
	
</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KM&amp;M :..</title>
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body class="background" style="height: 100%;">
<form id="form_transportes" name="form_transportes" method="post" action="" onSubmit="return f_confirmar()">
    <input type="hidden" name="OPERACAO" id="OPERACAO" value="" sempre_ativo="1" />
    <input type="hidden" name="CONSULTA" id="CONSULTA" value="" sempre_ativo="1" />
    <input type="hidden" name="ESTIMATIVA_ID" id="ESTIMATIVA_ID" value="" sempre_ativo="1" />
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
		<tr>
			<td>
                <fieldset><legend>Dados</legend>
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                    <tr>
                        <td width="1%"  nowrap class="texto">Centro de Custo:</td>
                        <td width="99%" class="texto">
                        <input name="COD_ORGANIZACIONAL" type="text" id="COD_ORGANIZACIONAL" onKeyPress="return f_formata(this,event,'AAAAAAAAAAAAAA')" onKeyUp="f_seleciona_centro_custo()" size="15" maxlength="15">
                        <select name="COD_CENTRO_CUSTO" id="COD_CENTRO_CUSTO" obrigatorio="1" display="CENTRO DE CUSTO" onChange="f_busca_estimativas_cc(); f_busca_estimativa();document.forms[0].COD_ORGANIZACIONAL.value=document.forms[0].COD_CENTRO_CUSTO.options[document.forms[0].COD_CENTRO_CUSTO.selectedIndex].codigo;" >
                            <option value="">-- Selecione --</option>
							<cfoutput query="qrOrganizacional">
                                <cfif qrOrganizacional.FOLHA eq 1>
                                      <option value="#qrOrganizacional.ORGANIZACIONAL_ID#" codigo="#qrOrganizacional.COD_ORGANIZACIONAL#" folha="#qrOrganizacional.FOLHA#">#qrOrganizacional.DESCRICAO_COMPLETA#</option>
                                </cfif>
                            </cfoutput>
                            </select></td>
                    </tr>
                    <tr>
                        <td width="1%"  nowrap class="texto">Data:</td>
                        <td width="99%" class="texto"><input type="text" name="DATA_ESTIMATIVA" id="DATA_ESTIMATIVA" maxlength="10" obrigatorio="1"  tipo="data" display="DATA" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 80px;" onChange="f_busca_estimativa()"/>
                            <button type="button" id="BTN_DATA_ESTIMATIVA" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle" /></button>
                            <script type="text/javascript"> 
                                Calendar.setup( {
                                    inputField  : "DATA_ESTIMATIVA",      // ID of the input field
                                    ifFormat    : "%d/%m/%Y",             // the date format
                                    button      : "BTN_DATA_ESTIMATIVA",  // ID of the button
                                    range       : [2001,2050]
                                } );
                            </script>&nbsp;
                            <span id="sp_info" class="obrigatorio" style="display: none;">Estimativa de faturamento j existente para data selecionada</span></td>
                    </tr>                    
                    <tr>
                        <td nowrap class="texto">Valor Estimado:</td>
                        <td class="texto"><input type="text" name="VALOR_ESTIMADO" id="VALOR_ESTIMADO" maxlength="19" obrigatorio="1" tipo="numerico" onChange="this.value = Number(this.value).toFixed(2);" onKeyPress="return f_formata_numero_decimal(this, event)" display="VALOR ESTIMADO" style="width: 150px;" />
                        &nbsp;</td>
                    </tr>
                </table>
                </fieldset>
			</td>
        </tr>
		<tr style="padding-top: 10px;">
			<td id="td_estimativas">
			<cfif qrFaturamentoEstimativa.RecordCount gt 0>       
                <div style="float:none">
                <table width="100" border="0" cellpadding="3" cellspacing="1">
                    <tr class="titulo_1">
                        <td colspan="3" align="center" nowrap>Estimativas</td>
                    </tr>
                    <tr class="titulo_2">
                        <td width="1%" align="left" nowrap>Centro de Custo</td>
                        <td width="1%" align="center" nowrap>Data</td>
                        <td width="1%" align="right" nowrap>Valor Estimado</td>
                    </tr>
                    <cfoutput query="qrFaturamentoEstimativa">
                    <tr class="linha_#(qrFaturamentoEstimativa.CurrentRow Mod 2) + 1#">
	                    <td width="1%" align="left" nowrap>#qrFaturamentoEstimativa.CENTRO_CUSTO#</td>
                        <td width="1%" align="center" nowrap>#qrFaturamentoEstimativa.DATA_ESTIMATIVA#</td>
                        <td width="1%" align="right" nowrap>#LSNumberFormat(qrFaturamentoEstimativa.VALOR_ESTIMADO, ',__.__')#</td>
                      </tr>
                    </cfoutput>                        
                </table>
                </div>
                <cfif IsDefined("qrIndicador") and qrIndicador.RecordCount gt 0>
					<cfoutput query="qrIndicador">                     
    <div style="float:left" >
                <table width="200" border="0" cellspacing="1" cellpadding="2">
  <tr>
    <td align="center" class="titulo_2">Dia #qrIndicador.DATA#</td>
  </tr>
  <tr>
    <td> <script language="JavaScript" src="/_scripts/FusionWidgets/JSClass/FusionCharts.js"></script>	                    
   <div id="chartdiv#qrIndicador.COD_CENTRO_CUSTO#">&nbsp;</div>
    <script type="text/javascript">
        var myChart = new FusionCharts("/_scripts/FusionWidgets/Charts/AngularGauge.swf", "EstimativaDiaria#qrIndicador.COD_CENTRO_CUSTO#", "305", "330", "0", "0");

		v_url  = escape('/aplicacoes/transporte/logistica/faturamento_gerencial/faturamento_estimativa/consultas_xml.cfm');
		v_url += escape('?centro_custo=#URLEncodedFormat(qrIndicador.CENTRO_CUSTO)#');
		v_url += escape('&cod_centro_custo=#URLEncodedFormat(qrIndicador.COD_CENTRO_CUSTO)#');
		v_url += escape('&data=#URLEncodedFormat(qrIndicador.DATA)#');
		v_url += escape('&consulta=2');
		v_url += escape('&altura=330');
		v_url += escape('&largura=305');
		v_url += escape('&fonte_titulo=18');
		v_url += escape('&valor_meta=#qrIndicador.VALOR_META#');
		v_url += escape('&perc_estimado=#qrIndicador.VALOR_ESTIMADO#');
		v_url += escape('&perc_solicitacoes=#qrIndicador.VALOR_SOLICIT_EXECUTADAS#');
		v_url += escape('&perc_realizado=#qrIndicador.VALOR_REALIZADO#');
		v_url += escape('&valor_custo_cf=#qrIndicador.VALOR_CUSTO_CF#');
		v_url += escape('&valor_receita_cf=#qrIndicador.VALOR_RECEITA_CF#');
		v_url += escape('&perc_carta_frete=#qrIndicador.PERC_CARTA_FRETE#');
		v_url += escape('&count_cf_avulsa=#qrIndicador.COUNT_CF_AVULSA#');
		v_url += escape('&valor_custo_cf_avulsa=#qrIndicador.VALOR_CUSTO_CF_AVULSA#');
		v_url += escape('&rnd=' + Number(new Date()));
		
        myChart.setDataURL(v_url);
        myChart.render("chartdiv#qrIndicador.COD_CENTRO_CUSTO#");
   </script>
   </td>
  </tr>
  <tr style="display:none">
    <td><table width="100%" border="0" cellspacing="1" cellpadding="2" class="texto">
  <tr>
    <td width="1%"><nobr>Meta:(100%)</nobr></td>
    <td width="99%" align="right">#LSNumberFormat(qrIndicador.VALOR_META,',.__')#</td>
  </tr>
  <tr>
    <td style="color:##0066FF">Estimado:</td> 
    <td align="right" style="color:##0066FF">#LSNumberFormat(qrIndicador.VALOR_ESTIMADO,',.__')#</td>
  </tr>
  <tr>
    <td style="color:##9D9D00">Solicitaes:</td>
    <td align="right" style="color:##9D9D00">#LSNumberFormat(qrIndicador.VALOR_SOLICIT_EXECUTADAS,',.__')#</td>
  </tr>
  <tr>
    <td style="color:##009933">Realizado:</td>
    <td align="right" style="color:##009933">#LSNumberFormat(qrIndicador.VALOR_REALIZADO,',.__')#</td>
  </tr>
</table>
</td>
  </tr>
</table></div>
</cfoutput>

                </cfif>
            </cfif>
            </td>
        </tr>
    </table>
</form>
</body>
</html>
<iframe name="consultas" frameborder="0" width="100%" height="600" src="" style="display:none;"></iframe>