<cfswitch expression="#vars.CONSULTA#">
	<cfcase value="1">
		<cfscript>
            conn = CreateComponent('_transportes.consulta.logistica.cfc_faturamento');
            qrIndicadorEmpresa = conn.get_faturamento_indicador_empresa_gerencial(data_inicio = vars.DATA_INICIO, data_termino = vars.DATA_TERMINO);
        </cfscript>        
        <chart exportShowMenuItem='1' exportAction='download' exportFileName='faturamento_filial' showExportDialog='1' exportHandler='http://#CGI.HTTP_HOST#/_class/funcoes/FCExporter.php' exportEnabled='1' labelDisplay='Stagger'  bgColor='#FFFFFF' showBorder='0' PYAxisName='Faturamento R$' SYAxisName='Acumulado' palette='1' useRoundEdges='1' numberPrefix='R$ ' sNumberPrefix='R$ ' formatNumberScale='0' sFormatNumberScale='0' thousandSeparator='.' decimalSeparator=',' forceDecimals='1' decimals='2' sDecimals='2' showValues='0' caption="Faturamento - Empresa" subCaption="Acumulado">
            <categories>
                <cfoutput query="qrIndicadorEmpresa">
	                <category label='#LSDateFormat(qrIndicadorEmpresa.DATA,"dd/mm")#' />
                </cfoutput>
                <category label='ACUM' />
            </categories>
            
            <dataset seriesName='Meta' parentYAxis='P' renderAs='LINE' lineThickness='4' color='FF0000'>
                <cfoutput query="qrIndicadorEmpresa">
                    <set value='#qrIndicadorEmpresa.VALOR_META#' />
                </cfoutput>
                <set value='' />
            </dataset>

            <dataset seriesName='Estimado' parentYAxis='P' renderAs='LINE' color='CCCCCC'>
                <cfoutput query="qrIndicadorEmpresa">
                    <set value='#qrIndicadorEmpresa.VALOR_ESTIMADO#' />
                </cfoutput>
                <set value='' />
            </dataset>

            <dataset seriesName='Solicita<cfoutput>#chr(231)##chr(245)#</cfoutput>es' parentYAxis='P' renderAs='LINE' color='EFEA27'>
                <cfoutput query="qrIndicadorEmpresa">
                    <set value='#qrIndicadorEmpresa.VALOR_SOLICIT_EXECUTADAS#' />
                </cfoutput>
                <set value='' />
            </dataset>
            
            <dataset seriesName='Realizado' parentYAxis='P' renderAs='LINE' lineThickness='4' color='009933'>
                <cfoutput query="qrIndicadorEmpresa">
                    <set value='#qrIndicadorEmpresa.VALOR_REALIZADO#' />
                </cfoutput>
                <set value='' />
            </dataset>
            
            <dataset seriesName='' parentYAxis='S' renderAs='COLUMN' color='FF0000'>
                <cfoutput query="qrIndicadorEmpresa">
	                <set value='' />
                </cfoutput>
                <set value='<cfoutput>#ArraySum(ListToArray(ValueList(qrIndicadorEmpresa.VALOR_META)))#</cfoutput>' />
            </dataset>
            
            <dataset seriesName='' parentYAxis='S' renderAs='COLUMN' color='009933'>
                <cfoutput query="qrIndicadorEmpresa">
	                <set value='' />
                </cfoutput>
                <set value='<cfoutput>#ArraySum(ListToArray(ValueList(qrIndicadorEmpresa.VALOR_REALIZADO)))#</cfoutput>' />
            </dataset>
			<styles>
				<definition>
					<style name='myCaptionFont' type='font' font='Verdana' size='18' color='000000' bold='1' underline='0'></style>
					<style name='legenda' type='font' font='Verdana' size='16' color='000000' bold='1' underline='0'></style>
					<style name='mySubCaptionFont' type='font' font='Verdana' size='11' color='000000' bold='1' ></style>
					<style name='myAxisTitlesFont' type='font' font='Verdana' size='14' bold='1' color='000000'></style>
				</definition>
				<application>
					<apply toObject='Legend' styles='legenda' />
					<apply toObject='Caption' styles='myCaptionFont' />
					<apply toObject='DATAVALUES' styles='mySubCaptionFont' />
					<apply toObject='DATALABELS' styles='mySubCaptionFont' />						
					<apply toObject='XAxisName' styles='myAxisTitlesFont' />
					<apply toObject='YAxisName' styles='myAxisTitlesFont' />
				</application>
			</styles>            
        </chart>
	</cfcase>    
    
	<cfcase value="2">
		<cfscript>
            conn = CreateComponent('_transportes.consulta.logistica.cfc_faturamento');
            qrIndicadorEmpresa = conn.get_faturamento_indicador_centro_custo_gerencial(cod_centro_custo=vars.COD_CENTRO_CUSTO, data_inicio = vars.DATA_INICIO, data_termino = vars.DATA_TERMINO);
        </cfscript>        
        <chart exportShowMenuItem='1' exportAction='save' exportFileName='faturamento_filial' showExportDialog='1' exportEnabled='1' exportHandler='http://#CGI.HTTP_HOST#/_class/funcoes/FCExporter.php' labelDisplay='Stagger'  bgColor='#FFFFFF' showBorder='0' PYAxisName='Faturamento R$' SYAxisName='Acumulado' palette='1' useRoundEdges='1' numberPrefix='R$ ' sNumberPrefix='R$ ' formatNumberScale='0' sFormatNumberScale='0' thousandSeparator='.' decimalSeparator=',' forceDecimals='1' decimals='2' sDecimals='2' showValues='0' caption="Faturamento - <cfoutput>#qrIndicadorEmpresa.CENTRO_CUSTO#</cfoutput>" subCaption="Acumulado">
            <categories>
                <cfoutput query="qrIndicadorEmpresa">
	                <category label='#LSDateFormat(qrIndicadorEmpresa.DATA,"dd/mm")#' />
                </cfoutput>
                <category label='ACUM' />
            </categories>
            
            <dataset seriesName='Meta' parentYAxis='P' renderAs='LINE' color='FF0000'>
                <cfoutput query="qrIndicadorEmpresa">
                    <set value='#qrIndicadorEmpresa.VALOR_META#' />
                </cfoutput>
                <set value='' />
            </dataset>

            <dataset seriesName='Estimado' parentYAxis='P' renderAs='LINE' color='CCCCCC'>
                <cfoutput query="qrIndicadorEmpresa">
                    <set value='#qrIndicadorEmpresa.VALOR_ESTIMADO#' />
                </cfoutput>
                <set value='' />
            </dataset>

            <dataset seriesName='Solicita<cfoutput>#chr(231)##chr(245)#</cfoutput>es' parentYAxis='P' renderAs='LINE' color='EFEA27'>
                <cfoutput query="qrIndicadorEmpresa">
                    <set value='#qrIndicadorEmpresa.VALOR_SOLICIT_EXECUTADAS#' />
                </cfoutput>
                <set value='' />
            </dataset>
            
            <dataset seriesName='Realizado' parentYAxis='P' renderAs='LINE' color='009933'>
                <cfoutput query="qrIndicadorEmpresa">
                    <set value='#qrIndicadorEmpresa.VALOR_REALIZADO#' />
                </cfoutput>
                <set value='' />
            </dataset>
            
            <dataset seriesName='' parentYAxis='S' renderAs='COLUMN' color='FF0000'>
                <cfoutput query="qrIndicadorEmpresa">
	                <set value='' />
                </cfoutput>
                <set value='<cfoutput>#ArraySum(ListToArray(ValueList(qrIndicadorEmpresa.VALOR_META)))#</cfoutput>' />
            </dataset>
            
            <dataset seriesName='' parentYAxis='S' renderAs='COLUMN' color='009933'>
                <cfoutput query="qrIndicadorEmpresa">
	                <set value='' />
                </cfoutput>
                <set value='<cfoutput>#ArraySum(ListToArray(ValueList(qrIndicadorEmpresa.VALOR_REALIZADO)))#</cfoutput>' />
            </dataset>
			<styles>
				<definition>
					<style name='myCaptionFont' type='font' font='Verdana' size='18' color='000000' bold='1' underline='0'></style>
					<style name='mySubCaptionFont' type='font' font='Verdana' size='11' color='000000' bold='1' ></style>
					<style name='myAxisTitlesFont' type='font' font='Verdana' size='14' bold='1' color='000000'></style>
				</definition>
				<application>
					<apply toObject='Caption' styles='myCaptionFont' />
					<apply toObject='DATAVALUES' styles='mySubCaptionFont' />
					<apply toObject='DATALABELS' styles='mySubCaptionFont' />						
					<apply toObject='XAxisName' styles='myAxisTitlesFont' />
					<apply toObject='YAxisName' styles='myAxisTitlesFont' />
				</application>
			</styles>            
        </chart>
	</cfcase>        
   
	<cfdefaultcase>
		<script defer="defer">
	    	alert('Operação não programada.');
	 	</script>
  	</cfdefaultcase>
</cfswitch>        