<!--- FORMATO DO ARQUIVO
	- Registros do tipo 1 (primeira linha): 
		-> Data (com 8 caracteres) 
		-> Nome da empresa (com at 25 caracteres) 
	- Registros do tipo 2 (segunda linha): 
		-> Mensagem (com no mximo 135 caracteres) 
	- Registros do tipo 3 (demais linhas): 
		-> Celular (com 10 caracteres) 
		-> Nome (com at 30 caracteres) 
		-> Id do cliente (com at 30 caracteres) 
		-> Tel p/ contato (com at 20 caracteres) 
	- Registros do tipo 9 (ltima linha): 
		-> Nr. total de registros tipo 3 
--->
<cftry>
	<cfscript>
		conn_consult = CreateObject("component","_transportes.consulta.cfc_kmm_sms");
		conn_manip   = CreateObject("component","_transportes.manipulacao.cfc_kmm_sms");
	</cfscript>
	<cffile action="Upload"
		fileField="ARQUIVO"
		destination="#GetTempDirectory()#/mensagens.txt"
		nameConflict="Overwrite"
		accept="text/plain,text/richtext,application/vns.ms-excel,text/comma-separated-values">
	<cffile action="read" 
			file="#vars.ARQUIVO#" 
			variable="var.leitura" 
			charset="iso-8859-1"
			accept="text/plain,text/richtext,application/vns.ms-excel,text/comma-separated-values"> 

	<cfset delimitador = chr(10)>
	<cfloop index="row" list="#var.leitura#" delimiters="#delimitador#">
		<cfset tipo_registro = Left(row,1)>
		<cfswitch expression="#tipo_registro#">
			<cfcase value="2">
				<cfset vars.mensagem = Mid(row,2,134)>
			</cfcase>
			<cfcase value="3">
				<cfset vars.grupo_id = 1>
				<cfset vars.operadora_id = 1>
				<cfset vars.ddd = Mid(row,2,2)>
				<cfset vars.numero = Mid(row,4,8)>
				<cfset vars.proprietario = Mid(row,12,30)>
				<cfset vars.atributo3 = Mid(row,42,30)>
				<cfset vars.atributo2 = Mid(row,72,20)>				
				<cfscript>
					vars.LISTA_ATRIBUTOS = '2,3';
					set_manipulacao = conn_manip.ins_movel(argumentCollection = vars);
					fnc_trata_erros(struct_erro = set_manipulacao, mostra_msg_ok = false);
					v_data_hora = DateFormat(Now(),'dd/mm/yyyy') & ' ' & TimeFormat(Now(),'HH:MM');
					set_manipulacao = conn_manip.envia_mensagem(MOVEL_ID = set_manipulacao.movel_id,
																TEXTO = vars.mensagem,
																DATA_ENVIO = v_data_hora);
					fnc_trata_erros(struct_erro = set_manipulacao, mostra_msg_ok = false);		
				</cfscript>
			</cfcase>
		</cfswitch>
	</cfloop>
	<script>
		alert('Mensagens enviadas com sucesso! Para verificar o envio utilize o relatrio de mensagens enviadas(ENV).');
	</script>
<cfcatch>
	<cfif Find('The MIME type of ',cfcatch.Message)>
		<script>
			alert('Tipo de arquivo invlido, apenas TXT e CSV so aceitos.');
		</script>
	<cfelse>
		<script>
			alert('<cfoutput>#JSStringFormat(cfcatch.Detail)#</cfoutput>');
		</script>
	</cfif>
</cfcatch>
</cftry>

<cfset requestEnd = 0>