<cfscript>
	conn = CreateObject("component", "_transportes.consulta.cfc_funcionario");
	connHolerite = CreateObject("component", "_transportes.consulta.recursos_humanos.cfc_holerite_controle");
	qrLista = connHolerite.get_holerite_controle(cod_funcionario = vars.cod_funcionario, situacao_id = 5);
</cfscript>

<cfoutput query="qrLista">
	<cfscript>
        imprimir = true;
        administrador = true;
		vars.COD_FUNCIONARIO = qrLista.COD_FUNCIONARIO;
		vars.mes = qrLista.MES;
		vars.ano = qrLista.ANO;
        
        qrFuncAutorizados = conn.get_func_autorizados();
        if((not conn.get_trava_folha(argumentCollection = vars)) or administrador) {
            imprimir = true;
            qrFolha = conn.get_funcionarios_holerite(argumentCollection = vars);
            qrEventos = conn.get_holerite_eventos(argumentCollection = vars);
            qrVales = conn.get_vales_pessoais(cod_funcionario = vars.cod_funcionario, 
                                              mes_ano         = qrFolha.TO_CHAR_RH_RECIBO_MES_RH);
            if (vars.MES + 1 gt 12) {
                V_MES = 1;
                V_ANO = vars.ANO + 1;
            }
            else { 
                V_MES = vars.MES+1;
                V_ANO = vars.ANO;
            }	
        } else {
            imprimir = false;
        }	
    </cfscript>
    <cfif not imprimir and not administrador>
        <script>
            alert('Impressao de recibo de holerite nao autorizada!');
            top.window.close();
        </script>    
    </cfif>
    <cfdocument name="pdf_holerite#qrLista.COD_FUNCIONARIO#_#Trim(qrLista.MES)#_#Trim(qrLista.ANO)#" format="pdf" >
    <style type="text/css">
	  body {
		 margin-left:2cm;  
	  }
	  table {
          font-family:Verdana, Geneva, sans-serif;
      }
      .titulo_1 {
        font-size: 18px;
        font-weight: bold;
      }
      .titulo_2 {
        font-size: 14px;
        font-weight: bold;
      }  
      .texto {
        font-size: 12px;
      }
	  .texto_negrito2 {
		font-size: 16px;
		font-weight:bold;
	  }    
	  .texto_negrito {
        font-size: 12px;
        font-weight:bold;
      }  
      .texto_eventos {
        font-size: 10px;
      }
      .texto_eventos_complemento {
        font-size: 9px;
        font-style:italic;
      }
    
    </style>
    <body>
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td colspan="2"><table width="100%" border="0" cellspacing="0" cellpadding="0">
              <tr>
                <td width="21%" rowspan="4" align="center" valign="top" style="padding-bottom:2px"><img src="/delpozo/_imagens/logos/logo_relatorio.jpg" width="120" height="80"></td>
                <td colspan="2" class="titulo_1"><span class="texto">#qrFolha.RAZAO_SOCIAL#</span></td>
                </tr>
              <tr>
                <td width="45%"><span class="texto">#qrFolha.ENTREPOSTO_ENDERECO_ENTRE#</span><span class="texto"></span></td>
                <td width="34%" rowspan="3" align="center" class="titulo_1">&nbsp;</td>
              </tr>
              <tr>
                <td><span class="texto">#qrFolha.SUBSTR_ENTREPOSTO_CGC_1#</span></td>
                </tr>
              <tr>
                <td class="texto_negrito">Compet&ecirc;ncia: <span class="texto_negrito2">#qrFolha.TO_CHAR_RH_RECIBO_MES_RH#</span></td>
                </tr>
              <tr>
                <td colspan="3" align="center" valign="top" style="padding-bottom:2px;border-top:5px ##000 solid;" class="titulo_1">Recibo de Pagamento</td>
              </tr>
            </table></td>
          </tr>
          <tr >
            <td colspan="2" style="border-top:2px ##000 solid"><table width="100%" border="0" cellspacing="2" cellpadding="0">
              <tr class="texto_negrito">
                <td width="75%">Funcion&aacute;rio</td>
                <td width="5%" align="center">CBO</td>
                <td width="8%" align="center">Local</td>
                <td width="7%" align="center">Depto.</td>
                <td width="5%" align="center">Setor</td>
              </tr>
              <tr>
                <td><span class="texto">#qrFolha.RH_FUNCIONARIO_COD_FUNCIO#</span></td>
                <td align="center"><span class="texto">#qrFolha.CBO#</span></td>
                <td align="center"><span class="texto">#qrFolha.COD_ENTREPOSTO#</span></td>
                <td align="center"><span class="texto">#qrFolha.COD_DEPARTAMENTO#</span></td>
                <td align="center"><span class="texto">#qrFolha.COD_SETOR#</span></td>
              </tr>
            </table></td>
          </tr>
          <tr>
            <td colspan="2" align="center" class="titulo_1" style="border-top:1px ##000 solid">Demonstrativo</td>
          </tr>
          <tr>
            <td colspan="2"><table width="100%" border="0" cellspacing="0" cellpadding="2">
              <tr class="texto_negrito">
                <td width="4%" align="center">C&oacute;d.</td>
                <td width="60%">Descri&ccedil;&atilde;o</td>
                <td width="200" align="right">Refer&ecirc;ncia</td>
                <td width="200" align="right">Recebimentos</td>
                <td width="200" align="right">Descontos</td>
              </tr>
              <cfloop query="qrEventos">
                  <tr class="texto_eventos">
                    <td align="center">#qrEventos.COD_EVENTO#</td>
                    <td>#qrEventos.DESCRICAO#</td>
                    <td align="right">#qrEventos.REFERENCIA#</td>
                    <td align="right">#DecimalFormat(qrEventos.DECODE_RH_EVENTO_PROVENTO)#</td>
                    <td align="right">#DecimalFormat(qrEventos.DECODE_RH_EVENTO_PROVEN_2)#</td>
                  </tr>
                  <cfif Len(qrEventos.COMPLEMENTO_EVENTO) GT 0>
                      <tr class="texto_eventos_complemento">
                        <td align="center">&nbsp;</td>
                        <td>#qrEventos.COMPLEMENTO_EVENTO#</td>
                        <td align="right">&nbsp;</td>
                        <td align="right">&nbsp;</td>
                        <td align="right">&nbsp;</td>
                      </tr>
                  </cfif>
              </cfloop>
              <tr class="texto_negrito">
                <td style="border-top:1px ##000 solid" align="center">&nbsp;</td>
                <td style="border-top:1px ##000 solid" >&nbsp;</td>
                <td style="border-top:1px ##000 solid" align="right">&nbsp;</td>
                <td style="border-top:1px ##000 solid" align="right">#DecimalFormat(qrFolha.TOTAL_PROVENTOS)#</td>
                <td style="border-top:1px ##000 solid" align="right">#DecimalFormat(qrFolha.TOTAL_DESCONTOS)#</td>
              </tr>
            </table></td>
          </tr>
          <tr>
            <td colspan="2"><table width="100%" border="0" cellspacing="1" cellpadding="2">
              <tr class="titulo_1">
                <td width="84%" align="right">Valor L&iacute;quido:</td>
                <td width="16%" align="center" nowrap style="border:1px ##000 solid; background-color:##CCC">#DecimalFormat(qrFolha.VALOR_LIQUIDO)#</td>
              </tr>
            </table></td>
          </tr>
          <tr>
            <td colspan="2" style="border-top:1px ##000 solid; border-bottom:1px ##000 solid;"><table width="100%" border="0" cellspacing="0" cellpadding="2">
              <tr>
                <td width="16%" align="center" nowrap class="titulo_2">Sal&aacute;rio Base</td>
                <td width="16%" align="center" nowrap class="titulo_2">Sal. Contr.INSS</td>
                <td width="16%" align="center" nowrap class="titulo_2">Base C&aacute;lc.FGTS</td>
                <td width="16%" align="center" nowrap class="titulo_2">FGTS do M&ecirc;s</td>
                <td width="16%" align="center" nowrap class="titulo_2">Base C&aacute;lc. IRRF</td>
                <td width="16%" align="center" nowrap class="titulo_2">Faixa IRRF</td>
              </tr>
              <tr align="center">
                <td height="36" class="texto">#DecimalFormat(qrFolha.SALARIO_BASE)#</td>
                <td class="texto">#DecimalFormat(qrFolha.SALARIO_CONTR_INSS)#</td>
                <td class="texto">#DecimalFormat(qrFolha.BASE_CALC_FGTS)#</td>
                <td class="texto">#DecimalFormat(qrFolha.VALOR_FGTS)#</td>
                <td class="texto">#DecimalFormat(qrFolha.BASE_CALC_IRRF)#</td>
                <td class="texto">&nbsp;</td>
              </tr>
            </table></td>
          </tr>
          <tr>
            <td height="137" colspan="2"><table width="100%" border="0" cellspacing="0" cellpadding="2">
              <tr>
                <td height="52" colspan="2">&nbsp;</td>
              </tr>
              <tr>
                <td colspan="2" class="texto">Declaro ter recebido a impor&acirc;ncia l&iacute;quida acima discriminada no recibo de pagamento.</td>
              </tr>
              <tr>
                <td width="60%" height="51">&nbsp;</td>
                <td width="40%" align="center" valign="bottom" nowrap><span class="texto">___________________________________________<br>
                #qrFolha.RH_FUNCIONARIO_COD_FUNCIO#</span></td>
              </tr>
            </table></td>
          </tr>
          <tr>
            <td colspan="2">&nbsp;</td>
          </tr>
          <tr>
            <td colspan="2" align="center" class="titulo_1" style="border-top:5px ##000 solid; border-bottom:1px ##000 solid">Recibo de Adiantamento de Di&aacute;ria</td>
          </tr>
          <tr>
            <td colspan="2" class="texto" style="padding:4px 4px 4px 0px">
              Declaro que recebi de #qrFolha.RAZAO_SOCIAL# no curso do m&ecirc;s de #qrFolha.TO_CHAR_RH_RECIBO_MES_RH# os adiantamentos de di&aacute;ria abaixo relacionados:</td>
          </tr>
          <tr>
            <td colspan="2" class="texto"><table width="100%" border="0" cellspacing="0" cellpadding="2">
              <tr class="texto_negrito">
                <td width="9%">N&ordm; Vale</td>
                <td width="15%" align="center">Data Troca</td>
                <td width="62%">Local Troca</td>
                <td width="14%" align="right">Valor</td>
              </tr>
              <cfloop query="qrVales">
                  <tr class="texto_eventos">
                    <td>#qrVales.NUM_VALE#</td>
                    <td align="center">#qrVales.DATA_TROCA#</td>
                    <td>#qrVales.LOCAL_TROCA#</td>
                    <td align="right">#LSNumberFormat(qrVales.VALOR,',.__')#</td>
                </tr>
              </cfloop>
                  <tr class="texto_eventos">
                    <td style="border-top:1px ##000 solid; padding-top:3px">&nbsp;</td>
                    <td style="border-top:1px ##000 solid; padding-top:3px" align="center">&nbsp;</td>
                    <td style="border-top:1px ##000 solid; padding-top:3px">&nbsp;</td>
                    <td style="border-top:1px ##000 solid; padding-top:3px" align="right">#LSNumberFormat(ArraySum(ListToArray(ValueList(qrVales.VALOR))),',.__')#</td>
                  </tr>
            </table></td>
          </tr>
          <tr>
            <td height="63" colspan="2" class="texto">&nbsp;</td>
          </tr>
          <tr>
            <td height="24" colspan="2" class="texto">Para maior clareza firmo o presente </td>
          </tr> 
          <tr>
            <td width="18%" align="center" class="texto">#qrFolha.DATA_PAGAMENTO#</td>
            <td width="40%" align="center" nowrap><span class="texto">___________________________________________<br>
              #qrFolha.RH_FUNCIONARIO_COD_FUNCIO#</span></td>
          </tr>      
        </table>
    </body>    
    </cfdocument>    
</cfoutput>

<cfset path = ExpandPath("/delpozo/upload/temp")>
    <cfpdf action="merge" destination="#path#/holerite#vars.cod_funcionario#.pdf" overwrite="yes">
		<cfoutput query="qrLista">
           <cfpdfparam source="pdf_holerite#qrLista.COD_FUNCIONARIO#_#Trim(qrLista.MES)#_#Trim(qrLista.ANO)#">
		</cfoutput>
    </cfpdf>
<script>
  window.location = '/delpozo/upload/temp/holerite<cfoutput>#vars.cod_funcionario#</cfoutput>.pdf';
</script>