<cfif IsDefined("vars.MES_INICIAL")>
	<cfscript>
		conn = CreateComponent("_transportes.consulta.cfc_funcionario");
		qrOrganograma = conn.get_organograma(cod_pessoa = vars.COD_PESSOA_FILIAL);
		
		if(IsDefined("vars.MES_INICIAL")) {
			conn = CreateComponent("_transportes.consulta.qualidade.cfc_indicadores_qualidade");
			qrProdutosPerigosos = conn.get_produtos_perigosos(argumentCollection = vars);
		}
	</cfscript>
<cfelse>
	<script type="text/javascript">
		alert('Dados no definidos!');
		window.close();
	</script>
</cfif>

<cfdocument name="pdf_produtos_perigosos" format="pdf" orientation="portrait">
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Relatrio de Atividades de Transportes de Produtos Perigosos</title>
<style type="text/css">
	body {
		margin:  0;
		padding: 0;
	}	
	
	table.tabela_relatorio {
		border-collapse: collapse;
	}

	table.tabela_relatorio tr td {
		border: 		1px solid #333;
		font-family: 	Arial, Helvetica, sans-serif;
		font-stretch: 	condensed;
		font-size: 		10px;
		padding: 		3px;
	}
</style>
</head>
<body>
    <table width="100%" border="0" cellspacing="0" cellpadding="0" align="center" class="tabela_relatorio">
        <tr>
            <td height="50" colspan="3" align="center"><img src="<cf_url>/_imagens/logos/logo_relatorio.jpg</cf_url>" /></td>
            <td height="50" colspan="4" align="center" style="border-left: none;"><strong>RELAT&Oacute;RIO DE ATIVIDADES DE TRANSPORTE DE PRODUTOS PERIGOSOS</strong></td>
        </tr>
        <cfoutput>
        <tr bgcolor="##EEEEEE">
            <td height="30" colspan="3" align="left" style="border-top: none;">Per&iacute;odo: #qrProdutosPerigosos.PERIODO_INICIAL# a #qrProdutosPerigosos.PERIODO_FINAL#</td>
            <td height="30" colspan="4" align="left" style="border-top: none; border-left: none;">Unidade: #qrOrganograma.COD_UNIDADE_NEGOCIO# - #qrOrganograma.NOME_FANTASIA#</td>
		</tr>
        </cfoutput>
        <tr>
            <td align="left"  nowrap style="border-top: none;"><strong>Classifica&ccedil;&atilde;o</strong></td>
            <td align="left"  nowrap style="border-top: none; border-left: none;""><strong>Produtos Qu&iacute;micos</strong></td>
            <td align="right" nowrap style="border-top: none; border-left: none;"><strong>Quantidade</strong></td>
            <td align="left"  nowrap style="border-top: none; border-left: none;"><strong>Unidade</strong></td>
            <td align="right" nowrap style="border-top: none; border-left: none;"><strong>KM Percorrido</strong></td>
            <td align="left"  nowrap style="border-top: none; border-left: none;"><strong>Ocorr&ecirc;ncia</strong></td>
            <td align="left"  nowrap style="border-top: none; border-left: none;"><strong>Observa&ccedil;&otilde;es</strong></td>
        </tr>
        <cfoutput query="qrProdutosPerigosos">
        <tr>
            <td align="left"  nowrap style="border-top: none;">#qrProdutosPerigosos.CLASSIFICACAO#</td>
            <td align="left"  nowrap style="border-top: none; border-left: none;"">#qrProdutosPerigosos.PRODUTOS_QUIMICOS#</td>
            <td align="right" nowrap style="border-top: none; border-left: none;">#qrProdutosPerigosos.QUANTIDADE#</td>
            <td align="left"  nowrap style="border-top: none; border-left: none;">#qrProdutosPerigosos.UNIDADE#</td>
            <td align="right" nowrap style="border-top: none; border-left: none;">#qrProdutosPerigosos.KM_PERCORRIDO#</td>
            <td align="left"  nowrap style="border-top: none; border-left: none;">#qrProdutosPerigosos.OCORRENCIA#</td>
            <td align="left"  nowrap style="border-top: none; border-left: none;">#qrProdutosPerigosos.OBSERVACOES#</td>
        </tr>
        </cfoutput>
        <tr>
        	<td height="80" colspan="7" align="center" valign="top" style="border-top: none; padding-top: 5px;"><strong>RESUMO DAS OCORR&Ecirc;NCIAS</strong></td>
        </tr>
    </table>
</body>
</html>
<cfdocumentitem type="footer">
	<style type="text/css">
		body {
			margin: 0;
			padding: 0;
		}
		.fonte {
			font-family: Verdana, Arial, Helvetica, sans-serif;
			font-stretch: condensed;
			font-size: 10px;
		}
	</style>
	<table width="100%" border="0" cellpadding="0" cellspacing="0" class="fonte">
        <tr>
        	<td colspan="2">&nbsp;</td>
        </tr>
        <tr>
        	<td nowrap align="left"><cfoutput>#session.usuario# - #DateFormat(Now(), 'dd/mm/yyyy') & " " & TimeFormat(Now(), 'HH:mm:ss')#</cfoutput></td>
            <td nowrap align="right">P&aacute;ginas: <cfoutput>#cfdocument.CurrentPageNumber# de #cfdocument.TotalPageCount#</cfoutput></td>
        </tr>
    </table>
</cfdocumentitem>
</cfdocument>
<cfset path = ExpandPath("/temp")>
<cfset data_hora = DateFormat(Now(), 'ddmmyyyy') & "_" & TimeFormat(Now(), 'HHmmss')>
<cfpdf action="merge" destination="#path#/produtos_perigosos_#data_hora#.pdf" overwrite="yes">
	<cfpdfparam source="pdf_produtos_perigosos" />
</cfpdf>
<script>
	window.location = '/temp/produtos_perigosos_<cfoutput>#data_hora#</cfoutput>.pdf';
</script>