<cfscript>
   conn = CreateComponent("_transportes.consulta.qualidade.cfc_controle_documento");
   conn2 = CreateComponent("_transportes.consulta.qualidade.cfc_controle_registro");
	  qrArea = conn2.get_area();
   qrEmpresa = conn.get_empresa();
   qrDocumento = conn.get_documento_lista_mestre();
   qrInfoLista = conn.get_info_lista_mestre();
</cfscript>
<cfdocument name="pdf_sd" format="pdf" orientation="landscape" margintop="2.8" unit="cm" marginbottom="1.4" marginleft="0.5" marginright="0.5">
<html>
<head>
<style type="text/css">
* {
font-family: Arial, sans-serif;
}
th.rotate {
  height: 200px;
  white-space: nowrap;
}
th.rotate {
  width: 30px !important;
}
th.rotate > div {
  /* transform: translate(0px, 110px) rotate(-90deg); */
  width: 30px;
}

th.rotate > div > span {
  padding: 0px 5px;
}

.main-table tr th, .main-table tr td {
   border-collapse: collapse;
		 border-spacing:0;
		 padding: 3px;
		 margin:0;
	}
.main-table tr th {
   background-color: white;
}
.main-table tr td {
   font-size: 0.8em;
}

.center {
   text-align: center;
   vertical-align: middle;
}

.main-table {
   border-collapse: collapse;
}

.main-table tr:first-child {
   border-left: 1px solid black;
   border-top: 1px solid black;
   border-right: 1px solid black;
}
.main-table tr:first-child td {
   border: none;
   padding: 0;
}
.logotipo {
   padding: 2px;
}
td.aplicabilidade {
   text-align: center;
}
.titulo {
   font-size: 300px !important;
   font-weight: bold;
}

.top {border-top: 1px solid black;}
.right {border-right: 1px solid black;}
.bottom {border-bottom: 1px solid black;}
.left {border-left: 1px solid black;}
</style>
</head>
<body>
<cfdocumentitem type="header">
   <cfset imgLogotipo = ImageNew("#qrEmpresa.logotipo#")>
   <cfset ImageSetAntialiasing(imgLogotipo,"on")>
   <cfset ImageResize(imgLogotipo,"150%","")>
   <table cellspacing="0" width="100%" style="margin-bottom: 0;">
      <tr>
         <th style="text-align: left; width: 1%;" width="1%"><cfimage action="writeTobrowser" source="#imgLogotipo#" class="logotipo" style="padding: 5px; height: 200px; max-width: 1000px;"></td>
         <th class="titulo center" style="font-size: 40px; font-family: Arial; width: 99%;" width="99%">LISTA MESTRE DE DOCUMENTOS<br /><br /><span style="font-size: 30px;"><cfoutput>#qrInfoLista.codigo#</cfoutput></span></td>
      </tr>
   </table>
</cfdocumentitem>
<cfdocumentitem type= "footer">
      <div style="width: 100%; text-align: right; border-top: 2px solid #622423; padding-top: 2px; font-family: Arial; font-size: 12px;">
         <cfoutput>Pgina #cfdocument.currentpagenumber# de #cfdocument.totalpagecount#</cfoutput>
      </div>
</cfdocumentitem>
<cfoutput>

<table class="main-table" cellspacing="0" width="100%" style="margin-top: 5px;">
   <tr>
      <th rowspan="2" class="top bottom left right">DOCUMENTO</th>
      <th rowspan="2" class="top right bottom">NMERO - REVISO</th>
      <th colspan="#qrArea.RecordCount#" class="top right bottom">APLICABILIDADE</th>
   </tr>
   <tr>
     <cfloop query="qrArea">
        <cfset imgDescricao = ImageNew("",250,20, "rgb", "ffffff")>
        <cfset attr = StructNew()>
        <cfset attr.size = 15> 
        <cfset attr.style = 'bold'> 
<!---        <cfset attr.font = "Liberation Sans Regular"> --->
                <cfset attr.font = "Lucida Sans Regular">
        <cfset ImageSetBackgroundColor(imgDescricao,"white")>
        <cfset ImageSetDrawingColor(imgDescricao,"black")>
        <cfset ImageSetAntialiasing(imgDescricao,"on")>
        <cfset ImageDrawText(imgDescricao,#qrArea.DESCRICAO#,10,18, attr)> 
        <cfset ImageRotate(imgDescricao,-90)>
        <th style="width: 30px;" class="right bottom"><cfimage source="#imgDescricao#" action="writeToBrowser"></th>
     </cfloop>
   </tr>
   <cfloop query="qrDocumento">
   <cfset v_lista_aplicabilidade = ListToArray(qrDocumento.lista_aplicabilidade)>
      <tr>
      	<td class="left right bottom">#qrDocumento.titulo#</td>
      	<td class="center right bottom">#qrDocumento.codigo#-#qrDocumento.versao_atual#</td>
       <cfloop query="qrArea">
          <td class="center right bottom"><cfif arrayContains( v_lista_aplicabilidade, qrArea.area_id )>X<cfelse></cfif></td>
       </cfloop>
      </tr>
   </cfloop>
</table>
  
</cfoutput>
</body>
</html>
</cfdocument>
<cfset v_nome_arquivo = DateFormat(now(),'ddmmyyyy') & TimeFormat(now(),'hhmmss')>
<cfset path = ExpandPath("/temp")>
<cfpdf action="merge" destination="#path#/lista_mestre_#v_nome_arquivo#.pdf" overwrite="yes">
	<cfpdfparam source="pdf_sd" />
</cfpdf>
<script>
  window.location = "/temp/lista_mestre_<cfoutput>#v_nome_arquivo#</cfoutput>.pdf";
</script>