ç<cfscript>
	conn = CreateComponent('_transportes.consulta.qualidade.cfc_indicadores_qualidade');
</cfscript>

<cfswitch expression="#vars.CONSULTA#">
  <!---Treinamentos--->
  <cfcase value="1">
	<cfscript>
		qrTreinamentoTipo = conn.get_treinamentos_tipo(data_inicio = vars.data_inicio, data_termino = vars.data_termino);
	</cfscript>	
        <chart caption="Treinamentos" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" /> subcaption="Total de <cfoutput>#qrTreinamentoTipo.RecordCount#</cfoutput> treinamento(s)">
			<cfoutput query="qrTreinamentoTipo">
            	<set label="#qrTreinamentoTipo.DESCRICAO#" value="#qrTreinamentoTipo.QUANTIDADE#" toolText="#qrTreinamentoTipo.DESCRICAO# - #qrTreinamentoTipo.PORCENTAGEM#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo_principal.xml" />
        </chart>
  </cfcase>
  <cfcase value="2">
     <cfscript>
		qrTreinamentoInstrutor = conn.get_treinamentos_instrutor(data_inicio = vars.data_inicio, data_termino = vars.data_termino);
	</cfscript>	
        <chart caption="Instrutores" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" />>
			<cfoutput query="qrTreinamentoInstrutor">
            	<set label="#qrTreinamentoInstrutor.DESCRICAO_ABRV#" value="#qrTreinamentoInstrutor.QUANTIDADE#" toolText="#qrTreinamentoInstrutor.DESCRICAO# - #qrTreinamentoInstrutor.PORCENTAGEM#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo.xml" />
        </chart>
  </cfcase>
  <cfcase value="3">
     <cfscript>
		qrTreinamentoParticipante = conn.get_treinamentos_participante(data_inicio = vars.data_inicio, data_termino = vars.data_termino);
	</cfscript>	
        <chart caption="Participantes" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" />>
			<cfoutput query="qrTreinamentoParticipante">
            	<set label="#qrTreinamentoParticipante.DESCRICAO_ABRV#" value="#qrTreinamentoParticipante.QUANTIDADE#" toolText="#qrTreinamentoParticipante.DESCRICAO# - #qrTreinamentoParticipante.PORCENTAGEM#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo.xml" />
        </chart>
  </cfcase>
  
  <!---Fornecedores--->
  <cfcase value="4">
     <cfscript>
		qrFornecedoresClassificacao = conn.get_fornecedor_classificacao();
	</cfscript>	
        <chart caption="<cfoutput>#ToString(toBinary(toBase64('Classificação')), 'utf-8')#</cfoutput>" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" />>
			<cfoutput query="qrFornecedoresClassificacao">
            	<set label="#qrFornecedoresClassificacao.DESCRICAO_ABRV#" value="#qrFornecedoresClassificacao.QUANTIDADE#" toolText="#qrFornecedoresClassificacao.DESCRICAO# - #qrFornecedoresClassificacao.PORCENTAGEM#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo_principal.xml" />
        </chart>
  </cfcase>
  <cfcase value="5">
     <cfscript>
		qrFornecedoresProduto = conn.get_fornecedor_produto();
	</cfscript>	
        <chart caption="Produtos" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" />>
			<cfoutput query="qrFornecedoresProduto">
            	<set label="#qrFornecedoresProduto.DESCRICAO_ABRV#" value="#qrFornecedoresProduto.QUANTIDADE#" toolText="#qrFornecedoresProduto.DESCRICAO# - #qrFornecedoresProduto.PORCENTAGEM#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo.xml" />
        </chart>
  </cfcase>
  <cfcase value="6">
     <cfscript>
		qrFornecedoresRequisito = conn.get_fornecedor_requisitos();
	</cfscript>	
        <chart caption="Requisitos" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" />>
			<cfoutput query="qrFornecedoresRequisito">
            	<set label="#qrFornecedoresRequisito.DESCRICAO#" value="#qrFornecedoresRequisito.QUANTIDADE#" toolText="#qrFornecedoresRequisito.DESCRICAO# - #qrFornecedoresRequisito.PORCENTAGEM#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo.xml" />
        </chart>
  </cfcase>
  <!---Documentos--->
  <cfcase value="7">
     <cfscript>
		qrDocumentosTipo = conn.get_tipo_documento(data_inicio = vars.data_inicio, data_termino = vars.data_termino);
	</cfscript>	
        <chart caption="Tipos de Documento" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" />>
			<cfoutput query="qrDocumentosTipo">
            	<set label="#qrDocumentosTipo.DESCRICAO#" value="#qrDocumentosTipo.QUANTIDADE#" toolText="#qrDocumentosTipo.DESCRICAO# - #qrDocumentosTipo.PORCENTAGEM#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo_principal.xml" />
        </chart>
  </cfcase>
  <cfcase value="8">
     <cfscript>
		qrDocumentosVersoes = conn.get_versoes_documento(data_inicio = vars.data_inicio, data_termino = vars.data_termino);
	</cfscript>	
        <chart caption="<cfoutput>#ToString(toBinary(toBase64('Versões')), 'utf-8')#</cfoutput>" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" />>
			<cfoutput query="qrDocumentosVersoes">
            	<set label="#qrDocumentosVersoes.DESCRICAO#" value="#qrDocumentosVersoes.QUANTIDADE#" toolText="#qrDocumentosVersoes.DESCRICAO# - #qrDocumentosVersoes.PORCENTAGEM#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo.xml" />
        </chart>
  </cfcase>
  <cfcase value="9">
     <cfscript>
		qrDocumentosDesenvolvedor = conn.get_desenvolvedor_documento(data_inicio = vars.data_inicio, data_termino = vars.data_termino);
	</cfscript>	
        <chart caption="Desenvolvedores" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" />>
			<cfoutput query="qrDocumentosDesenvolvedor">
            	<set label="#qrDocumentosDesenvolvedor.DESCRICAO_ABRV#" value="#qrDocumentosDesenvolvedor.QUANTIDADE#" toolText="#qrDocumentosDesenvolvedor.DESCRICAO# - #qrDocumentosDesenvolvedor.PORCENTAGEM#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo.xml" />
        </chart>
  </cfcase>
  <cfcase value="10">
     <cfscript>
		qrDocumentosSituacao = conn.get_situacao_documento(data_inicio = vars.data_inicio, data_termino = vars.data_termino);
	</cfscript>	
        <chart caption="<cfoutput>#ToString(toBinary(toBase64('Situação')), 'utf-8')#</cfoutput>" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" /> >
			<cfoutput query="qrDocumentosSituacao">
            	<set label="#qrDocumentosSituacao.DESCRICAO_ABRV#" value="#qrDocumentosSituacao.QUANTIDADE#" toolText="#qrDocumentosSituacao.DESCRICAO# - #qrDocumentosSituacao.PORCENTAGEM#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo.xml" />
        </chart>
  </cfcase>  
  <!---Registros--->
  <cfcase value="11">
     <cfscript>
		qrRegistrosResponsavel = conn.get_responsaveis_registro(data_inicio = vars.data_inicio, data_termino = vars.data_termino);
	</cfscript>	
        <chart caption="<cfoutput>#ToString(toBinary(toBase64('Responsável')), 'utf-8')#</cfoutput>" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" />>
			<cfoutput query="qrRegistrosResponsavel">
            	<set label="#qrRegistrosResponsavel.DESCRICAO_ABRV#" value="#qrRegistrosResponsavel.QUANTIDADE#"  toolText="#qrRegistrosResponsavel.DESCRICAO# - #qrRegistrosResponsavel.PORCENTAGEM#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo.xml" />
        </chart>
  </cfcase>
  <cfcase value="12">
     <cfscript>
		qrRegistrosIdentificador = conn.get_identificadores_registro(data_inicio = vars.data_inicio, data_termino = vars.data_termino);
	</cfscript>	
        <chart caption="Identificador" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" />>
			<cfoutput query="qrRegistrosIdentificador">
            	<set label="#qrRegistrosIdentificador.DESCRICAO_ABRV#" value="#qrRegistrosIdentificador.QUANTIDADE#" toolText="#qrRegistrosIdentificador.DESCRICAO# - #qrRegistrosIdentificador.PORCENTAGEM#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo.xml" />
        </chart>
  </cfcase>
  <cfcase value="13">
     <cfscript>
		qrRegistrosArea = conn.get_area_registro(data_inicio = vars.data_inicio, data_termino = vars.data_termino);
	</cfscript>	
        <chart caption="<cfoutput>#ToString(toBinary(toBase64('Áreas')), 'utf-8')#</cfoutput>" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" />>
			<cfoutput query="qrRegistrosArea">
            	<set label="#qrRegistrosArea.DESCRICAO#" value="#qrRegistrosArea.QUANTIDADE#" toolText="#qrRegistrosArea.DESCRICAO# - #qrRegistrosArea.PORCENTAGEM#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo.xml" />
        </chart>
  </cfcase>
  <cfcase value="14">
     <cfscript>
		qrRegistrosPrioridade = conn.get_prioridade_registro(data_inicio = vars.data_inicio, data_termino = vars.data_termino);
	</cfscript>	
        <chart caption="Prioridade" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" />>
			<cfoutput query="qrRegistrosPrioridade">
            	<set label="#qrRegistrosPrioridade.DESCRICAO#" value="#qrRegistrosPrioridade.QUANTIDADE#" toolText="#qrRegistrosPrioridade.DESCRICAO# - #qrRegistrosPrioridade.PORCENTAGEM#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo.xml" />
        </chart>
  </cfcase>
  <cfcase value="15">
     <cfscript>
		qrRegistrosClassificacao = conn.get_classificacao_registro(data_inicio = vars.data_inicio, data_termino = vars.data_termino);
	</cfscript>	
        <chart caption="<cfoutput>#ToString(toBinary(toBase64('Classificação')), 'utf-8')#</cfoutput>" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" />>
			<cfoutput query="qrRegistrosClassificacao">
            	<set label="#qrRegistrosClassificacao.DESCRICAO#" value="#qrRegistrosClassificacao.QUANTIDADE#" toolText="#qrRegistrosClassificacao.DESCRICAO# - #qrRegistrosClassificacao.PORCENTAGEM#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo.xml" />
        </chart>
  </cfcase>
  <cfcase value="16">
     <cfscript>
		qrRegistrosTipo = conn.get_tipo_registro(data_inicio = vars.data_inicio, data_termino = vars.data_termino);
	</cfscript>	
        <chart caption="Tipos de Registro" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" />>
			<cfoutput query="qrRegistrosTipo">
            	<set label="#qrRegistrosTipo.DESCRICAO#" value="#qrRegistrosTipo.QUANTIDADE#"  toolText="#qrRegistrosTipo.DESCRICAO# - #qrRegistrosTipo.PORCENTAGEM#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo.xml" />
        </chart>
  </cfcase>         
  <cfcase value="17">
     <cfscript>
		qrRegistrosOrganograma = conn.get_organograma_registro(data_inicio = vars.data_inicio, data_termino = vars.data_termino);
	</cfscript>	
        <chart caption="<cfoutput>#ToString(toBinary(toBase64('Origem de Não Conformidade')), 'utf-8')#</cfoutput>" <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/chart.xml" />  showLabels='0' decimalSeparator=','>
			<cfoutput query="qrRegistrosOrganograma">
            	<set label="#qrRegistrosOrganograma.DESCRICAO#" value="#qrRegistrosOrganograma.QUANTIDADE#" toolText="#qrRegistrosOrganograma.DESCRICAO# - #qrRegistrosOrganograma.PORCENTAGEM#" />
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo_principal.xml" />
        </chart>
  </cfcase>  
  <cfcase value="18">
	<cfscript>
		qrTreinamentoCarga = conn.get_treinamentos_carga(data_inicio = vars.data_inicio, data_termino = vars.data_termino);
		qrTotalCarga 	   = conn.get_total_carga(data_inicio = vars.data_inicio, data_termino = vars.data_termino);
	</cfscript>	
		<chart subcaption="Total de <cfoutput>#qrTotalCarga.CARGA_HORARIA_EXTENSO#</cfoutput> hora(s)" caption="Carga Horaria" defaultNumberScale='min' numberScaleValue='60,60' numberScaleUnit='min,hr' bgAlpha='0' bgColor='ffffff' showBorder='0' basefontColor='000000' chartTopMargin='15' chartBottomMargin='15' chartLeftMargin='10' chartRightMargin='10' toolTipBorderColor='ededed' toolTipBgColor='ededed'  gaugeFillMix='{dark-10},ffffff,{dark-10}'  showToolTipShadow='1' toolTipSepChar=' - ' labelSepChar=', ' useRoundEdges='1' >
			<cfoutput query="qrTreinamentoCarga">
            <set label="#qrTreinamentoCarga.DESCRICAO#" value="#qrTreinamentoCarga.CARGA_HORARIA*60#" toolText="#qrTreinamentoCarga.DESCRICAO# - #qrTreinamentoCarga.CARGA_HORARIA_EXTENSO#"/>
            </cfoutput>
            <cfinclude template="/aplicacoes/qualidade/indicadores/paineis/config/estilo_principal.xml" />
        </chart>
  </cfcase>
  
  <cfdefaultcase>Problemas com a definição da consulta.</cfdefaultcase>
</cfswitch>		
<cfabort />
