<html>
<cfinclude template="/_scripts/scripts.cfm" />
<cfscript>
	conn = CreateComponent("_transportes.consulta.cfc_global");
	qrClassificacao = conn.get_cg_ref_codes(rv_domain = 'REGISTRO.CLASSIFICACAO_ID', owner = 'QUALIDADE');
	qrPrioridade    = conn.get_cg_ref_codes(rv_domain = 'REGISTRO.PRIORIDADE', owner = 'QUALIDADE');
	
	v_data_previsao = conn.get_parametro_valor(cod_projeto = 11,
											 cod_aplicacao = 'OPERACIONAL',
											 parametro_grupo_id = 41,
											 parametro_id = 3);
	v_exibir_campos = conn.get_parametro_valor(cod_projeto = 11,
											 cod_aplicacao = 'OPERACIONAL',
											 parametro_grupo_id = 41,
											 parametro_id = 4);	
	v_permite_edicao = conn.get_parametro_valor(cod_projeto = 11,
											cod_aplicacao = 'OPERACIONAL',
											parametro_grupo_id = 41,
											parametro_id = 5);
	v_label_campo   = conn.get_parametro_valor(cod_projeto = 11,
											   cod_aplicacao = 'OPERACIONAL',
											   parametro_grupo_id = 41,
											   parametro_id = 6);	
	v_data_conclusao = conn.get_parametro_valor(cod_projeto = 11,
											 cod_aplicacao = 'OPERACIONAL',
											 parametro_grupo_id = 41,
											 parametro_id = 7);
	v_descricao_auto = conn.get_parametro_valor(cod_projeto = 11,
											cod_aplicacao = 'OPERACIONAL',
											parametro_grupo_id = 41,
											parametro_id = 9);								   										 
	v_exibir_anexos = conn.get_parametro_valor(cod_projeto = 11,
											cod_aplicacao = 'OPERACIONAL',
											parametro_grupo_id = 41,
											parametro_id = 14);								   										 
												 
	conn = CreateComponent("_transportes.consulta.qualidade.cfc_controle_registro");
	qrTipoRegistro 		= conn.get_tipo_registro();
	qrAtividade	   		= conn.get_atividade();
	qrRegistroDescricao = conn.get_registro_descricao();	
	qrArea	 	    	= conn.get_area();
	
	conn = CreateComponent("_transportes.consulta.cfc_funcionario");
	qrOrganograma = conn.get_organograma();
	
	conn_acesso = CreateComponent("_transportes.consulta.cfc_acesso");
	qrModulo = conn_acesso.get_modulos(descricao = 'Qualidade');	
	qrNivelAcesso = conn_acesso.get_modulo_usuario(usuario = session.usuario, modulo_id = qrModulo.modulo_id);
</cfscript>
<script src="/_scripts/dragdrop/drag.js" type="text/javascript"></script>
<script type="text/javascript">
	// Configura botes //
	parent.f_set_texto('titulo_aplicacao', 'Controle de Qualidade');
	parent.f_set_texto('titulo_pagina', 'Cadastro de No Conformidade');
	
	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); }
	
	parent.f_hidden('btn_excluir');
	
	var v_label_sacp = "SACPs";
	
	<cfif isdefined("session.site") and session.site eq "delpozo/">
		v_label_sacp = "Planos de Ao";
	</cfif>	
	
	
	f_cria_botao('localizar', 'Localizar', 'f_localizar()', parent.document.getElementById('barra_botoes_top'));
	f_cria_botao('sacp', v_label_sacp, 'f_visualizar_sacps()', parent.document.getElementById('barra_botoes_top'));
	f_cria_botao('tarefas', 'Tarefas', 'f_visualizar_tarefas()', parent.document.getElementById('barra_botoes_top'));
	f_cria_botao('marcar_confirmacao', 'Marcar Confirmao', 'f_marcar_confirmacao()', parent.document.getElementById('barra_botoes_top'));
	f_cria_botao('desmarcar_confirmacao', 'Desmarcar Confirmao', 'f_desmarcar_confirmacao()', parent.document.getElementById('barra_botoes_top'));
	f_cria_botao('avaliar_registro', 'Avaliar Registro', 'f_avaliar_registro()', parent.document.getElementById('barra_botoes_top'));
 	f_cria_botao('concluir_registro', 'Concluir Registro', 'f_concluir_registro()', parent.document.getElementById('barra_botoes_top'));
	
	parent.document.getElementById('btn_sacp').style.width = 110;
	parent.document.getElementById('btn_tarefas').style.width = 90;
	parent.document.getElementById('btn_marcar_confirmacao').style.width = 135;
	parent.document.getElementById('btn_desmarcar_confirmacao').style.width = 180;
	parent.document.getElementById('btn_avaliar_registro').style.width = 120;
	parent.document.getElementById('btn_concluir_registro').style.width = 120;

	<cfif v_descricao_auto eq 0> 		
		parent.f_hidden('btn_tarefas');    
	<cfelse>
		parent.f_hidden('btn_sacp');
	</cfif>
	
	f_desabilitar_botao('sacp');
	f_desabilitar_botao('tarefas');
	f_desabilitar_botao('marcar_confirmacao');
	f_desabilitar_botao('desmarcar_confirmacao');
	f_desabilitar_botao('avaliar_registro');
	f_desabilitar_botao('concluir_registro');
	
	// ---------------- //
	
	var v_departamento = [];
	var v_setor		   = [];
	var v_centro_custo = [];
	
	<cfoutput query="qrOrganograma" group="COD_PESSOA">
		v_departamento.push( {
			cod_pessoa: 	  '#JSStringFormat(qrOrganograma.COD_PESSOA)#',
			cod_departamento: '#JSStringFormat(qrOrganograma.COD_DEPARTAMENTO)#',
			departamento: 	  '#JSStringFormat(qrOrganograma.DEPARTAMENTO)#'
		} );
	</cfoutput>
	
	<cfoutput query="qrOrganograma" group="COD_PESSOA">
	<cfoutput group="COD_DEPARTAMENTO">
		v_setor.push( {
			cod_pessoa: 	  '#JSStringFormat(qrOrganograma.COD_PESSOA)#',
			cod_departamento: '#JSStringFormat(qrOrganograma.COD_DEPARTAMENTO)#',
			cod_setor:		  '#JSStringFormat(qrOrganograma.COD_SETOR)#',
			setor:			  '#JSStringFormat(qrOrganograma.SETOR)#'
		} );
	</cfoutput>
	</cfoutput>
	
	<cfoutput query="qrOrganograma">
		v_centro_custo.push( {
			cod_pessoa: 	  '#JSStringFormat(qrOrganograma.COD_PESSOA)#',
			cod_departamento: '#JSStringFormat(qrOrganograma.COD_DEPARTAMENTO)#',
			cod_setor:		  '#JSStringFormat(qrOrganograma.COD_SETOR)#',
			cod_centro_custo: '#JSStringFormat(qrOrganograma.COD_CENTRO_CUSTO)#',
			centro_custo: 	  '#JSStringFormat(qrOrganograma.CENTRO_CUSTO)#',
			cod_organograma:  '#JSStringFormat(qrOrganograma.COD_ORGANOGRAMA)#'
		} );
	</cfoutput>
	
	function f_confirmar() {
		with(document.forms[0]) {
			target = 'consultas';
			action = 'confirma.cfm';		
			if(DESCRICAO.value == ''){
				REGISTRO_DESCRICAO_ID.obrigatorio = 1;
			} else{
				REGISTRO_DESCRICAO_ID.obrigatorio = 0;
			}
			if(REGISTRO_DESCRICAO_ID.value == ''){
				DESCRICAO.obrigatorio = 1;
			} else{
				DESCRICAO.obrigatorio = 0;
			}
			if(f_verifica_form(document.forms[0])) {
				DESCRICAO.value = DESCRICAO.value + ' ';
				f_campos_habilitados(false);
				submit();
			}
		}
		return false;
	}
	parent.f_confirmar = f_confirmar;
	
	function f_excluir() {
		with(document.forms[0]) {
			OPERACAO.value = 4; // Excluir
			try {
				ATUALIZA_COMBO.disabled = false;
			} catch(e) {}
			target = 'consultas';
			action = 'confirma.cfm';		
			if(confirm('Para confirmar a excluso do registro clique em OK.')) {
				submit();
			}
		}
	}	
	parent.f_excluir = f_excluir;
	
	function f_localizar() {
		NewWindow('<cf_url>/aplicacoes/qualidade/cadastros/registro/localizar.cfm</cf_url>?registro_gerador=0', 'Localizar', 800, 600, 'yes');
	}
	parent.f_localizar = f_localizar;
	
	function f_visualizar_tarefas() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/aplicacoes/qualidade/cadastros/tarefa/lista.cfm</cf_url>?cadastro_registros=1&registro_id=' + REGISTRO_ID.value, '', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}
	parent.f_visualizar_tarefas = f_visualizar_tarefas;
	
	function f_visualizar_sacps() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/aplicacoes/qualidade/cadastros/sacp/lista.cfm</cf_url>?cadastro_registros=1&registro_id=' + REGISTRO_ID.value, '', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}
	parent.f_visualizar_sacps = f_visualizar_sacps;
	
	function f_marcar_confirmacao() {
		with(document.forms[0]) {
			if(confirm('Para marcar a confirmao do registro clique em OK.')) {
				f_query_wddx('/_transportes/manipulacao/qualidade/cfc_controle_registro.cfc?method=marcar_confirmacao_reg'
							,'registro_id='+REGISTRO_ID.value
							,function(obj) {
								with(document.forms[0]) {
									if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
										if (obj.struct.erro = 'false') {
											alert(obj.struct.mensagem);
										} else { alert(obj.struct.mensagem); } 
									}
								}
							});
				document.getElementById('sp_confirmado').innerHTML = 'Sim';
				f_desabilitar_botao('marcar_confirmacao');
				f_habilitar_botao('desmarcar_confirmacao', 'f_desmarcar_confirmacao()');				
			}
		}
	}
	parent.f_marcar_confirmacao = f_marcar_confirmacao;
	
	function f_desmarcar_confirmacao() {
		with(document.forms[0]) {
			if(confirm('Para desmarcar a confirmao do registro clique em OK.')) {
				f_query_wddx('/_transportes/manipulacao/qualidade/cfc_controle_registro.cfc?method=desmarcar_confirmacao_reg'
							,'registro_id='+REGISTRO_ID.value
							,function(obj) {
								with(document.forms[0]) {
									if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
										if (obj.struct.erro = 'false') {
											alert(obj.struct.mensagem);
										} else { alert(obj.struct.mensagem); } 
									}
								}
							});		
				document.getElementById('sp_confirmado').innerHTML = 'No';
				f_habilitar_botao('marcar_confirmacao', 'f_marcar_confirmacao()');
				f_desabilitar_botao('desmarcar_confirmacao');			
			}
		}
	}
	parent.f_desmarcar_confirmacao = f_desmarcar_confirmacao;
	
	function f_busca_dados(p_registro_id, p_operacao) {
		with(document.forms[0]) {
			
			if(p_operacao == 3) {
				parent.f_hidden('btn_incluir');
				parent.f_hidden('btn_editar');
			  	parent.f_hidden('btn_localizar');
			}
			
			f_cria_carregando_ajax();
			
			CONSULTA.value = 1; // Todos os Dados 
			OPERACAO.value = p_operacao;
			REGISTRO_ID.value = p_registro_id;
			
			target = 'consultas';
			action = 'consultas.cfm';
			submit();
		}
	}
	
	function f_atualizar_status() {
		with(document.forms[0]) {
			parent.f_atualizar();
			try{	
			top.opener.f_atualizar();
			}catch(e){}
		}
	}
	parent.f_atualizar_status = f_atualizar_status;
	
	function f_on_incluir() {
		with(document.forms[0]) {
			f_desabilitar_botao('tarefas');
			f_desabilitar_botao('sacp');
			f_desabilitar_botao('marcar_confirmacao');
			f_desabilitar_botao('desmarcar_confirmacao');
			
			document.getElementById('fds_busca_rapida').disabled = true;
			REGISTRO_ID_PESQUISAR.disabled = true;
			
			f_limpa_select(COD_DEPARTAMENTO);
			f_limpa_select(COD_SETOR);
			f_limpa_select(COD_CENTRO_CUSTO);
			
			f_cria_option('', '-- Selecione uma Filial --', COD_DEPARTAMENTO);
			f_cria_option('', '-- Selecione um Departamento --', COD_SETOR);
			f_cria_option('', '-- Selecione um Setor --', COD_CENTRO_CUSTO);
			
			document.getElementById('sp_situacao').innerHTML       = 'Aberto';
			document.getElementById('sp_confirmado').innerHTML 	   = 'No';
			
			<cfif v_data_conclusao neq 0>
				document.getElementById('sp_data_conclusao').innerHTML = 'No Concludo';
			</cfif>
			
			 f_muda_tipo_registro();
		}
	}
	parent.f_on_incluir = f_on_incluir;
	
	function f_on_editar() {
		with(document.forms[0]) {	
			document.getElementById('fds_busca_rapida').disabled = true;
			REGISTRO_ID_PESQUISAR.disabled = true;
			REGISTRO_DESCRICAO.disabled = true;
			<cfif qrNivelAcesso.nivel_acesso lt 10>		
				f_campos_habilitados(true);
			</cfif>			
		}
	}
	parent.f_on_editar = f_on_editar;
	
	function f_campos_habilitados(v_status) {
		with(document.forms[0]) {	
			document.getElementById('fds_busca_rapida').disabled = v_status;
			REGISTRO_ID_PESQUISAR.disabled = v_status;
			<cfif qrNivelAcesso.nivel_acesso lt 10>	
				COD_PESSOA_FILIAL.disabled = v_status;
				COD_DEPARTAMENTO.disabled = v_status;
				COD_SETOR.disabled = v_status;
				COD_CENTRO_CUSTO.disabled = v_status;
				TIPO_REGISTRO_ID.disabled = v_status;
				REGISTRO_ID_GERADOR.disabled = v_status;
				<cfif v_exibir_campos neq 0>
				document.getElementById('btn_registro_gerador').disabled = v_status;
				</cfif>
				CLASSIFICACAO_ID.disabled = v_status;
				PRIORIDADE.disabled = v_status;
				CLIENTE_CNPJ_CPF.disabled = v_status;
				CLIENTE.disabled = v_status;
				document.getElementById('btn_buscar_cliente').disabled = v_status;
				AREA_ID.disabled = v_status;
				COD_FUNCIONARIO_IDENTIFICACAO.disabled = v_status;
				NOME_FUNCIONARIO_IDENTIFICACAO.disabled = v_status;
				document.getElementById('btn_identificador').disabled = v_status;
				COD_FUNCIONARIO_RESPONSAVEL.disabled = v_status;
				NOME_FUNCIONARIO_RESPONSAVEL.disabled = v_status;
				document.getElementById('btn_responsavel').disabled = v_status;
				ATIVIDADE_ID.disabled = v_status;
				DATA_IDENTIFICACAO.disabled = v_status;
				BTN_DATA_IDENTIFICACAO.disabled = v_status;
				DATA_PREVISAO.disabled = v_status;
				BTN_DATA_PREVISAO.disabled = v_status;
			</cfif>			
		}
	}
	parent.f_on_editar = f_on_editar;
	
	function f_on_cancelar() {
		with(document.forms[0]) {
			f_desabilitar_botao('tarefas');
			f_desabilitar_botao('sacp');
			f_desabilitar_botao('marcar_confirmacao');
			f_desabilitar_botao('desmarcar_confirmacao');
			
			document.getElementById('fds_busca_rapida').disabled = false;
			REGISTRO_ID_PESQUISAR.disabled = false;
		}
	}
	parent.f_on_cancelar = f_on_cancelar;
	
	function f_muda_registro_id_pesquisar() {
		with(document.forms[0]) {
			if(REGISTRO_ID_PESQUISAR.value) {
				f_busca_dados(REGISTRO_ID_PESQUISAR.value, 1);
			}
		}
	}	

	function f_muda_tipo_registro() {
		with(document.forms[0]) {
			
			<cfif v_exibir_campos neq 0>
			if(Number(TIPO_REGISTRO_ID.value) == 3 || Number(TIPO_REGISTRO_ID.value) == 4 || Number(TIPO_REGISTRO_ID.value) == 5) {
				document.getElementById('tr_registro_gerador').style.display 		   = '';
				document.getElementById('tr_registro_gerador_descricao').style.display = '';
			}
			else {
				document.getElementById('tr_registro_gerador').style.display 		   = 'none';
				document.getElementById('tr_registro_gerador_descricao').style.display = 'none';
				
				REGISTRO_ID_GERADOR.value        = '';
				REGISTRO_GERADOR_DESCRICAO.value = '';
			}			
			
			if(Number(TIPO_REGISTRO_ID.value) == 1) {
				document.getElementById('tr_classificacao').style.display = '';
				
				CLASSIFICACAO_ID.setAttribute('obrigatorio', 1);
			}
			else {
				document.getElementById('tr_classificacao').style.display = 'none';
				
				CLASSIFICACAO_ID.setAttribute('obrigatorio', 0);
			}
			
			</cfif>
			
			if(Number(TIPO_REGISTRO_ID.value) == 2) {
				document.getElementById('tr_cliente').style.display = '';
				
				COD_CLIENTE.setAttribute('obrigatorio', 1);
				CLIENTE_CNPJ_CPF.setAttribute('obrigatorio', 1);
				CLIENTE.setAttribute('obrigatorio', 1);
			}
			else {
				document.getElementById('tr_cliente').style.display = 'none';
				
				COD_CLIENTE.setAttribute('obrigatorio', 0);
				CLIENTE_CNPJ_CPF.setAttribute('obrigatorio', 0);
				CLIENTE.setAttribute('obrigatorio', 0);
			}
			
			<cfif isdefined("session.site") and session.site eq "sulista/">
				document.getElementById('tr_cliente').style.display = '';				
				COD_CLIENTE.setAttribute('obrigatorio', 1);
				CLIENTE_CNPJ_CPF.setAttribute('obrigatorio', 1);
				CLIENTE.setAttribute('obrigatorio', 1);
			</cfif>
			
			CLASSIFICACAO_ID.value = '';
			COD_CLIENTE.value 	   = '';
			CLIENTE_CNPJ_CPF.value = '';
			CLIENTE.value 		   = '';
		}
	}

	
	function f_busca_registro_gerador() {
		with(document.forms[0]) {
			REGISTRO_GERADOR_DESCRICAO.value = '';
			
			if(!REGISTRO_ID_GERADOR.value) {
				return;
			}
			
			REGISTRO_GERADOR_DESCRICAO.value = 'Buscando registro gerador...';
			f_query_wddx('<cf_url>/_transportes/consulta/qualidade/cfc_controle_registro.cfc</cf_url>?method=get_registro'
						,'registro_id=' + REGISTRO_ID_GERADOR.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.registro_id.length > 0) {
									REGISTRO_GERADOR_DESCRICAO.value = obj.struct.descricao[0];
								}
								else {
									REGISTRO_ID_GERADOR.value		 = '';
									REGISTRO_GERADOR_DESCRICAO.value = '';
									
									alert('Registro gerador no encontrado.');
								}
							}
						});
		}
	}
	
	function f_busca_cliente() {
		with(document.forms[0]) {
			COD_CLIENTE.value = '';
			CLIENTE.value 	  = '';
			
			if(!CLIENTE_CNPJ_CPF.value) {
				return;
			}
			
			CLIENTE.value = 'Buscando cliente...';
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=get_pessoa_light'
						,'cnpj_cpf=' + CLIENTE_CNPJ_CPF.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.cod_pessoa.length > 0) {
									COD_CLIENTE.value = obj.struct.cod_pessoa[0];
									CLIENTE.value  	  = obj.struct.razao_social[0];
								}
								else {
									CLIENTE.value = 'Cliente no encontrado.';
								}
							}
						});
		}
	}
	
	function f_busca_departamento() {
		with(document.forms[0]) {
			var v_inserir;
			
			f_limpa_select(COD_DEPARTAMENTO);
			f_limpa_select(COD_SETOR);
			f_limpa_select(COD_CENTRO_CUSTO);
			
			f_cria_option('', '-- Selecione um Departamento --', COD_SETOR);
			f_cria_option('', '-- Selecione um Setor --', COD_CENTRO_CUSTO);
			
			if(!COD_PESSOA_FILIAL.value) {
				f_cria_option('', '-- Selecione uma Filial --', COD_DEPARTAMENTO);
			}
			
			for(var i = 0; i < v_departamento.length; i++) {

					v_inserir = true;
					
					for(var j = 0; j < COD_DEPARTAMENTO.options.length; j++) {
						if(Number(COD_DEPARTAMENTO.options[j].value) == Number(v_departamento[i].cod_departamento)) {
							v_inserir = false;
						}
					}
					
					if(v_inserir) {
						f_cria_option(v_departamento[i].cod_departamento, v_departamento[i].cod_departamento + ' - ' + v_departamento[i].departamento, COD_DEPARTAMENTO);
					}
			}
			
			if(COD_DEPARTAMENTO.options.length == 0) {
				f_cria_option('', '-- Esta Filial no possui nenhum Departamento --', COD_DEPARTAMENTO);
			}
			else {
				COD_DEPARTAMENTO.onchange();
			}
		}
	}
	
	function f_busca_setor() {
		with(document.forms[0]) {
			var v_inserir;
			
			f_limpa_select(COD_SETOR);
			f_limpa_select(COD_CENTRO_CUSTO);
			
			f_cria_option('', '-- Selecione um Setor --', COD_CENTRO_CUSTO);
			
			if(!COD_DEPARTAMENTO.value) {
				f_cria_option('', '-- Selecione um Departamento --', COD_SETOR);
			}
			
			for(var i = 0; i < v_setor.length; i++) {

					v_inserir = true;
					
					for(var j = 0; j < COD_SETOR.options.length; j++) {
						if(Number(COD_SETOR.options[j].value) == Number(v_setor[i].cod_setor)) {
							v_inserir = false;
						}
					}
					
					if(v_inserir) {
						f_cria_option(v_setor[i].cod_setor, v_setor[i].cod_setor + ' - ' + v_setor[i].setor, COD_SETOR);
					}
			}
			
			if(COD_SETOR.options.length == 0) {
				f_cria_option('', '-- Este Departamento no possui nenhum Setor --', COD_SETOR);
			}
			else {
				COD_SETOR.onchange();
			}
		}
	}
	
	function f_busca_centro_custo() {
		with(document.forms[0]) {
			var v_option;
			
			f_limpa_select(COD_CENTRO_CUSTO);
			
			if(!COD_SETOR.value) {
				f_cria_option('', '-- Selecione um Setor --', COD_CENTRO_CUSTO);
			}
			
			for(var i = 0; i < v_centro_custo.length; i++) {
				if((Number(v_centro_custo[i].cod_pessoa) == Number(COD_PESSOA_FILIAL.value)) && (Number(v_centro_custo[i].cod_departamento) == Number(COD_DEPARTAMENTO.value)) && (Number(v_centro_custo[i].cod_setor) == Number(COD_SETOR.value))) {
					v_option = f_cria_option(v_centro_custo[i].cod_centro_custo, v_centro_custo[i].cod_centro_custo + ' - ' + v_centro_custo[i].centro_custo, COD_CENTRO_CUSTO);
					v_option.setAttribute('cod_organograma', v_centro_custo[i].cod_organograma);
				}
			}
			
			if(COD_CENTRO_CUSTO.options.length == 0) {
				f_cria_option('', '-- Este Setor no possui nenhum Centro de Custo --', COD_CENTRO_CUSTO);
			}
			else {
				COD_CENTRO_CUSTO.onchange();
			}
		}
	}
	
	function f_muda_centro_custo() {
		with(document.forms[0]) {
			COD_ORGANOGRAMA.value = COD_CENTRO_CUSTO.options[COD_CENTRO_CUSTO.selectedIndex].getAttribute('cod_organograma');
		}
	}
	
	function f_busca_funcionario_identificacao() {
		with(document.forms[0]) {
			COD_IDENTIFICACAO.value       		 = '';
			NOME_FUNCIONARIO_IDENTIFICACAO.value = '';
			
			if(!COD_FUNCIONARIO_IDENTIFICACAO.value) {
				return;
			}
			
			NOME_FUNCIONARIO_IDENTIFICACAO.value = 'Buscando funcionrio...';				
								
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_funcionario.cfc</cf_url>?method=get_funcionario'//'/_transportes/consulta/cfc_pessoa.cfc?method=get_funcionario'
						,'cod_funcionario='+COD_FUNCIONARIO_IDENTIFICACAO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.cod_pessoa.length > 0) {
									COD_IDENTIFICACAO.value = obj.struct.cod_pessoa[0];
									NOME_FUNCIONARIO_IDENTIFICACAO.value = obj.struct.nome_funcionario[0];
								}
								else {
									NOME_FUNCIONARIO_IDENTIFICACAO.value = 'Funcionrio no encontrado.';
								}
							}
			});
					
		}
	}
	
	function f_busca_pessoa_identificacao() {
		with(document.forms[0]) {
			COD_IDENTIFICACAO.value       	   = '';
			NOME_FUNCIONARIO_IDENTIFICACAO.value = '';
			
			if(!COD_FUNCIONARIO_IDENTIFICACAO.value) {
				return;
			}
			
			NOME_FUNCIONARIO_IDENTIFICACAO.value = 'Buscando pessoa...';
			
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=getPessoa'
						,'completo=1&cnpj_cpf='+COD_FUNCIONARIO_IDENTIFICACAO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.cod_pessoa.length > 0) {
									COD_IDENTIFICACAO.value = obj.struct.cod_pessoa[0];
									NOME_FUNCIONARIO_IDENTIFICACAO.value = obj.struct.cliente[0];
								}
								else {
									NOME_FUNCIONARIO_IDENTIFICACAO.value = 'Pessoa no encontrada.';
								}
							}
			});
		}
	}
	
	function f_busca_funcionario_responsavel() {
		with(document.forms[0]) {
			COD_RESPONSAVEL.value       	   = '';
			NOME_FUNCIONARIO_RESPONSAVEL.value = '';
			
			if(!COD_FUNCIONARIO_RESPONSAVEL.value) {
				return;
			}
			
			NOME_FUNCIONARIO_RESPONSAVEL.value = 'Buscando funcionrio...';

			f_query_wddx('<cf_url>/_transportes/consulta/cfc_funcionario.cfc</cf_url>?method=get_funcionario'//'/_transportes/consulta/cfc_pessoa.cfc?method=get_funcionario'
						,'cod_funcionario='+COD_FUNCIONARIO_RESPONSAVEL.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.cod_pessoa.length > 0) {
									COD_RESPONSAVEL.value = obj.struct.cod_pessoa[0];
									NOME_FUNCIONARIO_RESPONSAVEL.value = obj.struct.nome_funcionario[0];
								}
								else {
									NOME_FUNCIONARIO_RESPONSAVEL.value = 'Funcionrio no encontrado.';
								}
							}
			});
		}
	}
	
	function f_busca_pessoa_responsavel() {
		with(document.forms[0]) {
			COD_RESPONSAVEL.value       	   = '';
			NOME_FUNCIONARIO_RESPONSAVEL.value = '';
			
			if(!COD_FUNCIONARIO_RESPONSAVEL.value) {
				return;
			}
			
			NOME_FUNCIONARIO_RESPONSAVEL.value = 'Buscando pessoa...';
			
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=getPessoa'
						,'completo=1&cnpj_cpf='+COD_FUNCIONARIO_RESPONSAVEL.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.cod_pessoa.length > 0) {
									COD_RESPONSAVEL.value = obj.struct.cod_pessoa[0]; 
									NOME_FUNCIONARIO_RESPONSAVEL.value = obj.struct.cliente[0];
								}
								else {
									NOME_FUNCIONARIO_RESPONSAVEL.value = 'Pessoa no encontrada.';
								}
							}
			});
		}
	}
	
	function f_avaliar_registro(){
		with(document.forms[0]){
			f_ocultar_div_avaliar_registro();
				
			obj = document.getElementById('div_avaliar_registro');
			f_get_scroll();
			
			if(obj.style.display == 'none') {
				setTimeout("document.getElementById('div_avaliar_registro').style.display = '';", 100);
				obj.style.top  = 10;
				obj.style.left = 450;
			}
			
			EFICAZ.disabled = false;
			AVALIACAO.disabled = false;
			document.getElementById('btn_confirmar_avaliacao_registro').disabled = false; 
			document.getElementById('btn_ocultar_div_avaliar_registro').disabled = false; 
		}
	}
	parent.f_avaliar_registro = f_avaliar_registro;
	
	function f_ocultar_div_avaliar_registro(){
		document.getElementById('div_avaliar_registro').style.display = 'none';
	}
	
	function f_avaliar(){
		with(document.forms[0]){
			OPERACAO.value = 8;
			target = 'consultas';
			action = 'confirma.cfm';
			submit();
		}
	}
	parent.f_avaliar = f_avaliar;
	
	function f_concluir_registro() {
		with(document.forms[0]) {
			if(POSSIVEIS_CAUSAS.value.trim() ==''){
				alert('Para concluir o registro  necessrio informar as possveis causas de sua ocorrncia.');
				if(!POSSIVEIS_CAUSAS.disabled)
					POSSIVEIS_CAUSAS.focus();
				return false;	
			}
			if(SOLUCAO_APLICAVEL.value.trim() ==''){
				alert('Para concluir o registro  necessrio informar a soluo aplicada.');
				if(!SOLUCAO_APLICAVEL.disabled)
					SOLUCAO_APLICAVEL.focus();
				return false;	
			}
			OPERACAO.value = 10;
			target = 'consultas';
			action = 'confirma.cfm';		
			submit();
		}
	}		
	parent.f_concluir_registro = f_concluir_registro;
	
	function f_muda_registro_descricao() {
		with(document.forms[0]) {
			REGISTRO_DESCRICAO.value = REGISTRO_DESCRICAO_ID.options[REGISTRO_DESCRICAO_ID.selectedIndex].getAttribute('descricao');
		}
	}
	parent.f_muda_registro_descricao = f_muda_registro_descricao;
	
	function f_visualizar_anexo() {
		with(document.forms[0]) {
			if(ANEXO_URL.value.replace(/ /,'') != '') {
				NewWindow(escape(ANEXO_URL.value).replace('%3A',':'), '_blank', 800,600,'yes');
			} else {
				alert('Nenhum anexo disponvel!');
			}
		}
	}
	var v_url_anexo = [];
	var v_anexo_sel_id = '';
	function f_anexar(p_campo) {
		with(document.forms[0]) {
			f_abrir_janela('/aplicacoes/qualidade/anexos/lista.cfm?campo=ANEXO_ID','f_busca_anexo()');
		}
	}
	
	function f_busca_anexo() {
		with(document.forms[0]) {
			CONSULTA.value = 4;
			target = 'consultas';
			action = '/aplicacoes/qualidade/anexos/consultas.cfm';
			submit();
		}
	}
	
</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KM&amp;M :..</title>
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body class="background" style="height: 100%;">
<form id="form_transportes" name="form_transportes" method="post" action="" onSubmit="return f_confirmar()">
    <input type="hidden" name="OPERACAO" id="OPERACAO" value="" sempre_ativo="1" />
    <input type="hidden" name="CONSULTA" id="CONSULTA" value="" sempre_ativo="1" />
    <input type="hidden" name="REGISTRO_ID" id="REGISTRO_ID" value="" sempre_ativo="1" />
    <input type="hidden" name="COD_ORGANOGRAMA" id="COD_ORGANOGRAMA" value="" />
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
    	<tr>
			<td>
                <fieldset id="fds_busca_rapida" sempre_ativo="1"><legend>Busca R&aacute;pida</legend>
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                	<tr>
                        <td nowrap class="texto" width="1%">C&oacute;digo do Registro:</td>
                        <td class="texto" width="99%"><input type="text" name="REGISTRO_ID_PESQUISAR" id="REGISTRO_ID_PESQUISAR" maxlength="15" tipo="numerico" display="CDIGO" sempre_ativo="1" onChange="f_muda_registro_id_pesquisar()" onKeyPress="return f_formata(this, '000000000000000')" style="width: 110px;" /></td>
                    </tr>
                </table>
				</fieldset>
			</td>
		</tr>
		<tr>
			<td>
                    <fieldset><legend>Origem da No Conformidade</legend>
                        <table width="100%" border="0" cellspacing="0" cellpadding="3">
                            <tr>
                                <td nowrap class="texto" width="1%" style="width:115px;">Filial:</td>
                                <td class="texto" width="99%"><select name="COD_PESSOA_FILIAL" id="COD_PESSOA_FILIAL" obrigatorio="1" display="FILIAL" onChange="f_busca_departamento()" style="width: 320px;">
                                    <option value="">-- Selecione --</option>
                                    <cfoutput query="qrOrganograma" group="COD_PESSOA">
                                        <option value="#qrOrganograma.COD_PESSOA#">#qrOrganograma.COD_UNIDADE_NEGOCIO# - #qrOrganograma.NOME_FANTASIA#</option>
                                    </cfoutput>
                                    </select></td>
                            </tr>
                            <tr>
                                <td nowrap class="texto">Departamento:</td>
                                <td class="texto"><select name="COD_DEPARTAMENTO" id="COD_DEPARTAMENTO" obrigatorio="1" display="DEPARTAMENTO" onChange="f_busca_setor()" style="width: 320px;">
                                    <option value="">-- Selecione uma Filial --</option>
                                    </select></td>
                            </tr>
                            <tr>
                                <td nowrap class="texto">Setor:</td>
                                <td class="texto"><select name="COD_SETOR" id="COD_SETOR" obrigatorio="1" display="SETOR" onChange="f_busca_centro_custo()" style="width: 320px;">
                                    <option value="">-- Selecione um Departamento --</option>
                                    </select></td>
                            </tr>
                            <tr>
                                <td nowrap class="texto">Centro de Custo:</td>
                                <td class="texto"><select name="COD_CENTRO_CUSTO" id="COD_CENTRO_CUSTO" obrigatorio="1" display="CENTRO DE CUSTO" onChange="f_muda_centro_custo()" style="width: 320px;">
                                    <option value="" cod_organograma="">-- Selecione um Setor --</option>
                                    </select></td>
                            </tr>                                
                        </table>
                    </fieldset>
                <fieldset><legend>Dados<span id="sp_cod_registro"></span></legend>
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                    <tr>
                        <td width="1%" style="width:115px;" nowrap class="texto">Tipo de NC:</td>
                        <td width="99%" class="texto"><select name="TIPO_REGISTRO_ID" id="TIPO_REGISTRO_ID" obrigatorio="1" display="TIPO DE REGISTRO" <cfif session.site neq "bbm/" and session.site neq "rodomar/">onChange="f_muda_tipo_registro()"</cfif> style="width: 160px;">
                            <option value="">-- Selecione --</option>
							<cfoutput query="qrTipoRegistro">
                                <option value="#qrTipoRegistro.TIPO_REGISTRO_ID#">#qrTipoRegistro.DESCRICAO#</option>
                            </cfoutput>
                            </select></td>
                    </tr>
                    <cfif v_exibir_campos neq 0>
                    <tr id="tr_registro_gerador" style="display: none;">
                        <td nowrap class="texto">Registro Gerador:</td>
                        <td class="texto"><input type="text" name="REGISTRO_ID_GERADOR" id="REGISTRO_ID_GERADOR" maxlength="15" tipo="numerico" display="CDIGO DO REGISTRO GERADOR" onChange="f_busca_registro_gerador()" onKeyPress="return f_formata(this, '000000000000000')" style="width: 110px;" />&nbsp;
                            <button type="button" id="btn_registro_gerador" class="botao-16x16" onClick="NewWindow('<cf_url>/aplicacoes/qualidade/cadastros/registro/localizar.cfm</cf_url>?registro_gerador=1', 'LocalizarRegistroGerador', 800, 600, 'yes');"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Registro" title="Buscar Registro" width="16" height="16" align="absmiddle" /></button></td>
                    </tr>
                    <tr id="tr_registro_gerador_descricao" style="display: none;">
                        <td nowrap class="texto"></td>
                        <td class="texto"><textarea name="REGISTRO_GERADOR_DESCRICAO" id="REGISTRO_GERADOR_DESCRICAO" rows="5" readonly display="DESCRIO DO REGISTRO GERADOR" style="width: 100%;"></textarea></td>
                    </tr>
                    <tr id="tr_classificacao" style="display: none;">
                        <td nowrap class="texto">Classifica&ccedil;&atilde;o:</td>
                        <td class="texto"><select name="CLASSIFICACAO_ID" id="CLASSIFICACAO_ID" display="CLASSIFICAO" style="width: 110px;">
                            <option value="">-- Selecione --</option>
							<cfoutput query="qrClassificacao">
                                <option value="#qrClassificacao.RV_LOW_VALUE#">#qrClassificacao.RV_ABBREVIATION#</option>
                            </cfoutput>
                            </select></td>
                    </tr>
                        <cfelse>
                         <input type="hidden" name="REGISTRO_ID_GERADOR" id="REGISTRO_ID_GERADOR" value="" />
                         <input type="hidden" name="REGISTRO_GERADOR_DESCRICAO" id="REGISTRO_GERADOR_DESCRICAO" value="" />   
                         <input type="hidden" name="CLASSIFICACAO_ID" id="CLASSIFICACAO_ID" value="" />                  
                        </cfif>
                    <tr>
                        <td nowrap class="texto">Prioridade:</td>
                        <td class="texto"><select name="PRIORIDADE" id="PRIORIDADE" obrigatorio="1" display="PRIORIDADE" style="width: 110px;">
                            <option value="">-- Selecione --</option>
							<cfoutput query="qrPrioridade">
                                <option value="#qrPrioridade.RV_LOW_VALUE#">#qrPrioridade.RV_ABBREVIATION#</option>
                            </cfoutput>
                            </select></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto">Situa&ccedil;&atilde;o:</td>
                        <td class="texto" style="height: 23px;"><span id="sp_situacao" class="texto_negrito">Aberto</span></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto">Confirmado:</td>
                        <td class="texto" style="height: 23px;"><span id="sp_confirmado" class="texto_negrito">N&atilde;o</span></td>
                    </tr>
                    <tr id="tr_cliente" style="display: none;">
                        <td nowrap class="texto">Cliente:</td>
                        <td class="texto">
                        	<input type="text" name="CLIENTE_CNPJ_CPF" id="CLIENTE_CNPJ_CPF" maxlength="14" tipo="numerico" display="CNPJ/CPF DO CLIENTE" onChange="f_busca_cliente()" onKeyPress="return f_formata(this, '00000000000000')" style="width: 110px;" />
							<input type="text" name="CLIENTE" id="CLIENTE" readonly display="CLIENTE" style="width: 500px;" />
                            <input type="hidden" name="COD_CLIENTE" id="COD_CLIENTE" display="CLIENTE" />
                            <button type="button" class="botao-16x16" id="btn_buscar_cliente" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?field=COD_PESSOA,CNPJ_CPF,RAZAO_SOCIAL&campo=COD_CLIENTE,CLIENTE_CNPJ_CPF,CLIENTE', '_blank', 800, 600, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Cliente" title="Buscar Cliente" width="16" height="16" align="absmiddle" /></button></td>
                    </tr>
                    <tr>
                      <td nowrap class="texto">&Aacute;rea Afetada:</td>
                      <td class="texto">
                      	<select name="AREA_ID" id="AREA_ID" style="width: 160px;">
                            <option value="">-- Selecione --</option>
                            <cfoutput query="qrArea">
                               <option value="#qrArea.AREA_ID#">#qrArea.DESCRICAO#</option>
                            </cfoutput>
                        </select></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto">Identificado Por:</td>
                        <td class="texto">
                        	<input type="text" name="COD_FUNCIONARIO_IDENTIFICACAO" id="COD_FUNCIONARIO_IDENTIFICACAO" maxlength="14" obrigatorio="1" tipo="numerico" display="IDENTIFICADOR DO RESPONSVEL PELA IDENTIFICAO DO REGISTRO" onChange="f_busca_pessoa_identificacao()" onKeyPress="return f_formata(this, '00000000000000')" style="width: 110px;" />
                        	<input type="text" name="NOME_FUNCIONARIO_IDENTIFICACAO" id="NOME_FUNCIONARIO_IDENTIFICACAO" readonly obrigatorio="1" display="NOME DO RESPONSVEL PELA IDENTIFICAO DO REGISTRO" style="width: 320px;" />
                            <input type="hidden" name="COD_IDENTIFICACAO" id="COD_IDENTIFICACAO" obrigatorio="1" display="IDENTIFICADO POR" />
                            <button id="btn_identificador" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?campo=COD_FUNCIONARIO_IDENTIFICACAO,NOME_FUNCIONARIO_IDENTIFICACAO,COD_IDENTIFICACAO&funcao=f_busca_pessoa_identificacao()','_blank',800,600,'yes')" type="button" class="botao-16x16" ><img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle"></button>                           
                        </td>
                    </tr>
                    <tr>
                        <td nowrap class="texto"><cfoutput>#v_label_campo#</cfoutput>:</td>
                        <td class="texto">
                        	<input type="text" name="COD_FUNCIONARIO_RESPONSAVEL" id="COD_FUNCIONARIO_RESPONSAVEL" maxlength="14" obrigatorio="1" tipo="numerico" display="IDENTIFICADOR DO RESPONSVEL" onChange="f_busca_pessoa_responsavel()" onKeyPress="return f_formata(this, '00000000000000')" style="width: 110px;" />
                        	<input type="text" name="NOME_FUNCIONARIO_RESPONSAVEL" id="NOME_FUNCIONARIO_RESPONSAVEL" readonly obrigatorio="1" display="NOME DO RESPONSVEL" style="width: 320px;" />
                            <input type="hidden" name="COD_RESPONSAVEL" id="COD_RESPONSAVEL" obrigatorio="1" display="RESPONSVEL" />
                            <button id="btn_responsavel"  onClick="NewWindow('/_consultas/localizar_pessoa.cfm?campo=COD_FUNCIONARIO_RESPONSAVEL,NOME_FUNCIONARIO_RESPONSAVEL,COD_RESPONSAVEL&funcao=f_busca_pessoa_responsavel()','_blank',800,600,'yes')" type="button" class="botao-16x16" ><img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle"></button>                           
                        </td>
                    </tr>
                    <tr>
                        <td nowrap class="texto">Atividade:</td>
                        <td class="texto"><select name="ATIVIDADE_ID" id="ATIVIDADE_ID" obrigatorio="1" display="ATIVIDADE">
                            <option value="">-- Selecione --</option>
							<cfoutput query="qrAtividade">
                                <option value="#qrAtividade.ATIVIDADE_ID#">#qrAtividade.DESCRICAO#</option>
                            </cfoutput>
                            </select></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto" width="1%">Data Identifica&ccedil;&atilde;o:</td>
                        <td class="texto" width="99%">
                                <input type="text" name="DATA_IDENTIFICACAO" id="DATA_IDENTIFICACAO" maxlength="10" obrigatorio="1" tipo="data" display="DATA DE IDENTIFICAO" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 80px;" />
                                <button type="button" id="BTN_DATA_IDENTIFICACAO" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
                                <script type="text/javascript"> 
                                    Calendar.setup( {
                                        inputField  : "DATA_IDENTIFICACAO",     // ID of the input field
                                        ifFormat    : "%d/%m/%Y", 				// the date format
                                        button      : "BTN_DATA_IDENTIFICACAO", // ID of the button
                                        range       : [2001,2050]
                                    } );
                                </script> 
                        </td>
                    </tr>
                    <tr>
                        <td nowrap class="texto">Data Previs&atilde;o:</td>
                        <td class="texto">
                            <cfif v_data_previsao eq 0>
                        	<input type="text" name="DATA_PREVISAO" id="DATA_PREVISAO" maxlength="10" tipo="data" display="DATA DE PREVISO" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 80px;" />
							<button type="button" id="BTN_DATA_PREVISAO" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "DATA_PREVISAO",      // ID of the input field
									ifFormat    : "%d/%m/%Y", 			// the date format
									button      : "BTN_DATA_PREVISAO",  // ID of the button
									range       : [2001,2050]
								} );
                            </script>
                             <cfelse>
                                <span id="sp_data_previsao" class="texto_negrito">Sem Previs&atilde;o</span>
                                <input type="hidden" name="DATA_PREVISAO" id="DATA_PREVISAO" value="" />
                                <input type="hidden" name="BTN_DATA_PREVISAO" id="BTN_DATA_PREVISAO" value="" />
                          </cfif>
                      </td>
                    </tr>
                    <tr>
                        <td nowrap class="texto">Data  Conclus&atilde;o:</td>
                        <td class="texto" style="height: 23px;">
                          <cfif v_data_conclusao eq 0>
                        	<input type="text" name="DATA_CONCLUSAO" id="DATA_CONCLUSAO" maxlength="10" tipo="data" display="DATA DE PREVISO" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 80px;" />
							<button type="button" id="BTN_DATA_CONCLUSAO" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
							<script type="text/javascript"> 
									Calendar.setup( {
									inputField  : "DATA_CONCLUSAO",      // ID of the input field
									ifFormat    : "%d/%m/%Y", 			// the date format
									button      : "BTN_DATA_CONCLUSAO",  // ID of the button
									range       : [2001,2050]
								} );
                            </script>
                             <cfelse>
                        	<span id="sp_data_conclusao" class="texto_negrito">No Conclu&iacute;do</span>
                            <input type="hidden" name="DATA_CONCLUSAO" id="DATA_CONCLUSAO" value="" />
                          </cfif>
                       </td>
                    </tr>
                    <tr id="formulario_site" style="display:none;">
                      <td nowrap class="texto" valign="top">Reclama&ccedil;&atilde;o/Sugest&atilde;o:</td>
                      <td class="texto"><span id="sp_descricao"></span></td>
                    </tr>
                    <tr style="display:none;" id="td_registro_descricao_id">
                        <td nowrap class="texto">Selecione uma Descri&ccedil;&atilde;o:</td>
                        <td class="texto"><select name="REGISTRO_DESCRICAO_ID" id="REGISTRO_DESCRICAO_ID" obrigatorio="0" display="DESCRIO" onChange="f_muda_registro_descricao()">
                        	<option value="" descricao="">-- Selecione --</option>
                            <cfoutput query="qrRegistroDescricao">
                                <option value="#qrRegistroDescricao.REGISTRO_DESCRICAO_ID#" descricao="#qrRegistroDescricao.DESCRICAO#">#qrRegistroDescricao.TITULO#</option>
                            </cfoutput>
                        	</select></td>
                    </tr>
                    <tr style="display:none;" id="td_registro_descricao">
                        <td nowrap class="texto"></td>
                        <td class="texto"><textarea name="REGISTRO_DESCRICAO" id="REGISTRO_DESCRICAO" rows="5" readonly display="DESCRIO" style="width: 100%;"></textarea></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto" valign="top">Descri&ccedil;&atilde;o:</td>
                        <td class="texto"><textarea name="DESCRICAO" id="DESCRICAO" rows="5" obrigatorio="0" display="DESCRIO" onKeyPress="if(this.value.length >= 1000) { return false; }" style="width: 100%;"></textarea></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto" valign="top">
						<cfif isdefined("session.site") and session.site eq "delpozo/">
                        An&aacute;lise das Causas:
                        <cfelse>
                        Poss&iacute;veis Causas:</cfif></td>
                        <td class="texto"><textarea name="POSSIVEIS_CAUSAS" id="POSSIVEIS_CAUSAS" rows="5" obrigatorio="<cfif session.site eq "transemba/">0<cfelse><cfoutput>#v_exibir_campos#</cfoutput></cfif>" display="POSSVEIS CAUSAS" onKeyPress="if(this.value.length >= 1000) { return false; }" style="width: 100%;"></textarea></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto" valign="top">
						<cfif isdefined("session.site") and session.site eq "delpozo/">
                        A&ccedil;&atilde;o Imediata:
                        <cfelse>
                        Solu&ccedil;&atilde;o Aplic&aacute;vel:</cfif>
                        </td>
                        <td class="texto"><textarea name="SOLUCAO_APLICAVEL" id="SOLUCAO_APLICAVEL" rows="5" display="SOLUO APLICVEL" onKeyPress="if(this.value.length >= 1000) { return false; }" style="width: 100%;"></textarea></td>
                    </tr>
                    <tr style="display:<cfif v_exibir_anexos eq 0>none;</cfif>">
                      <td width="1%" nowrap class="texto">Anexo:</td>
                      <td width="99%" class="texto">
                       	<input type="hidden" name="ANEXO_ID" obrigatorio="1" display="ANEXO" secao="ANEXOS" />
                        <input type="hidden" name="REG_ANEXO_ID"  />
                        <input type="hidden" name="ANEXO_URL" />    
                        <input name="ANEXO_TITULO" type="text" id="ANEXO_TITULO" style="width:400px" obrigatorio="1" display="ANEXO" secao="ANEXOS" readonly="true">
                        <button type="button" class="botao-16x16" onClick="f_anexar('ANEXO_ID')" title="Adicionar Anexo"><img src="/_imagens/botoes/16x16/anexos.gif" alt="" width="16" height="16" align="absmiddle" /></button>      
                        <button type="button" class="botao-16x16" onClick=" f_visualizar_anexo()" title="Visualizar Anexo"><img src="/_imagens/botoes/16x16/visualizar.gif" alt="" width="16" height="16" align="absmiddle" /></button>                   
                        &nbsp;Ordem:&nbsp;<input type="text" name="ANEXO_ORDEM" id="ANEXO_ORDEM" maxlength="2" obrigatorio="0" tipo="numerico" style="width:40px;" />
                      </td>
                    </tr>
                     <tr style="display:<cfif v_exibir_anexos eq 0>none;</cfif>">
                      <td>&nbsp;</td>
                      <td valign="top" nowrap class="texto"> 
												<cfset lista_id = 'ANEXOS'>
												<cfset lista_campos = 'REG_ANEXO_ID,ANEXO_ID,ANEXO_TITULO,ANEXO_URL,ANEXO_ORDEM'> 
                                                <cfset lista_titulos = 'Anexo,Ordem'>
                                                <cfset lista_titulos_campos = "ANEXO_TITULO,ANEXO_ORDEM">
                                                <cfset lista_titulos_tamanho = '350,50'>                                               
                                                <cfset lista_width = '90%,10%'>
                                                 <cfset lista_height = '100'>
                                                <cfset lista_default = 0>
                                                <cfset lista_campo_id = 'REG_ANEXO_ID'>
                                                <cfinclude template="/_include/lista.cfm">                                            
                      </td>
                    </tr> 
                </table>
                </fieldset>
			</td>
        </tr>
	</table>
    <div id="div_avaliar_registro" style="position: absolute; width: 400px; height: 140px; display: none;">
     	<table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_avaliar_registro" style="cursor: move;">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito"><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Avaliar Registro</label></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">
                        <tr>
                        	<td width="1%"  nowrap class="texto">Eficaz:</td>
                            <td width="99%" nowrap class="texto"><select name="EFICAZ" id="EFICAZ" display="EFICAZ" style="width: 150px;">
                            <option value="">-- Selecione --</option>
                                <option value="1">Sim</option>
                                <option value="0">No</option>
                            </select></td>
                        </tr>
                        <tr>
                            <td nowrap class="texto" valign="top">Avalia&ccedil;&atilde;o:</td>
                            <td valign="top"><textarea name="AVALIACAO" id="AVALIACAO" rows="5" display="AVALIAO" onKeyPress="if(this.value.length >= 1000) { return false; }" style="width: 100%;"></textarea></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right"><button type="button" id="btn_ocultar_div_avaliar_registro" class="botao" onClick="f_ocultar_div_avaliar_registro()"><nobr><img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr></button>&nbsp;
                    <button type="button" id="btn_confirmar_avaliacao_registro" class="botao" onClick="f_avaliar()"><nobr><img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr></button></td>
            </tr>
        </table>
    </div>
</form>
</body>
<script type="text/javascript">
	v_dragObj = new DragObj({ type: 'preview', moveOpacity : 60 });
	v_dragObj.addObj(document.getElementById('div_avaliar_registro'), document.getElementById('tr_cabecalho_interno_avaliar_registro'));
	<cfif v_descricao_auto eq 1>
		document.getElementById('td_registro_descricao_id').style.display = '';
		document.getElementById('td_registro_descricao').style.display = '';
	<cfelse>
		document.getElementById('td_registro_descricao_id').style.display = 'none';
		document.getElementById('td_registro_descricao').style.display = 'none';
	</cfif>
</script>
</html>
<iframe name="consultas" frameborder="0" width="100%" height="600" src="" style="display:none;"></iframe>