<html>
<cfparam name="vars.SITUACAO_ID" default="1" />
<cfparam name="vars.STATUS_ID" default="1" />
<cfscript>
	conn = CreateComponent("_transportes.consulta.cfc_global");
	qrSituacao = conn.get_cg_ref_codes(rv_domain = 'DOCUMENTO.SITUACAO', owner = 'QUALIDADE');
	v_exibir_anexos = conn.get_parametro_valor(cod_projeto = 11,
										     cod_aplicacao = 'OPERACIONAL',
										parametro_grupo_id = 41,
										      parametro_id = 14);
	
	conn = CreateComponent("_transportes.consulta.qualidade.cfc_controle_documento");
	qrTipoDocumento = conn.get_tipo_documento();
	qrDocumento 	= conn.get_documento(argumentCollection = vars);
	qrLocalizacao 	= conn.get_localizacao_impressao();	
	qrEmail 		= conn.get_responsavel_aprovacao();	
	
	conn_acesso = CreateComponent("_transportes.consulta.cfc_acesso");
	qrModulo = conn_acesso.get_modulos(descricao = 'Qualidade');	
	qrNivelAcesso = conn_acesso.get_modulo_usuario(usuario = session.usuario, modulo_id = qrModulo.modulo_id);	
	
	
</cfscript>
<cfinclude template="/_scripts/scripts.cfm" />
<cfinclude template="/_include/carregando.cfm" />
<script src="/_scripts/dragdrop/drag.js" type="text/javascript"></script>
<script type="text/javascript">
	// Configura botoes //
	parent.f_set_texto('titulo_aplicacao', 'Controle de Qualidade');
	parent.f_set_texto('titulo_pagina', 'Lista de Documentos/Registros');
	
	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); }
	
	parent.f_hidden('btn_editar');
	parent.f_hidden('btn_incluir');	
	parent.f_hidden('btn_excluir');
	parent.f_hidden('btn_cancelar');
	
	<cfif qrNivelAcesso.nivel_acesso lt 5>
		parent.f_hidden('btn_incluir');
	</cfif>
	
	f_habilitar_botao('confirmar', 'f_confirmar()');
	
	// -------------------- //

	
	function f_confirmar() {
		with(document.forms[0]) {			
			SITUACAO_ID.value = SITUACAO_ID_DOC.value;	
			STATUS_ID.value   = STATUS_ID_DOC.value;	
					
			target = '_self';
			action = 'lista.cfm';	
				
			if(f_verifica_form(document.forms[0])) {
				submit();
			}
		}
		return false;
	}
	parent.f_confirmar = f_confirmar;
	function f_incluir() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/aplicacoes/qualidade/cadastros/documento/principal.cfm</cf_url>?funcao_end=f_incluir()', 'f_atualizar()', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}
	parent.f_incluir = f_incluir;
	
	function f_busca_funcionario_responsavel() {
		with(document.forms[0]) {
			COD_RESPONSAVEL.value       	   = '';
			NOME_FUNCIONARIO_RESPONSAVEL.value = '';
			
			if(!COD_FUNCIONARIO_RESPONSAVEL.value) {
				return;
			}
			
			NOME_FUNCIONARIO_RESPONSAVEL.value = 'Buscando funcionrio...';
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_funcionario.cfc</cf_url>?method=get_funcionario'
						,'cod_funcionario=' + COD_FUNCIONARIO_RESPONSAVEL.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.cod_funcionario.length > 0) {
									COD_RESPONSAVEL.value       	   = obj.struct.cod_pessoa[0];
									NOME_FUNCIONARIO_RESPONSAVEL.value = obj.struct.nome_funcionario[0];
								}
								else {
									NOME_FUNCIONARIO_RESPONSAVEL.value = 'Funcionrio no encontrado.';
								}
							}
						});
		}
	}
	
	function f_busca_pessoa_responsavel() {
		with(document.forms[0]) {
			COD_RESPONSAVEL.value       	   = '';
			NOME_FUNCIONARIO_RESPONSAVEL.value = '';
			
			if(!COD_FUNCIONARIO_RESPONSAVEL.value) {
				return;
			}
			
			NOME_FUNCIONARIO_RESPONSAVEL.value = 'Buscando pessoa...';
			
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=getPessoa'
						,'completo=1&cnpj_cpf='+COD_FUNCIONARIO_RESPONSAVEL.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.cod_pessoa.length > 0) {
									COD_RESPONSAVEL.value = obj.struct.cod_pessoa[0];
									NOME_FUNCIONARIO_RESPONSAVEL.value = obj.struct.cliente[0];
								}
								else {
									NOME_FUNCIONARIO_RESPONSAVEL.value = 'Pessoa no encontrada.';
								}
							}
			});
		}
	}
	
	var v_situacao_id;
	var v_cliente_y;
	<!---var v_conteudo = <cfoutput>#qrDocumento.CONTEUDO#</cfoutput>;
	alert('+<cfoutput>#qrDocumento.CONTEUDO#</cfoutput>+');
	--->
	p = new PopupMenu('pop');
	p.addItem('imn_editar_documento', 'Editar...', '/_imagens/botoes/16x16/editar.gif', function() { f_editar_documento(); });
	p.addSeparator('ims_1');
	p.addItem('imn_gerar_versao', 'Gerar Nova Verso...', '/_imagens/botoes/16x16/versao.gif', function() { f_gerar_versao(); });
	p.addItem('imn_visualiza_versao', 'Visualizar Verses...', '/_imagens/botoes/16x16/adicionar_versao.gif', function() { f_visualizar_versao(); });
	p.addSeparator('ims_2');
	p.addItem('imn_inserir_anexo', 'Inserir Anexo...', '/_imagens/botoes/16x16/adicionar_anexo.gif', function() { f_inserir_anexo(); });
	p.addItem('imn_visualizar_anexo', 'Visualizar Anexo(s)...', '/_imagens/botoes/16x16/visualizar_anexo.gif', function() { f_visualizar_anexos(); });
	p.addSeparator('ims_3');
	p.addItem('imn_enviar_validacao', 'Enviar para Validao...', '/_imagens/botoes/16x16/enviar_para_avaliacao.gif', function() { f_mostrar_div_enviar_avaliacao(); });
	p.addItem('imn_enviar_aprovacao', 'Enviar para Aprovao...', '/_imagens/botoes/16x16/enviar_para_avaliacao.gif', function() { f_mostrar_div_enviar_avaliacao(); });
	p.addItem('imn_aprovar', 'Aprovar...', '/_imagens/botoes/16x16/marcar_confirmacao.gif', function() { f_aprovar_documento(); });
	p.addItem('imn_reprovar', 'Reprovar...', '/_imagens/botoes/16x16/desmarcar_confirmacao.gif', function() { f_mostrar_div_reprovar_documento(); });
	p.addItem('imn_visualizar_ciclo_aprovacao', 'Visualizar Aprovaes/Reprovaes...', '/_imagens/botoes/16x16/visualizar.gif', function() { f_visualizar_ciclo(); });
	p.addSeparator('ims_4');
	p.addItem('imn_imprimir', 'Visualizar/Imprimir...', '/_imagens/botoes/16x16/imprimir.gif', function() { f_imprimir_documento(1); });
	p.addItem('imn_exportar_documento', 'Exportar para planilha...', '/_imagens/botoes/16x16/exportar_excel.gif', function() { f_exportar_para_planilha(); });
	p.addItem('imn_imprimir_copia_controlada', 'Impresso Controlada', '/_imagens/botoes/16x16/imprimir.gif', function() { f_imprimir_copia_controlada(); });
	p.addSeparator('ims_5');
	p.addItem('imn_imprimir_lista_impressao', 'Lista de Impresses', '/_imagens/botoes/16x16/lista_impressoes.gif', function() { f_visualizar_impressoes(); });
	p.addSeparator('ims_6');
	p.addItem('imn_desativar', 'Desativar', '/_imagens/botoes/16x16/neutro.gif', function() { f_alterar_status(0); });
	p.addItem('imn_ativar', 'Ativar', '/_imagens/botoes/16x16/aberto.gif', function() { f_alterar_status(1); });

	
	function f_context(event, p_documento_id, p_versao_id, p_tipo_documento_id, p_situacao_id, p_user_insert, p_cod_pessoa_logada, p_cod_responsavel_aprovacao, p_cod_responsavel_validacao, p_status_id, p_documento_formato) {
		with(document.forms[0]) {
			
			
			v_cliente_y = window.event.clientY;	
			
			DOCUMENTO_ID.value = p_documento_id;
			VERSAO_ID_ATUAL.value = p_versao_id;
			SITUACAO_CONTROLE.value = p_situacao_id;
			
			p.itemIds['imn_imprimir'].setVisible(true);
			
			if(p_situacao_id == 1){
				p.itemIds['imn_aprovar'].setVisible(false);
				p.itemIds['imn_reprovar'].setVisible(false);
				p.itemIds['imn_enviar_aprovacao'].setVisible(false);
				p.itemIds['imn_enviar_validacao'].setVisible(true);
				p.itemIds['imn_gerar_versao'].setVisible(false);
			} else {
				p.itemIds['imn_aprovar'].setVisible(false);
				p.itemIds['imn_reprovar'].setVisible(false);
				p.itemIds['imn_enviar_aprovacao'].setVisible(false);
				p.itemIds['imn_enviar_validacao'].setVisible(false);
				p.itemIds['imn_gerar_versao'].setVisible(false);
			}
			
			if(p_situacao_id == 2){ 
				if(p_cod_pessoa_logada == p_cod_responsavel_validacao){
					p.itemIds['imn_reprovar'].setVisible(true);
					p.itemIds['imn_enviar_aprovacao'].setVisible(true);
				} else {
					p.itemIds['ims_3'].setVisible(false);
					p.itemIds['imn_reprovar'].setVisible(false);
					p.itemIds['imn_enviar_aprovacao'].setVisible(false);
				}
				p.itemIds['imn_aprovar'].setVisible(false);
			}	
			
			if(p_situacao_id == 3){
				if(p_cod_pessoa_logada == p_cod_responsavel_aprovacao){
				p.itemIds['imn_aprovar'].setVisible(true);
				p.itemIds['imn_reprovar'].setVisible(true);
				} else {
					p.itemIds['ims_3'].setVisible(false);
					p.itemIds['imn_aprovar'].setVisible(false);
					p.itemIds['imn_reprovar'].setVisible(false);
				}
				p.itemIds['imn_enviar_aprovacao'].setVisible(false);
			}
			
			if(p_situacao_id > 3) {
				p.itemIds['imn_visualizar_ciclo_aprovacao'].setVisible(true);
			}
			else {
				p.itemIds['imn_visualizar_ciclo_aprovacao'].setVisible(false);
			}
			
			if(p_situacao_id == 1 || p_situacao_id == 5){
				p.itemIds['imn_editar_documento'].setVisible(true);
				p.itemIds['ims_1'].setVisible(true);
			}
			else{
				p.itemIds['imn_editar_documento'].setVisible(false);
 			    p.itemIds['ims_1'].setVisible(false);
			}		
			
			if(p_status_id == 1){
				p.itemIds['imn_ativar'].setVisible(false);
			}else{
				p.itemIds['imn_desativar'].setVisible(false);
			}		
			
			
			if(p_situacao_id == 4) {
				p.itemIds['imn_aprovar'].setVisible(false);
				p.itemIds['imn_reprovar'].setVisible(false);
				p.itemIds['imn_enviar_aprovacao'].setVisible(false);
				p.itemIds['imn_enviar_validacao'].setVisible(false);
				p.itemIds['imn_gerar_versao'].setVisible(true);
			}
			
			if(p_situacao_id == 5) {
				p.itemIds['imn_aprovar'].setVisible(false);
				p.itemIds['imn_reprovar'].setVisible(false);
				p.itemIds['imn_enviar_aprovacao'].setVisible(false);
				p.itemIds['imn_enviar_validacao'].setVisible(true);
				p.itemIds['imn_gerar_versao'].setVisible(false);
			}
			
			<cfif isdefined("session.site") and session.site eq "sulista/">
				if(p_situacao_id != 4){
					p.itemIds['imn_editar_documento'].setVisible(true);
				}
			</cfif>
			
			<cfif v_exibir_anexos eq 0>
				p.itemIds['imn_inserir_anexo'].setVisible(false);
				p.itemIds['imn_visualizar_anexo'].setVisible(false);
				p.itemIds['ims_2'].setVisible(false);
			</cfif>
			
			<cfif qrNivelAcesso.nivel_acesso lt 5> 
				p.itemIds['imn_editar_documento'].setVisible(false);
				p.itemIds['imn_gerar_versao'].setVisible(false);
				p.itemIds['imn_inserir_anexo'].setVisible(false);
				p.itemIds['imn_enviar_validacao'].setVisible(false);
				p.itemIds['imn_enviar_aprovacao'].setVisible(false);
				p.itemIds['imn_aprovar'].setVisible(false);
				p.itemIds['imn_reprovar'].setVisible(false);
				p.itemIds['imn_visualizar_ciclo_aprovacao'].setVisible(false);
				p.itemIds['imn_imprimir_copia_controlada'].setVisible(false);	
				p.itemIds['imn_imprimir_lista_impressao'].setVisible(false);
				p.itemIds['imn_ativar'].setVisible(false);
				p.itemIds['imn_desativar'].setVisible(false);
				p.itemIds['ims_1'].setVisible(false);
				p.itemIds['ims_3'].setVisible(false);
				p.itemIds['ims_5'].setVisible(false);								
				p.itemIds['ims_6'].setVisible(false);												
				<cfif isdefined("session.site") and session.site eq "delpozo/">
					p.itemIds['imn_gerar_versao'].setVisible(false);
				</cfif>
		
			</cfif>
			
            	if(p_documento_formato == 1){
				   p.itemIds['imn_exportar_documento'].setVisible(false);	
				}else{
				   p.itemIds['imn_exportar_documento'].setVisible(true);		
				}
				
			return p.contextMenu(event);
		}
	}
	
	function f_editar_documento() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/aplicacoes/qualidade/cadastros/documento/principal.cfm</cf_url>?funcao_end=f_busca_dados(' + DOCUMENTO_ID.value + ', 3)&documento_id='+ DOCUMENTO_ID.value, 'f_atualizar()', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}
	
	function f_exportar_para_planilha() {
		//alert(document.forms[0].DOCUMENTO_ID.value);
	    v_form = document.createElement('form');
		v_form.action = '/_consultas/exportar_conteudo_excel.cfm';
		v_form.method = 'post';
		v_form.target = 'consultas';
		v_input = document.createElement('input');
		v_input.name = 'DOCUMENTO_ID';
		v_input.value = document.forms[0].DOCUMENTO_ID.value;
		v_form.appendChild(v_input);
		document.body.appendChild(v_form);
		v_form.submit();
		v_input.removeNode();
		v_form.removeNode();
		
	}
	
	function f_exportar_pdf(){
		v_form = document.createElement('form');
		v_form.action = '/_consultas/exportar_conteudo_pdf.cfm';
		v_form.method = 'post';
		v_form.target = 'consultas';
		v_input = document.createElement('input');
		v_input.name = 'DOCUMENTO_ID';
		v_input.value = document.forms[0].DOCUMENTO_ID.value;
		v_form.appendChild(v_input);
		document.body.appendChild(v_form);
		v_form.submit();
		v_input.removeNode();
		v_form.removeNode();
		
		}
	
	function f_gerar_versao() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/aplicacoes/qualidade/cadastros/documento/principal.cfm</cf_url>?funcao_end=f_editar()&operacao=8&documento_id='+ DOCUMENTO_ID.value+'&versao_id_atual='+ VERSAO_ID_ATUAL.value, 'f_atualizar()', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}
	
	function f_excluir() {
		with(document.forms[0]) {
			OPERACAO.value = 4; // Excluir
			try {
				ATUALIZA_COMBO.disabled = false;
			} catch(e) {}
			target = 'consultas';
			action = 'confirma.cfm';		
			if(confirm('Para confirmar a excluso do documento clique em OK.')) {
				submit();
			}
		}
	}
	
	function f_visualizar_tarefas() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/aplicacoes/qualidade/cadastros/tarefa/lista.cfm</cf_url>?lista_registros=1&registro_id=' + REGISTRO_ID.value, '', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}
	
	function f_visualizar_anexos(){
		with(document.forms[0]){
			f_ocultar_div_anexo_documento();
				
			obj = document.getElementById('div_anexo_documento');
			f_get_scroll();
			
			if(obj.style.display == 'none') {
				setTimeout("document.getElementById('div_anexo_documento').style.display = '';", 100);
				obj.style.top = p.contentDiv.style.top;
				obj.style.left = 10 + scrOfX;
			}		
						
			url = '<cf_url>/aplicacoes/qualidade/cadastros/documento/consultas.cfm</cf_url>?consulta=3&documento_id='+DOCUMENTO_ID.value+'&versao_id_atual='+VERSAO_ID_ATUAL.value;
			f_query_ajax(url, f_mostra_anexos, null);		
		}
	}
	parent.f_visualizar_anexos = f_visualizar_anexos;	
	
		
	function f_ocultar_div_anexo_documento(){
		document.getElementById('div_anexo_documento').style.display = 'none';
	}	
	
	function f_mostra_anexos(v_anexos){
		document.getElementById("td_busca_dados").innerHTML = v_anexos;
	}
	
	function f_inserir_anexo() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/aplicacoes/qualidade/anexos/lista.cfm</cf_url>?campo=ANEXO_ID&documento_id='+DOCUMENTO_ID.value+'&versao_id='+VERSAO_ID_ATUAL.value,'f_busca_anexo()');
		}
	}
	parent.f_inserir_anexo = f_inserir_anexo;
	
	function f_marcar_confirmacao() {
		with(document.forms[0]) {
			if(confirm('Para marcar a confirmao do registro clique em OK.')) {
				OPERACAO.value = 5;
				target = 'consultas';
				action = 'confirma.cfm';
				submit();
			}
		}
	}
	
	function f_desmarcar_confirmacao() {
		with(document.forms[0]) {
			if(confirm('Para desmarcar a confirmao do registro clique em OK.')) {
				OPERACAO.value = 6;
				target = 'consultas';
				action = 'confirma.cfm';
				submit();
			}
		}
	}
	
	function f_envia_email_cliente() {
		with(document.forms[0]) {
			if(confirm('Para enviar o e-mail de resposta ao cliente clique em OK.')) {
				OPERACAO.value = 7;
				target = 'consultas';
				action = 'confirma.cfm';
				submit();
			}
		}
	}	
	
	function f_aprovar_documento(){
		with(document.forms[0]){
			SITUACAO_ID.value = 4;			
			OPERACAO.value = 6;
			target = 'consultas';
			action = 'confirma.cfm';			
			submit();
		}
	}
	
	function f_mostrar_div_reprovar_documento(){
		with(document.forms[0]){

			SITUACAO_ID.value = 5;				
			
			f_ocultar_div_reprovar_documento();
				
			obj = document.getElementById('div_reprovar_documento');
			f_get_scroll();
			
			if(obj.style.display == 'none') {
				setTimeout("document.getElementById('div_reprovar_documento').style.display = '';", 100);
				obj.style.top = p.contentDiv.style.top;
				obj.style.left = 10 + scrOfX;
			}				
	
			MOTIVO_REPROVACAO.disabled = false;						
			document.getElementById('btn_ocultar_div_reprovar_documento').disabled = false;
		}
	}
	parent.f_mostrar_div_reprovar_documento = f_mostrar_div_reprovar_documento;	
	
		
	function f_ocultar_div_reprovar_documento(){
		document.getElementById('div_reprovar_documento').style.display = 'none';
	}	
	
	function f_reprovar_documento(){
		with(document.forms[0]){
			OPERACAO.value = 6;
			if(MOTIVO_REPROVACAO.value == '') {
				alert('O campo MOTIVO DA REPROVAO  obrigatrio');
				return false;
			}
			target = 'consultas';
			action = 'confirma.cfm';			
			submit();
		}
	}	
	
	function f_visualizar_ciclo(){
		with(document.forms[0]){
			f_ocultar_div_ciclo_documento();
				
			obj = document.getElementById('div_ciclo_documento');
			f_get_scroll();
			
			if(obj.style.display == 'none') {
				setTimeout("document.getElementById('div_ciclo_documento').style.display = '';", 100);
				obj.style.top = p.contentDiv.style.top;
				obj.style.left = 10 + scrOfX;
			}						
		
			url = '<cf_url>/aplicacoes/qualidade/cadastros/documento/consultas.cfm</cf_url>?consulta=4&documento_id='+DOCUMENTO_ID.value;
			f_query_ajax(url, f_mostra_ciclo, null);		
		}
	}
	parent.f_visualizar_ciclo = f_visualizar_ciclo;	
	
		
	function f_ocultar_div_ciclo_documento(){
		document.getElementById('div_ciclo_documento').style.display = 'none';
	}	
	
	function f_mostra_ciclo(v_ciclo){
		document.getElementById("td_busca_dados_ciclo").innerHTML = v_ciclo;
	}
	
	function f_visualizar_versao(){
		with(document.forms[0]){
			f_ocultar_div_versao_documento();
				
			obj = document.getElementById('div_versao_documento');
			f_get_scroll();
			
			if(obj.style.display == 'none') {
				setTimeout("document.getElementById('div_versao_documento').style.display = '';", 100);
				obj.style.top = p.contentDiv.style.top;
				obj.style.left = 10 + scrOfX;
			}						
		
			url = '<cf_url>/aplicacoes/qualidade/cadastros/documento/consultas.cfm</cf_url>?consulta=5&documento_id='+DOCUMENTO_ID.value;
			f_query_ajax(url, f_mostra_versao, null);		
		}
	}
	parent.f_visualizar_versao = f_visualizar_versao;	
	
		
	function f_ocultar_div_versao_documento(){
		document.getElementById('div_versao_documento').style.display = 'none';
	}	
	
	function f_mostra_versao(v_versao){
		document.getElementById("td_busca_dados_versao").innerHTML = v_versao;
	}

	
	function f_imprimir_copia_controlada(){
		with(document.forms[0]){
			f_ocultar_div_versao_documento();
				
			obj = document.getElementById('div_imprimir_documento');
			f_get_scroll();
			
			if(obj.style.display == 'none') {
				setTimeout("document.getElementById('div_imprimir_documento').style.display = '';", 100);
				obj.style.top = p.contentDiv.style.top;
				obj.style.left = 10 + scrOfX;
			}						
			
			LOCALIZACAO_IMPRESSAO.disabled = false;						
			
			document.getElementById('btn_ocultar_div_imprimir_documento').disabled = false;
		}
	}
	parent.f_imprimir_copia_controlada = f_imprimir_copia_controlada;	
	
		
	function f_ocultar_div_imprimir_documento(){
		document.getElementById('div_imprimir_documento').style.display = 'none';
	}	
	

	function f_imprimir(){
		with(document.forms[0]) {
			
			OPERACAO.value = 7;	
			
			if(LOCALIZACAO_IMPRESSAO.value == ''){
				alert('O campo LOCALIZAO DE IMPRESSO  obrigatrio.');	
				return false;
			}		
					
			target = 'consultas';
			action = 'confirma.cfm';			
			submit();
			
			f_imprimir_documento();
		}
	}
	parent.f_imprimir= f_imprimir;
	
	function f_imprimir_documento(controlado){
		with(document.forms[0]) {		
			window.open('<cf_url>/aplicacoes/qualidade/cadastros/documento/copia_controlada.cfm</cf_url>?documento_id='+DOCUMENTO_ID.value+'&controlado='+controlado,'Imprimir','resizable=yes,location=0,status=0,scrollbars=1,width=800,height=600');
		}
	}
	parent.f_imprimir_documento= f_imprimir_documento;
	
	
	function f_visualizar_impressoes(){
		with(document.forms[0]){
			f_ocultar_div_impressoes_documento();
				
			obj = document.getElementById('div_impressoes_documento');
			f_get_scroll();
			
			if(obj.style.display == 'none') {
				setTimeout("document.getElementById('div_impressoes_documento').style.display = '';", 100);
				obj.style.top = p.contentDiv.style.top;
				obj.style.left = 10 + scrOfX;
			}				
			
			
			url = '<cf_url>/aplicacoes/qualidade/cadastros/documento/consultas.cfm</cf_url>?consulta=6&documento_id='+DOCUMENTO_ID.value;
			f_query_ajax(url, f_mostra_impressoes, null);		
		}
	}
	parent.f_visualizar_impressoes = f_visualizar_impressoes;	
	
		
	function f_ocultar_div_impressoes_documento(){
		document.getElementById('div_impressoes_documento').style.display = 'none';
	}	
	
	function f_mostra_impressoes(v_impressoes){
		document.getElementById("td_busca_dados_impressoes").innerHTML = v_impressoes;
	}
	
	function f_mostrar_div_enviar_avaliacao(){ 
		with(document.forms[0]){
			f_ocultar_div_avaliacao_documento();
				
			obj = document.getElementById('div_avaliacao_documento');
			f_get_scroll();
			
			if(obj.style.display == 'none') {
				setTimeout("document.getElementById('div_avaliacao_documento').style.display = '';", 100);
				obj.style.top = p.contentDiv.style.top;
				obj.style.left = 10 + scrOfX;
			}			
			
			if(SITUACAO_CONTROLE.value == 1){
			    v_situacao_id = 2;
			}	
			if(SITUACAO_CONTROLE.value == 2){
			    v_situacao_id = 3;
			}
			if(SITUACAO_CONTROLE.value == 5){
				v_situacao_id = 3;
			}	
			
			EMAIL_AVALIACAO.disabled = false;	
		}
	}
	parent.f_mostrar_div_enviar_avaliacao = f_mostrar_div_enviar_avaliacao;	
	
		
	function f_ocultar_div_avaliacao_documento(){
		document.getElementById('div_avaliacao_documento').style.display = 'none';
	}
	
	function f_enviar_documento_avaliacao(p_situacao_id) {
		with(document.forms[0]) { 
			SITUACAO_ID.value = p_situacao_id;
			OPERACAO.value = 5;
			if(EMAIL_AVALIACAO.value == '') {
				alert('O campo RESPONSVEL PELA AVALIAO  obrigatrio');
				return false;
			}
			target = 'consultas';
			action = 'confirma.cfm';	
			submit();
		}
	}
	parent.f_enviar_documento_avaliacao = f_enviar_documento_avaliacao;
	
	
	function f_alterar_status(p_status_id) {
		with(document.forms[0]) {
			v_status = p_status_id == 1 ? 'ativar' : 'desativar';
			if(confirm('Para ' + v_status + ' o documento clique em OK.')) {
				STATUS_ID.value = p_status_id;
				OPERACAO.value = 9;
				target = 'consultas';
				action = 'confirma.cfm';
				submit();
			}
		}
	}
	
	function f_exportar_grid_excel(v_id) {
		f_exportar_excel(document.getElementById(v_id));
	}
		
</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KM&amp;M :..</title>
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/status.css</cf_url>" rel="stylesheet" type="text/css" />
<script src="/_scripts/dragdrop.js" type="text/javascript"></script>
</head>
<body class="background" style="height: 100%;">
<form id="form_transportes" name="form_transportes" method="get" action="" onSubmit="return f_confirmar()">
    <input type="hidden" name="OPERACAO" id="OPERACAO" value="" sempre_ativo="1" />
    
    <input type="hidden" name="DOCUMENTO_ID" id="DOCUMENTO_ID" value="" sempre_ativo="1" />
    <input type="hidden" name="SITUACAO_ID" id="SITUACAO_ID" value="" sempre_ativo="1" />
    <input type="hidden" name="ANEXO_ID" id="ANEXO_ID" value="" sempre_ativo="1" />
    <input type="hidden" name="VERSAO_ID_ATUAL" id="VERSAO_ID_ATUAL" value="" sempre_ativo="1" />
    <input type="hidden" name="STATUS_ID" id="STATUS_ID" value="" sempre_ativo="1" />    
    <input type="hidden" name="SITUACAO_CONTROLE" id="SITUACAO_CONTROLE" value="" sempre_ativo="1" />
    
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
    	<tr>
			<td>
                <fieldset><legend>Par&acirc;metros</legend>
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                    <tr>
                	    <td nowrap class="texto">Status:</td>
                	    <td class="texto">
                        	<select id="STATUS_ID_DOC" name="STATUS_ID_DOC" display="STATUS" style="width: 160px;" value="<cfoutput>#vars.STATUS_ID#</cfoutput>">
                            <option value="">-- Ambos --</option>
                            <option value="1" <cfif vars.SITUACAO_ID eq 1>selected</cfif>>Ativo</option>
                            <option value="0" <cfif vars.SITUACAO_ID eq 0>selected</cfif>>Inativo</option>
                            </select>
                        </td>
              	    </tr>
                    <tr>
                	    <td nowrap class="texto">Situa&ccedil;&atilde;o:</td>
                	    <td class="texto"><select id="SITUACAO_ID_DOC" name="SITUACAO_ID_DOC" display="SITUAO" style="width: 160px;" value="<cfoutput>#vars.SITUACAO_ID#</cfoutput>">
                            <option value="">-- Todas --</option>
                            <cfoutput query="qrSituacao">
                            	<option value="#qrSituacao.RV_LOW_VALUE#" <cfoutput><cfif qrSituacao.RV_LOW_VALUE eq vars.SITUACAO_ID>selected</cfif></cfoutput>>#qrSituacao.RV_ABBREVIATION#</option>
                            </cfoutput>
                            </select></td>
              	    </tr>
                    <tr>
                        <td width="1%" nowrap class="texto">Tipo de Documento:</td>
                        <td width="99%" class="texto"><select name="TIPO_DOCUMENTO_ID" id="TIPO_DOCUMENTO_ID" display="TIPO DE DOCUMENTO" style="width: 160px;">
                            <option value="">-- Todos --</option>
							<cfoutput query="qrTipoDocumento">
                                <option value="#qrTipoDocumento.TIPO_DOCUMENTO_ID#">#qrTipoDocumento.DESCRICAO#</option>
                            </cfoutput>
                            </select></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto">Desenvolvido por:</td>
                        <td class="texto">
							<input type="text" name="COD_FUNCIONARIO_RESPONSAVEL" id="COD_FUNCIONARIO_RESPONSAVEL" maxlength="14" obrigatorio="0" tipo="numerico" display="IDENTIFICADOR DO RESPONSVEL" onChange="f_busca_pessoa_responsavel()" onKeyPress="return f_formata(this, '00000000000000')" style="width: 110px;" />
                        	<input type="text" name="NOME_FUNCIONARIO_RESPONSAVEL" id="NOME_FUNCIONARIO_RESPONSAVEL" readonly obrigatorio="0" display="NOME DO RESPONSVEL" style="width: 320px;" />
                            <input type="hidden" name="COD_RESPONSAVEL" id="COD_RESPONSAVEL" obrigatorio="0" display="RESPONSVEL" />
                            <button onClick="NewWindow('/_consultas/localizar_pessoa.cfm?campo=COD_FUNCIONARIO_RESPONSAVEL,NOME_FUNCIONARIO_RESPONSAVEL,COD_RESPONSAVEL&funcao=f_busca_pessoa_responsavel()','_blank',800,600,'yes')" type="button" class="botao-16x16" ><img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle"></button>                           
                         </td>
                    </tr>
					<tr>
                        <td nowrap class="texto">Per&iacute;odo:</td>
                        <td class="texto"><input type="text" name="DATA_INICIAL" id="DATA_INICIAL" maxlength="10" tipo="data" display="DATA INICIAL" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 80px;" />
							<button type="button" id="BTN_DATA_INICIAL" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "DATA_INICIAL",     // ID of the input field
									ifFormat    : "%d/%m/%Y", 		  // the date format
									button      : "BTN_DATA_INICIAL", // ID of the button
									range       : [2001,2050]
								} );
                            </script>
                            at&eacute;
                            <input type="text" name="DATA_FINAL" id="DATA_FINAL" maxlength="10" tipo="data" display="DATA FINAL" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 80px;" />
							<button type="button" id="BTN_DATA_FINAL" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "DATA_FINAL",     // ID of the input field
									ifFormat    : "%d/%m/%Y", 		// the date format
									button      : "BTN_DATA_FINAL", // ID of the button
									range       : [2001,2050]
								} );
                            </script></td>
                    </tr>
					<tr>
					  <td nowrap class="texto">Palavra-chave:</td>
					  <td class="texto"><input type="text" name="PALAVRA_CHAVE" id="PALAVRA_CHAVE" onChange="f_busca_documento_palavra_chave()" style="width: 300px;" /></td>
				  </tr>
                </table>
                </fieldset>
			</td>
        </tr>
        <cfif qrDocumento.RecordCount gt 0>
      	<tr>
        	<td>
            	<cfset grid_cod = 'QUALIDADE_LISTA_DOCUMENTOS_'>
				<cfset grid_query = 'qrDocumento'>
                <cfset grid_field_list    = ''>
                <cfset grid_field_caption = ''>
                <cfset grid_field_align   = ''>
                <cfset grid_field_type    = ''>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DOCUMENTO_ID')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'ID')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CODIGO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'C&oacute;digo')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'TITULO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Ttulo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')> 
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'OBSERVACAO')> 
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Justificativa</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>       
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'TIPO_DOCUMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Tipo de Documento</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'SITUACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Situao</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_VERSAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Verso Atual</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>                
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'PALAVRA_CHAVE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Palavra-chave</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'UNIDADE_NEGOCIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Unidade de Neg&oacute;cio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DEPARTAMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Departamento</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'SETOR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Setor</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CENTRO_CUSTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Centro de Custo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NOME_FUNCIONARIO_RESPONSAVEL')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Respons&aacute;vel</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DOC_FORMATO_DESC')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Formato do documento</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DOC_PROTECAO_DESC')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Proteo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DOC_DESCARTE_DESC')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Descarte aps reteno</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
				<cfset grid_field_list 	  = ListAppend(grid_field_list,'DOC_RECUPERACAO_DESC')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Recuperao</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DOC_TEMPO_RETENCAO_DESC')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Tempo Reteno</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
				<cfset grid_field_list 	  = ListAppend(grid_field_list,'ARMAZENAMENTO_DESC')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Armazenamento</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'APLICABILIDADE_DESC')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Aplicabilidade</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'USER_INSERT')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Inserido Por</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATE_INSERT')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Inserido Em</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'USER_UPDATE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Alterado Por</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATE_UPDATE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Alterado Em</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>

                                
                <cfset grid_td_context_eval 		  = 'fnc_grid_td_context_eval'>
				<cfset grid_tr_class_function 		  = 'fnc_grid_tr_class'>
                <cfset grid_tr_onclick_function 	  = 'fnc_grid_tr_onclick'>
                <cfset grid_td_inline_function 		  = 'fnc_grid_td_inline'>
                <cfset grid_td_class_function 		  = 'fnc_grid_td_class'>
                <cfset grid_tr_oncontextmenu_function = 'fnc_grid_tr_oncontext_menu'>
                
                <cfscript>
                    function fnc_grid_td_context_eval(field) {
                        switch(ucase(field)) {
							case "COD_FUNCIONARIO_RESPONSAVEL":
								return qrDocumento.COD_FUNCIONARIO_RESPONSAVEL & " - " & qrDocumento.NOME_FUNCIONARIO_RESPONSAVEL;
								break;
							default:
								return Evaluate("#grid_query#.#field#");
								break;
						}
                    }
                    
                    function fnc_grid_tr_class() {
						return "linha_branca";
					}
					
					function fnc_grid_tr_onclick() {
						return "this.className = (this.className == 'linha_azul_escura' ? 'linha_branca' : 'linha_azul_escura');";
					}
					
					function fnc_grid_td_inline(field) {
						switch(ucase(field)) {						
							case "DESCRICAO":
								return "";
								break;							
							case "AVALIACAO":
								return "";
								break;
							default:
								return " nowrap";
								break;
						}
					}
					
					function fnc_grid_td_class(field) {
						switch(ucase(field)) {
							case "SITUACAO":
								if(qrDocumento.SITUACAO_ID eq 2 or qrDocumento.SITUACAO_ID eq 3) {
                                    return "linha_amarela";
                                }
                                else if(qrDocumento.SITUACAO_ID eq 5) {
                                    return "linha_vermelha";
                                }
								else if(qrDocumento.SITUACAO_ID eq 4) {
                                    return "linha_verde";
                                }								
                                break;
							default:
								return "";
								break;
						}
					}
					
					function fnc_grid_tr_oncontext_menu() {
                        return "return f_context(event, #qrDocumento.DOCUMENTO_ID#, #qrDocumento.VERSAO_ID_ATUAL#, #qrDocumento.TIPO_DOCUMENTO_ID#, #qrDocumento.SITUACAO_ID#, '#qrDocumento.USER_INSERT#','#session.cod_pessoa_usuario#', '#qrDocumento.COD_RESPONSAVEL_APROVACAO#', '#qrDocumento.COD_RESPONSAVEL_VALIDACAO#', '#qrDocumento.STATUS_ID#','#qrDocumento.DOCUMENTO_FORMATO#')";
                    }
                </cfscript>
                
                <cfset grid_fixed_header = 0>
                <cfinclude template="/_include/grid/grid.cfm">
            </td>
        </tr>
        <cfelse>
        <tr>
            <td align="center" valign="middle" class="obrigatorio" style="padding-top: 10px;">Nenhum documento foi encontrado.</td>
        </tr>
        </cfif>
	</table>
     <div id="div_anexo_documento" style="position: absolute; width: 400px; height: 140px; display: none;">
     	<table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_anexo_documento" style="cursor: move;">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito"><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Anexos do Documento</label></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">                       
                        <tr>
                            <td valign="top" id="td_busca_dados"></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right">
                	<button type="button" id="btn_ocultar_div_anexo_documento" class="botao" onClick="f_ocultar_div_anexo_documento()"><nobr><img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr></button>&nbsp;
                 </td>
            </tr>
        </table>
    </div>
    
    <div id="div_reprovar_documento" style="position: absolute; width: 400px; height: 140px; display: none;">
    <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
        <tr id="tr_cabecalho_interno_reprovar_documento" style="cursor: move;">
            <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito"><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Avaliao do Documento</label></td>
        </tr>
        <tr>
            <td height="98%">
                <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">                       
                    <tr>
                        <td nowrap class="texto" valign="top">Motivo da reprova&ccedil;&atilde;o:</td>      </tr>
                    <tr>
                        <td valign="top"><textarea name="MOTIVO_REPROVACAO" id="MOTIVO_REPROVACAO" display="MOTIVO DA REPROVA&Ccedil;&Atilde;O" onKeyPress="if(this.value.length >= 1000) { return false; }" rows="5" style="width:100%"></textarea></td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td height="1%" id="barra_botoes_bottom" class="texto" align="right">
                <button type="button" id="btn_ocultar_div_reprovar_documento" class="botao" onClick="f_ocultar_div_reprovar_documento()"><nobr><img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr></button>&nbsp;
            	<button type="button" id="btn_confirmar_reprovar_documento" class="botao" onClick="f_reprovar_documento()"><nobr><img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr></button>	
             </td>
        </tr>
    </table>
    </div>
    
    <div id="div_ciclo_documento" style="position: absolute; width: 400px; height: 140px; display: none;">
    	<table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_ciclo_documento" style="cursor: move;">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito"><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Aprovaes/Reprovaes</label></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">                       
                        <tr>
                            <td valign="top" id="td_busca_dados_ciclo"></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right">
                    <button type="button" id="btn_ocultar_div_ciclo_documento" class="botao" onClick="f_ocultar_div_ciclo_documento()"><nobr><img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr></button>&nbsp;
                 </td>
            </tr>
        </table>
    </div>
    
    
    <div id="div_versao_documento" style="position: absolute; width: 400px; height: 140px; display: none;">
     	<table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_versao_documento" style="cursor: move;">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito"><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Verses do Documento</label></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">                       
                        <tr>
                            <td valign="top" id="td_busca_dados_versao"></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right">
                	<button type="button" id="btn_ocultar_div_versao_documento" class="botao" onClick="f_ocultar_div_versao_documento()"><nobr><img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr></button>&nbsp;
                 </td>
            </tr>
        </table>
    </div>
    
   <div id="div_imprimir_documento" style="position: absolute; width: 400px; height: 140px; display: none;">
    <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
        <tr id="tr_cabecalho_interno_imprimir_documento" style="cursor: move;">
            <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito"><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Impresso Controlada</label></td>
        </tr>
        <tr>
            <td height="98%">
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                	<tr>
                	  <td nowrap class="texto">Localiza&ccedil;&atilde;o do documento impresso:&nbsp;</td>
           	      </tr>
                  <tr>
                	  <td width="99%" class="texto">

                      	<select name="LOCALIZACAO_IMPRESSAO" id="LOCALIZACAO_IMPRESSAO" display="LOCALIZA&Ccedil;&Ctilde;O DE IMPRESS&Ctilde;O" style="width:100%">                   
                            <option value="">-- Selecione --</option>
                            <cfoutput query="qrLocalizacao">
                              <option value="#qrLocalizacao.LOCALIZACAO_IMPRESSAO_ID#">#qrLocalizacao.DESCRICAO#</option>
                            </cfoutput>
              	    	</select>
                      </td>
           	      </tr>
             </table>
            </td>
        </tr>
        <tr>
            <td height="1%" id="barra_botoes_bottom" class="texto" align="right">
                <button type="button" id="btn_ocultar_div_imprimir_documento" class="botao" onClick="f_ocultar_div_imprimir_documento()"><nobr><img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr></button>&nbsp;
            	<button type="button" id="btn_confirmar_imprimir_documento" class="botao" onClick="f_imprimir()"><nobr><img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr></button>	
             </td>
        </tr>
    </table>
    </div>
    
   <div id="div_impressoes_documento" style="position: absolute; width: 400px; height: 140px; display: none;">
    	<table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_impressoes_documento" style="cursor: move;">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito"><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Impresses</label></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">                       
                        <tr>
                            <td valign="top" id="td_busca_dados_impressoes"></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right">
                    <button type="button" id="btn_ocultar_div_impressoes_documento" class="botao" onClick="f_ocultar_div_impressoes_documento()"><nobr><img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr></button>&nbsp;
                 </td>
            </tr>
        </table>
    </div>
    
    <div id="div_avaliacao_documento" style="position: absolute; width: 400px; height: 140px; display: none;">
    	<table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_avaliacao_documento" style="cursor: move;">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito"><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Enviar para Avaliao</label></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">                       
                       <tr>
                          <td nowrap class="texto">Respons&aacute;vel pela Avalia&ccedil;&atilde;o:</td>
                       </tr>
                        <tr>
                          <td width="1%" nowrap class="texto">
                          <select name="EMAIL_AVALIACAO" id="EMAIL_AVALIACAO" display="RESPONSVEL" style="width:100%;" onChange="if(this.options[this.selectedIndex].getAttribute('cod_pessoa')) document.getElementById('COD_PESSOA_APROVACAO').value = this.options[this.selectedIndex].getAttribute('cod_pessoa')">
                            <option value="">-- Selecione --</option>                           
							<cfoutput query="qrEmail">
                            <option cod_pessoa="#qrEmail.COD_PESSOA#" value="#qrEmail.EMAIL#">#qrEmail.NOME# - #qrEmail.EMAIL#</option>
                            </cfoutput>
                        </select>
                        <input type="hidden" name="COD_PESSOA_APROVACAO" id="COD_PESSOA_APROVACAO" value="#qrEmail.COD_PESSOA#"/>
                        </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right">
                    <button type="button" id="btn_ocultar_div_avaliacao_documento" class="botao" onClick="f_ocultar_div_avaliacao_documento()"><nobr><img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr></button>&nbsp;
                 	<button type="button" id="btn_confirmar_imprimir_documento" class="botao" onClick="f_enviar_documento_avaliacao(v_situacao_id)"><nobr><img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr></button>	
                 </td>
            </tr>
        </table>
    </div>

    </form>
</body>
<script type="text/javascript">
	f_hide_carregando();
	
	v_dragObj = new DragObj({ type: 'preview', moveOpacity : 60 });
	v_dragObj.addObj(document.getElementById('div_anexo_documento'), document.getElementById('tr_cabecalho_interno_anexo_documento'));
	v_dragObj.addObj(document.getElementById('div_reprovar_documento'), document.getElementById('tr_cabecalho_interno_reprovar_documento'));
	v_dragObj.addObj(document.getElementById('div_ciclo_documento'), document.getElementById('tr_cabecalho_interno_ciclo_documento'));
	v_dragObj.addObj(document.getElementById('div_versao_documento'), document.getElementById('tr_cabecalho_interno_versao_documento'));
	v_dragObj.addObj(document.getElementById('div_imprimir_documento'), document.getElementById('tr_cabecalho_interno_imprimir_documento'));
	v_dragObj.addObj(document.getElementById('div_impressoes_documento'), document.getElementById('tr_cabecalho_interno_impressoes_documento'));
	v_dragObj.addObj(document.getElementById('div_avaliacao_documento'), document.getElementById('tr_cabecalho_interno_avaliacao_documento'));
	
	with(document.forms[0]) {
		<cfoutput>
			<cfif IsDefined("vars.SITUACAO_ID_DOC")>	
				SITUACAO_ID_DOC.value = '#JSStringFormat(vars.SITUACAO_ID_DOC)#';
			</cfif>	
			<cfif IsDefined("vars.STATUS_ID_DOC")>	
				STATUS_ID_DOC.value = '#JSStringFormat(vars.STATUS_ID_DOC)#';
			</cfif>			
			<cfif IsDefined("vars.TIPO_DOCUMENTO_ID")>				
				TIPO_DOCUMENTO_ID.value 		   = '#JSStringFormat(vars.TIPO_DOCUMENTO_ID)#';	
			</cfif>				
			<cfif IsDefined("vars.COD_FUNCIONARIO_RESPONSAVEL")>		
				COD_FUNCIONARIO_RESPONSAVEL.value  = '#JSStringFormat(vars.COD_FUNCIONARIO_RESPONSAVEL)#';
			</cfif>	
			<cfif IsDefined("vars.NOME_FUNCIONARIO_RESPONSAVEL")>		
				NOME_FUNCIONARIO_RESPONSAVEL.value = '#JSStringFormat(vars.NOME_FUNCIONARIO_RESPONSAVEL)#';
			</cfif>	
			<cfif IsDefined("vars.COD_RESPONSAVEL")>		
				COD_RESPONSAVEL.value			   = '#JSStringFormat(vars.COD_RESPONSAVEL)#';
			</cfif>	
			<cfif IsDefined("vars.DATA_INICIAL")>		
				DATA_INICIAL.value 	   			   = '#JSStringFormat(vars.DATA_INICIAL)#';
			</cfif>	
			<cfif IsDefined("vars.DATA_FINAL")>		
				DATA_FINAL.value 	   			   = '#JSStringFormat(vars.DATA_FINAL)#';
			</cfif>	
			
		</cfoutput>
	}
</script>
</html>
<iframe name="consultas" frameborder="0" width="100%" height="600" src="" style=" display:none;"></iframe>
<cfset RequestEnd = 0>