<cfinclude template="/_scripts/scripts.cfm" />
<cfscript>	
	conn = CreateComponent("_transportes.consulta.qualidade.cfc_controle_documento");
	qrDocumento = conn.get_documento(documento_id = vars.DOCUMENTO_ID);
	qrDocAnexo = conn.get_documento_anexo(documento_id = vars.DOCUMENTO_ID);
	qrDocAuditoria = conn.get_documento_versao_auditoria(documento_id = vars.DOCUMENTO_ID);
	connP = CreateComponent("_transportes.consulta.cfc_pessoa");
    v_texto_controlado = "";
    if(IsDefined("vars.controlado") && vars.controlado == 1){ 
       v_texto_controlado = "<span style='font-size: 7px;'>*Cpia no controlada<span>";
    }

	if (session.site != 'delpozo/') {
	qrCargo = connP.get_telefones_pessoa(cod_pessoa = qrDocumento.COD_RESPONSAVEL);
	}
	conn = CreateComponent("_transportes.consulta.cfc_global");
	v_exibir_anexos = conn.get_parametro_valor(cod_projeto = 11,
										     cod_aplicacao = 'OPERACIONAL',
										parametro_grupo_id = 41,
										      parametro_id = 14);
</cfscript>
<cfif v_exibir_anexos eq 1>  
	<cfset marginTop = 2.5/>
<cfelse>
   	<cfset marginTop = 1.8/>
</cfif>

<cfif qrDocumento.DOCUMENTO_FORMATO eq 1>  
	<cfset v_orientacao = 'portrait'/>
<cfelse>
   	<cfset v_orientacao = 'landscape'/>
</cfif>  

<cfdocument format="pdf" name="pdf_documento" margintop="#marginTop#" unit="cm" marginbottom="1.5" marginleft="0.5" marginright="0.5" orientation = "#v_orientacao#">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KM&amp;M :..</title>
<style>
	.background{
		background-color: #FFF;
	}
	.cabecalho_p1{
		font-size:10px;
		border:0;
		border-collapse:collapse;
		border-spacing:0;
		padding:0;
		margin:0;
	}
	.cabecalho_p1 tr td{
		padding:5px;
		border:1px solid #000;
		vertical-align:midlle;
	}
	table tr td{
		border-color:#000;
	}
	.conteudo_corpo{
		width:100% !important;
		font-size:10px;
	}
	a:link, a:visited, a:active, a:hover {
		font-family: Arial, Helvetica, sans-serif;
		font-size: 10px;
		font-weight:bold;
		padding-bottom:2px;
		padding-left:1px;
		color: #484F5B; 
		text-decoration:none;
	}
	
	a:visited {
		color: #484F5B; 
		text-decoration:none;
	}
	
	a:active {
		color: #484F5B; 
		text-decoration:none;
	}
	
	a:hover {
		color: #484F5B;
		font-weight:bold;
		text-decoration:underline;
	}
	body{
		font-family: Arial, Helvetica, sans-serif;
		margin:1px;
		background-color:#F5F5F1;	
		scrollbar-face-color: #E5D4D4; 
		scrollbar-highlight-color: #990000; 
		scrollbar-shadow-color: #FFFFFF; 
		scrollbar-3dlight-color: #ffffff; 
		scrollbar-arrow-color: #990000; 
		scrollbar-track-color: #F5F5F1; 
		scrollbar-darkshadow-color: #990000; 
	}
	#tb_cabecalho,#tb_corpo, #tb_corpo table {
	    border:0;
		border-collapse:collapse;
		border-spacing:0;
		padding:0;
		margin:0;
	}		
	#tb_cabecalho td.td_cabecalho {
		font: 16px Arial, Helvetica, sans-serif;
		border:1px solid #EAEAEA;
		padding:2px 5px;
		text-align:center;
		vertical-align:midlle;	
	}		
</style>
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body style="background-color:#FFFFFF !important;"> 
    <cfdocumentitem type="header">
 		    <cfif session.site eq 'rodomar/' or session.site eq 'bbm/'>  
	            <cfset qrDocumento.CONTEUDO_CABECALHO = Replace(qrDocumento.CONTEUDO_CABECALHO,'/titulo/', UCase(#qrDocumento.TITULO#))/>
	            <cfset qrDocumento.CONTEUDO_CABECALHO = Replace(qrDocumento.CONTEUDO_CABECALHO,'/codigo/', UCase(#qrDocumento.CODIGO#))/>
   	            <cfset qrDocumento.CONTEUDO_CABECALHO = Replace(qrDocumento.CONTEUDO_CABECALHO,'/id_documento/', #qrDocumento.DOCUMENTO_ID#)/>
	            <cfset qrDocumento.CONTEUDO_CABECALHO = Replace(qrDocumento.CONTEUDO_CABECALHO,'/versao_atual/', #qrDocumento.NUM_VERSAO#)/>                
	            <cfset qrDocumento.CONTEUDO_CABECALHO = Replace(qrDocumento.CONTEUDO_CABECALHO,'/tipo_documento/', #qrDocumento.TIPO_DOCUMENTO#)/>
	            <cfset qrDocumento.CONTEUDO_CABECALHO = Replace(qrDocumento.CONTEUDO_CABECALHO,'/responsavel/', #qrDocumento.NOME_FUNCIONARIO_RESPONSAVEL#)/>    
	            <cfset qrDocumento.CONTEUDO_CABECALHO = Replace(qrDocumento.CONTEUDO_CABECALHO,'/situacao/', #qrDocumento.SITUACAO#)/>
	            <cfset qrDocumento.CONTEUDO_CABECALHO = Replace(qrDocumento.CONTEUDO_CABECALHO,'/palavra_chave/', #qrDocumento.PALAVRA_CHAVE#)/>     
   	            <cfset qrDocumento.CONTEUDO_CABECALHO = Replace(qrDocumento.CONTEUDO_CABECALHO,'/logo/', f_url("/_imagens/logos/logo_relatorio.jpg"))/> 
            	<div><cfoutput>#qrDocumento.CONTEUDO_CABECALHO#</cfoutput></div>
            <cfelse>    
            <cfoutput>
                <table width="100%" border="1" height="45" cellspacing="0" cellpadding="0" style="border:1px solid black;border-collapse:collapse;border-spacing:0;padding:0;margin:0; font: 12px Arial, Helvetica, sans-serif;">
                  <tr>
                    <td width="1%"><img src="<cf_url>/_imagens/logos/logo_relatorio.jpg</cf_url>" width="120" height="80"/></td>
                    <td width="98%" align="center" style="border-right:1px solid black;border-left:1px solid black;">#qrDocumento.TITULO#</td>
                    <td align="center" width="1%" nowrap>#qrDocumento.TIPO_DOCUMENTO#<br />#v_texto_controlado#</td> 
                  </tr> 
                </table>
			</cfoutput>
            </cfif> 
	</cfdocumentitem>
    <cfdocumentitem type="footer">
    	<div><cfoutput>#qrDocumento.CONTEUDO_RODAPE#</cfoutput></div>
	</cfdocumentitem>
    <cfoutput>
    <cfif session.site neq 'rodomar/' and session.site neq 'bbm/'>
  
        <table cellspacing="0" cellpadding="0" class="cabecalho_p1" width="100%" align="center">
           
                 <td width="75%" style="border-right:none; border-bottom:none;"><strong onClick="alert(window.innerHeight || self.innerHeight || (document.documentElement&&document.documentElement.clientHeight) || document.body.clientHeight);">Desenvolvido por:</strong>&nbsp;<span style="margin-top:10px;">#JSStringFormat(qrDocumento.NOME_FUNCIONARIO_RESPONSAVEL)#</span> 
                <cfif isDefined("qrCargo") and qrCargo.RecordCount gt 0> <cfif qrCargo.CARGO neq ""><span style="border-top:2px">- #qrCargo.CARGO#</span></cfif> <cfif qrCargo.SETOR neq ""><span style="border-top:4px;">#qrCargo.SETOR#</span></cfif></cfif>
                 </td>
                <td width="25%" style="border-bottom:none;"><strong>Cdigo:</strong>&nbsp;<span style="border-top:4px;">#JSStringFormat(qrDocumento.CODIGO)#</span></td>
            </tr>
            <tr>
                <td style="border-right:none; border-bottom:none;"><strong>Avaliado por:</strong>&nbsp;<cfif qrDocAuditoria.AVALIADO_POR neq ""> #JSStringFormat(qrDocAuditoria.AVALIADO_POR)# </cfif></td>
                <td style="border-bottom:none;"><strong>Avaliado em:</strong>&nbsp;#JSStringFormat(qrDocAuditoria.AVALIADO_EM)#</td>              
            </tr>
              <tr>
                <td style="border-right:none;"><strong>Aprovado por:</strong>&nbsp;<cfif qrDocAuditoria.NOME_USUARIO_APROVACAO neq ""> <span style="border-top:3px">#JSStringFormat(qrDocAuditoria.NOME_USUARIO_APROVACAO)#</span> </cfif></td>
                <td><strong>Aprovado em:</strong>&nbsp;<span style="border-top:4px;">#JSStringFormat(qrDocAuditoria.DATA_APROVACAO)#</span></td>              
            </tr>
        </table>
          
     
        </cfif>
        <div class="conteudo_corpo" style="margin-top: 5px; margin-bottom: 5px;">#qrDocumento.CONTEUDO#</div>
          <cfif v_exibir_anexos eq 1>
            <cfif qrDocAnexo.RecordCount gt 0>
             <table border="0" cellspacing="0" cellpadding="0"  class="cabecalho_p1" width="100%">
				<tr class="tr_corpo">
					<td width="13%" nowrap class="texto"><strong>Anexos:</strong></td>
					<td width="87%" nowrap class="texto">&nbsp;</td>
				</tr>
				<tr class="tr_corpo">
					<td height="100%" colspan="2" valign="top" nowrap class="texto">						   
						<ul>
							<cfloop query="qrDocAnexo">
								<li><a href="http://#replace(replace(URLEncodedFormat(replace(qrDocAnexo.ANEXO_URL,'http://','')),'%2E','.','all'),'%2F','/','all')#" target="_blank">#qrDocAnexo.ANEXO_TITULO#</a></li>
							</cfloop>
						</ul>
					</td>
                </tr> 
                </table>
            </cfif>
            </cfif>
			<cfif len(trim(qrDocumento.OBSERVACAO))> 
             <table border="0" cellspacing="0" cellpadding="0" width="100%" class="cabecalho_p1">
				<tr class="tr_corpo">
					<td valign="top" class="texto" style="text-align:justify;">
                    <strong>Justificativa:</strong><br/>
                    #qrDocumento.OBSERVACAO#
                    </td>
				</tr>
            </table>
            </cfif>
                        
        </tbody>
    </table>
      <table  class="cabecalho_p1" width="100%" cellspacing="0" cellpadding="0">
          
             <tr>
                <td width="20%" style="border-right:none;">Recuperao:</td>
                <td width="80%" >#JSStringFormat(qrDocumento.doc_recuperacao_desc)#</td>              
            </tr>
              <tr>
                <td width="20%" style="border-right:none; border-top:none; ">Proteo:</td>
                <td width="80%" style="border-top:none; ">#JSStringFormat(qrDocumento.doc_protecao_desc)#</td>              
            </tr>
          
             <tr>
                <td width="20%" style="border-right:none; border-top:none;">Tempo reteno:</td>
                <td width="80%" style="border-top:none; ">#JSStringFormat(qrDocumento.doc_tempo_retencao_desc)#</td>              
            </tr>
              <tr>
                <td width="20%" style="border-right:none; border-top:none;">Descarte aps reteno:</td>
                <td width="80%" style="border-top:none; ">#JSStringFormat(qrDocumento.doc_descarte_desc)#</td>              
            </tr>
              <tr>
                <td width="20%" style="border-right:none; border-top:none;">Armazenamento:</td>
                <td width="80%" style="border-top:none;  ">#JSStringFormat(qrDocumento.ARMAZENAMENTO_DESC)#</td>              
            </tr>            
              <tr>
                <td width="20%" style="border-right:none; border-top:none;">Aplicabilidade:</td>
                <td width="80%" style="border-top:none;  ">#JSStringFormat(qrDocumento.aplicabilidade_desc)#</td>              
            </tr>
        </table>                
    </cfoutput>
</body>
</html>
</cfdocument>
<cfset path = ExpandPath("/temp")>
<cfpdf action="merge" destination="#path#/documento_#qrDocumento.DOCUMENTO_ID#_#lstimeformat(now(),'hhmiss')#.pdf" overwrite="yes">
        <cfpdfparam source="pdf_documento" />
</cfpdf>
<script>	
  window.open('/temp/documento_<cfoutput>#qrDocumento.DOCUMENTO_ID#_#lstimeformat(now(),'hhmiss')#</cfoutput>.pdf','_self','');
</script>
<cfscript>
	//registra visualizao do documento
	conn_manip = CreateComponent("_transportes.manipulacao.qualidade.cfc_controle_documento"); 
	set_manipulacao = conn_manip.ins_visualizacao_documento(VERSAO_DOCUMENTO_ID = #qrDocumento.versao_id_atual#);			
	fnc_trata_erros(struct_erro = set_manipulacao);
</cfscript>
