<cfinclude template="/_scripts/scripts.cfm" />
<cfscript>
	conn = CreateComponent("_transportes.consulta.cfc_funcionario");
	qrOrganograma = conn.get_organograma();
    connA = CreateComponent("_transportes.consulta.qualidade.cfc_avaliacao_fornecedor");
	qrAvaliacao = connA.get_avaliacoes_fornecedor(avaliacao_id = vars.avaliacao_id);
	qrRequisitosFornecedor = connA.get_requisitos_avaliacao(avaliacao_id = vars.avaliacao_id);
    connG = CreateComponent("_transportes.consulta.cfc_global");	
	qrCGClassificacao = connA.get_cg_ref_codes(rv_domain = 'FORNECEDOR.CLASSIFICACAO', owner = 'QUALIDADE', order = 'to_number(rv_low_value)');
	qrCGAvaliacao = connA.get_cg_ref_codes(rv_domain = 'FORNECEDOR.AVALIACAO', owner = 'QUALIDADE', order = 'to_number(rv_low_value)');
	qrCGCor = connA.get_cg_ref_codes(rv_domain = 'FORNECEDOR.CLASSIFICACAO.COR', owner = 'QUALIDADE', order = 'to_number(rv_high_value)');	
								   										 
	v_pontualidade = connG.get_parametro_valor(cod_projeto = 11,
											 cod_aplicacao = 'OPERACIONAL',
									    parametro_grupo_id = 41,
										      parametro_id = 15);
											  
	if(v_pontualidade eq 1 and isDefined("qrAvaliacao.COD_PESSOA")){										  
		connC = CreateComponent("modulos.compras._componentes.consulta.cfc_compras");	
		qrSolicitacoes = connC.get_solicitacoes_compras(cod_pessoa_fornecedor = qrAvaliacao.COD_PESSOA);
	}
</cfscript>
<cfif session.site eq 'rodomar/' or session.site eq 'bbm/'>  
	<cfset marginTop = 2.5/>
<cfelse>
   	<cfset marginTop = 1.8/>
</cfif>    
<cfdocument format="pdf" name="pdf_documento" margintop="#marginTop#" unit="cm" marginbottom="1.5" marginleft="0.5" marginright="0.5">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KM&amp;M :..</title>
<style>
	.background{
		background-color: #FFF;
	}
	.cabecalho_p1{
		font-size:10px;
		border:0;
		border-collapse:collapse;
		border-spacing:0;
		padding:0;
		margin:0;
	}
	.cabecalho_p1 tr td{
		padding:5px;
		border:1px solid #000;
		vertical-align:midlle;
	}
	table tr td{
		 color:##000 !important;
	}
	/*.conteudo_corpo{
		width:100% !important;
		font-size:10px;
	}*/
	a:link, a:visited, a:active, a:hover {
		font-family: Arial, Helvetica, sans-serif;
		font-size: 10px;
		font-weight:bold;
		padding-bottom:2px;
		padding-left:1px;
		color: #484F5B; 
		text-decoration:none;
	}
	
	a:visited {
		color: #484F5B; 
		text-decoration:none;
	}
	
	a:active {
		color: #484F5B; 
		text-decoration:none;
	}
	
	a:hover {
		color: #484F5B;
		font-weight:bold;
		text-decoration:underline;
	}
	body{
		font-family: Arial, Helvetica, sans-serif;
		margin:1px;
		background-color:#F5F5F1;	
		scrollbar-face-color: #E5D4D4; 
		scrollbar-highlight-color: #990000; 
		scrollbar-shadow-color: #FFFFFF; 
		scrollbar-3dlight-color: #ffffff; 
		scrollbar-arrow-color: #990000; 
		scrollbar-track-color: #F5F5F1; 
		scrollbar-darkshadow-color: #990000; 
	}
	#tb_cabecalho,#tb_corpo, #tb_corpo table {
	    border:0;
		border-collapse:collapse;
		border-spacing:0;
		padding:0;
		margin:0;
	}		
	#tb_cabecalho td.td_cabecalho {
		font: 16px Arial, Helvetica, sans-serif;
		border:1px solid #EAEAEA;
		padding:2px 5px;
		text-align:center;
		vertical-align:midlle;	
	}	
	.tabReq{
		border-collapse: collapse;
		/*width:100%;*/
	}
	.tabReq tr td{
		width:75px;
		text-align:center;
	}
	.tabReq tr th, 	.tabReq tr td{
		padding:2px 5px 2px 5px;	
		color:#000 !important;
	}
	.tabReq tr th{
		font-weight:normal;
		text-align:left;
		border:1px solid #333;
	}		
</style>
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body style="background-color:#FFFFFF !important; color:#000 !important;"> 
    <cfdocumentitem type="header">
   
            <cfoutput>
                <table border="0" cellpadding="0" cellspacing="0" height="45" style="padding-bottom: 0px; margin: 0px; padding-left: 0px; border-spacing: 0; padding-right: 0px; border-collapse: collapse; font: 12px Arial, Helvetica, sans-serif; border:1px solid black; padding-top: 0px" width="100%">
                         <tbody>
                          <tr style="border-bottom:1px solid black;">
                           <td style="border-right:1px solid black; padding-left: 10px; padding-right: 10px; width:6px;">
                            <img height="40" src="<cf_url>/_imagens/logos/logo_relatorio.jpg</cf_url>" width="60" /></td>
                           <td align="center" style=" width:595px; font-weight:bold; border-right:1px solid black;">HOMOLOGA&Ccedil;&Atilde;O DE FORNECEDOR</td>
                           <td align="center" nowrap="nowrap" styke="width:200px;">
                           RQ.#vars.n_avaliacao#/01</td>
                          </tr>
                         </tbody>
                        </table>
			</cfoutput>
	</cfdocumentitem>
    <cfdocumentitem type="footer">
    	<div style="padding-bottom: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; font: 8px Arial, Helvetica, sans-serif; padding-top: 0px; font-weight:bold"><cfoutput>RQ.#vars.n_avaliacao#/01 - HOMOLOGAO DE FORNECEDOR	</cfoutput></div>
	</cfdocumentitem>
    <cfoutput>
    		<table border="0" cellspacing="0" cellpadding="3" width="100%">               
                  <tr>
                    <td class="texto" style="width:2% !important; padding-right:5px !important;">Fornecedor:</td>
                    <td class="texto" nowrap>#qrAvaliacao.RAZAO_SOCIAL#</td>
                  </tr>    
                  <tr>
                    <td class="texto" nowrap>C.N.P.J.:</td>
                    <td class="texto">
                        #qrAvaliacao.CNPJ_F#    
                    </td>
                  </tr>                      
                  <tr>
                    <td class="texto">Endere&ccedil;o:</td>
                    <td class="texto" nowrap>
                        #qrAvaliacao.ENDERECO#      
                    </td>
                  </tr>  
                  <tr>
                    <td class="texto">Contato:</td>
                    <td class="texto" nowrap>
                        #qrAvaliacao.CONTATO#   
                    </td>
                  </tr>  
                  <tr>
                    <td class="texto"  colspan="2">Material/servio fornecido: 
                        #qrAvaliacao.PRODUTOS#      
                    </td>
                  </tr>
                  </cfoutput>
                  <cfif v_pontualidade eq 1 and isDefined("qrAvaliacao.COD_PESSOA")>
					<cfset v_media   = 0>
                    <cfset v_pontual = 0>
                    <cfif qrSolicitacoes.RecordCount gt 0>
                        <cfoutput query="qrSolicitacoes">
                            <cfif qrSolicitacoes.STATUS_PREVISAO eq  'Dentro do Prazo'>
                                <cfset v_pontual = v_pontual + 1>
                            </cfif>
                        </cfoutput>
                        <cfset v_media = (v_pontual/qrSolicitacoes.RecordCount)*100>
                    </cfif>
                  <tr>
                    <td class="texto"  colspan="2">Pontualidade:
                        <cfoutput>#LSNumberFormat(v_media,"9999.99")#%</cfoutput>  
                    </td>
                  </tr>
                  </cfif>
                  <cfoutput>
                  <tr>
	                  <td colspan="2">
			                <table border="0" cellspacing="0" cellpadding="0" class="tabReq" id="tabReq" width="100%">                            	
                            	<tr style="font-weight:bold; background:##d9d9d9;">
                                	<th class="texto" style="text-align:center; font-weight:bold; border:1px solid ##333;">ITENS AVALIADOS</th>  </cfoutput>
                                    <cfset menorItem = qrCGAvaliacao.RV_LOW_VALUE[1]>                                
                                    <cfoutput query="qrCGAvaliacao">
		                                	<td nowrap class="texto" style="border-right:1px solid ##333;border-top:1px solid ##333;border-bottom:1px solid ##333;">#qrCGAvaliacao.RV_MEANING#</td>
									</cfoutput>
                                </tr>
                                <cfloop query="qrRequisitosFornecedor">
                                	<tr>
	                                	<th class="texto" style="border-right:1px solid ##333; border-top:none; border-bottom:1px solid ##333;"><cfoutput>#qrRequisitosFornecedor.DESCRICAO#</cfoutput></th>
                                       <cfloop  query="qrCGAvaliacao" >
		                                	<td class="texto" style="border-right:1px solid ##333; border-bottom:1px solid ##333;">
                                            <cfif qrCGAvaliacao.RV_LOW_VALUE eq qrRequisitosFornecedor.PONTOS>
                                            	<img src="<cf_url>/_imagens/botoes/16x16/check.jpg</cf_url>" width="16" height="16"/>
                                            </cfif>
                                            </td>
                                        </cfloop>
                                    </tr>
                                </cfloop>
				<cfoutput>                                
                            </table>
                      </td>
                  </tr>
                  <tr>
					 <td colspan="2">
                    	<table border="0" cellspacing="0" cellpadding="0" style="width:100%">
	                        <tr>
    			              	<td class="texto" colspan="2" style="background-color: ##92cddc; padding:5px 5px 2px 5px; font-weight:bold; color:##000 !important;">TOTAL: #qrAvaliacao.TOTAL_PONTOS# Pontos - #qrAvaliacao.CLASSIFICACAO#</td>
                		   </tr>                  
                           <tr style="font-weight:bold; background:##d9d9d9; text-align:center;">
                           		<td class="texto" colspan="2" style=" padding:5px 5px 2px 0px; color:##000 !important;">MEDIDAS A SEREM TOMADAS CONFORME RESULTADO DA AVALIA&Ccedil;&Atilde;O</td>
                           </tr>                        
                <cfset maiorItem = qrCGAvaliacao.RV_LOW_VALUE[qrCGAvaliacao.recordCount]>  
                <cfset nRequisitos = qrRequisitosFornecedor.recordCount>
                <cfset maxPontos = maiorItem*nRequisitos>
                <cfset maiorClassif = qrCGClassificacao.RV_HIGH_VALUE[qrCGClassificacao.recordCount]>
                           	
                        <tbody id="classificacoes"></cfoutput>
                        <cfoutput query="qrCGClassificacao">
                          <tr style="font-weight:bold; text-align:left;">
                            <cfset li = (qrCGClassificacao.RV_LOW_VALUE*maxPontos/maiorClassif)+1>
                            <cfset ls = (qrCGClassificacao.RV_HIGH_VALUE*maxPontos/maiorClassif)>
                            <cfset cor = qrCGCor.RV_MEANING[qrCGClassificacao.CurrentRow]>
                                <td class="texto" style="background-color:#cor#; width:1%; padding:5px 5px 2px 5px; color:##000 !important;" nowrap ls='#ls#' li='#li#' resultado='#qrCGClassificacao.RV_MEANING#'>
                            <cfif ls lt maiorItem>
                                #Round(li)# a #Round(ls)#
                            <cfelse>
	                            <cfset li = li-1>
                                &gt; #Round(li)#
                            </cfif>    
                                </td><td class="texto" style="background-color:#cor#; width:99%; padding:5px 5px 2px 5px; color:##000 !important;">#qrCGClassificacao.RV_MEANING#</td>
                          </tr>  
                        </cfoutput> <cfoutput>  
                        </tbody>    
                        
                        </table>
                   </td>
                </tr>
                  <tr>
					 <td colspan="2">
                    	<table border="0" cellspacing="0" cellpadding="0" style="width:100%;;">                
                            <tr>
                                <th colspan="2" class="texto" style="text-align:center; color:##000 !important; background:##d9d9d9; padding:5px 5px 2px 0px; border:1px solid ##333">OBSERVA&Ccedil;&Atilde;O</th>
                            </tr>        
                            <tr>
                                <td colspan="2" class="texto" style="text-align:justify; text-indent:10px;color:##000 !important; padding:5px 5px 2px 5px; border-bottom:1px solid ##333; border-left:1px solid ##333; border-right:1px solid ##333;">
                                <cfif Len(qrAvaliacao.OBSERVACAO) eq 0>
                                	&nbsp;
                                <cfelse>
                                    #qrAvaliacao.OBSERVACAO#
                                </cfif>
                                </td>
                            </tr>
                        </table>
                   </td>
                </tr>                   
                <tr>
                	<td colspan="2">
                    	<table border="0" cellspacing="0" cellpadding="0" style="width:100%;">            
	                        <tr>        	
	                            <th class="texto" style="width:1%; padding:2px 5px 2px 5px; color:##000 !important;">Respons&aacute;vel:&nbsp;</th>
    	                        <td class="texto" style="width:44%; padding:2px 5px 2px 5px; color:##000 !important;">#qrAvaliacao.NOME# </td>
                                <th class="texto" style="width:1%; padding:2px 5px 2px 5px; color:##000 !important;">Data:&nbsp;</th>
    	                        <td class="texto" style="width:44%; padding:2px 5px 2px 5px; color:##000 !important;">#qrAvaliacao.DATA_AVALIACAO# </td>

                           	</tr>
                        </table>
                    </td>
                </tr>                                                            
                 </table>
    </cfoutput>
</body>
</html>
</cfdocument>
<cfset path = ExpandPath("/temp")>
<cfpdf action="merge" destination="#path#/avaliacao_#lstimeformat(now(),'hhmiss')#.pdf" overwrite="yes">
        <cfpdfparam source="pdf_documento" />
</cfpdf>
<script>	
  window.open('/temp/avaliacao_<cfoutput>#lstimeformat(now(),'hhmiss')#</cfoutput>.pdf','_self','');
</script>