
<cfinclude template="/_scripts/scripts.cfm">
<cfscript>
	conn = CreateObject("component", "_transportes.consulta.cfc_desenvolvimento");
	qrRecurso = conn.get_recurso(usuario = session.usuario);
	tecnico = (qrRecurso.tecnico eq 1);
	
</cfscript>

<script>
	top.window.moveTo(screen.width-370,0);
	top.window.resizeTo(370,600);
	top.window.moveTo(screen.width-370,0);
	top.window.document.body.style.overflow = 'hidden';
	parent.f_hidden( 'btn_atualizar' );
	parent.f_hidden( 'btn_incluir' );
	parent.f_hidden( 'btn_editar' );
	parent.f_hidden( 'btn_excluir' );
	parent.f_hidden( 'btn_confirmar' );
	parent.f_hidden( 'btn_cancelar' );
	parent.f_cria_botao('adicionar_msg','Incluir','f_incluir_atd()');
	parent.f_cria_botao('ajuda2','Ajuda','f_ajuda()');
	
	parent.f_set_texto( 'titulo_aplicacao', '<cf_language>Atendimento On-line</cf_language>' );
	parent.f_set_texto( 'titulo_pagina', '<cf_language><cfif tecnico>Atendimento<cfelse>Solicitaes</cfif></cf_language>' );
	
	function f_incluir_atd() {
		f_abrir_janela('/aplicacoes/portal/atendimento/solicitacao/principal.cfm?funcao_end=f_incluir()','f_buscar_abertas()');
	}
	parent.f_incluir_atd = f_incluir_atd;
	function f_editar_atd() {
		with(document.forms[0]) {
			f_abrir_janela('/aplicacoes/portal/atendimento/solicitacao/principal.cfm?funcao_end=f_editar_id('+ATENDIMENTO_ID.value+')','f_buscar_abertas()');
		}
	}
	parent.f_editar_atd = f_editar_atd;


	function f_ajuda() {
		<cfif tecnico>
		NewWindow('/_downloads/Manual_Atendimento_On-Line_Tecnico.pdf','_blank',800,600);
		<cfelse>
		NewWindow('/_downloads/Manual_Atendimento_On-Line_Cliente.pdf','_blank',800,600);
		</cfif>
	}
	parent.f_ajuda = f_ajuda;
	
	function f_buscar_abertas() {
		with (document.forms[0]) {
			CONSULTA.value = 100;
			url = "consultas.cfm?"+f_get_query_string(document.forms[0]);
			f_query_ajax(url, 
				function (p_result) {
					try {
						if(p_result.ajax.readyState == 4 && p_result.ajax.status == 200) {
							if(String(p_result).replace(/ /g, '') != '' && String(p_result).indexOf('wddxPacket') == -1)
								document.getElementById('em_aberto').innerHTML = p_result; 
						}
					} catch(e) {}
				}, null);
		}
	}
	function f_buscar_finalizadas() {
		with (document.forms[0]) {
			CONSULTA.value = 100;
			url = "consultas.cfm?"+f_get_query_string(document.forms[0])+'&situacao_id=3,4';
			f_query_ajax(url, 
				function (p_result) {
					try {
						if(p_result.ajax.readyState == 4 && p_result.ajax.status == 200) { 
							if(String(p_result).replace(/ /g, '') != '' && String(p_result).indexOf('wddxPacket') == -1)
								document.getElementById('finalizadas').innerHTML = p_result; 
						}
					} catch(e) {}
				}, null);
		}
	}
	function f_buscar_nao_lidas() {
		with (document.forms[0]) {
			CONSULTA.value = 100;
			url = "/_transportes/consulta/cfc_atendimento.cfc?method=get_mensagens_nao_lidas";
			p_arguments = "ignorar_atendimento_id="
			f_query_wddx(url, p_arguments, 
				function (obj) {
					try {
						if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
							for(var i=0;i<obj.struct.atendimento_id.length;i++) {
								if(!windows[obj.struct.atendimento_id[i]] || windows[obj.struct.atendimento_id[i]].closed) {
									f_atendimento(obj.struct.atendimento_id[i]);
								}
							}
						} 
					} catch(e) {}
				}, true);
		}
	}
	
	function f_atendimento(p_id) {
		NewWindow('mensagem.cfm?atendimento_id='+p_id+'&tecnico=<cfoutput>#tecnico#</cfoutput>','mensagem_'+p_id,800,600,'yes');
	}
	var windows = [];
	function f_add_window(obj, id) {
		windows[id] = obj;
	}
	
	function f_historico_conversa(p_id) {
		f_abrir_janela('/aplicacoes/portal/atendimento/historico.cfm?atendimento_id='+p_id,'_blank');
	}
	
	setInterval(f_buscar_abertas, 7000);
	setInterval(f_buscar_nao_lidas, 5000);
	
</script>
<script src="/_scripts/dragdrop/popupmenu.js"></script>
<script>
	ppmSol = new PopupMenu('ppmSol');
	with(ppmSol) {
		addItem('imn_incluir','Incluir...','/_imagens/botoes/16x16/incluir.gif',function() { f_incluir_atd(); });
		addItem('imn_editar','Editar...','/_imagens/botoes/16x16/editar.gif',function() { f_editar_atd(); });
		addSeparator('ims_1');
		addItem('imn_abrir','Abrir conversa...','/_imagens/botoes/16x16/abrir.gif',function() { f_iniciar_solicitacao(); });
		addItem('imn_iniciar','Iniciar atendimento...','/_imagens/botoes/16x16/iniciar.gif',function() { f_iniciar_solicitacao(); });
		addItem('imn_fim_conversa','Finalizar conversa...','/_imagens/botoes/16x16/status_finaliza_conversa.gif',function() { f_finalizar_conversa(); });
		addSeparator('ims_2');
		addItem('imn_observacao','Inserir observao...','/_imagens/botoes/16x16/enviar_observacao.gif',function() { f_finalizar_conversa(); });
		addItem('imn_historico','Hist&oacute;rico...','/_imagens/botoes/16x16/historico_conversa.gif',function() { f_finalizar_conversa(); });
		addSeparator('ims_3');
		addItem('imn_atualizar','Atualizar...','/_imagens/botoes/16x16/atualizar.gif',function() { f_buscar_abertas(); });
	}

	function f_context_atendimento(ev, at_id, st_id) {
		with(document.forms[0]) {
			ATENDIMENTO_ID.value = at_id;
			SITUACAO_ID.value = st_id;
			ppmSol.itemIds['imn_incluir'].setVisible   		((String(',1,2,').indexOf(','+st_id+',') != -1));
			ppmSol.itemIds['imn_editar'].setVisible 	  	((String(',1,2,').indexOf(','+st_id+',') != -1));
			ppmSol.itemIds['ims_1'].setVisible   			((String(',1,2,').indexOf(','+st_id+',') != -1));
			ppmSol.itemIds['imn_abrir'].setVisible   		((String(', ,2,').indexOf(','+st_id+',') != -1));
			ppmSol.itemIds['imn_iniciar'].setVisible   		((String(',1, ,').indexOf(','+st_id+',') != -1));
			ppmSol.itemIds['imn_fim_conversa'].setVisible   ((String(', ,2,').indexOf(','+st_id+',') != -1));
			ppmSol.itemIds['ims_2'].setVisible   			((String(',1,2,').indexOf(','+st_id+',') != -1));
			ppmSol.itemIds['imn_observacao'].setVisible   	((String(', ,2,').indexOf(','+st_id+',') != -1));
			ppmSol.itemIds['imn_historico'].setVisible   	((String(',1,2,').indexOf(','+st_id+',') != -1));
			return ppmSol.contextMenu(ev);
		}
	}
</script>
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css">
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css">
<link href="<cf_url>/_estilos/abas.css</cf_url>" rel="stylesheet" type="text/css">
<table width="100%" border="0" cellpadding="0" cellspacing="0" id="tbl_status">
 <form name="form" action="" method="post">
 	<input name="CONSULTA" type="hidden" sempre_ativo="1" />
 	<input name="OPERACAO" type="hidden" sempre_ativo="1" />
 	<input name="TECNICO" type="hidden" sempre_ativo="1" value="<cfoutput>#qrRecurso.tecnico#</cfoutput>" />
 	<input name="ATENDIMENTO_ID" type="hidden" disabled="disabled" ativo="1" value="" />
 	<input name="SITUACAO_ID" type="hidden" disabled="disabled" ativo="1" value="" />
  <tr>
    <td width="12%" nowrap class="td_aba_up">Atendendo </td>
    <td width="13%" class="td_aba_down" onclick="f_buscar_finalizadas()">Finalizadas</td>
    <td width="75%" class="td_aba_none">&nbsp;</td>
  </tr>
  <tr>
    <td colspan="3" class="td_aba_corpo" id="em_aberto">&nbsp;</td>
  </tr>
  <tr>
    <td colspan="3" class="td_aba_corpo" id="finalizadas">&nbsp;</td>
  </tr>
  </form>
</table>
<script>
initAbas('tbl_status',0);
f_buscar_abertas();
</script>
