<html>
<body>
<script src="https://maps.googleapis.com/maps/api/js?v=3.9"></script>
<script type="text/javascript">

var map;
var time = 0;
var markers = new Array();

var directionsDisplay;
var directionsService;

var geocoder;

<cfif isDefined("vars.from") and isDefined("vars.to") >
	var marker_origem = '<cfoutput>#vars.from#</cfoutput>';
	var marker_destino = '<cfoutput>#vars.to#</cfoutput>';
</cfif>

<cfscript>
   if( isDefined("vars.from") )
	  fromDesc = listtoarray(vars.from,'@');
   if( isDefined("vars.to") )
	  toDesc = listtoarray(vars.to,'@');
   if( not isDefined("vars.locale") )
   	  vars.locale = 'pt_BR';
</cfscript>

	var v_origem = '<cfoutput>#vars.from#</cfoutput>';
	var v_destino = '<cfoutput>#vars.to#</cfoutput>';
	
//inicializa o mapa
function initialize() {
	//seta a posio de incio da tela
	var sp = new google.maps.LatLng(-23.547779, -46.639366);
	
	directionsService = new google.maps.DirectionsService();
	directionsDisplay = new google.maps.DirectionsRenderer();
	geocoder = new google.maps.Geocoder();
	
	//arrays para armazenar os pontos intermedirios a rota (pontos definidos pelo usurio)
	markers["marker"] = new Array();
    markers["indice"] = new Array();
	
	var myOptions = {
		zoom: 8,//posio inicia do zoom no gmaps
		center: sp, //posio inicial do mapa
		mapTypeId: google.maps.MapTypeId.ROADMAP //mapa para rota de rodovias
	};
	
	//inicializa o mapa
	map = new google.maps.Map(document.getElementById("mapa"), myOptions);
	
	//ao clicar no mapa, chama evento para criao de marker
	google.maps.event.addListener(map, "click", function(pt) { 
		createMarker(pt);
	});
	
	directionsDisplay.setMap(map);
	//indica qual elemento recebe a descrio do trajeto
	directionsDisplay.setPanel(document.getElementById("rota"));
	//inicia a escrita da rota dentro do mapa baseado nos pontos informados pelo usurio
	marcaOrigemDestino();

}

//cria o marker no mapa
function createMarker(pt){
    marker = new google.maps.Marker({ position: pt.latLng, map: map, draggable:true });	
	markers["marker"].push(marker);
	markers["indice"].push(time);
    eval("google.maps.event.addListener(markers[\"marker\"][(markers[\"marker\"].length-1)], \"click\", function() { removeMarker(eval("+time+")); });");
	//adiciona evento de drag end, quando terminar de arrastar, monta a rota novamente
	google.maps.event.addListener(marker, 'dragend', function() {
		montaRota();
	});
	
	montaRota();
    time++;
}

// remove o marker clicado pelo usurio
function removeMarker(indice){
	for (i in markers["indice"]){
		//verifica se  o marker que foi clicado
		if (markers["indice"][i] == indice){
			//remove o marker do mapa
			markers["marker"][i].setMap(null);
			//remove o marker do array
			markers["marker"].splice(i, 1);
			markers["indice"].splice(i, 1);
			//monta a rota novamente baseado nos pontos restantes
			montaRota();
		}
	}
}

// marca os dois pontos iniciais
function marcaOrigemDestino(){
	//retira do mapa os markers anteriores
	try{
		marker_origem.setMap(null);
	}catch(e){}
	try{
		marker_destino.setMap(null);
	}catch(e){}
	
	markers["marker"] = new Array();
    markers["indice"] = new Array();
	
	codeAddress(document.getElementById('origem').value, 'marker_origem', false);
	codeAddress(document.getElementById('destino').value, 'marker_destino', true);
}

// pega a latitude / longitude atravs de uma string
function codeAddress(p_address, p_var, p_monta_rota) {
	
	var address = p_address;
	//verifica se a classe foi carregada corretamente
	if (geocoder) {
		//obtem o endereo
		geocoder.geocode( { 'address': address}, function(results, status){
			if (status == google.maps.GeocoderStatus.OK){
				map.setCenter(results[0].geometry.location);
				//cria o marker
				var marker = new google.maps.Marker({
					map: map, 
					position: results[0].geometry.location
				});
				//faz varivel receber o marker
				eval(p_var+'=marker;');
				
				if(p_monta_rota)
					montaRota();
			} else {
				alert("Geocode was not successful for the following reason: " + status);
				return null;
			}
		});
	}
	return null;
}

function montaRota() {
	
	var waypts = [];
	// pega os pontos informados no mapa pelo usurio
	if(markers['marker'].length>0){
		for (var i = 0; i < markers['marker'].length; i++) {
			waypts.push({
				location:markers['marker'][i].position,
				stopover:false
			});
		}
	}
	
	var request = {
		origin: marker_origem.position,//ponto de partida
		destination: marker_destino.position,//ponto de chegada
		waypoints : waypts,//pontos indicados no mapa pelo usurio
		optimizeWaypoints : true,
		travelMode: google.maps.DirectionsTravelMode["DRIVING"]
	};
	//traa a rota no mapa
	directionsService.route(request, function(response, status) {
		// se o processo ocorreu com sucesso, pega a ditncia e mostra o "DIRECTIONS" (informaes sobre o trajeto informado)
		if (status == google.maps.DirectionsStatus.OK) {
			directionsDisplay.setDirections(response);
			var totalKM = 0;
			var route = response.routes[0];
			//pega a distancia entre os pontos
			for (var i = 0; i < route.legs.length; i++) {
				var routeSegment = i+1;
				totalKM = totalKM + route.legs[i].distance.value;
			}
			document.getElementById('km_rota').value = Math.round(totalKM/1000);
		}
	});
}

</script>
<style>
body{
	margin:0;
	padding:0;
	background-color:#d9d9d9;
}
*{
	font-family: Arial, Helvetica, sans-serif;
	font-size: 11px;
	font-weight: 100;
	color: #000;
}
.content{
	height:100%;
	width:100%;
}
.googledir div table tbody tr td {
    font-size:9px;
}

.texto {
	font-family: Arial, Helvetica, sans-serif;
	font-size: 11px;
	font-weight: 100;
	color: #000;
}
.campo {
	font-family: Arial, Helvetica, sans-serif;
	font-size: 14px;
	color: #333333;
	border:	1px solid #CCCCCC;
	padding: 0px 3px;
	font-weight:100;
}

a:link {
	color: #000000;
	text-decoration: none;
}
a:visited {
	text-decoration: none;
	color: #000000;
}
a:hover {
	text-decoration: underline;
	color: #000000;
}
a:active {
	text-decoration: none;
	color: #000000;
}

#rota{
	width: 275px;
	height:450px;
	overflow:auto;
}

#ORIGEM, #DESTINO{
	border:1px solid #666666;
	height:25px;
	width:450px;
	font-size:13px;
	padding-top:3px;
	font-weight:bold;
	font-family:Arial, Helvetica, sans-serif;
	letter-spacing:0.3px;
	color:#036;
}

#btn_como_chegar{	
	font-family:Arial, Helvetica, sans-serif;
	font-size:14px;
	font-weight:bold;
	color:#333;
	padding:0px;
	padding-top:2px;	
	margin:0px;
	text-align:center;
	cursor:pointer;
}
</style>
<input type="hidden" id="km_rota" value="">
<input type="hidden" value="Consulta" onClick="marcaOrigemDestino()">
<input type="hidden" value="Monta Rota" onClick="montaRota()">
<input type="hidden" value="Inicia" onClick="initialize()">
<div class="content" >
    <table align="left" border="0" width="100%" height="100%">
        <tr>
            <td width="1%" height="1%" class="texto" style="color:#000;padding-right:7px;font-size:12px">Origem:</td>
            <td><input type="text" id="origem" value="<cfoutput>#fromDesc[1]#</cfoutput>" class="campo" readonly="readonly"></td>
        </tr>
        <tr>
            <td class="texto" style="color:#000;padding-right:7px;font-size:12px">Destino:</td>
            <td>
            	<input type="text" id="destino" value="<cfoutput>#toDesc[1]#</cfoutput>" class="campo" readonly="readonly">
           	 	&nbsp; 
            	<input type="button" id="btn_como_chegar" onClick="initialize()" value="Consultar" title="Consultar rota" />
            </td>
        </tr>
		<tr>
			<td height="99%" colspan="2">
				<table class="texto" width="100%" border="0" height="100%">
					<tr>
						<td width="1" valign="top" class="texto"  height="100%">
							<div id="rota" style="height:100%;  border:1px solid #666"></div>
						</td>
						<td valign="top" height="100%">
							<div id="mapa" style="width: 100%; height:100%;  border:1px solid #666"></div>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
</div>
<script>
initialize();
</script>
</body>
</html>