<?php
ini_set('default_charset', 'UTF-8');
error_reporting(E_ALL ^ E_NOTICE);
$placas = $_POST['placa'];
$frotas = $_POST['frota'];
$descricaoPosicao = $_POST['descricao'];
$latitudes = $_POST['latitude'];
$longitudes = $_POST['longitude'];
$datasPosicao = $_POST['data'];

$velocidadeMedia = isset($_GET['vel_media']) && !empty($_GET['vel_media']) ? $_GET['vel_media'] : 55;

if(count($latitudes)>0){
	array_walk($latitudes, "trocaVirgPorPonto");
}
if(count($longitudes)>0){
	array_walk($longitudes, "trocaVirgPorPonto");
}
$origem = !empty($_POST['origem']) ? utf8_encode($_POST['origem']) : str_replace(chr(10), '', str_replace(chr(13), '', utf8_encode($descricaoPosicao[0])));
$origemLat = str_replace(',', '.', $_POST['lat_origem']);
$origemLong = str_replace(',', '.', $_POST['long_origem']);

$destino = utf8_encode($_POST['destino']);
$destinoLat = str_replace(',', '.', $_POST['lat_destino']);
$destinoLong = str_replace(',', '.', $_POST['long_destino']);

$latVeic = str_replace(',', '.', $_POST['lat']);
$longVeic = str_replace(',', '.', $_POST['long']);

?>
<html>
    <body>
    	<input type="hidden" value="mapa_viagem_calc_dist">
        <style>
            body{
                margin:0;
                padding:0;
                background-color:#d9d9d9;
            }
            *{
                font-family: Arial, Helvetica, sans-serif;
                font-size: 11px;
                font-weight: 100;
                color: #000000;
            }
            .content{
                height:100%;
                width:100%;
            }
            .googledir div table tbody tr td {
                font-size:9px;
            }

            .texto {
                font-family: Arial, Helvetica, sans-serif;
                font-size: 11px;
                font-weight: 100;
                color: #000;
            }
            .campo {
                font-family: Arial, Helvetica, sans-serif;
                font-size: 14px;
                color: #333333;
                border:	1px solid #CCCCCC;
                padding: 0px 3px;
                font-weight:100;
            }

            a:link {
                color: #000000;
                text-decoration: none;
            }
            a:visited {
                text-decoration: none;
                color: #000000;
            }
            a:hover {
                text-decoration: underline;
                color: #000000;
            }
            a:active {
                text-decoration: none;
                color: #000000;
            }

            #rota{
                width: 275px;
                height:450px;
                overflow:auto;
            }

            #ORIGEM, #DESTINO{
                border:1px solid #666666;
                height:25px;
                width:450px;
                font-size:13px;
                padding-top:3px;
                font-weight:bold;
                font-family:Arial, Helvetica, sans-serif;
                letter-spacing:0.3px;
                color:#036;
            }

            #btn_como_chegar{	
                font-family:Arial, Helvetica, sans-serif;
                font-size:14px;
                font-weight:bold;
                color:#333;
                padding:0px;
                padding-top:2px;	
                margin:0px;
                text-align:center;
                cursor:pointer;
            }
        </style>
        <?php include ("./url_maps.php"); ?>
        <script type="text/javascript">

            var map;
            var time = 0;
            var markers = new Array();
            
            var markerOrigem;
            var markerDestino;

			var directionsService;
            
            //inicializa o mapa
            function initialize() {
        		
                var sp = new google.maps.LatLng(<?=$latVeic?>+0.1, <?=$longVeic?>);
				
				directionsService = new google.maps.DirectionsService();
                
                var myOptions = {
                    zoom: <?=!empty($_POST['zoom'])?$_POST['zoom']:'12'?>,//posição inicia do zoom no gmaps
                    center: sp, //posição inicial do mapa
                    mapTypeId: google.maps.MapTypeId.ROADMAP //mapa para rota de rodovias
                };

                map = new google.maps.Map(document.getElementById("mapa"), myOptions);
                
                markers["marker"] = new Array();
                markers["indice"] = new Array();
                //INSERE MARKER DE ORIGEM
                markerOrigem = new google.maps.Marker({
                    position: new google.maps.LatLng(<?= $origemLat ?>, <?= $origemLong ?>)
                    , map: map
                    , icon : 'imagens/origem.png'
                    , shadow : 'imagens/origem_shadow.png'
                    , title : 'Origem: <?=$origem?>'
                });
				<?php
				//cria o balão se a descrição de origem não estiver vazia
				if(!empty($origem)){
				?>
                //cria o objeto de balão
                var infowindow = new google.maps.InfoWindow({
                    content: 'Origem: <?=$origem?>'
                });
                //atribui a INFOWINDOW no click do MARKER
                google.maps.event.addListener(markerOrigem, 'click', function() {
                    infowindow.open(map,markerOrigem);
                });
				<?php
				}//!empty($origem)
				?>
                markers["marker"].push(markerOrigem);
                markers["indice"].push(time);
                time++;
                <?php
                //percorre os registros recebidos para montar os markers
                if (count($latitudes) > 0) {
                    foreach ($latitudes as $i => $value) {
						//inicializa a variável
						$content = '';
						//se uma das variáveis possuir valor (PLACA, DATA DA POSICAO ou DESCRICAO DA POSICAO) monta o texto para o BALÃO
						if(!empty($placas[$i]) || !empty($datasPosicao[$i]) || !empty($descricaoPosicao[$i])){
							$content = "<div class='texto'>";
							if($placas[$i]!=''){
								$content .= "<b>Placa:</b> {$placas[$i]} <b>Frota:</b> {$frotas[$i]}";
							}
							if($datasPosicao[$i]!=''){
								$content .= "<br><b>Data:</b> {$datasPosicao[$i]}";
							}
							if($descricaoPosicao[$i]!=''){
								$content .= "<br><b>Posi&ccedil;&atilde;o:</b>" . str_replace(chr(10), '', str_replace(chr(13), '', utf8_encode($descricaoPosicao[$i])));
							}
							$content .= "</div>";
							
							$ultimo = 'false';
							if ($i == (count($placas) - 1)) {
								$ultimo = 'true';
							}
						}
						echo "\ncreateMarker('{$latitudes[$i]}', '{$longitudes[$i]}', '', {$ultimo}, \"{$content}\");";
                    }
                }
                ?>
                //INSERE MARKER DE DESTINO
                markerDestino = new google.maps.Marker({
                    position: new google.maps.LatLng(<?= $destinoLat ?>, <?= $destinoLong ?>)
                    , map: map
                    , icon : 'imagens/destino.png'
                    , shadow : 'imagens/destino_shadow.png'
                    , title : 'Destino: <?=$destino?>'
                });
				<?php
				//cria o balão se a descrição de destino não estiver vazia
				if(!empty($destino)){
				?>
                //cria o objeto de balão
                var infowindowD = new google.maps.InfoWindow({
                    content: 'Destino: <?=$destino?>'
                });
                //atribui a INFOWINDOW no click do MARKER
                google.maps.event.addListener(markerDestino, 'click', function() {
                    infowindowD.open(map,markerDestino);
                });
				<?php
				}//!empty($destino)
				?>
                markers["marker"].push(markerDestino);
                markers["indice"].push(time);
                time++;

                montaRota();
            }

            //cria o marker no mapa
            function createMarker(p_lat, p_long, p_title, p_ultima_pos, p_content){
                var v_icon = 'balao'
                if(p_ultima_pos){
                    v_icon = 'caminhao';
                }
                var marker = new google.maps.Marker({
                    position: new google.maps.LatLng(p_lat, p_long)
                    , map: map
                    , icon : 'imagens/'+v_icon+'.png'
                    , shadow : 'imagens/'+v_icon+'_shadow.png'
                    , title : p_title
                });
                //cria o objeto de balão se o conteudo não for vazio
				if(p_content!=''){
					var infowindow = new google.maps.InfoWindow({
						content: p_content
					});
					//atribui a INFOWINDOW no click do MARKER
					google.maps.event.addListener(marker, 'click', function() {
						infowindow.open(map,marker);
					});
				}
				
                markers["marker"].push(marker);
                markers["indice"].push(time);			
                time++;
            }
            
			var v_km_percorrido;
			var v_km_restante;
			
            function montaRota() {
                v_km_percorrido = 0;
				v_km_restante = 0;
				
                var directionsService = new google.maps.DirectionsService();
                
                var rendererOptions = {
                    suppressMarkers:true,
                    routeIndex:0,
                    preserveViewport:true
                };
                
                <?php
                
                if (count($latitudes) > 0) {
                    //desenha as polylines
                    // Utilizado os WAYPOINTS para diminuir o numero de requisições para montar a rota - evitar o erro OVER_QUERY_LIMIT
					//esta variável indica o numero de waypoints que serão utilizados
					$numWayPoints = 8;
					for($i = 0; $i <= count($latitudes); $i++) {
						$firstPoint = $i;
						//verifica o numero de pontos restantes para traçar a tragetória
						if(($i+$numWayPoints) > count($latitudes)){
							$lastPoint = count($latitudes) - 1;
						}else{//ultimo ponto - posição do array
							$lastPoint = $i + $numWayPoints + 1;
						}
						if(count($latitudes) < $lastPoint){
							$lastPoint = count($latitudes);
							$i = count($latitudes);
						}
						//unset($arrayWayPoints);
						//monta o array com os waypoints para escrita no JS
						echo "var waypts = [];\n";
						for($i = $i+1; $i < $lastPoint; $i++){
							echo "	waypts.push({\n".
								"		location:markers['marker'][{$i}].position,\n".
								"		stopover:true\n".
								"	});\n";
						}
						//volta uma posição para que os trajetos fiquem interligados
						$i = $i-1;
						
                        ?>
                        var request = {
                            origin: markers['marker'][<?=$firstPoint?>].position,//ponto de partida
                            destination: markers['marker'][<?=$lastPoint?>].position,//ponto de chegada
                            waypoints : waypts,//pontos indicados no mapa
                            optimizeWaypoints : true,
                            travelMode: google.maps.DirectionsTravelMode["DRIVING"]
                        };
                        
                        var directionsDisplay<?=$i?> = new google.maps.DirectionsRenderer(rendererOptions);
                        directionsDisplay<?=$i?>.setMap(map);
                        
                        directionsService.route(request, function(response, status) {
                            //pega o KM total percorrido
                            if (status == google.maps.DirectionsStatus.OK) {
                                directionsDisplay<?=$i?>.setDirections(response);
								
								var totalKM = 0;
								var route = response.routes[0];
								//pega a distancia entre os pontos
								for (var i = 0; i < route.legs.length; i++) {
									var routeSegment = i+1;
									totalKM = totalKM + route.legs[i].distance.value;
								}
								v_km_percorrido = v_km_percorrido + Math.round(totalKM/1000);
								
								totalizadores();
                            }
                        });
                        <?php
					}//for
                }
                ?>				
				
				//distância a percorrer
				request = {
					origin: markers['marker'][<?=count($latitudes)?>].position,//posição atual do veículo
					destination: markerDestino.position,//destino
					travelMode: google.maps.DirectionsTravelMode["DRIVING"]
				};
				
				var v_polylineOptions = {
					strokeColor : '#FF0000',
					strokeOpacity: 0.5
				}
				
				var rendererOptions = {
                	suppressMarkers:true,
                    routeIndex:0,
                    preserveViewport:true,
					polylineOptions:v_polylineOptions
                };
				
				var directionsDisplayDestino = new google.maps.DirectionsRenderer(rendererOptions);
				directionsDisplayDestino.setMap(map);
				
				directionsService.route(request, function(response, status) {
					if (status == google.maps.DirectionsStatus.OK) {
						directionsDisplayDestino.setDirections(response);
					}
				});
				
				//traça a rota no mapa
				directionsService.route(request, function(response, status) {
					// se o processo ocorreu com sucesso, pega a ditância e mostra o "DIRECTIONS" (informações sobre o trajeto informado)
					if (status == google.maps.DirectionsStatus.OK) {
						var totalKM = 0;
						var route = response.routes[0];
						//pega a distancia entre os pontos
						for (var i = 0; i < route.legs.length; i++) {
							var routeSegment = i+1;
							totalKM = totalKM + route.legs[i].distance.value;
						}
						v_km_restante = Math.round(totalKM/1000);
						totalizadores();
					}
				});				
				
            }//function montaRota()
			
			function totalizadores(){
				//verifica se o KM é um numero
				if(parseInt(v_km_restante)!=v_km_restante || parseInt(v_km_percorrido)!=v_km_percorrido){
					return;
				}
				
				document.getElementById('km_percorrido').innerHTML  = v_km_percorrido+'km';
				document.getElementById('km_restante').innerHTML	= v_km_restante+'km';
				document.getElementById('km_total').innerHTML       = (v_km_percorrido + v_km_restante)+'km';
				
				//55 adotado como velocidade média para viagem
				var v_tempo_estimado = v_km_restante / <?=$velocidadeMedia?>;
				var v_horas = Math.floor(v_tempo_estimado);
				var v_decimais = (v_tempo_estimado - v_horas)*100;
				var v_minutos = Math.floor((60 * v_decimais)/100);
				//separar HORAS, MINUTOS e SEGUNDOS
				document.getElementById('tempo_estimado').innerHTML = v_horas+'h:'+v_minutos+'min';
				
			}

        </script>
        <div class="content" >
            <table align="left" border="0" width="100%" height="100%">
            	<tr>
                	<td style='padding:15px;' width="1%" nowrap>Distância percorrida: <span id="km_percorrido" style="font-weight:bold;"></span>.</td>
	                <td style='padding:15px;' width="1%" nowrap>Distância da posição atual do veículo até o destino: <span id="km_restante" style="font-weight:bold;"></span>.</td>
                    <td style='padding:15px;' width="1%" nowrap>Tempo estimado para chegada no destino: <span id="tempo_estimado" style="font-weight:bold;"></span>.</td>
    	            <td style='padding:15px;' width="99%" nowrap>Total da rota: <span id="km_total" style="font-weight:bold;"></span>.</td>
                </tr>
                <tr>
                    <td height="99%" colspan="4">
                        <table class="texto" width="100%" border="0" height="100%">
                            <tr>
                                <?php
                                if($mostarCaminhos == 0){
								?>
                                <td valign="top" height="100%">
                                    <div id="mapa" style="width: 100%; height:100%;  border:1px solid #666"></div>
                                </td>
                                <?php
                                }else{
								?>
                                <td width="1" valign="top" class="texto"  height="100%">
                                    <div id="rota" style="height:100%;  border:1px solid #666"></div>
                                </td>
                                <td valign="top" height="100%">
                                    <div id="mapa" style="width: 100%; height:100%;  border:1px solid #666"></div>
                                </td>
                                <?php
                                }
								?>
                            </tr>                          
                        </table>
                    </td>
                </tr>
            </table>
        </div>
        <script>
            initialize();
        </script>
    </body>
</html>