<?php
ini_set('default_charset', 'UTF-8');
error_reporting(E_ALL ^ E_NOTICE);

$placas = $_POST['placa'];
$frotas = $_POST['frota'];
$descricaoPosicao = $_POST['descricao'];
$latitudes = $_POST['latitude'];
$longitudes = $_POST['longitude'];
$datasPosicao = $_POST['data'];

if(count($latitudes)>0){
	array_walk($latitudes, "trocaVirgPorPonto");
}
if(count($longitudes)>0){
	array_walk($longitudes, "trocaVirgPorPonto");
}
$origem = utf8_encode($_POST['origem']);
$origemLat = str_replace(',', '.', $_POST['lat_origem']);
$origemLong = str_replace(',', '.', $_POST['long_origem']);

$destino = utf8_encode($_POST['destino']);
$destinoLat = str_replace(',', '.', $_POST['lat_destino']);
$destinoLong = str_replace(',', '.', $_POST['long_destino']);

//varivel indica se a rota deve ser fechada da ORIGEM at o DESTINO
$origemDestino = $_GET['origemDestino'];
//mostra a div com os trajetos entre os pontos definidos
$mostarCaminhos = $_GET['caminhos'];

?>
<!DOCTYPE html>
<html>
   <head>
      <?php include ("./header_maps.php"); ?>
      <script src="../../_scripts/jquery/jquery.js"></script>

      <style>
      .iwContent{width:900px !important;}
      </style>

      <style type="text/css">
         html { height: 100% }
         body { height: 100%; margin: 0; padding: 0 }
         #mapa { height: 100% }
         #rota { height: 100% }
      </style>
   </head>
   
   <body>
    	<input type="hidden" id="km_rota" value="">
    	<input type="hidden" value="mapa_viagem">
        <?php include ("./url_maps.php"); ?>
        <script type="text/javascript">

            var map;
            var time = 0;
            var markers = new Array();
            
            var markerOrigem;
            var markerDestino;
            
            //inicializa o mapa
            function initialize() {
        
                var sp = new google.maps.LatLng(<?= $origemLat ?>, <?= $origemLong ?>);
                
                var myOptions = {
                    zoom: <?=!empty($_POST['zoom'])?$_POST['zoom']:'12'?>,//posio inicia do zoom no gmaps
                    center: sp, //posio inicial do mapa
                    mapTypeId: google.maps.MapTypeId.ROADMAP //mapa para rota de rodovias
                };

                map = new google.maps.Map(document.getElementById("mapa"), myOptions);
                
                markers["marker"] = new Array();
                markers["indice"] = new Array();
                //INSERE MARKER DE ORIGEM
                markerOrigem = new google.maps.Marker({
                    position: new google.maps.LatLng(<?= $origemLat ?>, <?= $origemLong ?>)
                    , map: map
                    , icon : 'imagens/origem.png'
                    , shadow : 'imagens/origem_shadow.png'
                    , title : "Origem: <?=$origem?>"
                });
				<?php
				//cria o balo se a descrio de origem no estiver vazia
				if(!empty($origem)){
				?>
                //cria o objeto de balo
                var infowindow = new google.maps.InfoWindow({
                    content: "Origem: <?=$origem?>"
                });
                //atribui a INFOWINDOW no click do MARKER
                google.maps.event.addListener(markerOrigem, 'click', function() {
                    infowindow.open(map,markerOrigem);
                });
				<?php
				}//!empty($origem)
				?>
                markers["marker"].push(markerOrigem);
                markers["indice"].push(time);
                time++;
                <?php			
                //percorre os registros recebidos para montar os markers
                if (count($latitudes) > 0) {
                    foreach ($latitudes as $i => $value) {
						//inicializa a varivel
						$content = '';
						//se uma das variveis possuir valor (PLACA, DATA DA POSICAO ou DESCRICAO DA POSICAO) monta o texto para o BALO
						if(!empty($placas[$i]) || !empty($datasPosicao[$i]) || !empty($descricaoPosicao[$i])){
							$content = "<div class='texto'>";
							if($placas[$i]!=''){
								$content .= "<b>Placa:</b> {$placas[$i]} <b>Frota:</b> {$frotas[$i]}";
							}
							if($datasPosicao[$i]!=''){
								$content .= "<br><b>Data:</b> {$datasPosicao[$i]}";
							}
							if($descricaoPosicao[$i]!=''){
								$content .= "<br><b>Posi&ccedil;&atilde;o:</b>" . str_replace(chr(10), '', str_replace(chr(13), '', utf8_encode($descricaoPosicao[$i])));
							}
							$content .= "</div>";
							
							$ultimo = 'false';
							if ($i == (count($placas) - 1)) {
								$ultimo = 'true';
							}
						}
						echo "\ncreateMarker('{$latitudes[$i]}', '{$longitudes[$i]}', '', {$ultimo}, \"{$content}\");";
                    }
                }
                ?>
                //INSERE MARKER DE DESTINO
                markerDestino = new google.maps.Marker({
                    position: new google.maps.LatLng(<?= $destinoLat ?>, <?= $destinoLong ?>)
                    , map: map
                    , icon : 'imagens/destino.png'
                    , shadow : 'imagens/destino_shadow.png'
                    , title : "Destino: <?=$destino?>"
                });
				<?php
				//cria o balo se a descrio de destino no estiver vazia
				if(!empty($destino)){
				?>
                //cria o objeto de balo
                var infowindowD = new google.maps.InfoWindow({
                    content: "Destino: <?=$destino?>"
                });
                //atribui a INFOWINDOW no click do MARKER
                google.maps.event.addListener(markerDestino, 'click', function() {
                    infowindowD.open(map,markerDestino);
                });
				<?php
				}//!empty($destino)
				?>
                markers["marker"].push(markerDestino);
                markers["indice"].push(time);
                time++;

                montaRota();
            }

            //cria o marker no mapa
            function createMarker(p_lat, p_long, p_title, p_ultima_pos, p_content){
                var v_icon = 'balao'
                if(p_ultima_pos){
                    v_icon = 'caminhao';
                }
                var marker = new google.maps.Marker({
                    position: new google.maps.LatLng(p_lat, p_long)
                    , map: map
                    , icon : 'imagens/'+v_icon+'.png'
                    , shadow : 'imagens/'+v_icon+'_shadow.png'
                    , title : p_title
                });
                //cria o objeto de balo se o conteudo no for vazio
				if(p_content!=''){
					var infowindow = new google.maps.InfoWindow({
						content: p_content
					});
					//atribui a INFOWINDOW no click do MARKER
					google.maps.event.addListener(marker, 'click', function() {
						infowindow.open(map,marker);
					});
				}
				
                markers["marker"].push(marker);
                markers["indice"].push(time);
                time++;
            }
            
            function montaRota() {
                
                var directionsService = new google.maps.DirectionsService();
                
                var rendererOptions = {
                    suppressMarkers:true,
                    routeIndex:0,
                    preserveViewport:true
                };
				
				var totalKM = 0;
                <?php
				
				if (count($latitudes) > 0) {
					$latitudes[] = str_replace(',', '.', $_POST['lat_destino']);
					$logitudes[] = str_replace(',', '.', $_POST['long_destino']);
				}
				
                if (count($latitudes) > 0) {
                    //desenha as polylines
                    // no foi utilizado os WAYPOINTS do procedimento ROUTE por limitao da google - permite apenas que 8 pontos sejam "plotados"
                    // desta forma,  desenhado uma linha entre cada ponto definido no mapa
					$numWayPoints = 8;
					$maior = 0;
					if(count($latitudes) > $numWayPoints){
					    $coeficiente = (count($latitudes) / $numWayPoints);
					}else{
						$coeficiente = 1;
					}
                    for($i=0; $i<count($latitudes); $i++){
						$value = $latitudes[$i];
						$firstPoint = $i;
						//verifica o numero de pontos restantes para traar a tragetria
						if(($i+$numWayPoints) > count($latitudes)){
							$lastPoint = count($latitudes);
						}else{//ultimo ponto - posio do array
							$lastPoint = $i + $numWayPoints + 1;
						}
						if(count($latitudes) < $lastPoint){
							$lastPoint = count($latitudes);
							$i = count($latitudes);
						}
						
						if(count($latitudes) > $lastPoint){
							$lastPoint = $lastPoint -1;
							$i = $lastPoint -1;
							$maior = 1;
						}
						
						
						//monta o array com os waypoints para escrita no JS
						echo "	var waypts = [];\n";
						 
						
						for($i = 1; $i < $lastPoint; $i++){
							$indice = floor($i * $coeficiente);	
								
							echo "	waypts.push({\n".
								"		location:markers['marker'][{$indice}].position,\n".
								"		stopover:true\n".
								"	});\n";
						}
						
						 if($maior == 1){
						    $lastPoint = count($latitudes);
						 }
						
						
						//volta uma posio para que os trajetos fiquem interligados
						$i = $i-1;						
                        ?>
                        var request = {
                            origin: markers['marker'][<?=$firstPoint?>].position,//ponto de partida
                            destination: markers['marker'][<?=$lastPoint?>].position,//ponto de chegada
                            waypoints : waypts,//pontos indicados no mapa
                            optimizeWaypoints : true,
                            travelMode: google.maps.DirectionsTravelMode["DRIVING"]
                        };
                        
                        var directionsDisplay<?=$i?> = new google.maps.DirectionsRenderer(rendererOptions);
                        directionsDisplay<?=$i?>.setMap(map);
						<?php if($mostarCaminhos==1){?>
						directionsDisplay<?=$i?>.setPanel(document.getElementById("rota"));
						<?php } ?>
                        
                        directionsService.route(request, function(response, status) {
                            // se o processo ocorreu com sucesso, pega a ditncia e mostra o "DIRECTIONS" (informaes sobre o trajeto informado)
							if (status == google.maps.DirectionsStatus.OK) {
								directionsDisplay<?=$i?>.setDirections(response);
								var route = response.routes[0];
								//pega a distancia entre os pontos
								for (var i = 0; i < route.legs.length; i++) {
									var routeSegment = i+1;
									totalKM = totalKM + route.legs[i].distance.value;
								}
								document.getElementById('km_rota').value = Math.round(totalKM/1000);
							}else{
								var pontosErro = '';
								for(var i = <?=$firstPoint?>; i<=<?=$lastPoint?>; i++)
									pontosErro += i+' ('+markers['marker'][i].position.ob+','+markers['marker'][i].position.pb+')/';
								document.getElementById("erroRota").innerHTML = document.getElementById("erroRota").innerHTML+"<br/>No foi possvel definir a rota entre os pontos: "+pontosErro;
								}
                        });
                        <?php
					}//foreach
                }else{//quando apenas a origem e o destino so enviados
					?>
					var request = {
						origin: markers['marker'][0].position,//ponto de partida
						destination: markers['marker'][1].position,//ponto de chegada
						waypoints : [],//pontos indicados no mapa
						optimizeWaypoints : true,
						travelMode: google.maps.DirectionsTravelMode["DRIVING"]
					};
					
					var directionsDisplay0 = new google.maps.DirectionsRenderer(rendererOptions);
					directionsDisplay0.setMap(map);
					<?php if($mostarCaminhos==1){?>
					directionsDisplay0.setPanel(document.getElementById("rota"));
					<?php } ?>
					
					directionsService.route(request, function(response, status) {
						
						// se o processo ocorreu com sucesso, pega a ditncia e mostra o "DIRECTIONS" (informaes sobre o trajeto informado)
						if (status == google.maps.DirectionsStatus.OK) {
							directionsDisplay0.setDirections(response);
							var route = response.routes[0];
							//pega a distancia entre os pontos
							for (var i = 0; i < route.legs.length; i++) {
								var routeSegment = i+1;
								totalKM = totalKM + route.legs[i].distance.value;
							}
							document.getElementById('km_rota').value = Math.round(totalKM/1000);
						}

					});
					<?php
				}//else
				?>
            }
        </script>
        <style>
            body{
                margin:0;
                padding:0;
                background-color:#d9d9d9;
            }
            *{
                font-family: Arial, Helvetica, sans-serif;
                font-size: 11px;
                font-weight: 100;
                color: #000;
            }
            .content{
                height:100%;
                width:100%;
            }
            .googledir div table tbody tr td {
                font-size:9px;
            }

            .texto {
                font-family: Arial, Helvetica, sans-serif;
                font-size: 11px;
                font-weight: 100;
                color: #000;
            }
            .campo {
                font-family: Arial, Helvetica, sans-serif;
                font-size: 14px;
                color: #333333;
                border:	1px solid #CCCCCC;
                padding: 0px 3px;
                font-weight:100;
            }

            a:link {
                color: #000000;
                text-decoration: none;
            }
            a:visited {
                text-decoration: none;
                color: #000000;
            }
            a:hover {
                text-decoration: underline;
                color: #000000;
            }
            a:active {
                text-decoration: none;
                color: #000000;
            }

            #rota{
                width: 275px;
                height:450px;
                overflow:auto;
            }

            #ORIGEM, #DESTINO{
                border:1px solid #666666;
                height:25px;
                width:450px;
                font-size:13px;
                padding-top:3px;
                font-weight:bold;
                font-family:Arial, Helvetica, sans-serif;
                letter-spacing:0.3px;
                color:#036;
            }

            #btn_como_chegar{	
                font-family:Arial, Helvetica, sans-serif;
                font-size:14px;
                font-weight:bold;
                color:#333;
                padding:0px;
                padding-top:2px;	
                margin:0px;
                text-align:center;
                cursor:pointer;
            }
        </style>
        <div class="content" >
            <table align="left" border="0" width="100%" height="100%">
                <tr>
                    <td height="99%" colspan="2">
                        <table class="texto" width="100%" border="0" height="100%">
                            <tr>
                                <?php
                                if($mostarCaminhos == 0){
								?>
                                <td valign="top" height="100%">
                                    <div id="mapa" style="width: 100%; height:100%;  border:1px solid #666"></div>
                                </td>
                                <?php
                                }else{
								?>
                                <td width="1" valign="top" class="texto"  height="100%">
                                    <div id="rota" style="height:100%;  border:1px solid #666"></div>
                                </td>
                                <td valign="top" height="100%">
                                    <div id="mapa" style="width: 100%; height:100%;  border:1px solid #666"></div>
                                </td>
                                <?php
                                }
								?>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>
        <div id="erroRota"></div>
        <script>
            initialize();
        </script>
    </body>
</html>