<?php
ini_set('default_charset', 'UTF-8');
error_reporting(E_ALL ^ E_NOTICE);

//distancia informada para montar os crculos
$latitudes = $_POST['latitude'];
$longitudes = $_POST['longitude'];
$postos = $_POST['postos'];

if(count($latitudes)>0){
	array_walk($latitudes, "trocaVirgPorPonto");
}
if(count($longitudes)>0){
	array_walk($longitudes, "trocaVirgPorPonto");
}

$latPosto = str_replace(',', '.', $latitudes[0]);
$longPosto = str_replace(',', '.',$longitudes[0]);

?>
<html>
    <body>
    	<input type="hidden" value="mapa_postos">
        <script src="https://maps.googleapis.com/maps/api/js?v=3.9"></script>
        <script type="text/javascript">

            var map;
            var time = 0;
            var markers = new Array();
			var rota = new Array();
            
            //inicializa o mapa
            function initialize() {
        
                var sp = new google.maps.LatLng(<?=$latPosto?>, <?=$longPosto?>);
                var myOptions = {
                    zoom: <?=!empty($_POST['zoom'])?$_POST['zoom']:'12'?>,//posio inicia do zoom no gmaps
                    center: sp, //posio inicial do mapa
                    mapTypeId: google.maps.MapTypeId.ROADMAP //mapa para rota de rodovias
                };

                map = new google.maps.Map(document.getElementById("mapa"), myOptions);

                markers["marker"] = new Array();
                markers["indice"] = new Array();
                
				rota["marker"] = new Array();
                <?php
                //percorre os registros recebidos para montar os markers
                if(count($postos) > 0){
                    foreach ($postos as $i => $value){
                        echo "\ncreateMarker('{$latitudes[$i]}', '{$longitudes[$i]}', '".utf8_encode($value)."');";
                    }
                }
                ?>
            }

            //cria o marker no mapa
            function createMarker(p_lat, p_long, p_title){
                
                v_icon = 'posto.png';
                
                var marker = new google.maps.Marker({
                      position: new google.maps.LatLng(p_lat, p_long)
                    , map: map
                    , icon : 'imagens/'+v_icon
                    , title : p_title
                });
                
                markers["marker"].push(marker);
                markers["indice"].push(time);
                
                time++;
            }
			
			function trim(str) {
				return str.replace(/^\s+|\s+$/g,"");
			}
			
			function posicionarMapa(p_lat, p_long){
				if(trim(p_lat) == '' || p_lat == 0 ||
				   trim(p_long) == '' || p_long == 0 ){
				   return false;
				}
				var v_pan = new google.maps.LatLng(p_lat.replace(",", "."), p_long.replace(",", "."));
				map.panTo(v_pan);
			}

			var directionsService = null;
			var directionsDisplay = null;
			
			function limpaTrajeto(){
				for(var i = 0; i < rota['marker'].length; i++){
					rota['marker'][i].setMap(null);
				}
				v_indice_rotas = 0;
				rota["marker"] = new Array();
				if(directionsDisplay != null){
					for(var i = 0; i < directionsDisplay.length; i++){
						directionsDisplay[i].setMap(null);
					}
				}
			}
			
			function addMarker(p_latitude, p_longitude, p_referencia, p_data){
				v_icon = 'balao.png';
                v_lat = p_latitude.replace(",", ".");
				v_long = p_longitude.replace(",", ".");
                var marker = new google.maps.Marker({
                      position: new google.maps.LatLng(v_lat, v_long)
                    , map: map
                    , icon : 'imagens/'+v_icon
                    , title : p_referencia+' - '+p_data
                });
                rota["marker"].push(marker);
			}
			
			function montaTrajeto(){
				
				var waypts = new Array(); 
				
				var wp = 0;
				waypts[wp] = new Array();
				
				v_origem = new Array();
				v_destino = new Array();
				
				v_origem[wp] = rota['marker'][0].position;
				
				for(var i = 1; i < rota['marker'].length; i++){
					if(i%7==0){
						wp++;
						waypts[wp] = new Array();
						v_origem[wp] = v_destino[wp-1];
					}
					waypts[wp].push({location: rota['marker'][i].position
									,stopover:true
									});
					v_destino[wp] = rota['marker'][i].position;
				}
				
				directionsDisplay = new Array();
				directionsService = new Array();
				
				for(var i = 0; i <= wp; i++){
					directionsService[i] = new google.maps.DirectionsService()
					
					var rendererOptions = {
						suppressMarkers:true,
						routeIndex:i,
						preserveViewport:true
					};
					
					directionsDisplay[i] = (new google.maps.DirectionsRenderer(rendererOptions));
					directionsDisplay[i].setMap(map);
				}
				desenhaRota(directionsDisplay, directionsService, v_origem, v_destino, waypts, 0);
			}
			
			function desenhaRota(p_directionsDisplay, p_directionsService, p_origem, p_destino, p_waypts, p_indice){
				if(p_indice < p_directionsDisplay.length){
					var request = {
						origin: p_origem[p_indice],//ponto de partida
						destination: p_destino[p_indice],//ponto de chegada
						waypoints : p_waypts[p_indice],//pontos indicados no mapa
						optimizeWaypoints : true,
						travelMode: google.maps.DirectionsTravelMode["DRIVING"]
					};
					
					p_directionsService[p_indice].route(request, function(response, status) {
						if (status == google.maps.DirectionsStatus.OK) {
							p_directionsDisplay[p_indice].setDirections(response);
							desenhaRota(p_directionsDisplay, p_directionsService, p_origem, p_destino, p_waypts, p_indice+1);
						}
					});
				}
			}

        </script>
        <style>
            body{
                margin:0;
                padding:0;
                background-color:#d9d9d9;
            }
            *{
                font-family: Arial, Helvetica, sans-serif;
                font-size: 11px;
                font-weight: 100;
                color: #000;
            }
            .content{
                height:100%;
                width:100%;
            }
            .googledir div table tbody tr td {
                font-size:9px;
            }

            .texto {
                font-family: Arial, Helvetica, sans-serif;
                font-size: 11px;
                font-weight: 100;
                color: #000;
            }
            .campo {
                font-family: Arial, Helvetica, sans-serif;
                font-size: 14px;
                color: #333333;
                border:	1px solid #CCCCCC;
                padding: 0px 3px;
                font-weight:100;
            }

            a:link {
                color: #000000;
                text-decoration: none;
            }
            a:visited {
                text-decoration: none;
                color: #000000;
            }
            a:hover {
                text-decoration: underline;
                color: #000000;
            }
            a:active {
                text-decoration: none;
                color: #000000;
            }

            #rota{
                width: 275px;
                height:450px;
                overflow:auto;
            }

            #ORIGEM, #DESTINO{
                border:1px solid #666666;
                height:25px;
                width:450px;
                font-size:13px;
                padding-top:3px;
                font-weight:bold;
                font-family:Arial, Helvetica, sans-serif;
                letter-spacing:0.3px;
                color:#036;
            }

            #btn_como_chegar{	
                font-family:Arial, Helvetica, sans-serif;
                font-size:14px;
                font-weight:bold;
                color:#333;
                padding:0px;
                padding-top:2px;	
                margin:0px;
                text-align:center;
                cursor:pointer;
            }
        </style>
        <div class="content" >
            <table align="left" border="0" width="100%" height="100%">
                <tr>
                    <td height="99%" colspan="2">
                        <table class="texto" width="100%" border="0" height="100%">
                            <tr>
                                <td valign="top" height="100%">
                                    <div id="mapa" style="width: 100%; height:100%;  border:1px solid #666"></div>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>
        <script>
            initialize();
        </script>
    </body>
</html>