<?php
ini_set('default_charset', 'UTF-8');
error_reporting(E_ALL ^ E_NOTICE);

$placas = $_POST['placa'];
$frotas = $_POST['frota'];
$descricaoPosicao = $_POST['descricao'];
$latitudes = $_POST['latitude'];
$longitudes = $_POST['longitude'];
$datasPosicao = $_POST['data'];

if(count($latitudes)>0){
	array_walk($latitudes, "trocaVirgPorPonto");
}
if(count($longitudes)>0){
	array_walk($longitudes, "trocaVirgPorPonto");
}

$origemLat  = $latitudes[0];
$origemLong = $longitudes[0];
$origemDesc = str_replace(chr(10), '', str_replace(chr(13), '', utf8_encode($descricaoPosicao[0])));
$origemConteudo = "<div class='texto'>";
if($placas[0]!=''){
	$origemConteudo .= "<b>Placa:</b> {$placas[0]} <b>Frota:</b> {$frotas[0]}";
}
if($datasPosicao[0]!=''){
	$origemConteudo .= "<br><b>Data:</b> {$datasPosicao[0]}";
}
if($descricaoPosicao[0]!=''){
	$origemConteudo .= "<br><b>Posi&ccedil;&atilde;o:</b>" . str_replace(chr(10), '', str_replace(chr(13), '', utf8_encode($descricaoPosicao[0])));
}
$origemConteudo .= "</div>";


array_shift($placas);
array_shift($frotas);
array_shift($descricaoPosicao);
array_shift($latitudes);
array_shift($longitudes);
array_shift($datasPosicao);

?>
<html>
    <body>
    	<input type="hidden" value="mapa_posicoes_veiculo">
        <script src="https://maps.googleapis.com/maps/api/js?v=3.9"></script>
        <script type="text/javascript">

            var map;
            var time = 0;
            var markers = new Array();
            
            var markerOrigem;
            var markerDestino;
            
            //inicializa o mapa
            function initialize() {
        
                var sp = new google.maps.LatLng(<?= $origemLat ?>, <?= $origemLong ?>);
                
                var myOptions = {
                    zoom: <?=!empty($_POST['zoom'])?$_POST['zoom']:'12'?>,//posição inicia do zoom no gmaps
                    center: sp, //posição inicial do mapa
                    mapTypeId: google.maps.MapTypeId.ROADMAP //mapa para rota de rodovias
                };

                map = new google.maps.Map(document.getElementById("mapa"), myOptions);
                
                markers["marker"] = new Array();
                markers["indice"] = new Array();
                //INSERE MARKER DE ORIGEM
                markerOrigem = new google.maps.Marker({
                    position: new google.maps.LatLng(<?= $origemLat ?>, <?= $origemLong ?>)
                    , map: map
                    , icon : 'imagens/origem.png'
                    , shadow : 'imagens/origem_shadow.png'
                });
				
                //cria o objeto de balão
                var infowindow = new google.maps.InfoWindow({
                    content: "<?="{$origemConteudo}"?>"
                });
                //atribui a INFOWINDOW no click do MARKER
                google.maps.event.addListener(markerOrigem, 'click', function() {
                    infowindow.open(map,markerOrigem);
                });
				
				markers["marker"].push(markerOrigem);
                markers["indice"].push(time);
                time++;
                <?php
                //percorre os registros recebidos para montar os markers
                if (count($latitudes) > 0) {
                    foreach ($latitudes as $i => $value) {
						
						//inicializa a variável
						$content = '';
						//se uma das variáveis possuir valor (PLACA, DATA DA POSICAO ou DESCRICAO DA POSICAO) monta o texto para o BALÃO
						if(!empty($placas[$i]) || !empty($datasPosicao[$i]) || !empty($descricaoPosicao[$i])){
							$content = "<div class='texto'>";
							if($placas[$i]!=''){
								$content .= "<b>Placa:</b> {$placas[$i]} <b>Frota:</b> {$frotas[$i]}";
							}
							if($datasPosicao[$i]!=''){
								$content .= "<br><b>Data:</b> {$datasPosicao[$i]}";
							}
							if($descricaoPosicao[$i]!=''){
								$content .= "<br><b>Posi&ccedil;&atilde;o:</b>" .  str_replace(chr(10), '', str_replace(chr(13), '', utf8_encode($descricaoPosicao[$i])));
							}
							$content .= "</div>";
							
							$ultimo = 'false';
							if ($i == (count($placas) - 1)) {
								$ultimo = 'true';
							}
						}
						echo "\ncreateMarker('{$latitudes[$i]}', '{$longitudes[$i]}', '', {$ultimo}, \"{$content}\");";
                    }
                }
                ?>

                montaRota();
            }

            //cria o marker no mapa
            function createMarker(p_lat, p_long, p_title, p_ultima_pos, p_content){
                var v_icon = 'balao'
                if(p_ultima_pos){
                    v_icon = 'caminhao';
                }
                var marker = new google.maps.Marker({
                    position: new google.maps.LatLng(p_lat, p_long)
                    , map: map
                    , icon : 'imagens/'+v_icon+'.png'
                    , shadow : 'imagens/'+v_icon+'_shadow.png'
                    , title : p_title
                });
                //cria o objeto de balão se o conteudo não for vazio
				if(p_content!=''){
					var infowindow = new google.maps.InfoWindow({
						content: p_content
					});
					//atribui a INFOWINDOW no click do MARKER
					google.maps.event.addListener(marker, 'click', function() {
						infowindow.open(map,marker);
					});
				}
				
                markers["marker"].push(marker);
                markers["indice"].push(time);
                time++;
            }
            
            function montaRota() {
                
                var directionsService = new google.maps.DirectionsService();
                
                var rendererOptions = {
                    suppressMarkers:true,
                    routeIndex:0,
                    preserveViewport:true
                };
                
                <?php
                
                if (count($latitudes) > 0) {
					//desenha as polylines
                    // Utilizado os WAYPOINTS para diminuir o numero de requisições para montar a rota - evitar o erro OVER_QUERY_LIMIT
					//esta variável indica o numero de waypoints que serão utilizados
					$numWayPoints = 8;
					for($i = 0; $i <= count($latitudes); $i++) {
						$firstPoint = $i;
						//verifica o numero de pontos restantes para traçar a tragetória
						if(($i+$numWayPoints) > count($latitudes)){
							$lastPoint = count($latitudes) - 1;
						}else{//ultimo ponto - posição do array
							$lastPoint = $i + $numWayPoints + 1;
						}
						//monta o array com os waypoints para escrita no JS
						echo "var waypts = [];\n";
						for($i = $i+1; $i < $lastPoint; $i++){
							echo "	waypts.push({\n".
								"		location:markers['marker'][{$i}].position,\n".
								"		stopover:true\n".
								"	});\n";
						}
						//volta uma posição para que os trajetos fiquem interligados
						$i = $i-1;
						
                        ?>
                        var request = {
                            origin: markers['marker'][<?=$firstPoint?>].position,//ponto de partida
                            destination: markers['marker'][<?=$lastPoint?>].position,//ponto de chegada
                            waypoints : waypts,//pontos indicados no mapa
                            optimizeWaypoints : true,
                            travelMode: google.maps.DirectionsTravelMode["DRIVING"]
                        };
                        
                        var directionsDisplay<?=$i?> = new google.maps.DirectionsRenderer(rendererOptions);
                        directionsDisplay<?=$i?>.setMap(map);
                        
                        directionsService.route(request, function(response, status) {
							if (status == google.maps.DirectionsStatus.OK) {
                                directionsDisplay<?=$i?>.setDirections(response);
                            }

                        });
                        <?php
					}//foreach
                }
				
                ?>
            }
        </script>
        <style>
            body{
                margin:0;
                padding:0;
                background-color:#d9d9d9;
            }
            *{
                font-family: Arial, Helvetica, sans-serif;
                font-size: 11px;
                font-weight: 100;
                color: #000;
            }
            .content{
                height:100%;
                width:100%;
            }
            .googledir div table tbody tr td {
                font-size:9px;
            }

            .texto {
                font-family: Arial, Helvetica, sans-serif;
                font-size: 11px;
                font-weight: 100;
                color: #000;
            }
            .campo {
                font-family: Arial, Helvetica, sans-serif;
                font-size: 14px;
                color: #333333;
                border:	1px solid #CCCCCC;
                padding: 0px 3px;
                font-weight:100;
            }

            a:link {
                color: #000000;
                text-decoration: none;
            }
            a:visited {
                text-decoration: none;
                color: #000000;
            }
            a:hover {
                text-decoration: underline;
                color: #000000;
            }
            a:active {
                text-decoration: none;
                color: #000000;
            }

            #rota{
                width: 275px;
                height:450px;
                overflow:auto;
            }

            #ORIGEM, #DESTINO{
                border:1px solid #666666;
                height:25px;
                width:450px;
                font-size:13px;
                padding-top:3px;
                font-weight:bold;
                font-family:Arial, Helvetica, sans-serif;
                letter-spacing:0.3px;
                color:#036;
            }

            #btn_como_chegar{	
                font-family:Arial, Helvetica, sans-serif;
                font-size:14px;
                font-weight:bold;
                color:#333;
                padding:0px;
                padding-top:2px;	
                margin:0px;
                text-align:center;
                cursor:pointer;
            }
        </style>
        <div class="content" >
            <table align="left" border="0" width="100%" height="100%">
                <tr>
                    <td height="99%" colspan="2">
                        <table class="texto" width="100%" border="0" height="100%">
                            <tr>
                                <?php
                                if($mostarCaminhos == 0){
								?>
                                <td valign="top" height="100%">
                                    <div id="mapa" style="width: 100%; height:100%;  border:1px solid #666"></div>
                                </td>
                                <?php
                                }else{
								?>
                                <td width="1" valign="top" class="texto"  height="100%">
                                    <div id="rota" style="height:100%;  border:1px solid #666"></div>
                                </td>
                                <td valign="top" height="100%">
                                    <div id="mapa" style="width: 100%; height:100%;  border:1px solid #666"></div>
                                </td>
                                <?php
                                }
								?>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </div>
        <script>
            initialize();
        </script>
    </body>
</html>