<cfscript>
conn = CreateComponent("_transportes.consulta.cfc_manutencao");
qrOrdensServico = conn.get_ordens_servico_print( ORDEM_SERVICO_ID = vars.ORDEM_SERVICO_ID);
qrAtividades = conn.get_veiculo_atividade_os(ORDEM_SERVICO_ID = vars.ORDEM_SERVICO_ID);
</cfscript>
<cfdocument name="os_atividades" format="pdf">
<cfdocumentitem type="header">
	<style type="text/css">
		body {
			margin: 0;
			padding: 0;
		}
		.fonte {
			font-family: Verdana, Arial, Helvetica, sans-serif;
			font-stretch: condensed;
			font-size: 10px;
		}		
	</style>
	<table width="100%" border="0" cellpadding="0" cellspacing="0" class="fonte">
        <tr>
        	<td style="height: 3mm;"></td>
        </tr>
        <tr>
        	<td nowrap align="center">..: KMM Engenharia de Sistemas :..</td>
        </tr>
    </table>
</cfdocumentitem>
<style type="text/css">
	body {
		margin: 0;
		padding: 0;
	}
	.fonte {
		font-family: Verdana, Arial, Helvetica, sans-serif;
		font-size: 12px;
	}
	.titulo {
		font-family: Verdana, Arial, Helvetica, sans-serif;
		font-size: 16px;
	}
	.div_check {
		border: solid 1px ##000;
		width: 5px;
		height: 5px;
		margin-left: 15px;
	}
</style>
<body>
<cfoutput>
<table border="0" cellspacing="2" class="fonte">
    <tr>
      <td colspan="2" class="titulo"><b>Dados da Ordem de Servi&ccedil;o</b></td>
    </tr>
    <tr>
      <td colspan="2"></td>
    </tr>                
    <tr>
      <td><b>N&ordm; OS:</b></td>
      <td>#qrOrdensServico.NUM_ORDEM_SERVICO#</td>
    </tr>
    <tr>
      <td><b>Equipamento:</b></td>
      <td>#qrOrdensServico.COD_EQUIPAMENTO#&nbsp;-&nbsp;#qrOrdensServico.MATERIAL#</td>
    </tr>
    <tr>
      <td><b>Data de Abertura:</b></td>
      <td>#qrOrdensServico.DATA_ABERTURA#</td>
    </tr>
    <tr>
      <td><b>Oficina:</b></td>
      <td>#qrOrdensServico.OFICINA#</td>
    </tr>
    <tr>
      <td><b>Respons&aacute;vel:</b></td>
      <td>#qrOrdensServico.RESPONSAVEL#</td>
    </tr>
    <tr>
      <td colspan="2"></td>
    </tr>
    <tr>
      <td colspan="2"></td>
    </tr>     
</table>
</cfoutput>
<table border="0" cellspacing="2" class="fonte">
    <cfif qrAtividades.recordCount gt 0>
    <tr>
      <td colspan="2" class="titulo">Atividades</td>
    </tr>
    <cfelse>
    <tr>
      <td>N&atilde;o Existem Atividades para serem Executadas</td>
    </tr>
    </cfif>
    <cfoutput query="qrAtividades">
        <tr>
          <td valign="top"><div class="div_check" style="width:2mm; height:2mm;"></div></td>
          <td>&nbsp;&nbsp;#qrAtividades.TITULO#</td>
        </tr>
    </cfoutput>
</table>
<cfdocumentitem type="footer">
	<style type="text/css">
		body {
			margin: 0;
			padding: 0;
		}
		.fonte {
			font-family: Verdana, Arial, Helvetica, sans-serif;
			font-stretch: condensed;
			font-size: 10px;
		}
	</style>
	<table width="100%" border="0" cellpadding="0" cellspacing="0" class="fonte">
        <tr>
        	<td colspan="2" style="height: 3mm;"></td>
        </tr>
        <tr>
        	<td nowrap align="left">P&aacute;ginas: <cfoutput>#cfdocument.CurrentPageNumber# de #cfdocument.TotalPageCount#</cfoutput></td>
            <td nowrap align="right"><cfoutput>#session.usuario# - #DateFormat(Now(), 'dd/mm/yyyy') & " " & TimeFormat(Now(), 'HH:mm:ss')#</cfoutput></td>
        </tr>
    </table>
</cfdocumentitem>
</body>
</cfdocument>
<cfset path = ExpandPath("/temp")>
<cfpdf action="merge" destination="#path#/os_atividades_#DateFormat(Now(),"ddmmyyyyHHmmss")#.pdf" overwrite="yes">
	<cfpdfparam source="os_atividades">
</cfpdf>
<script>
  window.location = '/temp/os_atividades_<cfoutput>#DateFormat(Now(),"ddmmyyyyHHmmss")#</cfoutput>.pdf';
</script>