<html>
<cfscript>
	conn = CreateComponent("_transportes.consulta.cfc_manutencao");
	qrEspecialidade = conn.get_recurso_especialidade();
	qrNivel   = conn.get_recurso_nivel();
	qrEspecialidadeValor = conn.get_especialidade_valor(abertos = 1);
</cfscript>
<cfinclude template="/_scripts/scripts.cfm"/>
<cfinclude template="/_scripts/calendar.cfm">
<script language="javascript1.2"> 

	// Configura botoes // 
	parent.f_set_texto( 'titulo_aplicacao', '<cf_language>Controle de Manuten&ccedil;&atilde;o</cf_language>' );
	parent.f_set_texto( 'titulo_pagina', '<cf_language>Valores para especialidades</cf_language>' );
	
	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); } 

	parent.f_hidden('btn_incluir');
	parent.f_hidden('btn_excluir');
	parent.f_hidden('btn_editar');
	parent.f_hidden('btn_cancelar');
	
	// -------------------- // 		
	function f_confirmar() {
		with(document.forms[0]) {
			target = 'consultas';
			action = 'confirma.cfm';	
			if (f_verifica_form(document.forms[0])) {
					submit();
			}
		}
		return false;
	}
	parent.f_confirmar = f_confirmar;
	
	function f_busca_historico() {
		with(document.forms[0]) {
			p_url = '/_transportes/consulta/cfc_manutencao.cfc?method=get_especialidade_valor';
			p_arguments = 'ESPECIALIDADE_ID='+ESPECIALIDADE_ID.value+'&NIVEL_ID='+NIVEL_ID.value;
			f_query_wddx(p_url, p_arguments, f_busca_historico_result);
		}
	}
	function f_limpa_tabela() {
		tbody = document.getElementById("tb_historico");
		while(tbody.rows.length > 0) {
			tbody.deleteRow(0);
		}
	}	

	function f_busca_historico_result(obj){ //callback functions always take one argument. This is the result passed back from the server.
		tbody = document.getElementById("tbl_historico").getElementsByTagName("TBODY")[0];
		f_limpa_tabela();
		if(obj.ajax.readyState == 4) { // Quando estiver tudo pronto.
			with(document.forms[0]) {
				for(i=0;i<obj.struct.controle_id.length;i++) {
					// cria a linha
					v_tr = document.createElement('tr');
					v_tr.className = 'linha_'+(i%2+1);
						
					// cria as colunas
					v_td = document.createElement('td');
					v_td.innerHTML = obj.struct.especialidade_nome[i]; 
					v_tr.appendChild(v_td);
					
					v_td = document.createElement('td');
					v_td.innerHTML = obj.struct.nivel_nome[i]; 
					v_tr.appendChild(v_td);
					
					v_td = document.createElement('td');
					v_td.innerHTML = obj.struct.data_inicio_char[i]; 
					v_tr.appendChild(v_td);
					
					v_td = document.createElement('td');
					v_td.innerHTML = obj.struct.data_fim_char[i];
					v_tr.appendChild(v_td);
					
					v_td = document.createElement('td');
					v_td.innerHTML = toCurrency(obj.struct.valor_empresa[i]);
					v_td.style.textAlign = 'right';
					v_tr.appendChild(v_td);
	
					v_td = document.createElement('td');
					v_td.innerHTML = toCurrency(obj.struct.valor_terceiro[i]);
					v_td.style.textAlign = 'right';
					v_tr.appendChild(v_td);
	
					// adiciona linha ao tbody
					tbody.appendChild(v_tr);
				}	
			}	
		}
	}
</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />

<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body class="background" style="height:100%">
<table width="100%" border="0" cellpadding="3" cellspacing="0">
   <form id="form_transportes" name="form_transportes" method="post" action="" onSubmit="return f_confirmar()">
      <input name="OPERACAO" type="hidden" value="">
      <input name="CONSULTA" type="hidden" value="">
      <input name="CONTROLE_ID" type="hidden" value="">
	  <input name="CONTROLE_SEL" type="hidden" value="">
      <tr>
        <td width="1%" class="texto">Especialidade:</td>
        <td><select name="ESPECIALIDADE_ID" id="ESPECIALIDADE_ID" obrigatorio="1" display="ESPECIALIDADE" secao="ESPVALOR">
				<option value="">-- Selecione --</option>
				<cfoutput query="qrEspecialidade">
				 <option value="#qrEspecialidade.ESPECIALIDADE_ID#">#qrEspecialidade.DESCRICAO#</option>
				</cfoutput>
			</select>
        </td>
      </tr>
      <tr>
        <td class="texto">N&iacute;vel:</td>
        <td><select name="NIVEL_ID" id="NIVEL_ID" obrigatorio="1" display="N&Iacute;VEL" secao="ESPVALOR"> 
			<option value="">-- Selecione --</option>
			 <cfoutput query="qrNivel">
			  <option value="#qrNivel.NIVEL_ID#">#qrNivel.DESCRICAO#</option>
			 </cfoutput>
            </select>
        </td>
      </tr>
	  <tr>
        <td class="texto"><nobr>Valor funcion&aacute;rio da empresa:</nobr></td>
        <td class="texto">
		<input name="VALOR_EMPRESA" type="text" id="VALOR_EMPRESA" size="20" obrigatorio="1" display="VALOR PARA FUNCION&Aacute;RIO DA EMPRESA" onKeyPress="return f_formata_numero_decimal(this)" secao="ESPVALOR">&nbsp;(hora)
        </td>
      </tr>
	  <tr>
        <td class="texto"><nobr>Valor funcion&aacute;rio terceiro:</nobr></td>
        <td class="texto">
		<input name="VALOR_TERCEIRO" type="text" id="VALOR_TERCEIRO" size="20" obrigatorio="1" display="VALOR PARA FUNCION&Aacute;RIO TERCEIRO" onKeyPress="return f_formata_numero_decimal(this)" secao="ESPVALOR">&nbsp;(hora)
        </td>
      </tr>
	  <tr>
        <td class="texto">Data inicial:</td>
        <td><input name="DATA_INICIO" type="text" id="DATA_INICIO" style="width: 80px" onKeyPress="return f_formata(this,event,'00/00/0000')" obrigatorio="1" display="DATA INICIAL" secao="ESPVALOR">
		<button id="btn_data_inicio" type="button" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="" width="16" height="16" align="absmiddle"></button>
		</td>
      </tr>
	  <tr>
        <td class="texto">Data final:</td>
        <td><input name="DATA_FIM" type="text" id="DATA_FIM" style="width: 80px" onKeyPress="return f_formata(this,event,'00/00/0000')" secao="ESPVALOR">
		<button id="btn_data_fim" type="button" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="" width="16" height="16" align="absmiddle"></button>
		</td>
      </tr>
	  <tr>
        <td colspan="2" valign="top">
		  <cfset lista_id = 'ESPVALOR'>
		  <cfset lista_campos = 'CONTROLE_ID,ESPECIALIDADE_ID,NIVEL_ID,VALOR_EMPRESA,VALOR_TERCEIRO,DATA_INICIO,DATA_FIM'>
		  <cfset lista_titulos = 'Especialidade,Nvel,Valor funcion&aacute;rio empresa (hora),Valor funcion&aacute;rio terceiro (hora),Data inicial,Data final'>
		  <cfset lista_titulos_campos = "'+ESPECIALIDADE_ID.options[ESPECIALIDADE_ID.selectedIndex].text+','+NIVEL_ID.options[NIVEL_ID.selectedIndex].text+',VALOR_EMPRESA,VALOR_TERCEIRO,DATA_INICIO,DATA_FIM">
		  <cfset lista_titulos_tamanho = '200,30,230,230,80,80'>
		  <cfset lista_campo_id = 'CONTROLE_ID'>
		  <cfset lista_default = 0>
		  <cfset lista_height = '250'>
		  <cfset lista_width = '100%'>
		  <cfinclude template="/_include/lista.cfm">
		  
		  <script language="javascript1.2">
		  function f_on_seleciona_ESPVALOR() {
			with(document.forms[0]) {
				v_lista = f_listagem_ESPVALOR();
				document.getElementById('tr_historico').style.display = 'none';
				if (v_lista[lista_selected_ESPVALOR.value].CONTROLE_ID == "") {
					return false;
				}
				else {
					ESPECIALIDADE_ID.disabled = 'disabled';
					NIVEL_ID.disabled = 'disabled';
					VALOR_EMPRESA.disabled = 'disabled';
					VALOR_TERCEIRO.disabled = 'disabled';
					DATA_INICIO.disabled = 'disabled';
					DATA_FIM.focus();
			
					document.getElementById('tr_historico').style.display = 'block';
					CONTROLE_SEL.value = v_lista[lista_selected_ESPVALOR.value].CONTROLE_ID;
					f_busca_historico();
				}
			 }
		  }	
		
		function f_on_salva_lista_ESPVALOR() {
		  	with(document.forms[0]) {
				ESPECIALIDADE_ID.disabled = 'disabled';
				NIVEL_ID.disabled = 'disabled';
				VALOR_EMPRESA.disabled = 'disabled';
				VALOR_TERCEIRO.disabled = 'disabled';
				DATA_INICIO.disabled = 'disabled';	
			}
		}
		
		function f_on_incluir_ESPVALOR() {
		  	with(document.forms[0]) {
				ESPECIALIDADE_ID.disabled = '';
				NIVEL_ID.disabled = '';
				VALOR_EMPRESA.disabled = '';
				VALOR_TERCEIRO.disabled = '';
				DATA_INICIO.disabled = '';
				
				document.getElementById('tr_historico').style.display = 'none';
			}
		}
		</script>
		</td>
      </tr>
	  <tr id="tr_historico" style="display:none">
	  <td colspan="2">
	  		<fieldset>
			<legend>Hist&oacute;rico de pre&ccedil;os</legend>
		   <table width="100%" border="0" cellpadding="3" cellspacing="1" class="texto" id="tbl_historico">
			 <tr>
				<td width="35%" nowrap class="titulo_3">Especialidade</td>
				<td width="5%" nowrap class="titulo_3">N&iacute;vel</td>
				<td width="15%" nowrap class="titulo_3">Data inicial</td>
				<td width="15%" nowrap class="titulo_3">Data final</td>
				<td width="15%" align="right" nowrap class="titulo_3">Valor funcion&aacute;rio empresa (hora)</td>
				<td width="15%" align="right" nowrap class="titulo_3">Valor funcion&aacute;rio terceiro (hora)</td>
			 </tr>
			 <tbody id="tb_historico">
			 </tbody>
		</table>
		</fieldset>
   </td>
   </tr>
   </form>
</table>
</body>
</html>
<iframe name="consultas" frameborder="0" width="100%" height="400" src="" style="display: none"></iframe>
<cfset requestEnd = 0>
<script language="javascript1.2">
   f_controla_campos( document.forms.length );
   f_incluir();
   with(document.forms[0]) {
	   <cfoutput query="qrEspecialidadeValor">
			f_incluir_ESPVALOR();
			CONTROLE_ID.value      = '#qrEspecialidadeValor.CONTROLE_ID#';
			ESPECIALIDADE_ID.value = '#qrEspecialidadeValor.ESPECIALIDADE_ID#';
			NIVEL_ID.value         = '#qrEspecialidadeValor.NIVEL_ID#';
			VALOR_EMPRESA.value    = '#qrEspecialidadeValor.VALOR_EMPRESA#';
			VALOR_TERCEIRO.value   = '#qrEspecialidadeValor.VALOR_TERCEIRO#';
			DATA_INICIO.value      = '#qrEspecialidadeValor.DATA_INICIO_CHAR#';
			DATA_FIM.value         = '#qrEspecialidadeValor.DATA_FIM_CHAR#';
			f_salvar_ESPVALOR();
	   </cfoutput>
   }

  Calendar.setup(
    {
      inputField  : "DATA_INICIO",      // ID of the input field
      ifFormat    : "%d/%m/%Y",    // the date format
      button      : "btn_data_inicio",    // ID of the button
	  range       : [2001,2050]
    }
  );
  
  Calendar.setup(
    {
      inputField  : "DATA_FIM",      // ID of the input field
      ifFormat    : "%d/%m/%Y",    // the date format
      button      : "btn_data_fim",    // ID of the button
	  range       : [2001,2050]
    }
  );
</script>