<script type="text/javascript" src="/_scripts/scripts_db.js"></script>
<cfswitch expression="#vars.CONSULTA#">
	<cfcase value="1">
        <chart bgColor='FFFFFF' showBorder='0' chartTopMargin='40' chartBottomMargin='15' gaugeStartAngle='180' gaugeEndAngle='0' gaugeFillMix='{dark-10},FFFFFF,{dark-10}' gaugeFillRatio='3' palette='1' lowerLimit='0' upperLimit='100' showValue='1' numberSuffix='%' formatNumberScale='0' thousandSeparator='.' decimalSeparator=','>
            <annotations>
                <annotationGroup id='group_titulo'>
                    <annotation type='text' x='250' y='25' font='Verdana' fontSize='10' bold='1' align='center' color='4A4A4A' label='Faturamento x Pneus' />
                </annotationGroup>
            </annotations>
            <colorRange>
                <color minValue='0' maxValue='<cfoutput>#vars.FAIXA_VERDE#</cfoutput>' code='8BBA00' />
                <color minValue='<cfoutput>#vars.FAIXA_VERDE#</cfoutput>' maxValue='<cfoutput>#vars.FAIXA_AMARELA#</cfoutput>' code='F6BD0F' />
                <color minValue='<cfoutput>#vars.FAIXA_AMARELA#</cfoutput>' maxValue='100' code='FF654F' />
            </colorRange>
            <trendpoints>
                <point displayValue='Meta' value='<cfoutput>#vars.META#</cfoutput>' valueInside='1' dashed='1' dashLen='1' color='999999' thickness='2' />
            </trendpoints>
            <dials>
                <dial rearExtension='10' value='<cfoutput>#vars.PERCENTUAL#</cfoutput>' />
            </dials>
        </chart>
	</cfcase>
    
    <cfcase value="2">
    	<chart bgColor='FFFFFF' showBorder='0' chartTopMargin='40' lowerLimit='0' upperLimit='<cfoutput>#vars.FAIXA_VERMELHA#</cfoutput>' gaugeRoundRadius='5' pointerOnTop='1' pointerRadius='10' formatNumberScale='0' thousandSeparator='.' decimalSeparator=',' forceDecimals='1' decimals='2'>
        	<annotations>
                <annotationGroup id='group_titulo'>
                    <annotation type='text' x='210' y='25' font='Verdana' fontSize='10' bold='1' align='center' color='4A4A4A' label='Custo por KM' />
                </annotationGroup>
            </annotations>
        	<colorRange>
                <color minValue='0' maxValue='<cfoutput>#vars.FAIXA_VERDE#</cfoutput>' code='8BBA00' />
                <color minValue='<cfoutput>#vars.FAIXA_VERDE#</cfoutput>' maxValue='<cfoutput>#vars.FAIXA_AMARELA#</cfoutput>' code='F6BD0F' />
                <color minValue='<cfoutput>#vars.FAIXA_AMARELA#</cfoutput>' maxValue='<cfoutput>#vars.FAIXA_VERMELHA#</cfoutput>' code='FF654F' />
            </colorRange>
            <trendpoints>
                <point displayValue='Meta' value='<cfoutput>#vars.META#</cfoutput>' dashed='1' dashLen='1' color='FFFFFF' thickness='2' />
            </trendpoints>
            <value><cfoutput>#vars.VALOR#</cfoutput></value>
            <styles>
                <definition>
                	<style name='bgValue' type='Font' font='Verdana' size='10' bgColor='333333' color='FFFFFF' />
                </definition>
				<application>
					<apply toObject='VALUE' styles='bgValue'/>
				</application>
            </styles>
        </chart>
    </cfcase>
	
	<cfcase value="3">
    	<cfscript>
			conn = CreateComponent("_transportes.consulta.gerencial.cfc_manutencao");
			qrEstoquePneus = conn.get_estoque_pneus(argumentCollection = vars);
		</cfscript>
        <chart bgColor='FFFFFF' chartRightMargin='30' caption='Estoque de Pneus' yAxisName='Quantidade' legendBorderAlpha='0' palette='1' useRoundEdges='1' divLineIsDashed='1' divLineDashLen='1' divLineDashGap='2' divLineColor='999999' divLineAlpha='80' formatNumberScale='0' thousandSeparator='.' decimalSeparator=','>
            <categories>
                <cfoutput query="qrEstoquePneus">
                	<category label='#qrEstoquePneus.CENTRO_CUSTO#' />
                </cfoutput>
            </categories>
            
            <dataset seriesName='Estoque' color='8EAC41'>
                <cfoutput query="qrEstoquePneus">
                    <set value='#qrEstoquePneus.QTDE_ESTOQUE#' />
                </cfoutput>
            </dataset>
            
            <dataset seriesName='Usados' color='FF0000'>
                <cfoutput query="qrEstoquePneus">
                    <set value='#qrEstoquePneus.QTDE_USADOS#' />
                </cfoutput>
            </dataset>
        </chart>
	</cfcase>
    
    <cfdefaultcase>
		<script defer="defer">
	    	alert('Operao no programada.');
	 	</script>
  	</cfdefaultcase>
</cfswitch>