<script type="text/javascript" src="/_scripts/scripts_db.js"></script>
<cfswitch expression="#vars.CONSULTA#"> 
	<cfcase value="1">
    	<cfscript>
			conn = CreateComponent("_transportes.consulta.gerencial.cfc_manutencao");
			qrMaiorDataOrdensServico = conn.get_maior_data_ordens_servico(argumentCollection = vars);
			qrMesesOrdensServico	 = conn.get_meses_ordens_servico(data_inicio=qrMaiorDataOrdensServico.DATA_INICIO, data_termino = qrMaiorDataOrdensServico.DATA_PREVISAO);
			qrPeriodoOrdensServico	 = conn.get_periodo_ordens_servico(data_inicio=qrMaiorDataOrdensServico.DATA_INICIO, data_termino = qrMaiorDataOrdensServico.DATA_PREVISAO);
			qrOrdensServico	      	 = conn.get_ordens_servico(argumentCollection = vars);
		</cfscript>
        <chart dateFormat='dd/mm/yyyy' outputDateFormat='dd/mm/yyyy hh:mn' showFullDataTable='1' ganttWidthPercent='72' canvasBorderColor='999999' canvasBorderThickness='0' gridBorderColor='4567aa' gridBorderAlpha='20' ganttPaneDuration='31' ganttPaneDurationUnit='d' legendBorderAlpha='0'>
            <categories bgColor='CCCCCC'>
                <category start='<cfoutput>#qrMesesOrdensServico.DATA_INICIO#</cfoutput> 00:00' end='<cfoutput>#qrMesesOrdensServico["DATA_TERMINO"][qrMesesOrdensServico.RecordCount]#</cfoutput> 23:59' label='Ordens de Servico (Abertas)'  fontColor='ffffff' fontSize='16' />
            </categories>
            <categories  bgColor='CCCCCC' fontColor='ff0000'>
            	<cfoutput query="qrMesesOrdensServico">
                	<category start='#qrMesesOrdensServico.DATA_INICIO# 00:00' end='#qrMesesOrdensServico.DATA_TERMINO# 23:59' label='#qrMesesOrdensServico.MES#'  alpha='' font='Verdana' fontColor='ffffff' fontSize='16' />
                </cfoutput>
            </categories>
			<categories bgColor='FFFFFF' font='Verdana' fontSize='11' isBold='1' align='center' fontColor='666666'>
            	<cfoutput query="qrPeriodoOrdensServico">
                	<category start='#qrPeriodoOrdensServico.DATA# 00:00' end='#qrPeriodoOrdensServico.DATA# 23:59' label='#qrPeriodoOrdensServico.DIA#' />
                </cfoutput>
            </categories>
            <processes headerText='Frotas' fontColor='000000' fontSize='14' isAnimated='1' bgColor='CCCCCC'  headerVAlign='bottom' headerAlign='left' headerbgColor='CCCCCC' headerFontColor='ffffff' headerFontSize='12'  align='left' isBold='1' bgAlpha='25'>
            	<cfoutput query="qrOrdensServico">
                	<process label='#qrOrdensServico.COD_VEICULO#' id='#qrOrdensServico.CurrentRow#' />
                </cfoutput>
            </processes>
            <dataTable showProcessName='1' nameAlign='left' fontColor='000000' fontSize='14' vAlign='right' align='center' headerVAlign='bottom' headerAlign='left' headerbgColor='CCCCCC' headerFontColor='ffffff' headerFontSize='12' >
                <dataColumn bgColor='eeeeee' headerText='Abertura' >
                	<cfoutput query="qrOrdensServico">
                        <text label='#LSDateFormat(qrOrdensServico.DATA_ABERTURA, "dd/mm")# #LSTimeFormat(qrOrdensServico.DATA_ABERTURA, "HH:mm")#' />
                    </cfoutput>
                </dataColumn>
                <dataColumn bgColor='eeeeee' headerText='Fechamento'>
                	<cfoutput query="qrOrdensServico">
                        <text label='<cfif Len(Trim(qrOrdensServico.DATA_PREVISAO))>#LSDateFormat(qrOrdensServico.DATA_PREVISAO, "dd/mm")# #LSTimeFormat(qrOrdensServico.DATA_PREVISAO, "HH:mm")#<cfelse>Sem Previso</cfif>' />
                    </cfoutput>
                </dataColumn>
                <dataColumn bgColor='eeeeee' headerText='Tipo' headerAlign='center'>
                	<cfoutput query="qrOrdensServico">
                        <text label='#qrOrdensServico.TIPO#' />
                    </cfoutput>
                </dataColumn>
            </dataTable>
            <tasks showEndDate='0'> 
            	<cfoutput query="qrOrdensServico">
                	<task showLabel='0' label='#qrOrdensServico.OFICINA#<cfif Len(Trim(qrOrdensServico.PRIMEIRA_PREVISAO))>(1#chr(170)# Prev.: #LSDateFormat(qrOrdensServico.PRIMEIRA_PREVISAO,'dd/mm')# #LSTimeFormat(qrOrdensServico.PRIMEIRA_PREVISAO,'HH:MM')# )</cfif>' processId='#qrOrdensServico.CurrentRow#' start='#qrOrdensServico.DATA_ABERTURA#' end='<cfif Len(Trim(qrOrdensServico.DATA_PREVISAO))>#qrOrdensServico.DATA_PREVISAO#<cfelse>#qrOrdensServico.DATA_ATUAL#</cfif>' color='4567aa' alpha='100'  height='32%' topPadding='12%' percentComplete='<cfif not Len(Trim(qrOrdensServico.DATA_PREVISAO))>0<cfelse>#qrOrdensServico.PERCENTUAL#</cfif>' />
                </cfoutput>
            </tasks>
            <cfif ListFind(ValueList(qrPeriodoOrdensServico.DATA), LSDateFormat(Now(), 'dd/mm/yyyy'))>
                <trendlines>
                    <line start='<cfoutput>#LSDateFormat(Now(), "dd/mm/yyyy")# #LSTimeFormat(Now(), "HH:MM:SS")#</cfoutput>' displayValue='Hoje' color='333333' thickness='2' dashed='1' />
                </trendlines>
            </cfif>
            <legend>
                <item label='Planejado' color='4567AA' />
                <item label='Atraso/Sem Previso' color='FF5E5E' />
            </legend>

			<styles> 
				<definition>
					<style name='myCaptionFont' type='font' font='Verdana' size='14' color='000000' bold='1' underline='0'></style>
					<style name='tasks' type='font' font='Verdana' size='11' color='000000' bold='0' underline='0'></style>
				</definition>
				<application>
					<apply toObject='LEGEND' styles='myCaptionFont' />
					<apply toObject='TASKLABELS' styles='tasks' />
				</application>
			</styles>               
		</chart>
	</cfcase>
	
	<cfcase value="2">
		<chart bgColor='FFFFFF' showBorder='0' chartTopMargin='40' lowerLimit='0' upperLimit='<cfoutput>#vars.QTDE_VEICULOS#</cfoutput>' gaugeRoundRadius='5' pointerOnTop='1' pointerRadius='10' numberSuffix='' formatNumberScale='0' thousandSeparator='.' decimalSeparator=','>
        	<annotations>
                <annotationGroup id='group_titulo' type="text">
                    <annotation type='text' x='210' y='25' font='Verdana' fontSize='17' bold='1' align='center' color='000000' label='<cfoutput>#vars.TITULO#</cfoutput> em manuteno' />
                    <annotation type='text' x='210' y='40' font='Verdana' fontSize='10' bold='0' align='center' color='000000' label='* Veculos vinculados aos GRUPOS de controle' />
                </annotationGroup>
            </annotations>
        	<colorRange>
                <color minValue='0' maxValue='<cfoutput>#vars.FAIXA_VERDE#</cfoutput>' code='8BBA00' />
                <color minValue='<cfoutput>#vars.FAIXA_VERDE#</cfoutput>' maxValue='<cfoutput>#vars.FAIXA_AMARELA#</cfoutput>' code='F6BD0F' />
                <color minValue='<cfoutput>#vars.FAIXA_AMARELA#</cfoutput>' maxValue='<cfoutput>#vars.QTDE_VEICULOS#</cfoutput>' code='FF654F' />
            </colorRange>
            <value><cfoutput>#vars.QTDE_EM_MANUTENCAO#</cfoutput></value>
            <styles>
                <definition>
                	<style name='bgValue' type='Font' font='Arial' size='22' bgColor='FFFFFF' color='000000' ></style>
                </definition>
				<application>
					<apply toObject='VALUE' styles='bgValue'/>
				</application>
            </styles>
        </chart>
	</cfcase>

	<cfcase value="3">
		<cfscript>
			conn = CreateComponent("_transportes.consulta.gerencial.cfc_manutencao");
			qrTiposOrdemServico = conn.get_tipos_ordem_servico(argumentCollection = vars);
		</cfscript>
		<chart bgColor='FFFFFF' showBorder='0' caption='Ordens de Servio Abertas' xAxisName='Tipos' yAxisName='Quantidade' palette='1' useRoundEdges='1' formatNumberScale='0' thousandSeparator='.' decimalSeparator=','>
        	<cfoutput query="qrTiposOrdemServico">
            	<set label='#qrTiposOrdemServico.TIPO_ORDEM_SERVICO#' value='#qrTiposOrdemServico.QTDE_TIPO#' />
            </cfoutput>
			<styles>
				<definition>
					<style name='myCaptionFont' type='font' font='Verdana' size='18' color='000000' bold='1' underline='0'></style>
					<style name='mySubCaptionFont' type='font' font='Verdana' size='13' color='000000' bold='1' ></style>
					<style name='myAxisTitlesFont' type='font' font='Verdana' size='14' bold='1' color='000000'></style>
				</definition>
				<application>
					<apply toObject='Caption' styles='myCaptionFont' />
					<apply toObject='DATAVALUES' styles='mySubCaptionFont' />
					<apply toObject='DATALABELS' styles='mySubCaptionFont' />						
					<apply toObject='XAxisName' styles='myAxisTitlesFont' />
					<apply toObject='YAxisName' styles='myAxisTitlesFont' />
				</application>
			</styles>			
        </chart>
	</cfcase>
    
    <cfdefaultcase>
		<script defer="defer">
	    	alert('Operao no programada.');
	 	</script>
  	</cfdefaultcase>
</cfswitch>