<script type="text/javascript" src="/_scripts/scripts_db.js"></script>
<cfswitch expression="#vars.CONSULTA#">
	<cfcase value="0">
    	<cfscript>
			conn = CreateComponent("_transportes.consulta.gerencial.cfc_manutencao");
			qrOrcadoRealizadoAcum = conn.get_orcado_realizado_pedidos(argumentCollection = vars);
	    	qrSaldos 			  = conn.get_orcado_realizado_pedidos_saldos(argumentCollection = vars);
		</cfscript>
        <chart bgColor='FFFFFF' rotateValues='1' showBorder='0' caption='Orado x Realizado x Pedidos Executados' legendBorderAlpha='0' palette='1' useRoundEdges='1' showValues='0' numberPrefix='R$ ' formatNumberScale='0' thousandSeparator='.' decimalSeparator=',' forceDecimals='1' decimals='2'>
            <dataset seriesName='Orado' renderAs='AREA'>
                <set value='' />
                <cfoutput query="qrOrcadoRealizadoAcum">
                    <set value='#qrOrcadoRealizadoAcum.VALOR_ORCADO#' />
                </cfoutput>
                <set value='' />
            </dataset>

			<categories>
               	<category label='Saldo'/>
                <cfoutput query="qrOrcadoRealizadoAcum">
                	<category label='#qrOrcadoRealizadoAcum.DIA#' />
                </cfoutput>
               	<category label='Previso' />
            </categories>

            <dataset seriesName='Saldo/Previso' renderAs='BAR'>
                <set toolText='Saldo em aberto meses anteriores: R$ <cfoutput>#LSNumberFormat(qrSaldos.SALDO_ANTERIOR,',.__')#</cfoutput>' value='<cfoutput>#qrSaldos.SALDO_ANTERIOR#</cfoutput>' showValue='1'/>
                <cfloop from="1" to="#qrOrcadoRealizadoAcum.RecordCount#" index="i">
                		<set value='0' />
                </cfloop>
                <set toolText='Saldo em aberto meses posteriores: R$ <cfoutput>#LSNumberFormat(qrSaldos.SALDO_SUPERIOR,',.__')#</cfoutput>' value='<cfoutput>#qrSaldos.SALDO_SUPERIOR#</cfoutput>' showValue='1'/>
            </dataset>
            
            <dataset seriesName='Acumulado(Entrada)' renderAs='LINE'>
                <set value='' />
                <cfoutput query="qrOrcadoRealizadoAcum">
                    <set value='#qrOrcadoRealizadoAcum.valor_nf_acumulado#' />
                </cfoutput>
                <set value='' />
            </dataset>

            <dataset seriesName='Pedido Executado' renderAs='LINE'>
                <set value='' />
                <cfoutput query="qrOrcadoRealizadoAcum">
                    <set value='#qrOrcadoRealizadoAcum.valor_pedido_executado#' />
                </cfoutput>
                <set value='' />
            </dataset>

            <dataset seriesName='CUSTO PROJETADO' renderAs='LINE' lineThickness='4'>
                <set value='' />
                <cfoutput query="qrOrcadoRealizadoAcum">
                    <set value='#qrOrcadoRealizadoAcum.valor_pedido_executado + qrOrcadoRealizadoAcum.valor_nf_acumulado#' />
                </cfoutput>
                <set value='' />
            </dataset>

			<styles>
				<definition>
					<style name='myCaptionFont' type='font' font='Verdana' size='18' color='000000' bold='1' underline='0'></style>
					<style name='legend' type='font' font='Verdana' size='14' color='000000' bold='1' underline='0'></style>
					<style name='Valores' type='font' font='Verdana' size='14' color='000000' bold='1' underline='0'></style>
				</definition>
				<application>
					<apply toObject='DataValues' styles='Valores' />
					<apply toObject='Legend' styles='legend' />
					<apply toObject='Caption' styles='myCaptionFont' />
				</application>
			</styles>              
		</chart>
	</cfcase>
	
	<cfcase value="1">
    	<cfscript>
			conn = CreateComponent("_transportes.consulta.gerencial.cfc_manutencao");
			qrOrcadoRealizadoAcum = conn.get_orcado_realizado_acumulado(argumentCollection = vars);
		</cfscript>
        <chart bgColor='FFFFFF' showBorder='0' caption='Orado x Realizado' legendBorderAlpha='0' palette='1' useRoundEdges='1' showValues='0' numberPrefix='R$ ' formatNumberScale='0' thousandSeparator='.' decimalSeparator=',' forceDecimals='1' decimals='2'>
            <dataset seriesName='Orado' renderAs='AREA'>
                <cfoutput query="qrOrcadoRealizadoAcum">
                    <set value='#qrOrcadoRealizadoAcum.VALOR_ORCADO_ACUM#' />
                </cfoutput>
            </dataset>

			<categories>
                <cfoutput query="qrOrcadoRealizadoAcum">
                	<category label='#qrOrcadoRealizadoAcum.DIA#' />
                </cfoutput>
            </categories>
            
            <dataset seriesName='Acumulado(Entrada)' renderAs='LINE'>
                <cfoutput query="qrOrcadoRealizadoAcum">
                    <set value='#qrOrcadoRealizadoAcum.valor_realizado_entrada_acum#' />
                </cfoutput>
            </dataset>

            <dataset seriesName='Acumulado(Emisso)' renderAs='LINE'>
                <cfoutput query="qrOrcadoRealizadoAcum">
                    <set value='#qrOrcadoRealizadoAcum.valor_realizado_emissao_acum#' />
                </cfoutput>
            </dataset>

            <dataset seriesName='Aprovado (No utilizado)' renderAs='LINE'>
                <cfoutput query="qrOrcadoRealizadoAcum">
                    <set value='#qrOrcadoRealizadoAcum.valor_aprovado_acum#' />
                </cfoutput>
            </dataset>

            <dataset seriesName='Aprovado Total' renderAs='LINE'>
                <cfoutput query="qrOrcadoRealizadoAcum">
                    <set value='#qrOrcadoRealizadoAcum.valor_aprovado_total_acum#' />
                </cfoutput>
            </dataset>
            
            <dataset seriesName='Realizado Dia' renderAs='AREA'>
                <cfoutput query="qrOrcadoRealizadoAcum">
                    <set value='#qrOrcadoRealizadoAcum.valor_realizado_emissao#' />
                </cfoutput>
            </dataset>
			<styles>
				<definition>
					<style name='myCaptionFont' type='font' font='Verdana' size='18' color='000000' bold='1' underline='0'></style>
				</definition>
				<application>
					<apply toObject='Caption' styles='myCaptionFont' />
				</application>
			</styles>              
		</chart>
	</cfcase>
	
	<cfcase value="2">
    	<cfscript>
			conn = CreateComponent("_transportes.consulta.gerencial.cfc_manutencao");
			qrCustoPorArea = conn.get_custo_por_area(argumentCollection = vars);
		</cfscript>
		<chart bgColor='FFFFFF' showBorder='0'  labelDisplay="ROTATE" slantLabels="1" caption='Custo por rea' xAxisName='reas' yAxisName='Valores' palette='1' useRoundEdges='0' showValues='1' numberPrefix='R$ ' formatNumberScale='0' thousandSeparator='.' decimalSeparator=',' forceDecimals='1' decimals='2'>
        	<cfoutput query="qrCustoPorArea">
            	<set label='#qrCustoPorArea.AREA#' value='#qrCustoPorArea.VALOR#' />
            </cfoutput>
			<styles>
				<definition>
					<style name='myCaptionFont' type='font' font='Verdana' size='18' color='000000' bold='1' underline='0'></style>
					<style name='mySubCaptionFont' type='font' font='Verdana' size='13' color='000000' bold='1' ></style>
					<style name='myAxisTitlesFont' type='font' font='Verdana' size='14' bold='1' color='000000'></style>
				</definition>
				<application>
					<apply toObject='Caption' styles='myCaptionFont' />
					<apply toObject='DATAVALUES' styles='mySubCaptionFont' />
					<apply toObject='DATALABELS' styles='mySubCaptionFont' />						
					<apply toObject='XAxisName' styles='myAxisTitlesFont' />
					<apply toObject='YAxisName' styles='myAxisTitlesFont' />
				</application>
			</styles>            
        </chart>
	</cfcase>
	
	<cfcase value="3">
		<chart bgColor='FFFFFF' showBorder='0' chartTopMargin='40' chartBottomMargin='15' gaugeStartAngle='180' gaugeEndAngle='0' gaugeFillMix='{dark-10},FFFFFF,{dark-10}' gaugeFillRatio='3' palette='1' lowerLimit='0' upperLimit='100' showValue='1' numberSuffix='%' formatNumberScale='0' thousandSeparator='.' decimalSeparator=','>
            <annotations>
                <annotationGroup id='group_titulo'>
                    <annotation type='text' x='250' y='25' font='Verdana' fontSize='15' bold='1' align='center' color='000000' label='Faturamento x Custo' />
                </annotationGroup>
            </annotations>
            <colorRange>
                <color minValue='0' maxValue='<cfoutput>#vars.FAIXA_VERDE#</cfoutput>' code='8BBA00' />
                <color minValue='<cfoutput>#vars.FAIXA_VERDE#</cfoutput>' maxValue='<cfoutput>#vars.FAIXA_AMARELA#</cfoutput>' code='F6BD0F' />
                <color minValue='<cfoutput>#vars.FAIXA_AMARELA#</cfoutput>' maxValue='100' code='FF654F' />
            </colorRange>
            <trendpoints>
                <point displayValue='Meta' value='<cfoutput>#vars.META#</cfoutput>' valueInside='1' dashed='1' dashLen='1' color='999999' thickness='2' />
            </trendpoints>
            <dials>
                <dial rearExtension='10' value='<cfoutput>#vars.PERCENTUAL#</cfoutput>' />
            </dials>
			<styles>
				<definition>
					<style name='myFont' type='font' font='Arial' size='14' color='000000' bold='1' underline='0'/>
				</definition>
				<application>
					<apply toObject='TICKVALUES' styles='myFont' />
					<apply toObject='LIMITVALUES' styles='myFont' />
					<apply toObject='VALUE' styles='myFont' />			
				</application>
			</styles>			
        </chart>
	</cfcase>
    
    <cfcase value="4">
    	<chart bgColor='FFFFFF' showBorder='0' chartTopMargin='40' lowerLimit='0' upperLimit='<cfoutput>#vars.FAIXA_VERMELHA#</cfoutput>' gaugeRoundRadius='5' pointerOnTop='1' pointerRadius='10' formatNumberScale='0' thousandSeparator='.' decimalSeparator=',' forceDecimals='1' decimals='2'>
        	<annotations>
                <annotationGroup id='group_titulo'>
                    <annotation type='text' x='210' y='25' font='Verdana' fontSize='15' bold='1' align='center' color='000000' label='Custo por KM' />
                </annotationGroup>
            </annotations>
        	<colorRange>
                <color minValue='0' maxValue='<cfoutput>#vars.FAIXA_VERDE#</cfoutput>' code='8BBA00' />
                <color minValue='<cfoutput>#vars.FAIXA_VERDE#</cfoutput>' maxValue='<cfoutput>#vars.FAIXA_AMARELA#</cfoutput>' code='F6BD0F' />
                <color minValue='<cfoutput>#vars.FAIXA_AMARELA#</cfoutput>' maxValue='<cfoutput>#vars.FAIXA_VERMELHA#</cfoutput>' code='FF654F' />
            </colorRange>
            <trendpoints>
                <point displayValue='Meta' value='<cfoutput>#vars.META#</cfoutput>' dashed='1' dashLen='1' color='FFFFFF' thickness='2' />
            </trendpoints>
            <value><cfoutput>#vars.VALOR#</cfoutput></value>
			<styles>
				<definition>
					<style name='myFont' type='font' font='Arial' size='14' color='000000' bold='1' underline='0'/>
				</definition>
				<application>
					<apply toObject='TICKVALUES' styles='myFont' />
					<apply toObject='LIMITVALUES' styles='myFont' />
					<apply toObject='VALUE' styles='myFont' />			
				</application>
			</styles>	
        </chart>
    </cfcase>
    
    <cfdefaultcase>
		<script defer="defer">
	    	alert('Operao no programada.');
	 	</script>
  	</cfdefaultcase>
</cfswitch>