<cfscript>
	/* Abre Conexes */ 
	conn_func_consult   = CreateObject("component","_transportes.consulta.cfc_funcionario");
	conn_acerto_consult = CreateObject("component","_transportes.consulta.cfc_despesas_estrada");
	conn_adm_consult    = CreateObject("component","_transportes.consulta.cfc_administracao");
	
	// Busca saldo anterior
	qrSaldoAnterior = conn_acerto_consult.get_saldo_anterior_extrato(cod_funcionario = vars.COD_FUNCIONARIO,
																	 data_inicial 	 = vars.DATA_INICIAL);
	// Consulta todos os lanctos
	qrLanctos = conn_acerto_consult.get_lancamentos_extrato(cod_funcionario = vars.COD_FUNCIONARIO,
															data_inicial    = vars.DATA_INICIAL,
															data_final      = vars.DATA_FINAL);
	//Consulta Funcionario 
	qrFuncionario = conn_func_consult.get_dados_motorista(cod_funcionario = vars.COD_FUNCIONARIO);

	qrKM_limite = conn_func_consult.get_dados_veiculo_motorista(cod_funcionario = vars.COD_FUNCIONARIO);
	
	
	// Busca mural de recados
	qrResponsavel = conn_func_consult.get_responsavel(cod_pessoa = vars.cod_funcionario);

	qrMural = conn_adm_consult.get_mural_internet(tipo_recado_id = 1);
	
	if (qrResponsavel.RecordCount) 
		qrMuralGrupo = conn_adm_consult.get_mural_internet(cod_grupo = qrResponsavel.COD_GRUPO);

	// Busca recados para o motorista
	qrRecados = conn_acerto_consult.get_recados(abertas = 1, ativas = 1, cod_funcionario = vars.COD_FUNCIONARIO);

	qrUltimoAcidente = conn_func_consult.get_ultimo_acidente();

	qrPrejuizosPendentes = conn_func_consult.get_prejuizos_pendentes();
	
	conn_ccresultado_consult = CreateObject("component","_transportes.consulta.cfc_conta_resultado");
	qrSaldoAnteriorResultado = conn_ccresultado_consult.get_saldo_anterior_extrato(cod_funcionario = vars.COD_FUNCIONARIO,
																				   data_inicial    = vars.DATA_INICIAL);

	qrResultadoLanctos = conn_ccresultado_consult.get_lancamentos_extrato(cod_funcionario = vars.COD_FUNCIONARIO,
																		  data_inicial    = vars.DATA_INICIAL,
																		  data_final      = vars.DATA_FINAL);
	
	qrNota = conn_ccresultado_consult.get_rank_motorista(cod_funcionario = vars.COD_FUNCIONARIO);
	
	// Busca CNH Status
	qrCNHStatus = conn_func_consult.get_cnh_situacao(cod_funcionario = vars.COD_FUNCIONARIO);
</cfscript>
<cfset frete_por_tonelada = 'Mdia empresa{R$}: ' & DecimalFormat(qrMedias.MEDIA_EMPRESA) & ' Sua Mdia{R$}: ' &  DecimalFormat(qrMedias.MEDIA_MOTORISTA) & ' Percentual: ' & qrMedias.PERCENTUAL & '%' >
<cfoutput query="qrMuralGrupo">
	<cfif qrMuralGrupo.currentRow eq 1>
		<cfset recados_grupo = qrMuralGrupo.MENSAGEM>
	<cfelse>
		<cfset recados_grupo = recados_grupo & chr(10) & qrMuralGrupo.MENSAGEM>
	</cfif>
</cfoutput>
<cfreport template="extrato.cfr" format="PDF" >
	<cfreportparam name="CNH_MENSAGEM"  value="#qrCNHStatus.MENSAGEM#" />
	<cfreportparam name="ACIDENTE_MENSAGEM"  value="#qrUltimoAcidente.MENSAGEM#" />
	<cfreportparam name="FRETE_POR_TONELADA"  value="#frete_por_tonelada#" />
	<cfreportparam name="RECADOS_GRUPOS"  value="#recados_grupo#" />
</cfreport>