<cffunction access="private" name="fnc_confirma_pneus" returntype="struct">
	<cftransaction action="begin">
		<cfloop list="#arguments.LOCALIZACAO_ID#" index="id">
			<cfscript>
				conn = CreateComponent("_transportes.manipulacao.cfc_pneus");	
				ret = conn.confirma_transferencia_pneu(localizacao_id = id);
			</cfscript>
			<cfif ret.erro>
				<cftransaction action="rollback">
				<cfreturn ret>
			</cfif>
		</cfloop>
	</cftransaction>
	<cfreturn ret>
</cffunction>

<cffunction access="private" name="fnc_recusa_pneus" returntype="struct">
	<cftransaction action="begin">
		<cfloop list="#arguments.LOCALIZACAO_ID#" index="id">
			<cfscript>
				conn = CreateComponent("_transportes.manipulacao.cfc_pneus");	
				ret = conn.recusa_transferencia_pneu(localizacao_id = id,
														  pneu_id        = Evaluate('arguments.'&id),
														  motivo         = arguments.motivo);
			</cfscript>
			<cfif ret.erro>
				<cftransaction action="rollback">
				<cfreturn ret>
			</cfif>
		</cfloop>
	</cftransaction>
	<cfreturn ret>
</cffunction>
<cfscript>
if( IsDefined("vars.OPERACAO") and Len( Trim( vars.OPERACAO ) ) ) {
	conn = CreateComponent("_transportes.manipulacao.cfc_pneus");
	switch ( val( vars.operacao ) ) 
	{   	 
		case 2 : 
			set_manipulacao = fnc_confirma_pneus(argumentCollection = vars); 
			break;
		case 3 : 
			set_manipulacao = fnc_recusa_pneus(argumentCollection = vars); 
			break;
	}
	fnc_trata_erros(struct_erro = set_manipulacao);
}  
</cfscript>

<script language="javascript1.2">
	parent.window.location = 'principal.cfm';
</script>