<!-- Consulta Remetente e inclui os dados para carga -->
<cfif isDefined("vars.OPERACAO") and vars.OPERACAO EQ 1>
	<cfscript>
		conn_emissao_consult = CreateObject("component","_com.consulta.cfc_emissao_documentos");
		qrRemetente = conn_emissao_consult.get_pessoa(codigo = vars.REM_CNPJ);
	</cfscript>
	<cfif qrRemetente.RecordCount gt 0>
		<cfoutput>
			<script language="javascript1.2">
				with(top.conteudo.form_lote) {
					REM_RAZAO_SOCIAL.value = '#JSStringFormat(qrRemetente.RAZAO_SOCIAL)#';
					REM_COD_PESSOA.value = #qrRemetente.COD_PESSOA#;
					CARGA_CEP.value = '#qrRemetente.CEP#';
					CARGA_ENDERECO.value = '#JSStringFormat(qrRemetente.ENDERECO)#';
					CARGA_BAIRRO.value = '#JSStringFormat(qrRemetente.BAIRRO)#';
					CARGA_COMPLEMENTO.value = '#JSStringFormat(qrRemetente.COMPLEMENTO)#';
					CARGA_UF.value = '#JSStringFormat(qrRemetente.UF)#';
					CARGA_MUNICIPIO.value = '#JSStringFormat(qrRemetente.MUNICIPIO)#';
					COLETA_COD_UF.value = #qrRemetente.COD_UF#;
					COLETA_COD_MUNICIPIO.value = #qrRemetente.COD_MUNICIPIO#;
					COLETA_COD_DISTRITO.value = #qrRemetente.COD_DISTRITO#;
					COLETA_COD_DV.value = #qrRemetente.COD_DV#;
				}
			</script>
		</cfoutput>
	<cfelse>
			<script language="javascript1.2">
				with(top.conteudo.form_lote) 
					REM_RAZAO_SOCIAL.value = 'Remetente no encontrado.';
			</script>
	</cfif>
</cfif>
<!-- Consulta Destinatrio e inclui os dados para descarga -->
<cfif isDefined("vars.OPERACAO") and vars.OPERACAO EQ 2>
	<cfscript>
		conn_emissao_consult = CreateObject("component","_com.consulta.cfc_emissao_documentos");
		qrDestinatario = conn_emissao_consult.get_pessoa(codigo = vars.DEST_CNPJ);
		qrICMS = conn_emissao_consult.get_icms(produto_id      = vars.PRODUTO_ID,
											   cod_atividade   = vars.COD_ATIVIDADE,
											   uf_origem       = vars.UF_COLETA,
											   uf_destino      = qrDestinatario.UF,
											   tomador_servico = vars.UF_COLETA);
		
	</cfscript>
	<cfif qrDestinatario.RecordCount gt 0>
		<cfoutput>
			<script language="javascript1.2">
				with(top.conteudo.form_conhecimento) {
					DEST_RAZAO_SOCIAL.value = '#JSStringFormat(qrDestinatario.RAZAO_SOCIAL)#';
					DEST_COD_PESSOA.value = #qrDestinatario.COD_PESSOA#;
					DESCARGA_CEP.value = '#qrDestinatario.CEP#';
					DESCARGA_ENDERECO.value = '#JSStringFormat(qrDestinatario.ENDERECO)#';
					DESCARGA_BAIRRO.value = '#JSStringFormat(qrDestinatario.BAIRRO)#';
					DESCARGA_COMPLEMENTO.value = '#JSStringFormat(qrDestinatario.COMPLEMENTO)#';
					DESCARGA_UF.value = '#JSStringFormat(qrDestinatario.UF)#';
					DESCARGA_MUNICIPIO.value = '#JSStringFormat(qrDestinatario.MUNICIPIO)#';					
					ENTREGA.value = '#JSStringFormat(qrDestinatario.MUNICIPIO)#';
					UF_ENTREGA.value = '#qrDestinatario.UF#';
					ENTREGA_COD_UF.value = #qrDestinatario.COD_UF#;
					ENTREGA_COD_MUNICIPIO.value = #qrDestinatario.COD_MUNICIPIO#;
					ENTREGA_COD_DISTRITO.value = #qrDestinatario.COD_DISTRITO#;
					ENTREGA_COD_DV.value = #qrDestinatario.COD_DV#;					
					// IBGE
					DEST_COD_UF.value = #qrDestinatario.COD_UF#;
					DEST_COD_MUNICIPIO.value = #qrDestinatario.COD_MUNICIPIO#;
					DEST_COD_DISTRITO.value = #qrDestinatario.COD_DISTRITO#;
					DEST_COD_DV.value = #qrDestinatario.COD_DV#;					
					// ICMS
					ALIQUOTA_ICMS.value = #qrICMS.aliquota_icms#;
					ST_ORIGEM_ID.value = '#qrICMS.st_icms_id#';					
					top.conteudo.v_calc_aliquota_icms = #qrICMS.aliquota_icms#;
				}
			</script>
		</cfoutput>
	<cfelse>
			<script language="javascript1.2">
				with(top.conteudo.form_lote) {
					DEST_RAZAO_SOCIAL.value = 'Destinatrio no encontrado.';
			</script>
	</cfif>
</cfif>
<!-- Consulta CEP - para CARGA -->
<cfif isDefined("vars.OPERACAO") and vars.OPERACAO EQ 3>
	<cfscript>
		conn_pessoas_consult = CreateObject("component","_com.consulta.cfc_pessoas");
		qrCarga = conn_pessoas_consult.getEndereco(cep = vars.CARGA_CEP);
	</cfscript>
	<cfif qrCarga.RecordCount gt 0>
		<cfoutput>
			<script language="javascript1.2">
				with(top.conteudo.form_lote) {
					CARGA_CEP.value = '#qrCarga.CEP#';
					CARGA_ENDERECO.value = '#JSStringFormat(qrCarga.LOGRADOURO)#';
					CARGA_BAIRRO.value = '#JSStringFormat(qrCarga.BAIRRO)#';
					CARGA_COMPLEMENTO.value = '';
					CARGA_UF.value = '#JSStringFormat(qrCarga.UF)#';
					CARGA_MUNICIPIO.value = '#JSStringFormat(qrCarga.LOCAL)#';
					COLETA_COD_UF.value = #qrCarga.COD_UF#;
					COLETA_COD_MUNICIPIO.value = #qrCarga.COD_MUNICIPIO#;
					COLETA_COD_DISTRITO.value = #qrCarga.COD_DISTRITO#;
					COLETA_COD_DV.value = #qrCarga.COD_DV#;
				}
			</script>
		</cfoutput>
	</cfif>
</cfif>

<!-- Consulta CEP - para DESCARGA -->
<cfif isDefined("vars.OPERACAO") and vars.OPERACAO EQ 4>
	<cfscript>
		conn_pessoas_consult = CreateObject("component","_com.consulta.cfc_pessoas");
		qrDescarga = conn_pessoas_consult.getEndereco(cep = vars.DESCARGA_CEP);
	</cfscript>
	<cfif qrDescarga.RecordCount gt 0>
		<cfoutput>
			<script language="javascript1.2">
				with(top.conteudo.form_conhecimento) {
					DESCARGA_CEP.value = '#qrDescarga.CEP#';
					DESCARGA_ENDERECO.value = '#JSStringFormat(qrDescarga.LOGRADOURO)#';
					DESCARGA_BAIRRO.value = '#JSStringFormat(qrDescarga.BAIRRO)#';
					DESCARGA_COMPLEMENTO.value = '';
					DESCARGA_UF.value = '#JSStringFormat(qrDescarga.UF)#';
					DESCARGA_MUNICIPIO.value = '#JSStringFormat(qrDescarga.LOCAL)#';
					ENTREGA_COD_UF.value = #qrDescarga.COD_UF#;
					ENTREGA_COD_MUNICIPIO.value = #qrDescarga.COD_MUNICIPIO#;
					ENTREGA_COD_DISTRITO.value = #qrDescarga.COD_DISTRITO#;
					ENTREGA_COD_DV.value = #qrDescarga.COD_DV#;
				}
			</script>
		</cfoutput>
	</cfif>
</cfif>

<!-- OPERACAO = 5 -->
<!-- Busca dados do servio contratado. -->
<cfif isDefined("vars.OPERACAO") and vars.OPERACAO EQ 5>
	<cftry>
		<cfif Len(vars.PLACA_CONTROLE) and Len(vars.DATA_EMISSAO)>
			<cfscript>
				conn_emissao_consult = CreateObject("component","_com.consulta.cfc_emissao_documentos");
				qrServico_Contratado = conn_emissao_consult.get_servico_contratado(p_placa=vars.PLACA_CONTROLE,p_data_emissao=vars.DATA_EMISSAO);
				conn_veiculo_consult = CreateObject("component","_com.consulta.cfc_veiculo");
				v_capacidade = conn_veiculo_consult.get_capacidade(placa=vars.PLACA_CONTROLE);
				
				try {
				    if (vars.PLACA_CONTROLE neq vars.PLACA_REFERENCIA) {
						if (v_capacidade eq 0)  {
							conn_veiculo_manip = CreateObject("component","_com.manipulacao.cfc_veiculo");
							conn_veiculo_manip.set_engate(placa_1 = vars.PLACA_CONTROLE, placa_2 = vars.PLACA_REFERENCIA, data = vars.DATA_EMISSAO);
							v_capacidade = conn_veiculo_consult.get_capacidade(placa=vars.PLACA_CONTROLE);
						}
						if (IsDefined("vars.BI_TREM") and (v_capacidade lt 30)) {
							conn_veiculo_manip = CreateObject("component","_com.manipulacao.cfc_veiculo");
							conn_veiculo_manip.set_engate(placa_1 = vars.PLACA_CONTROLE, placa_2 = vars.PLACA_REFERENCIA, data = vars.DATA_EMISSAO);
							conn_veiculo_manip.set_engate(placa_1 = vars.PLACA_REFERENCIA, placa_2 = vars.PLACA_SEGUNDA_CARRETA, data = vars.DATA_EMISSAO);
							v_capacidade = conn_veiculo_consult.get_capacidade(placa=vars.PLACA_CONTROLE);
						}
					}

					   v_verifica_composicao = conn_veiculo_consult.get_situacao_composicao(placa_controle=vars.PLACA_CONTROLE, placa_referencia=vars.PLACA_REFERENCIA);
					   retorno.erro = false;
				}
				catch ( Any e) {
					conexao_erro = CreateObject("component","_com.manipulacao.cfc_erros");	  
					retorno.erro = true;
					retorno.mensagem = conexao_erro.get_trata_erro(detalhe=e.getDetail(), numero_erro=e.getNativeErrorCode());
				}				
			</cfscript>
			<cfif qrServico_Contratado.retorno neq 0>
				<script language="javascript1.2">
					<cfif not retorno.erro>
						with(top.conteudo.form_conhecimento) {
						  <cfoutput>
							// Servio contratado
							<cfif Len(qrServico_contratado.COD_PESSOA_MOTORISTA)>
								COD_PESSOA_MOTORISTA.value = '#qrServico_contratado.COD_PESSOA_MOTORISTA#';
								CPF_MOTORISTA.value = '#qrServico_contratado.CPF_MOTORISTA#';
								NOME_MOTORISTA.value = '#qrServico_contratado.NOME_MOTORISTA#';
								CNH_NUMERO.value = '#qrServico_contratado.CNH_NUMERO#';
								CNH_VALIDADE.value = '#DateFormat(qrServico_contratado.CNH_VALIDADE,'dd/mm/yyyy')#';
							<cfelse>
								NOME_MOTORISTA.value = '';							
							</cfif>
							COD_PESSOA_PROPRIETARIO.value = '#qrServico_contratado.COD_PESSOA_PROPRIETARIO#';
							NIT_PROPRIETARIO.value = '#qrServico_contratado.PIS_PASEP_NIT#';
							CNPJ_CPF_PROPRIETARIO.value = '#qrServico_contratado.CNPJ_PROP#';
							PROPRIETARIO.value = '#qrServico_contratado.PROPRIETARIO#';
							ENDERECO_PROPRIETARIO.value = '#qrServico_contratado.ENDERECO#';
							UF_PROPRIETARIO.value = '#qrServico_contratado.UF#';
							CIDADE.value = '#qrServico_contratado.CIDADE#';
							PROPRIETARIO_COD_UF.value = '#qrServico_contratado.PROPRIETARIO_COD_UF#';
							PROPRIETARIO_COD_MUNICIPIO.value = '#qrServico_contratado.PROPRIETARIO_COD_MUNICIPIO#';
							PROPRIETARIO_COD_DISTRITO.value = '#qrServico_contratado.PROPRIETARIO_COD_DISTRITO#';
							PROPRIETARIO_COD_DV.value = '#qrServico_contratado.PROPRIETARIO_COD_DV#';
							PESO_CTRC.value = #v_capacidade#;
							top.conteudo.f_calculos('');
						  </cfoutput>
						}
					<cfelse>
						alert('<cfoutput>#JSStringFormat(retorno.mensagem)#</cfoutput>');
					</cfif>
				</script>
			<cfelse>
				<script language="javascript1.2">
					with(top.conteudo.form_conhecimento) {
					  <cfoutput>
						// Servio contratado
						NOME_MOTORISTA.value = 'Veculo no cadastrado, impossvel prosseguir.';
					  </cfoutput>
					}
				</script>
			</cfif> 
		</cfif>
	<cfcatch type="any">
		<cfscript>
			erro_conn = CreateObject("component","_com.manipulacao.cfc_erros");
		</cfscript>
		<cfset mensagem = JSStringFormat(erro_conn.get_trata_erro(cfcatch.Detail,cfcatch.NativeErrorCode))>
		<cfoutput>
			<cfdump var="#cfcatch#">
			<script language="javascript1.2">			
				alert('#mensagem#');
			</script>
		</cfoutput>
	</cfcatch>
	</cftry>
</cfif>

<!-- OPERACAO = 6 -->
<!-- Busca dados do motorista. -->
<cfif isDefined("vars.OPERACAO") and vars.OPERACAO EQ 6>
	<cfscript>
		conn_pessoas_consult = CreateObject("component","_com.consulta.cfc_pessoas");
		qrPessoa = conn_pessoas_consult.get_pessoa_fisica(cpf = vars.CPF_MOTORISTA);
	</cfscript>
	<script language="javascript1.2">
		with(top.conteudo.form_conhecimento) {
		  <cfoutput>
			// Motorista
			<cfif Len(qrPessoa.COD_PESSOA)>
				COD_PESSOA_MOTORISTA.value = '#qrPessoa.COD_PESSOA#';
				CPF_MOTORISTA.value = '#qrPessoa.CPF##qrPessoa.CPF_DV#';
				NOME_MOTORISTA.value = '#qrPessoa.NOME#';
				CNH_NUMERO.value = '#qrPessoa.CNH_NUM_REGISTRO#';
				CNH_VALIDADE.value = '#DateFormat(qrPessoa.CNH_VALIDADE,'dd/mm/yyyy')#';
			</cfif>
		  </cfoutput>
		}
	</script>
</cfif>
