<cfparam name="vars.PESO_TOTAL" default="0">
<cfparam name="vars.PESO_CTRC" default="0">
<cfscript>
	// Abre conexo
	 conn_ct_manip = CreateObject("component","_com.manipulacao.cfc_contrato_transporte");
 	 conn_ct_consult = CreateObject("component","_com.consulta.cfc_contrato_transporte");
	 conn_emissao_consult = CreateObject("component","_com.consulta.cfc_emissao_documentos");
	 conn_emissao_manip = CreateObject("component","_com.manipulacao.cfc_emissao_documentos");
</cfscript>
<cftry>
   <!--- Caso um lote avulso deva ser criado a var. vars.INSERE_LOTE deve ser true --->
   <cfif isDefined("vars.INSERE_LOTE") and vars.INSERE_LOTE>
   	  <cfparam name="vars.EMBARCADOR" default="">
   	  <cfparam name="vars.MOTORISTA" default="">
   	  <cfparam name="vars.FATURISTA" default="">
         <cfscript>
			function ListDeleteDuplicatesNoCase(list)
			{
			  var i = 1;
			  var delimiter = ',';
			  var returnValue = '';
			  if(ArrayLen(arguments) GTE 2)
				delimiter = arguments[2];
			  list = ListToArray(list, delimiter);
			  for(i = 1; i LTE ArrayLen(list); i = i + 1)
				if(NOT ListFindNoCase(returnValue, list[i], delimiter))
				  returnValue = ListAppend(returnValue, list[i], delimiter);
			  return returnValue;
			}
			lista_doctos = vars.EMBARCADOR & ',' & vars.MOTORISTA & ',' & vars.FATURISTA;
			lista_doctos = ListDeleteDuplicatesNoCase(ListSort(lista_doctos,"numeric"));
		    
			set_manipulacao = conn_ct_manip.set_lote(data_contrato = vars.DATA_CONTRATO,
													 num_natureza = vars.NUM_NATUREZA,
 													 num_produto = vars.PRODUTO_ID,
													 num_especie = vars.NUM_ESPECIE,
													 peso = vars.PESO,
													 volume = vars.VOLUME,
													 m3 = vars.M3,
													 frete_em = vars.FRETE_EM,
													 cod_unidade = vars.COD_UNIDADE,
													 qtde_viagem = vars.QTDE_VIAGENS,
													 destaca_base_calculo = vars.DESTACA_BASE_CALC_ICMS,
													 pedagio_incluso = vars.PEDAGIO_INCLUSO,
													 icms_incluso = vars.ICMS_INCLUSO,
													 regra_fiscal_id = vars.REGRA_FISCAL_ID,
													 frete_valor_unitario = vars.VALOR_UNITARIO,
													 frete_valor = vars.VALOR_TOTAL,
													 cod_pessoa_remetente = vars.REM_COD_PESSOA,
													 coleta_logradouro = vars.CARGA_ENDERECO,
												 	 coleta_complemento = vars.CARGA_COMPLEMENTO,
													 coleta_bairro = vars.CARGA_BAIRRO,
													 coleta_cep = vars.CARGA_CEP,
													 coleta_cod_uf = vars.COLETA_COD_UF,
													 coleta_cod_municipio = vars.COLETA_COD_MUNICIPIO,
													 coleta_cod_distrito = vars.COLETA_COD_DISTRITO,
													 coleta_cod_dv = vars.COLETA_COD_DV,
													 controle_por = vars.CONTROLE_VIAGEM,
													 negociado_por = vars.NEGOCIADO_POR,
													 observacao = vars.OBSERVACOES_LOTE_GERAL,
													 negociado_por_telefone = vars.NEGOCIADO_POR_TELEFONE,
													 negociado_por_email = vars.NEGOCIADO_POR_EMAIL,
													 contato_nome = vars.FATURAMENTO_NOME,
													 contato_telefone = vars.FATURAMENTO_TELEFONE,
													 contato_email = vars.FATURAMENTO_EMAIL,
													 negociado_com = vars.NEGOCIACAO_NOME,
													 negociado_com_cargo = vars.NEGOCIACAO_CARGO,
													 negociado_com_telefone = vars.NEGOCIACAO_TELEFONE,
													 negociado_com_email = vars.NEGOCIACAO_EMAIL,
													 seguro_por_conta = vars.SEGURO_POR_CONTA);	
		 </cfscript>
		
         <cfif set_manipulacao.erro>
            <cfthrow errorcode="#set_manipulacao.num_erro#" detail="#Replace(set_manipulacao.mensagem,chr(10),'<br>','ALL')#">
         </cfif>

		 <cfloop index="i" list="#lista_doctos#" delimiters=",">
            <cfscript>
				set_documentos = conn_ct_manip.set_documentos_faturamento(num_lote = set_manipulacao.num_lote,
																		  documento_id = i,
																		  embarcador = IIf(ListFind(vars.EMBARCADOR,i,','),DE("1"),DE("0")),
																		  motorista = IIf(ListFind(vars.MOTORISTA,i,','),DE("1"),DE("0")),
																		  faturista = IIf(ListFind(vars.FATURISTA,i,','),DE("1"),DE("0")));
			</cfscript>
         </cfloop>
        
		 <cfif set_documentos.erro>
            <cfthrow errorcode="#set_documentos.num_erro#" detail="#set_documentos.mensagem#">
         </cfif>
        
		<cfset session.num_lote = set_manipulacao.num_lote>
		 
      <cfelse>
		  <!--- Caso o lote j esteja inserido ento a var. session.num_lote  usada, se est no estiver difinida dispara erro --->
		  <cfif isDefined("vars.NUM_LOTE")>
			 <cfset session.num_lote = vars.NUM_LOTE>
			 <cfelseif not isDefined("session.num_lote") and not Len(session.num_lote) gt 0>
			 <cfthrow errorcode="20002" type="database" detail="Lote no determinado." message="Lote no determinado.">
		  </cfif>
		  <!--- Para viagens que possuem mais de um conhecimento devem ser inseridos aqui --->
		  <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>
			 <cfif Len(vars.ENTREGA_COD_UF) eq 0>
				<cfthrow errorcode="20000" detail="Problemas com o endereo do Destinatrio/Entrega. Verifique no cadastro.">
			 </cfif>
			 <cfscript>
					if (Len(vars.ST_ICMS_ID) eq 0) {
						qrICMS = conn_emissao_consult.get_icms(produto_id=vars.PRODUTO_ID,
												  cod_atividade=vars.COD_ATIVIDADE,
												  uf_origem = vars.UF_COLETA,
												  uf_destino = vars.UF_ENTREGA,
												  tomador_servico = vars.UF_COLETA);					
						
						vars.ST_ICMS_ID = NumberFormat(qrICMS.st_icms_id,'00');
					}
					
					set_conhecimento = conn_ct_manip.set_conhecimento(argumentCollection = vars,
																	  cod_pessoa_filial  = SESSION.COD_PESSOA,
																	  cod_departamento   = SESSION.COD_DEPARTAMENTO,
																	  cod_setor			 = SESSION.COD_SETOR,
																	  cod_centro_custo	 = SESSION.COD_CENTRO_CUSTO);				
			 </cfscript>
			 <cfif IsDefined("set_conhecimento") and set_conhecimento.erro>
				<cfthrow errorcode="#set_conhecimento.num_erro#" detail="#set_conhecimento.mensagem#">
			 </cfif>
			
			 <cfset vars.NOTAS = Replace(vars.NOTAS,","," ,","all")>
			 <cfloop index="i" list="#vars.NOTAS#" delimiters="||">
				<cfif i neq -1 and (ListLen(i,',') eq 6)>
				   <cfinvoke 
						 component="_com.manipulacao.cfc_emissao_documentos"
						 method="set_insere_nf_conhecimento"
						 returnvariable="insere_notas">
					  <cfinvokeargument name="conhecimento_id" value="#set_conhecimento.conhecimento_id#"/>
					  <cfinvokeargument name="data_emissao" value="#ListGetAt(i,5,",")#"/>
					  <cfinvokeargument name="modelo" value="#ListGetAt(i,4,",")#"/>
					  <cfinvokeargument name="serie" value="#ListGetAt(i,2,",")#"/>
					  <cfinvokeargument name="sub_serie" value="#ListGetAt(i,3,",")#"/>
					  <cfinvokeargument name="num_nota" value="#ListGetAt(i,1,",")#"/>
					  <cfinvokeargument name="valor_total" value="#ListGetAt(i,6,",")#"/>
				   </cfinvoke>
				   <cfif insere_notas.erro>
					  <cfthrow detail="#insere_notas.mensagem#" errorcode="#insere_notas.num_erro#">
				   </cfif>
				</cfif>
			 </cfloop>
		  </cfif>
   </cfif>

   <cfscript>
		// Busca sries
		qrSerie = conn_ct_consult.get_serie(cod_pessoa_filial= session.COD_PESSOA,
										    cod_departamento = session.cod_departamento,
											cod_setor	     = session.cod_setor,
											cod_centro_custo = session.cod_centro_custo);
		qrModelos = conn_emissao_consult.get_modelo_nota();
		qrLote  = conn_ct_consult.get_lote(num_lote = session.num_lote);	
	</cfscript>

    <cfset erro = false>

    <cfcatch>
		<cfif isDefined("cfcatch.NativeErrorCode")>
			<cfset fnc_controle_erros(numero_erro = cfcatch.NativeErrorCode, 
									  detalhe     = cfcatch.Detail)>
		<cfelseif isDefined("cfcatch.ErrorCode")>
			<cfset fnc_controle_erros(numero_erro = cfcatch.ErrorCode, 
									  detalhe     = cfcatch.Detail)>
		<cfelse>
			<cfset fnc_controle_erros(detalhe = cfcatch.Detail)>
		</cfif>		
     </cfcatch>		

</cftry>
</html>
<script language="javascript1.2" src="../../../../scripts/scripts.js"></script>
<script language="javascript1.2">
var v_campos = new Array();
// Nome dos campos
v_campos[1] = 'NUM_NOTA';
v_campos[2] = 'SERIE_NOTA';
v_campos[3] = 'SUB_SERIE';
v_campos[4] = 'MODELO';
v_campos[5] = 'DATA_EMISSAO_NOTA';
v_campos[6] = 'VALOR_TOTAL_NOTA';

var v_alinhamento = new Array();
// Alinhamento dos campos
v_alinhamento[1] = 'center';
v_alinhamento[2] = 'center';
v_alinhamento[3] = 'center';
v_alinhamento[4] = 'center';
v_alinhamento[5] = 'center';
v_alinhamento[6] = 'right';

var v_notas = new Array();
var v_count_nf = 0;
function adiciona_linha(id){
		if (f_verifica_form(document.form_conhecimento,'NOTA')) {
			tbody = document.getElementById(id).getElementsByTagName("TBODY")[0];
			row = document.createElement("TR");		
			

			row.id = 'tr_nf_'+v_count_nf;
			
			for (var i=1;i<v_campos.length;i++) {
				var td1 = document.createElement("TD");
				td1.align = v_alinhamento[i];
				td1.appendChild(document.createTextNode(eval('document.form_conhecimento.'+v_campos[i]+'.value')));
				row.appendChild(td1);
				
				if (i == 1)
				  v_notas[v_count_nf] = eval('document.form_conhecimento.'+v_campos[i]+'.value');
				else
				  v_notas[v_count_nf] = v_notas[v_count_nf]+','+eval('document.form_conhecimento.'+v_campos[i]+'.value');
				
				if (i == 6) 
				  document.form_conhecimento.VALOR_MERCADORIA.value = MM_arredondamento(parseFloat(document.form_conhecimento.VALOR_MERCADORIA.value) + parseFloat(eval('document.form_conhecimento.'+v_campos[i]+'.value')));
			}
			// Insere a imagem final
			var td1 = document.createElement("TD");
			td1.align = 'center';
			var img = new Image();
			img.src = '../../../../imagens/botao/del_topic.gif';
			img.indice = row.id;
			img.valor = eval('document.form_conhecimento.'+v_campos[6]+'.value');
			img.onclick = function() {
									   f_deleta_linha_nf('tb_notas', this.indice, this.valor);
									 }
			img.style.cursor = 'hand';
			td1.appendChild(img);
			row.appendChild(td1);		
			tbody.appendChild(row);
	
			v_count_nf = v_count_nf +1;
	
			//Limpa campos
			for (var i=1;i<v_campos.length;i++) {
				campo = eval('document.form_conhecimento.'+v_campos[i]);
	
				switch(i) {
					case 2: campo.value = 'U'; break;
					case 3: campo.value = '0'; break;
					case 4: campo.value = '1'; break;
					default: campo.value = ''; break;
				}
			}
	
			// Alterna cor das linhas
			for (i=2;i<tbody.rows.length;i++) {
				v_cor = tbody.rows[i].rowIndex;
				if (v_cor % 2 == 1)
					tbody.rows[i].style.background = '#FFFFFF';
				else tbody.rows[i].style.background = '';
		
			}		
		}		
	}
	
function f_deleta_linha_nf(id, p_linha, p_valor) {
	tbody = document.getElementById(id).getElementsByTagName("TBODY")[0];
	v_linha = document.getElementById(p_linha);

	tbody.deleteRow(v_linha.rowIndex);
	
	v_notas[p_linha.replace('tr_nf_','')] = -1;
	
	document.form_conhecimento.VALOR_MERCADORIA.value = MM_arredondamento(document.form_conhecimento.VALOR_MERCADORIA.value - p_valor);
	
	for (i=2;i<tbody.rows.length;i++) {
		v_cor = tbody.rows[i].rowIndex;
		if (v_cor % 2 == 1)
			tbody.rows[i].style.background = '#FFFFFF';
		else tbody.rows[i].style.background = '';
	}
}	

function f_confirmar() {
	with(document.form_conhecimento) {
		INSERE_CTRC.value = false;
		PAGO_POR.disabled = false;
		action = 'form_contrato_servico.cfm';
		target = '_self';
		submit();		
	}
}

function f_consulta_descarga() {
	with(document.form_conhecimento) {
		OPERACAO.value = 4; // Consulta Descarga
		target = 'consultas';
		action = 'consultas.cfm';
		submit();
	}
}

function f_consulta_motorista() {
	with(document.form_conhecimento) {
		OPERACAO.value = 6; // Consulta Motorista
		NOME_MOTORISTA.value = 'consultando...';
		target = 'motorista';
		action = 'consultas.cfm';
		submit();
	}
}

function f_consulta_destinatario() {
	with(document.form_conhecimento) {
		OPERACAO.value = 2; // Consulta Destinatrio
		target = 'destinatario';
		action = 'consultas.cfm';
		submit();
	}
}

function f_consulta_placa() {
	with(document.form_conhecimento) {
		OPERACAO.value = 5; // Consulta Servio Contratado
		NOME_MOTORISTA.value = 'consultando...';
		target = 'consultas';
		action = 'consultas.cfm';
		submit();		
	}
}

<cfoutput>
	v_calc_aliquota_icms = #qrLote.ALIQUOTA_ICMS#;
	v_icms_incluso = #qrLote.ICMS_INCLUSO#;
	v_valor_pedagio_incluso = #qrLote.PEDAGIO_INCLUSO#; 
	v_controla_base_calculo = #qrLote.DESTACA_BASE_CALC_ICMS#; 
</cfoutput>	

function f_calculos(campo) {
v_reducao_base_calculo_icms = 0;
	switch(campo.name) {
		case 'BASE_CALCULO_ICMS': 
			with(document.form_conhecimento) {
				VALOR_ICMS.value = MM_arredondamento(BASE_CALCULO_ICMS.value * (v_calc_aliquota_icms/100));		
			}
			break;
		default:
			with(document.form_conhecimento) {
			    if (v_icms_incluso == 1) 
					FRETE_PESO.value = FRETE_PESO.value * (1-(v_calc_aliquota_icms/100));
				
				if (FRETE_EM.value == 'LOTACAO') 
					FRETE_VALOR.value = MM_arredondamento(FRETE_PESO.value);
				else
				    FRETE_VALOR.value = MM_arredondamento(PESO_CTRC.value*FRETE_PESO.value);
					
				if (parseInt(document.form_conhecimento.SITUACAO_TRIBUTARIA.value) == 10) {
					TOTAL_CONHECIMENTO.value = FRETE_VALOR.value;				
					BASE_CALCULO_ICMS.value = MM_arredondamento(parseFloat(TOTAL_CONHECIMENTO.value)/ (1-(parseFloat(v_calc_aliquota_icms)/100))*((100-parseFloat(v_reducao_base_calculo_icms))/100));
				}
				else {
					TOTAL_CONHECIMENTO.value = MM_arredondamento(parseFloat(FRETE_VALOR.value) / (1-(parseFloat(v_calc_aliquota_icms)/100)));				
					BASE_CALCULO_ICMS.value = MM_arredondamento(parseFloat(TOTAL_CONHECIMENTO.value)*((100-parseFloat(v_reducao_base_calculo_icms))/100));
				}
				VALOR_ICMS.value = MM_arredondamento(parseFloat(BASE_CALCULO_ICMS.value) * (parseFloat(v_calc_aliquota_icms)/100));
			}
		  }
		if (v_valor_pedagio_incluso == 1) {
		    document.form_conhecimento.TOTAL_CONHECIMENTO.value = MM_arredondamento(parseFloat(document.form_conhecimento.TOTAL_CONHECIMENTO.value) + parseFloat(document.form_conhecimento.DESPACHO.value));
		}
		if (v_controla_base_calculo == 0) {
			with(document.form_conhecimento) {
				ALIQUOTA_ICMS.value = '0.00';
				v_calc_aliquota_icms = 0;
				BASE_CALCULO_ICMS.value = '0.00';
				VALOR_ICMS.value = '0.00';
			}	
		}		

		if (parseInt(document.form_conhecimento.SITUACAO_TRIBUTARIA.value) == 10) {
			with(document.form_conhecimento) {
				ALIQUOTA_ICMS.value = '0.00';
				VALOR_ICMS.value = '0.00';
			}	
		}		
}

function f_novo_ctrc(p_btn) {
	with(document.form_conhecimento) {
		INSERE_CTRC.value = true;
		target = '_self';
		action = 'form_ctrc.cfm';
		for (i=0;i<v_notas.length;i++) {
			if (i==0) NOTAS.value = v_notas[i];
			else NOTAS.value = NOTAS.value + '||' + v_notas[i];
		}		
		alert('O conhecimento vai ser impresso no fim do processo de incluso do contrato de transporte.');
		if (VALOR_MERCADORIA.value < 700000) {
			if (f_verifica_form(document.form_conhecimento, 'ctrc')) {
				submit();		
				 p_btn.innerHTML='<img src=../../../../imagens/botao/16x16/incluir.gif width=14 height=14 align=absmiddle> Processando...'; 
				 p_btn.onclick=function() { alert('Aguarde o processamento.') }
			}
		}
		else alert('Valor da mercadoria  superior ao permitido pela seguradora, verifique o valor das notas');
	}
}

function f_consulta_cep(p_campo, p_funcao) {
	var msAttributes ="status:no;help:yes;bord1er:thin;statusbar:no;scroll:auto;dialogWidth:500px;dialogHeight:300px";
	var v_url = "../../../consultas_gerais/consulta_cep.cfm?campo="+p_campo+"&funcao="+p_funcao;
	showModalDialog(v_url,window,msAttributes);
}

</script>
<html>
<head>
<title>..: Del Pozo NET :..</title>
<link href="../../../../estilos/padrao.css" rel="stylesheet" type="text/css">
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
</head>
<body> 
<table width="100%" border="0" cellpadding="0" cellspacing="0"> 
   <tr> 
      <td width="90%" height="20">
	  <cfif not erro> 
            <form name="form_conhecimento" method="post" action=""> 
               <table border="1" align="center" cellpadding="3" cellspacing="0" bordercolor="#FFFFFF" class="tabela-borda1px-semfundo"> 
                  <tr> 
                     <td colspan="6" class="titulo1"><div align="center"> 
                           <table width="100%"  border="0" cellspacing="0" cellpadding="0"> 
                              <tr> 
                                 <td width="98%" class="titulo1"><div align="center">Contrato
                                       de Transporte</div></td> 
                                 <td width="2%" class="titulo1"><img src="../../../../imagens/botao/16x16/duvida.gif" class="botao-img" width="16" height="16" onClick="window.showModalDialog('../ajuda/ajd_ctrc.html?ajuda=7','','dialogHeight: 350px; dialogWidth: 355px; dialogTop: center; dialogLeft: center; edge: Raised; center: Yes; help: No; resizable: No; status: No;');"></td> 
                              </tr> 
                           </table> 
                        </div></td> 
                  </tr> 
                  <tr align="center" valign="middle"> 
                     <td colspan="6" class="titulo1"><button name="btn_voltar" class="botao" style="width:140px " onClick="window.location='../../principal.cfm'"><img src="../../../../imagens/botao/16x16/voltar.gif" align="absmiddle"> Volta
                           para o Inicio</button>    
  
                        <button name="btn_voltar" class="botao" style="height:21px " onClick="window.location='form_lote.cfm'"><img src="../../../../imagens/botao/16x16/voltar.gif" align="absmiddle"> Voltar</button></td> 
                  </tr> 
                  <tr> 
                     <td colspan="6" class="titulo4">Lote N&ordm;: <cfoutput>#session.num_lote#</cfoutput> 
                         
                        <input name="INSERE_CTRC" type="hidden" id="INSERE_CTRC">
                        <input name="NUM_LOTE" type="hidden" id="NUM_LOTE" value="<cfoutput>#SESSION.NUM_LOTE#</cfoutput>"> 
                        <input name="NUM_ROMANEIO" type="hidden" id="NUM_ROMANEIO" value="<cfif isDefined("set_conhecimento.NUM_ROMANEIO")><cfoutput>#set_conhecimento.NUM_ROMANEIO#</cfoutput></cfif>"> 
                        <input name="VOLUME" type="hidden" id="VOLUME" value="0"> 
                        <input name="M3" type="hidden" id="M3" value="0"> 
                        <input name="FRETE_EM" type="hidden" id="FRETE_EM" value="<cfoutput>#qrLote.FRETE_EM#</cfoutput>"> 
                        <input name="COD_UNIDADE" type="hidden" id="COD_UNIDADE" value="<cfoutput>#qrLote.COD_UNIDADE#</cfoutput>"> </td> 
                  </tr> 
                  <tr> 
                     <td colspan="6" class="titulo4">Conhecimento
                        <input name="OPERACAO" type="hidden" id="OPERACAO"> </td> 
                  </tr> 
                  <tr class="texto1"> 
                     <td colspan="6" class="titulo3"><div align="center">Servi&ccedil;o
                           Contratado </div></td> 
                  </tr> 
                  <tr class="texto1"> 
                     <td colspan="6"><table width="100%"  border="1" cellpadding="3" cellspacing="0" bordercolor="#FFFFFF"> 
                           <tr> 
                              <td colspan="6" class="label1"><table width="100%"  border="1" cellpadding="3" cellspacing="0" bordercolor="#FFFFFF"> 
                                    <tr class="label1">
                                      <td width="18%" nowrap>Data/Hora Emiss&atilde;o: </td>
                                      <td colspan="6" nowrap><input name="DATA_EMISSAO" type="text" class="caixa_texto" id="DATA_EMISSAO" onKeyUp="f_formata_data_hora(this)" size="20" maxlength="16" secao="ctrc" display="DATA_EMISSAO" obrigatorio="1" hint="Data de emiss&atilde;o do Conhecimento"></td>
                                    </tr>
                                    <tr class="label1">
                                      <td nowrap>Placa Carreta:</td>
                                      <td width="9%" nowrap><input name="PLACA_REFERENCIA" type="text" class="caixa_texto" id="PLACA_REFERENCIA" onBlur="f_converte_placa(this)" onKeyUp="f_formata_placa(this)" size="11" maxlength="8" display="PLACA CARRETA" obrigatorio="1" secao="ctrc" hint="Placa da Carreta do Transportador" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>readonly="yes" value="<cfoutput>#vars.PLACA_REFERENCIA#</cfoutput>"</cfif>></td>
                                      <td width="12%" align="center" nowrap><input name="BI_TREM" type="checkbox" id="BI_TREM" value="1" onClick="if (this.checked) { td_label_bitrem.style.display=''; td_campo_bitrem.style.display=''; } else { td_label_bitrem.style.display='none'; td_campo_bitrem.style.display='none'; }">
  Bi-Trem </td>
                                      <td width="14%" nowrap id="td_label_bitrem" style="display:none"> 2&ordf; Placa da  Carreta: </td>
                                      <td width="9%" nowrap id="td_campo_bitrem" style="display:none"><input name="PLACA_SEGUNDA_CARRETA" type="text" class="caixa_texto" id="PLACA_SEGUNDA_CARRETA" onBlur="f_converte_placa(this);f_consulta_placa()" onKeyUp="f_formata_placa(this)" size="11" maxlength="8" display="PLACA SEGUNDA CARRETA" obrigatorio="0" secao="ctrc" hint="Placa da segunda carreta do Bi-Trem." <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>readonly="yes" value="<cfoutput>#vars.PLACA_CONTROLE#</cfoutput>"</cfif>></td>
                                      <td width="12%" nowrap>Placa Cavalo:</td>
                                      <td width="26%"><input name="PLACA_CONTROLE" type="text" class="caixa_texto" id="PLACA_CONTROLE" onBlur="f_converte_placa(this);f_consulta_placa()" onKeyUp="f_formata_placa(this)" size="11" maxlength="8" display="PLACA CAVALO" obrigatorio="1" secao="ctrc" hint="Placa do Cavalo do ve&iacute;culo do transportador" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>readonly="yes" value="<cfoutput>#vars.PLACA_CONTROLE#</cfoutput>"</cfif>></td> 
                                    </tr> 
                                 </table></td> 
                           </tr> 
                           <tr> 
                              <td width="13%" class="label1">Motorista:</td> 
                             <td colspan="5" valign="middle" nowrap><input name="CPF_MOTORISTA" type="text" class="caixa_texto" id="CPF_MOTORISTA" onChange="f_consulta_motorista()" size="15" maxlength="11" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>readonly="yes" value="<cfoutput>#vars.CPF_MOTORISTA#</cfoutput>"</cfif>> 
                                 <input name="NOME_MOTORISTA" type="text" class="caixa-texto-disable" id="NOME_MOTORISTA" size="40" readonly="yes" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>readonly="yes" value="<cfoutput>#vars.NOME_MOTORISTA#</cfoutput>"</cfif>> 
                                 <input name="COD_PESSOA_MOTORISTA" type="hidden" id="COD_PESSOA_MOTORISTA" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>readonly="yes" value="<cfoutput>#vars.COD_PESSOA_MOTORISTA#</cfoutput>"</cfif>>&nbsp;<button class="botao-inline" style=" border:1px solid #777777" onClick="NewWindow('../../../cadastro/cadastro_frame.cfm?ENDERECO=motorista/formulario.cfm','cad_motorista','760','450','yes');return false"><img src="../../../../imagens/botao/16x16/incluir.gif" width="16" height="16" align="absmiddle"> Cadastrar </button>
                                 &nbsp;
                                 <button class="botao-inline" style=" border:1px solid #777777" onClick="NewWindow('../consultas/busca_motorista.cfm','consulta_motorista','500','300','yes');return false"><img src="../../../../imagens/botao/16x16/localizar.gif" width="16" height="16" align="absmiddle"> Consultar</button>
                             </td> 
                           </tr> 
                           <tr> 
                              <td class="label1">CNH:</td> 
                              <td width="18%"><input name="CNH_NUMERO" type="text" class="caixa-texto-disable" id="CNH_NUMERO" size="25" readonly="yes" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>value="<cfoutput>#vars.CNH_NUMERO#</cfoutput>"</cfif>></td> 
                              <td width="13%" class="label1">Validade:</td> 
                              <td colspan="3"><input name="CNH_VALIDADE" type="text" class="caixa-texto-disable" id="CNH_VALIDADE" size="16" readonly="yes" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>value="<cfoutput>#vars.CNH_VALIDADE#</cfoutput>"</cfif>></td> 
                           </tr> 
                           <tr class="label1"> 
                              <td>CNPJ/CPF:</td> 
                              <td><input name="PROP_CNPJ_CPF" type="text" class="caixa-texto-disable" id="PROP_CNPJ_CPF" size="20" readonly="yes" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>value="<cfoutput>#vars.PROP_CNPJ_CPF#</cfoutput>"</cfif>> 
                                 <input name="COD_PESSOA_PROPRIETARIO" type="hidden" id="COD_PESSOA_PROPRIETARIO"  <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>value="<cfoutput>#vars.COD_PESSOA_PROPRIETARIO#</cfoutput>"</cfif>>
                                 <input name="PROPRIETARIO_COD_UF" type="hidden" id="PROPRIETARIO_COD_UF" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>value="<cfoutput>#vars.PROPRIETARIO_COD_UF#</cfoutput>"</cfif>>
                                 <input name="PROPRIETARIO_COD_MUNICIPIO" type="hidden" id="PROPRIETARIO_COD_MUNICIPIO" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>value="<cfoutput>#vars.PROPRIETARIO_COD_MUNICIPIO#</cfoutput>"</cfif>>
                                 <input name="PROPRIETARIO_COD_DISTRITO" type="hidden" id="PROPRIETARIO_COD_DISTRITO" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>value="<cfoutput>#vars.PROPRIETARIO_COD_DISTRITO#</cfoutput>"</cfif>>
                                 <input name="PROPRIETARIO_COD_DV" type="hidden" id="PROPRIETARIO_COD_DV" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>value="<cfoutput>#vars.PROPRIETARIO_COD_DV#</cfoutput>"</cfif>>
							  </td> 
                              <td>Nome:</td> 
                              <td colspan="3"><input name="PROP_RAZAO_SOCIAL" type="text" class="caixa-texto-disable" id="PROP_RAZAO_SOCIAL" size="50" readonly="yes" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>value="<cfoutput>#vars.PROP_RAZAO_SOCIAL#</cfoutput>"</cfif>></td> 
                           </tr> 
                           <tr class="label1"> 
                              <td>Endere&ccedil;o:</td> 
                              <td colspan="3"><input name="PROP_ENDERECO" type="text" class="caixa-texto-disable" id="PROP_ENDERECO" style="width:100% " maxlength="60" readonly="yes" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>value="<cfoutput>#vars.PROP_ENDERECO#</cfoutput>"</cfif>></td> 
                              <td width="4%">UF:</td> 
                              <td width="28%"><input name="PROP_UF" type="text" class="caixa-texto-disable" id="PROP_UF" size="5" maxlength="2" readonly="yes" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>value="<cfoutput>#vars.PROP_UF#</cfoutput>"</cfif>></td> 
                           </tr> 
                           <tr class="label1"> 
                              <td>Cidade:</td> 
                              <td><input name="CIDADE" type="text" class="caixa-texto-disable" id="CIDADE" style="width:100% " readonly="yes" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>value="<cfoutput>#vars.CIDADE#</cfoutput>"</cfif>></td> 
                              <td>NIT(INSS):</td> 
                              <td colspan="3"><input name="NIT_PROPRIETARIO" type="text" class="caixa-texto-disable" id="NIT_PROPRIETARIO" readonly="yes" <cfif isDefined("vars.INSERE_CTRC") and vars.INSERE_CTRC>value="<cfoutput>#vars.NIT_PROPRIETARIO#</cfoutput>"</cfif>></td> 
                           </tr> 
                        </table></td> 
                  </tr> 
                  <tr class="label1"> 
                     <td colspan="6" nowrap class="titulo3"><div align="center">Dados
                           do Conhecimento 
						   <cfoutput> 
                              <input name="COLETA_COD_UF" type="hidden" id="COLETA_COD_UF" value="#qrLote.COLETA_COD_UF#"> 
                              <input name="COLETA_COD_MUNICIPIO" type="hidden" id="COLETA_COD_MUNICIPIO" value="#qrLote.COLETA_COD_MUNICIPIO#"> 
                              <input name="COLETA_COD_DISTRITO" type="hidden" id="COLETA_COD_DISTRITO" value="#qrLote.COLETA_COD_DISTRITO#"> 
                              <input name="COLETA_COD_DV" type="hidden" id="COLETA_COD_DV" value="#qrLote.COLETA_COD_DV#"> 
                              <input name="ENTREGA_COD_UF" type="hidden" id="ENTREGA_COD_UF" value="#qrLote.ENTREGA_COD_UF#"> 
                              <input name="ENTREGA_COD_MUNICIPIO" type="hidden" id="ENTREGA_COD_MUNICIPIO" value="#qrLote.ENTREGA_COD_MUNICIPIO#"> 
                              <input name="ENTREGA_COD_DISTRITO" type="hidden" id="ENTREGA_COD_DISTRITO" value="#qrLote.ENTREGA_COD_DISTRITO#"> 
                              <input name="ENTREGA_COD_DV" type="hidden" id="ENTREGA_COD_DV" value="#qrLote.ENTREGA_COD_DV#"> 
                              <input name="PRODUTO_ID" type="hidden" id="PRODUTO_ID" value="#qrLote.NUM_PRODUTO#"> 
                              <input name="COD_ATIVIDADE" type="hidden" id="COD_ATIVIDADE" value="#qrLote.COD_ATIVIDADE_FISCAL#"> 
                              <input name="SITUACAO_TRIBUTARIA" type="hidden" id="SITUACAO_TRIBUTARIA" value="#qrLote.SITUACAO_TRIBUTARIA#"> 
                           </cfoutput> </div></td> 
                  </tr> 
                  <tr> 
                     <td width="109" nowrap class="label1"> Destinat&aacute;rio:</td> 
                     <td nowrap><input name="DEST_CNPJ" type="text" class="caixa_texto" id="DEST_CNPJ" onChange="f_consulta_destinatario()" size="20" maxlength="14" display="DESTINAT&Aacute;RIO (CNPJ/CPF)" obrigatorio="1" secao="ctrc" hint="CNPJ ou CPF do Destinat&aacute;rio"> 
                        <img src="../../../../imagens/botao/16x16/visualizar.gif" width="16" height="16" align="absmiddle" class="botao-img" onClick="NewWindow('../consultas/consulta_pessoa.cfm?FORM=form_conhecimento&DESTINATARIO=1','Destinatario','500','300','yes');return false"></td> 
                     <td width="118" nowrap class="label1">Nome/Raz&atilde;o
                        Social:</td> 
                     <td colspan="3"><input name="DEST_RAZAO_SOCIAL" type="text"class="caixa-texto-disable" id="DEST_RAZAO_SOCIAL" style="width:100% " size="40" readonly="yes" secao="ctrc" display="DADOS DESTINATTIO" obrigatorio="1" hint="Digite o CNPJ e aguarde enquanto o sistema procura os dados do destinatrio."> 
                        <input name="COD_DESTINATARIO" type="hidden" id="COD_DESTINATARIO"></td> 
                      <input name="DEST_COD_UF" type="hidden" id="DEST_COD_UF">
                     <input name="DEST_COD_MUNICIPIO" type="hidden" id="DEST_COD_MUNICIPIO"> 
                     <input name="DEST_COD_DISTRITO" type="hidden" id="DEST_COD_DISTRITO"> 
                     <input name="DEST_COD_DV" type="hidden" id="DEST_COD_DV"> 
                     <input name="ST_ICMS_ID" type="hidden" id="ST_ICMS_ID"> 
                  </tr> 
                  <tr class="label1"> 
                     <td colspan="6" nowrap><table width="100%"  border="0" cellpadding="2" cellspacing="0"> 
                           <tr> 
                              <td class="label2">Descarga</td> 
                           </tr> 
                           <tr> 
                              <td><table width="100%"  border="0" cellspacing="0" cellpadding="2"> 
                                    <tr class="label1"> 
                                       <td width="8%">CEP</td> 
                                       <td width="62%">Endere&ccedil;o</td> 
                                       <td width="30%">Bairro</td> 
                                    </tr> 
                                    <tr> 
                                       <td width="8%" nowrap><input name="DESCARGA_CEP" type="text" class="caixa_texto" id="DESCARGA_CEP" onChange="f_consulta_descarga()" size="10" maxlength="8" display="CEP DESTINATRIO" obrigatorio="1" secao="ctrc" hint="CEP do endereo do destinatrio"> 
                                          <img src="../../../../imagens/botao/16x16/visualizar.gif" width="16" height="16" align="absmiddle" class="botao-img" onClick="f_consulta_cep('form_conhecimento.DESCARGA_CEP', 'f_consulta_descarga()')"></td> 
                                       <td><input name="DESCARGA_ENDERECO" type="text" class="caixa_texto" id="DESCARGA_ENDERECO" style="width:100% " size="40" maxlength="60" display="RUA / RODOVIA" obrigatorio="1" secao="ctrc" hint="Endereo do destinatrio"></td> 
                                       <td><input name="DESCARGA_BAIRRO" type="text" class="caixa_texto" id="DESCARGA_BAIRRO" size="40" maxlength="60" display="BAIRRO" obrigatorio="1" secao="ctrc" hint="Bairro do destinatrio"></td> 
                                    </tr> 
                                 </table></td> 
                           </tr> 
                           <tr> 
                              <td><table width="100%"  border="0" cellspacing="0" cellpadding="2"> 
                                    <tr class="label1"> 
                                       <td width="66%">Complemento</td> 
                                       <td width="4%">UF</td> 
                                       <td width="30%">Munic&iacute;pio</td> 
                                    </tr> 
                                    <tr> 
                                       <td width="66%"><input name="DESCARGA_COMPLEMENTO" type="text" class="caixa_texto" id="DESCARGA_COMPLEMENTO" style="width:100% " size="60" maxlength="60" display="COMPLEMENTO" obrigatorio="0" hint="Complemento que facilite a localizao do endereo do destinatrio"></td> 
                                       <td><input name="DESCARGA_UF" type="text" class="caixa-texto-disable" id="DESCARGA_UF" size="4" maxlength="2" readonly="yes"></td> 
                                       <td><input name="DESCARGA_MUNICIPIO" type="text" class="caixa-texto-disable" id="DESCARGA_MUNICIPIO" size="40" maxlength="60" readonly="yes"></td> 
                                    </tr> 
                                 </table></td> 
                           </tr> 
                        </table></td> 
                  </tr> 
                  <tr class="label1"> 
                     <td nowrap>Coleta:</td> 
                    <td colspan="2" nowrap><input name="COLETA" type="text" class="caixa_texto" id="COLETA" value="<cfoutput>#qrLote.COLETA_MUNICIPIO#</cfoutput>" size="30" display="LOCAL DA COLETA" obrigatorio="1" secao="ctrc" hint="Local da coleta da mercadoria" > 
                        <input name="UF_COLETA" type="text" class="caixa_texto" id="UF_COLETA" value="<cfoutput>#qrLote.COLETA_UF#</cfoutput>" size="4" display="UF COLETA" obrigatorio="1" secao="ctrc" hint="UF da coleta da mercadoria"> 
                       <img src="../../../../imagens/botao/16x16/procurar.gif" name="img_coleta" width="16" height="16" align="absmiddle" class="botao-img" id="img_coleta" onClick="NewWindow('../consultas/consulta_municipio.cfm?FORM=form_conhecimento&RETORNO=UF_COLETA,COLETA,COLETA_COD_UF,COLETA_COD_MUNICIPIO,COLETA_COD_DISTRITO,COLETA_COD_DV','Coleta','500','300','yes');return false"></td> 
                     <td width="119" nowrap><div align="left">Entrega:</div></td> 
                    <td colspan="2" nowrap><input name="ENTREGA" type="text" class="caixa_texto" id="ENTREGA" size="30" display="LOCAL DA ENTREGA" obrigatorio="1" secao="ctrc" hint="Local para entrega da mercadoria" > 
                        <input name="UF_ENTREGA" type="text" class="caixa_texto" id="UF_ENTREGA" size="4" display="UF ENTREGA" obrigatorio="1" secao="ctrc" hint="UF para entrega da mercadoria"> 
                       <img src="../../../../imagens/botao/16x16/procurar.gif" name="img_entrega" width="16" height="16" align="absmiddle" class="botao-img" id="img_entrega" onClick="NewWindow('../consultas/consulta_municipio.cfm?FORM=form_conhecimento&RETORNO=UF_ENTREGA,ENTREGA,ENTREGA_COD_UF,ENTREGA_COD_MUNICIPIO,ENTREGA_COD_DISTRITO,ENTREGA_COD_DV','Entrega','500','300','yes');return false"></td> 
                  </tr> 
                  <tr class="label1"> 
                     <td nowrap>N&ordm; CTRC: </td> 
                     <td nowrap><input name="NUM_CONHECIMENTO" type="text" class="caixa_texto" id="NUM_CONHECIMENTO" size="15" maxlength="6" secao="ctrc" display="NMERO DO CTRC" obrigatorio="1" hint="Nmero do conhecimento que est sendo emitido"></td> 
                     <td nowrap>S&eacute;rie:</td> 
                     <td nowrap><select name="SERIE" class="caixa_texto" id="SERIE" display="SRIE" obrigatorio="1" secao="ctrc" hint="Srie do conhecimento que est sendo emitido"> 
                           <option value="">-- Selecione --</option> 
                           <cfoutput query="qrSerie"> 
                              <option value="#qrSerie.SERIE#" <cfif qrSerie.RecordCount eq 1>selected</cfif>>#qrSerie.SERIE#</option> 
                           </cfoutput> 
                        </select></td> 
                     <td width="116" nowrap>Pago por:<input name="PAGO_POR" type="hidden" value="<cfoutput>#qrLote.FRETE_POR_CONTA#</cfoutput>"> </td> 
                     <td width="104" nowrap><select name="PAGO_POR" disabled="disabled" class="caixa_texto" id="PAGO_POR" display="PAGO POR" obrigatorio="1" secao="ctrc" hint="Quem ser responsvel pelo pagamento"> 
                           <option value="0" <cfif qrLote.FRETE_POR_CONTA eq 0>selected</cfif>>Remetente</option> 
                           <option value="1" <cfif qrLote.FRETE_POR_CONTA eq 1>selected</cfif>>Destinat&aacute;rio</option> 
                        </select></td> 
                  </tr> 
                  <tr class="label1"> 
                     <td colspan="6" nowrap class="titulo3"><div align="center">Notas</div></td> 
                  </tr> 
                  <tr class="label1"> 
                     <td colspan="6" nowrap><table border="1" align="center" cellpadding="3" cellspacing="0" bordercolor="#FFFFFF" class="texto1" id="tb_notas"> 
                           <tr class="label2"> 
                              <td nowrap><div align="center">N&ordm; Nota</div></td> 
                              <td nowrap><div align="center">S&eacute;rie</div></td> 
                              <td nowrap><div align="center">Sub-s&eacute;rie</div></td> 
                              <td nowrap><div align="center">Modelo</div></td> 
                              <td nowrap><div align="center">Data Emiss&atilde;o</div></td> 
                              <td nowrap><div align="right">Valor Total Nota</div></td> 
                              <td nowrap><div align="center">Confirma</div></td> 
                           </tr> 
                           <tr class="texto1"> 
                              <td> <div align="center" onKeyPress="return f_formata(this,event,'000000000000000')"> 
                                    <input name="NUM_NOTA" type="text" class="caixa_texto" id="NUM_NOTA" style="text-align: center" size="10" maxlength="6" secao="NOTA" display="NUMERO NOTA" obrigatorio="1"> 
                                 </div></td> 
                              <td> <div align="center"> 
                                    <input name="SERIE_NOTA" type="text" class="caixa_texto" id="SERIE_NOTA" style="text-align: center" value="U" size="5" display="S&Eacute;RIE" obrigatorio="1" secao="NOTA"> 
                                 </div></td> 
                              <td> <div align="center"> 
                                    <input name="SUB_SERIE" type="text" class="caixa_texto" id="SUB_SERIE" style="text-align: center" value="0" size="5" maxlength="2" secao="NOTA" display="SUB-S&Eacute;RIE" obrigatorio="1"> 
                                 </div></td> 
                              <td> <div align="center"> 
                                <select name="MODELO" class="caixa_texto" id="MODELO" display="MODELO" obrigatorio="1" secao="NOTA" hint="Modelo, verificar na nota">
                                  <option selected>--</option>
								  <cfoutput query="qrModelos">
								  	<option  value="#qrModelos.COD_MODELO#">#qrModelos.COD_MODELO#</option>
								  </cfoutput>
                                </select>
</div></td> 
                              <td> <div align="center"> 
                                    <input name="DATA_EMISSAO_NOTA" type="text" class="caixa_texto" id="DATA_EMISSAO_NOTA" style="text-align: center" onKeyUp="MM_data_key_up(this,false)" size="20" maxlength="10" display="DATA EMISS&Atilde;O" obrigatorio="1" secao="NOTA"> 
                                 </div></td> 
                              <td> <div align="right"> 
                                    <input secao="NOTA" name="VALOR_TOTAL_NOTA" type="text" class="caixa-texto-monet" id="VALOR_TOTAL_NOTA" size="20" onKeyUp="verifica_separador(this,this.value)"> 
                                 </div></td> 
                              <td nowrap> <div align="center"> <a href="javascript: adiciona_linha('tb_notas');"><img src="../../../../imagens/botao/16x16/concluir.gif" width="15" height="14" border="0" align="absmiddle" class="botao-img" id="btn_confirma_nota">Clique
                                       aqui.</a> 
                                    <input name="NOTAS" type="hidden" id="NOTAS"> 
                                 </div></td> 
                           </tr> 
                           <tbody class="texto1"> </tbody> 
                        </table></td> 
                  </tr> 
                  <tr class="label1"> 
                     <td nowrap>Valor Mercadoria: </td> 
                     <td nowrap><input name="VALOR_MERCADORIA" type="text" class="caixa-texto-disable" id="VALOR_MERCADORIA" style="text-align:right " value="0.00" onKeyUp="verifica_separador(this,this.value)" size="18" readonly="yes" display="VALOR MERCADORIA (DIGITE AS NOTAS)" obrigatorio="1" secao="ctrc" hint="Valor da mercadoria, voc precisa lanar as notas"></td> 
                     <td nowrap>Coleta/Entrega:</td> 
                     <td nowrap><input name="COLETA_ENTREGA" type="text" class="caixa-texto-monet" id="COLETA_ENTREGA" value="0.00" size="18" display="COLETA / ENTREGA" onKeyUp="verifica_separador(this,this.value)"  obrigatorio="1" secao="ctrc" hint="Valor para coleta e entrega da mercadoria"></td> 
                     <td nowrap><input name="ADEME" type="hidden" id="ADEME" value="0"> 
                        Impostos:</td> 
                     <td nowrap><input name="IMPOSTOS" type="text" class="caixa-texto-monet" id="IMPOSTOS" value="0.00" size="18" display="IMPOSTOS" obrigatorio="1" onKeyUp="verifica_separador(this,this.value)"  secao="ctrc" hint="Valor dos impostos"></td> 
                  </tr> 
                  <tr class="label1"> 
                     <td nowrap>Peso:</td> 
                    <td nowrap><input name="PESO_CTRC" type="text" class="caixa-texto-monet" id="PESO_CTRC" onChange="f_calculos(this)" size="15" onKeyUp="verifica_separador(this,this.value)"  display="PESO" obrigatorio="1" secao="ctrc" hint="Peso transportado em TONELADAS.">
                     <input name="PESO_TOTAL" type="hidden" id="PESO_TOTAL" value="<cfoutput>#vars.PESO_TOTAL+vars.PESO_CTRC#</cfoutput>"></td> 
                     <td nowrap>Valor Unit&aacute;rio: </td> 
                     <td nowrap><input name="FRETE_PESO" type="text" class="caixa-texto-monet" id="FRETE_PESO" onChange="f_calculos(this)" onKeyUp="verifica_separador(this,this.value)"  value="<cfoutput>#qrLote.FRETE_VALOR_UNITARIO#</cfoutput>" size="18" display="VALOR UNITRIO" obrigatorio="1" secao="ctrc" hint="Valor Unitrio do frete"></td> 
                     <td nowrap>Valor Total:</td> 
                     <td nowrap><input name="FRETE_VALOR" type="text" class="caixa-texto-monet" id="FRETE_VALOR" onChange="f_calculos(this)" onKeyUp="verifica_separador(this,this.value)"  size="18" display="VALOR TOTAL" obrigatorio="1" secao="ctrc" hint="Valor Total do Frete"></td> 
                  </tr> 
                  <tr class="label1"> 
                     <td nowrap>Despacho:</td> 
                     <td nowrap><input name="DESPACHO" type="text" class="caixa-texto-monet" id="DESPACHO" onChange="f_calculos(this)" onKeyUp="verifica_separador(this,this.value)"  value="0.00" size="18" display="VALOR DESPACHO" obrigatorio="1" secao="ctrc" hint="Valor do despacho"></td> 
                     <td nowrap>Descontos:</td> 
                     <td nowrap><input name="DESCONTO" type="text" class="caixa-texto-monet" id="DESCONTO" onChange="f_calculos(this)" onKeyUp="verifica_separador(this,this.value)"  value="0.00" size="18" display="VALOR DESCONTOS" obrigatorio="1" secao="ctrc" hint="Valor para os descontos"></td> 
                     <td nowrap>Al&iacute;quota ICMS:</td> 
                     <td nowrap><input name="ALIQUOTA_ICMS" type="text" class="caixa-texto-monet" id="ALIQUOTA_ICMS" onChange="f_calculos(this)" value="0" size="18" display="ALQUOTA ICMS" obrigatorio="1" secao="ctrc" hint="Alquota ICMS"></td> 
                  </tr> 
                  <tr class="label1"> 
                     <td nowrap>Base Calc. ICMS: </td> 
                     <td nowrap><input name="BASE_CALCULO_ICMS" type="text" class="caixa-texto-monet" id="BASE_CALCULO_ICMS" onChange="f_calculos(this)" onKeyUp="verifica_separador(this,this.value)"  value="0.00" size="18" display="Base de Clculo do ICMS" obrigatorio="1" secao="ctrc" hint="Valor da base de clculo do ICMS"></td> 
                     <td nowrap>Valor ICMS: </td> 
                     <td nowrap><input name="VALOR_ICMS" type="text" class="caixa-texto-monet" id="VALOR_ICMS" value="0.00" size="18" readonly="yes" onKeyUp="verifica_separador(this,this.value)"  display="VALOR ICMS" obrigatorio="1" secao="ctrc" hint="Valor do ICMS"></td> 
                     <td nowrap>Total dos Servi&ccedil;os: </td> 
                     <td nowrap><input name="TOTAL_CONHECIMENTO" type="text" class="caixa-texto-monet" id="TOTAL_CONHECIMENTO" value="0.00" size="18" onKeyUp="verifica_separador(this,this.value)"  display="VALOR TOTAL DOS SERVIOS" obrigatorio="1" secao="ctrc" hint="Valor do total dos Servios"></td> 
                  </tr> 
                  <tr class="label1"> 
                     <td colspan="6" nowrap><div align="left">Observa&ccedil;&otilde;es:</div></td> 
                  </tr> 
                  <tr class="label1"> 
                     <td colspan="6" nowrap><textarea name="OBSERVACAO" rows="3" class="caixa_texto" id="OBSERVACAO" style="width:100% " hint="Digite as observaes"></textarea></td> 
                  </tr> 
                  <tr class="label1">
                     <td colspan="6"><div align="center">Inserir outro conhecimento neste mesmo lote?&nbsp;
                        <select name="AVANCAR" class="caixa_texto" id="AVANCAR" display="OUTRO CONHECIMENTO" obrigatorio="1" secao="ctrc" hint="Inserir outro conhecimento neste mesmo lote?">
                           <option selected>----</option>
                           <option value="true">Sim</option>
                           <option value="False">N&atilde;o</option>
                        </select> 
                     </div></td>
                  </tr>
                  <tr class="label1"> 
                     <td colspan="6"><div align="center">  
                           <button name="btn_novo" class="botao" style="width:180px " onClick="f_novo_ctrc(this)"><img src="../../../../imagens/botao/16x16/incluir.gif" width="13" height="16" align="absmiddle"> Confirmar
                           Conhecimento </button> 
						   <cfif IsDefined("vars.AVANCAR")>
                           	  <button <cfif vars.AVANCAR >disabled</cfif> name="btn_avancar" class="botao" style="width:180px " onClick="f_confirmar()"><img src="../../../../imagens/botao/16x16/avancar.gif" align="absmiddle">  Avan&ccedil;ar para Carta Frete</button>
  						   </cfif> 
                        </div></td> 
                  </tr> 
               </table> 
            </form>  
        </cfif> </td>  
   </tr> 
</table>  
</body>
</html>
<iframe name="consultas" height="500" width="100%"></iframe>
<iframe name="motorista" height="0" width="0"></iframe>
<iframe name="destinatario" height="0" width="0"></iframe>
<cfoutput>
	<script language="javascript1.2">
	window.onload = function() { 
								 f_controla_campos(1);  
								 <cfif Len(qrLote.CNPJ_CPF_DESTINATARIO) gt 0>
								 	with(document.form_conhecimento) {
										DEST_CNPJ.value = '#qrLote.CNPJ_CPF_DESTINATARIO#';
										f_consulta_destinatario();
										<cfif qrLote.LOTE_COM_DESTINATARIO eq 1>
											DEST_CNPJ.readOnly = true;
										</cfif>

									}
								 </cfif>
								 <cfif isDefined("vars.AVANCAR") and not vars.AVANCAR>
								 	f_consulta_destinatario();
								 </cfif>
								 document.form_conhecimento.DATA_EMISSAO.focus();
							   }
	
	</script>
</cfoutput>
