<!-- Consulta Remetente e inclui os dados para carga -->
<script language="javascript1.2">

function toCurrency(v_valor) {
	var partes = String(v_valor).split('.');
	if (partes[1]) {
		partes[1] = String(partes[1]);
		if(partes[1].length == 0) {
			partes[1] = '00';
		}
		if(partes[1].length == 1) {
			partes[1] = partes[1]+'0';
		}
		if(partes[1].length > 2) {
			partes[1] = partes[1].substr(0,2);
		}
		var dec = partes[1];
	} else {
		var dec = '00';
	}
	var result = 0;
	if (Math.round(v_valor) > v_valor) {
			result = (Math.round(v_valor)-1)+'.';
	} else {
			result = Math.round(v_valor)+'.';
	}
//	var dec = (((Math.round(v_valor*100) % 100)<10)?'0':'')+(Math.round(v_valor*100) % 100);
	return result+dec;
}

</script>

<cfif isDefined("vars.OPERACAO") and vars.OPERACAO EQ 1>
	<cfscript>
		conn = CreateObject("component","_transportes.consulta.cfc_pessoa");
		qrRemetente = conn.get_remetente_destinatario(codigo = vars.REM_CNPJ); 
	</cfscript>
	<cfif qrRemetente.RecordCount gt 0>
		<cfoutput>
			<script language="javascript1.2">
				with(parent.form_lote) {
					REM_RAZAO_SOCIAL.value = '#JSStringFormat(qrRemetente.RAZAO_SOCIAL)#';
					REM_COD_PESSOA.value = #qrRemetente.COD_PESSOA#;
					CARGA_CEP.value = '#qrRemetente.CEP#';
					CARGA_ENDERECO.value = '#JSStringFormat(qrRemetente.ENDERECO)#';
					CARGA_BAIRRO.value = '#JSStringFormat(qrRemetente.BAIRRO)#';
					CARGA_COMPLEMENTO.value = '#JSStringFormat(qrRemetente.COMPLEMENTO)#';
					CARGA_UF.value = '#JSStringFormat(qrRemetente.UF)#';
					CARGA_MUNICIPIO.value = '#JSStringFormat(qrRemetente.MUNICIPIO)#';
					COLETA_COD_UF.value = '#qrRemetente.COD_UF#';
					COLETA_COD_MUNICIPIO.value = '#qrRemetente.COD_MUNICIPIO#';
					COLETA_COD_DISTRITO.value = '#qrRemetente.COD_DISTRITO#';
					COLETA_COD_DV.value = '#qrRemetente.COD_DV#';
				}
			</script>
		</cfoutput>
	<cfelse>
			<script language="javascript1.2">
				with(parent.form_lote) 
					REM_RAZAO_SOCIAL.value = 'Remetente no encontrado.';
			</script>
	</cfif>
</cfif>
<!-- Consulta Destinatrio e inclui os dados para descarga -->
<cfif isDefined("vars.OPERACAO") and vars.OPERACAO EQ 22>
	<cfscript>
		conn_emissao_consult = CreateObject("component","_transportes.consulta.cfc_emissao_documentos");
		qrDestinatario = conn_emissao_consult.get_pessoa(cnpj_cpf = vars.DEST_CNPJ);
	</cfscript>
    <cfscript>
		if (vars.PAGO_POR eq 0) {
			qrICMS = conn_emissao_consult.get_icms(produto_id=vars.PRODUTO_ID,
									  cod_atividade=vars.COD_ATIVIDADE,
									  uf_origem = vars.COLETA_UF,
									  uf_destino = qrDestinatario.UF,
									  tomador_servico = vars.COLETA_UF);
		}
		else {
			qrICMS = conn_emissao_consult.get_icms(produto_id=vars.PRODUTO_ID,
									  cod_atividade= qrDestinatario.cod_atividade_fiscal,
									  uf_origem = vars.COLETA_UF,
									  uf_destino = qrDestinatario.UF ,
									  tomador_servico = qrDestinatario.UF);
	    }		
	</cfscript>
	<cfif qrDestinatario.RecordCount gt 0>
		<cfoutput>
			<script language="javascript1.2">
				with(parent.document.form_conhecimento) {
					DEST_RAZAO_SOCIAL.value = '#JSStringFormat(qrDestinatario.RAZAO_SOCIAL)#';
					COD_DESTINATARIO.value = #qrDestinatario.COD_PESSOA#;
					DESCARGA_CEP.value = '#qrDestinatario.CEP#';
					DESCARGA_ENDERECO.value = '#JSStringFormat(qrDestinatario.ENDERECO)#';
					DESCARGA_BAIRRO.value = '#JSStringFormat(qrDestinatario.BAIRRO)#';
					DESCARGA_COMPLEMENTO.value = '#JSStringFormat(qrDestinatario.COMPLEMENTO)#';
					DESCARGA_UF.value = '#JSStringFormat(qrDestinatario.UF)#';
					DESCARGA_MUNICIPIO.value = '#JSStringFormat(qrDestinatario.MUNICIPIO)#';					
					ENTREGA.value = '#JSStringFormat(qrDestinatario.MUNICIPIO)#';
					ENTREGA_UF.value = '#qrDestinatario.UF#';
					ENTREGA_COD_UF.value = #qrDestinatario.COD_UF#;
					ENTREGA_COD_MUNICIPIO.value = #qrDestinatario.COD_MUNICIPIO#;
					ENTREGA_COD_DISTRITO.value = #qrDestinatario.COD_DISTRITO#;
					ENTREGA_COD_DV.value = #qrDestinatario.COD_DV#;					
					// IBGE
					DEST_COD_UF.value = #qrDestinatario.COD_UF#;
					DEST_COD_MUNICIPIO.value = #qrDestinatario.COD_MUNICIPIO#;
					DEST_COD_DISTRITO.value = #qrDestinatario.COD_DISTRITO#;
					DEST_COD_DV.value = #qrDestinatario.COD_DV#;					
					// ICMS
					ALIQUOTA_ICMS.value = toCurrency(#qrICMS.aliquota_icms#);
					ST_ICMS_ID.value = '#qrICMS.st_icms_id#';					
					SITUACAO_TRIBUTARIA.value = '#qrICMS.st_icms_id#';					
					parent.v_calc_aliquota_icms = toCurrency(#qrICMS.aliquota_icms#);
				}
			</script>
		</cfoutput>
	<cfelse>
			<script language="javascript1.2">
				with(parent.form_lote) {
					DEST_RAZAO_SOCIAL.value = 'Destinatrio no encontrado.';
			</script>
	</cfif>
</cfif>
<!-- Consulta CEP - para CARGA -->
<cfif isDefined("vars.OPERACAO") and vars.OPERACAO EQ 3>
	<cfscript>
		conn_pessoas_consult = CreateObject("component","_transportes.consulta.cfc_pessoa");
		qrCarga = conn_pessoas_consult.getEndereco(cep = vars.CARGA_CEP);
	</cfscript>
	<cfif qrCarga.RecordCount gt 0>
		<cfoutput>
			<script language="javascript1.2">
				with(parent.form_lote) {
					CARGA_CEP.value = '#qrCarga.CEP#';
					CARGA_ENDERECO.value = '#JSStringFormat(qrCarga.LOGRADOURO)#';
					CARGA_BAIRRO.value = '#JSStringFormat(qrCarga.BAIRRO)#';
					CARGA_COMPLEMENTO.value = '';
					CARGA_UF.value = '#JSStringFormat(qrCarga.UF)#';
					CARGA_MUNICIPIO.value = '#JSStringFormat(qrCarga.LOCAL)#';
					COLETA_COD_UF.value = #qrCarga.COD_UF#;
					COLETA_COD_MUNICIPIO.value = #qrCarga.COD_MUNICIPIO#;
					COLETA_COD_DISTRITO.value = #qrCarga.COD_DISTRITO#;
					COLETA_COD_DV.value = #qrCarga.COD_DV#;
				}
			</script>
		</cfoutput>
	</cfif>
</cfif>

<!-- Consulta CEP - para DESCARGA -->
<cfif isDefined("vars.OPERACAO") and vars.OPERACAO EQ 4>
	<cfscript>
		conn_pessoas_consult = CreateObject("component","_transportes.consulta.cfc_pessoa");
		qrDescarga = conn_pessoas_consult.getEndereco(cep = vars.DESCARGA_CEP);
	</cfscript>
	<cfif qrDescarga.RecordCount gt 0>
		<cfoutput>
			<script language="javascript1.2">
				with(parent.document.form_conhecimento) {
					DESCARGA_CEP.value = '#qrDescarga.CEP#';
					DESCARGA_ENDERECO.value = '#JSStringFormat(qrDescarga.LOGRADOURO)#';
					DESCARGA_BAIRRO.value = '#JSStringFormat(qrDescarga.BAIRRO)#';
					DESCARGA_COMPLEMENTO.value = '';
					DESCARGA_UF.value = '#JSStringFormat(qrDescarga.UF)#';
					DESCARGA_MUNICIPIO.value = '#JSStringFormat(qrDescarga.LOCAL)#';
					ENTREGA_COD_UF.value = #qrDescarga.COD_UF#;
					ENTREGA_COD_MUNICIPIO.value = #qrDescarga.COD_MUNICIPIO#;
					ENTREGA_COD_DISTRITO.value = #qrDescarga.COD_DISTRITO#;
					ENTREGA_COD_DV.value = #qrDescarga.COD_DV#;
				}
			</script>
		</cfoutput>
	</cfif>
</cfif>

<!-- OPERACAO = 5 -->
<!-- Busca dados do servio contratado. -->
<cfif isDefined("vars.OPERACAO") and vars.OPERACAO EQ 5>
	<cfif Len(vars.PLACA_CONTROLE) and Len(vars.PLACA_REFERENCIA) and Len(vars.DATA_EMISSAO)>
		<cfscript>
			conn = CreateObject("component","_transportes.consulta.cfc_contrato_transporte");
			qrServico = conn.get_servico_contratado(p_placa=vars.PLACA_CONTROLE,p_data_emissao=vars.data_emissao);
			conn = CreateObject("component","_transportes.consulta.cfc_veiculo");
			v_capacidade = conn.get_capacidade(placa=vars.PLACA_CONTROLE);
			if (vars.PLACA_CONTROLE neq vars.PLACA_REFERENCIA) {
				conn_manip = CreateObject("component","_transportes.manipulacao.cfc_contrato_transporte");
				set_manipulacao = conn_manip.engata_composicao_terceiro(vars.PLACA_CONTROLE & ',' & vars.PLACA_REFERENCIA & ',' & vars.PLACA_SEGUNDA_CARRETA, 
				                                                        vars.DATA_EMISSAO);
				
				fnc_trata_erros(struct_erro = set_manipulacao,mostra_msg_ok=false);
				
				v_capacidade = conn.get_capacidade(placa=vars.PLACA_CONTROLE);
			}
		    v_verifica_composicao = conn.get_situacao_composicao(placa_controle = vars.PLACA_CONTROLE, 
		   														placa_referencia = vars.PLACA_REFERENCIA);
			fnc_trata_erros(struct_erro = v_verifica_composicao, mostra_msg_ok = false);
			</cfscript>
			<cfif qrServico.retorno neq 0>
				<script language="javascript1.2">
					with(parent.document.forms[0]) {
					  <cfoutput>
						// Servio contratado
						<cfif Len(qrServico.COD_PESSOA_MOTORISTA)>
							COD_PESSOA_MOTORISTA.value = '#qrServico.COD_PESSOA_MOTORISTA#';
							CPF_MOTORISTA.value = '#qrServico.CPF_MOTORISTA#';
							NOME_MOTORISTA.value = '#qrServico.NOME_MOTORISTA#';
							CNH_NUMERO.value = '#qrServico.CNH_NUMERO#';
							CNH_VALIDADE.value = '#DateFormat(qrServico.CNH_VALIDADE,'dd/mm/yyyy')#';
						<cfelse>
							NOME_MOTORISTA.value = '';							
						</cfif>
						<cfif qrServico.COD_PESSOA_PROPRIETARIO eq 1>
							alert('No podem ser emitidos contratos de transporte para veculos da frota. Impossvel prosseguir.');
							<cfabort/>
						</cfif>	
													
						COD_PESSOA_PROPRIETARIO.value = '#qrServico.COD_PESSOA_PROPRIETARIO#';
						NIT_PROPRIETARIO.value = '#qrServico.PIS_PASEP_NIT#';
						PROP_CNPJ_CPF.value = '#qrServico.CNPJ_PROP#';
						PROP_RAZAO_SOCIAL.value = '#qrServico.PROPRIETARIO#';
						PROP_ENDERECO.value = '#qrServico.ENDERECO#';
						PROP_UF.value = '#qrServico.UF#';
						CIDADE.value = '#qrServico.CIDADE#';
						PROPRIETARIO_COD_UF.value = '#qrServico.PROPRIETARIO_COD_UF#';
						PROPRIETARIO_COD_MUNICIPIO.value = '#qrServico.PROPRIETARIO_COD_MUNICIPIO#';
						PROPRIETARIO_COD_DISTRITO.value = '#qrServico.PROPRIETARIO_COD_DISTRITO#';
						PROPRIETARIO_COD_DV.value = '#qrServico.PROPRIETARIO_COD_DV#';
						PESO_CTRC.value = toCurrency(#v_capacidade#);
					//	parent.f_calculos('');
					  </cfoutput>
					}
			</script>
			<cfelse>
				<script language="javascript1.2">
					with(parent.document.form_conhecimento) {
					  <cfoutput>
						// Servio contratado
						NOME_MOTORISTA.value = 'Veculo no cadastrado, impossvel prosseguir.';
					  </cfoutput>
					}
				</script>
			</cfif> 
		</cfif>
</cfif>

<!-- OPERACAO = 6 -->
<!-- Busca dados do motorista. -->
<cfif isDefined("vars.OPERACAO") and vars.OPERACAO EQ 6>
	<cfscript>
		conn_pessoas_consult = CreateObject("component","_transportes.consulta.cfc_pessoa");
		qrPessoa = conn_pessoas_consult.getPessoa(cnpj_cpf = vars.CPF_MOTORISTA, completo=1);
	</cfscript>
	<script language="javascript1.2">
	// Motorista
	with(parent.document.forms[0]) {
		<cfif qrPessoa.RecordCount gt 0 >
			<cfoutput query="qrPessoa">
				COD_PESSOA_MOTORISTA.value = '#qrPessoa.COD_PESSOA#';
				CPF_MOTORISTA.value = '#qrPessoa.CNPJ_CPF#';
				NOME_MOTORISTA.value = '#qrPessoa.NOME#';
				CNH_NUMERO.value = '#qrPessoa.CNH#';
				CNH_VALIDADE.value = '#DateFormat(qrPessoa.validade_cnh,'dd/mm/yyyy')#';
			</cfoutput>
		<cfelse>
		       COD_PESSOA_MOTORISTA.value = 'N&atilde;o Encontrado !';
		</cfif>
	}
	</script>
</cfif>

<!-- Consulta CEP -->
<cfif isDefined("vars.OPERACAO") and vars.OPERACAO EQ 7>
	<cfscript>
		conn_pessoas_consult = CreateObject("component","_transportes.consulta.cfc_pessoa");
		qrDescarga = conn_pessoas_consult.get_endereco(cep = vars.DESCARGA_CEP);
	</cfscript>
	<cfif qrDescarga.RecordCount gt 0>
		<cfoutput>
			<script language="javascript1.2">
				with(parent.document.form_conhecimento) {
					DESCARGA_CEP.value = '#qrDescarga.CEP#';
					DESCARGA_ENDERECO.value = '#JSStringFormat(qrDescarga.LOGRADOURO)#';
					DESCARGA_BAIRRO.value = '#JSStringFormat(qrDescarga.BAIRRO)#';
					DESCARGA_COMPLEMENTO.value = '';
					DESCARGA_UF.value = '#JSStringFormat(qrDescarga.UF)#';
					DESCARGA_MUNICIPIO.value = '#JSStringFormat(qrDescarga.LOCAL)#';
					ENTREGA_COD_UF.value = #qrDescarga.COD_UF#;
					ENTREGA_COD_MUNICIPIO.value = #qrDescarga.COD_MUNICIPIO#;
					ENTREGA_COD_DISTRITO.value = #qrDescarga.COD_DISTRITO#;
					ENTREGA_COD_DV.value = #qrDescarga.COD_DV#;
				}
			</script>
		</cfoutput>
	</cfif>
</cfif>
<cfif isDefined("vars.OPERACAO") and vars.OPERACAO EQ 8>
	<cfscript>
		conn_pessoas_consult = CreateObject("component","_transportes.consulta.cfc_pessoa");
		qrDescarga = conn_pessoas_consult.get_endereco(cep = vars.CARGA_CEP);
	</cfscript>
	<cfif qrDescarga.RecordCount gt 0>
		<cfoutput>
			<script language="javascript1.2">
				with(parent.form_lote) {
					CARGA_CEP.value = '#qrDescarga.CEP#';
					CARGA_ENDERECO.value = '#JSStringFormat(qrDescarga.LOGRADOURO)#';
					CARGA_BAIRRO.value = '#JSStringFormat(qrDescarga.BAIRRO)#';
					CARGA_COMPLEMENTO.value = '';
					CARGA_UF.value = '#JSStringFormat(qrDescarga.UF)#';
					CARGA_MUNICIPIO.value = '#JSStringFormat(qrDescarga.LOCAL)#';
			}
			</script>
		</cfoutput>
	</cfif>
</cfif>
