<cfparam name="vars.FLAG_CONHECIMENTO" default="0">
<cfset vars.MUNICIPAL = 1>
<html>
<cfinclude template="/_scripts/scripts.cfm"/>
<cfscript>
	conn = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
	qrModelo = conn.get_modelo_nota(argumentCollection = vars);
	qrSerie  = conn.get_serie_nota(argumentCollection = vars, 
									documento_proprio = 1,
									cod_modelo = '01',
									cod_pessoa = session.cod_pessoa,
									cod_departamento = session.cod_departamento,
									cod_setor = session.cod_setor);
	qrSubSerie  = conn.get_sub_serie_nota(argumentCollection = vars);
	qrNatureza 	= conn.get_natureza();
	qrNaturezaOperacao = conn.get_natureza_operacao();
	qrEspecie  	= conn.get_especie();
	qrUnidade  	= conn.get_unidade();
	qrSituacaoTributaria = conn.get_situacao_tributaria();
	if (Len(Trim(session.cod_pessoa))and Len(Trim(session.cod_departamento))and Len(Trim(session.cod_setor))and Len(Trim(session.cod_centro_custo)))
	qrOrganograma = conn.get_organograma(cod_pessoa 		= session.cod_pessoa,
										 cod_departamento 	= session.cod_departamento,
				  						 cod_setor			= session.cod_setor,
										 cod_centro_custo 	= session.cod_centro_custo);
	conn = CreateComponent("_transportes.consulta.cfc_contrato_transporte");
	qrTipoFrete = conn.get_tipo_frete();
	qrRegraFiscal = conn.get_lote_regra_fiscal();
	
	conn = CreateComponent("_transportes.consulta.cfc_pessoa");
	qrEmitente = conn.get_pessoa_light(cod_pessoa = session.cod_pessoa);
</cfscript>
<script language="javascript1.2"> 
	
	// Configura botoes //
	parent.f_set_texto( 'titulo_aplicacao', '<cf_language>Controle de Documentos</cf_language>' );
	parent.f_set_texto( 'titulo_pagina', '<cf_language>Emisso de Nota fiscal de Servio (FRETE MUNICIPAL)</cf_language>' );

	parent.f_hidden('barra_botoes_top');
	parent.f_hidden('btn_editar');
	parent.f_hidden('btn_excluir');
	parent.f_hidden('btn_cancelar');
	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); } 

	// -------------------- // 
	function f_confirmar() {
		with(document.forms[0]) {
			target = 'consultas';
			REGRA_FISCAL_ID.value = REGRA_FISCAL.value;
			OPERACAO.value = 2;
			
			f_limpar_engates_brancos();
			<cfif isdefined("vars.terceiro") and vars.terceiro eq 1>
			if(!confirm('Ateno: A composio fornecida ser engatada. Deseja continuar mesmo assim?')) {
				return;
			}
			</cfif>
			<cfif isdefined("vars.frota_agregado") and len(trim(vars.frota_agregado))>
			if(VEICULO_PROPRIETARIO.value == 2 && Number(VALOR_SERVICO_AGREGADO.value) < Number(VALOR_ADIANTAMENTO_AGREGADO.value)) {
				alert('O valor de adiantamento do agregado no pode ser maior que o valor do servio!');
				return;
			}
			</cfif>
			action = 'confirma.cfm';					
			PLACA_REFERENCIA.value 				= f_get_placa_referencia();
			PLACA_REFERENCIA_COMPOSICAO.value 	= f_get_lista_engates();
			
		    if (Number(CONFIRMA.value) == 1) {
				if (f_verifica_form(document.forms[0])) {
				   f_habilita_todos_campos();
				   CONFIRMA.value = 0;
				   
				   submit();		
				<cfif isdefined("vars.terceiro") and vars.terceiro eq 1>
					setReadOnly['terceiro'](true);
				</cfif>
				}
			 } else { alert('O formulrio j foi confirmado. Aguarde...'); } 
		}
	}
	
	
	function f_get_lista_engates() {
		f_limpar_engates_brancos();
		v_placas = [];
		for(var i=0;i<v_placas_referencia.length;i++) {
			v_placas.push(v_placas_referencia[i].getValue());
		}
		return v_placas.toString();
	}
	function f_get_placa_referencia() {
		if(v_placas_referencia.length > 0) {
			return v_placas_referencia[0].getValue();
		} else {
			return document.forms[0].PLACA_CONTROLE.value;
		}
	}
	
	
	
	function f_busca_pessoa(p_destino) {
		with(document.forms[0]) {
			NewWindow('../consultas/localizar_pessoa.cfm?DESTINO='+p_destino,'pessoa',0,0,'yes');
		}
	}

	function f_busca_cidade(p_destino) {
		with(document.forms[0]) {
			NewWindow('../consultas/localizar_cidade.cfm?DESTINO='+p_destino,'cidade',0,0,'yes');
		}
	}	
	
	function f_busca_dado_veiculo(){ 
		with(document.forms[0]) {
			if(PLACA_CONTROLE.value == '')
				return;
			f_query_wddx("<cf_url>/_transportes/consulta/cfc_veiculo.cfc</cf_url>?method=get_motorista_proprietario",'PLACA_CONTROLE='+PLACA_CONTROLE.value+'&DATA_EMISSAO='+DATA_EMISSAO.value,f_busca_dado_veiculo_result);
		}
	}	
	
	function f_busca_dado_veiculo_result(obj){ //callback functions always take one argument. This is the result passed back from the server.
		if(obj.ajax.readyState == 4) { // Quando estiver tudo pronto.
			with(document.forms[0]) {
				COD_PROPRIETARIO.value  = obj.struct.cod_pessoa_proprietario;
				PROP_CNPJ_CPF.value 	= obj.struct.cnpj_prop;
				PROP_RAZAO_SOCIAL.value = obj.struct.proprietario;
				PROP_ENDERECO.value     = obj.struct.endereco;
				PROP_UF.value 			= obj.struct.uf;
				COD_MOTORISTA.value 	= obj.struct.cod_pessoa_motorista;
				MOTORISTA.value 		= obj.struct.nome_motorista;				
				NOME_MOTORISTA.value 	= obj.struct.nome_motorista;				
				return true;
			}	
		}	
	}
	parent.f_confirmar = f_confirmar;

	function f_busca_proprietario(){ 
		with(document.forms[0]) {
			if(PLACA_CONTROLE.value == '')
				return;
			f_query_wddx("<cf_url>/_transportes/consulta/cfc_veiculo.cfc</cf_url>?method=get_motorista_proprietario",'PLACA_CONTROLE='+PLACA_CONTROLE.value+'&DATA_EMISSAO='+DATA_EMISSAO.value,f_busca_proprietario_result);
		}
	}	
	
	function f_busca_proprietario_result(obj){ //callback functions always take one argument. This is the result passed back from the server.
		if(obj.ajax.readyState == 4) { // Quando estiver tudo pronto.
			with(document.forms[0]) {
				COD_PROPRIETARIO.value  = obj.struct.cod_pessoa_proprietario;
				PROP_CNPJ_CPF.value 	= obj.struct.cnpj_prop;
				PROPRIETARIO.value      = obj.struct.proprietario;
				PROP_RAZAO_SOCIAL.value = obj.struct.proprietario;				
				PROP_ENDERECO.value     = obj.struct.endereco;
				PROP_UF.value 			= obj.struct.uf;
				return true;
			}	
		}	
	}

	function f_busca_composicao(p_busca_item) {
		with(document.forms[0]) {
			if(PLACA_CONTROLE.value == '') {
				PLACA_REFERENCIA.value 		= '';
				VEICULO_PROPRIETARIO.value 	= '';
				COD_PROPRIETARIO.value  	= '';
				PROP_CNPJ_CPF.value 		= '';
				PROP_RAZAO_SOCIAL.value 	= '';
				PROP_ENDERECO.value     	= '';
				PROP_UF.value 				= '';
				COD_MOTORISTA.value 		= '';
				MOTORISTA.value 			= '';			
				NOME_MOTORISTA.value		= '';
				return;
			}
			f_busca_dado_veiculo();
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_veiculo.cfc</cf_url>?method=get_composicao'
						,'cod_veiculo='+PLACA_CONTROLE.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								with(document.forms[0]) {
									VEICULO_PROPRIETARIO.value = 1;
									if(obj.struct.cod_veiculo.length == 0) {
										alert('Veiculo no cadastrado!');
										PLACA_REFERENCIA.value = '';
										PLACA_CONTROLE.select();
										return;
									}
								<cfif isdefined("vars.terceiro") and vars.terceiro eq 1>
									if(obj.struct.veiculo_proprietario[0] != 3) {
										alert('Apenas veiculos de Terceiros podem ser selecionados como cavalo para esta emisso!');
										PLACA_CONTROLE.value = '';
										PLACA_CONTROLE.select();
										return;
									}
								</cfif>
									PLACA_CONTROLE.value = obj.struct.placa[0];
									f_limpar_engates();
									
									for (var i=1;i<obj.struct.placa.length;i++) {
										v_obj = f_engata();
										v_obj.setValue(obj.struct.placa[i]);
									}
									
									if (obj.struct.veiculo_proprietario[0] == 2) {
									   VEICULO_PROPRIETARIO.value = 2;
									}	
									else 
									if (p_busca_item) 
									   f_busca_romaneio_item();						
									<cfif isdefined("vars.placa_tracao")>
									setReadOnly['composicao'](true);
									</cfif>			
									VEICULO_PROPRIETARIO.value = 	obj.struct.veiculo_proprietario[0];					   		   
								}
							}
						});			
		}
	}
	
	function f_busca_conhecimento() {
		f_busca_nfs();
	}
	
	function f_busca_nfs() {
		with(document.forms[0]) {
			f_limpar_NOTAS_FISCAIS();
			f_query_wddx("<cf_url>/_transportes/consulta/cfc_emissao_documentos.cfc</cf_url>?method=get_conhecimento_nota_fiscal",
							 'NF_ES_ID=' + NF_ES_ID.value
							 ,function(obj) {
								if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
									f_limpar_NOTAS_FISCAIS();
									for(var i=0;i<obj.struct.NF_ES_ID.length;i++) {
										f_incluir_NOTAS_FISCAIS();
										NOTA_NUMERO.value             = obj.struct.numero[i];
										NOTA_MODELO.value             = obj.struct.modelo[i];
										NOTA_MODELO.onchange();
										NOTA_SERIE.value              = obj.struct.serie[i];
										NOTA_SERIE.onchange();
										NOTA_SUB_SERIE.value          = obj.struct.sub_serie[i];
										NOTA_DATA_EMISSAO.value       = obj.struct.data_emissao_data[i];
										NOTA_VALOR.value              = toCurrency(obj.struct.valor_total[i]);
										NOTA_VALOR_SEGURADO.value     = obj.struct.valor_segurado[i];
										NOTA_ORDEM_COMPRA.value       = obj.struct.ordem_compra_cliente[i];
										NOTA_QTDE_VOLUME.value        = obj.struct.qtde_volume[i];
										NOTA_COD_UNIDADE.value        = obj.struct.cod_unidade[i];
										NOTA_M3.value                 = obj.struct.m3[i];
										NOTA_NUM_NATUREZA.value       = obj.struct.num_natureza[i];
										NOTA_NATUREZA.value           = obj.struct.natureza[i];
										NOTA_COMPLEMENTO.value        = obj.struct.complemento[i];
										NOTA_NUM_ESPECIE.value        = obj.struct.num_especie[i];
										NOTA_ESPECIE.value            = obj.struct.especie[i];
										NOTA_ALTURA.value             = (obj.struct.altura[i] == '')?'0':obj.struct.altura[i];
										NOTA_LARGURA.value            = (obj.struct.largura[i] == '')?'0':obj.struct.largura[i];
										NOTA_COMPRIMENTO.value        = (obj.struct.comprimento[i] == '')?'0':obj.struct.comprimento[i];
										NOTA_CUBAGEM.value            = obj.struct.cubagem[i];
										NOTA_PESO.value               = obj.struct.peso[i];
										NOTA_PESO_CUBADO.value        = obj.struct.peso_cubado[i];
										NOTA_PESO_KG_CONVERTIDO.value = obj.struct.peso_kg_convertido[i];
										NOTA_PESO_COBRADO.value       = obj.struct.peso_cobrado[i];									
										f_calcula_cubagem();
										f_salvar_NOTAS_FISCAIS();
									}
									f_busca_conhecimento_dados();
								}
							 });
		}
	}	
	v_cnpj_ordem = '';
	function f_busca_conhecimento_dados(){ 
		with(document.forms[0]) {
			f_query_wddx("<cf_url>/_transportes/consulta/cfc_emissao_documentos.cfc</cf_url>?method=get_conhecimento_dados",
						 'NF_ES_ID=' + NF_ES_ID.value 
						 ,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.NUM_NOTA_FISCAL.length > 0) {

								  // Dados Gerais
								  	v_proprietario_tracao = obj.struct.proprietario_tracao[0];
									NF_ES_ID.value		= obj.struct.NF_ES_ID[0];
									NUM_NOTA_FISCAL.value		= obj.struct.NUM_NOTA_FISCAL[0];
									SERIE.value					= obj.struct.serie[0];
									DATA_EMISSAO.value			= obj.struct.data_emissao_data_hora[0];
									COD_ORGANOGRAMA_GERENCIAL.value = obj.struct.cod_organograma_gerencial[0];
									PAGADOR.value				= obj.struct.pagador[0];
									PLACA_CONTROLE.value 		= obj.struct.placa_tracao[0];
									PLACA_REFERENCIA.value 		= obj.struct.placa[0];
									
									REGRA_FISCAL.value			= obj.struct.regra_fiscal_id[0];
									REGRA_FISCAL_ID.value		= obj.struct.regra_fiscal_id[0];
									
									f_limpar_engates();
									if (obj.struct.placa[0] != '' && obj.struct.placa[0] != obj.struct.placa_tracao[0]) {
										v_obj = f_engata();
										v_obj.setValue(obj.struct.placa[0]);
									}
									
									COD_PROPRIETARIO.value 		= obj.struct.cod_proprietario[0];
									PROP_CNPJ_CPF.value 		= obj.struct.prop_cnpj_cpf[0];
									PROP_RAZAO_SOCIAL.value 	= obj.struct.prop_razao_social[0];
									PROP_ENDERECO.value 		= obj.struct.prop_endereco[0];
									PROP_UF.value 				= obj.struct.prop_uf[0];
									COD_MOTORISTA.value 		= obj.struct.cod_motorista[0];
									NOME_MOTORISTA.value 		= obj.struct.nome_motorista[0];
									
									NUM_ROMANEIO.value			= obj.struct.num_romaneio[0];
									ITEM_ID.value				= obj.struct.item_id[0];
									
									COD_PESSOA_FILIAL.value		= obj.struct.cod_pessoa_filial[0];
									COD_DEPARTAMENTO.value		= obj.struct.cod_departamento[0];
									COD_SETOR.value				= obj.struct.cod_setor[0];
									COD_CENTRO_CUSTO.value		= obj.struct.cod_centro_custo[0];
									
									CFOP_ID.value 				= obj.struct.cfop_id[0];
									CFOP.value 					= obj.struct.cfop[0];
									NATUREZA_OPERACAO.value		= obj.struct.natureza_operacao[0];
									M3.value					= obj.struct.m3[0];
									SITUACAO_ID.value			= obj.struct.situacao_id[0];
									
									IMPRESSO.value				= obj.struct.impresso[0];
									ENTRADA_DADOS.value			= obj.struct.entrada_dados[0];
									TEM_NOTA.value				= 0
									
									NUM_PRODUTO.value 			= obj.struct.num_produto[0];
									NUM_PRODUTO.onchange();
									ST_ICMS_ID.value 			= obj.struct.st_icms_id[0];
									ST_ORIGEM_ID.value 			= obj.struct.st_origem_id[0];
									REGRA_FISCAL_ID.value 		= obj.struct.regra_fiscal_id[0];
									PAGADOR.value 				= obj.struct.pagador[0];
									MOTORISTA.value 			= obj.struct.nome_motorista[0];
									PRAZO_ENTREGA.value			= obj.struct.prazo_entrega_data[0]
									VOLUME.value 				= obj.struct.volume[0];
									NUM_NATUREZA.value			= obj.struct.num_natureza[0];
									NUM_NATUREZA.onchange();
									NUM_ESPECIE.value			= obj.struct.num_especie[0];
									NUM_ESPECIE.onchange();
									RODAPE.value				= obj.struct.rodape[0];
									
									// Coleta
									COLETA_LOGRADOURO.value		= obj.struct.coleta_logradouro[0];
									COLETA_COMPLEMENTO.value	= obj.struct.coleta_complemento[0];
									COLETA_BAIRRO.value			= obj.struct.coleta_bairro[0];
									COLETA_CEP.value			= obj.struct.coleta_cep[0];
									COLETA_MUNICIPIO.value		= obj.struct.coleta_municipio[0];
									COLETA_UF.value 			= obj.struct.coleta_uf[0];
									COLETA_MUNICIPIO_ID.value 	= obj.struct.coleta_municipio_id;
									
									// Entrega
									ENTREGA_LOGRADOURO.value	= obj.struct.entrega_logradouro[0];
									ENTREGA_COMPLEMENTO.value	= obj.struct.entrega_complemento[0];
									ENTREGA_BAIRRO.value		= obj.struct.entrega_bairro[0];
									ENTREGA_CEP.value			= obj.struct.entrega_cep[0];
									ENTREGA_MUNICIPIO.value 	= obj.struct.entrega_municipio[0];
									ENTREGA_UF.value 			= obj.struct.entrega_uf[0];
									ENTREGA_MUNICIPIO_ID.value 	= obj.struct.entrega_municipio_id[0];
									
									// Rementente
									COD_REMETENTE.value 		= obj.struct.cod_remetente[0];
									REM_CNPJ_CPF.value 			= obj.struct.rem_cnpj_cpf[0];
									REM_RAZAO_SOCIAL.value 		= obj.struct.rem_razao_social[0];
									REM_INSCRICAO_ESTADUAL.value = obj.struct.rem_inscricao_estadual[0];
									REM_ENDERECO.value 			= obj.struct.rem_endereco[0];
									REM_CEP.value 				= obj.struct.rem_cep[0];
									REM_MUNICIPIO.value 		= obj.struct.rem_municipio[0];
									REM_UF.value 				= obj.struct.rem_uf[0];
									
									// Destinatario
									COD_DESTINATARIO.value 		= obj.struct.cod_destinatario[0];
									DEST_CNPJ_CPF.value 		= obj.struct.dest_cnpj_cpf[0];
									DEST_RAZAO_SOCIAL.value 	= obj.struct.dest_razao_social[0];
									DEST_INSCRICAO_ESTADUAL.value = obj.struct.dest_inscricao_estadual[0];
									DEST_ENDERECO.value 		= obj.struct.dest_endereco[0];
									DEST_CEP.value 				= obj.struct.dest_cep[0];
									DEST_MUNICIPIO.value 		= obj.struct.dest_municipio[0];
									DEST_UF.value 				= obj.struct.dest_uf[0];
									
									// Consignatario
									COD_CONSIGNATARIO.value 	= obj.struct.cod_consignatario[0];
									CONS_CNPJ_CPF.value 		= obj.struct.cons_cnpj_cpf[0];
									CONS_RAZAO_SOCIAL.value 	= obj.struct.cons_razao_social[0];
									CONS_INSCRICAO_ESTADUAL.value = obj.struct.cons_inscricao_estadual[0];
									CONS_ENDERECO.value 		= obj.struct.cons_endereco[0];
									CONS_CEP.value 				= obj.struct.cons_cep[0];
									CONS_MUNICIPIO.value 		= obj.struct.cons_municipio[0];
									CONS_UF.value 				= obj.struct.cons_uf[0];

									// Consignatario
									COD_REDESPACHO.value 	= obj.struct.cod_redespacho[0];
									RED_CNPJ_CPF.value 		= obj.struct.red_cnpj_cpf[0];
									RED_RAZAO_SOCIAL.value 	= obj.struct.red_razao_social[0];
									RED_INSCRICAO_ESTADUAL.value = obj.struct.red_inscricao_estadual[0];
									RED_ENDERECO.value 		= obj.struct.red_endereco[0];
									RED_CEP.value 				= obj.struct.red_cep[0];
									RED_MUNICIPIO.value 		= obj.struct.red_municipio[0];
									RED_UF.value 				= obj.struct.red_uf[0];
									
									// Cliente Cobranca
									COD_CLIENTE_COBRANCA.value 	= obj.struct.cod_cliente_cobranca[0];
									COB_CNPJ_CPF.value 			= obj.struct.cob_cnpj_cpf[0];
									COB_RAZAO_SOCIAL.value 		= obj.struct.cob_razao_social[0];
									COB_INSCRICAO_ESTADUAL.value = obj.struct.cob_inscricao_estadual[0];
									COB_ENDERECO.value 			= obj.struct.cob_endereco[0];
									COB_CEP.value 				= obj.struct.cob_cep[0];
									COB_MUNICIPIO.value 		= obj.struct.cob_municipio[0];
									COB_UF.value 				= obj.struct.cob_uf[0];
									
									ADEME.value					= obj.struct.ademe[0];
									DESCONTO.value				= obj.struct.desconto[0];
									IMPOSTOS.value				= obj.struct.impostos[0];
									DESPACHO_CALC.value			= obj.struct.despacho[0];
									PEDAGIO_CALC.value			= obj.struct.pedagio[0];
									SEC_CAT_CALC.value			= obj.struct.sec_cat[0];
									GRIS_CALC.value				= obj.struct.gris[0];
									COLETA_ENTREGA_CALC.value	= obj.struct.coleta_entrega[0];
									DESPACHO.value				= obj.struct.despacho[0];
									PEDAGIO.value				= obj.struct.pedagio[0];
									SEC_CAT.value				= obj.struct.sec_cat[0];
									GRIS.value					= obj.struct.gris[0];
									COLETA_ENTREGA.value		= obj.struct.coleta_entrega[0];
									FRETE_UNITARIO.value		= obj.struct.frete_unitario[0];
									FRETE_UNITARIO_DESC.value	= obj.struct.frete_unitario[0];
									FRETE_PESO.value			= obj.struct.frete_peso[0];
									FRETE_VALOR.value			= obj.struct.frete_valor[0];
									BASE_CALCULO_ICMS.value		= obj.struct.base_calculo_icms[0];
									ALIQUOTA_ICMS.value			= obj.struct.aliquota_icms[0];
									VALOR_ICMS.value			= obj.struct.valor_icms[0];
									TOTAL_CONHECIMENTO.value	= obj.struct.total_conhecimento[0];
									VALOR_ICMS_SUBSTIT.value	= obj.struct.valor_icms_substit[0];
									
									if (NUM_PRODUTO.value == 268) {
										BASE_CALCULO_ICMS.value		= obj.struct.base_calculo_iss[0];
										ALIQUOTA_ICMS.value			= obj.struct.aliquota_iss[0];
										VALOR_ICMS.value			= obj.struct.valor_iss[0];
									}
									
									if ( obj.struct.valor_icms_substit[0] > 0) 
										document.getElementById("tr_icms_substit").style.display = '';
									else
										document.getElementById("tr_icms_substit").style.display = 'none';
									
									v_cnpj_ordem = obj.struct.cnpj_ordem[0];
									f_on_busca_conhecimento();
									if (OPERACAO_ID.value == '') {
										document.getElementById('btn_buscar_lote').click();			
										document.getElementById('btn_buscar_lote').style.display = '';
									}
								}
								else {
								 alert('Conhecimento no encontrado!');
								 f_incluir();
								 
								}
							}
						});
		}
	}	
	function f_on_busca_conhecimento() {
	}

	var setReadOnly = [];

	setReadOnly['complemento'] = function(value) {
		with(document.forms[0]) {
			IMPRESSO.value 						= 0;
			OPERACAO_ID.readOnly 					= value;
			COD_ORGANOGRAMA_GERENCIAL.disabled 	= value;
			REGRA_FISCAL_ID.disabled			= value;
			REGRA_FISCAL.disabled				= value;
			NUM_PRODUTO.disabled				= value;
			PLACA_CONTROLE.readOnly				= value;
			PLACA_REFERENCIA.readOnly			= value;
			setReadOnly['composicao'](true);
			setReadOnly['NOTAS_FISCAIS'](true);
			setReadOnly['mercadorias_dados'](true);
			setReadOnly['mercadorias_calculos'](false);
			FRETE_UNITARIO_DESC.readOnly =  true;
			ALIQUOTA_ICMS.readOnly = true;
		}
	}	

	setReadOnly['frota_agregado'] = function(value) {
		with(document.forms[0]) {
			OPERACAO_ID.readOnly 					= value;
			REGRA_FISCAL_ID.disabled			= value;
			REGRA_FISCAL.disabled				= value;
			PAGADOR.disabled					= value;
			NUM_PRODUTO.disabled				= value;
			PLACA_CONTROLE.readOnly				= value;
			PLACA_REFERENCIA.readOnly			= value;
			setReadOnly['REM'](true);
			setReadOnly['RED'](true);
			setReadOnly['composicao'](true);
		}
	}	
	
	setReadOnly['subcontratado'] = function(value) {
		with(document.forms[0]) {
			OPERACAO_ID.readOnly 					= value;
			COD_ORGANOGRAMA_GERENCIAL.disabled 	= value;
			REGRA_FISCAL_ID.disabled			= value;
			PAGADOR.disabled					= value;
			NUM_PRODUTO.disabled				= value;
			PLACA_CONTROLE.readOnly				= value;
			PLACA_REFERENCIA.readOnly			= value;
			setReadOnly['rem_dest'](true);
			setReadOnly['NOTAS_FISCAIS'](true);
			setReadOnly['mercadorias_dados'](true);
			setReadOnly['composicao'](true);
			REGRA_FISCAL.disabled = true;
			DATA_EMISSAO.readOnly = true;
			document.getElementById('btn_data_emissao').style.display = 'none';
			PRAZO_ENTREGA.readOnly = true;
			document.getElementById('btn_prazo_entrega').style.display = 'none';
			PESO.readOnly =  true;
			COD_UNIDADE.disabled = true;
			ALIQUOTA_ICMS.readOnly = true;
		}
	}		
	
	setReadOnly['terceiro'] = function(value) {
		with(document.forms[0]) {
			REGRA_FISCAL.disabled = value;
			PAGADOR.disabled = value;
			NUM_PRODUTO.disabled = value;
			setReadOnly['REM'](value);
		}
	}

	function f_busca_operacao() {
		with(document.forms[0]) {
			if (OPERACAO_ID.value == '' && VIAGEM_CARGA_ID.value == '') {
				return;
			}
			if (CONHECIMENTO_ID.value != '') {
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_emissao_documentos.cfc</cf_url>?method=get_operacao_ctrc'
						,'operacao_id='+OPERACAO_ID.value + '&viagem_carga_id='+VIAGEM_CARGA_ID.value
						,function (obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								with(document.forms[0]) {	
									if(obj.struct.operacao_id.length == 1) {
										OPERACAO_ID.value 		    = obj.struct.operacao_id[0];
										document.getElementById('dv_operacao').innerHTML = obj.struct.operacao[0];
										NUM_PRODUTO.value 			= obj.struct.num_produto[0];
										REGRA_FISCAL.value 			= obj.struct.regra_fiscal_id[0];
										REGRA_FISCAL_ID.value 		= obj.struct.regra_fiscal_id[0];
										ENTREGA_MUNICIPIO_ID.value	= obj.struct.entrega_municipio_id[0];
										COD_ATIVIDADE.value			= obj.struct.cod_atividade_fiscal[0];
										PAGADOR.value				= obj.struct.frete_por_conta[0];

										
										COD_REMETENTE.value			= obj.struct.cod_remetente[0];
										REM_CNPJ_CPF.value			= obj.struct.rem_cnpj_cpf[0];
										REM_RAZAO_SOCIAL.value		= obj.struct.rem_razao_social[0];
										REM_INSCRICAO_ESTADUAL.value= obj.struct.rem_inscricao_estadual[0];
										REM_CEP.value				= obj.struct.rem_cep[0];
										REM_ENDERECO.value			= obj.struct.rem_logradouro[0];
										REM_ENDERECO_NUM.value		= obj.struct.rem_numero[0];
										REM_BAIRRO.value			= obj.struct.rem_bairro[0];

										REM_MUNICIPIO.value			= obj.struct.rem_municipio[0];
										REM_MUNICIPIO_ID.value		= obj.struct.rem_municipio_id[0];
										REM_UF.value				= obj.struct.rem_uf[0];
									
										COD_DESTINATARIO.value		= obj.struct.cod_destinatario[0];
										DEST_CNPJ_CPF.value			= obj.struct.dest_cnpj_cpf[0];
										DEST_RAZAO_SOCIAL.value		= obj.struct.dest_razao_social[0];
										DEST_INSCRICAO_ESTADUAL.value= obj.struct.dest_inscricao_estadual[0];
										DEST_CEP.value				= obj.struct.dest_cep[0];

										DEST_ENDERECO.value			= obj.struct.dest_logradouro[0];
										DEST_ENDERECO_NUM.value		= obj.struct.dest_numero[0];
										DEST_BAIRRO.value			= obj.struct.dest_bairro[0];
										DEST_MUNICIPIO_ID.value		= obj.struct.dest_municipio_id[0];
										DEST_MUNICIPIO.value		= obj.struct.dest_municipio[0];
										DEST_UF.value				= obj.struct.dest_uf[0];
										
										if(obj.struct.cod_cliente_cobranca[0] == '') {
											if (obj.struct.frete_por_conta[0] == 0) {
												COD_CLIENTE_COBRANCA.value	= obj.struct.cod_remetente[0];
												COB_CNPJ_CPF.value			= obj.struct.rem_cnpj_cpf[0];
												COB_RAZAO_SOCIAL.value		= obj.struct.rem_razao_social[0];
												COB_INSCRICAO_ESTADUAL.value= obj.struct.rem_inscricao_estadual[0];
												COB_CEP.value				= obj.struct.rem_cep[0];
												COB_ENDERECO.value			= obj.struct.rem_endereco[0];
												COB_MUNICIPIO.value			= obj.struct.rem_municipio[0];
												COB_UF.value				= obj.struct.rem_uf[0];
											} else {
												COD_CLIENTE_COBRANCA.value	= obj.struct.cod_destinatario[0];
												COB_CNPJ_CPF.value			= obj.struct.dest_cnpj_cpf[0];
												COB_RAZAO_SOCIAL.value		= obj.struct.dest_razao_social[0];
												COB_INSCRICAO_ESTADUAL.value= obj.struct.dest_inscricao_estadual[0];
												COB_CEP.value				= obj.struct.dest_cep[0];
												COB_ENDERECO.value			= obj.struct.dest_endereco[0];
												COB_MUNICIPIO.value			= obj.struct.dest_municipio[0];
												COB_UF.value				= obj.struct.dest_uf[0];
											}
										} else {
											COD_CLIENTE_COBRANCA.value	= obj.struct.cod_cliente_cobranca[0];
											COB_CNPJ_CPF.value			= obj.struct.cob_cnpj_cpf[0];
											COB_RAZAO_SOCIAL.value		= obj.struct.cob_razao_social[0];
											COB_INSCRICAO_ESTADUAL.value= obj.struct.cob_inscricao_estadual[0];
											COB_CEP.value				= obj.struct.cob_cep[0];
											COB_ENDERECO.value			= obj.struct.cob_endereco[0];
											COB_MUNICIPIO.value			= obj.struct.cob_municipio[0];
											COB_UF.value				= obj.struct.cob_uf[0];
										}

										if(obj.struct.cod_negociador[0]) {
												COD_NEGOCIADOR.value	= obj.struct.cod_negociador[0];
												NEG_CNPJ_CPF.value			= obj.struct.neg_cnpj_cpf[0];
												NEG_RAZAO_SOCIAL.value		= obj.struct.neg_razao_social[0];
												NEG_INSCRICAO_ESTADUAL.value= obj.struct.neg_inscricao_estadual[0];
												NEG_CEP.value				= obj.struct.neg_cep[0];
												NEG_ENDERECO.value			= obj.struct.neg_endereco[0];
												NEG_MUNICIPIO.value			= obj.struct.neg_municipio[0];
												NEG_UF.value				= obj.struct.neg_uf[0];
										}
										
										if (!COLETA_CEP.value) {
											COLETA_CEP.value			= obj.struct.coleta_cep[0];
											COLETA_LOGRADOURO.value		= obj.struct.coleta_logradouro[0];
											COLETA_COMPLEMENTO.value	= obj.struct.coleta_complemento[0];
											COLETA_BAIRRO.value			= obj.struct.coleta_bairro[0];
											COLETA_MUNICIPIO.value		= obj.struct.coleta_municipio[0];
											COLETA_UF.value				= obj.struct.coleta_uf[0];
											COLETA_MUNICIPIO_ID.value	= obj.struct.coleta_municipio_id[0];
										}
										<cfif not isdefined("vars.terceiro") and not isdefined("vars.complemento") >
											if (MUNICIPIO_ID_ORIGEM) {
												if (ITEM_ID.value == '00' && Number(ENTREGAS.value) == 1) {
													if (MUNICIPIO_ID_ORIGEM.value != COLETA_MUNICIPIO_ID.value) {
														alert('Problema na integridade das rotas. Origem do CTRC  ( ' + COLETA_MUNICIPIO.value + '-' + COLETA_UF.value + ') difere do destino da ultima rota do veculo ( '+ MUNICIPIO_ORIGEM.value +' ). Altere o local de coleta ou o lote.');
														document.getElementById('btn_buscar_lote').click();
													}						
												}					
											}
										</cfif>
										
										if (!ENTREGA_CEP.value) {
											ENTREGA_CEP.value			= obj.struct.entrega_cep[0];
											ENTREGA_LOGRADOURO.value	= obj.struct.entrega_logradouro[0];
											ENTREGA_COMPLEMENTO.value	= obj.struct.entrega_complemento[0];
											ENTREGA_BAIRRO.value		= obj.struct.entrega_bairro[0];
											ENTREGA_MUNICIPIO.value		= obj.struct.entrega_municipio[0];
											ENTREGA_UF.value			= obj.struct.entrega_uf[0];
											ENTREGA_MUNICIPIO_ID.value	= obj.struct.entrega_municipio_id[0];
										}
										NUM_NATUREZA.value			= obj.struct.num_natureza[0];
										NUM_NATUREZA.onchange();
										NUM_ESPECIE.value			= obj.struct.num_especie[0];
										NUM_ESPECIE.onchange();
										COD_UNIDADE.value			= obj.struct.cod_unidade[0];

										v_num_natureza_notas		= obj.struct.num_natureza[0];
										v_num_especie_notas			= obj.struct.num_especie[0];
										v_cod_unidade_notas			= obj.struct.cod_unidade[0];
										
										MOTORISTA.value				= obj.struct.motorista_nome[0];
										COD_MOTORISTA.value 		= obj.struct.motorista[0];
										f_limpar_engates();
										PLACA_CONTROLE.value =  '';
										if (obj.struct.composicao[0].length) {
											v_placas_viagem = obj.struct.composicao[0].split(' > ');
											for (var i=0; i<v_placas_viagem.length; i++){
											    if (i==0) {
													PLACA_CONTROLE.value =  v_placas_viagem[i];
													f_busca_proprietario();
												} else {
													f_engata();
													f_seta_placa_referencia(v_placas_viagem[i],i);
												}
											}
										}
										
										f_incluir_NOTAS_FISCAIS();
										
									} else {
										alert('Operao/Viagem no encontrado!')
										OPERACAO_ID.select();
									}
								}
							}
						});
		}
	}
		
	function f_seta_placa_controle(value) {
		with(document.forms[0]) {
			PLACA_CONTROLE.value = value;
			PLACA_CONTROLE.onchange();
		}
	}
	function f_seta_placa_referencia(value,idx) {
		with(document.forms[0]) {
			try {
				document.getElementById('PLACA_REFERENCIA_'+idx).value = value;
			} catch(e) {}
		}
	}
	function f_seta_placa_referencia2(value) {
		with(document.forms[0]) {
			PLACA_REFERENCIA2.value = value;
		}
	}
	
	function f_none() {
		
	}
	
	v_placas_referencia = [];
	function f_engata() {
		v_obj = new PlacaReferencia(document.getElementById('sp_placa_referencia'),v_placas_referencia.length+1);
		v_placas_referencia.push(v_obj);
		return v_obj;
	}
	
	function f_desengata() {
		if (v_placas_referencia.length > 0) {
			v_placas_referencia[v_placas_referencia.length-1].destroy();
			v_placas_referencia.pop();
			return true;
		}
		return false;
	}
	function f_limpar_engates() {
		while(f_desengata());
	}
	function f_limpar_engates_brancos() {
		for(var i=v_placas_referencia.length-1;i>=0;i--) {
			if(v_placas_referencia[i].getValue().replace(/ /g,'') == '') {
				v_placas_referencia[i].destroy();
				v_placas_referencia.splice(i,1);
			}
		}
	}
	function PlacaReferencia (group,index) {
		this.group = group;
		this.index = index;
		this.obj = document.createElement('nobr');
		this.input = document.createElement('input');
		with(this.input) {
			style.width = '75px';
			name		= 'PLACA_REFERENCIA_INTERNA';
			type		= 'text';
			id			= 'PLACA_REFERENCIA_'+index;
			onkeypress	= function () {
				return f_formata(this,event,'AAAAAAAAAAAAAAAA');
			}
			obrigatorio	= 0
			display		= 'PLACA DE REFERENCIA';
		}
		this.obj.appendChild(this.input);
		this.btnLocalizar = document.createElement('button');
		with(this.btnLocalizar) {
			idx = index;
			onclick = function () {
				NewWindow('/_consultas/localizar_veiculo.cfm?proprietario=3&placa=PLACA_REFERENCIA&funcao=f_seta_placa_referencia(PLACA_REFERENCIA.value,'+index+')','_blank',800,600,'yes');
			}
			className = "botao-16x16";
		}
		this.btnLocalizarIMG = document.createElement('img');
		with (this.btnLocalizarIMG) {
			src = "/_imagens/botoes/16x16/buscar.gif";
			alt = "Buscar Veculo";
			width = "16";
			height="16";
			align="absmiddle";
		}
		this.btnLocalizar.appendChild(this.btnLocalizarIMG);
		this.obj.appendChild(this.btnLocalizar);
		this.btnCadastrar = document.createElement('button');
		with(this.btnCadastrar) {
			idx = index;
			onclick = function () {
				f_abrir_janela('/aplicacoes/cadastros/veiculos/principal.cfm?funcao_end=f_incluir()','f_seta_placa_referencia(f_get_placa_veiculo(),'+index+')',800,600);
			}
			className = "botao-16x16";
		}
		this.btnCadastrarIMG = document.createElement('img');
		with (this.btnCadastrarIMG) {
			src = "/_imagens/botoes/16x16/cadastrar.gif";
			alt = "Cadastrar Veculo de Terceiro";
			width = "16";
			height="16";
			align="absmiddle";
		}
		this.btnCadastrar.appendChild(this.btnCadastrarIMG);
		this.obj.appendChild(this.btnCadastrar);
		this.getObj = function () {
			return this.obj;
		}
		group.appendChild(this.obj);
		this.destroy = function() {
			this.obj.removeNode(true);
		}
		this.setValue = function (value) {
			this.input.value = value;
		}
		this.getValue = function () {
			return this.input.value;
		}
		this.setReadOnly = function (value) {
			this.input.readOnly = value;
			this.btnLocalizar.disabled = value;
			this.btnCadastrar.disabled = value;
		}
		<cfif not (isdefined("vars.terceiro") and vars.terceiro eq 1)>
			this.btnLocalizar.style.visibility = 'hidden';
			this.btnCadastrar.style.visibility = 'hidden';
		</cfif>
		if (document.v_comp_readonly) {
			this.setReadOnly(true);
		}
	}
	
	document.v_comp_readonly = false;
	setReadOnly['composicao'] = function(value) {
		with(document.forms[0]) {
			document.v_comp_readonly = value;
			PLACA_CONTROLE.readOnly = value;
			document.getElementById('btn_localizar_placa_tracao').disabled = value;
			document.getElementById('btn_cadastrar_placa_tracao').disabled = value;
			document.getElementById('btn_engata').disabled = value;
			document.getElementById('btn_desengata').disabled = value;
			for(var i=0;i<v_placas_referencia.length;i++) {
				v_placas_referencia[i].setReadOnly(value);
			}
		}
	}
	
	function f_muda_pagador() {
		with(document.forms[0]) {
			if(PAGADOR.value == 0) {
				f_copia_cliente_COB('REM','COD_REMETENTE');
			} else {
				f_copia_cliente_COB('DEST','COD_DESTINATARIO');
			}
		}
	}
	
	function f_organograma(p_cod_centro_custo) {
	   with(document.forms[0]) {
	   	  <cfoutput query="qrOrganograma">
		  	 if (p_cod_centro_custo == #qrOrganograma.COD_CENTRO_CUSTO#) {
			    COD_PESSOA_FILIAL.value = '#qrOrganograma.COD_PESSOA#';
				COD_UNIDADE_NEGOCIO.value = '#qrOrganograma.COD_UNIDADE_NEGOCIO#';
				UNIDADE_NEGOCIO.value = '#qrOrganograma.FILIAL#';
				COD_DEPARTAMENTO.value = '#qrOrganograma.COD_DEPARTAMENTO#';
				DEPARTAMENTO.value = '#qrOrganograma.DEPARTAMENTO#';
				COD_SETOR.value = '#qrOrganograma.COD_SETOR#';
				SETOR.value = '#qrOrganograma.SETOR#';
				COD_CENTRO_CUSTO.value = '#qrOrganograma.COD_CENTRO_CUSTO#';
				CENTRO_CUSTO.value = '#qrOrganograma.CENTRO_CUSTO#';
			 }
		  </cfoutput>
	   }	
	}	
	
	function f_natureza_operacao(p_natureza_id) {
	  with(document.forms[0]) {
	     <cfoutput query="qrNaturezaOperacao">
		   if (p_natureza_id == #qrNaturezaOperacao.NATUREZA_ID#) {
		      NATUREZA_DESCRICAO.value = '#JSStringFormat(qrNaturezaOperacao.DESCRICAO)#';
		   }
		 </cfoutput>
		 
	  }
	}		
</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KM&amp;M Transporte e Log&iacute;stica :..</title>
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/abas.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body class="background" style="height:100%; overflow:auto" onLoad="document.forms[0].NUM_ROMANEIO.focus();" >
<table width="100%" height="100%" border="0" cellpadding="3" cellspacing="1" class="texto">
   <form id="form_transportes" name="form_transportes" method="post" action="">
      <input name="OPERACAO" type="hidden" value="">
      <input name="CONSULTA" type="hidden" value="">
      <input name="CONFIRMA" type="hidden" value="1" fixo="1">
      <input name="FRETE_PROPRIO" type="hidden" value="" fixo="1"> 
      <input name="NF_ES_ID" type="hidden" value="">
	  
      <input name="COD_ATIVIDADE" type="hidden" value="">

	  <input name="VIAGEM_CARGA_ID" type="hidden" id="VIAGEM_CARGA_ID" fixo="1" >
	  <input name="NUM_ROMANEIO" type="hidden" id="NUM_ROMANEIO" fixo="1" >
	  <input name="MUNICIPAL" type="hidden" id="MUNICIPAL" fixo="1" value="1" >
      <input name="ITEM_ID" type="hidden" value="">
      <input name="NUM_PRODUTO" type="hidden" value="">
      <input name="VEICULO_PROPRIETARIO" type="hidden" value="">
      <input name="ST_ICMS_ID" type="hidden" value="">
      <input name="ST_ORIGEM_ID" type="hidden" value=""> 
      <input name="FRETE_EM" type="hidden" value="">
      <input name="REGRA_FISCAL_ID" type="hidden" value="" >
	  <input name="IMPRIMIR" type="hidden" value="" fixo="1">
	  <input name="COD_PROPRIETARIO" type="hidden" id="COD_PROPRIETARIO">
	  <input name="PROP_CNPJ_CPF" type="hidden" id="PROP_CNPJ_CPF">
	  <input name="PROP_RAZAO_SOCIAL" type="hidden" id="PROP_RAZAO_SOCIAL">
	  <input name="PROP_ENDERECO" type="hidden" id="PROP_ENDERECO">
	  <input name="PROP_UF" type="hidden" id="PROP_UF">
	  <input name="COD_MOTORISTA" type="hidden" id="COD_MOTORISTA">
	  <input name="NOME_MOTORISTA" type="hidden" id="NOME_MOTORISTA">
	  <input name="FRACIONADO" type="hidden" id="FRACIONADO" value="0" fixo="1">
	  <input name="CONHECIMENTO_ID" type="hidden" id="CONHECIMENTO_ID">
	  <input name="OBSERVACAO" type="hidden" id="OBSERVACAO">
	  <input name="FUNDAMENTACAO_LEGAL" type="hidden" id="FUNDAMENTACAO_LEGAL">

	  <input name="CFOP_ID" type="hidden" id="CFOP_ID">
	  <input name="CFOP" type="hidden" id="CFOP">
	  <input name="NATUREZA_OPERACAO" type="hidden" id="NATUREZA_OPERACAO">

	  <input name="SITUACAO_ID" type="hidden" id="SITUACAO_ID">
	  <input name="IMPRESSO" type="hidden" id="IMPRESSO" value="" fixo="1">
	  <input name="ENTRADA_DADOS" type="hidden" id="ENTRADA_DADOS">
	  <input name="CORRECAO" type="hidden" id="CORRECAO">
	  <input name="TEM_NOTA" type="hidden" id="TEM_NOTA">
	  <cfif isdefined("vars.terceiro") and vars.terceiro eq 1>
	  <input name="TERCEIRO" type="hidden" id="TERCEIRO" value="1">
	  </cfif>
	  <input name="PLACA_REFERENCIA" type="hidden" id="PLACA_REFERENCIA">
	  <input name="PLACA_REFERENCIA_COMPOSICAO" type="hidden" id="PLACA_REFERENCIA_COMPOSICAO">
      <tr>
        <td height="15">Opera&ccedil;&atilde;o:</td>
        <td nowrap><input name="OPERACAO_ID" type="text" id="OPERACAO_ID" size="15" maxlength="10" readonly="true">
            <input name="ENTREGAS" type="text" id="ENTREGAS" style="text-align:center" title="NUMERO DE ENTREGAS" value="<cfif IsDefined("vars.ENTREGAS")><cfoutput>#vars.ENTREGAS#</cfoutput><cfelse>1</cfif>" size="2" maxlength="2"  obrigatorio="1" display="ENTREGA" fixo="1">
            <button type="button" class="botao-16x16" id="btn_buscar_lote" onClick="NewWindow('/_consultas/localizar_operacao.cfm?funcao_end=f_busca()&num_produto=268&fracionado=0&filial_atual=1&campo=OPERACAO_ID&MODALIDADE=TERCEIRO&funcao=f_busca_operacao()','_blank',800,600,'yes')" <cfif not (isdefined("vars.terceiro") and vars.terceiro eq 1)>style="display:none"</cfif>><img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle"></button></td>
        <td colspan="2" nowrap id="dv_operacao" class="obrigatorio">&nbsp;</td>
      </tr>
      <tr>
        <td height="1" nowrap>Pago por: </td>
        <td>
		<cfif IsDefined("qrOrganograma") and qrOrganograma.RecordCount gt 0>
			<cfoutput>
            <input type="hidden" value="<cfoutput>#qrOrganograma.cod_organograma#</cfoutput>" name="COD_ORGANOGRAMA_GERENCIAL">				</cfoutput>
		<cfelse>
			<span class="obrigatorio" >Verifique a lota&ccedil;&atilde;o do usu&aacute;rio</span>
		</cfif>
		<select name="PAGADOR" id="PAGADOR" obrigatorio="1" display="PAGADOR" onChange="f_muda_pagador(); f_calculos()" >
          <option value="">-- Selecione --</option>
          <option value="0" >Remetente</option>
          <option value="1">Destinatario</option>
        </select></td>
        <td nowrap>Regra Fiscal: </td>
        <td nowrap><select name="REGRA_FISCAL" id="REGRA_FISCAL" fixo="1" onChange="f_calculos()">
            <cfoutput query="qrRegraFiscal">
              <option value="#qrRegraFiscal.regra_fiscal_id#" <cfif qrRegraFiscal.regra_fiscal_id eq 1>selected</cfif>>#qrRegraFiscal.descricao#</option>
            </cfoutput>
          </select>        </td>
      </tr>
      
      <tr>
         <td height="1" nowrap>Ve&iacute;culos: </td>
         <td nowrap><nobr><input name="PLACA_CONTROLE" type="text" id="PLACA_CONTROLE" style="width:75px" onKeyPress="return f_formata(this,event,'AAAAAAAAA')" onChange="f_busca_composicao()" obrigatorio="0" display="PLACA CAVALO" ><span <cfif not (isdefined("vars.terceiro") and vars.terceiro eq 1)>style="visibility: hidden"</cfif>><button type="button" id="btn_localizar_placa_tracao" onClick="NewWindow('/_consultas/localizar_veiculo.cfm?proprietario=3&placa=PLACA_CONTROLE&funcao=f_busca_composicao()','_blank',800,600,'yes')" class="botao-16x16"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Ve&iacute;culo" width="16" height="16" align="absmiddle"></button>
          <button type="button" class="botao-16x16" onClick="f_abrir_janela('/aplicacoes/cadastros/veiculos/principal.cfm?funcao_end=f_incluir()','f_seta_placa_controle(f_get_placa_veiculo())',800,600)" id="btn_cadastrar_placa_tracao"><img src="/_imagens/botoes/16x16/cadastrar.gif" alt="Cadastrar Ve&iacute;culo de Terceiro" width="16" height="16" align="absmiddle"></button></span></nobr><span id="sp_placa_referencia"></span>
		  <nobr>
		<button type="button" id="btn_engata" class="botao-16x16" onClick="f_engata()"><img src="/_imagens/botoes/16x16/engatar.gif" alt="Engatar" width="16" height="16" align="absmiddle"></button>
		  <button type="button" id="btn_desengata" class="botao-16x16" onClick="f_desengata();"><img src="/_imagens/botoes/16x16/desengatar.gif" alt="" width="16" height="16" align="absmiddle"></button></nobr>		  </td>
        <td width="1%" nowrap>Motorista: </td>
        <td width="90%"><input name="MOTORISTA" type="text" id="MOTORISTA" readonly="true" style="width:100%"></td>
      </tr>
      <tr>
        <td height="1" nowrap>&nbsp;</td>
        <td nowrap>&nbsp;</td>
        <td nowrap>Propriet&aacute;rio:</td>
        <td><input name="PROPRIETARIO" type="text" id="PROPRIETARIO" readonly="true" style="width:100%"></td>
      </tr>
      <tr >
         <td colspan="4" valign="top" style="padding: 3px 0px 0px 0px">
   		<cfset v_colspan = 7>
		 
		 <table width="100%" height="100%" border="0" cellpadding="3" cellspacing="0" id="tbl_abas">
               <tr>
			   <cfif (isdefined("vars.frota_agregado") and vars.frota_agregado eq 1)>
                 <td width="1" nowrap class="td_aba_down">Romaneio</td>
			   </cfif>
               <td width="1" nowrap class="td_aba_down">Identificao</td>
                  <td width="1" height="1" nowrap class="td_aba_down">Remetente/Destinat&aacute;rio</td>
                  <td width="1" nowrap class="td_aba_down"><nobr>Notas Fiscais </nobr> </td>
                  <td width="1" nowrap class="td_aba_down">Negociao</td>
                  <td width="1700" class="td_aba_none">&nbsp;</td>
               </tr>
			   <cfif (isdefined("vars.frota_agregado") and vars.frota_agregado eq 1)><cfset v_colspan = 7>
               <tr>
                  <td colspan="7" valign="top" class="td_aba_corpo"><cfinclude template="#f_url('/aplicacoes/controle_documentos/conhecimento/emitir/forms/romaneio.cfm')#"></td>
               </tr>
			   </cfif>
               <cfset v_data = 'Data Sada'> 
               <tr>
                  <td colspan="<cfoutput>#v_colspan#</cfoutput>" valign="top" class="td_aba_corpo"><fieldset id="fds_rem_dest" style="border:0; padding:0; margin:0"><cfinclude template="/aplicacoes/controle_documentos/nota_fiscal_es/forms/identificacao.cfm"/></fieldset></td>
               </tr>
               <tr>
                  <td colspan="<cfoutput>#v_colspan#</cfoutput>" valign="top" class="td_aba_corpo"><fieldset id="fds_rem_dest" style="border:0; padding:0; margin:0"><cfinclude template="#f_url('/aplicacoes/controle_documentos/conhecimento/emitir/forms/rem_dest.cfm')#"/></fieldset></td>
               </tr>
               <tr>
                  <td  colspan="<cfoutput>#v_colspan#</cfoutput>" valign="top" class="td_aba_corpo"><fieldset id="fds_notas_fiscais" style="border:0; padding:0; margin:0"><cfinclude template="#f_url('/aplicacoes/controle_documentos/conhecimento/emitir/forms/notas_fiscais.cfm')#"/></fieldset></td>
               </tr>
               <tr>
                  <td colspan="<cfoutput>#v_colspan#</cfoutput>" valign="top" class="td_aba_corpo"><fieldset id="fds_mercadorias" style="border:0; padding:0; margin:0"><cfinclude template="#f_url('/aplicacoes/controle_documentos/conhecimento/emitir/forms/negociacao.cfm')#"/></fieldset></td>
               </tr>
            </table>
            <script language="javascript1.2">
			      initAbas('tbl_abas',0,true);
	  	      </script>		
              </td>
      </tr>
   </form>
</table>
</body>
</html>
<cfset requestend = 0>
<script>
	parent.f_habilitar_botao('confirmar','f_confirmar()');
</script>
<cfif IsDefined("vars.EMISSAO")>
	<script language="javascript1.2">
		<cfoutput>
			with(document.forms[0]) {
				PLACA_CONTROLE.value   = '#vars.PLACA_CONTROLE#';
				PLACA_REFERENCIA.value = '#vars.PLACA_REFERENCIA#';
				DATA_EMISSAO.value     = '#DateFormat(Now(),'dd/mm/yyyy')#';
				DATA_EMISSAO.readOnly  = true;
				NUM_ROMANEIO.value     = '#vars.NUM_ROMANEIO#';
				f_busca_romaneio();
			}
		</cfoutput>
	</script>	
</cfif>
<cfif IsDefined("vars.CADASTRAR")>
	<script language="javascript1.2">
		<cfoutput>
			with(document.forms[0]) {
				PLACA_CONTROLE.value   = '#vars.PLACA_CONTROLE#';
				PLACA_REFERENCIA.value = '#vars.PLACA_REFERENCIA#';
				NUM_ROMANEIO.value     = '#vars.NUM_ROMANEIO#';
				f_busca_romaneio();
			}
		</cfoutput>
	</script>	
</cfif>

<cfif IsDefined("vars.flag_conhecimento") and vars.flag_conhecimento eq "cadastrar">
	<script>
		with(document.forms[0]){
			DATA_EMISSAO.value='';
			DATA_EMISSAO.readOnly=false;
			document.getElementById("btn_data_emissao").style.display='block';
			FRETE_VALOR.readOnly=false;
			IMPRESSO.value = 1;
			TOTAL_CONHECIMENTO.readOnly=false;
			BASE_CALCULO_ICMS.readOnly=false;
			VALOR_ICMS.readOnly=false;
		}
	</script>
<cfelse>
	<script>
		with(document.forms[0]){
			DATA_EMISSAO.value="<cfoutput>#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#</cfoutput>";
			DATA_EMISSAO.readOnly=true;
			IMPRESSO.value = 0;
			IMPRIMIR.value     = 1;
			NOTA_DATA_EMISSAO.value="<cfoutput>#DateFormat(Now(),'dd/mm/yyyy')#</cfoutput>";
		}
	</script>
</cfif>

<cfif isdefined("vars.aberto") and vars.aberto eq 1>
	<script>
		with(document.forms[0]){
			DATA_EMISSAO.value="<cfoutput>#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#</cfoutput>";
			DATA_EMISSAO.readOnly=false;
			document.getElementById("btn_data_emissao").style.display='';
		}
	</script>
</cfif>

<script>
Calendar.setup(
    {
      inputField  : "DATA_EMISSAO",      // ID of the input field
      ifFormat    :    "%d/%m/%Y %H:%M",    // the date format
      button      : "btn_data_emissao",    // ID of the button
	  range       : [2001,2050],
	  showsTime   :  true
    }
  );
  window.onload = function() { f_controla_campos(1,true); }
  
with(document.forms[0]) {
<cfif isdefined("vars.acerto") and vars.acerto eq 1>
	FRETE_PROPRIO.value = 0;
<cfelse>
	FRETE_PROPRIO.value = 1;
</cfif>

<cfif isdefined("vars.NF_ES_ID")>
	NF_ES_ID.value = '<cfoutput>#vars.NF_ES_ID#</cfoutput>';
	f_busca_conhecimento();
	f_desabilitar_botao('confirmar');
	function f_on_busca_conhecimento() {
		f_habilitar_botao('confirmar','f_confirmar()');
	}
<cfif isdefined("vars.visualizar")>
	f_desabilita_todos_campos();
	parent.f_hidden('btn_confirmar');
	setReadOnly['composicao'](true);
</cfif>
</cfif>
<cfif isdefined("vars.terceiro") and vars.terceiro eq 1>
	setReadOnly['terceiro'](true);
	<cfif not isdefined("vars.num_lote")>
	document.getElementById('btn_buscar_lote').click();
	<cfelse>
	OPERACAO_ID.value = '<cfoutput>#vars.num_lote#</cfoutput>';
	f_busca_lote();
	</cfif>
	<cfif isdefined("vars.placa_tracao")>
	PLACA_CONTROLE.value = '<cfoutput>#vars.placa_tracao#</cfoutput>';
	PLACA_CONTROLE.onchange();
	setReadOnly['composicao'](true);
	</cfif>
	<cfif isdefined("vars.num_romaneio")>
	NUM_ROMANEIO.value = '<cfoutput>#vars.num_romaneio#</cfoutput>';
	</cfif>
</cfif>
<cfif isdefined("vars.frota_agregado") and vars.frota_agregado eq 1>
	setReadOnly['frota_agregado'](true);
	<cfif isdefined("vars.num_romaneio") and len(trim(vars.num_romaneio))>
	NUM_ROMANEIO_FROTA.value = '<cfoutput>#vars.num_romaneio#</cfoutput>';
	NUM_ROMANEIO_FROTA.onchange();
	NUM_NOTA_FISCAL.focus();
	</cfif>

</cfif>
	TIPO_NOTA_SERVICO.value = <cfoutput>#session.cod_centro_custo#</cfoutput>;
	f_organograma(<cfoutput>#session.cod_centro_custo#</cfoutput>);
	INCLUIR_SISS.value = 1;
	f_cancelar_NOTAS_FISCAIS();
}  
</script>

<iframe name="consultas" frameborder="0" width="0" height="0" src="" ></iframe>
