<cfscript>
	if(IsDefined("vars.DATA_INICIO") and IsDefined("vars.DATA_FIM")) {
		conn = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
		qrMapaProducao = conn.get_mapa_producao(argumentCollection = vars);
	}
</cfscript>
<cfdocument name="pdf_mapa_producao" format="pdf" orientation="landscape" margintop="0.1" marginright="0.1" marginbottom="0.1" marginleft="0.0">
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Mapa de Produo</title>
<style type="text/css">
	body {
		margin: 0;
		padding: 0;
	}
	.fonte {
		font-family: Arial, Helvetica, sans-serif;
		font-stretch: condensed;
		font-size: 7px;
	}
	.td_agrupamento {
		padding: 2px 2px 2px 0px;
		border-top: solid 1px #000;
		border-bottom: solid 1px #000;
	}
	.td_dados {
		padding: 2px 2px 2px 0px;
	}
	.td_dados_borda {
		padding: 2px 2px 2px 0px;
		border-right: solid 1px #CCC;
	}
	.td_resumo {
		padding: 3px 15px 3px 15px;
	}
</style>
</head>
<body>
<cfif IsDefined("qrMapaProducao")>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
	<tr>
		<td>
        	<table width="100%" border="0" cellpadding="0" cellspacing="0" class="fonte">
				<tr>
                    <td colspan="23">
                        <table width="100%" border="0" cellpadding="3" cellspacing="1" class="fonte">
                            <tr>
                                <td colspan="2" nowrap align="center" style="font-size: 16px;"><b><i><u>Mapa de Produ&ccedil;&atilde;o</u></i></b></td>
                            </tr>
                            <tr>
                                <td width="1%"><img src="<cf_url>/_imagens/logos/logo_relatorio.jpg</cf_url>" alt="" title="" style="width: 120px; height: 80px; margin-right: 20px;" /></td>
                                <td width="99%" nowrap valign="bottom" align="left" style="font-size: 12px;">Per&iacute;odo:&nbsp;<cfoutput>#vars.DATA_INICIO#</cfoutput>&nbsp;at&eacute;&nbsp;<cfoutput>#vars.DATA_FIM#</cfoutput></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td colspan="23">&nbsp;</td>
                </tr>
                <tr>
                    <td nowrap align="right" class="td_dados_borda"><b>Romaneio</b></td>
                    <td nowrap align="left" class="td_dados_borda"><b>Cliente</b></td>
                    <td nowrap align="right" class="td_dados_borda"><b>Hora</b></td>
                    <td nowrap align="right" class="td_dados_borda"><b>Cavalo</b></td>
                    <td nowrap align="right" class="td_dados_borda"><b>Carreta</b></td>
                    <td nowrap align="right" class="td_dados_borda"><b>Emp</b></td>
                    <td nowrap align="left" class="td_dados_borda"><b>N&ordm; Conhec.</b></td>
                    <td nowrap align="left" class="td_dados_borda">NF. CTe</td>
                    <td nowrap align="left" class="td_dados_borda"><b>Motorista</b></td>
                    <td nowrap align="left" class="td_dados_borda"><b>Produto</b></td>
                    <td nowrap align="left" class="td_dados_borda"><b>Origem</b></td>
                    <td nowrap align="left" class="td_dados_borda"><b>UF</b></td>
                    <td nowrap align="left" class="td_dados_borda"><b>Destino</b></td>
                    <td nowrap align="left" class="td_dados_borda"><b>UF</b></td>
                    <td nowrap align="right" class="td_dados_borda"><b>KM Vazio</b></td>
                    <td nowrap align="right" class="td_dados_borda"><b>KM</b></td>
                    <td nowrap align="right" class="td_dados_borda"><b>Peso (Kg)</b></td>
                    <td nowrap align="right" class="td_dados_borda"><b>Vl. Frete</b></td>
                    <td nowrap align="right" class="td_dados_borda"><b>Vl. s/ ICMS</b></td>
                    <td nowrap align="right" class="td_dados_borda"><b>Ped&aacute;gio</b></td>
                    <td nowrap align="right" class="td_dados_borda"><b>Terceiros</b></td>
                    <td nowrap align="right" class="td_dados_borda"><b>FC/FE</b></td>
                    <td nowrap align="right" class="td_dados"><b>R$/KM</b></td>
                </tr>
                <cfscript>
					v_total_km_frota = 0;
					v_total_km_terceiro = 0;
					v_total_km_agregado = 0;
					
					v_total_peso_frota = 0;
					v_total_peso_terceiro = 0;
					v_total_peso_agregado = 0;
					
					v_total_frete_bruto_frota = 0;
					v_total_frete_bruto_terceiro = 0;
					v_total_frete_bruto_agregado = 0;
					
					v_total_frete_sem_icms_frota = 0;
					v_total_frete_sem_icms_terceiro = 0;
					v_total_frete_sem_icms_agregado = 0;
					
					v_total_carta_frete_terceiro = 0;
					v_total_carta_frete_agregado = 0;
					
					v_total_qtd_frota = 0;
					v_total_qtd_terceiro = 0;
					v_total_qtd_agregado = 0;
					
					v_total_pedagio_frota = 0;
					v_total_pedagio_terceiro = 0;
					v_total_pedagio_agregado = 0;
				</cfscript>
                <cfoutput query="qrMapaProducao" group="COD_PESSOA_FILIAL">
                <tr>
                	<td colspan="23" nowrap align="left" class="td_agrupamento"><b>Filial:</b>&nbsp;#qrMapaProducao.FILIAL#</td>
                </tr>
                <cfoutput group="COD_CENTRO_CUSTO">
                <tr>
                	<td colspan="23" nowrap align="left" class="td_agrupamento"><b>Centro de Custo:</b>&nbsp;#qrMapaProducao.CENTRO_CUSTO#</td>
                </tr>
                <cfoutput group="DATA_EMISSAO">
                <tr>
                	<td colspan="23" nowrap align="left" class="td_agrupamento"><b>Data de Emiss&atilde;o:</b>&nbsp;#qrMapaProducao.DATA_EMISSAO#</td>
                </tr>
				<cfoutput>
                <cfscript>
					if(qrMapaProducao.MODALIDADE_VEICULO eq 'FROTA' or qrMapaProducao.MODALIDADE_VEICULO eq '') {
						if(Len(Trim(qrMapaProducao.KM_ROTA))) { v_total_km_frota = v_total_km_frota + qrMapaProducao.KM_ROTA; }
						if(Len(Trim(qrMapaProducao.PESO))) { v_total_peso_frota = v_total_peso_frota + (qrMapaProducao.PESO / 1000); }
						if(Len(Trim(qrMapaProducao.VALOR_FRETE))) { v_total_frete_bruto_frota = v_total_frete_bruto_frota + qrMapaProducao.VALOR_FRETE; }
						if(Len(Trim(qrMapaProducao.VALOR_SEM_ICMS))) { v_total_frete_sem_icms_frota = v_total_frete_sem_icms_frota + qrMapaProducao.VALOR_SEM_ICMS; }
						if(Len(Trim(qrMapaProducao.PEDAGIO))) { v_total_pedagio_frota = v_total_pedagio_frota + qrMapaProducao.PEDAGIO; }
						v_total_qtd_frota = v_total_qtd_frota + 1;
					}
					else if(qrMapaProducao.MODALIDADE_VEICULO eq 'TERCEIRO') {
						if(Len(Trim(qrMapaProducao.KM_ROTA))) { v_total_km_terceiro = v_total_km_terceiro + qrMapaProducao.KM_ROTA; }
						if(Len(Trim(qrMapaProducao.PESO))) { v_total_peso_terceiro = v_total_peso_terceiro + (qrMapaProducao.PESO / 1000); }
						if(Len(Trim(qrMapaProducao.VALOR_FRETE))) { v_total_frete_bruto_terceiro = v_total_frete_bruto_terceiro + qrMapaProducao.VALOR_FRETE; }
						if(Len(Trim(qrMapaProducao.VALOR_SEM_ICMS))) { v_total_frete_sem_icms_terceiro = v_total_frete_sem_icms_terceiro + qrMapaProducao.VALOR_SEM_ICMS; }
						if(Len(Trim(qrMapaProducao.TERCEIRO))) { v_total_carta_frete_terceiro = v_total_carta_frete_terceiro + qrMapaProducao.TERCEIRO; }
						if(Len(Trim(qrMapaProducao.PEDAGIO))) { v_total_pedagio_terceiro = v_total_pedagio_terceiro + qrMapaProducao.PEDAGIO; }
						v_total_qtd_terceiro = v_total_qtd_terceiro + 1;
					}
					else if(qrMapaProducao.MODALIDADE_VEICULO eq 'AGREGADO') {
						if(Len(Trim(qrMapaProducao.KM_ROTA))) { v_total_km_agregado = v_total_km_agregado + qrMapaProducao.KM_ROTA; }
						if(Len(Trim(qrMapaProducao.PESO))) { v_total_peso_agregado = v_total_peso_agregado + (qrMapaProducao.PESO / 1000); }
						if(Len(Trim(qrMapaProducao.VALOR_FRETE))) { v_total_frete_bruto_agregado = v_total_frete_bruto_agregado + qrMapaProducao.VALOR_FRETE; }
						if(Len(Trim(qrMapaProducao.VALOR_SEM_ICMS))) { v_total_frete_sem_icms_agregado = v_total_frete_sem_icms_agregado + qrMapaProducao.VALOR_SEM_ICMS; }
						if(Len(Trim(qrMapaProducao.TERCEIRO))) { v_total_carta_frete_agregado = v_total_carta_frete_agregado + qrMapaProducao.TERCEIRO; }
						if(Len(Trim(qrMapaProducao.PEDAGIO))) { v_total_pedagio_agregado = v_total_pedagio_agregado + qrMapaProducao.PEDAGIO; }
						v_total_qtd_agregado = v_total_qtd_agregado + 1;
					}
				</cfscript>
                <tr>
                    <td nowrap align="right" class="td_dados_borda">#qrMapaProducao.NUM_ROMANEIO#</td>
                    <td nowrap align="left" class="td_dados_borda">#Left(qrMapaProducao.COB_RAZAO_SOCIAL, 34)#</td>
                    <td nowrap align="right" class="td_dados_borda">#qrMapaProducao.HORA_EMISSAO#</td>
                    <td nowrap align="right" class="td_dados_borda">#qrMapaProducao.VEICULO#</td>
                    <td nowrap align="right" class="td_dados_borda">#qrMapaProducao.COD_VEICULO_REBOQUE#</td>
                    <td nowrap align="right" class="td_dados_borda">#qrMapaProducao.EMP#</td>
                    <td nowrap align="left" class="td_dados_borda">#qrMapaProducao.NUM_CONHECIMENTO#</td>
                    <td nowrap align="left" class="td_dados_borda">#qrMapaProducao.NF_CONHECIMENTO#</td>
                    <td nowrap align="left" class="td_dados_borda">#Left(qrMapaProducao.MOTORISTA, 24)#</td>
                    <td nowrap align="left" class="td_dados_borda">#Left(qrMapaProducao.NATUREZA, 18)#</td>
                    <td nowrap align="left" class="td_dados_borda">#Left(qrMapaProducao.ORIGEM, 20)#</td>
                    <td nowrap align="left" class="td_dados_borda">#qrMapaProducao.ORIGEM_UF#</td>
                    <td nowrap align="left" class="td_dados_borda">#Left(qrMapaProducao.DESTINO, 20)#</td>
                    <td nowrap align="left" class="td_dados_borda">#qrMapaProducao.DESTINO_UF#</td>
                    <td nowrap align="right" class="td_dados_borda">#LSNumberFormat(qrMapaProducao.KM_VAZIO, ',.__')#</td>
                    <td nowrap align="right" class="td_dados_borda">#LSNumberFormat(qrMapaProducao.KM_ROTA, ',.__')#</td>
                    <td nowrap align="right" class="td_dados_borda">#LSNumberFormat(qrMapaProducao.PESO, ',.__')#</td>
                    <td nowrap align="right" class="td_dados_borda">#LSNumberFormat(qrMapaProducao.VALOR_FRETE, ',.__')#</td>
                    <td nowrap align="right" class="td_dados_borda">#LSNumberFormat(qrMapaProducao.VALOR_SEM_ICMS, ',.__')#</td>
                    <td nowrap align="right" class="td_dados_borda">#LSNumberFormat(qrMapaProducao.PEDAGIO, ',.__')#</td>
                    <td nowrap align="right" class="td_dados_borda">#LSNumberFormat(qrMapaProducao.TERCEIRO, ',.__')#</td>
                    <td nowrap align="right" class="td_dados_borda">#LSNumberFormat(qrMapaProducao.FC_FE, ',.__')#</td>
                    <td nowrap align="right" class="td_dados">#LSNumberFormat(qrMapaProducao.REAIS_KM, ',.__')#</td>
                </tr>
                </cfoutput>
                </cfoutput>
                </cfoutput>
                </cfoutput>
			</table>
		</td>
	</tr>
    <tr>
    	<td>&nbsp;</td>
    </tr>
    <tr>
        <td>
        	<table border="0" cellpadding="3" cellspacing="1" class="fonte">
                <!-- thead -->
                <thead>
                <tr>
                    <td colspan="11" nowrap align="center" class="td_resumo">Resumo</td>
                </tr>
                <tr>
                    <td nowrap align="right" class="td_resumo"></td>
                    <td nowrap align="right" class="td_resumo">KM</td>
                    <td nowrap align="right" class="td_resumo">Peso (Ton)</td>
                    <td nowrap align="right" class="td_resumo">Frete Bruto</td>
                    <td nowrap align="right" class="td_resumo">Frete s/ ICMS</td>
                    <td nowrap align="right" class="td_resumo">Cred. Presumido</td>
                    <td nowrap align="right" class="td_resumo">Carta Frete</td>
                    <td nowrap align="right" class="td_resumo">Qt. Conhec.</td>
                    <td nowrap align="right" class="td_resumo">FC/FE</td>
                    <td nowrap align="right" class="td_resumo">R$/KM</td>
                    <td nowrap align="right" class="td_resumo">Ped&aacute;gio</td>
                </tr>
                </thead>
                <!-- ///// -->
                
                <!-- tbody -->
                <tbody>
                <tr>
                    <td nowrap align="right" class="td_resumo"><b>Frota</b></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_km_frota, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_peso_frota, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_frete_bruto_frota, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_frete_sem_icms_frota, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo">0,00</td>
                    <td nowrap align="right" class="td_resumo"></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_qtd_frota, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput><cfif v_total_km_frota eq 0>#LSNumberFormat(0, ',.__')#<cfelse>#LSNumberFormat(v_total_frete_sem_icms_frota / v_total_km_frota, ',.__')#</cfif></cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_pedagio_frota, ',.__')#</cfoutput></td>
                </tr>
                <tr>
                    <td nowrap align="right" class="td_resumo"><b>Terceiros</b></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_km_terceiro, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_peso_terceiro, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_frete_bruto_terceiro, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_frete_sem_icms_terceiro, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo">0,00</td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_carta_frete_terceiro, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_qtd_terceiro, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput><cfif v_total_frete_sem_icms_terceiro eq 0>#LSNumberFormat(0, ',.__')#<cfelse>#LSNumberFormat(v_total_carta_frete_terceiro / v_total_frete_sem_icms_terceiro, ',.__')#</cfif></cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput><cfif v_total_km_terceiro eq 0>#LSNumberFormat(0, ',.__')#<cfelse>#LSNumberFormat(v_total_frete_sem_icms_terceiro / v_total_km_terceiro, ',.__')#</cfif></cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_pedagio_terceiro, ',.__')#</cfoutput></td>
                </tr>
                <tr>
                    <td nowrap align="right" class="td_resumo"><b>Agregados</b></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_km_agregado, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_peso_agregado, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_frete_bruto_agregado, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_frete_sem_icms_agregado, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo">0,00</td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_carta_frete_agregado, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_qtd_agregado, ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput><cfif v_total_frete_sem_icms_agregado eq 0>#LSNumberFormat(0, ',.__')#<cfelse>#LSNumberFormat(v_total_carta_frete_agregado / v_total_frete_sem_icms_agregado, ',.__')#</cfif></cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput><cfif v_total_km_agregado eq 0>#LSNumberFormat(0, ',.__')#<cfelse>#LSNumberFormat(v_total_frete_sem_icms_agregado / v_total_km_agregado, ',.__')#</cfif></cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(v_total_pedagio_agregado, ',.__')#</cfoutput></td>
                </tr>
                <tr>
                    <td nowrap align="right" class="td_resumo"></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(ArraySum(ListToArray(ValueList(qrMapaProducao.KM_ROTA))), ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat((ArraySum(ListToArray(ValueList(qrMapaProducao.PESO))) / 1000), ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(ArraySum(ListToArray(ValueList(qrMapaProducao.VALOR_FRETE))), ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(ArraySum(ListToArray(ValueList(qrMapaProducao.VALOR_SEM_ICMS))), ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo">0,00</td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(ArraySum(ListToArray(ValueList(qrMapaProducao.TERCEIRO))), ',.__')#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(qrMapaProducao.RecordCount)#</cfoutput></td>
                    <td nowrap align="right" class="td_resumo"></td>
                    <td nowrap align="right" class="td_resumo"></td>
                    <td nowrap align="right" class="td_resumo"><cfoutput>#LSNumberFormat(ArraySum(ListToArray(ValueList(qrMapaProducao.PEDAGIO))), ',.__')#</cfoutput></td>
                </tr>
                </tbody>
                <!-- ///// -->
            </table>
        </td>
    </tr>
</table>
</cfif>
</body>
</html>
<cfdocumentitem type="footer">
	<style type="text/css">
		body {
			margin: 0;
			padding: 0;
		}
		.fonte {
			font-family: Verdana, Arial, Helvetica, sans-serif;
			font-stretch: condensed;
			font-size: 10px;
		}
	</style>
	<table width="100%" border="0" cellpadding="0" cellspacing="0" class="fonte">
        <tr>
        	<td nowrap align="left">P&aacute;ginas: <cfoutput>#cfdocument.CurrentPageNumber# de #cfdocument.TotalPageCount#</cfoutput></td>
            <td nowrap align="right"><cfoutput>#session.usuario# - #DateFormat(Now(), 'dd/mm/yyyy') & " " & TimeFormat(Now(), 'HH:mm:ss')#</cfoutput></td>
        </tr>
    </table>
</cfdocumentitem>
</cfdocument>
<cfset path = ExpandPath("/temp")>
<cfset data_hora = DateFormat(Now(), 'ddmmyyyy') & "_" & TimeFormat(Now(), 'HHmmss')>
<cfpdf action="merge" destination="#path#/mapa_producao_#data_hora#.pdf" overwrite="yes">
	<cfpdfparam source="pdf_mapa_producao" />
</cfpdf>
<script>
	window.location = '/temp/mapa_producao_<cfoutput>#data_hora#</cfoutput>.pdf';
</script>