<cfscript>
	if(IsDefined("vars.DATA_INICIO") and IsDefined("vars.DATA_FIM")) {
		conn = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
		qrMapaProducao = conn.get_mapa_producao(argumentCollection = vars);
	}
</cfscript>
<cfif IsDefined("qrMapaProducao")>
	<cfsetting showdebugoutput="no">
    <cfheader name="Content-Disposition" value="attachment; filename=Mapa_Producao.xls">
    <cfcontent type="application/msexcel; charset=iso-8859-1" reset="yes">
    <link rel="stylesheet" type="text/css" href="http://<cfoutput>#cgi.http_host#</cfoutput>/<cf_url>/_estilos/excel.css</cf_url>">
    <table border="0">
    	<tr>
        	<td>
            	<table border="1" class="borda">
                    <tr class="titulo_1">
                        <td colspan="22" nowrap align="left">MAPA DE PRODU&Ccedil;&Atilde;O</td>
                    </tr>
                    <tr class="linha_2">
                        <td colspan="22" nowrap align="left">Per&iacute;odo:&nbsp;<cfoutput>#vars.DATA_INICIO#</cfoutput>&nbsp;at&eacute;&nbsp;<cfoutput>#vars.DATA_FIM#</cfoutput></td>
                    </tr>
				</table>
			</td>
    	<tr>
        	<td></td>
        </tr>
        <tr>
			<td>
            	<table border="1" class="borda">
                    <!-- thead -->
                    <thead>
                    <tr class="titulo_1">
                       <td nowrap align="right">Filial</td>
                       <td nowrap align="right">Data</td>
                       <td nowrap align="left">Centro Custo</td>
                       <td nowrap align="left">Cod. Gerencial</td>
                       <td nowrap align="left">Centro Custo Gerencial</td>
                    	<td nowrap align="center">Romaneio</td>
                        <td nowrap align="left">Cliente</td>
                        <td nowrap align="right">Hora</td>
                        <td nowrap align="right">Cavalo</td>
                        <td nowrap align="right">Carreta</td>
                        <td nowrap align="right">Emp</td>
                        <td nowrap align="left">N&ordm; Conhec.</td>
                        <td nowrap align="left">NF. CTe</td>
                        <td nowrap align="left">Motorista</td>
                        <td nowrap align="left">Produto</td>
                        <td nowrap align="left">Origem</td>
                        <td nowrap align="left">UF</td>
                        <td nowrap align="left">Destino</td>
                        <td nowrap align="left">UF</td>
                        <td nowrap align="right">KM Vazio</td>
                        <td nowrap align="right">KM</td>
                        <td nowrap align="right">Peso (Kg)</td>
                        <td nowrap align="right">Vl. Frete</td>
                        <td nowrap align="right">Vl. s/ ICMS</td>
                        <td nowrap align="right">Ped&aacute;gio</td>
                        <td nowrap align="right">Terceiros</td>
                        <td nowrap align="center">Carta Frete</td>
                        <td nowrap align="right">FC/FE</td>
                        <td nowrap align="right">R$/KM</td>
                        <td nowrap align="left">Operao</td>
                    </tr>
                    </thead>
                    <!-- ///// -->
                    
                    <cfscript>
						v_total_km_frota = 0;
						v_total_km_terceiro = 0;
						v_total_km_agregado = 0;
						
						v_total_peso_frota = 0;
						v_total_peso_terceiro = 0;
						v_total_peso_agregado = 0;
						
						v_total_frete_bruto_frota = 0;
						v_total_frete_bruto_terceiro = 0;
						v_total_frete_bruto_agregado = 0;
						
						v_total_frete_sem_icms_frota = 0;
						v_total_frete_sem_icms_terceiro = 0;
						v_total_frete_sem_icms_agregado = 0;
						
						v_total_carta_frete_terceiro = 0;
						v_total_carta_frete_agregado = 0;
						
						v_total_qtd_frota = 0;
						v_total_qtd_terceiro = 0;
						v_total_qtd_agregado = 0;
						
						v_total_pedagio_frota = 0;
						v_total_pedagio_terceiro = 0;
						v_total_pedagio_agregado = 0;
					</cfscript>
                    
                    <!-- tbody -->
                    <tbody>
                    <cfoutput query="qrMapaProducao">
                    <cfscript>
                        if(qrMapaProducao.MODALIDADE_VEICULO eq 'FROTA' or qrMapaProducao.MODALIDADE_VEICULO eq '') {
                            if(Len(Trim(qrMapaProducao.KM_ROTA))) { v_total_km_frota = v_total_km_frota + qrMapaProducao.KM_ROTA; }
                            if(Len(Trim(qrMapaProducao.PESO))) { v_total_peso_frota = v_total_peso_frota + (qrMapaProducao.PESO / 1000); }
                            if(Len(Trim(qrMapaProducao.VALOR_FRETE))) { v_total_frete_bruto_frota = v_total_frete_bruto_frota + qrMapaProducao.VALOR_FRETE; }
                            if(Len(Trim(qrMapaProducao.VALOR_SEM_ICMS))) { v_total_frete_sem_icms_frota = v_total_frete_sem_icms_frota + qrMapaProducao.VALOR_SEM_ICMS; }
                            if(Len(Trim(qrMapaProducao.PEDAGIO))) { v_total_pedagio_frota = v_total_pedagio_frota + qrMapaProducao.PEDAGIO; }
                            v_total_qtd_frota = v_total_qtd_frota + 1;
                        }
                        else if(qrMapaProducao.MODALIDADE_VEICULO eq 'TERCEIRO') {
                            if(Len(Trim(qrMapaProducao.KM_ROTA))) { v_total_km_terceiro = v_total_km_terceiro + qrMapaProducao.KM_ROTA; }
                            if(Len(Trim(qrMapaProducao.PESO))) { v_total_peso_terceiro = v_total_peso_terceiro + (qrMapaProducao.PESO / 1000); }
                            if(Len(Trim(qrMapaProducao.VALOR_FRETE))) { v_total_frete_bruto_terceiro = v_total_frete_bruto_terceiro + qrMapaProducao.VALOR_FRETE; }
                            if(Len(Trim(qrMapaProducao.VALOR_SEM_ICMS))) { v_total_frete_sem_icms_terceiro = v_total_frete_sem_icms_terceiro + qrMapaProducao.VALOR_SEM_ICMS; }
                            if(Len(Trim(qrMapaProducao.TERCEIRO))) { v_total_carta_frete_terceiro = v_total_carta_frete_terceiro + qrMapaProducao.TERCEIRO; }
                            if(Len(Trim(qrMapaProducao.PEDAGIO))) { v_total_pedagio_terceiro = v_total_pedagio_terceiro + qrMapaProducao.PEDAGIO; }
                            v_total_qtd_terceiro = v_total_qtd_terceiro + 1;
                        }
                        else if(qrMapaProducao.MODALIDADE_VEICULO eq 'AGREGADO') {
                            if(Len(Trim(qrMapaProducao.KM_ROTA))) { v_total_km_agregado = v_total_km_agregado + qrMapaProducao.KM_ROTA; }
                            if(Len(Trim(qrMapaProducao.PESO))) { v_total_peso_agregado = v_total_peso_agregado + (qrMapaProducao.PESO / 1000); }
                            if(Len(Trim(qrMapaProducao.VALOR_FRETE))) { v_total_frete_bruto_agregado = v_total_frete_bruto_agregado + qrMapaProducao.VALOR_FRETE; }
                            if(Len(Trim(qrMapaProducao.VALOR_SEM_ICMS))) { v_total_frete_sem_icms_agregado = v_total_frete_sem_icms_agregado + qrMapaProducao.VALOR_SEM_ICMS; }
                            if(Len(Trim(qrMapaProducao.TERCEIRO))) { v_total_carta_frete_agregado = v_total_carta_frete_agregado + qrMapaProducao.TERCEIRO; }
                            if(Len(Trim(qrMapaProducao.PEDAGIO))) { v_total_pedagio_agregado = v_total_pedagio_agregado + qrMapaProducao.PEDAGIO; }
                            v_total_qtd_agregado = v_total_qtd_agregado + 1;
                        }
                    </cfscript>
                    <tr class="linha_2">
                        <td nowrap align="right" height="23">#qrMapaProducao.FILIAL#</td>
                        <td nowrap align="right" height="23">#qrMapaProducao.DATA_EMISSAO#</td>
                        <td nowrap align="left" height="23">#qrMapaProducao.CENTRO_CUSTO#</td>
                        <td nowrap align="left" height="23">#qrMapaProducao.COD_CENTRO_CUSTO_GERENCIAL#</td>
                        <td nowrap align="left" height="23">#qrMapaProducao.CENTRO_CUSTO_GERENCIAL#</td>
                        <td nowrap align="center" height="23">#qrMapaProducao.NUM_ROMANEIO#</td>
                        <td nowrap align="left" height="23">#qrMapaProducao.COB_RAZAO_SOCIAL#</td>
                        <td nowrap align="right" height="23">#qrMapaProducao.HORA_EMISSAO#</td>
                        <td nowrap align="right" height="23">#qrMapaProducao.VEICULO#</td>
                        <td nowrap align="right" height="23">#qrMapaProducao.COD_VEICULO_REBOQUE#</td>
                        <td nowrap align="right" height="23">#qrMapaProducao.EMP#</td>
                        <td nowrap align="left" height="23">#qrMapaProducao.NUM_CONHECIMENTO#</td>
                        <td nowrap align="left" height="23">#qrMapaProducao.NF_CONHECIMENTO#</td>
                        <td nowrap align="left" height="23">#qrMapaProducao.MOTORISTA#</td>
                        <td nowrap align="left" height="23">#qrMapaProducao.NATUREZA#</td>
                        <td nowrap align="left" height="23">#qrMapaProducao.ORIGEM#</td>
                        <td nowrap align="left" height="23">#qrMapaProducao.ORIGEM_UF#</td>
                        <td nowrap align="left" height="23">#qrMapaProducao.DESTINO#</td>
                        <td nowrap align="left" height="23">#qrMapaProducao.DESTINO_UF#</td>
                        <td nowrap align="right" height="23">#LSNumberFormat(qrMapaProducao.KM_VAZIO, ',.__')#</td>
                        <td nowrap align="right" height="23">#LSNumberFormat(qrMapaProducao.KM_ROTA, ',.__')#</td>
                        <td nowrap align="right" height="23">#LSNumberFormat(qrMapaProducao.PESO, ',.__')#</td>
                        <td nowrap align="right" height="23">#LSNumberFormat(qrMapaProducao.VALOR_FRETE, ',.__')#</td>
                        <td nowrap align="right" height="23">#LSNumberFormat(qrMapaProducao.VALOR_SEM_ICMS, ',.__')#</td>
                        <td nowrap align="right" height="23">#LSNumberFormat(qrMapaProducao.PEDAGIO, ',.__')#</td>
                        <td nowrap align="right" height="23">#LSNumberFormat(qrMapaProducao.TERCEIRO, ',.__')#</td>
                        <td nowrap align="center" height="23">#qrMapaProducao.CARTA_FRETE#</td>
                        <td nowrap align="right" height="23">#LSNumberFormat(qrMapaProducao.FC_FE, ',.__')#</td>
                        <td nowrap align="right" height="23">#LSNumberFormat(qrMapaProducao.REAIS_KM, ',.__')#</td>
                        <td nowrap align="left" height="23">#qrMapaProducao.OPERACAO#</td>
                    </tr>
                    </cfoutput>
                    </tbody>
                    <!-- ///// -->
				</table>
            </td>
        </tr>
        <tr>
        	<td></td>
        </tr>
        <tr>
            <td>
            	<table border="1" class="borda">
					<!-- thead -->
                    <thead>
                    <tr class="titulo_1">
                        <td colspan="11" nowrap align="center">Resumo</td>
                    </tr>
                    <tr class="titulo_2">
                        <td nowrap align="right"></td>
                        <td nowrap align="right">KM</td>
                        <td nowrap align="right">Peso (Ton)</td>
                        <td nowrap align="right">Frete Bruto</td>
                        <td nowrap align="right">Frete s/ ICMS</td>
                        <td nowrap align="right">Cred. Presumido</td>
                        <td nowrap align="right">Carta Frete</td>
                        <td nowrap align="right">Qt. Conhec.</td>
                        <td nowrap align="right">FC/FE</td>
                        <td nowrap align="right">R$/KM</td>
                        <td nowrap align="right">Ped&aacute;gio</td>
                    </tr>
                    </thead>
                    <!-- ///// -->
                    
                    <!-- tbody -->
                    <tbody>
                    <tr class="linha_2">
                        <td nowrap align="right"><b>Frota</b></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_km_frota, ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_peso_frota, ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_frete_bruto_frota, ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_frete_sem_icms_frota, ',.__')#</cfoutput></td>
                        <td nowrap align="right">0,00</td>
                        <td nowrap align="right"></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_qtd_frota, ',.__')#</cfoutput></td>
                        <td nowrap align="right"></td>
                        <td nowrap align="right"><cfoutput><cfif v_total_km_frota eq 0>#LSNumberFormat(0, ',.__')#<cfelse>#LSNumberFormat(v_total_frete_sem_icms_frota / v_total_km_frota, ',.__')#</cfif></cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_pedagio_frota, ',.__')#</cfoutput></td>
                    </tr>
                    <tr class="linha_2">
                        <td nowrap align="right"><b>Terceiros</b></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_km_terceiro, ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_peso_terceiro, ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_frete_bruto_terceiro, ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_frete_sem_icms_terceiro, ',.__')#</cfoutput></td>
                        <td nowrap align="right">0,00</td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_carta_frete_terceiro, ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_qtd_terceiro, ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput><cfif v_total_frete_sem_icms_terceiro eq 0>#LSNumberFormat(0, ',.__')#<cfelse>#LSNumberFormat(v_total_carta_frete_terceiro / v_total_frete_sem_icms_terceiro, ',.__')#</cfif></cfoutput></td>
                        <td nowrap align="right"><cfoutput><cfif v_total_km_terceiro eq 0>#LSNumberFormat(0, ',.__')#<cfelse>#LSNumberFormat(v_total_frete_sem_icms_terceiro / v_total_km_terceiro, ',.__')#</cfif></cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_pedagio_terceiro, ',.__')#</cfoutput></td>
                    </tr>
                    <tr class="linha_2">
                        <td nowrap align="right"><b>Agregados</b></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_km_agregado, ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_peso_agregado, ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_frete_bruto_agregado, ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_frete_sem_icms_agregado, ',.__')#</cfoutput></td>
                        <td nowrap align="right">0,00</td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_carta_frete_agregado, ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_qtd_agregado, ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput><cfif v_total_frete_sem_icms_agregado eq 0>#LSNumberFormat(0, ',.__')#<cfelse>#LSNumberFormat(v_total_carta_frete_agregado / v_total_frete_sem_icms_agregado, ',.__')#</cfif></cfoutput></td>
                        <td nowrap align="right"><cfoutput><cfif v_total_km_agregado eq 0>#LSNumberFormat(0, ',.__')#<cfelse>#LSNumberFormat(v_total_frete_sem_icms_agregado / v_total_km_agregado, ',.__')#</cfif></cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(v_total_pedagio_agregado, ',.__')#</cfoutput></td>
                    </tr>
                    <tr class="linha_2">
                        <td nowrap align="right"></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(ArraySum(ListToArray(ValueList(qrMapaProducao.KM_ROTA))), ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat((ArraySum(ListToArray(ValueList(qrMapaProducao.PESO))) / 1000), ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(ArraySum(ListToArray(ValueList(qrMapaProducao.VALOR_FRETE))), ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(ArraySum(ListToArray(ValueList(qrMapaProducao.VALOR_SEM_ICMS))), ',.__')#</cfoutput></td>
                        <td nowrap align="right">0,00</td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(ArraySum(ListToArray(ValueList(qrMapaProducao.TERCEIRO))), ',.__')#</cfoutput></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(qrMapaProducao.RecordCount)#</cfoutput></td>
                        <td nowrap align="right"></td>
                        <td nowrap align="right"></td>
                        <td nowrap align="right"><cfoutput>#LSNumberFormat(ArraySum(ListToArray(ValueList(qrMapaProducao.PEDAGIO))), ',.__')#</cfoutput></td>
                    </tr>
                    </tbody>
                    <!-- ///// -->
                </table>
            </td>
		</tr>
    </table>
</cfif>