<cfparam name="vars.COD_PESSOA_FILIAL" default="#session.COD_PESSOA#">
<cfparam name="vars.COD_DEPARTAMENTO" default="#session.COD_DEPARTAMENTO#">
<cfparam name="vars.COD_SETOR" default="#session.COD_SETOR#">
<cfparam name="vars.COD_CENTRO_CUSTO" default="#session.COD_CENTRO_CUSTO#">
<cfparam name="vars.NUM_ROMANEIO" default="0">

<cfparam name="vars.CTF" default="0">
<cfparam name="vars.REPOM" default="0">
<cfparam name="vars.AVULSA" default="0">
<cfparam name="vars.COMPLEMENTAR" default="0">
<cfparam name="vars.DIARIA" default="0">
<html>
<cfif not Len(Trim(session.cod_setor)) >
  <script>
  	alert('Problemas com a lotao do usurio.');
	window.history.go(-1);
  </script>
</cfif>
<cfinclude template="/_scripts/scripts.cfm"/>
<cfscript>
	conn = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
	qrUnidade = conn.get_unidade();
	qrSerie   = conn.get_serie(cod_pessoa_filial = vars.COD_PESSOA_FILIAL, 
							   cod_setor         = vars.COD_SETOR, 
							   cod_departamento  = vars.COD_DEPARTAMENTO,
							   cod_centro_custo  = vars.COD_CENTRO_CUSTO,
							   cod_modelo 		 = "'X2'");
	qrSerieCTRC = conn.get_serie(cod_pessoa_filial = vars.COD_PESSOA_FILIAL, 
							     cod_setor         = vars.COD_SETOR, 
							     cod_departamento  = vars.COD_DEPARTAMENTO,
							     cod_centro_custo  = vars.COD_CENTRO_CUSTO,
							     cod_modelo 	   = "'08','57'");
	qrTipoDocto = conn.get_tipo_docto();
	
	if(vars.CTF eq 1) {
		qrItensCartaFrete = conn.get_carta_frete_item(ctf_frete = 1);
	}
	else {
		qrItensCartaFrete = conn.get_carta_frete_item(contrato_transporte = 1);
	}
	
	conn = CreateComponent("_transportes.consulta.cfc_logistico");
	qrFreteEm = conn.get_cg_ref_codes(dominio = 'LOTE.FRETE_EM');
	
	conn = CreateComponent("_transportes.consulta.cfc_global");
	v_percentual_combustivel  = conn.get_parametro_num(11, 'OPERACIONAL', 306);
	v_modulo_agregado_ativo   = conn.get_parametro_valor(11, 'OPERACIONAL', 12, 308);
	v_realiza_calculo_rpa 	  = conn.get_parametro_valor(11, 'OPERACIONAL', 43, 9);
	v_valor_pedagio_validacao = conn.get_parametro_valor(11, 'OPERACIONAL', 43, 15);
	
	conn = CreateComponent("_transportes.consulta.cfc_contrato_transporte");
	qrNum_Formulario = conn.get_prox_num_formulario(cod_pessoa_filial = vars.COD_PESSOA_FILIAL, 
					    					        cod_setor         = vars.COD_DEPARTAMENTO,
													cod_departamento  = vars.COD_SETOR, 
													cod_centro_custo  = vars.COD_CENTRO_CUSTO);
	
	if(vars.AVULSA eq 1) {
		qrUsuario = conn.get_alcada_liberacao_controle(operacao = 'AVULSO');
	}
	else {
		qrUsuario = conn.get_alcada_liberacao_controle(operacao = "CT,CT%");
	}
	
	connG = CreateComponent("_transportes.consulta.cfc_global");
	v_valor_parametro	     = connG.get_parametro_valor(25, 'FISCAL.EXE', 7, 50);
	v_gerencial_obrigatorio	 = v_valor_parametro == 'Sim' ? true : false;
</cfscript>
<script type="text/javascript"> 

	// Configura botoes // 
	parent.f_hidden('btn_editar');
	parent.f_hidden('btn_excluir');
	parent.f_hidden('btn_cancelar');
	parent.f_hidden('btn_incluir');

	<cfset vars.funcao_end = 'f_incluir()'>
	
	parent.f_set_texto( 'titulo_aplicacao', '<cf_language>Controle Log&iacute;stico</cf_language>' );
	parent.f_set_texto( 'titulo_pagina', '<cf_language>Emiss&atilde;o de Contrato de Transporte</cf_language>' );

	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); } 

	// -------------------- // 
	
	var v_emite_tabela_frete = -1;
    var v_internacional 	 = 0;
	var v_calculos_pendente  = 0;
	
	function f_confirmar() {
		with(document.forms[0]) {
			var v_divisao = 0;
			
			OPERACAO.value = 2;
			target = 'consultas';
			action = 'confirma.cfm';
			
			if(v_internacional == 1) {	
				for(var i = 0; i < document.forms[0].elements.length; i++) {
					if(document.forms[0].elements[i].tipo == 'divisao' && document.forms[0].elements[i].checked) {
						v_divisao = 1;
					}
				}
				
				if(v_divisao == 0) {
					alert(' necessrio selecionar pelo menos uma diviso.');
					return false;
				}
			}
			
			TIPO_CARGA.disabled = false;
			
			if(TIPO_CARGA.value == 3) {
				if(f_valor_campo('CARGA_ID_COLETA',document.forms[0])+f_valor_campo('CARGA_ID_ENTREGA',document.forms[0]) == '') {
					alert(' necessario indicar as cargas vinculadas a viagem!');
					return false;
				}
			}
			
			if(f_verifica_form(document.forms[0])) {
				f_habilita_todos_campos();
				
			   	submit();
			}
			
			TIPO_CARGA.disabled = true;
		}
		return false;
	}
	parent.f_confirmar = f_confirmar;	

	function f_muda_tipo_carga() {
		with(document.forms[0]) {
			FRETE_EM.disabled = true;
			FRETE_EM.value = 'LOTACAO';
			
			<cfif vars.AVULSA eq 0 and vars.COMPLEMENTAR eq 0 and vars.DIARIA eq 0>
				document.getElementById('tr_carga_normal').style.display = (TIPO_CARGA.value == 1)?'':'none';
				document.getElementById('tr_carga_fracionada').style.display = (TIPO_CARGA.value == 2)?'':'none';
			</cfif>
			
			switch (Number(TIPO_CARGA.value)) {
				case 2 : 
					<cfif vars.AVULSA eq 0 and vars.COMPLEMENTAR eq 0 and vars.DIARIA eq 0>
						if(NUM_ROMANEIO.value != '') {
							NUM_ROMANEIO.value = '';
							NUM_ROMANEIO.onchange();
						}
						NUM_MANIFESTO.obrigatorio = 1;
						NUM_ROMANEIO.obrigatorio = 0;
					</cfif>
					
					PESO.readOnly = false;
					TOLERANCIA_FALTA.readOnly = false;
					COD_UNIDADE_COMBO.disabled = false;
					M3.disabled = false;
					VOLUME.disabled = false;
					PESO.disabled = false;
					PLACA_CONTROLE.readOnly = true;
					
					break;
				case 1 : 
					<cfif vars.AVULSA eq 0 and vars.COMPLEMENTAR eq 0 and vars.DIARIA eq 0>
						if(NUM_MANIFESTO.value != '') {
							NUM_MANIFESTO.value = '';
							NUM_MANIFESTO.onchange();
						}
						NUM_ROMANEIO.obrigatorio = 1;
						NUM_MANIFESTO.obrigatorio = 0;
					</cfif>
					
					PESO.readOnly = false;
					TOLERANCIA_FALTA.readOnly = false;
					COD_UNIDADE_COMBO.disabled = false;
					M3.disabled = false;
					VOLUME.disabled = false;
					PESO.disabled = false;
					PLACA_CONTROLE.readOnly = true;
					
					break;
				case 3 : 
					<cfif vars.AVULSA eq 0 and vars.COMPLEMENTAR eq 0 and vars.DIARIA eq 0>
						NUM_ROMANEIO.obrigatorio = 0;
						NUM_MANIFESTO.obrigatorio = 0;
					</cfif>
					
					PESO.value = 0;
					PESO.readOnly = true;
					TOLERANCIA_FALTA.readOnly = true;
					COD_UNIDADE_COMBO.value = 'Kg';
					COD_UNIDADE.value = 'Kg';
					COD_UNIDADE_COMBO.disabled = true;
					M3.value = 0;
					M3.disabled = true;
					VOLUME.value = 0;
					VOLUME.disabled = true;
					PESO.disabled = true;
					PLACA_CONTROLE.readOnly = false;
					
					break;
				case 4 : 
					<cfif vars.AVULSA eq 0 and vars.COMPLEMENTAR eq 0 and vars.DIARIA eq 0>
						NUM_ROMANEIO.obrigatorio = 0;
						NUM_MANIFESTO.obrigatorio = 0;
					</cfif>
					
					PLACA_CONTROLE.readOnly = false;
					
					break;	
			}
		}
	}
	
	function f_busca_viagem_carga_dados() {
		with(document.forms[0]) {
			if(VIAGEM_CARGA_ID.value == '' || VIAGEM_CARGA_ID.value == 'undefined') {
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_contrato_transporte.cfc</cf_url>?method=get_solicitacao_carga_dados'
						,'viagem_carga_id='+VIAGEM_CARGA_ID.value
						,function (obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								with(document.forms[0]) {
									if(obj.struct.fracionado == 1) {
										TIPO_CARGA.value = 2;
									} else {
										TIPO_CARGA.value = 1;
									}
									TIPO_CARGA.onchange();
									OPERACAO_LOGISTICA.value = obj.struct.operacao[0];
									OPERACAO_ID.value = obj.struct.operacao_id[0];
								}
							}
						});
		}
	}
	
	v_calculando = false;
	function f_busca_manifesto() {
		with(document.forms[0]) {
			v_calculando = true;
			MANIFESTO_ID.value = '';
			PESO.value = '';
			VOLUME.value = '';
			M3.value = '';
			COD_UNIDADE.value = '';
			COD_UNIDADE_COMBO.value = '';
			PESO_TON.value = '';
			PLACA_CONTROLE.value = '';
			PLACA_CONTROLE.onchange();
			
			f_calculos();
			if(NUM_MANIFESTO.value == '') {
				v_calculando = false;
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_contrato_transporte.cfc</cf_url>?method=get_manifesto_ct'
						,'cod_pessoa_filial=<cfoutput>#session.cod_pessoa#</cfoutput>&num_manifesto='+NUM_MANIFESTO.value
						,function (obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								with(document.forms[0]) {
									if(obj.struct.manifesto_id.length >= 1) {
										if(obj.struct.veiculo_proprietario[0] != 3) {
											alert('Somente veiculos de Terceiros podem gerar contrato de transporte.');
											NUM_MANIFESTO.select();
											return;
										}
										if(obj.struct.vinculado_ct[0] == 1) {
											alert('Este manifesto j est vinculado a um contrato de transporte.');
											NUM_MANIFESTO.select();
											return;
										}
										if(obj.struct.vinculado_roo[0] == 1) {
											alert('Este manifesto est num romaneio que j est vinculado a um contrato de transporte.');
											NUM_MANIFESTO.select();
											return;
										}
										MANIFESTO_ID.value = obj.struct.manifesto_id[0];
										NUM_MANIFESTO.value = obj.struct.num_manifesto[0];
										PESO.value = obj.struct.peso[0];
										VOLUME.value = obj.struct.volume[0];
										M3.value = obj.struct.m3[0];
										COD_UNIDADE.value = 'Kg';
										COD_UNIDADE_COMBO.value = 'Kg';
										PESO_TON.value = obj.struct.peso_ton[0];
										f_calculos();
										PLACA_CONTROLE.value = obj.struct.placa_tracao[0];
										PLACA_CONTROLE.onchange();
										PLACA_REFERENCIA.value = obj.struct.placa_reboque[0];
										OPERACAO_ID.value = obj.struct.operacao_id[0];
										//f_busca_manifestos_romaneio();
//										f_busca_conhecimentos_manifesto();
									} else {
										alert('Nao foi possvel localizar o manifesto!');
										return;
									}
								}
							}
						});
		}
	}
	var v_clr_opt;
	function f_busca_conhecimentos_manifesto() {
		with(document.forms[0]) {
			f_limpa_select(CONHECIMENTO_ID);
			v_clr_opt = f_cria_option('', 'Aguarde, buscando os conhecimentos...', CONHECIMENTO_ID);
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_contrato_transporte.cfc</cf_url>?method=get_manifesto_conhecimento'
						,'manifesto_id=' + MANIFESTO_ID.value
						,function (obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								f_limpa_select(CONHECIMENTO_ID);
								
								for (var i = 0; i < obj.struct.manifesto_id.length; i++) {
									v_opt = f_cria_option(obj.struct.conhecimento_id[i], obj.struct.num_conhecimento[i], CONHECIMENTO_ID);
									v_opt.setAttribute('data_emissao', obj.struct.data_emissao[i]);
								}
							}
						});
		}
	}
	
	function f_calculos() {
		with(document.forms[0]) {
			ACRESCIMOS.value = toCurrency(ACRESCIMOS.value);
			DESCONTOS.value = toCurrency(DESCONTOS.value);
			//Valor do Pedgio
			v_lista = f_listagem_ACRESCIMOS();
			v_pedagio = 0;							
			for(var i=0;i<v_lista.length;i++) {
				if(v_lista[i].ACR_ITEM_ID == 1) {
					v_pedagio += Number(v_lista[i].ACR_VALOR);
				}
			}							
			
			switch (FRETE_EM.value) {
				case 'PESO' : 
					if(!(PESO.value == "" || VALOR_UNITARIO.value == "")) {
						VALOR_FRETE_LIQUIDO.value = toCurrency(Number(PESO_TON.value) * Number(VALOR_UNITARIO.value));
					}
					break;
				case 'VOLUME' :
					if(!(VOLUME.value == "" || VALOR_UNITARIO.value == "")) {
						VALOR_FRETE_LIQUIDO.value = toCurrency(Number(VOLUME.value) * Number(VALOR_UNITARIO.value));
					}	  
					break;
				case 'LOTACAO' :
					if(VALOR_UNITARIO.value != "") {
						VALOR_FRETE_LIQUIDO.value = toCurrency(Number(VALOR_UNITARIO.value));
					}
					break;
				case 'M3' :
					if(!(M3.value == "" || VALOR_UNITARIO.value == "")) { 
						VALOR_FRETE_LIQUIDO.value = toCurrency(Number(M3.value) * Number(VALOR_UNITARIO.value));
					}
					break;
			}
			
			if(!(VALOR_FRETE_LIQUIDO.value == "" || ACRESCIMOS.value == "")) {	
				VALOR_FRETE_BRUTO.value = toCurrency(Number(VALOR_FRETE_LIQUIDO.value) + Number(ACRESCIMOS.value)) - Number(v_pedagio);
			}
			
			if(!(VALOR_FRETE_LIQUIDO.value == "" || ACRESCIMOS.value == "" || DESCONTOS.value == "")) {
				VALOR_FRETE.value =  toCurrency(Number(VALOR_FRETE_LIQUIDO.value) + Number(ACRESCIMOS.value) - Number(DESCONTOS.value));
			}
			
			if(VALOR_FRETE.value != "") {
				FRETE_COMBINADO.value =  toCurrency(Number(VALOR_FRETE.value));
			}
			
			TOLERANCIA_FALTA.value = Number(TOLERANCIA_FALTA.value);
			
			f_calculo_rpa();
			f_validar_liberacao();
		}
	}
	
	function f_busca_dado_veiculo(){ 
		with(document.forms[0]) {
			var v_data;
			
			if(PLACA_CONTROLE.value == '' || PLACA_CONTROLE.value == 'undefined') {
				PROPRIETARIO_COD_PESSOA.value  	= '';
				PROPRIETARIO_CNPJ_CPF.value 	= '';
				PROPRIETARIO.value 				= '';
				PROPRIETARIO_ENDERECO.value     = '';
				PROPRIETARIO_MUNICIPIO.value 	= '';
				PROPRIETARIO_UF.value 			= '';
				MOTORISTA_COD_PESSOA.value 		= '';
				MOTORISTA_CPF.value 			= '';
				MOTORISTA.value 				= '';
				MOTORISTA_CNH.value				= '';
				MOTORISTA_CNH_VALIDADE.value	= '';
				PROPRIETARIO_NIT.value 			= '';
				PROPRIETARIO_MUNICIPIO_ID.value = '';
				
				f_busca_composicao();
				
				return;
			}
			
			<cfif vars.AVULSA eq 0 and vars.COMPLEMENTAR eq 0 and vars.DIARIA eq 0>
				v_data                        = PLACA_CONTROLE.options[PLACA_CONTROLE.selectedIndex].getAttribute('data_inicio');
				CARTAO_NUMERO_HISTORICO.value = PLACA_CONTROLE.options[PLACA_CONTROLE.selectedIndex].getAttribute('cartao_numero_historico');
			<cfelse>
				v_data 						  = DATA_EMISSAO.value + ':00';
				CARTAO_NUMERO_HISTORICO.value = '';
			</cfif>
			
			<cfif vars.REPOM eq 1>
				f_validar_cartao_historico();
			</cfif>
			
			f_query_wddx("<cf_url>/_transportes/consulta/cfc_veiculo.cfc</cf_url>?method=get_motorista_proprietario"
						,'PLACA_CONTROLE=' + PLACA_CONTROLE.value + '&DATA_EMISSAO=' + v_data
						,function (obj){ //callback functions always take one argument. This is the result passed back from the server.
							if(obj.ajax.readyState == 4) { // Quando estiver tudo pronto.
								if(obj.struct.veiculo_proprietario != 3 && Number('<cfoutput>#v_modulo_agregado_ativo#</cfoutput>') == 1) {
									alert('O veiculo vinculado (' + PLACA_CONTROLE.value + ') no pertence a um terceiro!');
									NUM_MANIFESTO.value
									PLACA_CONTROLE.value = '';
									PLACA_CONTROLE.onchange();
									
									return;
								}
								with(document.forms[0]) {
									PROPRIETARIO_COD_PESSOA.value  	= obj.struct.cod_pessoa_proprietario;
									PROPRIETARIO_CNPJ_CPF.value 	= obj.struct.cnpj_prop;
									PROPRIETARIO.value 				= obj.struct.proprietario;
									PROPRIETARIO_ENDERECO.value     = obj.struct.endereco;
									PROPRIETARIO_MUNICIPIO.value 	= obj.struct.cidade;
									PROPRIETARIO_UF.value 			= obj.struct.uf;
									MOTORISTA_COD_PESSOA.value 		= obj.struct.cod_pessoa_motorista;
									MOTORISTA_CPF.value 			= obj.struct.cpf_motorista;
									MOTORISTA.value 				= obj.struct.nome_motorista;				
									MOTORISTA_CNH.value				= obj.struct.cnh_numero;
									MOTORISTA_CNH_VALIDADE.value	= (obj.struct.cnh_validade != '')?f_format_date(obj.struct.cnh_validade):'';
									PROPRIETARIO_NIT.value 			= obj.struct.pis_pasep_nit;
									PROPRIETARIO_MUNICIPIO_ID.value = obj.struct.proprietario_municipio_id;
									
									f_busca_composicao();
									f_calculos();
									
									return true;
								}	
							}	
						});
		}
	}	
	
	function f_calcula_peso_ton() {
		with(document.forms[0]) {
			PESO_TON.value = '';
			if(PESO.value == '' || COD_UNIDADE.value == '') {
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_logistico.cfc</cf_url>?method=converte_unidade'
						,'valor='+PESO.value+'&unidade_origem='+COD_UNIDADE.value+'&unidade_destino=Ton'
						,function (obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								with(document.forms[0]) {
									PESO_TON.value = obj.struct;
									f_calculos();

								}
							}
						})	
		}
		if (document.forms[0].PLACA_CONTROLE.value) {
		   f_calculos_tabela_frete();
		}
	}
	
	function f_on_incluir() {
		with(document.forms[0]) {
			<cfoutput>
				f_desabilitar_botao('confirmar');
				
				<cfif vars.AVULSA eq 0>
					TIPO_CARGA.value = 1;
				<cfelse>
					TIPO_CARGA.value = 4;
				</cfif>
				
				TIPO_CARGA.onchange();
				
				<cfif isdefined("vars.num_romaneio") && vars.num_romaneio neq 0 and vars.REPOM eq 0>
					TIPO_CARGA.disabled = true;
					NUM_ROMANEIO.value = '#NumberFormat(vars.num_romaneio, '0')#';
					NUM_ROMANEIO.onchange();
					NUM_ROMANEIO.readOnly = true;
					OPERACAO_ID.value = '#vars.operacao_id#';
					VIAGEM_CARGA_ID.value = '#vars.viagem_carga_id#';
					VIAGEM_CARGA_ID.onchange();
					//NUM_FORMULARIO.focus();
					PLACA_REFERENCIA.value = '#vars.placa_referencia#';
					VOLTAR_MENU.value = 1;
				<cfelseif isdefined("vars.num_romaneio") && vars.num_romaneio neq 0 and vars.REPOM eq 1>
					TIPO_CARGA.disabled = true;
					NUM_ROMANEIO.value = '#NumberFormat(vars.num_romaneio, '0')#';
					NUM_ROMANEIO.onchange();
					NUM_ROMANEIO.readOnly = true;
					VOLTAR_MENU.value = 1;
				</cfif>
				
				NUM_FORMULARIO.value = <cfoutput>'#qrNum_Formulario.PROX_NUM_FORMULARIO#'</cfoutput>;
			</cfoutput>
		}
	}
	
	function f_muda_conhecimento_manifesto() {
		with(document.forms[0]) {
			<cfif vars.CTF eq 0 and vars.REPOM eq 0>
				NUM_FORMULARIO.value = '';
				NUM_FORMULARIO.readOnly = false;
				
				try { 
				DATA_EMISSAO.value = CONHECIMENTO_ID.options[CONHECIMENTO_ID.selectedIndex].data_emissao;
				} catch(e) {}
				CONHECIMENTO_ID.value = CONHECIMENTO_ID_ROMANEIO.value;
				
				if(SERIE_FORMULARIO.options[SERIE_FORMULARIO.selectedIndex].getAttribute('formulario') == 22 || SERIE_FORMULARIO.options[SERIE_FORMULARIO.selectedIndex].getAttribute('formulario') == 3 ){
					NUM_FORMULARIO.value = CONHECIMENTO_ID.options[CONHECIMENTO_ID.selectedIndex].text;
					NUM_FORMULARIO.readOnly = true;
				}else{
					NUM_FORMULARIO.readOnly = false;
					//Busca N do Formulrio
					f_query_wddx('<cf_url>/_transportes/consulta/cfc_contrato_transporte.cfc</cf_url>?method=get_prox_num_formulario_limite'
							,'cod_pessoa_filial=' + <cfoutput>#vars.COD_PESSOA_FILIAL#</cfoutput> +
							'&cod_setor=' + <cfoutput>#vars.COD_DEPARTAMENTO#</cfoutput> +
							'&cod_departamento=' + <cfoutput>#vars.COD_SETOR#</cfoutput> +
							'&cod_centro_custo=' + <cfoutput>#vars.COD_CENTRO_CUSTO#</cfoutput> +
							'&serie=' +  SERIE_FORMULARIO.value +
							'&cod_modelo=X2'
							
							,function (obj) {
								if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
									with(document.forms[0]) {
										NUM_FORMULARIO.value = obj.struct.prox_num_formulario[0];									
									}
								}
							});
				}
			</cfif>
		}
	}
	
	function f_busca_romaneio() {
		with(document.forms[0]) {
			APENAS_COMPLEMENTOS.value = 0;
			
			if (NUM_ROMANEIO.value == '') {
				NUM_FORMULARIO.readOnly = false;
				f_limpa_select(CONHECIMENTO_ID_ROMANEIO);
				v_option = f_cria_option('', '-- Selecione o Romaneio --', CONHECIMENTO_ID_ROMANEIO);
				v_option.setAttribute('data_emissao', '');
				
				f_busca_veiculos_romaneio();
				
				return false;				
			}
			
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_emissao_documentos.cfc</cf_url>?method=get_romaneio_ct'
						,'num_romaneio=' + NUM_ROMANEIO.value
						,function (obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								with(document.forms[0]) {
									if (!obj.struct.operacao[0]) {
										alert('Dados do romaneio no encontrados!');
										return false;	 
									}
									if(obj.struct.vinculado_ct[0] == 1) {
									}
									OPERACAO_ID.value    	 = obj.struct.operacao_id[0];
									OPERACAO_LOGISTICA.value = obj.struct.operacao[0];
									f_busca_organizacional(OPERACAO_ID.value);
									
									VIAGEM_CARGA_ID.value 	 = obj.struct.viagem_carga_id[0];
									PESO.value	      		 = obj.struct.peso[0];
									M3.value	      		 = obj.struct.m3[0];
									VOLUME.value      		 = obj.struct.volume[0];
									COD_UNIDADE_COMBO.value  = obj.struct.cod_unidade[0];
									COD_UNIDADE_COMBO.onchange();
									/*PLACA_CONTROLE.value 	 = obj.struct.placa_controle[0];
									PLACA_CONTROLE.onchange();*/
									
									<cfif vars.REPOM eq 1>
										ROTA_ID.value			 = obj.struct.rota_id[0];
										ROTA_DESCRICAO.value	 = obj.struct.descricao_rota[0];
										CARTAO_NUMERO.value 	 = obj.struct.cartao_numero[0];
										
										<cfif vars.AVULSA eq 0>
											VALOR_PEDAGIO_ROTA.value = Number(obj.struct.valor_pedagio_rota[0]).toFixed(2);
										<cfelse>
											VALOR_PEDAGIO_ROTA.value = '0.00';
										</cfif>
									</cfif>
									
									v_internacional = Number(obj.struct.internacional[0]);
									
									f_busca_veiculos_romaneio();
									f_busca_ctrc_romaneio();
									f_busca_divisao_crt();
								}
							}
						});
		}
	}
	
	function f_busca_veiculos_romaneio() {
		with(document.forms[0]) {
			var v_option;
			
			f_limpa_select(PLACA_CONTROLE);
			
			if(!NUM_ROMANEIO.value) {
				f_limpa_select(PLACA_CONTROLE);
				
				v_option = f_cria_option('', '-- Selecione --', PLACA_CONTROLE);
				v_option.setAttribute('placa_referencia', '');
				v_option.setAttribute('data_inicio', '');
				v_option.setAttribute('cartao_numero_historico', '');
				
				f_busca_dado_veiculo();
				
				return;
			}
			
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_contrato_transporte.cfc</cf_url>?method=get_veiculos_romaneio'
						,'num_romaneio=' + NUM_ROMANEIO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {							
								if(obj.struct.placa_controle.length > 0) {
									v_option = f_cria_option('', '-- Selecione --', PLACA_CONTROLE);
									v_option.setAttribute('placa_referencia', '');
									v_option.setAttribute('data_inicio', '');
									v_option.setAttribute('cartao_numero_historico', '');
									
									for(var i = 0; i < obj.struct.placa_controle.length; i++) {
										v_option = f_cria_option(obj.struct.placa_controle[i], obj.struct.placa_controle[i], PLACA_CONTROLE);
										v_option.setAttribute('placa_referencia', obj.struct.placa_referencia[i]);
										v_option.setAttribute('data_inicio', obj.struct.data_inicio[i]);
										v_option.setAttribute('cartao_numero_historico', obj.struct.cartao_numero_historico[i]);
									}
									
									if(PLACA_CONTROLE.options.length == 2) {
										PLACA_CONTROLE.options[0] = null;
										PLACA_CONTROLE.options[0].selected = true;
									}
								}
								else {
									v_option = f_cria_option('', '-- Informe o Romaneio --', PLACA_CONTROLE);
									v_option.setAttribute('placa_referencia', '');
									v_option.setAttribute('data_inicio', '');
									v_option.setAttribute('cartao_numero_historico', '');
										
									alert('O romaneio informado no possui histricos de veculos.')
								}
								
								f_busca_dado_veiculo();
							}
						});
		}
	}

	function f_busca_organizacional(p_operacao_id) {
		with(document.forms[0]) {
			f_limpa_select(ORGANIZACIONAL_ID);
			COD_ORGANIZACIONAL.value = '';
			
			var v_filtro = '';
			if(p_operacao_id != '' && p_operacao_id != null) {
				v_filtro = 'operacao_id=' + p_operacao_id + '&entrada_saida=1';
			}
			else {
				return;
			}
			
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_emissao_documentos.cfc</cf_url>?method=get_organizacional'
						,v_filtro
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.organizacional_id.length > 0) {
									if(obj.struct.organizacional_id.length > 1) {
										v_opt = f_cria_option('', '-- Selecione --', ORGANIZACIONAL_ID);
										v_opt.setAttribute('codigo', '');
									}
									
									for(var i = 0; i < obj.struct.organizacional_id.length; i++) {
										v_opt = f_cria_option(obj.struct.organizacional_id[i], obj.struct.descricao_completa[i], ORGANIZACIONAL_ID);
										v_opt.setAttribute('codigo', obj.struct.cod_organizacional[i]);
									}
									
									if(obj.struct.organizacional_id.length == 1) {
										ORGANIZACIONAL_ID.onchange();
										ORGANIZACIONAL_ID.disabled = true;
										COD_ORGANIZACIONAL.readOnly = true;
									}
									else {
										ORGANIZACIONAL_ID.disabled = false;
										COD_ORGANIZACIONAL.readOnly = false;
									}
									
								}
								<cfif v_gerencial_obrigatorio >
								else {
									alert('Nenhum Centro de Custo Gerencial foi encontrado para esta operao.');
								}
								</cfif>
							}
						});
		}
	}
	
	
	function f_muda_organizacional() {
		with(document.forms[0]) {
			for(var i = 0; i < ORGANIZACIONAL_ID.options.length; i++) {
				if(ORGANIZACIONAL_ID.options[i].getAttribute('codigo') == COD_ORGANIZACIONAL.value) {
					ORGANIZACIONAL_ID.options[i].selected = true;
					return;
				}
			}
			ORGANIZACIONAL_ID.value = '';
			alert('Centro de Custo Gerencial no encontrado.');
		}
	}
	
	function f_busca_composicao(p_busca_item) {
		with(document.forms[0]) {
			if(!PLACA_CONTROLE.value) {
				PLACA_REFERENCIA.value = '';
				
				<cfif vars.REPOM eq 1>
					f_verificar_roteiro(0);
				<cfelse>
					f_calculos_tabela_frete();
				</cfif>
				
				return;
			}
			
			<cfif vars.AVULSA eq 0 and vars.COMPLEMENTAR eq 0 and vars.DIARIA eq 0>
				PLACA_REFERENCIA.value = PLACA_CONTROLE.options[PLACA_CONTROLE.selectedIndex].getAttribute('placa_referencia');
				
				<cfif vars.REPOM eq 1>
					f_verificar_roteiro(0);
				<cfelse>
					f_calculos_tabela_frete();
				</cfif>
				
				return;
			</cfif>
			
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_veiculo.cfc</cf_url>?method=get_composicao'
						,'cod_veiculo=' + PLACA_CONTROLE.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								with(document.forms[0]) {
									PLACA_CONTROLE.value = obj.struct.placa[0];
									PLACA_REFERENCIA.value = (obj.struct.placa.length == 1)?obj.struct.placa[0]:obj.struct.placa[1];
									
									<cfif vars.REPOM eq 1>
										f_verificar_roteiro(0);
									<cfelse>
										f_calculos_tabela_frete();
									</cfif>
								}
							}
						});
		}
	}
	
	function f_busca_ctrc_romaneio() {
		with(document.forms[0]) {
			f_limpa_select(CONHECIMENTO_ID_ROMANEIO);
			f_limpa_select(CONHECIMENTO_ID);
			f_cria_option('', 'Aguarde, buscando conhecimentos...', CONHECIMENTO_ID_ROMANEIO);
			f_cria_option('', 'Aguarde, buscando conhecimentos...', CONHECIMENTO_ID);
			
			if(v_internacional == 1) {
				return;
			}
			
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_emissao_documentos.cfc</cf_url>?method=get_ctrc_romaneio'
						,'num_romaneio='+NUM_ROMANEIO.value
						,function (obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								f_limpa_select(CONHECIMENTO_ID_ROMANEIO);
								f_limpa_select(CONHECIMENTO_ID);
								
								for(var i = 0; i < obj.struct.conhecimento_id.length; i++) {
									if((Number(APENAS_COMPLEMENTOS.value) == 0 || obj.struct.conhecimento_id_complementado[i] != '') && (obj.struct.ct_vinculado[i] == 0)) {
										v_opt = f_cria_option(obj.struct.conhecimento_id[i], obj.struct.num_conhecimento[i], CONHECIMENTO_ID_ROMANEIO);
										v_opt.setAttribute('data_emissao', obj.struct.data_emissao[i]);
										v_opt.setAttribute('conhecimento_id_complementado', obj.struct.conhecimento_id_complementado[i]);
										
										<cfif isdefined("vars.conhecimento_id")>
										if(String(obj.struct.conhecimento_id[i]) == '<cfoutput>#vars.conhecimento_id#</cfoutput>') {
											v_opt.selected = true;
										}
										</cfif>
										
										v_opt2 = f_cria_option(obj.struct.conhecimento_id[i], obj.struct.num_conhecimento[i], CONHECIMENTO_ID);
										v_opt2.setAttribute('data_emissao', obj.struct.data_emissao[i]);
										v_opt2.setAttribute('conhecimento_id_complementado', obj.struct.conhecimento_id_complementado[i]);
									}
								}
								
								CONHECIMENTO_ID_ROMANEIO.onchange();
							}
						});
		}
	}
	
	function f_calculo_abast() {
		with(document.forms[0]) {
			POSTO_QUANTIDADE.value = toCurrency(Number(POSTO_QUANTIDADE.value));
			POSTO_VALOR_UNITARIO.value = toCurrency(Number(POSTO_VALOR_UNITARIO.value));
			POSTO_VALOR_TOTAL.value = toCurrency(Number(POSTO_QUANTIDADE.value)*Number(POSTO_VALOR_UNITARIO.value));
			ACR_VALOR.value = POSTO_VALOR_TOTAL.value;
		}
	}
	
	function f_muda_produto() {
		with(document.forms[0]) {
			if(ACR_ITEM_ID.value == -2) {
				document.getElementById('tb_posto').style.display = '';
				document.getElementById('sp_valor_item').style.display = 'none';
				POSTO_COD_PESSOA.obrigatorio = 1;
				POSTO_VALOR_UNITARIO.obrigatorio = 1;
				POSTO_QUANTIDADE.obrigatorio = 1;
			} else {
				document.getElementById('tb_posto').style.display = 'none';
				document.getElementById('sp_valor_item').style.display = '';
				POSTO_COD_PESSOA.obrigatorio = 0;
				POSTO_VALOR_UNITARIO.obrigatorio = 0;
				POSTO_QUANTIDADE.obrigatorio = 0;
			}
		}
	}
	

	function f_limpa_POSTO() {
		with(document.forms[0]) {
			POSTO_COD_PESSOA.value = '';
			POSTO.value = '';
			POSTO_CNPJ_CPF.value = '';
			POSTO_VALOR_UNITARIO.value = '';
		}
	}
		
	function f_busca_pessoa_POSTO() {
		with(document.forms[0]) {
			v_cnpj = POSTO_CNPJ_CPF.value;
			f_limpa_POSTO();
			POSTO_CNPJ_CPF.value = v_cnpj;
			if (true || POSTO_CNPJ_CPF.value.length > 4) {
				f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=get_pessoa_light'
							,'rapida=1&posto=1&num_modalidade=12&cnpj_cpf='+POSTO_CNPJ_CPF.value
							,function(obj) {
								if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
									if(obj.struct.cod_pessoa.length > 0) {
										POSTO_CNPJ_CPF.value = obj.struct.cnpj_cpf[0];
										POSTO_COD_PESSOA.value = obj.struct.cod_pessoa[0];
										POSTO.value = (obj.struct.razao_social[0] == '')?obj.struct.cliente[0]:obj.struct.razao_social[0];
										if(Number(obj.struct.preco_diesel[0]) == 0) {
	//										POSTO_VALOR_UNITARIO.value = '';
										} else {	
											POSTO_VALOR_UNITARIO.value = toCurrency(obj.struct.preco_diesel[0]);
										}
									}
									else {
										v_cnpj = POSTO_CNPJ_CPF.value;
										f_limpa_POSTO();
										POSTO_CNPJ_CPF.value = v_cnpj;
										alert('Nenhum posto encontrado!')
									}
								}
							});
				}
		}
	}
	
	function f_calculo_rpa() {
		with(document.forms[0]) {
			<cfif v_realiza_calculo_rpa eq 0>
				return false;
			</cfif>
			
			if(DATA_EMISSAO.value == '') {
				return;
			}
			if(VALOR_FRETE_LIQUIDO.value == '') {
				return;
			}
			if(PROPRIETARIO_COD_PESSOA.value == '') {
				return;
			}
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_emissao_documentos.cfc</cf_url>?method=calculo_rpa'
						, 'cod_pessoa=' + PROPRIETARIO_COD_PESSOA.value
						+ '&data=' + DATA_EMISSAO.value
						+ '&valor_servico=' + VALOR_FRETE_LIQUIDO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								VALOR_INSS.value = toCurrency(Number(obj.struct.valor_inss));
								VALOR_SEST.value = toCurrency(Number(obj.struct.valor_sest));
								VALOR_SENAT.value = toCurrency(Number(obj.struct.valor_senat));
								VALOR_IRRF.value = toCurrency(Number(obj.struct.valor_irrf));
								BASE_CALC_INSS.value = toCurrency(Number(obj.struct.base_calc_inss));
								BASE_CALC_SEST_SENAT.value = toCurrency(Number(obj.struct.base_calc_sest_senat));
								BASE_CALC_IRRF.value = toCurrency(Number(obj.struct.base_calc_irrf));
								f_tipo_pessoa();
							}
						});
		}
	}
	
	function f_prenche_romaneio(){
		with(document.forms[0]) {
			NUM_ROMANEIO.value = <cfoutput>#vars.num_romaneio#</cfoutput>;
		}
		f_busca_romaneio()
	}
	
	function f_muda_serie(){
		f_busca_romaneio();
	}
	
	function f_tipo_pessoa(){
		with(document.forms[0]) {
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_acesso.cfc</cf_url>?method=get_pessoa_light'
							, 'cod_pessoa=' + PROPRIETARIO_COD_PESSOA.value
							,function(obj) {
								if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
									if(obj.struct.tipo_pessoa == 0){
										VALOR_INSS.value = '0,00';
										VALOR_SEST.value = '0,00';
										VALOR_SENAT.value = '0,00';
										VALOR_IRRF.value = '0,00';
										BASE_CALC_INSS.value = '0,00';
										BASE_CALC_SEST_SENAT.value = '0,00';
										BASE_CALC_IRRF.value = '0,00';
									}
								}
							});
		}
	}
	
	function f_busca_placa_referencia(){ 
		with(document.forms[0]) {
			if(PLACA_REFERENCIA.value == '' || PLACA_REFERENCIA.value == 'undefined') {
			   return;
			}
			f_query_wddx("<cf_url>/_transportes/consulta/cfc_veiculo.cfc</cf_url>?method=get_veiculo_localizar"
						,'trazer_proprietario=1&PLACA='+PLACA_REFERENCIA.value
						,function (obj){ //callback functions always take one argument. This is the result passed back from the server.
							if(obj.ajax.readyState == 4) { // Quando estiver tudo pronto.
								if(obj.struct.placa.length == 0) {
									alert('O veiculo (' + PLACA_REFERENCIA.value + ') no est cadastrado ou est inativo!');
									PLACA_REFERENCIA.value = '';
									return false;
 								}
							}	
						});
		}
	}
	
	function f_busca_pessoa(p_chave, p_tipo) {
		with(document.forms[0]) {
			document.getElementById(p_chave).value        		  	= '';
			document.getElementById(p_tipo + '_NOME').value 		= '';
			document.getElementById(p_tipo + '_ENDERECO').value 	= '';
			document.getElementById(p_tipo + '_MUNICIPIO_ID').value = '';
			
			if(!document.getElementById(p_tipo + '_CNPJ').value) {
				f_calculos_tabela_frete();
				
				return;	
			}
			
			document.getElementById(p_tipo + '_NOME').value = 'Buscando pessoa...';
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=get_pessoa_light'
						,'cnpj_cpf=' + document.getElementById(p_tipo + '_CNPJ').value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.cod_pessoa.length > 0) {
									document.getElementById(p_chave).value        		  	= obj.struct.cod_pessoa[0];
									document.getElementById(p_tipo + '_CNPJ').value 		= obj.struct.cnpj_cpf[0];
									document.getElementById(p_tipo + '_NOME').value 		= obj.struct.cliente[0];
									document.getElementById(p_tipo + '_ENDERECO').value 	= obj.struct.endereco_completo[0];
									document.getElementById(p_tipo + '_MUNICIPIO_ID').value = obj.struct.municipio_id[0];
								}
								else {
									document.getElementById(p_tipo + '_NOME').value = 'Pessoa no encontrada';
								}
								
								f_calculos_tabela_frete();
							}
						});
		}
	}
	
	function f_busca_natureza() {
		with(document.forms[0]) {
			if(!NUM_NATUREZA.value) {
				NATUREZA.value = '';
				
				f_calculos_tabela_frete();
				
				return;
			}
			
			NATUREZA.value = 'Buscanco natureza...';
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_emissao_documentos.cfc</cf_url>?method=get_natureza'
						,'num_natureza=' + NUM_NATUREZA.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.num_natureza.length == 1) {
									NATUREZA.value = obj.struct.descricao[0];
								}
								else {
									NUM_NATUREZA.value = '';
									NATUREZA.value 	   = '';
									
									alert('Natureza no encontrada.');
								}
								
								f_calculos_tabela_frete();
							}
						});
		}
	}
	
	function f_busca_operacao() {
		with(document.forms[0]) {
			if(!OPERACAO_ID.value) {
				OPERACAO_LOGISTICA.value = '';
				
				f_busca_organizacional(OPERACAO_ID.value);
				f_calculos_tabela_frete();
				
				return;
			}
			
			OPERACAO_LOGISTICA.value = 'Buscando operao...';
			f_query_wddx('<cf_url>/_transportes/consulta/logistica/cfc_operacao.cfc</cf_url>?method=get_operacao'
						,'operacao_id=' + OPERACAO_ID.value
					    +'&cod_organograma=' + <cfoutput>#session.cod_organograma#</cfoutput>
						+'&internacional=0'
						+'&somente_ativas=1'
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.operacao_id.length == 1) {
									OPERACAO_LOGISTICA.value = obj.struct.descricao[0];
								}
								else {
									OPERACAO_ID.value 		 = '';
									OPERACAO_LOGISTICA.value = '';
									alert('Operao no encontrada.');
								}
								
								f_busca_organizacional(OPERACAO_ID.value);
								f_calculos_tabela_frete();
							}
						});
		}
	}
	
	function f_calculos_tabela_frete() {
		with(document.forms[0]) {
			var v_return = false;
			var v_list_item;
			
			f_desabilitar_botao('confirmar');
			
			<cfif vars.AVULSA eq 0 and vars.COMPLEMENTAR eq 0 and vars.DIARIA eq 0>
				// N Romaneio
				v_list_item = document.getElementById('li_num_romaneio');
				
				if(NUM_ROMANEIO.value) {
					f_alterar_item_checklist(v_list_item, 1);
				}
				else {
					f_alterar_item_checklist(v_list_item, 0);
					v_return = true;
				}
			<cfelseif vars.AVULSA eq 1>
				// Natureza
				v_list_item = document.getElementById('li_natureza');
				
				if(NUM_NATUREZA.value) {
					f_alterar_item_checklist(v_list_item, 1);
				}
				else {
					f_alterar_item_checklist(v_list_item, 0);
					v_return = true;
				}
				
				// Operao
				v_list_item = document.getElementById('li_operacao');
				
				if(OPERACAO_ID.value) {
					f_alterar_item_checklist(v_list_item, 1);
				}
				else {
					f_alterar_item_checklist(v_list_item, 0);
					v_return = true;
				}
				
				// Placa Cavalo
				v_list_item = document.getElementById('li_placa_cavalo');
				
				if(PLACA_CONTROLE.value) {
					f_alterar_item_checklist(v_list_item, 1);
				}
				else {
					f_alterar_item_checklist(v_list_item, 0);
					v_return = true;
				}
				
				// Remetente
				v_list_item = document.getElementById('li_remetente');
				
				if(COD_REMETENTE.value) {
					if(REM_MUNICIPIO_ID.value) {
						f_alterar_item_checklist(v_list_item, 1);
					}
					else {
						f_alterar_item_checklist(v_list_item, 0);
						alert('O remetente selecionado no possui municpio.');
						
						v_return = true;
					}
				}
				else {
					f_alterar_item_checklist(v_list_item, 0);
					v_return = true;
				}
				
				// Destinatrio
				v_list_item = document.getElementById('li_destinatario');
				
				if(COD_DESTINATARIO.value) {
					if(DEST_MUNICIPIO_ID.value) {
						f_alterar_item_checklist(v_list_item, 1);
					}
					else {
						f_alterar_item_checklist(v_list_item, 0);
						alert('O destinatrio selecionado no possui municpio.');
						
						v_return = true;
					}
					
				}
				else {
					f_alterar_item_checklist(v_list_item, 0);
					v_return = true;
				}
			<cfelseif vars.COMPLEMENTAR eq 1>
				// N Romaneio
				v_list_item = document.getElementById('li_complemento');
				
				if(NUM_ROMANEIO.value) {
					f_alterar_item_checklist(v_list_item, 1);
				}
				else {
					f_alterar_item_checklist(v_list_item, 0);
					v_return = true;
				}
			<cfelseif vars.DIARIA eq 1>
				// N Romaneio
				v_list_item = document.getElementById('li_diaria');
				
				switch(Number(TIPO_DIARIA.value)) {
					case 1:
						if(DIARIA_CTRC_ID.value) {
							f_alterar_item_checklist(v_list_item, 1);
						}
						else {
							f_alterar_item_checklist(v_list_item, 0);
							v_return = true;
						}
						
						break;
					case 2: 
						if(DIARIA_CRT_ID.value) {
							f_alterar_item_checklist(v_list_item, 1);
						}
						else {
							f_alterar_item_checklist(v_list_item, 0);
							v_return = true;
						}
						
						break;
					default:
						f_alterar_item_checklist(v_list_item, 0);
						v_return = true;
						
						break;
				}
				
				
			</cfif>
			
			if(v_return) {
				document.getElementById('tr_negociacao_checklist').style.display = '';
				document.getElementById('tr_negociacao_tabela_frete').style.display = 'none';
				return;
			}
			
			CONSULTA.value = 6;
			target = 'consultas';
			action = 'consultas.cfm';
			submit();
			
			document.getElementById('tr_negociacao_checklist').style.display = 'none';
			document.getElementById('tr_negociacao_carregando').style.display = '';
			document.getElementById('tr_negociacao_info').style.display = '';
		}
	}
	
	function f_alterar_item_checklist(p_list_item, p_item_ok) {
		if(p_item_ok == 1) {
			p_list_item.className = 'texto_negrito';
			p_list_item.style.listStyleImage = "url('/_imagens/botoes/10x10/confirmar.gif')";
		}
		else {
			p_list_item.className = 'obrigatorio';
			p_list_item.style.listStyleImage = 'none';
		}
	}
	
	function f_validar_liberacao() {
		with(document.forms[0]) {
			var v_percentual_receita;
			
			if(v_emite_tabela_frete == 0) {
				if(Number(TOTAL_RECEITA.value) > 0) {
					<cfif vars.REPOM eq 1 and v_valor_pedagio_validacao eq 1>
						v_percentual_receita = Number((Number(VALOR_FRETE_LIQUIDO.value) + Number(VALOR_PEDAGIO_ROTA.value) + Number(VALOR_CF_ACUMULADO.value)) / Number(TOTAL_RECEITA.value) * 100).toFixed(2);
					<cfelse>
						v_percentual_receita = Number((Number(VALOR_FRETE_LIQUIDO.value) + Number(VALOR_CF_ACUMULADO.value)) / Number(TOTAL_RECEITA.value) * 100).toFixed(2);
					</cfif>
				}
				else {
					v_percentual_receita = '0.00';
				}
				document.getElementById('td_valor_receita').innerHTML = v_percentual_receita + ' %';
			}
			else if(v_emite_tabela_frete == 1) {
				document.getElementById('td_valor_receita').innerHTML = Number(VALOR_MAXIMO.value).toFixed(2);
			}
			else {
				document.getElementById('td_label_receita').innerHTML = '';
				document.getElementById('td_valor_receita').innerHTML = '';
			}
			
			<cfif vars.AVULSA eq 0>
				<cfif vars.REPOM eq 1 and v_valor_pedagio_validacao eq 1>
				if((Number(VALOR_FRETE_LIQUIDO.value) + Number(VALOR_PEDAGIO_ROTA.value) + Number(VALOR_CF_ACUMULADO.value)) > Number(VALOR_MAXIMO.value)) {
				<cfelse>
				if((Number(VALOR_FRETE_LIQUIDO.value) + Number(VALOR_CF_ACUMULADO.value)) > Number(VALOR_MAXIMO.value)) {
				</cfif>
					document.getElementById('tr_liberacao').style.display = '';
					OBSERVACAO.setAttribute('obrigatorio', 1);
				}
				else {
					document.getElementById('tr_liberacao').style.display = 'none';
					USUARIO_LIBERACAO.value = '';
					SENHA_LIBERACAO.value   = '';
					OBSERVACAO.setAttribute('obrigatorio', 0);
				}
			<cfelse>
				document.getElementById('tr_liberacao').style.display = '';
				OBSERVACAO.setAttribute('obrigatorio', 1);
			</cfif>
		}
	}
	
	function f_busca_divisao_crt() {
		with(document.forms[0]) {
			if(v_internacional == 0){
				return;
			}
			
			f_query_ajax('<cf_url>/aplicacoes/controle_documentos/contrato_transporte/emitir/forms/divisao_crt.cfm</cf_url>' +
						'?num_romaneio=' + NUM_ROMANEIO.value
						,function(obj) {
							document.getElementById('td_divisao_crt').innerHTML = obj;
						});
		}
	}
	
	var v_cod_pessoa = 0;
	
	function f_ajusta_valor(obj, p_cod_pessoa, p_placa_controle) {
		with(document.forms[0]) {
			v_cod_pessoa = p_cod_pessoa;
			PLACA_CONTROLE.value = p_placa_controle;
			PLACA_CONTROLE.onchange();
			
			f_soma_divisao();
		}
	}
	
	function f_soma_divisao() {
		with(document.forms[0]) {
			TOTAL_RECEITA.value = 0;
			v_marcado = 0;
			
			// Verifica se pelo menos um est marcado
			for (var i=0; i<document.forms[0].elements.length; i++) {
				if (document.forms[0].elements[i].tipo == 'divisao' && document.forms[0].elements[i].checked) {
					v_marcado = 1;
				}
			}
			
			for (var i=0; i<document.forms[0].elements.length; i++) {
				if (document.forms[0].elements[i].tipo == 'divisao' && document.forms[0].elements[i].checked) {
					TOTAL_RECEITA.value = (Number(TOTAL_RECEITA.value) + Number(document.forms[0].elements[i].valor)).toFixed(2);
				}
				if (document.forms[0].elements[i].tipo == 'divisao') {
				  if (Number(document.forms[0].elements[i].cod_motorista) == Number(v_cod_pessoa) || v_marcado == 0)
	  				 document.forms[0].elements[i].disabled = false;
				  else 
					 document.forms[0].elements[i].disabled = true;
				}
			}
		}
	}
	
	<cfif vars.DIARIA eq 1>
		function f_muda_tipo_diaria() {
			with(document.forms[0]) {
				document.getElementById('tr_diaria_ctrc').style.display = (TIPO_DIARIA.value == 1) ? '' : 'none';
				document.getElementById('tr_diaria_crt').style.display = (TIPO_DIARIA.value == 2) ? '' : 'none';
				
				DIARIA_NUM_CTRC.value   = '';
				CTRC_DIARIA_SERIE.value = '';
				DIARIA_CTRC_ID.value  	= '';
				DIARIA_NUM_CRT.value  	= '';
				DIARIA_CRT_ID.value   	= '';
				
				switch(Number(TIPO_DIARIA.value)) {
					case 1:
						DIARIA_NUM_CTRC.setAttribute('obrigatorio', 1);
						CTRC_DIARIA_SERIE.setAttribute('obrigatorio', 1);
						DIARIA_CTRC_ID.setAttribute('obrigatorio', 1);
						DIARIA_NUM_CRT.setAttribute('obrigatorio', 0);
						DIARIA_CRT_ID.setAttribute('obrigatorio', 0);
						break;
					case 2: 
						DIARIA_NUM_CTRC.setAttribute('obrigatorio', 0);
						CTRC_DIARIA_SERIE.setAttribute('obrigatorio', 0);
						DIARIA_CTRC_ID.setAttribute('obrigatorio', 0);
						DIARIA_NUM_CRT.setAttribute('obrigatorio', 1);
						DIARIA_CRT_ID.setAttribute('obrigatorio', 1);
						break;
					default:
						DIARIA_NUM_CTRC.setAttribute('obrigatorio', 0);
						CTRC_DIARIA_SERIE.setAttribute('obrigatorio', 0);
						DIARIA_CTRC_ID.setAttribute('obrigatorio', 0);
						DIARIA_NUM_CRT.setAttribute('obrigatorio', 0);
						DIARIA_CRT_ID.setAttribute('obrigatorio', 0);
						break;
				}
			}
		}
		
		function f_busca_ctrc_valor() {		
			with(document.forms[0]) {
				DIARIA_CTRC_ID.value = '';
				
				if(!DIARIA_NUM_CTRC.value || !CTRC_DIARIA_SERIE.value) {
					OPERACAO_ID.value    	 = '';
					OPERACAO_LOGISTICA.value = '';
					
					f_busca_organizacional(OPERACAO_ID.value);
					
					PLACA_CONTROLE.value     = '';
					PLACA_CONTROLE.onchange();
					PESO.value	      		 = '';
					COD_UNIDADE_COMBO.value  = '';
					COD_UNIDADE_COMBO.onchange();
					M3.value	      		 = 0;
					VOLUME.value      		 = '';
					
					<cfif vars.REPOM eq 1>
						CARTAO_NUMERO.value = '';
					</cfif>
					
					CARTAO_NUMERO_HISTORICO.value = '';
					
					f_calculos_tabela_frete();
					
					return false;
				}
				
				f_query_wddx('<cf_url>/_transportes/consulta/cfc_emissao_documentos.cfc</cf_url>?method=get_ctrc_diaria_valor'
							,'num_conhecimento=' + DIARIA_NUM_CTRC.value +
							'&serie=' + CTRC_DIARIA_SERIE.value +
							'&cod_pessoa_filial=' + COD_PESSOA_FILIAL.value +
							'&cod_departamento=' + COD_DEPARTAMENTO.value +
							'&cod_setor=' + COD_SETOR.value +
							'&cod_centro_custo=' + COD_CENTRO_CUSTO.value
							,function (obj) {
								if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
									with(document.forms[0]) {
										if(obj.struct.conhecimento_id.length > 0 && obj.struct.cancelado[0] == '') {
											OPERACAO_ID.value    	 = obj.struct.operacao_id[0];
											OPERACAO_LOGISTICA.value = obj.struct.operacao[0];
											
											f_busca_organizacional(OPERACAO_ID.value);
											
											DIARIA_CTRC_ID.value     = obj.struct.conhecimento_id[0];
											PLACA_CONTROLE.value 	 = obj.struct.placa_tracao[0];
											PLACA_CONTROLE.onchange();
											PESO.value	      		 = obj.struct.peso[0];
											COD_UNIDADE_COMBO.value  = obj.struct.cod_unidade[0];
											COD_UNIDADE_COMBO.onchange();
											M3.value	      		 = obj.struct.m3[0];
											VOLUME.value      		 = obj.struct.volume[0];
											
											<cfif vars.REPOM eq 1>
												CARTAO_NUMERO.value 		  = obj.struct.cartao_numero_historico[0];
												CARTAO_NUMERO_HISTORICO.value = obj.struct.cartao_numero_historico[0];
											<cfelse>
												CARTAO_NUMERO_HISTORICO.value = '';
											</cfif>
											
											f_calculos_tabela_frete();
										}
										else {
											if(obj.struct.conhecimento_id.length > 0 && obj.struct.cancelado[0] != '') {
												alert('Conhecimento de diria cancelado.');
											}
											else {
												alert('Conhecimento de diria no encontrado.');
											}
											
											DIARIA_NUM_CTRC.value    = '';
											CTRC_DIARIA_SERIE.value  = '';
											OPERACAO_ID.value    	 = '';
											OPERACAO_LOGISTICA.value = '';
											
											f_busca_organizacional(OPERACAO_ID.value);
											
											PLACA_CONTROLE.value     = '';
											PLACA_CONTROLE.onchange();
											PESO.value	      		 = '';
											COD_UNIDADE_COMBO.value  = '';
											COD_UNIDADE_COMBO.onchange();
											M3.value	      		 = 0;
											VOLUME.value      		 = '';
											
											<cfif vars.REPOM eq 1>
												CARTAO_NUMERO.value = '';
											</cfif>
											
											CARTAO_NUMERO_HISTORICO.value = '';
											
											f_calculos_tabela_frete();
										}
									}
								}
							});
			}
		}
		
		function f_busca_crt_valor() {}
	</cfif>
	
	<cfif vars.REPOM eq 1>
		function f_buscar_cadastros_repom() {
			with(document.forms[0]) {
			<cfif vars.AVULSA eq 0 and vars.COMPLEMENTAR eq 0 and vars.DIARIA eq 0>
				if(NUM_ROMANEIO.value) {
					f_query_ajax('<cf_url>/aplicacoes/controle_documentos/contrato_transporte/emitir/consultas.cfm</cf_url>' +
								'?consulta=8' +
								'&num_romaneio=' + NUM_ROMANEIO.value +
								'&cartao_numero=' + CARTAO_NUMERO.value +
								'&rota_id=' + ROTA_ID.value +
								'&cod_contratado=' + PROPRIETARIO_COD_PESSOA.value +
								'&cod_motorista=' + MOTORISTA_COD_PESSOA.value +
								'&placa_cavalo=' + PLACA_CONTROLE.value +
								'&placa_carreta=' + PLACA_REFERENCIA.value
								,function(obj) {
									document.getElementById('td_validacao_repom').innerHTML = obj;
								});
				}
			<cfelse>
				if(CARTAO_NUMERO.value || ROTA_ID.value || PROPRIETARIO_COD_PESSOA.value || MOTORISTA_COD_PESSOA.value || PLACA_CONTROLE.value || PLACA_REFERENCIA.value) {
					f_query_ajax('<cf_url>/aplicacoes/controle_documentos/contrato_transporte/emitir/consultas.cfm</cf_url>' +
								'?consulta=8' +
								'&num_romaneio=' +
								'&cartao_numero=' + CARTAO_NUMERO.value +
								'&rota_id=' + ROTA_ID.value +
								'&cod_contratado=' + PROPRIETARIO_COD_PESSOA.value +
								'&cod_motorista=' + MOTORISTA_COD_PESSOA.value +
								'&placa_cavalo=' + PLACA_CONTROLE.value +
								'&placa_carreta=' + PLACA_REFERENCIA.value
								,function(obj) {
									document.getElementById('td_validacao_repom').innerHTML = obj;
								});
				}
			</cfif>
				else {
					document.getElementById('td_validacao_repom').innerHTML = '';
				}
			}
		}
		
		function f_verificar_cartao() {
			with(document.forms[0]) {
				if(confirm('Para verificar o carto clique em OK.')) {
					f_cria_carregando_ajax();
					
					OPERACAO.value = 3;
					target = 'consultas';
					action = 'confirma.cfm';
					method = 'post';
					submit();
				}
			}
		}
		
		function f_verificar_roteiro(p_alert) {
			with(document.forms[0]) {
				if(ROTA_ID.value && PLACA_CONTROLE.value && (p_alert == 0 || confirm('Para verificar o roteiro clique em OK.'))) {
					f_cria_carregando_ajax();
					
					v_calculos_pendente = 1;
					OPERACAO.value = 4;
					target = 'consultas';
					action = 'confirma.cfm';
					method = 'post';
					submit();
				}
				else {
					f_buscar_cadastros_repom();
				}
			}
		}
		
		function f_solicitar_roteiro() {
			with(document.forms[0]) {
				if(confirm('Para solicitar o roteiro clique em OK.')) {
					f_cria_carregando_ajax();
					
					OPERACAO.value = 5;
					target = 'consultas';
					action = 'confirma.cfm';
					method = 'post';
					submit();
				}
			}
		}
		
		function f_atualizar_cadastros() {
			with(document.forms[0]) {
				if(confirm('Para atualizar os dados clique em OK.')) {
					f_cria_carregando_ajax();
					
					OPERACAO.value = 6;
					target = 'consultas';
					action = 'confirma.cfm';
					method = 'post';
					submit();
				}
			}
		}
		
		function f_busca_rota() {
			with(document.forms[0]) {
				ROTA_DESCRICAO.value = '';
				
				if(!ROTA_ID.value) {
					f_verificar_roteiro(0);
					return;
				}
				
				ROTA_DESCRICAO.value = 'Buscando rota...';
				f_query_wddx('<cf_url>/_transportes/consulta/cfc_controle_trafego.cfc</cf_url>?method=get_rota'
						,'rota_id=' + ROTA_ID.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.rota_id.length > 0) {
									ROTA_DESCRICAO.value = obj.struct.descricao_rota[0];
									f_verificar_roteiro(0);
								}
								else {
									ROTA_DESCRICAO.value = 'Rota no encontrada.';
								}
							}
						});
			}
		}
		
		function f_muda_cartao() {
			f_buscar_cadastros_repom();
			f_validar_cartao_historico();
		}
		
		function f_validar_cartao_historico() {
			with(document.forms[0]) {
				if(CARTAO_NUMERO_HISTORICO.value && CARTAO_NUMERO.value != CARTAO_NUMERO_HISTORICO.value) {
					document.getElementById('tr_info_cartao_historico').style.display = '';
					document.getElementById('sp_info_cartao_historico').innerHTML = 'Nmero do ltimo carto Repom utilizado por este motorista: ' + CARTAO_NUMERO_HISTORICO.value + '.';
				}
				else {
					document.getElementById('tr_info_cartao_historico').style.display = 'none';
					document.getElementById('sp_info_cartao_historico').innerHTML = '';
				}
			}
		}
		
		function f_visualizar_cartao_historico() {
			with(document.forms[0]) {
				f_abrir_janela('<cf_url>/aplicacoes/transporte/repom/consulta_cartao/principal.cfm</cf_url>?CARTAO_NUMERO=' + CARTAO_NUMERO_HISTORICO.value, '', (screen.width * 0.7), (screen.height * 0.7), 'yes');
			}
		}
	</cfif>
</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />

<title>..: KM&amp;M Transporte e Log&iacute;stica :..</title>

<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/status.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body class="background" style="height:100%; overflow:auto">
<form id="form_transportes" name="form_transportes" method="post" action="" onSubmit="return f_confirmar()">
    <input name="OPERACAO" type="hidden" value="" sempre_ativo="1">
    <input name="CONSULTA" type="hidden" value="" sempre_ativo="1">
    <input name="MANIFESTO_ID" type="hidden" value="" sempre_ativo="1">
    <input name="VOLTAR_MENU" type="hidden" value="0" sempre_ativo="1">
    <input name="APENAS_COMPLEMENTOS" type="hidden" value="0" sempre_ativo="1">
    <input name="ATUALIZA_COMBO" id="ATUALIZA_COMBO" type="hidden" value="" sempre_ativo="1" />
    
    <input name="COD_PESSOA_FILIAL" id="COD_PESSOA_FILIAL" type="hidden" value="<cfoutput>#vars.COD_PESSOA_FILIAL#</cfoutput>" sempre_ativo="1" fixo="1">
    <input name="COD_CENTRO_CUSTO" id="COD_CENTRO_CUSTO" type="hidden" value="<cfoutput>#vars.COD_CENTRO_CUSTO#</cfoutput>" sempre_ativo="1" fixo="1">
    <input name="COD_DEPARTAMENTO" id="COD_DEPARTAMENTO" type="hidden" value="<cfoutput>#vars.COD_DEPARTAMENTO#</cfoutput>" sempre_ativo="1" fixo="1">
    <input name="COD_SETOR" id="COD_SETOR" type="hidden" value="<cfoutput>#vars.COD_SETOR#</cfoutput>" sempre_ativo="1" fixo="1">
    <input name="COD_MODELO" id="COD_MODELO" type="hidden" value="X2" sempre_ativo="1" fixo="1">
    
    <input name="CTF" id="CTF" type="hidden" value="<cfoutput>#vars.CTF#</cfoutput>" sempre_ativo="1" fixo="1">
    <input name="REPOM" id="REPOM" type="hidden" value="<cfoutput>#vars.REPOM#</cfoutput>" sempre_ativo="1" fixo="1">
    <input name="AVULSA" id="AVULSA" type="hidden" value="<cfoutput>#vars.AVULSA#</cfoutput>" sempre_ativo="1" fixo="1">
    <input name="COMPLEMENTAR" id="COMPLEMENTAR" type="hidden" value="<cfoutput>#vars.COMPLEMENTAR#</cfoutput>" sempre_ativo="1" fixo="1">
    <input name="DIARIA" id="DIARIA" type="hidden" value="<cfoutput>#vars.DIARIA#</cfoutput>" sempre_ativo="1" fixo="1">
    
    <input name="VALOR_MAXIMO" id="VALOR_MAXIMO" type="hidden" value="" sempre_ativo="1" />
    <input name="CARTAO_NUMERO_HISTORICO" id="CARTAO_NUMERO_HISTORICO" type="hidden" value="" sempre_ativo="1" />
    
	<table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0">  
        <tr>
            <td>
                <fieldset><legend>Dados do Contrato de Transporte</legend>
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                    <tr>
                        <td nowrap class="texto"><nobr>Tipo de Carga:</nobr></td>
                        <td colspan="3" class="texto"><select name="TIPO_CARGA" id="TIPO_CARGA" onChange="f_muda_tipo_carga()" fixo="1">
							<cfif vars.AVULSA eq 0>
                            	<option value="1" selected>Carga Normal</option>
                            <cfelse>
                            	<option value="4" selected>Avulso</option>
                            </cfif>
                            </select><cfif vars.CTF eq 1>&nbsp;<span class="obrigatorio">Aten&ccedil;&atilde;o! Frete ser&aacute; pago pelo sistema CTF Frete.</span></cfif></td>
                    </tr>
                    
                    <cfif vars.AVULSA eq 0 and vars.COMPLEMENTAR eq 0 and vars.DIARIA eq 0>
                    <tr id="tr_carga_normal">
                        <td nowrap class="texto"><nobr>N&ordm; Romaneio:</nobr></td>
                        <td colspan="3" nowrap class="texto"><input name="NUM_ROMANEIO" type="text" id="NUM_ROMANEIO" onKeyPress="return f_formata(this,event,'000000000000')" onChange="f_busca_romaneio()" display="NUMERO DO ROMANEIO" style="width: 81px;" /></td>
                    </tr>
                    <tr id="tr_conhecimento" style="display: none;">
                        <td nowrap class="texto"><nobr>Conhecimento:</nobr></td>
                        <td colspan="3" nowrap class="texto"><select name="CONHECIMENTO_ID_ROMANEIO" id="CONHECIMENTO_ID_ROMANEIO" onChange="f_muda_conhecimento_manifesto()" obrigatorio="0" display="CONHECIMENTO" ativo="1"> 
                        	<option value="" data_emissao="#LSDateFormat(Now())#">-- Selecione o Romaneio --</option> 
                        	</select></td>
                    </tr>
                    <tr id="tr_carga_fracionada" style="display: none;">
                        <td nowrap class="texto"><nobr>N&ordm; Manifesto:</nobr></td>
                        <td nowrap class="texto"><input name="NUM_MANIFESTO" type="text" id="NUM_MANIFESTO" onKeyPress="return f_formata(this,event,'000000000000')" onChange="f_busca_manifesto()" display="NUMERO DO MANIFESTO"></td>
                        <td nowrap class="texto"><nobr>Conhecimento:</nobr></td>
                        <td class="texto"><select name="CONHECIMENTO_ID" id="CONHECIMENTO_ID" onChange="this.form.DATA_EMISSAO.value = this.options[this.selectedIndex].data_emissao;f_muda_conhecimento_manifesto()" obrigatorio="0" display="CONHECIMENTO" ativo="1"> 
                        	<option value="" data_emissao="#LSDateFormat(Now())#">-- Selecione o Manifesto --</option>
                        	</select></td>
                    </tr>
                    </cfif>
                    
                    <cfif vars.COMPLEMENTAR eq 1>
                    <tr id="tr_complemento" >
                        <td class="texto">N&ordm; CTRC:</td>
                        <td class="texto"><input name="NUM_CTRC" type="text" id="NUM_CTRC" onChange="f_busca_ctrc()" onKeyPress="return f_formata(this,event,'000000000000')" obrigatorio="1" display="NUMERO DO CTRC">
                        	<input type="hidden" name="CTRC_ID" id="CTRC_ID"></td>
                        <td class="texto" style="display:none ">Conhecimento:</td>
                        <td class="texto" style="display:none "><select name="CONHECIMENTO_ID_ROMANEIO" id="CONHECIMENTO_ID_ROMANEIO" onChange="this.form.CONHECIMENTO_ID.value = this.value; <!---this.form.DATA_EMISSAO.value = this.options[this.selectedIndex].data_emissao; --->f_muda_conhecimento_manifesto()" obrigatorio="0" display="CONHECIMENTO" ativo="1"> 
                        	<option value="" data_emissao="#LSDateFormat(Now())#">-- Selecione o Romaneio --</option> 
                        	</select></td>
                    </tr>                   
                   	</cfif>
                    
                   	<cfif vars.DIARIA eq 1>
                    <tr>
                        <td nowrap class="texto">Tipo de Di&aacute;ria:</td>
                        <td colspan="3" nowrap class="texto"><select name="TIPO_DIARIA" id="TIPO_DIARIA" obrigatorio="1" display="TIPO DE DIRIA" onChange="f_muda_tipo_diaria()">
                            	<option value="">--</option>
                                <option value="1">CTRC/CTe</option>
                        		<!---<option value="2">CRT</option>--->
                            </select></td>
                    </tr>
                    <tr id="tr_diaria_ctrc" style="display: none;">
                        <td nowrap class="texto">N&ordm; CTRC/CTe:</td>
                        <td colspan="3" nowrap class="texto"><input type="text" name="DIARIA_NUM_CTRC" id="DIARIA_NUM_CTRC" maxlength="15" tipo="numerico" display="NMERO DO CTRC/CTE" onChange="f_busca_ctrc_valor()" onKeyPress="return f_formata(this, '000000000000000')" style="width: 119px;" />
                        	<select name="CTRC_DIARIA_SERIE" id="CTRC_DIARIA_SERIE" display="SRIE DO CTRC/CTE" onChange="f_busca_ctrc_valor()">
                            	<option value="">--</option>
								<cfoutput query="qrSerieCTRC">
                                    <option value="#qrSerieCTRC.SERIE#">#qrSerieCTRC.SERIE#</option>
                                </cfoutput>
                            </select>
                        	<input type="hidden" name="DIARIA_CTRC_ID" id="DIARIA_CTRC_ID" display="NMERO DO CTRC" /></td>
                    </tr>
                    <tr id="tr_diaria_crt" style="display: none;">
                        <td nowrap class="texto">N&ordm; CRT:</td>
                        <td colspan="3" nowrap class="texto"><input type="text" name="DIARIA_NUM_CRT" id="DIARIA_NUM_CRT" maxlength="15" tipo="numerico" display="NMERO DO CRT" onChange="f_busca_crt_valor()" onKeyPress="return f_formata(this, 'XX.000.000.000')" style="width: 119px;" />
                        	<input type="hidden" name="DIARIA_CRT_ID" id="DIARIA_CRT_ID" display="NMERO DO CRT" /></td>
                    </tr>                    
                   	</cfif>
                    
                    <cfif vars.CTF eq 0 and vars.REPOM eq 0>
                    <tr>
                        <td nowrap class="texto"><nobr>N&ordm; Formul&aacute;rio:</nobr></td>
                        <td colspan="3" nowrap class="texto"><nobr><input name="NUM_FORMULARIO" type="text" id="NUM_FORMULARIO" onKeyPress="return f_formata(this,event,'00000000000000')" obrigatorio="1" display="NUMERO DO FORMULARIO" style="width: 81px;" />
                            <select name="SERIE_FORMULARIO" id="SERIE_FORMULARIO" fixo="1">
								<cfoutput query="qrSerie">
                                	<option value="#qrSerie.SERIE#" formulario='#qrSerie.FORMULARIO#' selected>#qrSerie.SERIE#</option>
                                </cfoutput>
                            </select></nobr></td>
                    </tr>
                    <cfelseif vars.CTF eq 1>
						<input name="NUM_FORMULARIO" type="hidden" value="" sempre_ativo="1" fixo="1">
                      	<input name="SERIE_FORMULARIO" type="hidden" value="CTF" sempre_ativo="1" fixo="1">
                   	<cfelseif vars.REPOM eq 1>
                      	<input name="NUM_FORMULARIO" type="hidden" value="" sempre_ativo="1" fixo="1">
                      	<input name="SERIE_FORMULARIO" type="hidden" value="REPOM" sempre_ativo="1" fixo="1">
                   	</cfif>
                    <tr>
                     	<td id="td_divisao_crt" colspan="4" class="texto"></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto" style="width: 108px;"><nobr>Emiss&atilde;o:</nobr></td>
                        <td nowrap class="texto" style="width: 1%;"><nobr><input name="DATA_EMISSAO" type="text" id="DATA_EMISSAO" maxlength="16" onKeyPress="return f_formata(this,event,'00/00/0000 00:00')" value="<cfoutput>#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#</cfoutput>" readonly="readonly" fixo="1" style="width: 119px;" />
                            <button type="button" id="btn_data_emissao" class="botao-16x16" style="display: none"><img src="/_imagens/botoes/16x16/calendario.gif" alt="" width="16" height="16" align="absmiddle"></button>
                            <script type="text/javascript">
								Calendar.setup(
									{
										inputField  : "DATA_EMISSAO",       // ID of the input field
										ifFormat    : "%d/%m/%Y",    		// the date format
										button      : "btn_data_emissao",   // ID of the button
										range       : [2001,2050]
									}
								);
                            </script></nobr></td>
                        <td nowrap class="texto" style="width: 1%;"><cfif vars.AVULSA eq 1><nobr>Natureza:</nobr></cfif></td>
                        <td class="texto" style="width: 99%;"><cfif vars.AVULSA eq 1><input type="text" name="NUM_NATUREZA" id="NUM_NATUREZA" maxlength="6" obrigatorio="1" tipo="numerico" display="NMERO DA NATUREZA" onChange="f_busca_natureza()" onKeyPress="return f_formata(this,event,'000000')" style="width: 50px;" />
                        	<input type="text" name="NATUREZA" id="NATUREZA" readonly obrigatorio="1" display="NATUREZA" style="width: 234px;" />&nbsp;
                            <button type="button" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_natureza.cfm?num_natureza=NUM_NATUREZA&natureza=NATUREZA&funcao=f_calculos_tabela_frete()', 'LocalizarNatureza', 600, 480, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Natureza" title="Buscar Natureza" width="16" height="16" align="absmiddle" /></button></cfif></td>
                    </tr>
                    <tr>
                    	<td nowrap class="texto"><nobr>Opera&ccedil;&atilde;o:</nobr></td>
                        <td colspan="3" nowrap class="texto"><input type="text" name="OPERACAO_ID" id="OPERACAO_ID" maxlength="10" <cfif vars.AVULSA eq 0>readonly</cfif> obrigatorio="1" tipo="numerico" display="CDIGO DA OPERAO" onChange="f_busca_operacao()" onKeyPress="return f_formata(this,event,'0000000000')" style="width: 81px;" />
                        	<input type="text" name="OPERACAO_LOGISTICA" id="OPERACAO_LOGISTICA" readonly obrigatorio="1" display="OPERAO" style="width: 506px;" />
                        	<input type="hidden" name="VIAGEM_CARGA_ID" id="VIAGEM_CARGA_ID" onChange="f_busca_viagem_carga_dados()" >
                            <cfif vars.AVULSA eq 1><button type="button" class="botao-16x16" onClick="NewWindow('localizar_operacao.cfm', 'LocalizarOperacao', 600, 480, 'yes')" ><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Opera&ccedil;&atilde;o" title="Buscar Opera&ccedil;&atilde;o" width="16" height="16" align="absmiddle" /></button></cfif></td>
                    </tr>
					<tr>
                        <td nowrap="nowrap" class="texto">CC Gerencial:</td>
                        <td class="texto" colspan="3"><input name="COD_ORGANIZACIONAL" type="text" id="COD_ORGANIZACIONAL" display="CD. CENTRO DE CUSTO GERENCIAL" onChange="f_muda_organizacional()" onKeyPress="return f_formata(this,event,'AAAAAAAAAAA')" size="10" maxlength="11" <cfif v_gerencial_obrigatorio >obrigatorio="1"</cfif> />
                           <select name="ORGANIZACIONAL_ID" id="ORGANIZACIONAL_ID"  display="CENTRO DE CUSTO GERENCIAL" onChange="document.forms[0].COD_ORGANIZACIONAL.value=document.forms[0].ORGANIZACIONAL_ID.options[document.forms[0].ORGANIZACIONAL_ID.selectedIndex].codigo" <cfif v_gerencial_obrigatorio >obrigatorio="1"</cfif> >
                           </select></td>
                    </tr>
                </table>
                </fieldset>
            </td>
        </tr>
        <cfif vars.REPOM eq 1>
        <tr>
            <td>
                <fieldset><legend>Valida&ccedil;&atilde;o Repom</legend>
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                    <tr>
                        <td id="td_validacao_repom" colspan="2"></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto" style="width: 108px;"><nobr>Rota do Contrato:</nobr></td>
                        <td nowrap class="texto" style="width: 99%;"><input type="text" name="ROTA_ID" id="ROTA_ID" maxlength="10" obrigatorio="1" tipo="numerico" display="CDIGO DA ROTA" onChange="f_busca_rota()" onKeyPress="return f_formata(this, '0000000000')" style="width: 81px;" />
                        	<input type="text" name="ROTA_DESCRICAO" id="ROTA_DESCRICAO" readonly obrigatorio="1" display="DESCRICAO_ROTA" style="width: 506px;" />&nbsp;
                            <button type="button" class="botao-16x16" onClick="NewWindow('<cf_url>/_consultas/localizar_rota.cfm</cf_url>?campo=ROTA_ID,ROTA_DESCRICAO&field=ROTA_ID,DESCRICAO_ROTA&repom=1&funcao=f_verificar_roteiro(0)', 'LocalizarRota', 640, 480, 'yes');"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Rota" title="Buscar Rota" width="16" height="16" align="absmiddle" /></button></td>
                    </tr>
				</table>
                </fieldset>
			</td>
        </tr>
        </cfif>
        <tr>
            <td>
                <fieldset><legend>Servi&ccedil;o Contratado</legend>
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                	<cfif vars.REPOM eq 1>
                    <tr>
                        <td nowrap class="texto"><nobr>N&ordm; Cart&atilde;o Repom:</nobr></td>
                        <td colspan="3" class="texto"><input type="text" name="CARTAO_NUMERO" id="CARTAO_NUMERO" maxlength="20" obrigatorio="1" tipo="numerico" display="NMERO DO CARTO REPOM" onChange="f_muda_cartao()" onKeyPress="return f_formata(this, '00000000000000000000')" style="width: 150px;" />&nbsp;
                        	<span class="obrigatorio">* N&uacute;mero que consta no verso do cart&atilde;o Repom.</span></td>
                    </tr>
                    </cfif>
                    <tr>
                        <td nowrap class="texto" style="width: 108px;"><nobr>Placa Cavalo:</nobr></td>
                        <cfif vars.AVULSA eq 0 and vars.COMPLEMENTAR eq 0 and vars.DIARIA eq 0>
                        <td nowrap class="texto" style="width: 1%;"><select name="PLACA_CONTROLE" id="PLACA_CONTROLE" obrigatorio="1" display="PLACA CAVALO" onChange="f_busca_dado_veiculo()">
                            <option value="">-- Informe o Romaneio --</option>
                            </select></td>
                        <cfelse>
                        <td nowrap class="texto" style="width: 1%;"><input name="PLACA_CONTROLE" type="text" id="PLACA_CONTROLE" onChange="f_busca_dado_veiculo()" onKeyPress="return f_formata(this,event,'AAAAAAAAA')" readonly="true" obrigatorio="1" display="VEICULO CONTRATADO" style="width: 81px;" /></td>
                        </cfif>
                        <td nowrap class="texto" style="width: 1%;"><nobr>Placa Carreta:</nobr></td>
                        <td class="texto" style="width: 99%;"><input name="PLACA_REFERENCIA" type="text" id="PLACA_REFERENCIA" onKeyPress="return f_formata(this,event,'AAAAAAAAA')" onChange="f_busca_placa_referencia()" style="width: 81px;" /></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto"><nobr>Motorista:</nobr></td>
                        <td colspan="3" class="texto"><input name="MOTORISTA_CPF" type="text" id="MOTORISTA_CPF" readonly="true">
                            <input name="MOTORISTA" type="text" id="MOTORISTA" style="width: 350px" readonly="true">
                            <input name="MOTORISTA_COD_PESSOA" type="hidden" id="MOTORISTA_COD_PESSOA"></td>
                    </tr>
                    <tr id="tr_info_cartao_historico" style="display: none;">
                        <td nowrap class="texto"></td>
                        <td colspan="3" nowrap class="texto"><span id="sp_info_cartao_historico" class="obrigatorio"></span>&nbsp;
                        	<button type="button" class="botao-16x16" onClick="f_visualizar_cartao_historico()"><img src="/_imagens/botoes/16x16/repom.gif" alt="Visualizar Hist&oacute;rico do Cart&atilde;o" title="Visualizar Hist&oacute;rico do Cart&atilde;o" width="16" height="16" align="absmiddle" /></button></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto"><nobr>C.N.H.:</nobr></td>
                        <td nowrap class="texto"><input name="MOTORISTA_CNH" type="text" id="MOTORISTA_CNH" readonly="true" obrigatorio="0" display="CNH DO MOTORISTA"></td>
                        <td nowrap class="texto"><nobr>Validade:</nobr></td>
                        <td class="texto"><input name="MOTORISTA_CNH_VALIDADE" type="text" id="MOTORISTA_CNH_VALIDADE" readonly="true" style="width: 81px;" /></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto"><nobr>Propriet&aacute;rio:</nobr></td>
                        <td colspan="3" class="texto"><input name="PROPRIETARIO_CNPJ_CPF" type="text" id="PROPRIETARIO_CNPJ_CPF" readonly="true">
                            <input name="PROPRIETARIO" type="text" id="PROPRIETARIO" style="width: 350px" readonly="true">
                            <input name="PROPRIETARIO_COD_PESSOA" type="hidden" id="PROPRIETARIO_COD_PESSOA"></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto"><nobr>PIS/NIT:</nobr></td>
                        <td colspan="3" class="texto"><input name="PROPRIETARIO_NIT" type="text" id="PROPRIETARIO_NIT" readonly="true"></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto"><nobr>Endere&ccedil;o:</nobr></td>
                        <td colspan="3" class="texto"><input name="PROPRIETARIO_ENDERECO" type="text" id="PROPRIETARIO_ENDERECO" style="width: 473px" readonly="true"></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto"><nobr>Munic&iacute;pio:</nobr></td>
                        <td colspan="3" class="texto"><input name="PROPRIETARIO_MUNICIPIO" type="text" id="PROPRIETARIO_MUNICIPIO" style="width: 439px" readonly="true">
                            <input name="PROPRIETARIO_UF" type="text" id="PROPRIETARIO_UF" style="width: 30px" readonly="true">
                            <input name="PROPRIETARIO_MUNICIPIO_ID" type="hidden" id="PROPRIETARIO_MUNICIPIO_ID"></td>
                    </tr>
                </table>
                </fieldset>
            </td>
        </tr>
        <cfif vars.AVULSA eq 1>
        <tr>
            <td>
                <fieldset><legend>Remetente</legend>
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                    <tr>
                        <td nowrap class="texto" style="width: 108px;"><nobr>Remetente:</nobr></td>
                        <td class="texto" style="width: 99%;"><input name="REM_CNPJ" type="text" id="REM_CNPJ" onChange="f_busca_pessoa('COD_REMETENTE', 'REM')" maxlength="18" display="REMETENTE" <cfif vars.AVULSA eq 1>obrigatorio="1"</cfif> />
                            <input name="REM_NOME" type="text" disabled="disabled" id="REM_NOME" style="width: 350px;" maxlength="60" readonly="readonly" />
                            <input type="hidden" name="COD_REMETENTE" id="COD_REMETENTE" display="REMETENTE" <cfif vars.AVULSA eq 1>obrigatorio="1"</cfif> />
                            <button id="btn_remetente" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?campo=REM_CNPJ,REM_NOME,COD_REMETENTE,REM_MUNICIPIO_ID,REM_ENDERECO&field=CNPJ_CPF,CLIENTE,COD_PESSOA,MUNICIPIO_ID,ENDERECO_COMPLETO&funcao=f_calculos_tabela_frete()','LocalizarRemetente','800','600')" class="botao-16x16"><img src="/_imagens/botoes/16x16/localizar.gif" alt="Busca Remetente" width="16" height="16" align="absmiddle" /></button>
                            <input type="hidden" name="REM_MUNICIPIO_ID" id="REM_MUNICIPIO_ID" /></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto"><nobr>Endere&ccedil;o:</nobr></td>
                        <td class="texto"><input name="REM_ENDERECO" type="text" disabled="disabled" id="REM_ENDERECO" style="width: 473px;" maxlength="100" readonly="readonly" /></td>
                    </tr>
                </table>
                </fieldset>
            </td>
        </tr>
        <tr>
            <td>
                <fieldset><legend>Destinat&aacute;rio</legend>
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                    <tr>
                        <td nowrap class="texto" style="width: 108px;"><nobr>Destinat&aacute;rio:</nobr></td>
                        <td class="texto" style="width: 99%;"><input name="DEST_CNPJ" type="text" id="DEST_CNPJ" onChange="f_busca_pessoa('COD_DESTINATARIO', 'DEST')" maxlength="18" display="DESTINAT&Aacute;RIO" <cfif vars.AVULSA eq 1>obrigatorio="1"</cfif> />
                            <input name="DEST_NOME" type="text" disabled="disabled" id="DEST_NOME" style="width: 350px;" maxlength="60" readonly="readonly" />
                            <input type="hidden" name="COD_DESTINATARIO" id="COD_DESTINATARIO" display="DESTINAT&Aacute;RIO" <cfif vars.AVULSA eq 1>obrigatorio="1"</cfif> />
                            <button id="btn_destinatario" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?campo=DEST_CNPJ,DEST_NOME,COD_DESTINATARIO,DEST_MUNICIPIO_ID,DEST_ENDERECO&field=CNPJ_CPF,CLIENTE,COD_PESSOA,MUNICIPIO_ID,ENDERECO_COMPLETO&funcao=f_calculos_tabela_frete()','LocalizarDestinatario','800','600')" class="botao-16x16"><img src="/_imagens/botoes/16x16/localizar.gif" alt="Busca Destinat&aacute;rio" width="16" height="16" align="absmiddle" /></button>
                            <input type="hidden" name="DEST_MUNICIPIO_ID" id="DEST_MUNICIPIO_ID" /></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto"><nobr>Endere&ccedil;o:</nobr></td>
                        <td class="texto"><input name="DEST_ENDERECO" type="text" disabled="disabled" id="DEST_ENDERECO" style="width: 473px;" maxlength="100" readonly="readonly" /></td>
                    </tr>
                </table>
                </fieldset>
            </td>
        </tr>
        </cfif>
        <tr>
            <td>
                <fieldset><legend>Valores</legend>
                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                    <tr>
                        <td style="width: 1%;">
                            <table width="100%" border="0" cellspacing="0" cellpadding="3">
                                <tr>
                                    <td nowrap class="texto" style="width: 108px;"><nobr>Peso:</nobr></td>
                                    <td nowrap class="texto" style="width: 1%;"><nobr><input name="PESO" type="text" id="PESO" onChange="f_calcula_peso_ton()" style="width: 81px;" onKeyPress="return f_formata_numero_decimal(this,event)" >
                                        <select name="COD_UNIDADE_COMBO" id="COD_UNIDADE_COMBO" onChange="this.value = this.form.COD_UNIDADE.value = this.value; f_calcula_peso_ton();" >
                                            <option value="">-- Selecione --</option>
                                            <cfoutput query="qrUnidade">
                                                <option value="#qrUnidade.COD_UNIDADE#">#qrUnidade.UNIDADE#</option>
                                            </cfoutput>
                                        </select>
                                        <input type="hidden" name="PESO_TON">
                                        <input type="hidden" name="COD_UNIDADE"></nobr></td>
                                    <td nowrap class="texto" style="width: 1%;"><nobr>M<sup>3</sup>:</nobr></td>
                                    <td class="texto" style="width: 99%;"><input name="M3" type="text" id="M3" onChange="f_calculos()" onKeyPress="return f_formata_numero_decimal(this,event)" value="0" obrigatorio="1" display="M3" fixo="1" style="width: 81px;" /></td>
                                </tr>
                                <tr>
                                    <td nowrap class="texto"><nobr>Volume:</nobr></td>
                                    <td nowrap class="texto"><input name="VOLUME" type="text" id="VOLUME" obrigatorio="1" display="VOLUME" onKeyPress="return f_formata_numero_decimal(this,event)" onChange="f_calculos()" style="width: 81px;" /></td>
                                    <td nowrap class="texto"><nobr>Frete em:</nobr></td>
                                    <td class="texto"><select name="FRETE_EM" id="FRETE_EM" onChange="f_calculos()" obrigatorio="1" display="FRETE EM" style="width: 81px;" />
                                            <cfoutput query="qrFreteEm">
                                            	<cfif qrFreteEm.ID eq 'LOTACAO'>
                                                	<option value="#qrFreteEm.ID#">#qrFreteEm.ID#</option>
                                                </cfif>
                                            </cfoutput>
                                        </select></td>
                                </tr>
                                <tr>
                                    <td nowrap class="texto"><nobr>Valor Unit&aacute;rio:</nobr></td>
                                    <td nowrap class="texto"><input name="VALOR_UNITARIO" type="text" id="VALOR_UNITARIO" onKeyPress="return f_formata_numero_decimal(this,event)" onChange="f_calculos()" obrigatorio="1" display="VALOR UNITARIO" style="width: 81px;" /></td>
                                    <td nowrap class="texto"><nobr>Valor do Servi&ccedil;o:</nobr></td>
                                    <td class="texto"><input name="VALOR_FRETE_LIQUIDO" readonly="true" type="text" id="VALOR_FRETE_LIQUIDO" onKeyPress="return f_formata_numero_decimal(this,event)" style="width: 81px;" /></td>
                                </tr>
                                <tr>
                                    <td nowrap class="texto"><nobr>Acr&eacute;scimos:</nobr></td>
                                    <td nowrap class="texto"><input name="ACRESCIMOS" type="text" id="ACRESCIMOS" readonly="true" onKeyPress="return f_formata_numero_decimal(this,event)" style="width: 81px;" /></td>
                                    <td nowrap class="texto"><nobr>Descontos:</nobr></td>
                                    <td class="texto"><input name="DESCONTOS" type="text" id="DESCONTOS" readonly="true" onKeyPress="return f_formata_numero_decimal(this,event)" style="width: 81px;" /></td>
                                </tr>
                                <tr>
                                    <td nowrap class="texto"><nobr>Total do Servi&ccedil;o:</nobr></td>
                                    <td nowrap class="texto"><input name="VALOR_FRETE_BRUTO" type="text" id="VALOR_FRETE_BRUTO" readonly="true" onKeyPress="return f_formata_numero_decimal(this,event)" style="width: 81px;" /></td>
                                    <td nowrap class="texto"><nobr>L&iacute;quido do Servi&ccedil;o:</nobr></td>
                                    <td class="texto"><input name="VALOR_FRETE" type="text" id="VALOR_FRETE" readonly="true" onKeyPress="return f_formata_numero_decimal(this,event)" style="width: 81px;" /></td>
                                </tr>
                                <tr>
                                    <td nowrap class="texto"><nobr>L&iacute;quido a Pagar:</nobr></td>
                                    <td nowrap class="texto"><input name="FRETE_COMBINADO" type="text" id="FRETE_COMBINADO" readonly="true" onKeyPress="return f_formata_numero_decimal(this,event)" style="width: 81px;" /></td>
                                    <td nowrap class="texto"><nobr>Toler&acirc;ncia de Faltas:</nobr></td>
                                    <td nowrap class="texto"><nobr><input name="TOLERANCIA_FALTA" type="text" id="TOLERANCIA_FALTA" onKeyPress="return f_formata_numero_decimal(this,event)" obrigatorio="1" display="TOLERANCIA DE FALTAS" style="width: 81px;" />&nbsp;%</nobr></td>
                                </tr>
                                <tr style="display: none;">
                                    <td nowrap class="texto"><nobr>Adiantamento:</nobr></td>
                                    <td nowrap class="texto"><input type="text" name="VALOR_ADIANTAMENTO" id="VALOR_ADIANTAMENTO" readonly style="width: 81px;" /></td>
                                    <td colspan="2" class="texto"><nobr><input type="checkbox" name="PARCELADO" id="PARCELADO" class="check" disabled ativo="0" onClick="this.form.TOTAL_PARCELA.disabled = !this.checked" />
                                        <label for="PARCELADO">Parcelamento</label>
                                        <select name="TOTAL_PARCELA" id="TOTAL_PARCELA" disabled ativo="0" >
                                            <option value="2">2x</option>
                                            <option value="3">3x</option>
                                            <option value="4">4x</option>
                                            <option value="5">5x</option>
                                        </select></nobr></td>
                                </tr>
                                <tr>
                                    <td nowrap class="texto"><nobr>Valor INSS:</nobr></td>
                                    <td nowrap class="texto"><input type="text" name="VALOR_INSS" id="VALOR_INSS" readonly="yes" style="width: 81px;" /></td>
                                    <td nowrap class="texto"><nobr>Base Calc. INSS:</nobr></td>
                                    <td class="texto"><input type="text" name="BASE_CALC_INSS" id="BASE_CALC_INSS" readonly="yes" style="width: 81px;" /></td>
                                </tr>
                                <tr>
                                    <td nowrap class="texto"><nobr>Valor SEST:</nobr></td>
                                    <td nowrap class="texto"><input type="text" name="VALOR_SEST" id="VALOR_SEST" readonly="yes" style="width: 81px;" /></td>
                                    <td nowrap class="texto"><nobr>Base Calc. SEST/SENAT:</nobr></td>
                                    <td class="texto"><input type="text" name="BASE_CALC_SEST_SENAT" id="BASE_CALC_SEST_SENAT" readonly="yes" style="width: 81px;" /></td>
                                </tr>
                                <tr>
                                    <td nowrap class="texto"><nobr>Valor SENAT:</nobr></td>
                                    <td colspan="3" class="texto"><input type="text" name="VALOR_SENAT" id="VALOR_SENAT" readonly="yes" style="width: 81px;" /></td>
                                </tr>
                                <tr>
                                    <td nowrap class="texto"><nobr>Valor IRRF:</nobr></td>
                                    <td nowrap class="texto"><input type="text" name="VALOR_IRRF" id="VALOR_IRRF" readonly="yes" style="width: 81px;" /></td>
                                    <td nowrap class="texto"><nobr>Base Calc. IRRF:</nobr></td>
                                    <td nowrap class="texto"><nobr><input type="text" name="BASE_CALC_IRRF" id="BASE_CALC_IRRF" readonly="yes" style="width: 81px;" />
                                    	<button type="button" class="botao-16x16" onClick="f_calculos()"><img src="/_imagens/botoes/16x16/calculadora.gif" alt="" width="16" height="16" align="absmiddle"></button></nobr></td>
                                </tr>
                                <tr <cfif vars.AVULSA eq 1>style="display: none;"</cfif>>
                                    <td nowrap class="texto"><nobr>Total da Receita:</nobr></td>
                                    <td colspan="3" class="texto"><input type="text" name="TOTAL_RECEITA" id="TOTAL_RECEITA" readonly display="TOTAL DA RECEITA" style="width: 81px;" /></td>
                               	</tr>
                                <tr <cfif vars.AVULSA eq 1>style="display: none;"</cfif>>
                                    <td nowrap class="texto"><nobr>Valor Emitido:</nobr></td>
                                    <td nowrap class="texto"><input type="text" name="VALOR_CF_ACUMULADO" id="VALOR_CF_ACUMULADO" readonly display="VALOR EMITIDO" style="width: 81px;" /></td>
                                    <td id="td_label_receita" nowrap class="texto"></td>
                                    <td id="td_valor_receita" nowrap class="obrigatorio"></td>
                               	</tr>
                                <tr id="tr_liberacao" <cfif vars.AVULSA neq 1>style="display: none;"</cfif>>
                                    <td nowrap class="texto">Usu&aacute;rio Libera&ccedil;&atilde;o:</td>
                                    <td nowrap class="texto"><select name="USUARIO_LIBERACAO" id="USUARIO_LIBERACAO" display="USURIO DE LIBERAO">
                            				<option value="">-- Selecione --</option>
											<cfoutput query="qrUsuario">
                                                <option value="#qrUsuario.USUARIO#">#qrUsuario.NOME#</option>
                                            </cfoutput>
                            			</select></td>
                                    <td nowrap class="texto">Senha autoriza&ccedil;&atilde;o:</td>
                                    <td class="texto"><input type="text" name="SENHA_LIBERACAO" id="SENHA_LIBERACAO" maxlength="15" display="SENHA DE LIBERAO" style="width: 81px;" /></td>
								</tr>
                                <cfif vars.REPOM eq 1>
                                <tr>
                                    <td nowrap class="texto"><nobr>Valor Ped&aacute;gio:</nobr></td>
                                    <td colspan="3" class="texto"><input type="text" name="VALOR_PEDAGIO_ROTA" id="VALOR_PEDAGIO_ROTA" readonly="yes" style="width: 81px;" />&nbsp;
                                    	<span class="obrigatorio">* Valor de Ped&aacute;gio que ser carregado no cart&atilde;o Repom.</span></td>
                                </tr>
                                </cfif>
                            </table>
						</td>
                        <td valign="top">
                        	<table width="100%" border="0" cellspacing="0" cellpadding="0">
                            	<tr id="tr_negociacao_checklist">
                                    <td class="texto_negrito" style="padding: 5px;">Para buscar qual forma ir&aacute; utilizar para executar os c&aacute;lculos preencha os dados:
                                    	<cfif vars.AVULSA eq 0 and vars.COMPLEMENTAR eq 0 and vars.DIARIA eq 0>
                                        	<ul style="margin-top: 5px; margin-left: 16px;">
                                                <li id="li_num_romaneio" class="obrigatorio">N&ordm; Romaneio</li>
                                            </ul>
                                        <cfelseif vars.AVULSA eq 1>
											<ul style="margin-top: 5px; margin-left: 16px;">
                                            	<li id="li_natureza" class="obrigatorio">Natureza</li>
                                                <li id="li_operacao" class="obrigatorio">Opera&ccedil;&atilde;o</li>
                                                <li id="li_placa_cavalo" class="obrigatorio">Placa Cavalo</li>
                                                <li id="li_remetente" class="obrigatorio">Remetente</li>
                                                <li id="li_destinatario" class="obrigatorio">Destinat&aacute;rio</li>
                                            </ul>
                                        <cfelseif vars.COMPLEMENTAR eq 1>
                                        	<ul style="margin-top: 5px; margin-left: 16px;">
                                                <li id="li_complemento" class="obrigatorio">N&ordm; CTRC/CTe</li>
                                            </ul>
                                        <cfelseif vars.DIARIA eq 1>
                                        	<ul style="margin-top: 5px; margin-left: 16px;">
                                                <li id="li_diaria" class="obrigatorio">N&ordm; CTRC/CTe ou N&ordm; CRT</li>
                                            </ul>
										</cfif>
									</td>
                                </tr>
                                <tr id="tr_negociacao_carregando" style="display: none;">
                                    <td style="padding: 5px;"><img src="/_imagens/uteis/carregando.gif" alt="" title="" /></td>
                                </tr>
                                <tr id="tr_negociacao_info" style="display: none;">
                                    <td class="obrigatorio" style="padding: 5px;">Por favor, aguarde. O sistema est&aacute; buscando qual forma ir&aacute; utilizar para executar os c&aacute;lculos.</td>
                                </tr>
                                <tr id="tr_negociacao_tabela_frete" style="display: none;">
                                    <td id="td_negociacao_tabela_frete" style="padding: 5px;"></td>
                                </tr>
							</table>
                        </td>
					</tr>
				</table>
                </fieldset>
            </td>
        </tr>
        <tr>
            <td>
                <fieldset><legend>Acr&eacute;scimos/Descontos</legend>
                <input type="hidden" name="ACR_COMPOE_FRETE">
                <input type="hidden" name="ACR_DEB_CRED_MOTORISTA">
                <input type="hidden" name="ACR_ACRESCIMO">
                <input type="hidden" name="ACR_DESCONTO">
                <input type="hidden" name="ACR_ACRESCIMO_REAL">
                <input type="hidden" name="ACR_DESCONTO_REAL">
                <input type="hidden" name="ACR_DESCRICAO">
                <input type="hidden" name="ACR_DESCONTO_COD">
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                    <tr>
                        <td nowrap class="texto" style="width: 100px;"><nobr>Descri&ccedil;&atilde;o:</nobr></td>
                        <td class="texto" style="width: 99%;"><nobr><select name="ACR_ITEM_ID" id="ACR_ITEM_ID" obrigatorio="1" display="DESCRICAO" secao="ACRESCIMOS"
                                onChange="this.form.ACR_VALOR.value = 0.00;
                                          if(this.value != '') {
                                              with(this.form) {
                                                ACR_TIPO.value = this.options[this.selectedIndex].tipo;
                                                ACR_COMPOE_FRETE.value = this.options[this.selectedIndex].compoe_frete;
                                                ACR_DEB_CRED_MOTORISTA.value = this.options[this.selectedIndex].deb_cred_motorista;
                                                ACR_DESCONTO_COD.value = this.options[this.selectedIndex].desconto;
                                              }
                                          } else {
                                                ACR_TIPO.value = '';
                                                ACR_COMPOE_FRETE.value = '';
                                                ACR_DEB_CRED_MOTORISTA.value = '';
                                                ACR_DESCONTO_COD.value = '';
                                          }
                                          ">
                                <option value="">-- Selecione --</option>
                                <cfoutput query="qrItensCartaFrete">
                                   <option 	value="#qrItensCartaFrete.ITEM_ID#" 
                                            tipo="#qrItensCartaFrete.TIPO#" 
                                            desconto="#qrItensCartaFrete.DESCONTO#" 
                                            compoe_frete="#qrItensCartaFrete.COMPOE_FRETE#" 
                                            deb_cred_motorista="#qrItensCartaFrete.DEB_CRED_MOTORISTA#">#qrItensCartaFrete.DESCRICAO#</option>
                                </cfoutput>				   
                            </select>
                            <input name="ACR_TIPO" type="text" id="ACR_TIPO" readonly="true">
                            <span id="sp_valor_item">Valor:
                            <input name="ACR_VALOR" type="text" id="ACR_VALOR" onKeyPress="return f_formata_numero_decimal(this,event)" obrigatorio="1" display="VALOR" secao="ACRESCIMOS"></span></nobr></td>
                        </tr>
                        <tbody id="tb_posto" style="display: none;">
                        <tr>
                            <td nowrap class="texto"><nobr>Posto:</nobr></td>
                            <td class="texto"><input name="POSTO_CNPJ_CPF" type="text" id="POSTO_CNPJ_CPF" onChange="f_busca_pessoa_POSTO()">
                                <input name="POSTO" type="text" id="POSTO" style="width: 350px" readonly="true">
                                <input name="POSTO_COD_PESSOA" type="hidden" id="POSTO_COD_PESSOA" obrigatorio="0" display="POSTO" secao="ACRESCIMOS">
                                <button type="button" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?modalidade_id=12&campo=POSTO_CNPJ_CPF&funcao=f_busca_pessoa_POSTO()','LocalizarPosto',800,600,'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle"></button></td>
                        </tr>
                        <tr>
                            <td nowrap class="texto"><nobr>Litros:</nobr></td>
                            <td class="texto"><input name="POSTO_QUANTIDADE" type="text" id="POSTO_QUANTIDADE" style="width: 70px" obrigatorio="0" display="QUANTIDADE" secao="ACRESCIMOS" onChange="f_calculo_abast()" onKeyPress="return f_formata_numero_decimal(this,event)"> 
                            	Valor Unit&aacute;rio:
                                <input name="POSTO_VALOR_UNITARIO" type="text" id="POSTO_VALOR_UNITARIO" style="width: 70px" obrigatorio="0" display="VALOR UNITARIO" secao="ACRESCIMOS" onChange="f_calculo_abast()" onKeyPress="return f_formata_numero_decimal(this,event)"></td>
                        </tr>
                        <tr>
                            <td nowrap class="texto"><nobr>Valor Total:</nobr></td>
                            <td class="texto"><input name="POSTO_VALOR_TOTAL" type="text" readonly="true" id="POSTO_VALOR_TOTAL" style="width: 70px"></td>
                        </tr>
                        </tbody>
                        <tr>
                            <td colspan="2" class="texto">
								<cfset lista_id 				= 'ACRESCIMOS'>
                                <cfset lista_campos 			= 'ACR_ITEM_ID,ACR_COMPOE_FRETE,ACR_DEB_CRED_MOTORISTA,ACR_ACRESCIMO,ACR_DESCONTO,ACR_TIPO,ACR_ACRESCIMO_REAL,ACR_DESCONTO_REAL,ACR_VALOR,ACR_DESCRICAO,POSTO_COD_PESSOA,POSTO_CNPJ_CPF,POSTO,POSTO_QUANTIDADE,POSTO_VALOR_UNITARIO,POSTO_VALOR_TOTAL,ACR_DESCONTO_COD'>
                                <cfset lista_titulos 			= 'Descri&ccedil;&atilde;o,Acr&eacute;scimo,Desconto'>
                                <cfset lista_titulos_campos 	= "'+ACR_ITEM_ID.options[ACR_ITEM_ID.selectedIndex].text+',ACR_ACRESCIMO,ACR_DESCONTO">
                                <cfset lista_titulos_tamanho 	= '200,50,50'>
                                <cfset lista_campo_id 			= 'ACR_ITEM_ID'>
                                <cfset lista_default 			= 0>
                                <cfset lista_campos_unique		= 'ACR_ITEM_ID'>
                                <cfset lista_width	 			= '700'>
                                <cfset lista_heigth	 			= '150'>
                                <cfinclude template	="/_include/lista.cfm">
							</td>
                            <script type="text/javascript">
                                    //  necessrio setar este flag para buscar os dados do banco de dados
                                    // Motivo: No  possvel inserir diretamente os dados de impostos
                                    v_insercao_interna = false;
                                    function f_before_salvar_ACRESCIMOS() {
                                        with(document.forms[0]) {
                                            if(!v_insercao_interna && Number(ACR_VALOR.value) < 0) {
                                                alert('O valor do item deve ser maior que zero!');
                                                return false;
                                            }
                                            //Incluir Teste para impedir a insero de dados de SEST/SENAT, INSS e IRRF
                                            if (!v_insercao_interna && 
                                                (ACR_ITEM_ID.value == 20 /* IRRF */ || 
                                                 ACR_ITEM_ID.value == 21 /* INSS */ || 
                                                 ACR_ITEM_ID.value == 23 /* SEST */ ||
                                                 ACR_ITEM_ID.value == 24 /* SENAT */)) {
                                                alert('Os valores de IRRF, INSS, SEST e SENAT so calculados automaticamente pelo sistema ao confirmar o contrato de transporte.');
                                                return false;
                                            }
                                            ACR_VALOR.value = toCurrency(ACR_VALOR.value);
                                            ACR_DESCRICAO.value = ACR_ITEM_ID.options[ACR_ITEM_ID.selectedIndex].text;
                                            if(ACR_DEB_CRED_MOTORISTA.value == 1) {
                                                ACR_ACRESCIMO.value = '0.00';
                                                ACR_DESCONTO.value = toCurrency(ACR_VALOR.value);
                                                ACR_ACRESCIMO_REAL.value = '0.00';
                                                ACR_DESCONTO_REAL.value = (ACR_COMPOE_FRETE.value == 1)?toCurrency(ACR_VALOR.value):'0.00';
                                            } else {
                                                ACR_ACRESCIMO.value = toCurrency(ACR_VALOR.value);
                                                ACR_DESCONTO.value = '0.00';
                                                ACR_ACRESCIMO_REAL.value = (ACR_COMPOE_FRETE.value == 1)?toCurrency(ACR_VALOR.value):'0.00';
                                                ACR_DESCONTO_REAL.value = '0.00';
                                            }
                                            return true;
                                        }
                                    }
                                    
                                    function f_on_salva_lista_ACRESCIMOS() {
                                        with(document.forms[0]) {
                                            v_lista = f_listagem_ACRESCIMOS();
                                            ACRESCIMOS.value = toCurrency(f_total_campo_ACRESCIMOS('ACR_ACRESCIMO_REAL'));
                                            DESCONTOS.value = toCurrency(f_total_campo_ACRESCIMOS('ACR_DESCONTO_REAL'));
                                            f_calculos();
                                            f_muda_produto();
                                            v_soma = 0;							
                                            for(var i=0;i<v_lista.length;i++) {
                                                if(v_lista[i].ACR_ITEM_ID == 7) {
                                                    v_soma += Number(v_lista[i].ACR_DESCONTO_REAL);
                                                }
                                            }							
                                            VALOR_ADIANTAMENTO.value = toCurrency(v_soma);

                                            PARCELADO.disabled = (v_soma <= 0);
                                            if(v_soma <= 0)
                                                PARCELADO.checked = false;
                                            TOTAL_PARCELA.disabled = !PARCELADO.checked || PARCELADO.disabled;
                                        }
                                    }
                                    
                                    function f_on_seleciona_ACRESCIMOS() {
                                        f_muda_produto();
                                    }
                                    
                                    function f_on_incluir_ACRESCIMOS() {
                                        f_muda_produto();
                                    }
                                </script>
					</tr>
                </table>
                </fieldset>
            </td>
        </tr>
        <tr>
            <td>
                <fieldset><legend>Observa&ccedil;&otilde;es</legend>
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                    <tr>
                        <td><textarea name="OBSERVACAO" id="OBSERVACAO" display="OBSERVAO" style="width: 100%; height: 60px;"></textarea></td>
                    </tr>
                </table>
                </fieldset>
            </td>
        </tr>
	</table>
</form>
</body>
<script type="text/javascript">
	if(<cfoutput>#vars.num_romaneio#</cfoutput> != 0) {
 		f_prenche_romaneio();
	}
	
	<cfif qrSerie.recordCount gt 1>
		f_muda_serie();
	</cfif>
</script>
</html>
<iframe name="consultas" frameborder="0" width="100%" height="500" src="" style="display: none;"></iframe>