<html>
<cfinclude template="/_scripts/scripts.cfm" />
<cfinclude template="/_include/carregando.cfm" />

<cfscript>
	v_mes = lsDateFormat(now(),'mm');
	v_ano = lsDateFormat(now(),'yyyy');	

	if(v_mes == 0){
		v_mes = 12;
		v_ano = v_ano - 1;
	}
	
	v_data_inicio = '01/'&v_mes&'/'&v_ano;
</cfscript>

<cfparam name="vars.DATA_INICIO" default="#lsDateFormat(v_data_inicio)#" />
<cfparam name="vars.DATA_TERMINO" default="#lsDateFormat(now())#" />

<cfscript>
	conn = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
	qrSerie = conn.get_serie(cod_pessoa_filial = session.cod_pessoa, 
							         cod_setor = session.cod_setor,
							  cod_departamento = session.cod_departamento, 
							  cod_centro_custo = session.cod_centro_custo,
									cod_modelo = "08,57");
									
	conn = CreateObject("component", "_transportes.consulta.cfc_gestao_avaria");
	qrStatusPendencias = conn.get_status_pendencias();
		
	qrPendenciaOperacional = conn.get_pendencia_operacional(argumentCollection = vars);
	
	conn = CreateComponent("_transportes.consulta.cfc_global");
	qrSituacao = conn.get_cg_ref_codes(rv_domain = 'DOCUMENTO.SITUACAO', owner = 'QUALIDADE');
	
	connF = CreateComponent("_transportes.consulta.cfc_funcionario");
	qrOrganograma = connF.get_organograma();

</cfscript>
<script type="text/javascript">
	// Configura botoes //
	parent.f_set_texto('titulo_aplicacao', 'Gesto de Avarias');
	parent.f_set_texto('titulo_pagina', 'Relatrio de Pendncias Operacionais');
	
	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); }
	
	parent.f_hidden('btn_incluir');
	parent.f_hidden('btn_editar');
	parent.f_hidden('btn_excluir');
	parent.f_hidden('btn_cancelar');
	
	f_habilitar_botao('confirmar', 'f_confirmar()');
	
	// -------------------- //

	
	function f_confirmar() {
		with(document.forms[0]) {	
							
			target = '_self';
			action = 'lista.cfm';	
				
			if(f_verifica_form(document.forms[0])) {
				if ((DATA_TERMINO.value.getDateTime() != null && DATA_INICIO.value.getDateTime() != null) &&
				    (Number(DATA_TERMINO.value.getDateTime()) < Number(DATA_INICIO.value.getDateTime()))) {
					alert('A data de trmino no pode ser maior que a data inicial.');
					DATA_F.select();
					return false;
				}
				
				submit();
			}
		}
		return false;
	}
	parent.f_confirmar = f_confirmar;

	function f_busca_pessoa_DESTINATARIO() {
		with(document.forms[0]) {
			
			COD_DESTINATARIO.value       	    = '';
			DESTINATARIO.value = '';
			
			if(!DESTINATARIO_CNPJ_CPF.value) {
				return;
			}
			
			DESTINATARIO.value = 'Buscando pessoa...';
			
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=getPessoa'
						,'cnpj_cpf='+DESTINATARIO_CNPJ_CPF.value +
						 '&num_modalidade=13,5'
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.cod_pessoa.length > 0) {
									COD_DESTINATARIO.value = obj.struct.cod_pessoa[0];
									DESTINATARIO.value = obj.struct.razao_social[0];
								}
								else {
									DESTINATARIO.value = 'Pessoa no encontrada.';
								}
							}
			});
		}
	}
	
	function f_busca_pessoa_REMETENTE() {
		with(document.forms[0]) {
			
			COD_REMETENTE.value       	     = '';
			REMETENTE.value = '';
			
			if(!REMETENTE_CNPJ_CPF.value) {
				return;
			}
			
			REMETENTE.value = 'Buscando pessoa...';
			
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=getPessoa'
						,'cnpj_cpf='+REMETENTE_CNPJ_CPF.value +
						 '&num_modalidade=13,5'
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.cod_pessoa.length > 0) {
									COD_REMETENTE.value = obj.struct.cod_pessoa[0];
									REMETENTE.value = obj.struct.razao_social[0];
								}
								else {
									REMETENTE.value = 'Pessoa no encontrada.';
								}
							}
			});
		}
	}
	
	function f_busca_cliente() {
		with(document.forms[0]) {
			COD_CLIENTE.value = '';
			CLIENTE.value 	  = '';
			
			if(!CLIENTE_CNPJ_CPF.value) {
				return;
			}
			
			CLIENTE.value = 'Buscando cliente...';
			f_query_wddx('<cf_url>/_transportes/consulta/cfc_pessoa.cfc</cf_url>?method=get_pessoa_light'
						,'cnpj_cpf=' + CLIENTE_CNPJ_CPF.value +
						'&num_modalidade=5,13'
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.cod_pessoa.length > 0) {
									COD_CLIENTE.value = obj.struct.cod_pessoa[0];
									CLIENTE.value  	  = obj.struct.razao_social[0];
								}
								else {
									CLIENTE.value = 'Cliente no encontrado.';
								}
							}
						});
		}
	}
	
	
		var v_departamento = [];
		var v_setor		   = [];
		var v_centro_custo = [];
		
		<cfoutput query="qrOrganograma" group="COD_PESSOA">
			v_departamento.push( {
				cod_pessoa: 	  '#JSStringFormat(qrOrganograma.COD_PESSOA)#',
				cod_departamento: '#JSStringFormat(qrOrganograma.COD_DEPARTAMENTO)#',
				departamento: 	  '#JSStringFormat(qrOrganograma.DEPARTAMENTO)#'
			} );
		</cfoutput>
		
		<cfoutput query="qrOrganograma" group="COD_PESSOA">
			<cfoutput group="COD_DEPARTAMENTO">
				v_setor.push( {
					cod_pessoa: 	  '#JSStringFormat(qrOrganograma.COD_PESSOA)#',
					cod_departamento: '#JSStringFormat(qrOrganograma.COD_DEPARTAMENTO)#',
					cod_setor:		  '#JSStringFormat(qrOrganograma.COD_SETOR)#',
					setor:			  '#JSStringFormat(qrOrganograma.SETOR)#'
				} );
			</cfoutput>
		</cfoutput>	
		
		<cfoutput query="qrOrganograma">
			v_centro_custo.push( {
				cod_pessoa: 	  '#JSStringFormat(qrOrganograma.COD_PESSOA)#',
				cod_departamento: '#JSStringFormat(qrOrganograma.COD_DEPARTAMENTO)#',
				cod_setor:		  '#JSStringFormat(qrOrganograma.COD_SETOR)#',
				cod_centro_custo: '#JSStringFormat(qrOrganograma.COD_CENTRO_CUSTO)#',
				centro_custo: 	  '#JSStringFormat(qrOrganograma.CENTRO_CUSTO)#',
				cod_organograma:  '#JSStringFormat(qrOrganograma.COD_ORGANOGRAMA)#'
			} );
		</cfoutput>	


	function f_muda_centro_custo() {
		with(document.forms[0]) {
			COD_ORGANOGRAMA.value = COD_CENTRO_CUSTO.options[COD_CENTRO_CUSTO.selectedIndex].getAttribute('cod_organograma');
		}
	}
	
	function f_busca_departamento() {
		with(document.forms[0]) {
			var v_inserir;
			
			f_limpa_select(COD_DEPARTAMENTO);
			f_limpa_select(COD_SETOR);
			f_limpa_select(COD_CENTRO_CUSTO);
			
			f_cria_option('', '-- Todos --', COD_SETOR);
			f_cria_option('', '-- Todos --', COD_CENTRO_CUSTO);
			
			if(!COD_PESSOA_FILIAL.value) {
				f_cria_option('', '-- Todos --', COD_DEPARTAMENTO);
			}	
			
			
			for(var i = 0; i < v_departamento.length; i++) {
				if(Number(v_departamento[i].cod_pessoa) == Number(COD_PESSOA_FILIAL.value)) {
					v_inserir = true;
					
					for(var j = 0; j < COD_DEPARTAMENTO.options.length; j++) {
						if(Number(COD_DEPARTAMENTO.options[j].value) == Number(v_departamento[i].cod_departamento)) {
							v_inserir = false;
						}
					}
					
					if(v_inserir) {
						f_cria_option(v_departamento[i].cod_departamento, v_departamento[i].cod_departamento + ' - ' + v_departamento[i].departamento, COD_DEPARTAMENTO);
					}
				}
			}
			
			if(COD_DEPARTAMENTO.options.length == 0) {
				f_cria_option('', '-- Esta Filial no possui nenhum Departamento --', COD_DEPARTAMENTO);
			}
			else {
				COD_DEPARTAMENTO.onchange();
			}
			
			if(COD_DEPARTAMENTO.options.length == 2) {
				COD_DEPARTAMENTO.remove(0);  
			}
		}
	}
	
	function f_busca_setor() {
		with(document.forms[0]) {
			var v_inserir;
			
			f_limpa_select(COD_SETOR);
			f_limpa_select(COD_CENTRO_CUSTO);
			
			f_cria_option('', '-- Todos --', COD_CENTRO_CUSTO);
			
			if(!COD_DEPARTAMENTO.value) {
				f_cria_option('', '-- Todos --', COD_SETOR);
			}			

			
			for(var i = 0; i < v_setor.length; i++) {
				if((Number(v_setor[i].cod_pessoa) == Number(COD_PESSOA_FILIAL.value)) && (Number(v_setor[i].cod_departamento) == Number(COD_DEPARTAMENTO.value))) {
					v_inserir = true;
					
					for(var j = 0; j < COD_SETOR.options.length; j++) {
						if(Number(COD_SETOR.options[j].value) == Number(v_setor[i].cod_setor)) {
							v_inserir = false;
						}
					}
					
					if(v_inserir) {
						f_cria_option(v_setor[i].cod_setor, v_setor[i].cod_setor + ' - ' + v_setor[i].setor, COD_SETOR);
					}
				}
			}
			
			if(COD_SETOR.options.length == 0) {
				f_cria_option('', '-- Este Departamento no possui nenhum Setor --', COD_SETOR);
			}
			else {
				COD_SETOR.onchange();
			}
			
			if(COD_SETOR.options.length == 2) {
				COD_SETOR.remove(0);  
			}
		}
	}
	
	function f_busca_centro_custo() {
		with(document.forms[0]) {
			var v_inserir;
			
			f_limpa_select(COD_CENTRO_CUSTO);
			
			if(!COD_SETOR.value) {
				f_cria_option('', '-- Todos --', COD_CENTRO_CUSTO);
			}
			
			for(var i = 0; i < v_centro_custo.length; i++) {
				if((Number(v_centro_custo[i].cod_pessoa) == Number(COD_PESSOA_FILIAL.value)) && (Number(v_centro_custo[i].cod_departamento) == Number(COD_DEPARTAMENTO.value)) && (Number(v_centro_custo[i].cod_setor) == Number(COD_SETOR.value))) {
					v_inserir = true;
					
					for(var j = 0; j < COD_CENTRO_CUSTO.options.length; j++) {
						if(Number(COD_CENTRO_CUSTO.options[j].value) == Number(v_centro_custo[i].cod_centro_custo)) {
							v_inserir = false;
						}
					}
					
					if(v_inserir) {
						f_cria_option(v_centro_custo[i].cod_centro_custo, v_centro_custo[i].cod_centro_custo + ' - ' + v_centro_custo[i].centro_custo, COD_CENTRO_CUSTO);
					}
				}
			}
			
			if(COD_CENTRO_CUSTO.options.length == 0) {
				f_cria_option('', '-- Este Setor no possui nenhum Centro de Custo --', COD_CENTRO_CUSTO);
			}
			
			if(COD_CENTRO_CUSTO.options.length == 2) {
				COD_CENTRO_CUSTO.remove(0);  
			}
		}
	}
	
	
</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KM&amp;M :..</title>
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/status.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body class="background" style="height: 100%;">
<script src="/_scripts/dragdrop.js" type="text/javascript"></script>
<form id="form_transportes" name="form_transportes" method="get" action="" onSubmit="return f_confirmar()">
    <input type="hidden" name="OPERACAO" id="OPERACAO" value="" sempre_ativo="1" />
    <input type="hidden" name="CONHECIMENTO_ID" id="CONHECIMENTO_ID" value="" sempre_ativo="1" />
    <input type="hidden" name="PENDENCIA_OPERACIONAL_ID" id="PENDENCIA_OPERACIONAL_ID"  sempre_ativo="1" />
    <input type="hidden" name="COD_ORGANOGRAMA" id="COD_ORGANOGRAMA" sempre_ativo="1" />
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
    	<tr>
			<td>
                <fieldset><legend>Par&acirc;metros</legend>
                   <table width="100%" border="0" cellspacing="0" cellpadding="3">
                      <tr>
                        <td class="texto" nowrap width="1%">Per&iacute;odo:</td>
                        <td colspan="3" nowrap class="texto" width="99%">
						<input type="text" name="DATA_INICIO" id="DATA_INICIO" maxlength="10" tipo="data" display="PERODO" obrigatorio="1" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 85px;" value="<cfoutput>#lsDateFormat(v_data_inicio)#</cfoutput>"  />
                        <button class="botao-16x16" tabindex="1" id="btn_inicio"><img src="/_imagens/botoes/16x16/calendario.gif" alt="" width="16" height="16" align="absmiddle" /></button>
                        <script>
                            Calendar.setup(
                                {
                                  inputField  : "DATA_INICIO",
                                  ifFormat    : "%d/%m/%Y",
                                  button      : "btn_inicio",
                                  range       : [2001,2050]
                                }
                              );
                        </script>
                        at&eacute;                        
                      	<input type="text" name="DATA_TERMINO" id="DATA_TERMINO" maxlength="10" tipo="data" display="PERODO" obrigatorio="0" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 85px;" value="<cfoutput>#lsDateFormat(now())#</cfoutput>" />
                        <button class="botao-16x16" tabindex="1" id="btn_termino"><img src="/_imagens/botoes/16x16/calendario.gif" alt="" width="16" height="16" align="absmiddle" /></button>
                        <script>
                            Calendar.setup(
                                {
                                  inputField  : "DATA_TERMINO",
                                  ifFormat    : "%d/%m/%Y",
                                  button      : "btn_termino",
                                  range       : [2001,2050]
                                }
                              );
                        </script>
                        </td>
                    </tr>
                      <tr>
                        <td class="texto" nowrap>Status:</td>
                        <td colspan="3" nowrap class="texto">
							<select id="STATUS_PENDENCIA_ID" name="STATUS_PENDENCIA_ID">
                                <option value="">-- Todos --</option>
                            <cfoutput query="qrStatusPendencias">
                                <option value="#qrStatusPendencias.STATUS_PENDENCIA_ID#">#qrStatusPendencias.CODIGO# - #qrStatusPendencias.DESCRICAO#</option>
                            </cfoutput>
                            </select>
                        </td>
                      </tr>
                      <tr>
                        <td class="texto" nowrap>CTRC/CTe:</td>
                        <td colspan="3" nowrap class="texto">
                          <input obrigatorio="0" name="NUM_CONHECIMENTO"  type="text" id="NUM_CONHECIMENTO" style="width: 95px" maxlength="20" tipo="numerico" onKeyPress="return f_formata(this, '00000000000000000000')" />                          
                          <select name="SERIE" id="SERIE" obrigatorio="0" display="SERIE" fixo="1">
                             <cfif qrSerie.RecordCount gt 1 or qrSerie.RecordCount eq 0>
                               <option value="">--</option>
                             </cfif>
                             <cfoutput query="qrSerie">
                               <option value="#qrSerie.SERIE#">#qrSerie.SERIE#</option>
                             </cfoutput>
                           </select>
                        </td>
                      </tr>
                      <tr>
                        <td class="texto" nowrap>Nota Fiscal:</td>
                        <td colspan="3" nowrap class="texto"><input obrigatorio="0" name="NUM_NOTA_FISCAL" type="text" id="NUM_NOTA_FISCAL" style="width: 95px" maxlength="20" tipo="numerico" onKeyPress="return f_formata(this, '00000000000000000000')"/></td>
                      </tr>
                      <tr>
                        <td class="texto" nowrap>Pedido:</td>
                        <td colspan="3" nowrap class="texto"><input obrigatorio="0" name="NUM_PEDIDO" type="text" id="NUM_PEDIDO" style="width: 95px" maxlength="20" /></td>
                      </tr>
                      <tr>
                        <td class="texto" nowrap>C&oacute;digo TRM:</td>
                        <td colspan="3" nowrap class="texto"><input obrigatorio="0" name="COD_PEDIDO" type="text" id="COD_PEDIDO" style="width: 95px" maxlength="20" /></td>
                      </tr>
                      <tr>
                          <td class="texto" nowrap>N&ordm; Coleta:</td>
                          <td colspan="3" nowrap class="texto">
                          <input obrigatorio="0" name="NUM_COLETA" type="text" id="NUM_COLETA" style="width: 95px" maxlength="20" tipo="numerico" onKeyPress="return f_formata(this, '00000000000000000000')"/>
                          </td>
                    </tr>
                      <tr>
                        <td class="texto" nowrap>Cliente:</td>
                        <td colspan="3" nowrap class="texto">
                            <input type="hidden" name="COD_CLIENTE" id="COD_CLIENTE" display="CLIENTE" />
                            <input type="text" name="CLIENTE_CNPJ_CPF" id="CLIENTE_CNPJ_CPF" maxlength="14" tipo="numerico" display="CNPJ/CPF DO CLIENTE" onChange="f_busca_cliente()" onKeyPress="return f_formata(this, '00000000000000')" style="width: 95px;" />
                            <input type="text" name="CLIENTE" id="CLIENTE" readonly display="CLIENTE" style="width: 350px;" />&nbsp;
                            <button type="button" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?field=COD_PESSOA,CNPJ_CPF,RAZAO_SOCIAL&campo=COD_CLIENTE,CLIENTE_CNPJ_CPF,CLIENTE&num_modalidade=5,13', '_blank', 800, 600, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Cliente" title="Buscar Cliente" width="16" height="16" align="absmiddle" /></button>
                        </td>
                      </tr>
                      <tr>
                        <td class="texto" nowrap>Remetente:</td>
                        <td colspan="3" nowrap class="texto">
                          <input name="COD_REMETENTE" type="hidden" id="COD_REMETENTE"  />
                          <input name="REMETENTE_CNPJ_CPF" type="text" id="REMETENTE_CNPJ_CPF"  onchange="f_busca_pessoa_REMETENTE()" size="20" maxlength="16" tipo="numerico" onKeyPress="return f_formata(this,event,'00000000000000')" style="width: 95px;"/>
                          <input name="REMETENTE" type="text" id="REMETENTE" size="60" maxlength="60" readonly="true"  style="width: 350px;"/>&nbsp;
                          <button type="button" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?field=COD_PESSOA,CNPJ_CPF,RAZAO_SOCIAL&campo=COD_REMETENTE,REMETENTE_CNPJ_CPF,REMETENTE', '_blank', 800, 600, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar REMETENTE" title="Buscar Remetente" width="16" height="16" align="absmiddle" /></button>
                      	</td>
                      </tr>                     
                      <tr>
                        <td class="texto" nowrap>Destinat&aacute;rio:</td>
                        <td colspan="3" nowrap class="texto">
                          <input name="COD_DESTINATARIO" type="hidden" id="COD_DESTINATARIO"  />
                          <input name="DESTINATARIO_CNPJ_CPF" type="text" id="DESTINATARIO_CNPJ_CPF"  onchange="f_busca_pessoa_DESTINATARIO()" size="20" maxlength="16" tipo="numerico" onKeyPress="return f_formata(this,event,'00000000000000')" style="width: 95px;"/>
                          <input name="DESTINATARIO" type="text" id="DESTINATARIO" size="60" maxlength="60" readonly="true"  style="width: 350px;"/>&nbsp;
                          <button type="button" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?field=COD_PESSOA,CNPJ_CPF,RAZAO_SOCIAL&campo=COD_DESTINATARIO,DESTINATARIO_CNPJ_CPF,DESTINATARIO', '_blank', 800, 600, 'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar DESTINATARIO" title="Buscar Destinatrio" width="16" height="16" align="absmiddle" /></button>
                        </td>
                      </tr>
                     <tr>
                        <td nowrap class="texto">Filial:</td>
                        <td colspan="3" class="texto"><select name="COD_PESSOA_FILIAL" id="COD_PESSOA_FILIAL" obrigatorio="0" display="FILIAL" onChange="f_busca_departamento()" style="width: 320px;">
                            <option value="">-- Todas --</option>
                            <cfoutput query="qrOrganograma" group="COD_PESSOA">
                                <option value="#qrOrganograma.COD_PESSOA#">#qrOrganograma.COD_UNIDADE_NEGOCIO# - #qrOrganograma.NOME_FANTASIA#</option>
                            </cfoutput>
                            </select></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto">Departamento:</td>
                        <td colspan="3" class="texto"><select name="COD_DEPARTAMENTO" id="COD_DEPARTAMENTO" obrigatorio="0" display="DEPARTAMENTO" onChange="f_busca_setor()" style="width: 320px;">
                            <option value="">-- Todos --</option>
                            </select></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto">Setor:</td>
                        <td colspan="3" class="texto"><select name="COD_SETOR" id="COD_SETOR" obrigatorio="0" display="SETOR" onChange="f_busca_centro_custo()" style="width: 320px;">
                            <option value="">-- Todos --</option>
                            </select></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto">Centro de Custo:</td>
                        <td colspan="3" class="texto"><select name="COD_CENTRO_CUSTO" id="COD_CENTRO_CUSTO" obrigatorio="0" display="CENTRO DE CUSTO" onChange="f_muda_centro_custo()" style="width: 320px;">
                            <option value="" cod_organograma="">-- Todos --</option>
                            </select></td>
                    </tr>
                  </table>
                </fieldset>
			</td>
        </tr>
       <cfif qrPendenciaOperacional.RecordCount gt 0>
      	<tr>
        	<td>
            	<cfset grid_cod = 'PENDENCIA_OPERACIONAL'>
				<cfset grid_query = 'qrPendenciaOperacional'>
                <cfset grid_field_list    = ''>
                <cfset grid_field_caption = ''>
                <cfset grid_field_align   = ''>
                <cfset grid_field_type    = ''>                     
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_NOTA_FISCAL')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Nota Fiscal</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')> 
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_EMISSAO_NF')> 
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Data Emisso NF</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>       
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_CONHECIMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>CTRC/CTe</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_EMISSAO_CTRC')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Data Emisso CTRC/CTe</nobr>')>                
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'ORIGEM')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Origem</nobr>')>                
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DESTINO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Destino</nobr>')>                
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'REM_RAZAO_SOCIAL')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Remetente</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>                
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DEST_RAZAO_SOCIAL')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Destinatrio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>                
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_OCORRENCIA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Data Ocorrncia</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'OCORRENCIA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Ocorrncia</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')> 
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'SOLUCAO_APONTADA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Soluo Apontada</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>                                 
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'STATUS')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Status</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>                                 
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'RESPONSAVEL')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Responsvel</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>                                
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'TELEFONE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Telefone</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_FINALIZACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Data Finalizao</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')> 
                
                <cfset grid_tr_class_function 		  = 'fnc_grid_tr_class'>
                <cfset grid_tr_onclick_function 	  = 'fnc_grid_tr_onclick'>
                <cfset grid_td_inline_function 		  = 'fnc_grid_td_inline'>                               
                
                <cfscript>
					function fnc_grid_tr_class() {
							return "linha_branca";
					}					
					function fnc_grid_tr_onclick() {
						return "this.className = (this.className == 'linha_azul_escura' ? 'linha_branca' : 'linha_azul_escura');";
					}
					
					function fnc_grid_td_inline(field) {
						if(ucase(field) != 'OCORRENCIA' && ucase(field) != 'SOLUCAO_APONTADA'){
							return "nowrap";
						}
                    }
               </cfscript>
               
                <cfset grid_fixed_header = 0>
                <cfinclude template="/_include/grid/grid.cfm">
                    
            </td>
        </tr>
        <cfelse>
        <tr>
            <td align="center" valign="middle" class="obrigatorio" style="padding-top: 10px;">Nenhuma pendncia encontrada.</td>
        </tr>
        </cfif>
	</table>    
    </form>
</body>
<script type="text/javascript">

	f_hide_carregando();
	
	with(document.forms[0]) {
				
		<cfoutput>
			<cfif IsDefined("vars.DATA_INICIO")>		
				DATA_INICIO.value = '#JSStringFormat(vars.DATA_INICIO)#';
			</cfif>	
			<cfif IsDefined("vars.DATA_TERMINO")>		
				DATA_TERMINO.value = '#JSStringFormat(vars.DATA_TERMINO)#';
			</cfif>	
			<cfif IsDefined("vars.STATUS_PENDENCIA_ID")>	
				STATUS_PENDENCIA_ID.value = '#JSStringFormat(vars.STATUS_PENDENCIA_ID)#';
			</cfif>				
			<cfif IsDefined("vars.NUM_CONHECIMENTO")>	
				NUM_CONHECIMENTO.value = '#JSStringFormat(vars.NUM_CONHECIMENTO)#';
			</cfif>	
			<cfif IsDefined("vars.SERIE")>	
				SERIE.value = '#JSStringFormat(vars.SERIE)#';
			</cfif>	
			<cfif IsDefined("vars.NUM_NOTA_FISCAL")>	
				NUM_NOTA_FISCAL.value = '#JSStringFormat(vars.NUM_NOTA_FISCAL)#';
			</cfif>	
			<cfif IsDefined("vars.NUM_PEDIDO")>	
				NUM_PEDIDO.value = '#JSStringFormat(vars.NUM_PEDIDO)#';
			</cfif>	
			<cfif IsDefined("vars.COD_PEDIDO")>	
				COD_PEDIDO.value = '#JSStringFormat(vars.COD_PEDIDO)#';
			</cfif>	
			<cfif IsDefined("vars.NUM_COLETA")>	
				NUM_COLETA.value = '#JSStringFormat(vars.NUM_COLETA)#';
			</cfif>							
			<cfif IsDefined("vars.COD_REMETENTE")>		
				COD_REMETENTE.value  = '#JSStringFormat(vars.COD_REMETENTE)#';
			</cfif>	
			<cfif IsDefined("vars.REMETENTE_CNPJ_CPF")>		
				REMETENTE_CNPJ_CPF.value = '#JSStringFormat(vars.REMETENTE)#';
			</cfif>	
			<cfif IsDefined("vars.REMETENTE")>		
				REMETENTE.value = '#JSStringFormat(vars.REMETENTE)#';
			</cfif>				
			<cfif IsDefined("vars.COD_REMETENTE")>		
				COD_REMETENTE.value  = '#JSStringFormat(vars.COD_REMETENTE)#';
			</cfif>	
			<cfif IsDefined("vars.DESTINATARIO_CNPJ_CPF")>		
				DESTINATARIO_CNPJ_CPF.value = '#JSStringFormat(vars.DESTINATARIO_CNPJ_CPF)#';
			</cfif>	
			<cfif IsDefined("vars.DESTINATARIO")>		
				DESTINATARIO.value = '#JSStringFormat(vars.DESTINATARIO)#';
			</cfif>		
			<cfif IsDefined("vars.COD_PESSOA_FILIAL")>		
				COD_PESSOA_FILIAL.value = '#JSStringFormat(vars.COD_PESSOA_FILIAL)#';
				COD_PESSOA_FILIAL.onchange();
			</cfif>	   
		</cfoutput>
	}
</script>
</html>
<iframe name="consultas" frameborder="0" width="100%" height="600" src="" style=" display:none;"></iframe>
<cfset RequestEnd = 0>