<html xmlns="http://www.w3.org/1999/xhtml">
<cfscript>
	conn = CreateObject("component","_transportes.consulta.cfc_almoxarifado");	
	qrEstoque = conn.get_material_compra(argumentCollection = vars);

// ChartDirector for ColdFusion API Access Point
cd = CreateObject("java", "ChartDirector.CFChart");

// A utility to allow us to create arrays with data in one line of code
function Array() {
    var result = ArrayNew(1);
    var i = 0;
    for (i = 1; i LTE ArrayLen(arguments); i = i + 1)
        result[i] = arguments[i];
    return result;
}

// The data for the chart
data0 = ListToArray(ValueList(qrEstoque.VALOR_UNITARIO));
data1 = ListToArray(ValueList(qrEstoque.VALOR_MEDIO));
data2 = ListToArray(ValueList(qrEstoque.MATERIAL_COMPRA));

v_marca1 = ArrayMax(ListToArray(ValueList(qrEstoque.MARCA_INICIAL)));
v_marca2 = ArrayMin(ListToArray(ValueList(qrEstoque.MARCA_FINAL)));

// In this example, the data points are unevenly spaced on the x-axis
for (i=1; i lte qrEstoque.recordCount; i=i+1) {
	if (v_marca2 eq 0) v_marca2 = qrEstoque.MARCA_FINAL[i];
	if (qrEstoque.recordCount gt 10) {
		labels[i] = LSDateFormat(qrEstoque.DATA_LANCAMENTO[i],'dd/mm');
	}
	else {
		labels[i] = LSDateFormat(qrEstoque.DATA_LANCAMENTO[i],'dd/mm/yyyy');
	}
}

if (v_marca2 eq 100) v_marca2 = qrEstoque.recordCount-1;

// Create a XYChart object of size 600 x 300 pixels, with a pale red (ffdddd)
// background, black border, 1 pixel 3D border effect and rounded corners.
c = cd.XYChart(800, 300, "0xcccccc", "0x000000", 1);
c.setRoundedFrame();

// Set search path to current directory for loading icon images
c.setSearchPath(GetPageContext());

// Set the plotarea at (55, 58) and of size 520 x 195 pixels, with white (ffffff)
// background. Set horizontal and vertical grid lines to grey (cccccc).
c.setPlotArea(55, 58, 720, 195, "0xffffff", -1, -1, "0xcccccc", "0xcccccc");

// Add a legend box at (55, 32) (top of the chart) with horizontal layout. Use 9 pts
// Arial Bold font. Set the background and border color to Transparent.
c.addLegend(55, 32, False, "Arial Bold", 9).setBackground(cd.Transparent);

// Add a title box to the chart using 15 pts Times Bold Italic font. The title is in
// CDML and includes embedded images for highlight. The text is white (ffffff) on a
// dark red (880000) background, with soft lighting effect from the right side.
c.addTitle("<*block,valign=absmiddle*>Compras dos timos 6 meses<*/*>", "Verdana",
    15, "0xffffff").setBackground("0x880000", -1, cd.softLighting(cd.Right));

copyRight = c.addText(770, 250, qrEstoque.MATERIAL, "Arial Bold");
copyRight.setAlignment(cd.BottomRight);

// Add a title to the y axis
c.yAxis().setTitle("Valor Unitrio");

// Set the labels on the x axis
c.xAxis().setLabels(labels);

// Add a title to the x axis using CMDL
c.xAxis().setTitle(
    "<*block,valign=absmiddle*>Data Compra<*/*>");

// Set the axes width to 2 pixels
c.xAxis().setWidth(2);
c.yAxis().setWidth(2);

c.xAxis().addZone(v_marca1, v_marca2, "0xD8E8FA");

// Add a vertical brown (0x995500) mark line at x = 18
xMark1 = c.xAxis().addMark(v_marca1, "0x995500", "Data Inicial");

// Set the mark line width to 2 pixels
xMark1.setLineWidth(2);

// Put the mark label at the left of the mark line
xMark1.setAlignment(cd.Left);

// Rotate the mark label by 90 degrees so it draws vertically
xMark1.setFontAngle(90);

// Marca FINAL
xMark2 = c.xAxis().addMark(v_marca2, "0x995500", "Data Final");

// Set the mark line width to 2 pixels
xMark2.setLineWidth(2);

// Put the mark label at the right of the mark line
xMark2.setAlignment(cd.Right);

// Rotate the mark label by 90 degrees so it draws vertically
xMark2.setFontAngle(90);

// Add a line layer to the chart
layer = c.addLineLayer();

layer.setLineWidth(2);

// Add the first line
layer.addDataSet(data0, "0xcf4040", "Compra").setDataSymbol(cd.SquareSymbol, 4);

layer.addExtraField(data2);

// Add the second line. Plot the points with a 9 pixel dismond symbol
layer.addDataSet(data1, "0x40cf40", "Mdio").setDataSymbol(cd.DiamondSymbol, 6);

// Enable data label on the data points. Set the label format to nn%.
layer.setDataLabelFormat("{value|0}");

// Output the chart
chart1URL = c.makeSession(GetPageContext(), "chart1");

// Include tool tip for the chart
imageMap1 = c.getHTMLImageMap("","", "title='{field0} - {xLabel}: {dataSetName}: R$ {value}'");

</cfscript>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>ltimas compras</title>
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body>
<cfoutput>
<img border="0" src="/_scripts/cfdemo/getchart.cfm?#chart1URL#" usemap="##map1"/>
<map name="map1">#imageMap1#</map>
</cfoutput>
</body>
</html>
