<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Insere um vale
    -- cristofer 26/12/2008 13:34:30 - CRIADO
    --->
    <cffunction name='ins_vale' displayname='Insere um vale' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_VALE' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='TIPO_ID' required='yes'>
        <cfargument name='COD_PESSOA_TROCA' required='yes'>
        <cfargument name='DATA_ENTREGA' required='yes'>
        <cfargument name='DATA_TROCA' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='COD_PESSOA_FUNCIONARIO' required='yes'>
        <cfargument name='COMENTARIO' required='yes'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='CC_SACADO' required='no' default="">
        <cfargument name='CONTROLE_ID' required='no' default="">
        <cfargument name='USUARIO_LIBERACAO' required='no' default="">
        <cfargument name='SENHA_LIBERACAO' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_controla_vale.prc_ins_vale' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_VALE'  value='#arguments.NUM_VALE#' variable='retorno.NUM_VALE'  null='#iif(len(trim(arguments.NUM_VALE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_TROCA'  value='#arguments.COD_PESSOA_TROCA#'  null='#iif(len(trim(arguments.COD_PESSOA_TROCA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTREGA'  value='#arguments.DATA_ENTREGA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_TROCA'  value='#arguments.DATA_TROCA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FUNCIONARIO'  value='#arguments.COD_PESSOA_FUNCIONARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_FUNCIONARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CC_SACADO'  value='#arguments.CC_SACADO#'  null='#iif(len(trim(arguments.CC_SACADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLE_ID'  value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_USUARIO_LIBERACAO' value='#arguments.USUARIO_LIBERACAO#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SENHA_LIBERACAO' value='#arguments.SENHA_LIBERACAO#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vale inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Cancela uma sequencia de vales
    -- cristofer 26/12/2008 13:36:43 - CRIADO
    --->
    <cffunction name='cancela_vales' displayname='Cancela uma sequencia de vales' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_INICIAL' required='yes'>
        <cfargument name='NUM_FINAL' required='yes'>
        <cfargument name='MOTIVO' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='TODOS' required='no' default="0">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_controla_vale.prc_cancela_vales' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_INICIAL'  value='#arguments.NUM_INICIAL#'  null='#iif(len(trim(arguments.NUM_INICIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_FINAL'  value='#arguments.NUM_FINAL#'  null='#iif(len(trim(arguments.NUM_FINAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TODOS'  value='#arguments.TODOS#'  null='#iif(len(trim(arguments.TODOS)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfif arguments.num_inicial eq arguments.num_final>
	                <cfset retorno.mensagem = JSStringFormat('Vale cancelado com sucesso!')>
                <cfelse>
	                <cfset retorno.mensagem = JSStringFormat('Vales cancelados com sucesso!')>
                </cfif>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
</cfcomponent>