<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Consulta Roteiros
	-- ANDERSONC 10/06/2011 18:44:01 - CRIADO
	--->
	<cffunction name='consulta_roteiros' displayname='Consulta Roteiros' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='repom.pkg_repom.prc_consulta_roteiros' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORIGEM_MUNICIPIO_ID'  value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESTINO_MUNICIPIO_ID'  value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Solicita um Roteiro
	-- ANDERSONC 10/06/2011 15:37:17 - CRIADO
	--->
	<cffunction name='solicita_roteiro' displayname='Solicita um Roteiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='ROTA_ID' required='yes'>
        <cfargument name='DESCRICAO_ROTA' required='no' default=''>
		<cfargument name='PEDAGIO_IDA_VOLTA' required='no' default=''>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_repom.prc_solicita_roteiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_ROTA'  value='#arguments.DESCRICAO_ROTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PEDAGIO_IDA_VOLTA'  value='#arguments.PEDAGIO_IDA_VOLTA#'  null='#iif(len(trim(arguments.PEDAGIO_IDA_VOLTA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Roteiro solicitado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Verificar dados junto a Repom
	-- FABIOG 15/06/2011 11:43:37 - CRIADO
	--->
	<cffunction name='ins_solicit_carga_dados' displayname='Verificar dados junto a Repom' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
		<cfargument name='CARTAO_NUMERO' required='yes'>
		<cfargument name='ADTO_TRAJETO_VAZIO' required='yes'>
		<cftry>
            <cfstoredproc procedure='repom.pkg_logistica.prc_ins_solicit_carga_dados' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_CARGA_ID'  value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CARTAO_NUMERO'  value='#arguments.CARTAO_NUMERO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ADTO_TRAJETO_VAZIO'  value='#arguments.ADTO_TRAJETO_VAZIO#'  null='#iif(len(trim(arguments.ADTO_TRAJETO_VAZIO)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MENSAGEM' variable='retorno.MENSAGEM' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Verifica o carto
    -- ANDERSONC 28/09/2011 18:02:29 - CRIADO
    --->
    <cffunction name='verificar_cartao' displayname='Verifica o carto' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='no' default=''>
        <cfargument name='CARTAO_NUMERO' required='no' default=''>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='repom.pkg_logistica.prc_verificar_cartao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_CARGA_ID'  value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CARTAO_NUMERO'  value='#arguments.CARTAO_NUMERO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao para Verificar Carto na Repom enviada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Verifica o roteiro e retorna o valor de pedgio
    -- ANDERSONC 29/09/2011 09:56:10 - CRIADO
    --->
    <cffunction name='verificar_roteiro' displayname='Verifica o roteiro e retorna o valor de pedgio' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='no' default=''>
        <cfargument name='ROTA_ID' required='no' default=''>
        <cfargument name='PLACA_CAVALO' required='no' default=''>
        <cfargument name='PLACA_CARRETA' required='no' default=''>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='repom.pkg_logistica.prc_verificar_roteiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_CARGA_ID'  value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CAVALO'  value='#arguments.PLACA_CAVALO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CARRETA'  value='#arguments.PLACA_CARRETA#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_PEDAGIO_ROTA' variable='retorno.VALOR_PEDAGIO_ROTA' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao para Verificar Roteiro na Repom enviada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Verifica os dados do contratado, motorista, cavalo e carreta
	-- ANDERSONC 29/09/2011 09:58:02 - CRIADO
	--->
	<cffunction name='verificar_dados' displayname='Verifica os dados do contratado, motorista, cavalo e carreta' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_CARGA_ID' required='no' default=''>
		<cfargument name='PLACA_CAVALO' required='no' default=''>
		<cfargument name='PLACA_CARRETA' required='no' default=''>
		<cfargument name='COD_MOTORISTA' required='no' default=''>
		<cfargument name='COD_CONTRATADO' required='no' default=''>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_logistica.prc_verificar_dados' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_CARGA_ID'  value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CAVALO'  value='#arguments.PLACA_CAVALO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CARRETA'  value='#arguments.PLACA_CARRETA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTRATADO'  value='#arguments.COD_CONTRATADO#'  null='#iif(len(trim(arguments.COD_CONTRATADO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitao para Atualizar Cadastros na Repom enviada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Solicita o roteiro
    -- ANDERSONC 29/09/2011 10:02:48 - CRIADO
    --->
    <cffunction name='solicitar_roteiro' displayname='Solicita o roteiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='no' default=''>
        <cfargument name='ROTA_ID' required='no' default=''>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='repom.pkg_logistica.prc_solicitar_roteiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_CARGA_ID'  value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao enviada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gerar o contrato de quitao
	-- FABIOG 16/06/2011 10:12:18 - CRIADO
	--->
	<cffunction name='gera_contrato_quitacao' displayname='Gerar o contrato de quitao' access='remote' returntype='Struct' output='true'>
	<cfargument name='CONTRATO_QUITACAO_ID' required='yes'>
	<cftry>
    	<cftransaction action='begin'>
            <cfstoredproc procedure='repom.pkg_impressao.prc_gera_contrato_quitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_QUITACAO_ID'  value='#arguments.CONTRATO_QUITACAO_ID#'  null='#iif(len(trim(arguments.CONTRATO_QUITACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB' dbvarname='P_ARQUIVO' variable='retorno.ARQUIVO' >
            </cfstoredproc>
            <cfset retorno.erro = false>
        </cftransaction>
    <cfcatch>
        <cftransaction action='rollback'/>
        <cfset retorno.erro = true>
        <cfset retorno.mensagem = cfcatch>
        <cfset request.erro = cfcatch>
    </cfcatch>
	</cftry>
	<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Consultar os dados do contrato junto a Repom.
	-- FABIOG 16/06/2011 15:36:14 - CRIADO
	--->
	<cffunction name='consulta_contrato' displayname='Consultar os dados do contrato junto a Repom.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='repom.pkg_repom.prc_consulta_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISICAO_ID' variable='retorno.REQUISICAO_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Quitar um contrato junto a Repom.
	-- FABIOG 17/06/2011 10:47:34 - CRIADO
	--->
	<cffunction name='quita_contrato' displayname='Quitar um contrato junto a Repom.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='COD_ORGANOGRAMA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_repom.prc_quita_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_QUITACAO_ID' variable='retorno.CONTRATO_QUITACAO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANOGRAMA'  value='#arguments.COD_ORGANOGRAMA#' >
				</cfstoredproc>
                
                <cfset retorno.mensagem = 'Contrato quitado com sucesso.'>
				<cfset retorno.erro = false>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Emite um contrato
	-- ANDERSONC 02/09/2011 16:25:10 - CRIADO
	--->
	<cffunction name='emitir_contrato' displayname='Emite um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='ROTA_ID' required='yes'>
		<cfargument name='CARTAO_NUMERO' required='yes'>
		<cftry>
            <cfstoredproc procedure='repom.pkg_contrato.prc_emitir_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID' variable='retorno.CONTRATO_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CARTAO_NUMERO'  value='#arguments.CARTAO_NUMERO#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Autorizar um pagamento
	-- FABIOG 25/06/2011 10:15:45 - CRIADO
	--->
	<cffunction name='autoriza_pagamento' displayname='Autorizar um pagamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='QUANTIDADE_DIAS' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_repom.prc_autoriza_pagamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE_DIAS'  value='#arguments.QUANTIDADE_DIAS#'  null='#iif(len(trim(arguments.QUANTIDADE_DIAS)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pagamento autorizado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gerar um contrato
	-- FABIOG 27/06/2011 16:11:49 - CRIADO
	--->
	<cffunction name='gera_contrato' displayname='Gerar um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_impressao.prc_gera_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB' dbvarname='P_ARQUIVO' variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('a')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gerar um contrato
	-- ANDERSONC 29/07/2011 13:12:09 - CRIADO
	--->
	<cffunction name='emitir_contrato_viagem' displayname='Gerar um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='VIAGEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_contrato.prc_emitir_contrato_vazio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID' variable='retorno.CONTRATO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VIAGEM_ID'  value='#arguments.VIAGEM_ID#'  null='#iif(len(trim(arguments.VIAGEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato emitido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Cancela um contrato
	-- ANDERSONC 04/10/2011 16:04:03 - CRIADO
	--->
	<cffunction name='cancela_contrato' displayname='Cancela um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_contrato.prc_cancelar_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato cancelado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Integra um contrato
	-- ANDERSONC 21/11/2011 13:52:42 - CRIADO
	--->
	<cffunction name='integrar_contrato' displayname='Integra um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_contrato.prc_integrar_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_ID'  value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato Integrado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>