<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Insere pamcard
    -- LEANDROR 26/05/2010 17:19:50 - CRIADO
    --->
    <cffunction name='ins_pamcard' displayname='Insere pamcard' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUMERO' required='yes'>
        <cfargument name='COD_PESSOA_PORTADOR' required='yes'>
        <cfargument name='TIPO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='pamcary.pkg_pamcard.prc_ins_pamcard' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER' dbvarname='PARAMETER' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAMCARD_ID' variable='retorno.PAMCARD_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUMERO'  value='#arguments.NUMERO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_PORTADOR'  value='#arguments.COD_PESSOA_PORTADOR#'  null='#iif(len(trim(arguments.COD_PESSOA_PORTADOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO'  value='#arguments.TIPO#'  null='#iif(len(trim(arguments.TIPO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Pamcard inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Altera pamcard
    -- LEANDROR 26/05/2010 17:18:55 - CRIADO
    --->
    <cffunction name='alt_pamcard' displayname='Altera pamcard' access='remote' returntype='Struct' output='true'>
        <cfargument name='PAMCARD_ID' required='yes'>
        <cfargument name='NUMERO' required='yes'>
        <cfargument name='COD_PESSOA_PORTADOR' required='yes'>
        <cfargument name='TIPO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='pamcary.pkg_pamcard.prc_alt_pamcard' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER' dbvarname='PARAMETER' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAMCARD_ID'  value='#arguments.PAMCARD_ID#'  null='#iif(len(trim(arguments.PAMCARD_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUMERO'  value='#arguments.NUMERO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_PORTADOR'  value='#arguments.COD_PESSOA_PORTADOR#'  null='#iif(len(trim(arguments.COD_PESSOA_PORTADOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO'  value='#arguments.TIPO#'  null='#iif(len(trim(arguments.TIPO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Pamcard alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
        
    
	<!--- 
    -- PROPSITO
    -- Exclui pamcard
    -- LEANDROR 26/05/2010 17:17:47 - CRIADO
    --->
    <cffunction name='del_pamcard' displayname='Exclui pamcard' access='remote' returntype='Struct' output='true'>
        <cfargument name='PAMCARD_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='pamcary.pkg_pamcard.prc_del_pamcard' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER' dbvarname='PARAMETER' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PAMCARD_ID'  value='#arguments.PAMCARD_ID#'  null='#iif(len(trim(arguments.PAMCARD_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Pamcard excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
-- PROPSITO
-- Integra romaneio com a Pamcary
-- LEANDROR 27/05/2010 14:51:43 - CRIADO
--->
    <cffunction name='ins_transacao' displayname='Integra romaneio com a Pamcary' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='VALOR_PEDAGIO' required='no' default="">
        <cfargument name='SOMENTE_CHEIO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='pamcary.pkg_transacao.prc_ins_transacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER' dbvarname='PARAMETER' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSACAO_ID' variable='retorno.TRANSACAO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_PEDAGIO'  value='#arguments.VALOR_PEDAGIO#'  null='#iif(len(trim(arguments.VALOR_PEDAGIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOMENTE_CHEIO'  value='#arguments.SOMENTE_CHEIO#'  null='#iif(len(trim(arguments.SOMENTE_CHEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Romaneio integrado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Exclui uma transao
	-- WAGNERS 23/12/2010 11:18:34 - CRIADO
	--->
	<cffunction name='del_transacao' displayname='Exclui uma transao' access='remote' returntype='Struct' output='true'>
		<cfargument name='TRANSACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pamcary.pkg_transacao.prc_del_transacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSACAO_ID'  value='#arguments.TRANSACAO_ID#'  null='#iif(len(trim(arguments.TRANSACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Transao excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui uma transao
	-- WAGNERS 23/12/2010 11:18:34 - CRIADO
	--->
	<cffunction name='atualiza_retorno' displayname='Atualiza transao' access='remote' returntype='Struct' output='true'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pamcary.pkg_transacao.prc_att_retorno' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atualizao efetuada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
</cfcomponent>