<cfcomponent extends="_transportes.funcoes.cfc_init">
    <!--- 
    -- PROPSITO
    -- Insere uma despesa de viagem para o motorista
    -- cristofer 31/12/2008 10:35:01 - CRIADO
    --->
    <cffunction name='ins_mot_viagem_despesa' displayname='Insere uma despesa de viagem para o motorista' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_LANCAMENTO' required='yes'>
        <cfargument name='DATA_DESPESA' required='yes'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='VALOR_LANCAMENTO' required='yes'>
        <cfargument name='HISTORICO' required='yes'>
        <cfargument name='FAVORECIDO' required='yes'>
        <cfargument name='PRODUTO_ID' required='yes'>        
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_motorista.prc_ins_mot_viagem_despesa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_DESPESA'  value='#arguments.DATA_DESPESA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_LANCAMENTO'  value='#arguments.VALOR_LANCAMENTO#'  null='#iif(len(trim(arguments.VALOR_LANCAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HISTORICO'  value='#arguments.HISTORICO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FAVORECIDO'  value='#arguments.FAVORECIDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOT_DESPESA_ID' variable='retorno.MOT_DESPESA_ID' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Despesa inserida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera uma despesa de viagem para o motorista
    -- cristofer 31/12/2008 10:36:25 - CRIADO
    --->
    <cffunction name='upd_mot_viagem_despesa' displayname='Altera uma despesa de viagem para o motorista' access='remote' returntype='Struct' output='true'>
        <cfargument name='MOT_DESPESA_ID' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='DATA_LANCAMENTO' required='yes'>
        <cfargument name='DATA_DESPESA' required='yes'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='VALOR_LANCAMENTO' required='yes'>
        <cfargument name='HISTORICO' required='yes'>
        <cfargument name='FAVORECIDO' required='yes'>
        <cfargument name='PRODUTO_ID' required='yes'>        
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_motorista.prc_alt_mot_viagem_despesa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOT_DESPESA_ID'  value='#arguments.MOT_DESPESA_ID#'  null='#iif(len(trim(arguments.MOT_DESPESA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_DESPESA'  value='#arguments.DATA_DESPESA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_LANCAMENTO'  value='#arguments.VALOR_LANCAMENTO#'  null='#iif(len(trim(arguments.VALOR_LANCAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_HISTORICO'  value='#arguments.HISTORICO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FAVORECIDO'  value='#arguments.FAVORECIDO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Despesa alterada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Cancela uma despesa de viagem para o motorista
    -- cristofer 31/12/2008 10:37:02 - CRIADO
    --->
    <cffunction name='cancela_mot_viagem_despesa' displayname='Cancela uma despesa de viagem para o motorista' access='remote' returntype='Struct' output='true'>
        <cfargument name='MOT_DESPESA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_motorista.prc_cancel_mot_viagem_desp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOT_DESPESA_ID'  value='#arguments.MOT_DESPESA_ID#'  null='#iif(len(trim(arguments.MOT_DESPESA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Despesa cancelada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Estorna uma despesa de viagem para o motorista
    -- cristofer 31/12/2008 10:37:33 - CRIADO
    --->
    <cffunction name='estorna_mot_viagem_despesa' displayname='Estorna uma despesa de viagem para o motorista' access='remote' returntype='Struct' output='true'>
        <cfargument name='MOT_DESPESA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_motorista.prc_estorna_mot_viagem_desp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOT_DESPESA_ID'  value='#arguments.MOT_DESPESA_ID#'  null='#iif(len(trim(arguments.MOT_DESPESA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Despesa estornada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
</cfcomponent>