<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Insere um item de ajuste do itinerario
    -- cristofer 05/01/2009 14:07:29 - CRIADO
    --->
    <cffunction name='ajusta_itinerarios' displayname='Insere um item de ajuste do itinerario' access='remote' returntype='Struct' output='true'>
        <cftry>
            <cftransaction action='begin'>
            	<cfscript>
					v_str = structnew();
					v_str.data_chegada		= this.ListaToArray (lista = arguments, variavel = "C_DATA_CHEGADA");
					v_str.data_previsao		= this.ListaToArray (lista = arguments, variavel = "C_DATA_PREVISAO");
					v_str.placa_referencia	= this.ListaToArray (lista = arguments, variavel = "C_PLACA_REFERENCIA");
					v_str.rota_id			= this.ListaToArray (lista = arguments, variavel = "C_ROTA_ID");
					v_str.itinerario_id		= this.ListaToArray (lista = arguments, variavel = "C_ITINERARIO_ID");
					v_str.km_rota			= this.ListaToArray (lista = arguments, variavel = "C_KM_ROTA");
					v_str.num_romaneio		= this.ListaToArray (lista = arguments, variavel = "C_NUM_ROMANEIO");
					v_str.ordem				= this.ListaToArray (lista = arguments, variavel = "C_ORDEM");
					v_str.vazio_carregado	= this.ListaToArray (lista = arguments, variavel = "C_VAZIO_CARREGADO");
				</cfscript>
                <cfdump var="#v_str#">
                <cfloop from="1" to="#ArrayLen(v_str.itinerario_id)#" index="count">
					<cfscript>
                        ret = this.ins_itinerario_ajuste(
                                                itinerario_id		= iif(left(v_str.itinerario_id[count],1) eq 'I',de('-1'),de(v_str.itinerario_id[count])),
                                                placa_referencia	= v_str.placa_referencia[count],
                                                rota_id				= v_str.rota_id[count],
                                                km_rota				= v_str.km_rota[count],
                                                data_previsao		= v_str.data_previsao[count],
                                                data_chegada		= v_str.data_chegada[count],
                                                vazio_carregado		= v_str.vazio_carregado[count],
                                                num_romaneio		= v_str.num_romaneio[count],
                                                ordem				= v_str.ordem[count],
                                                redespacho_cfa		= '',
                                                sequencia			= count);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <cfif isdefined("arguments.itinerario_id_inicial")>
                	<cfscript>
                        ret = this.ins_itinerario_ajuste(
                                                itinerario_id		= arguments.itinerario_id_inicial,
                                                placa_referencia	= '',
                                                rota_id				= '',
                                                km_rota				= '',
                                                data_previsao		= '',
                                                data_chegada		= '',
                                                vazio_carregado		= '',
                                                num_romaneio		= '',
                                                ordem				= '',
                                                redespacho_cfa		= '',
                                                sequencia			= -1);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                <cfif isdefined("arguments.itinerario_id_final")>
                	<cfscript>
                        ret = this.ins_itinerario_ajuste(
                                                itinerario_id		= arguments.itinerario_id_final,
                                                placa_referencia	= '',
                                                rota_id				= '',
                                                km_rota				= '',
                                                data_previsao		= '',
                                                data_chegada		= '',
                                                vazio_carregado		= '',
                                                num_romaneio		= '',
                                                ordem				= '',
                                                redespacho_cfa		= '',
                                                sequencia			= -2);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>
                <cfstoredproc procedure='oper.pkg_itinerario.prc_ajusta_itinerarios' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Itinerarios ajustados com sucesso')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Insere um item de ajuste do itinerario
    -- cristofer 05/01/2009 14:07:29 - CRIADO
    --->
    <cffunction name='ins_itinerario_ajuste' displayname='Insere um item de ajuste do itinerario' access='remote' returntype='Struct' output='true'>
        <cfargument name='ITINERARIO_ID' required='yes'>
        <cfargument name='PLACA_REFERENCIA' required='yes'>
        <cfargument name='ROTA_ID' required='yes'>
        <cfargument name='KM_ROTA' required='yes'>
        <cfargument name='DATA_PREVISAO' required='yes'>
        <cfargument name='DATA_CHEGADA' required='yes'>
        <cfargument name='VAZIO_CARREGADO' required='yes'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='ORDEM' required='yes'>
        <cfargument name='REDESPACHO_CFA' required='yes'>
        <cfargument name='SEQUENCIA' required='yes'>
        <cftry>
        		<!---<cfoutput>
                insert into oper.romaneio_itinerario_temp 
                  (itinerario_id, placa_referencia, rota_id, km_rota, data_previsao, data_chegada, vazio_carregado, num_romaneio,ordem, redespacho_cfa,sequencia)
				values
				  ('#arguments.itinerario_id#','#arguments.placa_referencia#','#arguments.rota_id#','#arguments.km_rota#','#arguments.data_previsao#','#arguments.data_chegada#','#arguments.vazio_carregado#','#arguments.num_romaneio#','#arguments.ordem#','#arguments.redespacho_cfa#','#arguments.sequencia#');<br>

				</cfoutput>--->
                <cfstoredproc procedure='oper.pkg_itinerario.prc_ins_itinerario_ajuste' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ITINERARIO_ID'  value='#arguments.ITINERARIO_ID#'  null='#iif(len(trim(arguments.ITINERARIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_REFERENCIA'  value='#arguments.PLACA_REFERENCIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_KM_ROTA'  value='#arguments.KM_ROTA#'  null='#iif(len(trim(arguments.KM_ROTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PREVISAO'  value='#arguments.DATA_PREVISAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CHEGADA'  value='#arguments.DATA_CHEGADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VAZIO_CARREGADO'  value='#arguments.VAZIO_CARREGADO#'  null='#iif(len(trim(arguments.VAZIO_CARREGADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORDEM'  value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REDESPACHO_CFA'  value='#arguments.REDESPACHO_CFA#'  null='#iif(len(trim(arguments.REDESPACHO_CFA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SEQUENCIA'  value='#arguments.SEQUENCIA#'  null='#iif(len(trim(arguments.SEQUENCIA)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Item inserido com sucesso')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

</cfcomponent>