<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Insere um grupo de embalagem
    -- ANDERSONC 28/12/2009 18:01:31 - CRIADO
    --->
    <cffunction name='ins_grupo_embalagem' displayname='Insere um grupo de embalagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_ins_grupo_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_ID' variable='retorno.GRUPO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Grupo de embalagem inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um grupo de embalagem
    -- ANDERSONC 28/12/2009 18:02:22 - CRIADO
    --->
    <cffunction name='upd_grupo_embalagem' displayname='Altera um grupo de embalagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='GRUPO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_alt_grupo_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Grupo de embalagem alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um grupo de embalagem
    -- ANDERSONC 28/12/2009 18:02:54 - CRIADO
    --->
    <cffunction name='del_grupo_embalagem' displayname='Exclui um grupo de embalagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='GRUPO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_del_grupo_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Grupo de embalagem excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere um tipo de embalagem
    -- ANDERSONC 29/12/2009 11:07:16 - CRIADO
    --->
    <cffunction name='ins_tipo_embalagem' displayname='Insere um tipo de embalagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='GRUPO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='ABREVIATURA' required='yes'>
        <cfargument name='CAPACIDADE' required='yes'>
        <cfargument name='COD_UNIDADE' required='yes'>
        <cfargument name='ALTURA' required='yes'>
        <cfargument name='COMPRIMENTO' required='yes'>
        <cfargument name='LARGURA' required='yes'>
        <cfargument name='CUBAGEM' required='yes'>
        <cfargument name='PRODUTO_ID' required='yes'>
        <cfargument name='CONTROLADA' required='yes'>
        <cfargument name='EXIGE_NF' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_ins_tipo_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID' variable='retorno.TIPO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ABREVIATURA'  value='#arguments.ABREVIATURA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAPACIDADE'  value='#arguments.CAPACIDADE#'  null='#iif(len(trim(arguments.CAPACIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTURA'  value='#arguments.ALTURA#'  null='#iif(len(trim(arguments.ALTURA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COMPRIMENTO'  value='#arguments.COMPRIMENTO#'  null='#iif(len(trim(arguments.COMPRIMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LARGURA'  value='#arguments.LARGURA#'  null='#iif(len(trim(arguments.LARGURA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CUBAGEM'  value='#arguments.CUBAGEM#'  null='#iif(len(trim(arguments.CUBAGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLADA'  value='#arguments.CONTROLADA#'  null='#iif(len(trim(arguments.CONTROLADA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXIGE_NF'  value='#arguments.EXIGE_NF#'  null='#iif(len(trim(arguments.EXIGE_NF)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de embalagem inserido com sucesso.')>
            </cftransaction>
            
            <!--- Insero de Tipos de Embalagem --->
				<cfscript>
                    v_tipo_reforma_id = this.ListaToArray(lista = arguments, variavel = 'TIPO_REFORMA_ID_TIPO_REFORMA');
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_tipo_reforma_id)#" index="count">
                    <cfscript>
                        retorno = this.ins_tipo_reforma_embalagem(TIPO_REFORMA_ID	= v_tipo_reforma_id[count],
															      TIPO_EMBALAGEM_ID = retorno.TIPO_ID);
                    </cfscript>
                    <cfif retorno.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
            <!--- Insero de Laudos de Descarte --->
				<cfscript>
                    v_motivo_id = this.ListaToArray(lista = arguments, variavel = 'MOTIVO_ID_MOTIVO_DESCARTE');
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_motivo_id)#" index="count">
                    <cfscript>
                        retorno = this.ins_mot_descarte_embalagem(MOTIVO_ID	        = v_motivo_id[count],
															      TIPO_EMBALAGEM_ID = retorno.TIPO_ID);
                    </cfscript>
                    <cfif retorno.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um tipo de embalagem
    -- ANDERSONC 29/12/2009 11:08:12 - CRIADO
    --->
    <cffunction name='upd_tipo_embalagem' displayname='Altera um tipo de embalagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_ID' required='yes'>
        <cfargument name='GRUPO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='ABREVIATURA' required='yes'>
        <cfargument name='CAPACIDADE' required='yes'>
        <cfargument name='COD_UNIDADE' required='yes'>
        <cfargument name='ALTURA' required='yes'>
        <cfargument name='COMPRIMENTO' required='yes'>
        <cfargument name='LARGURA' required='yes'>
        <cfargument name='CUBAGEM' required='yes'>
        <cfargument name='PRODUTO_ID' required='yes'>
        <cfargument name='CONTROLADA' required='yes'>
        <cfargument name='EXIGE_NF' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_alt_tipo_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GRUPO_ID'  value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ABREVIATURA'  value='#arguments.ABREVIATURA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAPACIDADE'  value='#arguments.CAPACIDADE#'  null='#iif(len(trim(arguments.CAPACIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ALTURA'  value='#arguments.ALTURA#'  null='#iif(len(trim(arguments.ALTURA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COMPRIMENTO'  value='#arguments.COMPRIMENTO#'  null='#iif(len(trim(arguments.COMPRIMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LARGURA'  value='#arguments.LARGURA#'  null='#iif(len(trim(arguments.LARGURA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CUBAGEM'  value='#arguments.CUBAGEM#'  null='#iif(len(trim(arguments.CUBAGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTROLADA'  value='#arguments.CONTROLADA#'  null='#iif(len(trim(arguments.CONTROLADA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EXIGE_NF'  value='#arguments.EXIGE_NF#'  null='#iif(len(trim(arguments.EXIGE_NF)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                </cfstoredproc>
                
                <!--- Insero de Tipos de Embalagem --->
				<cfscript>
                    v_tipo_reforma_embalagem_id = this.ListaToArray(lista = arguments, variavel = 'TIPO_REFORMA_EMBALAGEM_ID_TIPO_REFORMA');
					v_tipo_reforma_id			= this.ListaToArray(lista = arguments, variavel = 'TIPO_REFORMA_ID_TIPO_REFORMA');
					v_excluir	        		= this.ListDiff(lista1 = lista_deleted_TIPO_REFORMA, lista2 = ArrayToList(v_tipo_reforma_embalagem_id));
                </cfscript>
                
                <cfloop list="#v_excluir#" delimiters="," index="c_id">
					<cfscript>
                        ret = this.del_tipo_reforma_embalagem(TIPO_REFORMA_EMBALAGEM_ID = c_id);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                    
                <cfloop from="1" to="#ArrayLen(v_tipo_reforma_embalagem_id)#" index="count">
                    <cfscript>
                        if(Not Len(Trim(v_tipo_reforma_embalagem_id[count]))) {
							retorno = this.ins_tipo_reforma_embalagem(TIPO_REFORMA_ID	= v_tipo_reforma_id[count],
																	  TIPO_EMBALAGEM_ID = arguments.TIPO_ID);
						}
						else{
							retorno = this.upd_tipo_reforma_embalagem(TIPO_REFORMA_EMBALAGEM_ID = v_tipo_reforma_embalagem_id[count],
																	  TIPO_REFORMA_ID			= v_tipo_reforma_id[count],
																	  TIPO_EMBALAGEM_ID			= arguments.TIPO_ID);
						}
                    </cfscript>
                    <cfif retorno.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
                <!--- Insero de Laudos de Descarte --->
				<cfscript>
                    v_mot_tipo_embalagem_id		= this.ListaToArray(lista = arguments, variavel = 'MOT_TIPO_EMBALAGEM_ID_MOTIVO_DESCARTE');
					v_motivo_id 				= this.ListaToArray(lista = arguments, variavel = 'MOTIVO_ID_MOTIVO_DESCARTE');
					v_excluir_laudo	        		= this.ListDiff(lista1 = lista_deleted_MOTIVO_DESCARTE, lista2 = ArrayToList(v_mot_tipo_embalagem_id));
                </cfscript>
                
                <cfloop list="#v_excluir_laudo#" delimiters="," index="c_id">
					<cfscript>
                        ret = this.del_mot_descarte_embalagem(MOT_TIPO_EMBALAGEM_ID = c_id);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfloop from="1" to="#ArrayLen(v_mot_tipo_embalagem_id)#" index="count">
                    <cfscript>
                        if(Not Len(Trim(v_mot_tipo_embalagem_id[count]))) {
							ret = this.ins_mot_descarte_embalagem(MOTIVO_ID	        = v_motivo_id[count],
															      TIPO_EMBALAGEM_ID = arguments.TIPO_ID);
						}
						else{
							ret = this.upd_mot_descarte_embalagem(MOT_TIPO_EMBALAGEM_ID = v_mot_tipo_embalagem_id[count],
																  MOTIVO_ID	            = v_motivo_id[count],
															      TIPO_EMBALAGEM_ID     = arguments.TIPO_ID);							
						}
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de embalagem alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um tipo de embalagem
    -- ANDERSONC 29/12/2009 11:08:53 - CRIADO
    --->
    <cffunction name='del_tipo_embalagem' displayname='Exclui um tipo de embalagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_del_tipo_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_ID'  value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de embalagem excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Vincular Tipo de Reforma ao Tipo de Embalagem
	-- RAFAEL 11/01/2010 15:17:30 - CRIADO
	--->
	<cffunction name='ins_tipo_reforma_embalagem' displayname='Vincular Tipo de Reforma ao Tipo de Embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_REFORMA_ID' required='yes'>
		<cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_embalagens.prc_ins_tipo_reforma_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_REFORMA_EMBALAGEM_ID' variable='retorno.TIPO_REFORMA_EMBALAGEM_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_REFORMA_ID'  value='#arguments.TIPO_REFORMA_ID#'  null='#iif(len(trim(arguments.TIPO_REFORMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de Embalagem vinculado com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
        <!--- 
	-- PROPSITO
	-- Alterar Vinculo de Tipo de Reforma ao Tipo de Embalagem
	-- RAFAEL 11/01/2010 15:19:58 - CRIADO
	--->
	<cffunction name='upd_tipo_reforma_embalagem' displayname='Alterar Vinculo de Tipo de Reforma ao Tipo de Embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_REFORMA_EMBALAGEM_ID' required='yes'>
		<cfargument name='TIPO_REFORMA_ID' required='yes'>
		<cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_embalagens.prc_alt_tipo_reforma_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_REFORMA_EMBALAGEM_ID'  value='#arguments.TIPO_REFORMA_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_REFORMA_EMBALAGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_REFORMA_ID'  value='#arguments.TIPO_REFORMA_ID#'  null='#iif(len(trim(arguments.TIPO_REFORMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vinculo alterado com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclur Vinculo de Tipo de Reforma ao Tipo de Embalagem
	-- RAFAEL 11/01/2010 15:21:08 - CRIADO
	--->
	<cffunction name='del_tipo_reforma_embalagem' displayname='ExclurVinculo de Tipo de Reforma ao Tipo de Embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_REFORMA_EMBALAGEM_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_embalagens.prc_del_tipo_reforma_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_REFORMA_EMBALAGEM_ID'  value='#arguments.TIPO_REFORMA_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_REFORMA_EMBALAGEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vinculo excludo com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere um fabricante
    -- ANDERSONC 29/12/2009 15:29:13 - CRIADO
    --->
    <cffunction name='ins_fabricante' displayname='Insere um fabricante' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='SITUACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_ins_fabricante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FABRICANTE_ID' variable='retorno.FABRICANTE_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO'  value='#arguments.SITUACAO#'  null='#iif(len(trim(arguments.SITUACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                
                <!--- Insero de Tipos de Embalagem --->
				<cfscript>
					v_tipo_embalagem_id = this.ListaToArray(lista = arguments, variavel = 'TIPO_EMBALAGEM_ID_TIPO_EMBALAGEM');
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_tipo_embalagem_id)#" index="count">
                    <cfscript>
                        ret = this.ins_embalagem_fabricante(TIPO_EMBALAGEM_ID = v_tipo_embalagem_id[count],
															FABRICANTE_ID	  = retorno.FABRICANTE_ID);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Fabricante inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um fabricante
    -- ANDERSONC 29/12/2009 15:29:48 - CRIADO
    --->
    <cffunction name='upd_fabricante' displayname='Altera um fabricante' access='remote' returntype='Struct' output='true'>
        <cfargument name='FABRICANTE_ID' required='yes'>
        <cfargument name='SITUACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_alt_fabricante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FABRICANTE_ID'  value='#arguments.FABRICANTE_ID#'  null='#iif(len(trim(arguments.FABRICANTE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO'  value='#arguments.SITUACAO#'  null='#iif(len(trim(arguments.SITUACAO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                
                <!--- Alterao de Tipos de Embalagem --->
				<cfscript>
                    v_emb_fabricante_id = this.ListaToArray(lista = arguments, variavel = 'EMB_FABRICANTE_ID_TIPO_EMBALAGEM');
					v_tipo_embalagem_id = this.ListaToArray(lista = arguments, variavel = 'TIPO_EMBALAGEM_ID_TIPO_EMBALAGEM');
                    v_excluir	        = this.ListDiff(lista1 = arguments.lista_deleted_TIPO_EMBALAGEM, lista2 = ArrayToList(v_emb_fabricante_id));
                </cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="c_id">
                    <cfscript>
                        ret = this.del_embalagem_fabricante(EMB_FABRICANTE_ID = c_id);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_emb_fabricante_id)#" index="count">
                    <cfscript>
                        if(Not Len(Trim(v_emb_fabricante_id[count]))) {
							ret = this.ins_embalagem_fabricante(TIPO_EMBALAGEM_ID = v_tipo_embalagem_id[count],
																FABRICANTE_ID	  = arguments.FABRICANTE_ID);
                        }
                        else {
							ret = this.upd_embalagem_fabricante(EMB_FABRICANTE_ID = v_emb_fabricante_id[count],
																TIPO_EMBALAGEM_ID = v_tipo_embalagem_id[count],
																FABRICANTE_ID	  = arguments.FABRICANTE_ID);
                        }
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Fabricante alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um fabricante
    -- ANDERSONC 29/12/2009 15:30:26 - CRIADO
    --->
    <cffunction name='del_fabricante' displayname='Exclui um fabricante' access='remote' returntype='Struct' output='true'>
        <cfargument name='FABRICANTE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_del_fabricante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FABRICANTE_ID'  value='#arguments.FABRICANTE_ID#'  null='#iif(len(trim(arguments.FABRICANTE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Fabricante excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere um tipo de embalagem a um fabricante
    -- ANDERSONC 29/12/2009 16:03:43 - CRIADO
    --->
    <cffunction name='ins_embalagem_fabricante' displayname='Insere um tipo de embalagem a um fabricante' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
        <cfargument name='FABRICANTE_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='embalagens.pkg_embalagens.prc_ins_embalagem_fabricante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMB_FABRICANTE_ID' variable='retorno.EMB_FABRICANTE_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FABRICANTE_ID'  value='#arguments.FABRICANTE_ID#'  null='#iif(len(trim(arguments.FABRICANTE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Tipo de embalagem inserido com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um tipo de embalagem de um fabricante
    -- ANDERSONC 29/12/2009 16:04:36 - CRIADO
    --->
    <cffunction name='upd_embalagem_fabricante' displayname='Altera um tipo de embalagem de um fabricante' access='remote' returntype='Struct' output='true'>
        <cfargument name='EMB_FABRICANTE_ID' required='yes'>
        <cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
        <cfargument name='FABRICANTE_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='embalagens.pkg_embalagens.prc_alt_embalagem_fabricante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMB_FABRICANTE_ID'  value='#arguments.EMB_FABRICANTE_ID#'  null='#iif(len(trim(arguments.EMB_FABRICANTE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FABRICANTE_ID'  value='#arguments.FABRICANTE_ID#'  null='#iif(len(trim(arguments.FABRICANTE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Tipo de embalagem alterado com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um tipo de embalagem de um fabricante
    -- ANDERSONC 29/12/2009 16:05:13 - CRIADO
    --->
    <cffunction name='del_embalagem_fabricante' displayname='Exclui um tipo de embalagem de um fabricante' access='remote' returntype='Struct' output='true'>
        <cfargument name='EMB_FABRICANTE_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='embalagens.pkg_embalagens.prc_del_embalagem_fabricante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMB_FABRICANTE_ID'  value='#arguments.EMB_FABRICANTE_ID#'  null='#iif(len(trim(arguments.EMB_FABRICANTE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Tipo de embalagem excludo com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um tipo de ponto de estoque
	-- RAFAEL 29/12/2009 18:29:53 - CRIADO
	--->
	<cffunction name='ins_ponto_estoque_tipo' displayname='Inserir Tipos de Ponto de Estoque' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='embalagens.pkg_embalagens.prc_ins_ponto_estoque_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PE_TIPO_ID' variable='retorno.PE_TIPO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
                
                <!--- Insero de Tipos de Movimentao --->
				<cfscript>
                    v_estoque_mov_tipo_id = this.ListaToArray(lista = arguments, variavel = 'TIPO_MOVIMENTACAO_TIPO_MOVIMENTACAO');					
				</cfscript>
                <cfloop from="1" to="#ArrayLen(v_estoque_mov_tipo_id)#" index="count">
                    <cfscript>						
						ret = this.ins_ponto_estoque_mov(PE_TIPO_ID 		 = retorno.PE_TIPO_ID,
														 ESTOQUE_MOV_TIPO_ID = v_estoque_mov_tipo_id[count]);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de ponto de estoque inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera um tipo de ponto de estoque
	-- RAFAEL 29/12/2009 18:33:24 - CRIADO
	--->
	<cffunction name='upd_ponto_estoque_tipo' displayname='Alterar Tipos de Ponto de Estoque' access='remote' returntype='Struct' output='true'>
		<cfargument name='PE_TIPO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='embalagens.pkg_embalagens.prc_alt_ponto_estoque_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PE_TIPO_ID'  value='#arguments.PE_TIPO_ID#'  null='#iif(len(trim(arguments.PE_TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
				</cfstoredproc>
                
                <!--- Alterao de Tipos de Movimentao --->
				<cfscript>
					v_pem_id 			  = this.ListaToArray(lista = arguments, variavel = 'PEM_ID_TIPO_MOVIMENTACAO');
                    v_estoque_mov_tipo_id = this.ListaToArray(lista = arguments, variavel = 'TIPO_MOVIMENTACAO_TIPO_MOVIMENTACAO');
					v_excluir	          = this.ListDiff(lista1 = arguments.lista_deleted_TIPO_MOVIMENTACAO, lista2 = ArrayToList(v_pem_id));
				</cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="c_id">
                    <cfscript>
                        ret = this.del_ponto_estoque_mov(PEM_ID = c_id);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_estoque_mov_tipo_id)#" index="count">
                    <cfscript>						
						if(Not Len(Trim(v_pem_id[count]))) {
							ret = this.ins_ponto_estoque_mov(PE_TIPO_ID 		 = arguments.PE_TIPO_ID,
														     ESTOQUE_MOV_TIPO_ID = v_estoque_mov_tipo_id[count]);
                        }
                        else {
							ret = this.upd_ponto_estoque_mov(PEM_ID		         = v_pem_id[count],
															 PE_TIPO_ID 		 = arguments.PE_TIPO_ID,
														     ESTOQUE_MOV_TIPO_ID = v_estoque_mov_tipo_id[count]);
                        }
                    </cfscript>
                   <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de ponto de estoque alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui um tipo de ponto de estoque
	-- RAFAEL 29/12/2009 18:32:10 - CRIADO
	--->
	<cffunction name='del_ponto_estoque_tipo' displayname='Excluir Tipos de Ponto de Estoque' access='remote' returntype='Struct' output='true'>
		<cfargument name='PE_TIPO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='embalagens.pkg_embalagens.prc_del_ponto_estoque_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PE_TIPO_ID'  value='#arguments.PE_TIPO_ID#'  null='#iif(len(trim(arguments.PE_TIPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de ponto de estoque excludo com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um tipo de movimentao a um ponto de estoque
	-- RAFAEL 30/12/2009 08:42:05 - CRIADO
	--->
	<cffunction name='ins_ponto_estoque_mov' displayname='Vincular Tipos de Movimentao a um Ponto de Estoque' access='remote' returntype='Struct' output='true'>
		<cfargument name='PE_TIPO_ID' required='yes'>
		<cfargument name='ESTOQUE_MOV_TIPO_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='embalagens.pkg_embalagens.prc_ins_ponto_estoque_mov' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PEM_ID' variable='retorno.PEM_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PE_TIPO_ID'  value='#arguments.PE_TIPO_ID#'  null='#iif(len(trim(arguments.PE_TIPO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ESTOQUE_MOV_TIPO_ID'  value='#arguments.ESTOQUE_MOV_TIPO_ID#'  null='#iif(len(trim(arguments.ESTOQUE_MOV_TIPO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Tipo de movimentao de estoque inserido com sucesso.')>
            <cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Altera um tipo de movimentao de um ponto de estoque
	-- RAFAEL 30/12/2009 08:43:08 - CRIADO
	--->
	<cffunction name='upd_ponto_estoque_mov' displayname='Vincular Tipos de Movimentao a um Ponto de Estoque' access='remote' returntype='Struct' output='true'>
		<cfargument name='PEM_ID' required='yes'>
		<cfargument name='PE_TIPO_ID' required='yes'>
		<cfargument name='ESTOQUE_MOV_TIPO_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='embalagens.pkg_embalagens.prc_alt_ponto_estoque_mov' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PEM_ID'  value='#arguments.PEM_ID#'  null='#iif(len(trim(arguments.PEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PE_TIPO_ID'  value='#arguments.PE_TIPO_ID#'  null='#iif(len(trim(arguments.PE_TIPO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ESTOQUE_MOV_TIPO_ID'  value='#arguments.ESTOQUE_MOV_TIPO_ID#'  null='#iif(len(trim(arguments.ESTOQUE_MOV_TIPO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Tipo de movimentao de estoque alterado com sucesso.')>
            <cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclui um tipo de movimentao de um ponto de estoque
	-- RAFAEL 30/12/2009 08:49:09 - CRIADO
	--->
	<cffunction name='del_ponto_estoque_mov' displayname='Vincular Tipos de Movimentao a um Ponto de Estoque' access='remote' returntype='Struct' output='true'>
		<cfargument name='PEM_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='embalagens.pkg_embalagens.prc_del_ponto_estoque_mov' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PEM_ID'  value='#arguments.PEM_ID#'  null='#iif(len(trim(arguments.PEM_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Tipo de movimentao de estoque excludo com sucesso.')>
            <cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir Pontos de Estoque
	-- RAFAEL 30/12/2009 13:41:02 - CRIADO
	--->
	<cffunction name='ins_ponto_estoque' displayname='Inserir Pontos de Estoque' access='remote' returntype='Struct' output='true'>
		<cfargument name='PE_TIPO_ID' required='yes'>
		<cfargument name='SITUACAO' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='embalagens.pkg_embalagens.prc_ins_ponto_estoque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PONTO_ESTOQUE_ID' variable='retorno.PONTO_ESTOQUE_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PE_TIPO_ID'  value='#arguments.PE_TIPO_ID#'  null='#iif(len(trim(arguments.PE_TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO'  value='#arguments.SITUACAO#'  null='#iif(len(trim(arguments.SITUACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ponto de Estoque inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Alterar Pontos de Estoque
	-- RAFAEL 30/12/2009 13:42:46 - CRIADO
	--->
	<cffunction name='upd_ponto_estoque' displayname='Alterar Pontos de Estoque' access='remote' returntype='Struct' output='true'>
		<cfargument name='PONTO_ESTOQUE_ID' required='yes'>
		<cfargument name='PE_TIPO_ID' required='yes'>
		<cfargument name='SITUACAO' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='embalagens.pkg_embalagens.prc_alt_ponto_estoque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PONTO_ESTOQUE_ID'  value='#arguments.PONTO_ESTOQUE_ID#'  null='#iif(len(trim(arguments.PONTO_ESTOQUE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PE_TIPO_ID'  value='#arguments.PE_TIPO_ID#'  null='#iif(len(trim(arguments.PE_TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO'  value='#arguments.SITUACAO#'  null='#iif(len(trim(arguments.SITUACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ponto de Estoque alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Exclur Pontos de Estoque
	-- RAFAEL 30/12/2009 13:43:30 - CRIADO
	--->
	<cffunction name='del_ponto_estoque' displayname='Exclur Pontos de Estoque' access='remote' returntype='Struct' output='true'>
		<cfargument name='PONTO_ESTOQUE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='embalagens.pkg_embalagens.prc_del_ponto_estoque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PONTO_ESTOQUE_ID'  value='#arguments.PONTO_ESTOQUE_ID#'  null='#iif(len(trim(arguments.PONTO_ESTOQUE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ponto de Estoque excludo com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere uma reformadora
    -- ANDERSONC 30/12/2009 11:57:22 - CRIADO
    --->
    <cffunction name='ins_reformadora' displayname='Insere uma reformadora' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='SITUACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_ins_reformadora' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFORMADORA_ID' variable='retorno.REFORMADORA_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO'  value='#arguments.SITUACAO#'  null='#iif(len(trim(arguments.SITUACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                
                <!--- Insero de Tipos de Embalagem --->
				<cfscript>
					v_tipo_embalagem_id = this.ListaToArray(lista = arguments, variavel = 'TIPO_EMBALAGEM_ID_TIPO_EMBALAGEM');
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_tipo_embalagem_id)#" index="count">
                    <cfscript>
                        ret = this.ins_embalagem_reformadora(TIPO_EMBALAGEM_ID = v_tipo_embalagem_id[count],
															 REFORMADORA_ID	   = retorno.REFORMADORA_ID);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Reformadora inserida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera uma reformadora
    -- ANDERSONC 30/12/2009 11:58:07 - CRIADO
    --->
    <cffunction name='upd_reformadora' displayname='Altera uma reformadora' access='remote' returntype='Struct' output='true'>
        <cfargument name='REFORMADORA_ID' required='yes'>
        <cfargument name='SITUACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_alt_reformadora' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFORMADORA_ID'  value='#arguments.REFORMADORA_ID#'  null='#iif(len(trim(arguments.REFORMADORA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SITUACAO'  value='#arguments.SITUACAO#'  null='#iif(len(trim(arguments.SITUACAO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                
                <!--- Alterao de Tipos de Embalagem --->
				<cfscript>
                    v_emb_reformadora_id = this.ListaToArray(lista = arguments, variavel = 'EMB_REFORMADORA_ID_TIPO_EMBALAGEM');
					v_tipo_embalagem_id  = this.ListaToArray(lista = arguments, variavel = 'TIPO_EMBALAGEM_ID_TIPO_EMBALAGEM');
                    v_excluir	         = this.ListDiff(lista1 = arguments.lista_deleted_TIPO_EMBALAGEM, lista2 = ArrayToList(v_emb_reformadora_id));
                </cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="c_id">
                    <cfscript>
                        ret = this.del_embalagem_reformadora(EMB_REFORMADORA_ID = c_id);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_emb_reformadora_id)#" index="count">
                    <cfscript>
                        if(Not Len(Trim(v_emb_reformadora_id[count]))) {
							ret = this.ins_embalagem_reformadora(TIPO_EMBALAGEM_ID = v_tipo_embalagem_id[count],
																 REFORMADORA_ID	   = arguments.REFORMADORA_ID);
                        }
                        else {
							ret = this.upd_embalagem_reformadora(EMB_REFORMADORA_ID = v_emb_reformadora_id[count],
																 TIPO_EMBALAGEM_ID  = v_tipo_embalagem_id[count],
																 REFORMADORA_ID	    = arguments.REFORMADORA_ID);
                        }
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Reformadora alterada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui uma reformadora
    -- ANDERSONC 30/12/2009 11:59:00 - CRIADO
    --->
    <cffunction name='del_reformadora' displayname='Exclui uma reformadora' access='remote' returntype='Struct' output='true'>
        <cfargument name='REFORMADORA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_del_reformadora' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFORMADORA_ID'  value='#arguments.REFORMADORA_ID#'  null='#iif(len(trim(arguments.REFORMADORA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Reformadora excluda com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere um tipo de embalagem a uma reformadora
    -- ANDERSONC 30/12/2009 16:57:43 - CRIADO
    --->
    <cffunction name='ins_embalagem_reformadora' displayname='Insere um tipo de embalagem a uma reformadora' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
        <cfargument name='REFORMADORA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='embalagens.pkg_embalagens.prc_ins_embalagem_reformadora' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMB_REFORMADORA_ID' variable='retorno.EMB_REFORMADORA_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFORMADORA_ID'  value='#arguments.REFORMADORA_ID#'  null='#iif(len(trim(arguments.REFORMADORA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Tipo de embalagem inserido com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um tipo de embalagem de uma reformadora
    -- ANDERSONC 30/12/2009 16:59:22 - CRIADO
    --->
    <cffunction name='upd_embalagem_reformadora' displayname='Altera um tipo de embalagem de uma reformadora' access='remote' returntype='Struct' output='true'>
        <cfargument name='EMB_REFORMADORA_ID' required='yes'>
        <cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
        <cfargument name='REFORMADORA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='embalagens.pkg_embalagens.prc_alt_embalagem_reformadora' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMB_REFORMADORA_ID'  value='#arguments.EMB_REFORMADORA_ID#'  null='#iif(len(trim(arguments.EMB_REFORMADORA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFORMADORA_ID'  value='#arguments.REFORMADORA_ID#'  null='#iif(len(trim(arguments.REFORMADORA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Tipo de embalagem alterado com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um tipo de embalagem de uma reformadora
    -- ANDERSONC 30/12/2009 17:00:04 - CRIADO
    --->
    <cffunction name='del_embalagem_reformadora' displayname='Exclui um tipo de embalagem de uma reformadora' access='remote' returntype='Struct' output='true'>
        <cfargument name='EMB_REFORMADORA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='embalagens.pkg_embalagens.prc_del_embalagem_reformadora' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMB_REFORMADORA_ID'  value='#arguments.EMB_REFORMADORA_ID#'  null='#iif(len(trim(arguments.EMB_REFORMADORA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Tipo de embalagem excludo com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	
	<!--- 
    -- PROPSITO
    -- Insere um tipo de reforma
    -- ANDERSONC 30/12/2009 15:05:14 - CRIADO
    --->
    <cffunction name='ins_tipo_reforma' displayname='Insere um tipo de reforma' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_ins_tipo_reforma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_REFORMA_ID' variable='retorno.TIPO_REFORMA_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de reforma inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um tipo de reforma
    -- ANDERSONC 30/12/2009 15:06:47 - CRIADO
    --->
    <cffunction name='upd_tipo_reforma' displayname='Altera um tipo de reforma' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_REFORMA_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_alt_tipo_reforma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_REFORMA_ID'  value='#arguments.TIPO_REFORMA_ID#'  null='#iif(len(trim(arguments.TIPO_REFORMA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de reforma alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um tipo de reforma
    -- ANDERSONC 30/12/2009 15:07:24 - CRIADO
    --->
    <cffunction name='del_tipo_reforma' displayname='Exclui um tipo de reforma' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_REFORMA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_del_tipo_reforma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_REFORMA_ID'  value='#arguments.TIPO_REFORMA_ID#'  null='#iif(len(trim(arguments.TIPO_REFORMA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de reforma excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere um motivo de descarte
    -- ANDERSONC 31/12/2009 09:50:34 - CRIADO
    --->
    <cffunction name='ins_motivo_descarte' displayname='Insere um motivo de descarte' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_ins_motivo_descarte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOTIVO_ID' variable='retorno.MOTIVO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#'  null='#iif(len(trim(arguments.DESCRICAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Motivo de descarte inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera um motivo de descarte
    -- ANDERSONC 31/12/2009 09:51:45 - CRIADO
    --->
    <cffunction name='upd_motivo_descarte' displayname='Altera um motivo de descarte' access='remote' returntype='Struct' output='true'>
        <cfargument name='MOTIVO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_alt_motivo_descarte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOTIVO_ID'  value='#arguments.MOTIVO_ID#'  null='#iif(len(trim(arguments.MOTIVO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#'  null='#iif(len(trim(arguments.DESCRICAO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Motivo de descarte alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui um motivo de descarte
    -- ANDERSONC 31/12/2009 09:52:19 - CRIADO
    --->
    <cffunction name='del_motivo_descarte' displayname='Exclui um motivo de descarte' access='remote' returntype='Struct' output='true'>
        <cfargument name='MOTIVO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='embalagens.pkg_embalagens.prc_del_motivo_descarte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOTIVO_ID'  value='#arguments.MOTIVO_ID#'  null='#iif(len(trim(arguments.MOTIVO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Motivo de descarte excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Vincular Motivo de Descarte a uma Embalagem
	-- RAFAEL 09/02/2010 15:37:09 - CRIADO
	--->
	<cffunction name='ins_mot_descarte_embalagem' displayname='Vincular Motivo de Descarte a uma Embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='MOTIVO_ID' required='yes'>
		<cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_embalagens.prc_ins_mot_descarte_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOT_TIPO_EMBALAGEM_ID' variable='retorno.MOT_TIPO_EMBALAGEM_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOTIVO_ID'  value='#arguments.MOTIVO_ID#'  null='#iif(len(trim(arguments.MOTIVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Alterar vinculo Motivo de Descarte a uma Embalagem
	-- RAFAEL 09/02/2010 15:38:08 - CRIADO
	--->
	<cffunction name='upd_mot_descarte_embalagem' displayname='Alterar vinculo Motivo de Descarte a uma Embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='MOT_TIPO_EMBALAGEM_ID' required='yes'>
		<cfargument name='MOTIVO_ID' required='yes'>
		<cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_embalagens.prc_alt_mot_descarte_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOT_TIPO_EMBALAGEM_ID'  value='#arguments.MOT_TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.MOT_TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOTIVO_ID'  value='#arguments.MOTIVO_ID#'  null='#iif(len(trim(arguments.MOTIVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Excluir vinculo de Motivo de Descarte a uma Embalagem
	-- RAFAEL 09/02/2010 15:38:49 - CRIADO
	--->
	<cffunction name='del_mot_descarte_embalagem' displayname='Excluir vinculo de Motivo de Descarte a uma Embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='MOT_TIPO_EMBALAGEM_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_embalagens.prc_del_mot_descarte_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOT_TIPO_EMBALAGEM_ID'  value='#arguments.MOT_TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.MOT_TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere Agrupamento de Movimentao
	-- RAFAEL 15/02/2010 09:08:17 - CRIADO
	--->
	<cffunction name='ins_movimentacao_agrup' displayname='Insere Agrupamento de Movimentao' access='remote' returntype='Struct' output='true'>
		<cfargument name='MOVIMENTACAO_TIPO_ID' required='yes'>
		<cfargument name='DATA_MOVIMENTACAO' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='PONTO_ESTOQUE_SAIDA_ID' required='yes'>
		<cfargument name='ESTOQUE_TIPO_SAIDA' required='yes'>
		<cfargument name='PONTO_ESTOQUE_ENTRADA_ID' required='yes'>
		<cfargument name='ESTOQUE_TIPO_ENTRADA' required='yes'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_movimentacao_agrup' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUPAMENTO_ID' variable='retorno.MOVIMENTACAO_AGRUPAMENTO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_TIPO_ID'  value='#arguments.MOVIMENTACAO_TIPO_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_MOVIMENTACAO'  value='#arguments.DATA_MOVIMENTACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PONTO_ESTOQUE_SAIDA_ID'  value='#arguments.PONTO_ESTOQUE_SAIDA_ID#'  null='#iif(len(trim(arguments.PONTO_ESTOQUE_SAIDA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ESTOQUE_TIPO_SAIDA'  value='#arguments.ESTOQUE_TIPO_SAIDA#'  null='#iif(len(trim(arguments.ESTOQUE_TIPO_SAIDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PONTO_ESTOQUE_ENTRADA_ID'  value='#arguments.PONTO_ESTOQUE_ENTRADA_ID#'  null='#iif(len(trim(arguments.PONTO_ESTOQUE_ENTRADA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ESTOQUE_TIPO_ENTRADA'  value='#arguments.ESTOQUE_TIPO_ENTRADA#'  null='#iif(len(trim(arguments.ESTOQUE_TIPO_ENTRADA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Insere um inventrio
	-- ANDERSONC 05/01/2010 16:17:17 - CRIADO
	--->
    <cffunction name='ins_inventario' displayname='Insere um inventrio' access='remote' returntype='Struct' output='true'>
        <cfargument name='DATA_MOVIMENTACAO' required='yes'>
        <cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
        <cfargument name='NUM_EMBALAGEM' required='yes'>
		<cfargument name='FABRICANTE_ID' required='no' default="">
		<cfargument name='POSSUI_REFORMA' required='no' default="">
		<cfargument name='PROPRIA' required='no' default="">
        <cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
		<cftry>
            <cftransaction action='begin'>
                <!---Insere agrupamento--->
                <cfscript>
						retorno = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 1,
															  DATA_MOVIMENTACAO        = arguments.DATA_MOVIMENTACAO ,
															  COD_CENTRO_CUSTO         = arguments.COD_CENTRO_CUSTO ,
															  PONTO_ESTOQUE_SAIDA_ID   = '' ,
															  ESTOQUE_TIPO_SAIDA       = '' ,
															  PONTO_ESTOQUE_ENTRADA_ID = arguments.PONTO_ESTOQUE_ID ,
															  ESTOQUE_TIPO_ENTRADA     = 1 ,
															  NUM_NOTA_ID              = '');
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
                <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_inventario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_MOVIMENTACAO'  value='#arguments.DATA_MOVIMENTACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_EMBALAGEM'  value='#arguments.NUM_EMBALAGEM#'  null='#iif(len(trim(arguments.NUM_EMBALAGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FABRICANTE_ID'  value='#arguments.FABRICANTE_ID#'  null='#iif(len(trim(arguments.FABRICANTE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_POSSUI_REFORMA'  value='#arguments.POSSUI_REFORMA#'  null='#iif(len(trim(arguments.POSSUI_REFORMA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROPRIA'  value='#arguments.PROPRIA#'  null='#iif(len(trim(arguments.PROPRIA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_PROPRIETARIO'  value='#arguments.COD_PESSOA_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#retorno.MOVIMENTACAO_AGRUPAMENTO_ID#'  null='#iif(len(trim(retorno.MOVIMENTACAO_AGRUPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                
                <!---Insere Contabilizao--->
                <cfscript>
						retorno = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID     = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Inventrio inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere uma aquisio
	-- RAFAEL 05/02/2010 16:30:12 - CRIADO
	--->
	<cffunction name='ins_aquisicao_private' displayname='Insere um inventrio' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
        <cfargument name='FABRICANTE_ID' required='yes'>
        <cfargument name='NUM_EMBALAGEM' required='yes'>
        <cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
        <cfargument name='PROPRIA' required='yes'>
        <cfargument name='POSSUI_REFORMA' required='yes'>
        <cfargument name='NUM_REFORMAS' required='yes'>
        <cfargument name='GARANTIA' required='yes'>
        <cfargument name='ANO_FABRICACAO' required='yes'>
        <cfargument name='NUM_NOTA_ID' required='yes'>
        <cfargument name='VALOR_BRUTO' required='yes'>
        <cfargument name='COD_MOEDA' required='yes'>
        <cfargument name='VALOR_UNITARIO' required='yes'>
        <cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
        <cfargument name='MOVIMENTACAO_AGRUP_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_aquisicao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBALAGEM_ID' variable='retorno.EMBALAGEM_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_FABRICANTE_ID'  value='#arguments.FABRICANTE_ID#'  null='#iif(len(trim(arguments.FABRICANTE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_EMBALAGEM'  value='#arguments.NUM_EMBALAGEM#'  null='#iif(len(trim(arguments.NUM_EMBALAGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_PROPRIETARIO'  value='#arguments.COD_PESSOA_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PESSOA_PROPRIETARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PROPRIA'  value='#arguments.PROPRIA#'  null='#iif(len(trim(arguments.PROPRIA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_POSSUI_REFORMA'  value='#arguments.POSSUI_REFORMA#'  null='#iif(len(trim(arguments.POSSUI_REFORMA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_REFORMAS'  value='#arguments.NUM_REFORMAS#'  null='#iif(len(trim(arguments.NUM_REFORMAS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_GARANTIA'  value='#arguments.GARANTIA#'  null='#iif(len(trim(arguments.GARANTIA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANO_FABRICACAO'  value='#arguments.ANO_FABRICACAO#'  null='#iif(len(trim(arguments.ANO_FABRICACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_BRUTO'  value='#arguments.VALOR_BRUTO#'  null='#iif(len(trim(arguments.VALOR_BRUTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_MOEDA'  value='#arguments.COD_MOEDA#'  null='#iif(len(trim(arguments.COD_MOEDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_UNITARIO'  value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FORNECEDOR'  value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#arguments.MOVIMENTACAO_AGRUP_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUP_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere uma aquisio
	-- RAFAEL 05/02/2010 16:30:12 - CRIADO
	--->
	<cffunction name='ins_aquisicao' displayname='Insere um inventrio' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
		<cfargument name='FABRICANTE_ID' required='yes'>
		<cfargument name='NUM_EMBALAGEM' required='yes'>
		<cfargument name='COD_PESSOA_PROPRIETARIO' required='yes'>
		<cfargument name='PROPRIA' required='yes'>
		<cfargument name='POSSUI_REFORMA' required='yes'>
		<cfargument name='NUM_REFORMAS' required='no' default="0">
		<cfargument name='GARANTIA' required='yes'>
		<cfargument name='ANO_FABRICACAO' required='yes'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='VALOR_BRUTO' required='yes'>
		<cfargument name='COD_MOEDA' required='yes'>
		<cfargument name='VALOR_UNITARIO' required='yes'>
		<cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
		<cfargument name='PONTO_ESTOQUE_ID' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cftry>
        	<cftransaction action='begin'>
				<!---Insere agrupamento--->
                <cfscript>
						retorno = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 3,
															  DATA_MOVIMENTACAO        = '#LSDateFormat(now())# #lsTimeFormat(now())#' ,
															  COD_CENTRO_CUSTO         = arguments.COD_CENTRO_CUSTO ,
															  PONTO_ESTOQUE_SAIDA_ID   = '' ,
															  ESTOQUE_TIPO_SAIDA       = '' ,
															  PONTO_ESTOQUE_ENTRADA_ID = arguments.PONTO_ESTOQUE_ID ,
															  ESTOQUE_TIPO_ENTRADA     = 1 ,
															  NUM_NOTA_ID              = arguments.NUM_NOTA_ID);
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
				<!---Insere Embalagem Controlada--->
                <cfif arguments.CONTROLADA eq 1>
                	<cfscript>
						v_num_embalagem		= this.ListaToArray(lista = arguments, variavel = 'NUM_EMBALAGEM_EMBALAGENS');
					</cfscript>
                    <cfloop from="1" to="#ArrayLen(v_num_embalagem)#" index="count">
                    	<cfscript>
                                retorno = this.ins_aquisicao_private(TIPO_EMBALAGEM_ID		 = arguments.TIPO_EMBALAGEM_ID,
											  					 	 FABRICANTE_ID			 = arguments.FABRICANTE_ID,
																 	 NUM_EMBALAGEM			 = v_num_embalagem[count],
																 	 COD_PESSOA_PROPRIETARIO = arguments.COD_PESSOA_PROPRIETARIO,
																 	 PROPRIA				 = arguments.PROPRIA,
																 	 POSSUI_REFORMA			 = arguments.POSSUI_REFORMA,
																 	 NUM_REFORMAS			 = arguments.NUM_REFORMAS,
																 	 GARANTIA				 = arguments.GARANTIA,
																 	 ANO_FABRICACAO			 = arguments.ANO_FABRICACAO,
																 	 NUM_NOTA_ID			 = arguments.NUM_NOTA_ID,
																 	 VALOR_BRUTO			 = arguments.VALOR_BRUTO,
																 	 COD_MOEDA				 = arguments.COD_MOEDA,
																 	 VALOR_UNITARIO			 = arguments.VALOR_UNITARIO,
																 	 COD_PESSOA_FORNECEDOR	 = arguments.COD_PESSOA_FORNECEDOR,
																 	 MOVIMENTACAO_AGRUP_ID	 = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
                        </cfscript>
                        <cfif retorno.erro>
                            <cfthrow object="#retorno.mensagem#">
                        </cfif>
                    </cfloop>
                <cfelse>
                	<cfscript>
							retorno = this.ins_aquisicao_private(TIPO_EMBALAGEM_ID		 = arguments.TIPO_EMBALAGEM_ID,
										 					 	 FABRICANTE_ID			 = arguments.FABRICANTE_ID,
															 	 NUM_EMBALAGEM			 = arguments.NUM_EMBALAGEM_NAO_CONTROLADA,
															 	 COD_PESSOA_PROPRIETARIO = arguments.COD_PESSOA_PROPRIETARIO,
															 	 PROPRIA				 = arguments.PROPRIA,
															 	 POSSUI_REFORMA			 = arguments.POSSUI_REFORMA,
															 	 NUM_REFORMAS			 = arguments.NUM_REFORMAS,
															 	 GARANTIA				 = arguments.GARANTIA,
															 	 ANO_FABRICACAO			 = arguments.ANO_FABRICACAO,
															 	 NUM_NOTA_ID			 = arguments.NUM_NOTA_ID,
															 	 VALOR_BRUTO			 = arguments.VALOR_BRUTO,
															 	 COD_MOEDA				 = arguments.COD_MOEDA,
															 	 VALOR_UNITARIO			 = arguments.VALOR_UNITARIO,
															 	 COD_PESSOA_FORNECEDOR	 = arguments.COD_PESSOA_FORNECEDOR,
																 MOVIMENTACAO_AGRUP_ID	 = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
					</cfscript>
                    <cfif retorno.erro>
						<cfthrow object="#retorno.mensagem#">
					</cfif>
                </cfif>
                
                <!---Insere Contabilizao--->
                <cfscript>
						retorno = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID     = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Aquisio inserida com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir Reforma de Embalagem
	-- RAFAEL 04/01/2010 16:04:47 - CRIADO
	--->
	<cffunction name='ins_embalagem_reforma' displayname='Inserir Reforma de Embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='EMBALAGEM_ID' required='yes'>
		<cfargument name='REFORMA_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='DATA_ENTRADA' required='yes'>
		<cfargument name='DATA_SAIDA' required='no' default="">
		<cfargument name='OBSERVACAO' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_embalagem_reforma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBALAGEM_REFORMA_ID' variable='retorno.EMBALAGEM_REFORMA_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBALAGEM_ID'  value='#arguments.EMBALAGEM_ID#'  null='#iif(len(trim(arguments.EMBALAGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFORMA_ID'  value='#arguments.REFORMA_ID#'  null='#iif(len(trim(arguments.REFORMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTRADA'  value='#arguments.DATA_ENTRADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_SAIDA'  value='#arguments.DATA_SAIDA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
					<cfset retorno.erro = false>
					<cfset retorno.mensagem = JSStringFormat('Reforma inserida com sucesso.')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Marcar Embalagem Reforma como executada
	-- RAFAEL 10/02/2010 17:03:55 - CRIADO
	--->
	<cffunction name='fecha_embalagem_reforma' displayname='Marcar Embalagem Reforma como executada' access='remote' returntype='Struct' output='true'>
		<cfargument name='EMBALAGEM_REFORMA_ID' required='yes'>
		<cfargument name='DATA_SAIDA' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_movimentacao.prc_fecha_embalagem_reforma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBALAGEM_REFORMA_ID'  value='#arguments.EMBALAGEM_REFORMA_ID#'  null='#iif(len(trim(arguments.EMBALAGEM_REFORMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_SAIDA'  value='#arguments.DATA_SAIDA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir Reforma de Embalagem
	-- RAFAEL 04/01/2010 16:12:30 - CRIADO
	--->
	<cffunction name='ins_reforma' displayname='Inserir Reforma de Embalagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
        <cfargument name='REFORMADORA_ID' required='yes'>
		<cftry>
            <cftransaction action='begin'>
                <cfscript>
					conn = CreateComponent("_transportes.consulta.transporte.cfc_embalagens");
					qrReformadora = conn.get_reformadora(reformadora_id = arguments.REFORMADORA_ID);
				</cfscript>
				
				<!---Insere agrupamento--->
                <cfscript>
						retorno = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 2,
															  DATA_MOVIMENTACAO        = '#LSDateFormat(now())# #lsTimeFormat(now())#' ,
															  COD_CENTRO_CUSTO         = arguments.COD_CENTRO_CUSTO ,
															  PONTO_ESTOQUE_SAIDA_ID   = arguments.PONTO_ESTOQUE_ID ,
															  ESTOQUE_TIPO_SAIDA       = 1 ,
															  PONTO_ESTOQUE_ENTRADA_ID = qrReformadora.PONTO_ESTOQUE_ID ,
															  ESTOQUE_TIPO_ENTRADA     = 3 ,
															  NUM_NOTA_ID              = '');
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
                <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_reforma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFORMA_ID' variable='retorno.REFORMA_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFORMADORA_ID'  value='#arguments.REFORMADORA_ID#'  null='#iif(len(trim(arguments.REFORMADORA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#retorno.MOVIMENTACAO_AGRUPAMENTO_ID#'  null='#iif(len(trim(retorno.MOVIMENTACAO_AGRUPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                    
                    <!--- Insero de Embalagem no controlada --->
                    <cfif arguments.CONTROLADA eq 0>
                        <cfscript>
                            ret = this.ins_embalagem_reforma(EMBALAGEM_ID 	= '',
                                                             REFORMA_ID		= retorno.REFORMA_ID,
                                                             QUANTIDADE		= arguments.QUANTIDADE,
                                                             DATA_ENTRADA	= arguments.DATA_ENTRADA,
                                                             DATA_SAIDA		= '',
                                                             OBSERVACAO		= arguments.OBSERVACAO);
                        </cfscript>
                        <cfif ret.erro>
                            <cfthrow object="#ret.mensagem#">
                        </cfif>
                    </cfif>
                    
                    <!--- Insero de Embalagens controladas --->
                    <cfif arguments.CONTROLADA eq 1>
                        <cfscript>
                            v_embalagem_id		= this.ListaToArray(lista = arguments, variavel = 'EMBALAGEM_ID_EMBALAGENS');
                            v_observacao		= this.ListaToArray(lista = arguments, variavel = 'OBSERVACAO_CONTROLADA_EMBALAGENS');
                        </cfscript>
                        
                        <cfloop from="1" to="#ArrayLen(v_embalagem_id)#" index="count">
                            <cfscript>
                                    ret = this.ins_embalagem_reforma(EMBALAGEM_ID 	= v_embalagem_id[count],
                                                                     REFORMA_ID		= retorno.REFORMA_ID,
                                                                     QUANTIDADE		= 1,
                                                                     DATA_ENTRADA	= arguments.DATA_ENTRADA,
                                                                     DATA_SAIDA		= '',
                                                                     OBSERVACAO		= v_observacao[count]);                            
                            </cfscript>
                            <cfif ret.erro>
                                <cfthrow object="#ret.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfif>
                    
                    <!---Insere Contabilizao--->
					<cfscript>
                            retorno = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID     = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
                    </cfscript>
                    <cfif retorno.erro>
                        <cfthrow object="#retorno.mensagem#">
                    </cfif>
                    
                <cfset retorno.erro = false>
    
                    <cfset retorno.mensagem = JSStringFormat('Reforma inserida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Excluir Reformas
	-- RAFAEL 07/01/2010 08:56:46 - CRIADO
	--->
	<cffunction name='del_reforma' displayname='Excluir Reformas' access='remote' returntype='Struct' output='true'>
		<cfargument name='REFORMA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='embalagens.pkg_movimentacao.prc_del_reforma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFORMA_ID'  value='#arguments.REFORMA_ID#'  null='#iif(len(trim(arguments.REFORMA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Reforma excluda com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir Retorno de Reforma
	-- RAFAEL 13/01/2010 15:43:32 - CRIADO
	--->
	<cffunction name='ins_retorno_reforma' displayname='Inserir Retorno de Reforma' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_RETORNO' required='yes'>
        <cfargument name='PONTO_ESTOQUE_ID' required='yes'>
        <cftry>
			<cftransaction action='begin'>
				<cfscript>
					conn = CreateComponent("_transportes.consulta.transporte.cfc_embalagens");
					qrReforma = conn.get_reforma(reforma_id = arguments.REFORMA_ID);
				</cfscript>
				
				<!---Insere agrupamento--->
                <cfscript>
						retorno = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 4,
															  DATA_MOVIMENTACAO        = '#LSDateFormat(now())# #lsTimeFormat(now())#' ,
															  COD_CENTRO_CUSTO         = qrReforma.COD_CENTRO_CUSTO ,
															  PONTO_ESTOQUE_SAIDA_ID   = qrReforma.PONTO_ESTOQUE_REFORMADORA,
															  ESTOQUE_TIPO_SAIDA       = 3,
															  PONTO_ESTOQUE_ENTRADA_ID = arguments.PONTO_ESTOQUE_ID,
															  ESTOQUE_TIPO_ENTRADA     = 1,
															  NUM_NOTA_ID              = '');
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
				<!---Criao das Variveis--->
                <cfscript>
                	v_emb_reforma_id  = this.ListaToArray(lista = arguments, variavel = 'EMBALAGEM_REFORMA_ID');
					v_quantidade      = this.ListaToArray(lista = arguments, variavel = 'QUANTIDADE');
					
					v_tipo_reforma_id = this.ListaToArray(lista = arguments, variavel = 'EMBALAGEM_REFORMA_TIPO_REFORMA_ID');
					v_valor = this.ListaToArray(lista = arguments, variavel = 'VALOR');
				</cfscript>
                
                <!---Insere Retorno de Reforma--->
                <cfloop from="1" to="#ArrayLen(v_emb_reforma_id)#" index="count">
					<cfscript>
                    	retorno = this.ins_retorno_reforma_private(EMBALAGEM_REFORMA_ID  = v_emb_reforma_id[count],
						    									   QUANTIDADE			 = v_quantidade[count],
																   DATA_RETORNO			 = arguments.DATA_RETORNO,
																   PONTO_ESTOQUE_ID		 = arguments.PONTO_ESTOQUE_ID,
																   MOVIMENTACAO_AGRUP_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);                            
                    </cfscript>
                    <cfif retorno.erro>
                        <cfthrow object="#retorno.mensagem#">
                    </cfif>
                    
                    <!---Insere Consertos--->
                    <cfloop from="1" to="#ArrayLen(v_tipo_reforma_id)#" index="count2">
                    	<cfif ListGetAt(v_tipo_reforma_id[count2],1,'_') eq v_emb_reforma_id[count]>
                        	<cfscript>
								retorno = this.ins_reforma_conserto(RETORNO_REFORMA_ID = retorno.RETORNO_REFORMA_ID,
																	TIPO_REFORMA_ID	   = ListGetAt(v_tipo_reforma_id[count2],2,'_'),
																	VALOR_CONSERTO     = v_valor[count2]);                            
							</cfscript>
							<cfif retorno.erro>
								<cfthrow object="#retorno.mensagem#">
							</cfif>
                        
                        
                        </cfif>                        
                    </cfloop>
                </cfloop>
                
                <!---Insere Contabilizao--->
                <cfscript>
						retorno = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID     = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Embalagem Reformada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Inserir Retorno de Reforma
	-- RAFAEL 13/01/2010 15:43:32 - CRIADO
	--->
	<cffunction name='ins_retorno_reforma_private' displayname='Inserir Retorno de Reforma' access='remote' returntype='Struct' output='true'>
		<cfargument name='EMBALAGEM_REFORMA_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='DATA_RETORNO' required='yes'>
        <cfargument name='PONTO_ESTOQUE_ID' required='yes'>
		<cfargument name='MOVIMENTACAO_AGRUP_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_retorno_reforma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RETORNO_REFORMA_ID' variable='retorno.RETORNO_REFORMA_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBALAGEM_REFORMA_ID'  value='#arguments.EMBALAGEM_REFORMA_ID#'  null='#iif(len(trim(arguments.EMBALAGEM_REFORMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_RETORNO'  value='#arguments.DATA_RETORNO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PONTO_ESTOQUE_ID'  value='#arguments.PONTO_ESTOQUE_ID#'  null='#iif(len(trim(arguments.PONTO_ESTOQUE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#arguments.MOVIMENTACAO_AGRUP_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUP_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Embalagem Refomnada com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere Conserto de uma Reforma
	-- RAFAEL 14/01/2010 17:00:13 - CRIADO
	--->
	<cffunction name='ins_reforma_conserto' displayname='Insere Conserto de uma Reforma' access='remote' returntype='Struct' output='true'>
		<cfargument name='RETORNO_REFORMA_ID' required='yes'>
		<cfargument name='TIPO_REFORMA_ID' required='yes'>
		<cfargument name='VALOR_CONSERTO' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_reforma_conserto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFORMA_CONSERTO_ID' variable='retorno.REFORMA_CONSERTO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RETORNO_REFORMA_ID'  value='#arguments.RETORNO_REFORMA_ID#'  null='#iif(len(trim(arguments.RETORNO_REFORMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_REFORMA_ID'  value='#arguments.TIPO_REFORMA_ID#'  null='#iif(len(trim(arguments.TIPO_REFORMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_CONSERTO'  value='#arguments.VALOR_CONSERTO#'  null='#iif(len(trim(arguments.VALOR_CONSERTO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conserto inserido com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir Descarte de Embalagem
	-- RAFAEL 08/02/2010 16:34:02 - CRIADO
	--->
	<cffunction name='ins_analise_descarte' displayname='Inserir Descarte de Embalagem' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
        <cfargument name='PONTO_ESTOQUE_SAIDA' required='yes'>
        <cfargument name='PONTO_ESTOQUE_ENTRADA' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <!---Insere agrupamento--->
                <cfscript>
						retorno = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 5,
															  DATA_MOVIMENTACAO        = '#LSDateFormat(now())# #lsTimeFormat(now())#' ,
															  COD_CENTRO_CUSTO         = arguments.COD_CENTRO_CUSTO ,
															  PONTO_ESTOQUE_SAIDA_ID   = arguments.PONTO_ESTOQUE_SAIDA ,
															  ESTOQUE_TIPO_SAIDA       = 1 ,
															  PONTO_ESTOQUE_ENTRADA_ID = arguments.PONTO_ESTOQUE_ENTRADA ,
															  ESTOQUE_TIPO_ENTRADA     = 4 ,
															  NUM_NOTA_ID              = '');
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
                <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_analise_descarte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANALISE_DESCARTE_ID' variable='retorno.ANALISE_DESCARTE_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#retorno.MOVIMENTACAO_AGRUPAMENTO_ID#'  null='#iif(len(trim(retorno.MOVIMENTACAO_AGRUPAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
			    
                    <!--- Insero de Embalagem no controlada --->
                    <cfif arguments.CONTROLADA eq 0>
                        <cfscript>
                            retorno = this.ins_embalagem_descarte(ANALISE_DESCARTE_ID = retorno.ANALISE_DESCARTE_ID,
                                                                  EMBALAGEM_ID		  = '',
                                                                  REFORMA_ID		  = arguments.REFORMA_ID,
                                                                  QUANTIDADE		  = arguments.QUANTIDADE,
                                                                  DATA_ENTRADA		  = arguments.DATA_ENTRADA,
                                                                  DATA_SAIDA		  = '',
                                                                  OBSERVACAO		  =  arguments.OBSERVACAO);						
                        </cfscript>
                        <cfif retorno.erro>
                            <cfthrow object="#retorno.mensagem#">
                        </cfif>
                        
                    <cfelse>
                    
                        <cfscript>
                            v_embalagem_id		= this.ListaToArray(lista = arguments, variavel = 'EMBALAGEM_ID_EMBALAGENS');
                            v_observacao		= this.ListaToArray(lista = arguments, variavel = 'OBSERVACAO_CONTROLADA_EMBALAGENS');
                        </cfscript>
                        
                        <cfloop from="1" to="#ArrayLen(v_embalagem_id)#" index="count">
                            <cfscript>
                                retorno = this.ins_embalagem_descarte(ANALISE_DESCARTE_ID = retorno.ANALISE_DESCARTE_ID,
                                                                      EMBALAGEM_ID		  = v_embalagem_id[count],
                                                                      REFORMA_ID		  = arguments.REFORMA_ID,
                                                                      QUANTIDADE		  = 1,
                                                                      DATA_ENTRADA		  = arguments.DATA_ENTRADA,
                                                                      DATA_SAIDA		  = '',
                                                                      OBSERVACAO		  = v_observacao[count]);
                            </cfscript>
                            <cfif retorno.erro>
                                <cfthrow object="#retorno.mensagem#">
                            </cfif>
                        </cfloop>
                       
                    </cfif>
                    
                    <!---Insere Contabilizao--->
					<cfscript>
                            retorno = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID     = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
                    </cfscript>
                    <cfif retorno.erro>
                        <cfthrow object="#retorno.mensagem#">
                    </cfif>
                    
                <cfset retorno.erro = false>
                    <cfset retorno.mensagem = JSStringFormat('Descarte inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir Descarte de Embalagem a partir da tela de Reforma
	-- RAFAEL 08/02/2010 16:34:02 - CRIADO
	--->
	<cffunction name='ins_analise_descarte_reforma' displayname='Inserir Descarte de Embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='REFORMA_ID' required='yes'>
		<cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
        <cfargument name='PONTO_ESTOQUE_ID' required='yes'>
        <cftry>
            <cfscript>
				conn = CreateComponent("_transportes.consulta.transporte.cfc_embalagens");
				qrReforma = conn.get_reforma(reforma_id = arguments.REFORMA_ID);
			</cfscript>
            
            <cftransaction action='begin'>
                <!---Insere agrupamento--->
                <cfscript>
						retorno = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 5,
															  DATA_MOVIMENTACAO        = '#LSDateFormat(now())# #lsTimeFormat(now())#' ,
															  COD_CENTRO_CUSTO         = qrReforma.COD_CENTRO_CUSTO ,
															  PONTO_ESTOQUE_SAIDA_ID   = qrReforma.PONTO_ESTOQUE_REFORMADORA ,
															  ESTOQUE_TIPO_SAIDA       = 3 ,
															  PONTO_ESTOQUE_ENTRADA_ID = arguments.PONTO_ESTOQUE_ID ,
															  ESTOQUE_TIPO_ENTRADA     = 4 ,
															  NUM_NOTA_ID              = '');
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
                <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_analise_descarte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANALISE_DESCARTE_ID' variable='retorno.ANALISE_DESCARTE_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#retorno.MOVIMENTACAO_AGRUPAMENTO_ID#'  null='#iif(len(trim(retorno.MOVIMENTACAO_AGRUPAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                             
                <cfscript>
                    v_emb_reforma_id  = this.ListaToArray(lista = arguments, variavel = 'EMBALAGEM_REFORMA_ID');
                    v_quantidade      = this.ListaToArray(lista = arguments, variavel = 'QUANTIDADE');
                    v_observacao      = this.ListaToArray(lista = arguments, variavel = 'OBSERVACAO');
					v_embalagem_id    = this.ListaToArray(lista = arguments, variavel = 'EMBALAGEM_ID');
                </cfscript>
                
                <cfloop from="1" to="#ArrayLen(v_emb_reforma_id)#" index="count">
                    <cfscript>
                        retorno = this.ins_embalagem_descarte(ANALISE_DESCARTE_ID = retorno.ANALISE_DESCARTE_ID,
                                                              EMBALAGEM_ID		  = v_embalagem_id[count],
                                                              REFORMA_ID		  = arguments.REFORMA_ID,
                                                              QUANTIDADE		  = v_quantidade[count],
                                                              DATA_ENTRADA		  = arguments.DATA_ENTRADA,
                                                              DATA_SAIDA		  = '',
                                                              OBSERVACAO		  = v_observacao[count]);
                    </cfscript>
                    <cfif retorno.erro>
                        <cfthrow object="#retorno.mensagem#">
                    </cfif>
                    
                    <!---Fecha a Embalagem Reforma--->
                    <cfscript>
                        retorno = this.fecha_embalagem_reforma(EMBALAGEM_REFORMA_ID = v_emb_reforma_id[count],
                                                               DATA_SAIDA		    = arguments.DATA_ENTRADA);
                    </cfscript>
                    <cfif retorno.erro>
                        <cfthrow object="#retorno.mensagem#">
                    </cfif>
                    
                </cfloop>
                
                <!---Insere Contabilizao--->
                <cfscript>
						retorno = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID     = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Descarte inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Excluir Descarte de Embalagem
	-- RAFAEL 08/02/2010 16:35:39 - CRIADO
	--->
	<cffunction name='del_analise_descarte' displayname='Excluir Descarte de Embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANALISE_DESCARTE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='embalagens.pkg_movimentacao.prc_del_analise_descarte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANALISE_DESCARTE_ID'  value='#arguments.ANALISE_DESCARTE_ID#'  null='#iif(len(trim(arguments.ANALISE_DESCARTE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Descarte excludo com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir Anlise de Descarte da Embalagem
	-- RAFAEL 08/02/2010 17:44:07 - CRIADO
	--->
	<cffunction name='ins_embalagem_descarte' displayname='Inserir Anlise de Descarte da Embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANALISE_DESCARTE_ID' required='yes'>
		<cfargument name='EMBALAGEM_ID' required='yes'>
		<cfargument name='REFORMA_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='DATA_ENTRADA' required='yes'>
		<cfargument name='DATA_SAIDA' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_embalagem_descarte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANALISE_EMBALAGEM_ID' variable='retorno.ANALISE_EMBALAGEM_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANALISE_DESCARTE_ID'  value='#arguments.ANALISE_DESCARTE_ID#'  null='#iif(len(trim(arguments.ANALISE_DESCARTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBALAGEM_ID'  value='#arguments.EMBALAGEM_ID#'  null='#iif(len(trim(arguments.EMBALAGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFORMA_ID'  value='#arguments.REFORMA_ID#'  null='#iif(len(trim(arguments.REFORMA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTRADA'  value='#arguments.DATA_ENTRADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_SAIDA'  value='#arguments.DATA_SAIDA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Fechar descarte da Embalagem
	-- RAFAEL 10/02/2010 19:34:58 - CRIADO
	--->
	<cffunction name='fecha_embalagem_descarte' displayname='Fechar descarte da Embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANALISE_EMBALAGEM_ID' required='yes'>
		<cfargument name='DATA_SAIDA' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_movimentacao.prc_fecha_embalagem_descarte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANALISE_EMBALAGEM_ID'  value='#arguments.ANALISE_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.ANALISE_EMBALAGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_SAIDA'  value='#arguments.DATA_SAIDA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir Retorno de Reforma
	-- RAFAEL 13/01/2010 15:43:32 - CRIADO
	--->
	<cffunction name='ins_descarte' displayname='Inserir Retorno de Reforma' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_RETORNO' required='yes'>
        
        <cfdump var="#arguments#">
        
        <cftry>
        	<cftransaction action='begin'>
            	<cfscript>
					conn = CreateComponent("_transportes.consulta.transporte.cfc_embalagens");
					qrDescarte = conn.get_descarte(analise_descarte_id = arguments.ANALISE_DESCARTE_ID);
				</cfscript>
                
                <!---Insere agrupamento--->
                <cfscript>
						retorno = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 6,
															  DATA_MOVIMENTACAO        = arguments.DATA_RETORNO ,
															  COD_CENTRO_CUSTO         = qrDescarte.COD_CENTRO_CUSTO ,
															  PONTO_ESTOQUE_SAIDA_ID   = qrDescarte.PONTO_ESTOQUE_ENTRADA_ID,
															  ESTOQUE_TIPO_SAIDA       = 4 ,
															  PONTO_ESTOQUE_ENTRADA_ID = '' ,
															  ESTOQUE_TIPO_ENTRADA     = '' ,
															  NUM_NOTA_ID              = '');
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
				<!---Criao das Variveis--->
                <cfscript>
                	v_analise_embalagem_id = this.ListaToArray(lista = arguments, variavel = 'ANALISE_EMBALAGEM_ID');
					v_quantidade           = this.ListaToArray(lista = arguments, variavel = 'QUANTIDADE');
					
					analise_embalagem_motivo_id = this.ListaToArray(lista = arguments, variavel = 'ANALISE_EMBALAGEM_MOTIVO_ID');					
				</cfscript>
                
                <!---Insere Descarte--->
                <cfloop from="1" to="#ArrayLen(v_analise_embalagem_id)#" index="count">
					<cfscript>
                    	retorno = this.ins_descarte_private(ANALISE_EMBALAGEM_ID  = v_analise_embalagem_id[count],
						    							    QUANTIDADE			  = v_quantidade[count],
															DATA_RETORNO		  = arguments.DATA_RETORNO,
															MOVIMENTACAO_AGRUP_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);                            
                    </cfscript>
                    <cfif retorno.erro>
                        <cfthrow object="#retorno.mensagem#">
                    </cfif>
                    
                    <!---Insere Laudos--->
                    <cfloop from="1" to="#ArrayLen(analise_embalagem_motivo_id)#" index="count2">
                    	<cfif ListGetAt(analise_embalagem_motivo_id[count2],1,'_') eq v_analise_embalagem_id[count]>
                        	<cfscript>
								retorno = this.ins_descarte_laudo(DESCARTE_ID = retorno.DESCARTE_ID,
																  MOTIVO_ID	  = ListGetAt(analise_embalagem_motivo_id[count2],2,'_'));                            
							</cfscript>
							<cfif retorno.erro>
								<cfthrow object="#retorno.mensagem#">
							</cfif>
                        
                        
                        </cfif>                        
                    </cfloop>
                </cfloop>
                
                <!---Insere Contabilizao--->
                <cfscript>
						retorno = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID     = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Embalagem Descartada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Efetua o Descarte de uma Embalagem
	-- RAFAEL 09/02/2010 20:31:01 - CRIADO
	--->
	<cffunction name='ins_descarte_private' displayname='Efetua o Descarte de uma Embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANALISE_EMBALAGEM_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='DATA_RETORNO' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_descarte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCARTE_ID' variable='retorno.DESCARTE_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANALISE_EMBALAGEM_ID'  value='#arguments.ANALISE_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.ANALISE_EMBALAGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_RETORNO'  value='#arguments.DATA_RETORNO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#retorno.MOVIMENTACAO_AGRUPAMENTO_ID#'  null='#iif(len(trim(retorno.MOVIMENTACAO_AGRUPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere os Laudos de um Descarte
	-- RAFAEL 09/02/2010 20:42:42 - CRIADO
	--->
	<cffunction name='ins_descarte_laudo' displayname='Insere os Laudos de um Descarte' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCARTE_ID' required='yes'>
		<cfargument name='MOTIVO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_descarte_laudo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCARTE_LAUDO_ID' variable='retorno.DESCARTE_LAUDO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESCARTE_ID'  value='#arguments.DESCARTE_ID#'  null='#iif(len(trim(arguments.DESCARTE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOTIVO_ID'  value='#arguments.MOTIVO_ID#'  null='#iif(len(trim(arguments.MOTIVO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retornar um equipamento oriundo de uma Anlise de Descarte
	-- RAFAEL 10/02/2010 18:59:42 - CRIADO
	--->
	<cffunction name='ins_retorno_estoque_private' displayname='Retornar um equipamento oriundo de uma Anlise de Descarte' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
        <cfargument name='EMBALAGEM_ID' required='yes'>
        <cfargument name='MOVIMENTACAO_AGRUP_ID' required='yes'>
        <cfargument name='ANALISE_DESCARTE_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_retorno_estoque' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBALAGEM_ID'  value='#arguments.EMBALAGEM_ID#'  null='#iif(len(trim(arguments.EMBALAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#arguments.MOVIMENTACAO_AGRUP_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUP_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ANALISE_DESCARTE_ID'  value='#arguments.ANALISE_DESCARTE_ID#'  null='#iif(len(trim(arguments.ANALISE_DESCARTE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retornar um equipamento oriundo de uma Anlise de Descarte
	-- RAFAEL 10/02/2010 18:59:42 - CRIADO
	--->
	<cffunction name='ins_retorno_estoque' displayname='Retornar um equipamento oriundo de uma Anlise de Descarte' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
		<cfargument name='PONTO_ESTOQUE_ENTRADA' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='ANALISE_DESCARTE_ID' required='yes'>
        <cftry>
        	<cfscript>
				conn = CreateComponent("_transportes.consulta.transporte.cfc_embalagens");
				qrDescarte = conn.get_descarte(analise_descarte_id = arguments.ANALISE_DESCARTE_ID);
			</cfscript>
            
            <cftransaction action='begin'>
				<!---Insere agrupamento--->
                <cfscript>
						retorno = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 9,
															  DATA_MOVIMENTACAO        = arguments.DATA_ENTRADA ,
															  COD_CENTRO_CUSTO         = qrDescarte.COD_CENTRO_CUSTO ,
															  PONTO_ESTOQUE_SAIDA_ID   = qrDescarte.PONTO_ESTOQUE_ID,
															  ESTOQUE_TIPO_SAIDA       = 4 ,
															  PONTO_ESTOQUE_ENTRADA_ID = arguments.PONTO_ESTOQUE_ENTRADA ,
															  ESTOQUE_TIPO_ENTRADA     = 1 ,
															  NUM_NOTA_ID              = '');
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
				
				<!---Criao das Variveis--->
                <cfscript>
                	v_analise_embalagem_id  = this.ListaToArray(lista = arguments, variavel = 'ANALISE_EMBALAGEM_ID');
					v_embalagem_id         = this.ListaToArray(lista = arguments, variavel = 'EMBALAGEM_ID');
					v_quantidade           = this.ListaToArray(lista = arguments, variavel = 'QUANTIDADE');
				</cfscript>
                
                <!---Insere Descarte--->
                <cfif arguments.CONTROLADA eq 0>
                    <cfloop from="1" to="#ArrayLen(v_analise_embalagem_id)#" index="count">
                        <cfscript>
                            retorno = this.ins_retorno_estoque_private(TIPO_EMBALAGEM_ID 	 = arguments.TIPO_EMBALAGEM_ID,
                                                                       EMBALAGEM_ID		 	 = v_quantidade[count],
                                                                       MOVIMENTACAO_AGRUP_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID,
																	   ANALISE_DESCARTE_ID	 = v_analise_embalagem_id[count]);
                        </cfscript>
                        <cfif retorno.erro>
                            <cfthrow object="#retorno.mensagem#">
                        </cfif>
                        
                        <!---Fecha a Embalagem Reforma--->
						<cfscript>
                            retorno = this.fecha_embalagem_descarte(ANALISE_EMBALAGEM_ID = v_analise_embalagem_id[count],
                                                                   DATA_SAIDA		     = arguments.DATA_ENTRADA);
                        </cfscript>
                        <cfif retorno.erro>
                            <cfthrow object="#retorno.mensagem#">
                        </cfif>
                        
                    </cfloop>
                 <cfelse>
                 	<cfloop from="1" to="#ArrayLen(v_analise_embalagem_id)#" index="count">
                        <cfscript>
                            retorno = this.ins_retorno_estoque_private(TIPO_EMBALAGEM_ID 	 = arguments.TIPO_EMBALAGEM_ID,
                                                                       EMBALAGEM_ID		 	 = v_embalagem_id[count],
                                                                       MOVIMENTACAO_AGRUP_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID,
																	   ANALISE_DESCARTE_ID	 = v_analise_embalagem_id[count]);
                        </cfscript>
                        <cfif retorno.erro>
                            <cfthrow object="#retorno.mensagem#">
                        </cfif>
                        
                        <!---Fecha a Embalagem Reforma--->
						<cfscript>
                            retorno = this.fecha_embalagem_descarte(ANALISE_EMBALAGEM_ID = v_analise_embalagem_id[count],
                                                                   DATA_SAIDA		     = arguments.DATA_ENTRADA);
                        </cfscript>
                        <cfif retorno.erro>
                            <cfthrow object="#retorno.mensagem#">
                        </cfif>
                        
                    </cfloop>
                 </cfif>
                 
                 <!---Insere Contabilizao--->
                <cfscript>
						retorno = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID     = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Equipamento retornado ao estoque com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir Transferncia
	-- RAFAEL 11/02/2010 17:55:15 - CRIADO
	--->
	<cffunction name='ins_transferencia' displayname='Inserir Transferncia' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
		<cfargument name='PONTO_ESTOQUE_SAIDA' required='yes'>
		<cfargument name='PONTO_ESTOQUE_ENTRADA' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='DATA_ENTRADA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<!---Insere agrupamento--->
                <cfscript>
						retorno = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 10,
															  DATA_MOVIMENTACAO        = arguments.DATA_ENTRADA ,
															  COD_CENTRO_CUSTO         = arguments.COD_CENTRO_CUSTO ,
															  PONTO_ESTOQUE_SAIDA_ID   = arguments.PONTO_ESTOQUE_SAIDA,
															  ESTOQUE_TIPO_SAIDA       = 1 ,
															  PONTO_ESTOQUE_ENTRADA_ID = arguments.PONTO_ESTOQUE_ENTRADA ,
															  ESTOQUE_TIPO_ENTRADA     = 2 ,
															  NUM_NOTA_ID              = '');
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
                <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_transferencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSFERENCIA_ID' variable='retorno.TRANSFERENCIA_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#retorno.MOVIMENTACAO_AGRUPAMENTO_ID#'  null='#iif(len(trim(retorno.MOVIMENTACAO_AGRUPAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
                
                <!---Criao das Variveis--->
                <cfscript>
                	v_embalagem_id = this.ListaToArray(lista = arguments, variavel = 'EMBALAGEM_ID_EMBALAGENS');
					v_observacao   = this.ListaToArray(lista = arguments, variavel = 'OBSERVACAO_CONTROLADA_EMBALAGENS');
				</cfscript>
                
                <!---Insere Descarte--->
                <cfif arguments.CONTROLADA eq 1>
                    <cfloop from="1" to="#ArrayLen(v_embalagem_id)#" index="count">
                        <cfscript>
                            retorno = this.ins_transf_embalagem(TRANSFERENCIA_ID = retorno.TRANSFERENCIA_ID,
																EMBALAGEM_ID     = v_embalagem_id[count],
																QUANTIDADE       = 1,
																DATA_ENTRADA     = arguments.DATA_ENTRADA,
																DATA_SAIDA       = '',
																OBSERVACAO       = v_observacao[count],
																MOVIMENTACAO_AGRUP_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
                        </cfscript>
                        <cfif retorno.erro>
                            <cfthrow object="#retorno.mensagem#">
                        </cfif>
                        
                        
                    </cfloop>
                <cfelse>
                 	    <cfscript>
                            retorno = this.ins_transf_embalagem(TRANSFERENCIA_ID = retorno.TRANSFERENCIA_ID,
																EMBALAGEM_ID     = '',
																QUANTIDADE       = arguments.QUANTIDADE,
																DATA_ENTRADA     = arguments.DATA_ENTRADA,
																DATA_SAIDA       = '',
																OBSERVACAO       = arguments.OBSERVACAO,
																MOVIMENTACAO_AGRUP_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
                        </cfscript>
                        <cfif retorno.erro>
                            <cfthrow object="#retorno.mensagem#">
                        </cfif>                    
                </cfif>
                
                <!---Insere Contabilizao--->
                <cfscript>
						retorno = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID     = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Transferncia inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir Embalagem Transferncia
	-- RAFAEL 11/02/2010 17:59:40 - CRIADO
	--->
	<cffunction name='ins_transf_embalagem' displayname='Inserir Embalagem Transferncia' access='remote' returntype='Struct' output='true'>
        <cfargument name='TRANSFERENCIA_ID' required='yes'>
        <cfargument name='EMBALAGEM_ID' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='DATA_ENTRADA' required='yes'>
        <cfargument name='DATA_SAIDA' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cfargument name='MOVIMENTACAO_AGRUP_ID' required='yes'>
        <cftry>
				<cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_transf_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSFERENCIA_EMBALAGEM_ID' variable='retorno.TRANSFERENCIA_EMBALAGEM_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSFERENCIA_ID'  value='#arguments.TRANSFERENCIA_ID#'  null='#iif(len(trim(arguments.TRANSFERENCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBALAGEM_ID'  value='#arguments.EMBALAGEM_ID#'  null='#iif(len(trim(arguments.EMBALAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTRADA'  value='#arguments.DATA_ENTRADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_SAIDA'  value='#arguments.DATA_SAIDA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#arguments.MOVIMENTACAO_AGRUP_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUP_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere confirmao de Transferncia
	-- RAFAEL 11/02/2010 21:57:42 - CRIADO
	--->
	<cffunction name='ins_transf_emb_confirma_private' displayname='Insere confirmao de Transferncia' access='remote' returntype='Struct' output='true'>
        <cfargument name='TRANSFERENCIA_EMBALAGEM_ID' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='DATA_RETORNO' required='yes'>
        <cfargument name='MOVIMENTACAO_AGRUP_ID' required='yes'>
		<cftry>
			<cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_transf_emb_confirmacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSF_EMB_CONFIRMACAO_ID' variable='retorno.TRANSF_EMB_CONFIRMACAO_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSFERENCIA_EMBALAGEM_ID'  value='#arguments.TRANSFERENCIA_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TRANSFERENCIA_EMBALAGEM_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_RETORNO'  value='#arguments.DATA_RETORNO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#arguments.MOVIMENTACAO_AGRUP_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUP_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere confirmao de Transferncia
	-- RAFAEL 11/02/2010 21:57:42 - CRIADO
	--->
	<cffunction name='ins_transf_emb_confirma' displayname='Insere confirmao de Transferncia' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_RETORNO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
            	<cfscript>
					conn = CreateComponent("_transportes.consulta.transporte.cfc_embalagens");
					qrMovimentacaoAgrup = conn.get_movimentacao_agrupamento(movimentacao_agrupamento_id = arguments.MOVIMENTACAO_AGRUP_ID);
				</cfscript>
				
				<!---Insere agrupamento--->
                <cfscript>
						retorno = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 11,
															  DATA_MOVIMENTACAO        = qrMovimentacaoAgrup.DATA_MOVIMENTACAO ,
															  COD_CENTRO_CUSTO         = qrMovimentacaoAgrup.COD_CENTRO_CUSTO ,
															  PONTO_ESTOQUE_SAIDA_ID   = qrMovimentacaoAgrup.PONTO_ESTOQUE_ENTRADA_ID,
															  ESTOQUE_TIPO_SAIDA       = 2 ,
															  PONTO_ESTOQUE_ENTRADA_ID = qrMovimentacaoAgrup.PONTO_ESTOQUE_ENTRADA_ID ,
															  ESTOQUE_TIPO_ENTRADA     = 1 ,
															  NUM_NOTA_ID              = '');
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
                <!---Criao das Variveis--->
                <cfscript>
                	v_transferencia_embalagem_id = this.ListaToArray(lista = arguments, variavel = 'TRANSFERENCIA_EMBALAGEM_ID');
					v_quantidade   				 = this.ListaToArray(lista = arguments, variavel = 'QUANTIDADE');
				</cfscript>
                
                <!---Insere Confirmao--->
                <cfloop from="1" to="#ArrayLen(v_transferencia_embalagem_id)#" index="count">
					<cfscript>
                    	retorno = this.ins_transf_emb_confirma_private(TRANSFERENCIA_EMBALAGEM_ID = v_transferencia_embalagem_id[count],
																	   QUANTIDADE                 = v_quantidade[count],
																	   DATA_RETORNO               = arguments.DATA_RETORNO,
																	   MOVIMENTACAO_AGRUP_ID 	  = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
                    </cfscript>
                    <cfif retorno.erro>
                    	<cfthrow object="#retorno.mensagem#">
                    </cfif>
                    
                </cfloop>
                
                <!---Insere Contabilizao--->
                <cfscript>
						retorno = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID     = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Transferncia confirmada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Rejeita Transferncia
	-- RAFAEL 12/02/2010 09:08:42 - CRIADO
	--->
	<cffunction name='ins_transf_emb_rejeita_private' displayname='Rejeita Transferncia' access='remote' returntype='Struct' output='true'>
		<cfargument name='TRANSFERENCIA_EMBALAGEM_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='DATA_RETORNO' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_transf_emb_rejeita' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSF_EMB_CONFIRMACAO_ID' variable='retorno.TRANSF_EMB_CONFIRMACAO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSFERENCIA_EMBALAGEM_ID'  value='#arguments.TRANSFERENCIA_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TRANSFERENCIA_EMBALAGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_RETORNO'  value='#arguments.DATA_RETORNO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#arguments.MOVIMENTACAO_AGRUP_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUP_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Rejeita Transferncia
	-- RAFAEL 12/02/2010 09:08:42 - CRIADO
	--->
	<cffunction name='ins_transf_emb_rejeita' displayname='Rejeita Transferncia' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_RETORNO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
            	<cfscript>
					conn = CreateComponent("_transportes.consulta.transporte.cfc_embalagens");
					qrMovimentacaoAgrup = conn.get_movimentacao_agrupamento(movimentacao_agrupamento_id = arguments.MOVIMENTACAO_AGRUP_ID);
				</cfscript>
				
				<!---Insere agrupamento--->
                <cfscript>
						retorno = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 12,
															  DATA_MOVIMENTACAO        = qrMovimentacaoAgrup.DATA_MOVIMENTACAO ,
															  COD_CENTRO_CUSTO         = qrMovimentacaoAgrup.COD_CENTRO_CUSTO ,
															  PONTO_ESTOQUE_SAIDA_ID   = qrMovimentacaoAgrup.PONTO_ESTOQUE_ENTRADA_ID,
															  ESTOQUE_TIPO_SAIDA       = 2 ,
															  PONTO_ESTOQUE_ENTRADA_ID = qrMovimentacaoAgrup.PONTO_ESTOQUE_SAIDA_ID,
															  ESTOQUE_TIPO_ENTRADA     = 1 ,
															  NUM_NOTA_ID              = '');
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
                <!---Criao das Variveis--->
                <cfscript>
                	v_transferencia_embalagem_id = this.ListaToArray(lista = arguments, variavel = 'TRANSFERENCIA_EMBALAGEM_ID');
					v_quantidade   				 = this.ListaToArray(lista = arguments, variavel = 'QUANTIDADE');
				</cfscript>
                
                <!---Insere Confirmao--->
                <cfloop from="1" to="#ArrayLen(v_transferencia_embalagem_id)#" index="count">
					<cfscript>
                    	retorno = this.ins_transf_emb_rejeita_private(TRANSFERENCIA_EMBALAGEM_ID = v_transferencia_embalagem_id[count],
																	  QUANTIDADE                 = v_quantidade[count],
																	  DATA_RETORNO               = arguments.DATA_RETORNO,
																	  MOVIMENTACAO_AGRUP_ID 	 = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
                    </cfscript>
                    <cfif retorno.erro>
                    	<cfthrow object="#retorno.mensagem#">
                    </cfif>
                    
                </cfloop>
                
                <!---Insere Contabilizao--->
                <cfscript>
						retorno = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID     = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Transferncia rejeitada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
    -- PROPSITO
    -- Movimentao de Embalagens sem Nota Fiscal
    -- ANDERSONC 12/02/2010 09:25:34 - CRIADO
    --->
    <cffunction name='ins_movimentacao_sem_nota_fiscal' displayname='Entrada de Embalagens sem Nota Fiscal' access='remote' returntype='Struct' output='true'>
    	<cfargument name='ENTRADA_SAIDA' required='yes'>
        <cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
        <cfargument name='NUM_EMBALAGEM' required='yes'>
        <cfargument name='PONTO_ESTOQUE_ENTRADA' required='yes'>
        <cfargument name='PONTO_ESTOQUE_SAIDA' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cftry>
        	<cftransaction action='begin'>
            	<!---Insere agrupamento--->
                <cfscript>
					retorno = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = arguments.MOVIMENTACAO_TIPO,
														  DATA_MOVIMENTACAO        = '#LSDateFormat(now())# #LSTimeFormat(now())#' ,
														  COD_CENTRO_CUSTO         = arguments.COD_CENTRO_CUSTO ,
														  PONTO_ESTOQUE_SAIDA_ID   = arguments.PONTO_ESTOQUE_SAIDA ,
														  ESTOQUE_TIPO_SAIDA       = arguments.MOVIMENTACAO_TIPO_SAIDA ,
														  PONTO_ESTOQUE_ENTRADA_ID = arguments.PONTO_ESTOQUE_ENTRADA ,
														  ESTOQUE_TIPO_ENTRADA     = arguments.MOVIMENTACAO_TIPO_ENTRADA ,
														  NUM_NOTA_ID              = '');
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
				
				<cfscript>
					conn = CreateComponent("_transportes.consulta.transporte.cfc_embalagens");
					qrTipoEmbalagem = conn.get_tipo_embalagem(tipo_id = arguments.TIPO_EMBALAGEM_ID);
				</cfscript>
            
                <!--- Entrada de Embalagens sem Nota Fiscal --->
            	<cfif arguments.ENTRADA_SAIDA eq 1>
                	<cfif qrTipoEmbalagem.CONTROLADA eq 1>
                    	<cfscript>
							v_num_embalagem = this.ListaToArray(lista = arguments, variavel = 'NUM_EMBALAGEM_EMBALAGEM_CONTROLADA');
						</cfscript>
						<cfloop from="1" to="#ArrayLen(v_num_embalagem)#" index="count">
							<cfscript>
								ret = this.ins_entrada_embalagem(TIPO_EMBALAGEM_ID     = arguments.TIPO_EMBALAGEM_ID,
																 NUM_EMBALAGEM         = v_num_embalagem[count],
																 MOVIMENTACAO_AGRUP_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
							</cfscript>
							<cfif ret.erro>
								<cfthrow object="#ret.mensagem#">
							</cfif>
						</cfloop>
                    <cfelse>
                    	<cfscript>
							ret = this.ins_entrada_embalagem(TIPO_EMBALAGEM_ID     = arguments.TIPO_EMBALAGEM_ID,
															 NUM_EMBALAGEM         = arguments.NUM_EMBALAGEM,
															 MOVIMENTACAO_AGRUP_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
						</cfscript>
						<cfif ret.erro>
							<cfthrow object="#ret.mensagem#">
						</cfif>
                    </cfif>
                <!--- Sada de Embalagens sem Nota Fiscal --->
                <cfelseif arguments.ENTRADA_SAIDA eq 2>
                	<!---Insere transferncia--->
					<cfscript>
                        ret_transf = this.ins_transferencia_cliente(TIPO_EMBALAGEM_ID 	  = arguments.TIPO_EMBALAGEM_ID,
                                                                    MOVIMENTACAO_AGRUP_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
                    </cfscript>
                    <cfif ret_transf.erro>
                        <cfthrow object="#ret_transf.mensagem#">
                    </cfif>
                    
                	<cfif qrTipoEmbalagem.CONTROLADA eq 1>
                    	<cfscript>
							v_embalagem_id  = this.ListaToArray(lista = arguments, variavel = 'EMBALAGEM_ID_EMBALAGEM_CONTROLADA');
							v_num_embalagem = this.ListaToArray(lista = arguments, variavel = 'NUM_EMBALAGEM_EMBALAGEM_CONTROLADA');
						</cfscript>
						<cfloop from="1" to="#ArrayLen(v_num_embalagem)#" index="count">
							<cfscript>
								ret = this.ins_transf_cliente_it(TRANSFERENCIA_ID = ret_transf.TRANSFERENCIA_ID,
																 EMBALAGEM_ID     = v_embalagem_id[count],
																 QUANTIDADE 	  = 1);
							</cfscript>
							<cfif ret.erro>
								<cfthrow object="#ret.mensagem#">
                    		</cfif>
						</cfloop>
                    <cfelse>
                    	<cfscript>
							ret = this.ins_transf_cliente_it(TRANSFERENCIA_ID = ret_transf.TRANSFERENCIA_ID,
															 EMBALAGEM_ID     = '',
															 QUANTIDADE 	  = arguments.NUM_EMBALAGEM);
						</cfscript>
						<cfif ret.erro>
							<cfthrow object="#ret.mensagem#">
						</cfif>
                	</cfif>
                    
                    <cfset ret.mensagem = JSStringFormat('Sada inserida com sucesso.')>
				</cfif>
				
				<!---Insere Contabilizao--->
                <cfscript>
					retorno = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
                </cfscript>
                <cfif retorno.erro>
                    <cfthrow object="#retorno.mensagem#">
                </cfif>
            	
            	<cfset retorno.erro = false>
                <cfset retorno.mensagem = ret.mensagem>
            </cftransaction>
            <cfcatch>
            	<cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	
	<!--- 
	-- PROPSITO
    -- Entrada de Embalagens sem Nota Fiscal
    -- ANDERSONC 12/02/2010 09:25:34 - CRIADO
	--->
    <cffunction name='ins_entrada_embalagem' displayname='Entrada de Embalagens sem Nota Fiscal' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
        <cfargument name='NUM_EMBALAGEM' required='yes'>
        <cfargument name='MOVIMENTACAO_AGRUP_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_entrada_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_EMBALAGEM'  value='#arguments.NUM_EMBALAGEM#'  null='#iif(len(trim(arguments.NUM_EMBALAGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#arguments.MOVIMENTACAO_AGRUP_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUP_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Entrada inserida com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Sada de Embalagens sem Nota Fiscal
    -- ANDERSONC 12/02/2010 09:27:20 - CRIADO
    --->
    <cffunction name='ins_saida_embalagem' displayname='Sada de Embalagens sem Nota Fiscal' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
        <cfargument name='NUM_EMBALAGEM' required='yes'>
		<cfargument name='MOVIMENTACAO_AGRUP_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_saida_embalagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_EMBALAGEM'  value='#arguments.NUM_EMBALAGEM#'  null='#iif(len(trim(arguments.NUM_EMBALAGEM)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#arguments.MOVIMENTACAO_AGRUP_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUP_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Sada inserida com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Inserir sada de Embalagem com NF
    -- RAFAEL 12/02/2010 20:48:49 - CRIADO
    --->
    <cffunction name='ins_saida_embalagem_nf' displayname='Inserir sada de Embalagem com NF' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
        <cfargument name='NUM_EMBALAGEM' required='yes'>
        <cfargument name='MOVIMENTACAO_AGRUP_ID' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cftry>
            <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_saida_embalagem_nf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_EMBALAGEM'  value='#arguments.NUM_EMBALAGEM#'  null='#iif(len(trim(arguments.NUM_EMBALAGEM)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#arguments.MOVIMENTACAO_AGRUP_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUP_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
				<cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir entrada de Embalagem com NF
	-- RAFAEL 12/02/2010 20:17:49 - CRIADO
	--->
	<cffunction name='ins_entrada_embalagem_nf' displayname='Inserir entrada de Embalagem com NF' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
        <cfargument name='NUM_EMBALAGEM' required='yes'>
        <cfargument name='MOVIMENTACAO_AGRUP_ID' required='yes'>
        <cfargument name='VALOR' required='yes'>
		<cftry>
			<cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_entrada_embalagem_nf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_EMBALAGEM'  value='#arguments.NUM_EMBALAGEM#'  null='#iif(len(trim(arguments.NUM_EMBALAGEM)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#arguments.MOVIMENTACAO_AGRUP_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUP_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Contabilizar as Movimentaes de Embalagens
	-- RAFAEL 23/03/2010 16:36:57 - CRIADO
	--->
	<cffunction name='prc_contabilizar' displayname='Contabilizar as Movimentaes de Embalagens' access='remote' returntype='Struct' output='true'>
		<cfargument name='MOVIMENTACAO_AGRUPAMENTO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_embalagem_contab.prc_contabilizar' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUPAMENTO_ID'  value='#arguments.MOVIMENTACAO_AGRUPAMENTO_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AGRUPAMENTO_ID' variable='retorno.AGRUPAMENTO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere uma transferncia para um cliente
	-- ANDERSONC 15/04/2010 09:40:55 - CRIADO
	--->
	<cffunction name='ins_transferencia_cliente' displayname='Insere uma transferncia para um cliente' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
		<cfargument name='MOVIMENTACAO_AGRUP_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_transferencia_cliente' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSFERENCIA_ID' variable='retorno.TRANSFERENCIA_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#arguments.MOVIMENTACAO_AGRUP_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUP_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um item para uma transferncia de um cliente
	-- ANDERSONC 15/04/2010 09:46:47 - CRIADO
	--->
	<cffunction name='ins_transf_cliente_it' displayname='Insere um item para uma transferncia de um cliente' access='remote' returntype='Struct' output='true'>
		<cfargument name='TRANSFERENCIA_ID' required='yes'>
		<cfargument name='EMBALAGEM_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='VALOR' required='no' default=''>
		<cftry>
            <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_transf_cliente_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSFERENCIA_CLIENTE_IT_ID' variable='retorno.TRANSFERENCIA_CLIENTE_IT_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSFERENCIA_ID'  value='#arguments.TRANSFERENCIA_ID#'  null='#iif(len(trim(arguments.TRANSFERENCIA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBALAGEM_ID'  value='#arguments.EMBALAGEM_ID#'  null='#iif(len(trim(arguments.EMBALAGEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Confirma o recebimento de uma(s) embalagem(ns)
	-- ANDERSONC 16/04/2010 11:04:54 - CRIADO
	--->
    <cffunction name='ins_transf_cliente_it_confirma' displayname='Confirma o recebimento de uma(s) embalagem(ns)' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_CONFIRMACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
            	<cfscript>
					conn = CreateComponent("_transportes.consulta.transporte.cfc_embalagens");
					qrMovimentacaoAgrup = conn.get_movimentacao_agrupamento(movimentacao_agrupamento_id = arguments.MOVIMENTACAO_AGRUP_ID);
				</cfscript>
				
				<!---Insere agrupamento--->
                <cfscript>
					retorno = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 15,
														  DATA_MOVIMENTACAO        = arguments.DATA_CONFIRMACAO,
														  COD_CENTRO_CUSTO         = qrMovimentacaoAgrup.COD_CENTRO_CUSTO,
														  PONTO_ESTOQUE_SAIDA_ID   = qrMovimentacaoAgrup.PONTO_ESTOQUE_ENTRADA_ID,
														  ESTOQUE_TIPO_SAIDA       = 2,
														  PONTO_ESTOQUE_ENTRADA_ID = qrMovimentacaoAgrup.PONTO_ESTOQUE_ENTRADA_ID,
														  ESTOQUE_TIPO_ENTRADA     = 6,
														  NUM_NOTA_ID              = qrMovimentacaoAgrup.NUM_NOTA_ID);
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
                <!---Criao das Variveis--->
                <cfscript>
                	v_transferencia_cliente_it_id = this.ListaToArray(lista = arguments, variavel = 'TRANSFERENCIA_CLIENTE_IT_ID');
					v_quantidade   				  = this.ListaToArray(lista = arguments, variavel = 'QUANTIDADE');
				</cfscript>
                
                <!---Insere Confirmao--->
                <cfloop from="1" to="#ArrayLen(v_transferencia_cliente_it_id)#" index="count">
					<cfscript>
                    	ret_transf = this.ins_transf_cliente_it_conf(TRANSFERENCIA_CLIENTE_IT_ID = v_transferencia_cliente_it_id[count],
																     QUANTIDADE                  = v_quantidade[count],
																     DATA_CONFIRMACAO            = arguments.DATA_CONFIRMACAO,
																     MOVIMENTACAO_AGRUP_ID 	  	 = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
                    </cfscript>
                    <cfif ret_transf.erro>
                    	<cfthrow object="#ret_transf.mensagem#">
                    </cfif>
                </cfloop>
                
                <!---Insere Contabilizao--->
                <cfscript>
					ret_contab = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
				</cfscript>
				<cfif ret_contab.erro>
					<cfthrow object="#ret_contab.mensagem#">
				</cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recebimento confirmado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Rejeita o recebimento de uma embalagem
	-- ANDERSONC 16/04/2010 11:04:54 - CRIADO
	--->
    <cffunction name='ins_transf_cliente_it_rejeita' displayname='Rejeita o recebimento de uma(s) embalagem(ns)' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_REJEICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
            	<cfscript>
					conn = CreateComponent("_transportes.consulta.transporte.cfc_embalagens");
					qrMovimentacaoAgrup = conn.get_movimentacao_agrupamento(movimentacao_agrupamento_id = arguments.MOVIMENTACAO_AGRUP_ID);
				</cfscript>
				
				<!---Insere agrupamento--->
                <cfscript>
					retorno = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 16,
														  DATA_MOVIMENTACAO        = arguments.DATA_REJEICAO,
														  COD_CENTRO_CUSTO         = qrMovimentacaoAgrup.COD_CENTRO_CUSTO,
														  PONTO_ESTOQUE_SAIDA_ID   = qrMovimentacaoAgrup.PONTO_ESTOQUE_ENTRADA_ID,
														  ESTOQUE_TIPO_SAIDA       = 2,
														  PONTO_ESTOQUE_ENTRADA_ID = qrMovimentacaoAgrup.PONTO_ESTOQUE_ENTRADA_ID,
														  ESTOQUE_TIPO_ENTRADA     = 2,
														  NUM_NOTA_ID              = qrMovimentacaoAgrup.NUM_NOTA_ID);
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
                <!---Criao das Variveis--->
                <cfscript>
                	v_transferencia_cliente_it_id = this.ListaToArray(lista = arguments, variavel = 'TRANSFERENCIA_CLIENTE_IT_ID');
					v_quantidade   				  = this.ListaToArray(lista = arguments, variavel = 'QUANTIDADE');
				</cfscript>
                
                <!---Insere Confirmao--->
                <cfloop from="1" to="#ArrayLen(v_transferencia_cliente_it_id)#" index="count">
					<cfscript>
                    	ret_transf = this.ins_transf_cliente_it_conf(TRANSFERENCIA_CLIENTE_IT_ID = v_transferencia_cliente_it_id[count],
																     QUANTIDADE                  = v_quantidade[count],
																     DATA_REJEICAO               = arguments.DATA_REJEICAO,
																     MOVIMENTACAO_AGRUP_ID 	 	 = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
                    </cfscript>
                    <cfif ret_transf.erro>
                    	<cfthrow object="#ret_transf.mensagem#">
                    </cfif>
                </cfloop>
                
                <!---Insere Contabilizao--->
                <cfscript>
					ret_contab = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
				</cfscript>
				<cfif ret_contab.erro>
					<cfthrow object="#ret_contab.mensagem#">
				</cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recebimento confirmado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Confirma o recebimento de uma embalagem
	-- ANDERSONC 16/04/2010 11:04:54 - CRIADO
	--->
	<cffunction name='ins_transf_cliente_it_conf' displayname='Confirma o recebimento de uma embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='TRANSFERENCIA_CLIENTE_IT_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='DATA_CONFIRMACAO' required='no' default=''>
		<cfargument name='DATA_REJEICAO' required='no' default=''>
		<cfargument name='MOVIMENTACAO_AGRUP_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_transf_cliente_it_conf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSF_CLIENTE_IT_CONF_ID' variable='retorno.TRANSF_CLIENTE_IT_CONF_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSFERENCIA_CLIENTE_IT_ID'  value='#arguments.TRANSFERENCIA_CLIENTE_IT_ID#'  null='#iif(len(trim(arguments.TRANSFERENCIA_CLIENTE_IT_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONFIRMACAO'  value='#arguments.DATA_CONFIRMACAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_REJEICAO'  value='#arguments.DATA_REJEICAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#arguments.MOVIMENTACAO_AGRUP_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUP_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Confirma o retorno de uma(s) embalagem(ns)
	-- ANDERSONC 18/04/2010 23:56:39 - CRIADO
	--->
    <cffunction name='ins_retorno_cliente_confirma' displayname='Confirma o retorno de uma(s) embalagem(ns)' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_RETORNO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
            	<!---Insere Confirmao--->
                <cfscript>
					ret_conf = this.ins_retorno_cliente_conf(DATA_RETORNO = arguments.DATA_RETORNO);
				</cfscript>
				<cfif ret_conf.erro>
					<cfthrow object="#ret_conf.mensagem#">
				</cfif>
                
                <!---Criao das Variveis--->
                <cfscript>
                	v_retorno_id 			= this.ListaToArray(lista = arguments, variavel = 'RETORNO_ID');
					v_quantidade 			= this.ListaToArray(lista = arguments, variavel = 'QUANTIDADE');
					v_movimentacao_agrup_id = this.ListaToArray(lista = arguments, variavel = 'MOVIMENTACAO_AGRUP_ID');
					
					v_agrupamentos = StructNew();
				</cfscript>
                
                <!---Insere Itens de Confirmao--->
                <cfloop from="1" to="#ArrayLen(v_retorno_id)#" index="count_ret">
                	<cfif StructKeyExists(v_agrupamentos, v_movimentacao_agrup_id[count_ret])>
                    	ret_agrup.MOVIMENTACAO_AGRUPAMENTO_ID = v_agrupamentos[v_movimentacao_agrup_id[count_ret]];
                    <cfelse>
                    	<cfscript>
							conn = CreateComponent("_transportes.consulta.transporte.cfc_embalagens");
							qrMovimentacaoAgrup = conn.get_movimentacao_agrupamento(movimentacao_agrupamento_id = v_movimentacao_agrup_id[count_ret]);
						</cfscript>
						
						<!---Insere agrupamento--->
						<cfscript>
							ret_agrup = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 17,
																	DATA_MOVIMENTACAO        = arguments.DATA_RETORNO,
																	COD_CENTRO_CUSTO         = qrMovimentacaoAgrup.COD_CENTRO_CUSTO,
																	PONTO_ESTOQUE_SAIDA_ID   = qrMovimentacaoAgrup.PONTO_ESTOQUE_ENTRADA_ID,
																	ESTOQUE_TIPO_SAIDA       = 6,
																	PONTO_ESTOQUE_ENTRADA_ID = qrMovimentacaoAgrup.PONTO_ESTOQUE_SAIDA_ID,
																	ESTOQUE_TIPO_ENTRADA     = 2,
																	NUM_NOTA_ID              = qrMovimentacaoAgrup.NUM_NOTA_ID);
							
							v_agrupamentos[v_movimentacao_agrup_id[count_ret]] = ret_agrup.MOVIMENTACAO_AGRUPAMENTO_ID;
						</cfscript>
						<cfif ret_agrup.erro>
							<cfthrow object="#ret_agrup.mensagem#">
						</cfif>
                    </cfif>
                    
                	<cfscript>
                    	ret_conf_it = this.ins_ret_cliente_conf_it(RETORNO_CLIENTE_CONF_ID = ret_conf.RETORNO_CLIENTE_CONF_ID,
																   RETORNO_ID			   = v_retorno_id[count_ret],
																   QUANTIDADE			   = v_quantidade[count_ret],
																   MOVIMENTACAO_AGRUP_ID   = ret_agrup.MOVIMENTACAO_AGRUPAMENTO_ID);
                    </cfscript>
                    <cfif ret_conf_it.erro>
                    	<cfthrow object="#ret_conf_it.mensagem#">
                    </cfif>
                </cfloop>
                
                <!---Insere Contabilizao--->
                <cfloop list="#StructKeyList(v_agrupamentos, ',')#" delimiters="," index="agrup">
					<cfscript>
                        ret_contab = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID = v_agrupamentos[agrup]);
                    </cfscript>
                    <cfif ret_contab.erro>
                        <cfthrow object="#ret_contab.mensagem#">
                    </cfif>
                </cfloop>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Retorno confirmado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Confirma o retorno de uma(s) embalagem(ns)
	-- ANDERSONC 18/04/2010 23:56:39 - CRIADO
	--->
	<cffunction name='ins_retorno_cliente_conf' displayname='Confirma o retorno de uma(s) embalagem(ns)' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_RETORNO' required='yes'>
		<cftry>
            <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_retorno_cliente_conf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RETORNO_CLIENTE_CONF_ID' variable='retorno.RETORNO_CLIENTE_CONF_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_RETORNO'  value='#arguments.DATA_RETORNO#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Confirma o retorno de uma embalagem
	-- ANDERSONC 18/04/2010 23:58:24 - CRIADO
	--->
	<cffunction name='ins_ret_cliente_conf_it' displayname='Confirma o retorno de uma embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='RETORNO_CLIENTE_CONF_ID' required='yes'>
		<cfargument name='RETORNO_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='MOVIMENTACAO_AGRUP_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_ret_cliente_conf_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RETORNO_CLIENTE_CONF_IT_ID' variable='retorno.RETORNO_CLIENTE_CONF_IT_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RETORNO_CLIENTE_CONF_ID'  value='#arguments.RETORNO_CLIENTE_CONF_ID#'  null='#iif(len(trim(arguments.RETORNO_CLIENTE_CONF_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RETORNO_ID'  value='#arguments.RETORNO_ID#'  null='#iif(len(trim(arguments.RETORNO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#arguments.MOVIMENTACAO_AGRUP_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUP_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere uma transferncia para estoque
	-- FABIOG 18/04/2011 11:14:44 - CRIADO
	--->
	<cffunction name='ins_transf_filial' displayname='Insere uma transferncia para estoque' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
		<cfargument name='MOVIMENTACAO_AGRUP_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_transf_filial' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSFERENCIA_FILIAL_ID' variable='retorno.TRANSFERENCIA_FILIAL_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#arguments.MOVIMENTACAO_AGRUP_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUP_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um item para uma transferncia para estoque.
	-- FABIOG 18/04/2011 11:16:30 - CRIADO
	--->
	<cffunction name='ins_transf_filial_it' displayname='Insere um item para uma transferncia para estoque.' access='remote' returntype='Struct' output='true'>
		<cfargument name='TRANSFERENCIA_FILIAL_ID' required='yes'>
		<cfargument name='EMBALAGEM_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cftry>
            <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_transf_filial_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSF_FILIAL_IT_ID' variable='retorno.TRANSF_FILIAL_IT_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRANSFERENCIA_FILIAL_ID'  value='#arguments.TRANSFERENCIA_FILIAL_ID#'  null='#iif(len(trim(arguments.TRANSFERENCIA_FILIAL_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMBALAGEM_ID'  value='#arguments.EMBALAGEM_ID#'  null='#iif(len(trim(arguments.EMBALAGEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR'  value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Confirma o recebimento de uma ou mais embalagens
	-- ANDERSONC 16/04/2010 11:04:54 - CRIADO
	--->
    <cffunction name='ins_transf_filial_it_conf' displayname='Confirma o recebimento de uma(s) embalagem(ns)' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_CONFIRMACAO' required='yes'>
        <cfargument name='CENTRO_CUSTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
            	<cfscript>
					conn = CreateComponent("_transportes.consulta.transporte.cfc_embalagens");
					qrMovimentacaoAgrup = conn.get_movimentacao_agrupamento(movimentacao_agrupamento_id = arguments.MOVIMENTACAO_AGRUP_ID);
				</cfscript>
				
				<!---Insere agrupamento--->
                <cfscript>
					retorno = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 15,
														  DATA_MOVIMENTACAO        = arguments.DATA_CONFIRMACAO,
														  COD_CENTRO_CUSTO         = qrMovimentacaoAgrup.COD_CENTRO_CUSTO,
														  PONTO_ESTOQUE_SAIDA_ID   = qrMovimentacaoAgrup.PONTO_ESTOQUE_ENTRADA_ID,
														  ESTOQUE_TIPO_SAIDA       = 2,
														  PONTO_ESTOQUE_ENTRADA_ID = qrMovimentacaoAgrup.PONTO_ESTOQUE_ENTRADA_ID,
														  ESTOQUE_TIPO_ENTRADA     = 6,
														  NUM_NOTA_ID              = qrMovimentacaoAgrup.NUM_NOTA_ID);
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
                <!---Criao das Variveis--->
                <cfscript>
                	v_transferencia_filial_it_id  = this.ListaToArray(lista = arguments, variavel = 'TRANSFERENCIA_FILIAL_IT_ID');
					v_quantidade   				  = this.ListaToArray(lista = arguments, variavel = 'QUANTIDADE');
				</cfscript>
                
                <!---Insere Confirmao--->
                <cfloop from="1" to="#ArrayLen(v_transferencia_filial_it_id)#" index="count">
					<cfscript>
                    	ret_transf = this.ins_transf_filial_it_conf(TRANSFERENCIA_FILIAL_IT_ID  = v_transferencia_filial_it_id[count],
																    QUANTIDADE                  = v_quantidade[count],
																    DATA_CONFIRMACAO            = arguments.DATA_CONFIRMACAO,
																    MOVIMENTACAO_AGRUP_ID 	  	= retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
                    </cfscript>
                    <cfif ret_transf.erro>
                    	<cfthrow object="#ret_transf.mensagem#">
                    </cfif>
                </cfloop>
                
                <!---Insere Contabilizao--->
                <cfscript>
					ret_contab = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
				</cfscript>
				<cfif ret_contab.erro>
					<cfthrow object="#ret_contab.mensagem#">
				</cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recebimento confirmado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Rejeita o recebimento de uma embalagem
	-- ANDERSONC 16/04/2010 11:04:54 - CRIADO
	--->
    <cffunction name='ins_transf_filial_it_rejeita' displayname='Rejeita o recebimento de uma(s) embalagem(ns)' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_REJEICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
            	<cfscript>
					conn = CreateComponent("_transportes.consulta.transporte.cfc_embalagens");
					qrMovimentacaoAgrup = conn.get_movimentacao_agrupamento(movimentacao_agrupamento_id = arguments.MOVIMENTACAO_AGRUP_ID);
				</cfscript>
				
				<!---Insere agrupamento--->
                <cfscript>
					retorno = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 16,
														  DATA_MOVIMENTACAO        = arguments.DATA_REJEICAO,
														  COD_CENTRO_CUSTO         = qrMovimentacaoAgrup.COD_CENTRO_CUSTO,
														  PONTO_ESTOQUE_SAIDA_ID   = qrMovimentacaoAgrup.PONTO_ESTOQUE_ENTRADA_ID,
														  ESTOQUE_TIPO_SAIDA       = 2,
														  PONTO_ESTOQUE_ENTRADA_ID = qrMovimentacaoAgrup.PONTO_ESTOQUE_ENTRADA_ID,
														  ESTOQUE_TIPO_ENTRADA     = 2,
														  NUM_NOTA_ID              = qrMovimentacaoAgrup.NUM_NOTA_ID);
				</cfscript>
				<cfif retorno.erro>
					<cfthrow object="#retorno.mensagem#">
				</cfif>
                
                <!---Criao das Variveis--->
                <cfscript>
                	v_transferencia_cliente_it_id = this.ListaToArray(lista = arguments, variavel = 'TRANSFERENCIA_FILIAL_IT_ID');
					v_quantidade   				  = this.ListaToArray(lista = arguments, variavel = 'QUANTIDADE');
				</cfscript>
                
                <!---Insere Confirmao--->
                <cfloop from="1" to="#ArrayLen(v_transferencia_cliente_it_id)#" index="count">
					<cfscript>
                    	ret_transf = this.ins_transf_cliente_it_conf(TRANSFERENCIA_CLIENTE_IT_ID = v_transferencia_cliente_it_id[count],
																     QUANTIDADE                  = v_quantidade[count],
																     DATA_REJEICAO               = arguments.DATA_REJEICAO,
																     MOVIMENTACAO_AGRUP_ID 	 	 = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
                    </cfscript>
                    <cfif ret_transf.erro>
                    	<cfthrow object="#ret_transf.mensagem#">
                    </cfif>
                </cfloop>
                
                <!---Insere Contabilizao--->
                <cfscript>
					ret_contab = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID = retorno.MOVIMENTACAO_AGRUPAMENTO_ID);
				</cfscript>
				<cfif ret_contab.erro>
					<cfthrow object="#ret_contab.mensagem#">
				</cfif>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recebimento confirmado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir reforma de embalagem
	-- FABIOG 26/04/2011 13:49:49 - CRIADO
	--->
	<cffunction name='ins_envio_reforma' displayname='Inserir reforma de embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_EMBALAGEM_ID' required='yes'>
		<cfargument name='REFORMADORA_ID' required='yes'>
		<cfargument name='MOVIMENTACAO_AGRUP_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_reforma' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFORMA_ID' variable='retorno.REFORMA_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_EMBALAGEM_ID'  value='#arguments.TIPO_EMBALAGEM_ID#'  null='#iif(len(trim(arguments.TIPO_EMBALAGEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REFORMADORA_ID'  value='#arguments.REFORMADORA_ID#'  null='#iif(len(trim(arguments.REFORMADORA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#arguments.MOVIMENTACAO_AGRUP_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUP_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Reforma inserida com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Confirma o retorno de embalagem(ns)
	-- FABIOG 04/05/2011 15:04:40 - CRIADO
	--->
	<cffunction name='ins_retorno_filial_conf' displayname='Confirma o retorno de embalagem(ns)' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_RETORNO' required='yes'>
		<cftry>
            <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_retorno_filial_conf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RETORNO_FILIAL_CONF_ID' variable='retorno.RETORNO_FILIAL_CONF_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_RETORNO'  value='#arguments.DATA_RETORNO#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Confirma o retorno de uma embalagem
	-- FABIOG 04/05/2011 15:07:01 - CRIADO
	--->
	<cffunction name='ins_ret_filial_conf_it' displayname='Confirma o retorno de uma embalagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='RETORNO_FILIAL_CONF_ID' required='yes'>
		<cfargument name='RETORNO_FILIAL_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='MOVIMENTACAO_AGRUP_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='embalagens.pkg_movimentacao.prc_ins_ret_filial_conf_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RETORNO_FILIAL_CONF_IT_ID' variable='retorno.RETORNO_FILIAL_CONF_IT_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RETORNO_FILIAL_CONF_ID'  value='#arguments.RETORNO_FILIAL_CONF_ID#'  null='#iif(len(trim(arguments.RETORNO_FILIAL_CONF_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_RETORNO_FILIAL_ID'  value='#arguments.RETORNO_FILIAL_ID#'  null='#iif(len(trim(arguments.RETORNO_FILIAL_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_QUANTIDADE'  value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOVIMENTACAO_AGRUP_ID'  value='#arguments.MOVIMENTACAO_AGRUP_ID#'  null='#iif(len(trim(arguments.MOVIMENTACAO_AGRUP_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
     <!--- 
	-- PROPSITO
	-- Confirma o retorno de uma(s) embalagem(ns)
	-- FABIOG 04/05/2011 15:01:32 - CRIADO
	--->
    <cffunction name='ins_retorno_filial_confirma' displayname='Confirma o retorno de uma(s) embalagem(ns)' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_CONFIRMACAO' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
            	<!---Insere Confirmao--->
                <cfscript>
					ret_conf = this.ins_retorno_filial_conf(DATA_RETORNO = arguments.DATA_CONFIRMACAO);
				</cfscript>
				<cfif ret_conf.erro>
					<cfthrow object="#ret_conf.mensagem#">
				</cfif>
                
                <!---Criao das Variveis--->
                <cfscript>
                	v_retorno_filial_id		= this.ListaToArray(lista = arguments, variavel = 'RETORNO_FILIAL_ID');
					v_quantidade 			= this.ListaToArray(lista = arguments, variavel = 'QUANTIDADE');
					v_movimentacao_agrup_id = this.ListaToArray(lista = arguments, variavel = 'MOVIMENTACAO_AGRUP_ID');
					
					v_agrupamentos = StructNew();
				</cfscript>
                
                <!---Insere Itens de Confirmao--->
                <cfloop from="1" to="#ArrayLen(v_retorno_filial_id)#" index="count_ret">
                	<cfif StructKeyExists(v_agrupamentos, v_movimentacao_agrup_id[count_ret])>
                    	ret_agrup.MOVIMENTACAO_AGRUPAMENTO_ID = v_agrupamentos[v_movimentacao_agrup_id[count_ret]];
                    <cfelse>
                    	<cfscript>
							conn = CreateComponent("_transportes.consulta.transporte.cfc_embalagens");
							qrMovimentacaoAgrup = conn.get_movimentacao_agrupamento(movimentacao_agrupamento_id = v_movimentacao_agrup_id[count_ret]);
						</cfscript>
						
						<!---Insere agrupamento--->
						<cfscript>
							ret_agrup = this.ins_movimentacao_agrup(MOVIMENTACAO_TIPO_ID     = 8,
																	DATA_MOVIMENTACAO        = arguments.DATA_CONFIRMACAO,
																	COD_CENTRO_CUSTO         = arguments.COD_CENTRO_CUSTO,
																	PONTO_ESTOQUE_SAIDA_ID   = qrMovimentacaoAgrup.PONTO_ESTOQUE_ENTRADA_ID,
																	ESTOQUE_TIPO_SAIDA       = 2,
																	PONTO_ESTOQUE_ENTRADA_ID = qrMovimentacaoAgrup.PONTO_ESTOQUE_ENTRADA_ID,
																	ESTOQUE_TIPO_ENTRADA     = 1,
																	NUM_NOTA_ID              = qrMovimentacaoAgrup.NUM_NOTA_ID);
							
							v_agrupamentos[v_movimentacao_agrup_id[count_ret]] = ret_agrup.MOVIMENTACAO_AGRUPAMENTO_ID;
						</cfscript>
						<cfif ret_agrup.erro>
							<cfthrow object="#ret_agrup.mensagem#">
						</cfif>
                    </cfif>
                    
                	<cfscript>
                    	ret_conf_it = this.ins_ret_filial_conf_it(RETORNO_FILIAL_CONF_ID = ret_conf.RETORNO_FILIAL_CONF_ID,
																  RETORNO_FILIAL_ID	     = v_retorno_filial_id[count_ret],
																  QUANTIDADE			 = v_quantidade[count_ret],
																  MOVIMENTACAO_AGRUP_ID  = ret_agrup.MOVIMENTACAO_AGRUPAMENTO_ID);
                    </cfscript>
                    <cfif ret_conf_it.erro>
                    	<cfthrow object="#ret_conf_it.mensagem#">
                    </cfif>
                </cfloop>
                
                <!---Insere Contabilizao--->
                <cfloop list="#StructKeyList(v_agrupamentos, ',')#" delimiters="," index="agrup">
					<cfscript>
                        ret_contab = this.prc_contabilizar(MOVIMENTACAO_AGRUPAMENTO_ID = v_agrupamentos[agrup]);
                    </cfscript>
                    <cfif ret_contab.erro>
                        <cfthrow object="#ret_contab.mensagem#">
                    </cfif>
                </cfloop>
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Retorno confirmado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>