<cfcomponent extends="_transportes.funcoes.cfc_init">
	
	<!--- 
    -- PROPSITO
    -- Insere ocorrencia vinculada a um carga
    -- guto 19/01/2009 17:20:01 - CRIADO
    --->
    <cffunction name='set_carga_ocorrencia' displayname='Insere ocorrencia vinculada a um carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='OCORRENCIA_ID' required='yes'>
        <cfargument name='CARGA_ID' required='yes'>
        <cfargument name='DATA' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
				<!--- Busca lista de ocorrencias --->
				<cfscript>
					v_carga_ocorrencia_id = this.ListaToArray (lista = arguments, variavel = "CARGA_OCORRENCIA_ID_OCORRENCIA");
					v_ocorrencia_id       = this.ListaToArray (lista = arguments, variavel = "OCORRENCIA_ID_OCORRENCIA");
					v_carga_id            = this.ListaToArray (lista = arguments, variavel = "CARGA_ID_OCORRENCIA");
					v_data                = this.ListaToArray (lista = arguments, variavel = "DATA_OCORRENCIA");
					v_observacao          = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO_OCORRENCIA");
					v_item_excluir        = this.ListDiff(lista1 = arguments.lista_deleted_OCORRENCIA, lista2 = ArrayToList(v_carga_ocorrencia_id));
				</cfscript>
				
                <cfloop list="#v_item_excluir#" index="i">
					<cfscript>
						set_manipulacao = this.del_carga_ocorrencia(carga_ocorrencia_id = i);
					</cfscript>
                    <cfif set_manipulacao.erro>
	                    <cfthrow object="#set_manipulacao.mensagem#">
                    </cfif>
                </cfloop>
                
				<cfloop from="1" to="#ArrayLen(v_ocorrencia_id)#" index="count">
                    <cfif not Len(Trim(v_carga_ocorrencia_id[count])) >
						<cfscript>
                            set_manipulacao = this.ins_carga_ocorrencia(OCORRENCIA_ID = v_ocorrencia_id[count]
																	   ,CARGA_ID = v_carga_id[count]
																	   ,DATA = v_data[count]
																	   ,OBSERVACAO = v_observacao[count]);
                        </cfscript>
                    <cfelse>    
						<cfscript>
                            set_manipulacao = this.upd_carga_ocorrencia(CARGA_OCORRENCIA_ID = v_carga_ocorrencia_id[count]
																	   ,OCORRENCIA_ID = v_ocorrencia_id[count]
																	   ,CARGA_ID = v_carga_id[count]
																	   ,DATA = v_data[count]
																	   ,OBSERVACAO = v_observacao[count]);
                        </cfscript>
                    </cfif>
                    <cfif set_manipulacao.erro>
	                    <cfthrow object="#set_manipulacao.mensagem#">
                    </cfif>
				</cfloop>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ocorrencias registradas com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	
	<!--- 
    -- PROPSITO
    -- Insere ocorrencia vinculada a um carga
    -- guto 19/01/2009 17:20:01 - CRIADO
    --->
    <cffunction name='ins_carga_ocorrencia' displayname='Insere ocorrencia vinculada a um carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='OCORRENCIA_ID' required='yes'>
        <cfargument name='CARGA_ID' required='yes'>
        <cfargument name='DATA' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_edi_proceda.prc_ins_carga_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_OCORRENCIA_ID' variable='retorno.CARGA_OCORRENCIA_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OCORRENCIA_ID'  value='#arguments.OCORRENCIA_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID'  value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ocorrencia inserida com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Altera ocorrencia vinculada a um carga
    -- guto 19/01/2009 17:21:38 - CRIADO
    --->
    <cffunction name='upd_carga_ocorrencia' displayname='Altera ocorrencia vinculada a um carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='CARGA_OCORRENCIA_ID' required='yes'>
        <cfargument name='OCORRENCIA_ID' required='yes'>
        <cfargument name='CARGA_ID' required='yes'>
        <cfargument name='DATA' required='yes'>
        <cfargument name='OBSERVACAO' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_edi_proceda.prc_alt_carga_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_OCORRENCIA_ID'  value='#arguments.CARGA_OCORRENCIA_ID#'  null='#iif(len(trim(arguments.CARGA_OCORRENCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OCORRENCIA_ID'  value='#arguments.OCORRENCIA_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_ID'  value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA'  value='#arguments.DATA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ocorrencia inserida com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Exclui ocorrencia vinculada a um carga
    -- guto 19/01/2009 17:22:12 - CRIADO
    --->
    <cffunction name='del_carga_ocorrencia' displayname='Exclui ocorrencia vinculada a um carga' access='remote' returntype='Struct' output='true'>
        <cfargument name='CARGA_OCORRENCIA_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_edi_proceda.prc_del_carga_ocorrencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARGA_OCORRENCIA_ID'  value='#arguments.CARGA_OCORRENCIA_ID#'  null='#iif(len(trim(arguments.CARGA_OCORRENCIA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ocorrencia inserida com sucesso!')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
</cfcomponent>