<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Vincula documentos exigidos para a quitaao
    -- guto 23/02/2009 10:31:24 - CRIADO
    --->
    <cffunction name='vincula_contrato_doctos' displayname='Vincula documentos exigidos para a quitaao' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_CONTRATO_CTF' required='yes'>
        <cfargument name='CODIGO_DOCTO' required='yes'>
        <cftry>
            <cfstoredproc procedure='ctffrete.pkg_ctffrete.prc_vincula_contrato_doctos' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CONTRATO_CTF'  value='#arguments.COD_CONTRATO_CTF#'  null='#iif(len(trim(arguments.COD_CONTRATO_CTF)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CODIGO_DOCTO'  value='#arguments.CODIGO_DOCTO#'  null='#iif(len(trim(arguments.CODIGO_DOCTO)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Doctos vinculados com sucesso!')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset retorno.mensagem_str = cfcatch.Detail>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Bloquear contrato
    -- guto 23/02/2009 10:31:24 - CRIADO
    --->
    <cffunction name='bloquear_contrato' displayname='Vincula documentos exigidos para a quitaao' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_CONTRATO_CTF' required='yes'>
        <cftry>
            <cfstoredproc procedure='ctffrete.pkg_ctffrete.prc_bloquear_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CONTRATO_CTF'  value='#arguments.COD_CONTRATO_CTF#'  null='#iif(len(trim(arguments.COD_CONTRATO_CTF)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Contrato bloqueado com sucesso!')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset retorno.mensagem_str = cfcatch.Detail>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Desbloquear contrato
    -- guto 23/02/2009 10:31:24 - CRIADO
    --->
    <cffunction name='desbloquear_contrato' displayname='Vincula documentos exigidos para a quitaao' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_CONTRATO_CTF' required='yes'>
        <cftry>
            <cfstoredproc procedure='ctffrete.pkg_ctffrete.prc_desbloquear_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CONTRATO_CTF'  value='#arguments.COD_CONTRATO_CTF#'  null='#iif(len(trim(arguments.COD_CONTRATO_CTF)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Contrato desbloqueado com sucesso!')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset retorno.mensagem_str = cfcatch.Detail>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Associar TAG CTF
    -- guto 23/02/2009 10:31:24 - CRIADO
    --->
    <cffunction name='associar_tag_ctf' displayname='Vincula documentos exigidos para a quitaao' access='remote' returntype='Struct' output='true'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='NUM_TAG_CTF' required='yes'>
        <cfargument name='SUBSTITUIR' required='yes'>
        <cftry>
            <cfstoredproc procedure='ctffrete.pkg_ctffrete.prc_associar_tag_veiculo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_TAG_CTF'  value='#arguments.NUM_TAG_CTF#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#'  >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSTITUIR'  value='N' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Tag vinculada com sucesso!')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset retorno.mensagem_str = cfcatch.Detail>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Busca os dados do contrato atualizados
	-- ANDERSONC 03/09/2009 09:11:21 - CRIADO
	--->
	<cffunction name='busca_dados_contrato' displayname='Busca os dados do contrato atualizados' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_CONTRATO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='ctffrete.pkg_ctffrete.prc_busca_dados_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTRATO'  value='#arguments.COD_CONTRATO#'  null='#iif(len(trim(arguments.COD_CONTRATO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Dados atualizados com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
		<!--- 
    -- PROPSITO
    -- Registra recebimento de Contratos de Transporte
    -- LEANDROR 31/05/2010 18:27:49 - CRIADO
    --->
    <cffunction name='reg_recebimento_contrato' displayname='Registra recebimento de Contrato de Transporte' access='remote' returntype='Struct' output='true'>
        <cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='COD_ORGANOGRAMA' required='yes'>
        <cfargument name='COD_CONTRATO_CTF' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='ctffrete.pkg_ctffrete.prc_reg_recebimento_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                	<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONTRATO_RECEBIMENTO_ID' variable='retorno.CONTRATO_RECEBIMENTO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_LANCTO_ID'  value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANOGRAMA'  value='#arguments.COD_ORGANOGRAMA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CONTRATO_CTF'  value='#arguments.COD_CONTRATO_CTF#'  null='#iif(len(trim(arguments.COD_CONTRATO_CTF)), de('no'), de('yes'))#'>
                    <cfprocparam type="out" cfsqltype="cf_sql_varchar" dbvarname="p_rowid" variable="retorno.rowid">
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Contrato recebido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
</cfcomponent>